var net = require('net');
var HOST = '127.0.0.1';
var PORT = 54321;
var client = new net.Socket();
var GS = require('./gamestate.js');
var gameState = new GS(client);

var iter = 0;

// Connect to server
client.connect(PORT, HOST);

// Emitted when connection is succesful
client.on('connect', function() {
    console.log('CONNECTED TO: ' + HOST + ':' + PORT);

    // Tell server that we want JSON
    client.write('JSON\n');

    // Tell server our name
    client.write('0.8004203809845802\n');
})

// Triggered when an error occurs in the connection
client.on('error', function(data) {
    console.log('ERROR: ' + data);
    client.destroy();
});

// Triggered each time the server sends us something
client.on('data', function(data) {
    // Start our little timer
    var hrstart = process.hrtime();

    // Log  a few lines for the sake of tidy
    for (var i = 0; i < 20; i++) {
        console.log('')
    };

    // Log some useful data
    iter++;
    console.log('--------Iteration : ' + iter + '------');

    // Splits data on \n
    var d = data.toString('utf-8').split('\n');

    // Removes last object in array, as it's an \n
    d.pop();

    // Start doing stuff
    gameState.Update(JSON.parse(d[0]));

    // Stop our timer and log something useful
    var hrend = process.hrtime(hrstart);
    console.info('Execution time: %ds %dms', hrend[0], hrend[1]/1000000);
    console.log('--------------------------------------\n');
});

// Triggered when connection closes
client.on('close', function(error) {
    client.destroy();
    if (error == true)
    {
        console.log('An error occured. Unexpected disconnect');
    } else {
        console.log('Disconnected.');
    }
});

