// RoadToSuccess.cpp : Defines the entry point for the console application.
//

#include <GL/glew.h>
#include <GLFW/glfw3.h>
#include "Demo.h"
#include <stdio.h>
#include <bass.h>

static void key(GLFWwindow *w, int key, int scancode, int action, int mode) {
	if (key == GLFW_KEY_ESCAPE && action == GLFW_PRESS) {
		glfwSetWindowShouldClose(w, GL_TRUE);
	}
}

int main(int argc, char **argv)
{
	GLFWwindow *window;
	GLFWmonitor *monitor;
	const GLFWvidmode *mode;
	QWORD bytepos;
	double time;

	glewExperimental = GL_TRUE;
	glfwInit();
	BASS_Init(-1, 48000, 0, 0, NULL);

	monitor = glfwGetPrimaryMonitor();
	mode    = glfwGetVideoMode(monitor);
	glfwWindowHint(GLFW_RED_BITS,     mode->redBits);
	glfwWindowHint(GLFW_BLUE_BITS,    mode->blueBits);
	glfwWindowHint(GLFW_GREEN_BITS,   mode->greenBits);
	glfwWindowHint(GLFW_REFRESH_RATE, mode->refreshRate);
	glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
	glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);

	window = glfwCreateWindow(mode->width, mode->height, "Road to success", monitor, NULL);

	if (window) {
		glfwSetInputMode(window, GLFW_CURSOR, GLFW_CURSOR_HIDDEN);
		glfwMakeContextCurrent(window);
		glfwSetKeyCallback(window, key);
		glewInit();
		cg::Demo *demo = new cg::Demo("", mode->width, mode->height);
		HSTREAM stream = BASS_StreamCreateFile(false, "data\\traveltoozora.mp3", 0, 0, 0);
		BASS_ChannelPlay(stream, false);
		while (!glfwWindowShouldClose(window)) {
			bytepos = BASS_ChannelGetPosition(stream, BASS_POS_BYTE);
			time = BASS_ChannelBytes2Seconds(stream, bytepos);
			if (time > 185.0) break;
			demo->update(time);
			glfwSwapBuffers(window);
			glfwPollEvents();
		}
		glfwSetInputMode(window, GLFW_CURSOR, GLFW_CURSOR_NORMAL);
		delete demo;
	}

	BASS_Free();
	glfwDestroyWindow(window);
	glfwTerminate();
	//printf("Press enter to quit\n"); //FIXME remove from final release
	//getc(stdin);
    return 0;
}

