#version 330

uniform float time;
out vec2 textcoord;
out vec4 colour;

void main(){
   float x = gl_VertexID / 8000.0 - 1.0;
   float y = sin((x / (sin(time)*0.2+1.0) + (time / 80.0)) * 200.0);
   if(x < 0.0 && y < 0.0){
      colour = vec4(0.702, 0.435, 0.690, 1.0);
   }
   else if(x < 0.0 && y > 0.0){
      colour = vec4(0.506, 0.725, 0.890, 1.0);
   }
   else if(x > 0.0 && y > 0.0){
      colour = vec4(1.0, 0.976, 0.561, 1.0);
   }
   else{
      colour = vec4(0.714, 0.902, 0.2, 1.0);
   }
   vec2 vertex = vec2(x,y);
   textcoord = vertex;
   gl_Position = vec4(vertex, 0.0, 1.0);
}