#version 330

in vec2 texcoord;

uniform sampler2D color;
uniform sampler2D bright;
uniform int height;
uniform float fadeperc;
uniform int kernelsize;
uniform float vignette;
uniform int avg;
uniform float zoom;

out vec4 FragColor;

const float weight[9] = float[9](0.132980760, 0.125794409, 0.106482669, 0.080656908, 0.054670025, 0.033159046, 0.017996989, 0.008740630, 0.003798662);
const vec4 black      = vec4(0.0, 0.0, 0.0, 1.0);
const float num[9]    = float[9](0.0, 3.0, 6.0, 9.0, 12.0, 15.0, 18.0, 21.0, 24.0);
const vec2 center     = vec2(0.5);

void main(){
   vec2 texcoord2 = texcoord * vec2(zoom) + vec2((1.0 - zoom) / 2.0);
   vec4 val = texture(color, texcoord2);
   float dy = 1.0 / float(height);
   if(avg == 1){
      float dx = dy / 1.7777777777;

      for(int i = -3; i < 3; i++){
         for(int j = -7; j < 7; j++){
            vec2 kcoord = vec2(float(i) * dx, float(j) * dy);
            val += texture(color, texcoord2 + kcoord);
         }
      }
      val = val / (3.0 * 14.0);
   }

   float d = distance(texcoord2, center) * vignette;

   vec4 sum = texture(bright, texcoord2) * weight[0];
   for(int i = 1; i < kernelsize; i++){
      sum += texture(bright, texcoord2 + vec2(0.0, num[i] * dy)) * weight[i];
      sum += texture(bright, texcoord2 - vec2(0.0, num[i] * dy)) * weight[i];
   }

   FragColor = mix(mix(val + sum, black, fadeperc), black, d);
}