#version 120

uniform sampler2D texture0;
uniform sampler2D texture1;
uniform float time = 1.0;
uniform float stage1 = 1;
uniform float stage2 = 2;
uniform float transition = 1.0;

float getTextureTransitionColor(vec2 coord, float stage)
{
	float percent = 0;
	float x = coord.x;
	float y = coord.y;
	if (stage == 1)
	{
		percent = sin(x*40)*sin(x*40);
	}
	else if (stage == 2)
	{
		percent = sin(y*cos(y*20)*x*20);
	}
	
	return percent;
}

void main()
{
	vec2 coord0=gl_TexCoord[0].xy;
	vec2 coord1=gl_TexCoord[0].xy;

	vec4 color = texture2D(texture0, coord0);
	if (color.r > 0.0)
	{
		float percent = getTextureTransitionColor(coord0, stage1)*(1-transition) + getTextureTransitionColor(coord0, stage2)*(transition);
		color = percent<0.5?texture2D(texture0, coord1):texture2D(texture1, coord1);
	}

	gl_FragColor = color;
}