/* Little starfield thingie */

var starInfo = {
	amount: 200,
	speed: 2,
	generated: false,
	stars: []
};

Star = function( dom )
{
	this.size = Math.random() * 3 + 0.2;
	this.mul = 0;
	this.ele = document.createElement( 'div' );
	this.ele.className = 'star';
	var deg = Math.random() * 180;
	this.directionx = Math.sin( deg ) - Math.cos( deg );
	this.directiony = -Math.cos( deg ) - Math.sin( deg );
	this.px = 0;
	this.py = 0;
	this.time = ( new Date() ).getTime() + ( Math.random() * 2200 );
	dom.appendChild( this.ele );
}

Starfield = function( dom )
{
	// Generate stars
	if( !starInfo.generated )
	{
		starInfo.generated = true;
		for( var a = 0; a < starInfo.amount; a++ )
		{
			var star = new Star( dom );
			starInfo.stars.push( star );
		}
		starInfo.time = ( new Date() ).getTime();
		return;
	}
}
Starfield.prototype.move = function()
{

	var phase = ( new Date() ).getTime();
	for( var a = 0; a < starInfo.amount; a++ )
	{
		// Calculate star
		var sinf = starInfo.stars[a];
		var timemul = ( phase - sinf.time ) / ( 30 / starInfo.speed );
		
		sinf.px = sinf.directionx * timemul;
		sinf.py = sinf.directiony * timemul;
		
		var distort = Math.pow( timemul / 170, 2 );
		
		sinf.py *= distort;
		sinf.px *= distort;
		
		var star = starInfo.stars[a].ele;
		star.style.width = Math.floor( 4 * distort ) + 'px';
		star.style.height = Math.floor( 4 * distort ) + 'px';
		star.style.opacity = distort;
		star.style.borderRadius = star.style.width;
		
		// Out of screen, make new star
		if( timemul > 170 )
		{
			sinf.time = ( new Date() ).getTime();
			var deg = Math.random() * 180;
			sinf.directionx = Math.sin( deg ) - Math.cos( deg );
			sinf.directiony = -Math.cos( deg ) - Math.sin( deg );
		}
		
		// Place the star
		star.style.left = Math.floor( sinf.px + 160 ) + 'px';
		star.style.top = Math.floor( sinf.py + 120 ) + 'px';
	}
}

