varying vec2 texcoord;
uniform vec2 noiseoffset;
uniform sampler2D tex0;
uniform float noisepower;


float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(void)
{
	float tu = mod(texcoord.x + noiseoffset.x, 1.0);
	float tv = mod(texcoord.y + noiseoffset.y, 1.0);

	float r = rand(vec2(tu, tv));
	vec4 texel = vec4(1, 1, 1, r * noisepower);
	
	gl_FragColor = texel; 
}