var Treecubes = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.scene.add(this.pointLight);
    
    this.createCube();
};


Treecubes.prototype = PartBase.prototype.inheritance();

Treecubes.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(3);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 4);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
    
    this.dof = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 2,
        aperture: 0.005
    });
    this.dof.renderToScreen = true;
    TDEMO.composer.addPass(this.dof);
    TDEMO.copyPass.enabled = false;
};

Treecubes.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false;
   this.dof.enabled = false;
   TDEMO.copyPass.enabled = true;
};

Treecubes.prototype.animateBox = function(rot) {
  var tcrot = SYNC.getObjRotation();
  var tcpos = SYNC.getObjPosition();

  this.box.rotation.x = tcrot.x;
  this.box.rotation.y = tcrot.y;
  this.box.rotation.z = tcrot.z;

  this.box.position.x = tcpos.x;
  this.box.position.y = tcpos.y;
  this.box.position.z = tcpos.z;

};

Treecubes.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.pointLight.position.set(this.camera.position.clone());
  var rot = delta/8;
  
  this.animateBox(rot);
};


Treecubes.prototype.createCube = function() {
    this.box = puukuutio(60, 60, 60, puu, 1, 1);
    this.scene.add(this.box);
    this.box.position.z = 30;
};


