
var Demo = function() {
	this.loader = new Loader();
	this.player = new Player();
}

var fboImage;

Demo.prototype.init = function()
{
var tick =((60/79)/4);
var totalDuration=80;

this.loader.addAnimation ([
{
"start": "0:00", "duration": "533"
,"layer": "00000"
,"fbo":{"name":"fbo","action":"begin"}
},
{
"start": "0:00", "duration": "533"
,"layer": "00010","fbo":{"name":"fbo","action":"unbind"}
}
])

	this.loader.addAnimation([
    {
         "start": 0, "duration":30
        ,"layer": "00001", "image": ["data/usa_flag.png","data/hard_noise.png"]
		
	     ,"shader":{
	            "name":"Distortion",
	            "variable":[
	                  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
	                 ,{"name":"noiseTexture","type":"int","value":[1]}
	                 ,{"name":"distortionResolutionX","value":[7.8]}
	                 ,{"name":"distortionResolutionY","value":[7.3]}
	                 ,{"name":"distortionX","value":[0.02]}
	                 ,{"name":"distortionY","value":[0.02]}
	                 ,{"name":"distortionSpeed","value":[2.0]}
	                 ,{"name":"shakeSizeY","value":[0.005]}
	                 ,{"name":"glitchSize","value":[0.001]}
	                 ,{"name":"noiseAlpha","value":[0.0]}
	            ]
	        }
	    }
	]);
	
	this.loader.addAnimation([
    {
         "start": 0, "duration":533
        ,"layer": "00001", "image": ["data/usa_flag2.png","data/hard_noise.png"]
		,"color": [{"a":0}, {"start":22,"duration":7,"a":255}]
	     ,"shader":{
	            "name":"Distortion",
	            "variable":[
	                  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
	                 ,{"name":"noiseTexture","type":"int","value":[1]}
	                 ,{"name":"distortionResolutionX","value":[7.8]}
	                 ,{"name":"distortionResolutionY","value":[7.3]}
	                 ,{"name":"distortionX","value":[0.02]}
	                 ,{"name":"distortionY","value":[0.02]}
	                 ,{"name":"distortionSpeed","value":[2.0]}
	                 ,{"name":"shakeSizeY","value":[0.005]}
	                 ,{"name":"glitchSize","value":[0.001]}
	                 ,{"name":"noiseAlpha","value":[0.0]}
	            ]
	        }
	    }
	]);

this.loader.addAnimation([{
		 "start": 0.0, "duration": 800
		,"layer": "00002", "image": "statue_of_liberty.png"
		,"color": [{"a":255}]
		,"position":[
			 {"x":350,"y":0}
			 ,{"start":0.0, "duration":60.00, "x":350, "y":-800}
		]
	}]);
	
this.loader.addAnimation ([
    {
         "start": 0, "duration":50
        ,"layer": "00003"
		 ,"initFunction":"{initTexts();}"
		 ,"runFunction":"{runTexts(animation);}"
		 ,"shader":{
			"name":"Distortion",
			"variable":[
				  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				 ,{"name":"noiseTexture","type":"int","value":[1]}
				 ,{"name":"distortionResolutionX","value":[2.8]}
				 ,{"name":"distortionResolutionY","value":[2.3]}
				 ,{"name":"distortionX","value":[0.05]}
				 ,{"name":"distortionY","value":[0.2]}
				 ,{"name":"distortionSpeed","value":[10.0]}
				 ,{"name":"shakeSizeY","value":[0.05]}
				 ,{"name":"glitchSize","value":[0.01]}
				 ,{"name":"noiseAlpha","value":[0.0]}
			]
		}
	}
]);

	this.loader.addAnimation([
	{
		 "start": 50, "duration": 28
		,"layer": "00011"
		,"initFunction":"{initStarParticles(animation);}"
		,"runFunction":"{drawStarParticles(animation);}"
     ,"shader":{
            "name":"Distortion",
            "variable":[
                  {"name":"time","value":["{return getSceneTimeFromStart()+2*Math.random();}"]}
                 ,{"name":"noiseTexture","type":"int","value":[1]}
                 ,{"name":"distortionResolutionX","value":[7.8]}
                 ,{"name":"distortionResolutionY","value":[7.3]}
                 ,{"name":"distortionX","value":[0.2]}
                 ,{"name":"distortionY","value":[0.2]}
                 ,{"name":"distortionSpeed","value":[20.0]}
                 ,{"name":"shakeSizeY","value":[0.05]}
                 ,{"name":"glitchSize","value":[0.01]}
                 ,{"name":"noiseAlpha","value":[0.0]}
            ]
        }
	}]);

	this.loader.addAnimation([{
		 "start": 35.0, "duration": 800
		,"layer": "00011", "image": "trumphead.png"
		,"scale":[
			 {"x":1.1,"y":1.1}
			 ]
		,"position":[
			 {"x":420,"y":180}
		]
		,"color": [{}, {"start":"1:20","duration":1,"a":0}]
	}]);

this.loader.addAnimation([{
		 "start": 35.0, "duration": 800
		,"layer": "00012", "image": "trump_hands.png"
		,"scale":[
			 {"x":1.6,"y":1.6}
			 ]
		,"position":[
			 {"x":55,"y":0}
		]
		,"color": [{}, {"start":"1:20","duration":1,"a":0}]
	}]);

this.loader.addAnimation ([
    {
         "start": 0, "duration":533
        ,"layer": "00013", "image": ["fbo.color.fbo","data/hard_noise.png"]
		,"scale":[
		 {"x":1.0,"y":1.0}
		 ,{"start":50.0, "duration":15.00, "x":0.52, "y":0.52}
		 ]
		 ,"position":[
		 {"x":0,"y":0}
		 ,{"start":50.0, "duration":15.00, "x":320, "y":60}
		]
		,"color": [{}, {"start":"1:20","duration":1,"a":0}]
	 ,"initFunction":"{fboImage = imageLoadImage('fbo.color.fbo'); setTextureSizeToScreenSize(fboImage.ptr); }"
	 ,"runFunction":"{setTextureSizeToScreenSize(fboImage.ptr);}"
     ,"shader":{
            "name":"Distortion",
            "variable":[
                  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
                 ,{"name":"noiseTexture","type":"int","value":[1]}
                 ,{"name":"distortionResolutionX","value":[7.8]}
                 ,{"name":"distortionResolutionY","value":[7.3]}
                 ,{"name":"distortionX","value":[0.02]}
                 ,{"name":"distortionY","value":[0.02]}
                 ,{"name":"distortionSpeed","value":[2.0]}
                 ,{"name":"shakeSizeY","value":[0.005]}
                 ,{"name":"glitchSize","value":[0.001]}
                 ,{"name":"noiseAlpha","value":[0.0]}
            ]
        }
    }
]);

this.loader.addAnimation([{
	 "start": "1:11", "duration": 10
	,"layer": "00020", "image": "demoscene.png"
	,"color": [{"a":0},{"duration":1,"a":255},{"duration":8},{"duration":1,"a":0}]
}]);

var gunCount = 10;
for(var i=0; i<gunCount; i++)
{
	var position = 360/gunCount*i;
	this.loader.addAnimation([{
		 "start": "1:22", "duration": 9
		,"layer": "00020", "image": "m-16.png"
		,"scale": [{"x":0.2, "y":0.2}]
		,"angle": [{"degreesZ":position,"pivot":{"x":1192*0.15,"y":0}},{"duration":9,"degreesZ":360*2+position}]
		,"position": [{"x":getScreenWidth()/2+1192*0.05, "y":getScreenHeight()/2}]
		,"color": [{"a":0}, {"duration":1,"a":255},{"start":"1:27","duration":1.5,"a":0}]
		
	}]);
}

this.loader.addAnimation([{
	 "start": "1:22", "duration": 9
	,"layer": "00020", "image": "republican_logo.png"
	,"scale": [{"x":0.5, "y":0.5}]
	,"color": [{"a":0}, {"duration":1,"a":255},{"start":"1:27","duration":1.5,"a":0}]
}]);

this.loader.addAnimation([{
	 "start": "1:20", "duration": 9
	,"layer": "00020", "image": "great_again.png"
	,"position": [{"x":90,"y":getScreenHeight()*0.8}]
	,"color": [{"a":0}, {"duration":1,"a":255},{"start":"1:27","duration":1.5,"a":0}]
}]);

this.loader.addAnimation([{
	 "start": "1:22", "duration": 9
	,"layer": "00020", "image": "jml.png"
	,"color": [{"a":0}, {"duration":1,"a":255},{"start":"1:27","duration":1.5,"a":0}]
	,"scale": [{"x":0.1, "y":0.1}]
	,"position": [{"x":getScreenWidth()*0.94,"y":getScreenHeight()*0.84}]
}]);

	this.loader.processAnimation();
	
	//debugPrint(JSON.stringify(this.loader.animationLayers,  null, 2));
}

/*
("socialists.png")	- socialists
("muslims.png")		- neckbeards
("gun_control.png")	- revision visitors
("obama.png")		- pouet users
("china.png")		- Lame Atari
("mexicans.png")	- Lousy Amiga

Demoscene wasn't built by stinking sofa sceners
Make scene great again
*/

var texts,noiseTexture;
function initTexts()
{
	texts = [
		 imageLoadImage("socialists.png")
		,imageLoadImage("neckbeards.png")
		,imageLoadImage("revision_visitors.png")
		,imageLoadImage("pouet_users.png")
		,imageLoadImage("lame_atari.png")
		,imageLoadImage("lousy_amiga.png")
	];
	noiseTexture = imageLoadImage("realnoise.png");
}

function drawTextTexture(texture, alpha)
{
	glColor4f(1,1,1,alpha);
	setTextureDefaults(texture.ptr);
	setTextureCenterAlignment(texture.ptr, 1);
	setTextureScale(texture.ptr, 1.5,1.5);
	setTextureUnitTexture(texture.ptr, 1, noiseTexture.ptr);
	drawTexture(texture.ptr);
	glColor4f(1,1,1,1);
}

function runTexts(animation)
{
	var textureDuration = animation.duration / texts.length;
	var textureFade = 1.5;

	var alpha = 0;
	var time = getSceneTimeFromStart()-animation.start;
	var textI = Math.floor(time/textureDuration);
	var currentTextStartTime = textI*textureDuration;
	if (time-currentTextStartTime < textureFade)
	{
		alpha = (time-currentTextStartTime)/textureFade;
	}
	else if (time-currentTextStartTime-textureDuration+textureFade < textureFade)
	{
		alpha = 1-(time-currentTextStartTime-textureDuration+textureFade)/textureFade;
	}
	else
	{
		alpha = 1;
	}

	var texture = texts[textI];
	drawTextTexture(texture, alpha);
}

var particleContainer;
function particleInit(particleContainer, particle)
{
	var scale = 0.15;	
	setParticleScaleRange(particle.ptr, scale, scale, 0, scale, scale, 0);
	
	var precision = getScreenHeight();
	var radius = getScreenWidth();
	setParticleAngleRange(particle.ptr, 0, 0, random()*360, 0, 0, random()*360*(random()*2-1));

	var starW = 615;
	var starH = 629;
	var x = getScreenWidth()/2-(starW*scale)/2;
	var y = getScreenHeight()/2-(starH*scale)/2;
	var angle = (random()*precision+precision)*2*Math.PI/precision;
	var endX = Math.cos(angle) * radius;
	var endY = Math.sin(angle) * radius;
	setParticlePositionRange(particle.ptr, x, y, 0, endX, endY, 0);
	
	var lifeSeconds = 3;	
	var startTime = getSceneTimeFromStart()+random()*lifeSeconds*2;
	var duration = lifeSeconds+random()*lifeSeconds;
	setParticleTime(particle.ptr, startTime, duration);
	
	setParticleColor(particle.ptr, 1,1,1, 1);
}

function initStarParticles(animation)
{
	particleContainer = initParticleContainer();
	setParticleContainerTime(particleContainer.ptr, animation.start, animation.duration);
	setParticleContainerPerspective3d(particleContainer.ptr, 0);
	bindParticleContainerInitParticleFunction(particleContainer.ptr, "particleInit");
	setParticleContainerDefaultTextureList(particleContainer.ptr,
		[
			imageLoadImage("data/star.png").ptr
		]
	);
	initParticleContainerParticles(particleContainer.ptr, 0, 52);
}

function drawStarParticles(animation)
{
	drawParticleContainer(particleContainer.ptr);
}

Demo.prototype.run = function()
{
	this.player.drawAnimation(this.loader.animationLayers);
}
