Game.State.GainStatState = {
    setup: function(entity) {
        this._entity = entity;
        this._options = entity.getStatOptions();
    },
    render: function() {
        var letters = 'abcdefghijklmnopqrstuvwxyz';

		var msg="<h1>LEVEL UP!</h1>";
		msg+="Choose a stat to improve.<br/><br/>";
		
        for (var i = 0; i < this._options.length; i++)
            msg+=letters.substring(i, i + 1) + ' - ' + this._options[i][0] + "<br/>";

        msg+="<br>Remaining points: " + this._entity.getStatPoints();
        Game.modalAnnounce(msg);
	},
    handleInput: function(inputType, inputData) {
        if (inputType === 'keydown') {
            if (inputData.keyCode >= ROT.VK_A && inputData.keyCode <= ROT.VK_Z) {	// If a letter was pressed, check if it matches to a valid option.
                var index = inputData.keyCode - ROT.VK_A;							// Check if it maps to a valid item by subtracting 'a' from the character to know what letter of the alphabet we used.
                if (this._options[index]) {
                    this._options[index][1].call(this._entity);
                    this._entity.setStatPoints(this._entity.getStatPoints() - 1);
                    if (this._entity.getStatPoints() == 0) {
						Game.closeModalAnnounce();
                        Game.State.PlayState.setSubState(undefined);
                    } else
                        Game.refresh();
                }
            }
        }
    }
};
