Game.DynamicGlyph = function(properties) {
    properties = properties || {};
    Game.Glyph.call(this, properties);
    this._name = properties['name'] || '';
    this._attachedMixins = {};
    this._attachedMixinGroups = {};
    this._listeners = {};

    // Setup the object's mixins
    var mixins = properties['mixins'] || [];
    for (var i = 0; i < mixins.length; i++) {
        for (var key in mixins[i])								// Copy over all properties from each mixin apart from the name, init, or listeners property. 
            if (key != 'init' && key != 'name' && key != 'listeners' && !this.hasOwnProperty(key))
                this[key] = mixins[i][key];
				
        this._attachedMixins[mixins[i].name] = true;			// Add the name of this mixin to our attached mixins
        
        if (mixins[i].groupName)								// If a group name is present, add it
            this._attachedMixinGroups[mixins[i].groupName] = true;
        
        if (mixins[i].listeners) {								// Add all of our listeners
            for (var key in mixins[i].listeners){				// If we don't already have a key for this event in our listeners array, add it.
                if (!this._listeners[key])
                    this._listeners[key] = [];
                
                //this._listeners[key].push(mixins[i].listeners[key]);	// Add the listener
				if (this._listeners[key].indexOf(mixins[i].listeners[key]) === -1)	// Add the listener if we don't already know about it
					this._listeners[key].push(mixins[i].listeners[key]);			
            }
        }
    }
	
	// Finally call each mixin's init function if there is one -- holding off till now in case mixin's init functions check for other mixins!
    for (var i = 0; i < mixins.length; i++)
	    if (mixins[i].init)
            mixins[i].init.call(this, properties);
};
Game.DynamicGlyph.extend(Game.Glyph);

Game.DynamicGlyph.prototype.hasMixin = function(obj) {
    if (typeof obj === 'object')
        return this._attachedMixins[obj.name];
    else
        return this._attachedMixins[obj] || this._attachedMixinGroups[obj];
};

Game.DynamicGlyph.prototype.setName = function(name) {
    this._name = name;
};

Game.DynamicGlyph.prototype.getName = function() {
    return this._name;
};

Game.DynamicGlyph.prototype.getDescription = function() {
    return Game.capitaliseFirstLetter(this._name);
};

Game.DynamicGlyph.prototype.describeA = function(capitalize) {
    var prefixes = capitalize ? ['A', 'An'] : ['a', 'an'];
    var string = this._name;
    var firstLetter = string.charAt(0).toLowerCase();
    var prefix = 'aeiou'.indexOf(firstLetter) >= 0 ? 1 : 0;
    return prefixes[prefix] + ' ' + string;
};

Game.DynamicGlyph.prototype.describeThe = function(capitalize) {
    var prefix = capitalize ? 'The' : 'the';
    return prefix + ' ' + this._name;
};

Game.DynamicGlyph.prototype.raiseEvent = function(event) {
    if (!this._listeners[event])								// Make sure we have at least one listener, or else exit
        return;
    var args = Array.prototype.slice.call(arguments, 1)			// Extract any arguments passed, removing the event name
    var results = [];
    for (var i = 0; i < this._listeners[event].length; i++)		// Invoke each listener, with this entity as the context and the arguments
        results.push(this._listeners[event][i].apply(this, args));
    return results;
};

Game.DynamicGlyph.prototype.details = function() {
    var details = [];
    var detailGroups = this.raiseEvent('details');
    if (detailGroups)
        for (var i = 0, l = detailGroups.length; i < l; i++)
            if (detailGroups[i])
                for (var j = 0; j < detailGroups[i].length; j++)
                    details.push(detailGroups[i][j].key + ': ' +  detailGroups[i][j].value);          
    
	return details.join(', ');
};