#include "input.h"

// Global status things.
int key[256];
int specialKey[256];

// Key press handler, normal keys.
void handleKeypress( unsigned char k, int x, int y ) {
	key[ k ] = 1;

	// Some special cases.
	switch( k ) {
		case 27: // Escape
			exit( 0 );
		case 'p': // Neat for debugging
			sleep( 1 );
		break;
	}
}
void handleKeyUp( unsigned char k, int x, int y ) {
	key[ k ] = 0;
}

// Key press handler, special keys.
void handleSpecialKeypress( int k, int x, int y ) {
	specialKey[ k ] = 1;
}
void handleSpecialUp( int k, int x, int y ) {
	specialKey[ k ] = 0;
}

int warped;
float rotatex;
float rotatey;
void mouseMove(int x, int y)
{
	if(!warped) {
		float changex = x - 512.0/2.0;
		float changey = y - 512.0/2.0;

		//keep camera from rotating beyond vertically up/down
		if(rotatex>=-90 && changey < 10) {
			rotatex = rotatex + 0.25f*changey;
		}
		else if(rotatex<=90 && changey > 10) {
			rotatex = rotatex + 0.25f*changey;
		}
		
		rotatey = rotatey + 0.25f*changex;
		warped = 1;
		glutWarpPointer(512.0/2.0, 512.0/2.0);
	}
	else {
		warped = 0;
	}
}

// Register key handlers.
void setupInput() {
	glutKeyboardFunc( handleKeypress );
	glutKeyboardUpFunc( handleKeyUp );
	glutSpecialFunc( handleSpecialKeypress );
	glutSpecialUpFunc( handleSpecialUp );
	glutPassiveMotionFunc( mouseMove );
}