#version 120

#define M_PI 3.1415926535897932384626433832795
#define BG_CIRCLES 1
#define BG_SPOT 2
#define BG_SPIRAL 3

uniform sampler2D texture;
uniform float time = 1.0;
uniform float fade = 0.2;
uniform vec2 position = vec2(-0.5, -0.5);
uniform vec4 backgroundColor = vec4(0,0,0,0);

uniform int background = BG_SPIRAL;

//BG_SPIRAL uniforms
uniform float curveThickness = 0.5;
uniform float curveBendDegrees = -45;
uniform float curvesDegrees = 60;


void main()
{
	vec2 coord=gl_TexCoord[0].xy;

	float x = coord.x;
	float y = coord.y;
	float d = sqrt(x*x + y*y);

	vec4 color = backgroundColor;
	if (background == BG_CIRCLES)
	{
		x = position.x+coord.x;
		y = position.y+coord.y;
		d = sqrt(x*x + y*y);
		d = sin(d*40)*5;
		color = vec4(d);
	}
	else if (background == BG_SPOT)
	{
		float cx = position.x+x;
		float cy = position.y+y;
		float circle = 1.0/sqrt(cx*cx + cy*cy);

		d = 0;
		if (circle > 3.0)
		{
			float size = 1-sqrt(cx*cx + cy*cy)*3;
			d = sin(sqrt(x*x)*80)*1.5*size+cos(sqrt(y*y)*80)*1.5*size;
		}
		color = vec4(d);
	}
	else if (background == BG_SPIRAL)
	{
		coord += position;
		float curveBendRad = radians(curveBendDegrees);
		float curvesRad = radians(curvesDegrees);
		float bend = curveBendRad*log(length(coord));
		float d = mod(time+atan(coord.x,coord.y)+bend, curvesRad);
		if (d < curvesRad*curveThickness)
		{
			color = vec4(1);
		}
	}

	gl_FragColor = vec4(color.r,color.g,color.b,color.a) * gl_Color;
}
