var TICK;

Demo.prototype.init = function()
{
	TICK = timerGetBeatInSeconds();

	Sync.addSync(
	[
		 { "name":"kick", "type":"rocket" }
		,{ "name":"snare", "type":"rocket" }
		,{ "name":"scratch", "type":"rocket" }
		,{ "name":"wobble", "type":"rocket" }
		,{ "name":"blip", "type":"rocket" }
	]);

	this.preInitIntro(0,30);
	this.preInitKekkonen(14,16);
	this.preInitDance(45,14+TICK*2);
	this.preInitWobbleBall(30,16);
	this.preInitGreetings(59,30);
	this.preInitCredits(86,25);	
}

function getDancer1JazzHands(xy)
{
	var p = Math.sin(getSceneTimeFromStart()*TICK*50)*TICK*80;

	return p;
}

function getDancer2Hands(animation, leftright)
{
	var p = Math.max(Math.min((getSceneTimeFromStart()-(animation.start+6))/1.0, 1.0), 0.0);
	return p;
}

function getDancer3Legs(animation, leftright)
{
	var p = Math.max(Math.min((getSceneTimeFromStart()-(animation.start+12))/0.5, 1.0), 0.0);
	return p;
}

Demo.prototype.preInitDance = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 10
		,"fbo":{"name":"danceFbo","action":"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/wall_dance.png"
		,"layer": 10
		,"color":[
			 {"a":0}
			,{"duration":1}
			,{"duration":0.5,"a":255}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_1_body.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":2}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":300,"y":340}
		]
		,"scale":[{"uniform2d":0.7}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_1_hand_left.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":2}
			,{"duration":0.5,"a":255}
		]
		,"pivot": [
			{"y":-30}
		]
		,"position": [
			{"x":135,"y":535}
		]
		,"scale":[{"uniform2d":0.7}]
		,"angle":[{"degreesZ":"{return getDancer1JazzHands(2);}"}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_1_hand_right.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":2}
			,{"duration":0.5,"a":255}
		]
		,"pivot": [
			{"x":-30}
		]
		,"position": [
			{"x":480,"y":335}
		]
		,"scale":[{"uniform2d":0.7}]
		,"angle":[{"degreesZ":"{return getDancer1JazzHands(2);}"}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_2_body.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":5}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":900,"y":340}
		]
		,"scale":[{"uniform2d":0.7}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_2_hand_left.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":5}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":1080,"y":430}
		]
		,"scale":[{"uniform2d":0.7}]
		,"shader":{"name":"data/shader/dancer.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"multiplier","value":["{return getDancer2Hands(animation, 1);}"]}
				,{"name":"scene","type":"int","value":[2]}
			]
		}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_2_hand_right.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":5}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":750,"y":550}
		]
		,"scale":[{"uniform2d":0.7}]
		,"shader":{"name":"data/shader/dancer.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"multiplier","value":["{return getDancer2Hands(animation, 0);}"]}
				,{"name":"scene","type":"int","value":[2]}
			]
		}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_2_legs.png"
		,"layer": 10
		,"color":[
			 {"a":0,"r":0,"g":0,"b":0}
			,{"duration":5}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":940,"y":250}
		]
		,"scale":[{"uniform2d":0.7}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_3_legs.png"
		,"layer": 10
		,"color":[
			 {"a":0}
			,{"duration":10}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":593,"y":206}
		]
		,"scale":[{"uniform2d":0.71}]
		,"shader":{"name":"data/shader/dancer.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"multiplier","value":["{return getDancer3Legs(animation, 0);}"]}
				,{"name":"scene","type":"int","value":[1]}
			]
		}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/dancer_3_body.png"
		,"layer": 10
		,"color":[
			 {"a":0}
			,{"duration":10}
			,{"duration":0.5,"a":255}
		]
		,"position": [
			{"x":590,"y":340}
		]
		,"scale":[{"uniform2d":0.7}]
	}]);


	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 10
		,"fbo":{"name":"danceFbo","action":"unbind"}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "danceFbo.color.fbo"
		,"layer": 11
		,"position":[
			 {"y":getScreenHeight()/2,"x":getScreenWidth()/2}
			,{"duration":durationTime-TICK*2}
			,{"duration":TICK*2,"x":-getScreenWidth()/2}
		]
	}]);
}

Demo.prototype.preInitCredits = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/vinyl_complete.png"
		,"perspective": "3d"
		,"position": [
			 {"z":-6,"x":4,"y":1}
			,{"duration":3,"z":0,"x":0,"y":0}
		]
		,"angle":[
			 {}
			,{"duration":3,"degreesZ":360,"degreesY":360*2,"degreesX":360}
		]
		,"scale":[
			 {}
			,{"duration":3,"uniform2d":4}
		]
		,"layer": 11
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+3, "duration": durationTime-3
		,"image": "data/vinyl_label.png"
		,"perspective": "3d"
		,"angle":[
			{"degreesZ":"{return Sync.getSyncValue('wobble')*45}"},{"duration":durationTime,"degreesZ":"{return 360*5+Sync.getSyncValue('wobble')*45}"}
		]
		,"scale":[{"uniform2d":1.3}]
		,"layer": 11
	}]);

	var outro_images = [
		 "data/outro_text_1.png"
		,"data/outro_text_2.png"
		,"data/outro_text_3.png"
		,"data/outro_text_4.png"
		,"data/outro_text_5.png"
		,"data/intro_text_linefeed.png"
		,"data/intro_text_linefeed.png"
		,"data/intro_text_linefeed.png"
		,"data/outro_text_6.png"
		,"data/outro_text_7.png"
	];
	for(var i = 0; i < outro_images.length; i++)
	{
		var textDuration = 11;
		this.loader.addAnimation([
		{
			 "start": startTime+0.6*i+4, "duration": textDuration
			,"image": outro_images[i]
			,"position":[
				 {"y":0, "x":getScreenWidth()/2}
				,{"y":720, "duration":textDuration}
			]
			,"color":[
				 {"a":0}
				,{"duration":0.25,"a":255}
				,{"duration":textDuration-0.5}
				,{"duration":0.25,"a":0}
			]
			,"scale":[{"uniform2d":0.45}]
			,"layer": 11
		}]);
	}
}

function getKekkonenHeadShake(xy)
{
	var p = Math.sin(getSceneTimeFromStart()*TICK*12)*TICK*8;

	if (xy == 0) //x
	{
		return 1098+p;
	}
	else if (xy == 1) //y
	{
		return 515+p;
	}
	else //rotate
	{
		return p;
	}
}

Demo.prototype.preInitGreetings = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 10
		,"fbo":{"name":"greetFbo","action":"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	var wallScrollDuration = durationTime-TICK*8;
	var wallStartX = 1090;
	var wallEndX = 200;
	var wallDiff = wallStartX-wallEndX;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/wall_greet.png"
		,"position": [
			 {"x":wallStartX, "y":400}
			,{"x":wallEndX, "duration":wallScrollDuration}
		]
		,"layer": 10
	}]);

	var defaults = {
		 "color":[
		 	 {"r":0,"g":0,"b":0,"a":230}
		 ]
		,"scale":[{"uniform2d":0.75}]
	};
	var greet_images = [
		{
			 "image":"data/greet_aarikeskusta.png"
			,"position": [
				 {"x":800,"y":200}
				,{"x":800-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":8}]
		},
		{
			 "image":"data/greet_iso.png"
			,"position": [
				 {"x":1300,"y":500}
				,{"x":1300-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":-2}]
		},
		{
			 "image":"data/greet_kewlers.png"
			,"position": [
				 {"x":800,"y":300}
				,{"x":800-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":4}]
		},
		{
			 "image":"data/greet_vaahtera.png"
			,"position": [
				 {"x":350,"y":100}
				,{"x":350-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":2}]
		},
		{
			 "image":"data/greet_wamma.png"
			,"position": [
				 {"x":1450,"y":100}
				,{"x":1450-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":10}]
		},
		{
			 "image":"data/greet_paraguay.png"
			,"position": [
				 {"x":700,"y":600}
				,{"x":700-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":-4}]
		},
		{
			 "image":"data/greet_dekadence.png"
			,"position": [
				 {"x":1500,"y":400}
				,{"x":1500-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":-3}]
		},
		{
			 "image":"data/greet_damones.png"
			,"position": [
				 {"x":1600,"y":600}
				,{"x":1600-wallDiff, "duration":wallScrollDuration}
			]
			,"color":Utils.deepCopyJson(defaults.color)
			,"scale":Utils.deepCopyJson(defaults.scale)
			,"angle":[{"degreesZ":10}]
		}
	];

	for(var i = 0; i < greet_images.length; i++)
	{
		var greet = greet_images[i];
		if (greet.position.length < 2) {break;}
		this.loader.addAnimation([
		{
			 "start": startTime, "duration": durationTime
			,"image": greet.image
			,"position": greet.position
			,"color": greet.color
			,"scale": greet.scale
			,"angle": greet.angle
			,"layer": 10
			,"shader":{"name":"Speaker",
				"variable":[
					 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
					,{"name":"multiplier","value":["{return Sync.getSyncValue('kick')*0.3+Sync.getSyncValue('snare')*0.6;}"]}
				]
			}
		}]);		
	}

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 10
		,"fbo":{"name":"greetFbo","action":"unbind"}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "greetFbo.color.fbo"
		,"layer": 11
		,"position":[
			 {"y":getScreenHeight()/2,"x":getScreenWidth()*1.5}
			,{"duration":TICK*2,"x":getScreenWidth()/2}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/kekkonen_body.png"
		,"position": [
			{"x":1100, "y":205}
		]
		,"color":[
			 {"a":0}
			,{"duration":TICK*2}
			,{"duration":TICK, "a":255}
			,{"duration":durationTime-2}
			,{"duration":0.5,"a":0}
		]
		,"layer": 13
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/kekkonen_grills_pink_head.png"
		,"position": [
			 {"x":"{return getKekkonenHeadShake(0);}", "y":"{return getKekkonenHeadShake(1);}"}
		]
		,"angle": [
			{"degreesZ":"{return getKekkonenHeadShake(2);}"}
		]
		,"layer": 13
		,"color":[
			 {"a":0}
			,{"duration":TICK*2}
			,{"duration":TICK, "a":255}
			,{"duration":durationTime-2}
			,{"duration":0.5,"a":0}
		]
	}]);
}

Demo.prototype.preInitIntro = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/eduskuntatalo.png"
		,"position":[{"y":-100},{"duration":15,"y":400}]
		,"color":[
			 {"a":0}
			,{"duration":1,"a":255}
			,{"duration":23.25}
			,{"duration":0.5,"a":0}
		]
		,"align":2
		,"layer": 10
	}]);


	var intro_images = [
		 "data/intro_text_1_1.png"
		,"data/intro_text_linefeed.png"
		,"data/intro_text_2_1.png"
		,"data/intro_text_2_2.png"
		,"data/intro_text_2_3.png"
		,"data/intro_text_linefeed.png"
		,"data/intro_text_3_1.png"
		,"data/intro_text_3_2.png"
		,"data/intro_text_3_3.png"
	];
	for(var i = 0; i < intro_images.length; i++)
	{
		var textDuration = 8;
		this.loader.addAnimation([
		{
			 "start": startTime+0.6*i+1, "duration": textDuration
			,"image": intro_images[i]
			,"position":[
				 {"y":0, "x":getScreenWidth()/2}
				,{"y":720, "duration":textDuration}
			]
			,"color":[
				 {"a":0}
				,{"duration":0.25,"a":255}
				,{"duration":textDuration-0.5}
				,{"duration":0.25,"a":0}
			]
			,"scale":[{"uniform2d":0.8}]
			,"layer": 10
		}]);
	}
}

Demo.prototype.preInitKekkonen = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime+1, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": 10
		,"shader":{"name":"data/shader/background.fs",
			"variable":[
				{"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":50}
			,{"duration":8.75}
			,{"duration":0.5,"a":255}
		]
	}]);

	this.preInitSpeaker(startTime, durationTime,
		{
			"position": { "x": 150, "y": 300 },
			"scale": { "x": 0.8, "y": 0.8 }
			,"color":[
				 {"a":0}
				,{"duration":12}
				,{"duration":0.5,"a":255}
			]
		}
	);

	this.preInitSpeaker(startTime, durationTime,
		{
			"position": { "x": 1120, "y": 300 },
			"mirror": true
			,"scale": { "x": 0.8, "y": 0.8 }
			,"color":[
				 {"a":0}
				,{"duration":12}
				,{"duration":0.5,"a":255}
			]
		}
	);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/kekkonen.png"
		,"position":[{"x":getScreenWidth()/2,"y":255}]
		,"color":[
			 {"r":0,"g":0,"b":0,"a":0}
			,{"duration":0.5}
			,{"duration":0.5,"a":255}
			,{"duration":6.25}
			,{"duration":0.5,"r":255,"g":255,"b":255}
			,{"duration":7}
			,{"duration":0,"a":0}
		]
		,"layer": 10
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/kekkonen_grills_pink.png"
		,"position":[
			 {"x":getScreenWidth()/2,"y":255}
			,{"duration":15.5}
			,{"duration":0.5,"y":-250}
		]
		,"layer": 10
		,"color":[
			 {"a":0}
			,{"duration":14}
			,{"duration":0.5,"a":255}
			,{"duration":1}
			,{"duration":0.5,"a":0}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/demo_title.png"
		,"color":[
			 {"a":0}
			,{"duration":12}
			,{"duration":0.5,"a":255}
			,{"duration":3}
			,{"duration":0.5,"a":0}
		]
		,"angle":[{"degreesZ":0},{"duration":15.5},{"duration":0.5,"degreesZ":180}]
		,"scale":[{},{"duration":15.5},{"duration":0.5,"uniform2d":4}]
		,"layer": 10
	}]);
}

Demo.prototype.preInitSpeaker = function(startTime, durationTime, definitions)
{
	var layer = 10;
	var mirror = definitions.mirror===true?-1:1;

	var x = definitions.position.x;
	var y = definitions.position.y;
	var scaleX = definitions.scale.x*mirror;
	var scaleY = definitions.scale.y;

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/speaker_box.png"
		,"scale": [{"x":scaleX, "y":scaleY}]
		,"position":[{"x":x,"y":y}]
		,"layer": layer
		,"color": definitions.color
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/speaker_up.png"
		,"scale": [{"x":scaleX, "y":scaleY}]
		,"position":[{"x":x+110*mirror,"y":y+150}]
		,"layer": layer
		,"color": definitions.color
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/speaker_up.png"
		,"scale": [{"x":scaleX, "y":scaleY}]
		,"position":[{"x":x+110*mirror,"y":y+150}]
		,"layer": layer
		,"shader":{"name":"Speaker",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"multiplier","value":["{return Sync.getSyncValue('kick');}"]}
			]
		}
		,"color": definitions.color
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/speaker_down.png"
		,"scale": [{"x":scaleX, "y":scaleY}]
		,"position":[{"x":x+110*mirror,"y":y-100}]
		,"layer": layer
		,"color": definitions.color
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/speaker_down.png"
		,"scale": [{"x":scaleX, "y":scaleY}]
		,"position":[{"x":x+110*mirror,"y":y-100}]
		,"layer": layer
		,"shader":{"name":"Speaker",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"multiplier","value":["{return Sync.getSyncValue('kick');}"]}
			]
		}
		,"color": definitions.color
	}]);
}

var oldBeat = {
	"kick": 0,
	"snare": 0
};
var beatTriggerI = 0;
function checkWobbleBeat(sync)
{
	var beat = Math.floor(timerGetCurrentBeat());
	if (beat < oldBeat[sync])
	{
		oldBeat[sync] = 0;
	}
	beatTriggerI++;

	if (oldBeat[sync] <= beat && Sync.getSyncValue(sync) > 0.95)
	{
		oldBeat[sync] = beat;
		return true;
	}

	return false;	
}

var displacementMagnitude = [{"x":0,"y":0,"z":0},{"x":0,"y":0,"z":0},{"x":0,"y":0,"z":0,"done":false}]
function getWobbleDisplacementMagnitude(xyz)
{
	if (checkWobbleBeat("kick") === true)
	{
		displacementMagnitude[0].x = displacementMagnitude[1].x;
		displacementMagnitude[0].y = displacementMagnitude[1].y;
		displacementMagnitude[0].z = displacementMagnitude[1].z;

		displacementMagnitude[1].x = random()*8+3;
		displacementMagnitude[1].y = random()*8+3;
		displacementMagnitude[1].z = random()*8+3;

		displacementMagnitude[2].done = false;

		//*Sync.getSyncValue("kick");
	}
	var p = Sync.getSyncValue("kick");
	if (p >= 1.0)
	{
		displacementMagnitude[2].done = true;
	}
	else if (displacementMagnitude[2].done === true)
	{
		p = 1.0;
	}
	displacementMagnitude[2].x = interpolate(p,displacementMagnitude[0].x,displacementMagnitude[1].x);
	displacementMagnitude[2].y = interpolate(p,displacementMagnitude[0].y,displacementMagnitude[1].y);
	displacementMagnitude[2].z = interpolate(p,displacementMagnitude[0].z,displacementMagnitude[1].z);

	if (xyz == 0) //x
	{
		return displacementMagnitude[2].x;
	}
	else if (xyz == 1) //y
	{
		return displacementMagnitude[2].y;
	}
	else if (xyz == 2) //z
	{
		return displacementMagnitude[2].z;
	}
}

var displacementMultiplier = [{"x":0,"y":0,"z":0},{"x":0,"y":0,"z":0},{"x":0,"y":0,"z":0,"done":false}];

function getWobbleDisplacementMultiplier(animation,xyz)
{
	if (checkWobbleBeat("snare") === true)
	{
		displacementMultiplier[0].x = displacementMultiplier[1].x;
		displacementMultiplier[0].y = displacementMultiplier[1].y;
		displacementMultiplier[0].z = displacementMultiplier[1].z;

		var r = random()*0.13+0.02;
		displacementMultiplier[1].x = r;
		displacementMultiplier[1].y = r;
		displacementMultiplier[1].z = r;

		displacementMultiplier[2].done = false;
	}
	var p = Sync.getSyncValue("snare");
	if (p >= 1.0)
	{
		displacementMultiplier[2].done = true;
	}
	else if (displacementMultiplier[2].done === true)
	{
		p = 1.0;
	}
	displacementMultiplier[2].x = interpolate(p,displacementMultiplier[0].x,displacementMultiplier[1].x);
	displacementMultiplier[2].y = interpolate(p,displacementMultiplier[0].y,displacementMultiplier[1].y);
	displacementMultiplier[2].z = interpolate(p,displacementMultiplier[0].z,displacementMultiplier[1].z);

	var SPHERE_FADE_TIME = 1.0;
	var p = Math.max(Math.min((getSceneTimeFromStart()-(animation.start+animation.duration-1))/SPHERE_FADE_TIME, 1.0),0.0);
	if (p > 0)
	{
		return p;
	}

	if (xyz == 0) //x
	{
		return displacementMultiplier[2].x;
	}
	else if (xyz == 1) //y
	{
		return displacementMultiplier[2].y;
	}
	else if (xyz == 2) //z
	{
		return displacementMultiplier[2].z;
	}
}

function getWobbleSphereSize(animation)
{
	var SPHERE_SCALE_TIME = 1.0;
	var p = Math.min((getSceneTimeFromStart()-animation.start)/SPHERE_SCALE_TIME, 1.0);

	return p*1.1;
}

function getWobbleSpiralFadeThickness(animation)
{
	var thickness = 0.5;
	var SPIRAL_FADE_TIME = 1.0;
	var p = Math.max(Math.min((getSceneTimeFromStart()-(animation.start+animation.duration-1))/SPIRAL_FADE_TIME, 1.0),0.0);

	return (1-p)*thickness;
}

Demo.prototype.preInitWobbleBall = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": 10
		,"shader":{"name":"data/shader/background.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"curveThickness","value":["{return getWobbleSpiralFadeThickness(animation);}"]}
			]
		}
		,"color":[
			 {"a":255}
			,{"duration":durationTime-1}
			,{"duration":1,"a":0}
		]
	}]);

	this.preInitSpeaker(startTime, durationTime,
		{
			"position": { "x": 1120, "y": 300 },
			"scale": { "x": 0.8, "y": 0.8 },
			"mirror": true
			,"color":[
				 {}
				,{"start":startTime+durationTime-1,"duration":1,"a":0}
			]
		}
	);

	this.preInitSpeaker(startTime, durationTime,
		{
			"position": { "x": 150, "y": 300 },
			"scale": { "x": 0.8, "y": 0.8 }
			,"color":[
				 {}
				,{"start":startTime+durationTime-1,"duration":1,"a":0}
			]
		}
	);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": 10
		,"shader":{"name":"data/shader/raymarching.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"displacementMagnitude","value":["{return getWobbleDisplacementMagnitude(0);}","{return getWobbleDisplacementMagnitude(1);}","{return getWobbleDisplacementMagnitude(2);}"]}
				,{"name":"displacementMultiplier","value":["{return getWobbleDisplacementMultiplier(animation,0);}","{return getWobbleDisplacementMultiplier(animation,1);}","{return getWobbleDisplacementMultiplier(animation,2);}"]}
				,{"name":"sphereSize","value":["{return getWobbleSphereSize(animation);}"]}
			]
		}
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"start":startTime+durationTime-1,"duration":1,"a":0}
		]
	}]);
}
