import matplotlib
matplotlib.use('Agg')
from flask import Flask, render_template, Response, url_for
import os, subprocess
import config
from pylab import *
import mpld3

app = Flask(__name__)

@app.route('/')
def vauvaVahti():
    return render_template('index.html')

@app.route('/plots.html')
def plots():
    m3 = url_for('static', filename='mpld3.v0.3git.js')
    d3 = url_for('static', filename='d3.v3.min.js')
    def makefig():
       data=loadtxt('temp_h.dat')
       plot(data[:,0],data[:,1],'r-',label='T')
       plot(data[:,0],data[:,2],'g,-',label='H')
       xlabel('Aika')
       legend()
	
       yield mpld3.fig_to_html(figure(1),no_extras=True,template_type="general",mpld3_url=m3,d3_url=d3)
       close(figure(1))
    return Response(response=makefig(), status=200);

@app.route('/media/default.<type>')
def media_content_audio(type):
    def generate():
        cmdline= list()
        cmdline.append( config.decoder )
	cmdline.extend( config.rec_device )
        cmdline.extend( config.avconv_args[type] )
        FNULL = open(os.devnull, 'w')
        proc= subprocess.Popen( cmdline, stdout=subprocess.PIPE, stderr=FNULL )
        try:
            f= proc.stdout
            byte = f.read(config.chunksize)
            while byte:
                yield byte
                byte = f.read(config.chunksize)
        finally:
            proc.kill()

    return Response(response=generate(),status=200,mimetype=config.transcode_mime[type],headers={'Access-Control-Allow-Origin': '*', "Content-Type":config.transcode_mime[type],"Content-Disposition":"inline","Content-Transfer-Enconding":"binary"})



if __name__ == '__main__':
    app.run('0.0.0.0')
