!function t(e,n,r){function i(s,a){if(!n[s]){if(!e[s]){var u="function"==typeof require&&require;if(!a&&u)return u(s,!0);if(o)return o(s,!0);throw new Error("Cannot find module '"+s+"'")}var l=n[s]={exports:{}};e[s][0].call(l.exports,function(t){var n=e[s][1][t];return i(n?n:t)},l,l.exports,t,e,n,r)}return n[s].exports}for(var o="function"==typeof require&&require,s=0;s<r.length;s++)i(r[s]);return i}({1:[function(t,e,n){e.exports={"arrow.position":"uniform float worldUnit;\nuniform float lineDepth;\nuniform float lineWidth;\nuniform float focusDepth;\n\nuniform vec4 geometryClip;\nuniform float arrowSize;\nuniform float arrowSpace;\n\nattribute vec4 position4;\nattribute vec3 arrow;\nattribute vec2 attach;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvoid getArrowGeometry(vec4 xyzw, float near, float far, out vec3 left, out vec3 right, out vec3 start) {\n  right = getPosition(xyzw, 1.0);\n  left  = getPosition(vec4(near, xyzw.yzw), 0.0);\n  start = getPosition(vec4(far, xyzw.yzw), 0.0);\n}\n\nmat4 getArrowMatrix(vec3 left, vec3 right, vec3 start) {\n\n  float depth = focusDepth;\n  if (lineDepth < 1.0) {\n    // Depth blending\n    float z = max(0.00001, -right.z);\n    depth = mix(z, focusDepth, lineDepth);\n  }\n    \n  vec3 diff = left - right;\n  float l = length(diff);\n  if (l == 0.0) {\n    return mat4(1.0, 0.0, 0.0, 0.0,\n                0.0, 1.0, 0.0, 0.0,\n                0.0, 0.0, 1.0, 0.0,\n                0.0, 0.0, 0.0, 1.0);\n  }\n\n  // Construct TBN matrix around shaft\n  vec3 t = normalize(diff);\n  vec3 n = normalize(cross(t, t.yzx + vec3(.1, .2, .3)));\n  vec3 b = cross(n, t);\n  \n  // Shrink arrows when vector gets too small\n  // Approach linear scaling with cubic ease the smaller we get\n  float size = arrowSize * lineWidth * worldUnit * depth * 1.25;\n  diff = right - start;\n  l = length(diff) * arrowSpace;\n  float mini = clamp(1.0 - l / size * .333, 0.0, 1.0);\n  float scale = 1.0 - mini * mini * mini;\n  float range = size * scale;\n  \n  // Size to 2.5:1 ratio\n  float rangeNB = range / 2.5;\n\n  // Anchor at end position\n  return mat4(vec4(n * rangeNB,  0),\n              vec4(b * rangeNB,  0),\n              vec4(t * range, 0),\n              vec4(right,  1.0));\n}\n\nvec3 getArrowPosition() {\n  vec3 left, right, start;\n  \n  vec4 p = min(geometryClip, position4);\n  \n  getArrowGeometry(p, attach.x, attach.y, left, right, start);\n  mat4 matrix = getArrowMatrix(left, right, start);\n  return (matrix * vec4(arrow.xyz, 1.0)).xyz;\n\n}\n","axis.position":"uniform vec4 axisStep;\nuniform vec4 axisPosition;\n\nvec4 getAxisPosition(vec4 xyzw, inout vec4 stpq) {\n  return axisStep * xyzw.x + axisPosition;\n}\n","cartesian.position":"uniform mat4 viewMatrix;\n\nvec4 getCartesianPosition(vec4 position, inout vec4 stpq) {\n  return viewMatrix * vec4(position.xyz, 1.0);\n}\n","cartesian4.position":"uniform vec4 basisScale;\nuniform vec4 basisOffset;\nuniform vec4 viewScale;\nuniform vec4 viewOffset;\n\nvec4 getCartesian4Position(vec4 position, inout vec4 stpq) {\n  return position * basisScale + basisOffset;\n}\n","clamp.position":"uniform vec4 clampLimit;\n\nvec4 getClampXYZW(vec4 xyzw) {\n  return clamp(xyzw, vec4(0.0), clampLimit);\n}\n","color.opaque":"vec4 opaqueColor(vec4 color) {\n  return vec4(color.rgb, 1.0);\n}\n","face.position":"uniform vec4 geometryClip;\nattribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getFacePosition() {\n  vec4 p = min(geometryClip, position4);\n  return getPosition(p, 1.0);\n}\n","face.position.normal":"attribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvarying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvoid getFaceGeometry(vec4 xyzw, out vec3 pos, out vec3 normal) {\n  vec3 a, b, c;\n\n  a   = getPosition(vec4(xyzw.xyz, 0.0), 0.0);\n  b   = getPosition(vec4(xyzw.xyz, 1.0), 0.0);\n  c   = getPosition(vec4(xyzw.xyz, 2.0), 0.0);\n\n  pos = getPosition(xyzw, 1.0);\n  normal = normalize(cross(c - a, b - a));\n}\n\nvec3 getFacePositionNormal() {\n  vec3 center, normal;\n\n  getFaceGeometry(position4, center, normal);\n  vNormal   = normal;\n  vLight    = normalize((viewMatrix * vec4(1.0, 2.0, 2.0, 0.0)).xyz);\n  vPosition = -center;\n\n  return center;\n}\n","float.encode":"/*\nFloat encoding technique by\nCarlos Scheidegger\nhttps://github.com/cscheid/lux/blob/master/src/shade/bits/encode_float.js\n\nConversion to GLSL by:\nhttp://concord-consortium.github.io/lab/experiments/webgl-gpgpu/script.js\n*/\n\nfloat shift_right(float v, float amt) { \n  v = floor(v) + 0.5; \n  return floor(v / exp2(amt)); \n}\n\nfloat shift_left(float v, float amt) { \n  return floor(v * exp2(amt) + 0.5); \n}\n\nfloat mask_last(float v, float bits) { \n  return mod(v, shift_left(1.0, bits)); \n}\n\nfloat extract_bits(float num, float from, float to) { \n  from = floor(from + 0.5); to = floor(to + 0.5); \n  return mask_last(shift_right(num, from), to - from); \n}\n\nvec4 encode_float(float val) { \n  if (val == 0.0) return vec4(0, 0, 0, 0); \n  float valuesign = val > 0.0 ? 0.0 : 1.0; \n  val = abs(val); \n  float exponent = floor(log2(val)); \n  float biased_exponent = exponent + 127.0; \n  float fraction = ((val / exp2(exponent)) - 1.0) * 8388608.0; \n  float t = biased_exponent / 2.0; \n  float last_bit_of_biased_exponent = fract(t) * 2.0; \n  float remaining_bits_of_biased_exponent = floor(t); \n  float byte4 = extract_bits(fraction, 0.0, 8.0) / 255.0; \n  float byte3 = extract_bits(fraction, 8.0, 16.0) / 255.0; \n  float byte2 = (last_bit_of_biased_exponent * 128.0 + extract_bits(fraction, 16.0, 23.0)) / 255.0; \n  float byte1 = (valuesign * 128.0 + remaining_bits_of_biased_exponent) / 255.0; \n  return vec4(byte4, byte3, byte2, byte1); \n}\n","float.index.pack":"uniform vec4 indexModulus;\n\nvec4 getSample(vec4 xyzw);\nvec4 getIndex(vec4 xyzw);\n\nvec4 floatPackIndex(vec4 xyzw) {\n  vec4 value = getSample(xyzw);\n  vec4 index = getIndex(xyzw);\n\n  vec4 offset = floor(index + .5) * indexModulus;\n  vec2 sum2 = offset.xy + offset.zw;\n  float sum = sum2.x + sum2.y;\n  return vec4(value.xyz, sum);\n}","float.stretch":"vec4 getSample(vec4 xyzw);\n\nfloat floatStretch(vec4 xyzw, float channelIndex) {\n  vec4 sample = getSample(xyzw);\n  vec2 xy = channelIndex > 1.5 ? sample.zw : sample.xy;\n  return mod(channelIndex, 2.0) > .5 ? xy.y : xy.x;\n}","fragment.clip.dashed":"varying float vClipStrokeWidth;\nvarying float vClipStrokeIndex;\nvarying vec3  vClipStrokeEven;\nvarying vec3  vClipStrokeOdd;\nvarying vec3  vClipStrokePosition;\n\nvoid clipStrokeFragment() {\n  bool odd = mod(vClipStrokeIndex, 2.0) >= 1.0;\n\n  vec3 tangent;\n  if (odd) {\n    tangent = vClipStrokeOdd;\n  }\n  else {\n    tangent = vClipStrokeEven;\n  }\n\n  float travel = dot(vClipStrokePosition, normalize(tangent)) / vClipStrokeWidth;\n  if (mod(travel, 16.0) > 8.0) {\n    discard;\n  }\n}\n","fragment.clip.dotted":"varying float vClipStrokeWidth;\nvarying float vClipStrokeIndex;\nvarying vec3  vClipStrokeEven;\nvarying vec3  vClipStrokeOdd;\nvarying vec3  vClipStrokePosition;\n\nvoid clipStrokeFragment() {\n  bool odd = mod(vClipStrokeIndex, 2.0) >= 1.0;\n\n  vec3 tangent;\n  if (odd) {\n    tangent = vClipStrokeOdd;\n  }\n  else {\n    tangent = vClipStrokeEven;\n  }\n\n  float travel = dot(vClipStrokePosition, normalize(tangent)) / vClipStrokeWidth;\n  if (mod(travel, 4.0) > 2.0) {\n    discard;\n  }\n}\n","fragment.clip.ends":"varying vec2 vClipEnds;\n\nvoid clipEndsFragment() {\n  if (vClipEnds.x < 0.0 || vClipEnds.y < 0.0) discard;\n}\n","fragment.clip.proximity":"varying float vClipProximity;\n\nvoid clipProximityFragment() {\n  if (vClipProximity >= 0.5) discard;\n}","fragment.color":"void setFragmentColor(vec4 color) {\n  gl_FragColor = color;\n}","fragment.map.rgba":"vec4 fragmentRGBA(vec4 rgba, vec4 stpq) {\n  return rgba;\n}","fragment.solid":"void setFragmentColor(vec4 color) {\n  if (color.a < 1.0) discard;\n  gl_FragColor = color;\n}","fragment.transparent":"void setFragmentColor(vec4 color) {\n  if (color.a >= 1.0) discard;\n  gl_FragColor = color;\n}","grid.position":"uniform vec4 gridPosition;\nuniform vec4 gridStep;\nuniform vec4 gridAxis;\n\nvec4 sampleData(vec2 xy);\n\nvec4 getGridPosition(vec4 xyzw) {\n  vec4 onAxis  = gridAxis * sampleData(vec2(xyzw.y, 0.0)).x;\n  vec4 offAxis = gridStep * xyzw.x + gridPosition;\n  return onAxis + offAxis;\n}\n","grow.position":"uniform float growScale;\nuniform vec4  growMask;\nuniform vec4  growAnchor;\n\nvec4 getSample(vec4 xyzw);\n\nvec4 getGrowSample(vec4 xyzw) {\n  vec4 anchor = xyzw * growMask + growAnchor;\n\n  vec4 position = getSample(xyzw);\n  vec4 center = getSample(anchor);\n\n  return mix(center, position, growScale);\n}","join.position":"uniform float joinStride;\nuniform float joinStrideInv;\n\nfloat getIndex(vec4 xyzw);\nvec4 getRest(vec4 xyzw);\nvec4 injectIndices(float a, float b);\n\nvec4 getJoinXYZW(vec4 xyzw) {\n\n  float a = getIndex(xyzw);\n  float b = a * joinStrideInv;\n\n  float integer  = floor(b);\n  float fraction = b - integer;\n  \n  return injectIndices(fraction * joinStride, integer) + getRest(xyzw);\n}\n","label.alpha":"varying float vPixelSize;\n\nvec4 getLabelAlphaColor(vec4 color, vec4 sample) {\n  float mask = clamp(sample.r * 1000.0, 0.0, 1.0);\n  float alpha = (sample.r - .5) * vPixelSize + .5;\n  float a = mask * alpha * color.a;\n  if (a <= 0.0) discard;\n  return vec4(color.xyz, a);\n}\n","label.map":"vec2 mapUV(vec4 uvwo, vec4 stpq) {\n  return uvwo.xy;\n}\n","label.outline":"uniform float outlineExpand;\nuniform float outlineStep;\nuniform vec3  outlineColor;\n\nvarying float vPixelSize;\n\nconst float PIXEL_STEP = 255.0 / 16.0;\n\nvec4 getLabelOutlineColor(vec4 color, vec4 sample) {\n  float ps = vPixelSize * PIXEL_STEP;\n  float os = outlineStep;\n\n  float sdf = sample.r - .5 + outlineExpand;\n  vec2  sdfs = vec2(sdf, sdf + os);\n  vec2  alpha = clamp(sdfs * ps + .5, 0.0, 1.0);\n\n  if (alpha.y <= 0.0) {\n    discard;\n  }\n\n  vec3 blend = color.xyz;\n  if (alpha.y > alpha.x) {\n    blend = sqrt(mix(outlineColor * outlineColor, blend * blend, alpha.x));\n  }\n  \n  return vec4(blend, alpha.y * color.a);\n}\n","layer.position":"uniform vec4 layerScale;\nuniform vec4 layerBias;\n\nvec4 layerPosition(vec4 position, inout vec4 stpq) {\n  return layerScale * position + layerBias;\n}\n","lerp.depth":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpDepth(vec4 xyzw) {\n  float x = xyzw.z;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(xyzw.xy, i, xyzw.w);\n  vec4 xyzw2 = vec4(xyzw.xy, i + 1.0, xyzw.w);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","lerp.height":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpHeight(vec4 xyzw) {\n  float x = xyzw.y;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(xyzw.x, i, xyzw.zw);\n  vec4 xyzw2 = vec4(xyzw.x, i + 1.0, xyzw.zw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","lerp.items":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpItems(vec4 xyzw) {\n  float x = xyzw.w;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(xyzw.xyz, i);\n  vec4 xyzw2 = vec4(xyzw.xyz, i + 1.0);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","lerp.width":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpWidth(vec4 xyzw) {\n  float x = xyzw.x;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(i, xyzw.yzw);\n  vec4 xyzw2 = vec4(i + 1.0, xyzw.yzw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","line.position":"// Units and calibration\nuniform float worldUnit;\nuniform float lineWidth;\nuniform float lineDepth;\nuniform float focusDepth;\n\n// General data index\nuniform vec4 geometryClip;\nattribute vec4 position4;\n\n// (Start/mid/end -1/0/1, top/bottom -1,1) \nattribute vec2 line;\n\n// 0...1 for round or bevel joins\n#ifdef LINE_JOIN_DETAIL\nattribute float joint;\n#else\nconst float joint = 0.0;\n#endif\n\n// Knock out excessively long line segments (e.g. for asymtpotes)\n#ifdef LINE_PROXIMITY\nuniform float lineProximity;\nvarying float vClipProximity;\n#endif\n\n// Ghetto line stroking (local only, not global)\n#ifdef LINE_STROKE\nvarying float vClipStrokeWidth;\nvarying float vClipStrokeIndex;\nvarying vec3  vClipStrokeEven;\nvarying vec3  vClipStrokeOdd;\nvarying vec3  vClipStrokePosition;\n#endif\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\n// Clip line ends for arrows / decoration\n#ifdef LINE_CLIP\nuniform float clipRange;\nuniform vec2  clipStyle;\nuniform float clipSpace;\n\nattribute vec2 strip;\n\nvarying vec2 vClipEnds;\n\nvoid clipEnds(vec4 xyzw, vec3 center, vec3 pos) {\n\n  // Sample end of line strip\n  vec4 xyzwE = vec4(strip.y, xyzw.yzw);\n  vec3 end   = getPosition(xyzwE, 0.0);\n\n  // Sample start of line strip\n  vec4 xyzwS = vec4(strip.x, xyzw.yzw);\n  vec3 start = getPosition(xyzwS, 0.0);\n\n  // Measure length\n  vec3 diff = end - start;\n  float l = length(diff) * clipSpace;\n\n  // Arrow length (=2.5x radius)\n  float arrowSize = 1.25 * clipRange * lineWidth * worldUnit;\n\n  vClipEnds = vec2(1.0);\n\n  if (clipStyle.y > 0.0) {\n    // Depth blend end\n    float depth = focusDepth;\n    if (lineDepth < 1.0) {\n      float z = max(0.00001, -end.z);\n      depth = mix(z, focusDepth, lineDepth);\n    }\n    \n    // Absolute arrow length\n    float size = arrowSize * depth;\n\n    // Adjust clip range\n    // Approach linear scaling with cubic ease the smaller we get\n    float mini = clamp(1.0 - l / size * .333, 0.0, 1.0);\n    float scale = 1.0 - mini * mini * mini; \n    float invrange = 1.0 / (size * scale);\n  \n    // Clip end\n    diff = normalize(end - center);\n    float d = dot(end - pos, diff);\n    vClipEnds.x = d * invrange - 1.0;\n  }\n\n  if (clipStyle.x > 0.0) {\n    // Depth blend start\n    float depth = focusDepth;\n    if (lineDepth < 1.0) {\n      float z = max(0.00001, -start.z);\n      depth = mix(z, focusDepth, lineDepth);\n    }\n    \n    // Absolute arrow length\n    float size = arrowSize * depth;\n\n    // Adjust clip range\n    // Approach linear scaling with cubic ease the smaller we get\n    float mini = clamp(1.0 - l / size * .333, 0.0, 1.0);\n    float scale = 1.0 - mini * mini * mini; \n    float invrange = 1.0 / (size * scale);\n  \n    // Clip start \n    diff = normalize(center - start);\n    float d = dot(pos - start, diff);\n    vClipEnds.y = d * invrange - 1.0;\n  }\n\n\n}\n#endif\n\n// Adjust left/center/right to be inside near/far z range\nconst float epsilon = 1e-5;\nvoid fixCenter(inout vec3 left, inout vec3 center, inout vec3 right) {\n  if (center.z >= 0.0) {\n    if (left.z < 0.0) {\n      float d = (center.z + epsilon) / (center.z - left.z);\n      center = mix(center, left, d);\n    }\n    else if (right.z < 0.0) {\n      float d = (center.z + epsilon) / (center.z - right.z);\n      center = mix(center, right, d);\n    }\n  }\n\n  if (left.z >= 0.0) {\n    if (center.z < 0.0) {\n      float d = (left.z + epsilon) / (left.z - center.z);\n      left = mix(left, center, d);\n    }\n  }\n\n  if (right.z >= 0.0) {\n    if (center.z < 0.0) {\n      float d = (right.z + epsilon) / (right.z - center.z);\n      right = mix(right, center, d);\n    }\n  }\n}\n\n// Sample the source data in an edge-aware manner\nvoid getLineGeometry(vec4 xyzw, float edge, out vec3 left, out vec3 center, out vec3 right) {\n  vec4 delta = vec4(1.0, 0.0, 0.0, 0.0);\n\n  center =                 getPosition(xyzw, 1.0);\n  left   = (edge > -0.5) ? getPosition(xyzw - delta, 0.0) : center;\n  right  = (edge < 0.5)  ? getPosition(xyzw + delta, 0.0) : center;\n}\n\n// Calculate the position for a vertex along the line, including joins\nvec3 getLineJoin(float edge, bool odd, vec3 left, vec3 center, vec3 right, float width, float offset, float joint) {\n  vec2 join = vec2(1.0, 0.0);\n\n  fixCenter(left, center, right);\n\n  vec4 a = vec4(left.xy, right.xy);\n  vec4 b = a / vec4(left.zz, right.zz);\n\n  vec2 l = b.xy;\n  vec2 r = b.zw;\n  vec2 c = center.xy / center.z;\n\n  vec4 d = vec4(l, c) - vec4(c, r);\n  float l1 = dot(d.xy, d.xy);\n  float l2 = dot(d.zw, d.zw);\n\n  if (l1 + l2 > 0.0) {\n    \n    if (edge > 0.5 || l2 == 0.0) {\n      vec2 nl = normalize(d.xy);\n      vec2 tl = vec2(nl.y, -nl.x);\n\n#ifdef LINE_PROXIMITY\n      vClipProximity = 1.0;\n#endif\n\n#ifdef LINE_STROKE\n      vClipStrokeEven = vClipStrokeOdd = normalize(left - center);\n#endif\n      join = tl;\n    }\n    else if (edge < -0.5 || l1 == 0.0) {\n      vec2 nr = normalize(d.zw);\n      vec2 tr = vec2(nr.y, -nr.x);\n\n#ifdef LINE_PROXIMITY\n      vClipProximity = 1.0;\n#endif\n\n#ifdef LINE_STROKE\n      vClipStrokeEven = vClipStrokeOdd = normalize(center - right);\n#endif\n      join = tr;\n    }\n    else {\n      // Limit join stretch for tiny segments\n      float lmin2 = min(l1, l2) / (width * width);\n\n      // Hide line segment if ratio of leg lengths exceeds promixity threshold\n#ifdef LINE_PROXIMITY\n      float lr     = l1 / l2;\n      float rl     = l2 / l1;\n      float ratio  = max(lr, rl);\n      float thresh = lineProximity + 1.0;\n      vClipProximity = (ratio > thresh * thresh) ? 1.0 : 0.0;\n#endif\n\n      // Calculate normals/tangents\n      vec2 nl = normalize(d.xy);\n      vec2 nr = normalize(d.zw);\n\n      // Calculate tangents\n      vec2 tl = vec2(nl.y, -nl.x);\n      vec2 tr = vec2(nr.y, -nr.x);\n\n#ifdef LINE_PROXIMITY\n      // Mix tangents according to leg lengths\n      vec2 tc = normalize(mix(tl, tr, l1/(l1+l2)));\n#else\n      // Average tangent\n      vec2 tc = normalize(tl + tr);\n#endif\n    \n      // Miter join\n      float cosA   = dot(nl, tc);\n      float sinA   = max(0.1, abs(dot(tl, tc)));\n      float factor = cosA / sinA;\n      float scale  = sqrt(1.0 + min(lmin2, factor * factor));\n\n      // Stroke normals\n#ifdef LINE_STROKE\n      vec3 stroke1 = normalize(left - center);\n      vec3 stroke2 = normalize(center - right);\n\n      if (odd) {\n        vClipStrokeEven = stroke1;\n        vClipStrokeOdd  = stroke2;\n      }\n      else {\n        vClipStrokeEven = stroke2;\n        vClipStrokeOdd  = stroke1;\n      }\n#endif\n\n#ifdef LINE_JOIN_MITER\n      // Apply straight up miter\n      join = tc * scale;\n#endif\n\n#ifdef LINE_JOIN_ROUND\n      // Slerp bevel join into circular arc\n      float dotProduct = dot(nl, nr);\n      float angle = acos(dotProduct);\n      float sinT  = sin(angle);\n      join = (sin((1.0 - joint) * angle) * tl + sin(joint * angle) * tr) / sinT;\n#endif\n\n#ifdef LINE_JOIN_BEVEL\n      // Direct bevel join between two flat ends\n      float dotProduct = dot(nl, nr);\n      join = mix(tl, tr, joint);\n#endif\n\n#ifdef LINE_JOIN_DETAIL\n      // Check if on inside or outside of joint\n      float crossProduct = nl.x * nr.y - nl.y * nr.x;\n      if (offset * crossProduct < 0.0) {\n        // For near-180-degree bends, correct back to a miter to avoid discontinuities\n        float ratio = clamp(-dotProduct * 2.0 - 1.0, 0.0, 1.0);\n        // Otherwise collapse the inside vertices into one.\n        join = mix(tc * scale, join, ratio * ratio * ratio);\n      }\n#endif\n\n    }\n    return vec3(join, 0.0);\n  }\n  else {\n    return vec3(0.0);\n  }\n\n}\n\n// Calculate final line position\nvec3 getLinePosition() {\n  vec3 left, center, right, join;\n\n  // left/center/right\n  float edge = line.x;\n  // up/down\n  float offset = line.y;\n\n  // Clip data\n  vec4 p = min(geometryClip, position4);\n  edge += max(0.0, position4.x - geometryClip.x);\n\n  // Get position + adjacent neighbours\n  getLineGeometry(p, edge, left, center, right);\n\n#ifdef LINE_STROKE\n  // Set parameters for line stroke fragment shader\n  vClipStrokePosition = center;\n  vClipStrokeIndex = p.x;\n  bool odd = mod(p.x, 2.0) >= 1.0;\n#else\n  bool odd = true;\n#endif\n\n  // Divide line width up/down\n  float width = lineWidth * 0.5;\n\n  float depth = focusDepth;\n  if (lineDepth < 1.0) {\n    // Depth blending\n    float z = max(0.00001, -center.z);\n    depth = mix(z, focusDepth, lineDepth);\n  }\n  width *= depth;\n\n  // Convert to world units\n  width *= worldUnit;\n\n  // Calculate line join\n  join = getLineJoin(edge, odd, left, center, right, width, offset, joint);\n  vec3 pos = center + join * offset * width;\n\n#ifdef LINE_STROKE\n  vClipStrokeWidth = width;\n#endif\n\n#ifdef LINE_CLIP\n  clipEnds(p, center, pos);\n#endif\n\n  return pos;\n}\n","map.2d.data":"uniform vec2 dataResolution;\nuniform vec2 dataPointer;\n\nvec2 map2DData(vec2 xy) {\n  return (xy + dataPointer) * dataResolution;\n}\n","map.2d.data.wrap":"uniform vec2 dataResolution;\nuniform vec2 dataPointer;\n\nvec2 map2DData(vec2 xy) {\n  return fract((xy + dataPointer) * dataResolution);\n}\n","map.xyzw.2dv":"void mapXyzw2DV(vec4 xyzw, out vec2 xy, out float z) {\n  xy = xyzw.xy;\n  z  = xyzw.z;\n}\n\n","map.xyzw.align":"vec4 alignXYZW(vec4 xyzw) {\n  return floor(xyzw + .5);\n}\n\n","map.xyzw.texture":"uniform float textureItems;\nuniform float textureHeight;\n\nvec2 mapXyzwTexture(vec4 xyzw) {\n  \n  float x = xyzw.x;\n  float y = xyzw.y;\n  float z = xyzw.z;\n  float i = xyzw.w;\n  \n  return vec2(i, y) + vec2(x, z) * vec2(textureItems, textureHeight);\n}\n\n","mesh.fragment.color":"varying vec4 vColor;\n\nvec4 getColor() {\n  return vColor;\n}\n","mesh.fragment.map":"#ifdef POSITION_STPQ\nvarying vec4 vSTPQ;\n#endif\n#ifdef POSITION_U\nvarying float vU;\n#endif\n#ifdef POSITION_UV\nvarying vec2 vUV;\n#endif\n#ifdef POSITION_UVW\nvarying vec3 vUVW;\n#endif\n#ifdef POSITION_UVWO\nvarying vec4 vUVWO;\n#endif\n\nvec4 getSample(vec4 uvwo, vec4 stpq);\n\nvec4 getMapColor() {\n  #ifdef POSITION_STPQ\n  vec4 stpq = vSTPQ;\n  #else\n  vec4 stpq = vec4(0.0);\n  #endif\n\n  #ifdef POSITION_U\n  vec4 uvwo = vec4(vU, 0.0, 0.0, 0.0);\n  #endif\n  #ifdef POSITION_UV\n  vec4 uvwo = vec4(vUV, 0.0, 0.0);\n  #endif\n  #ifdef POSITION_UVW\n  vec4 uvwo = vec4(vUVW, 0.0);\n  #endif\n  #ifdef POSITION_UVWO\n  vec4 uvwo = vec4(vUVWO);\n  #endif\n\n  return getSample(uvwo, stpq);\n}\n","mesh.fragment.mask":"varying float vMask;\n\nfloat ease(float t) {\n  t = clamp(t, 0.0, 1.0);\n  return t * t * (3.0 - 2.0 * t);\n}\n\nvec4 maskColor() {\n  if (vMask <= 0.0) discard;\n  return vec4(vec3(1.0), ease(vMask));\n}\n","mesh.fragment.material":"#ifdef POSITION_STPQ\nvarying vec4 vSTPQ;\n#endif\n#ifdef POSITION_U\nvarying float vU;\n#endif\n#ifdef POSITION_UV\nvarying vec2 vUV;\n#endif\n#ifdef POSITION_UVW\nvarying vec3 vUVW;\n#endif\n#ifdef POSITION_UVWO\nvarying vec4 vUVWO;\n#endif\n\nvec4 getSample(vec4 rgba, vec4 stpq);\n\nvec4 getMaterialColor(vec4 rgba) {\n  vec4 stpq = vec4(0.0);\n\n  #ifdef POSITION_U\n  stpq.x = vU;\n  #endif\n  #ifdef POSITION_UV\n  stpq.xy = vUV;\n  #endif\n  #ifdef POSITION_UVW\n  stpq.xyz = vUVW;\n  #endif\n  #ifdef POSITION_UVWO\n  stpq = vUVWO;\n  #endif\n\n  #ifdef POSITION_STPQ\n  stpq = vSTPQ;\n  #endif\n\n  return getSample(rgba, stpq);\n}\n","mesh.fragment.shaded":"varying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvec3 offSpecular(vec3 color) {\n  vec3 c = 1.0 - color;\n  return 1.0 - c * c;\n}\n\nvec4 getShadedColor(vec4 rgba) {\n  \n  vec3 color = rgba.xyz;\n  vec3 color2 = offSpecular(rgba.xyz);\n\n  vec3 normal = normalize(vNormal);\n  vec3 light = normalize(vLight);\n  vec3 position = normalize(vPosition);\n  \n  float side    = gl_FrontFacing ? -1.0 : 1.0;\n  float cosine  = side * dot(normal, light);\n  float diffuse = mix(max(0.0, cosine), .5 + .5 * cosine, .1);\n  \n  vec3  halfLight = normalize(light + position);\n	float cosineHalf = max(0.0, side * dot(normal, halfLight));\n	float specular = pow(cosineHalf, 16.0);\n	\n	return vec4(color * (diffuse * .9 + .05) + .25 * color2 * specular, rgba.a);\n}\n","mesh.fragment.texture":"","mesh.gamma.in":"vec4 getGammaInColor(vec4 rgba) {\n  return vec4(rgba.rgb * rgba.rgb, rgba.a);\n}\n","mesh.gamma.out":"vec4 getGammaOutColor(vec4 rgba) {\n  return vec4(sqrt(rgba.rgb), rgba.a);\n}\n","mesh.map.uvwo":"vec4 mapUVWO(vec4 uvwo, vec4 stpq) {\n  return uvwo;\n}\n","mesh.position":"uniform vec4 geometryClip;\nattribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getMeshPosition() {\n  vec4 p = min(geometryClip, position4);\n  return getPosition(p, 1.0);\n}\n","mesh.vertex.color":"attribute vec4 position4;\nuniform vec4 geometryClip;\nvarying vec4 vColor;\n\n// External\nvec4 getSample(vec4 xyzw);\n\nvoid vertexColor() {\n  vec4 p = min(geometryClip, position4);\n  vColor = getSample(p);\n}\n","mesh.vertex.mask":"attribute vec4 position4;\nuniform vec4 geometryResolution;\nuniform vec4 geometryClip;\nvarying float vMask;\n\n// External\nfloat getSample(vec4 xyzw);\n\nvoid maskLevel() {\n  vec4 p = min(geometryClip, position4);\n  vMask = getSample(p * geometryResolution);\n}\n","mesh.vertex.position":"uniform vec4 geometryResolution;\n\n#ifdef POSITION_STPQ\nvarying vec4 vSTPQ;\n#endif\n#ifdef POSITION_U\nvarying float vU;\n#endif\n#ifdef POSITION_UV\nvarying vec2 vUV;\n#endif\n#ifdef POSITION_UVW\nvarying vec3 vUVW;\n#endif\n#ifdef POSITION_UVWO\nvarying vec4 vUVWO;\n#endif\n\n// External\nvec3 getPosition(vec4 xyzw, in vec4 stpqIn, out vec4 stpqOut);\n\nvec3 getMeshPosition(vec4 xyzw, float canonical) {\n  vec4 stpqOut, stpqIn = xyzw * geometryResolution;\n  vec3 xyz = getPosition(xyzw, stpqIn, stpqOut);\n\n  #ifdef POSITION_MAP\n  if (canonical > 0.5) {\n    #ifdef POSITION_STPQ\n    vSTPQ = stpqOut;\n    #endif\n    #ifdef POSITION_U\n    vU = stpqOut.x;\n    #endif\n    #ifdef POSITION_UV\n    vUV = stpqOut.xy;\n    #endif\n    #ifdef POSITION_UVW\n    vUVW = stpqOut.xyz;\n    #endif\n    #ifdef POSITION_UVWO\n    vUVWO = stpqOut;\n    #endif\n  }\n  #endif\n  return xyz;\n}\n","move.position":"uniform float transitionEnter;\nuniform float transitionExit;\nuniform vec4  transitionScale;\nuniform vec4  transitionBias;\nuniform float transitionSkew;\nuniform float transitionActive;\n\nuniform vec4  moveFrom;\nuniform vec4  moveTo;\n\nfloat ease(float t) {\n  t = clamp(t, 0.0, 1.0);\n  return 1.0 - (2.0 - t) * t;\n}\n\nvec4 getTransitionPosition(vec4 xyzw, inout vec4 stpq) {\n  if (transitionActive < 0.5) return xyzw;\n\n  float enter   = transitionEnter;\n  float exit    = transitionExit;\n  float skew    = transitionSkew;\n  vec4  scale   = transitionScale;\n  vec4  bias    = transitionBias;\n\n  float factor  = 1.0 + skew;\n  float offset  = dot(vec4(1.0), stpq * scale + bias);\n\n  float a1 = ease(enter * factor - offset);\n  float a2 = ease(exit  * factor + offset - skew);\n\n  return xyzw + a1 * moveFrom + a2 * moveTo;\n}","object.mask.default":"vec4 getMask(vec4 xyzw) {\n  return vec4(1.0);\n}","point.alpha.circle":"varying float vPixelSize;\n\nfloat getDiscAlpha(float mask) {\n  // Approximation: 1 - x*x is approximately linear around x = 1 with slope 2\n  return vPixelSize * (1.0 - mask);\n  //  return vPixelSize * 2.0 * (1.0 - sqrt(mask));\n}\n","point.alpha.circle.hollow":"varying float vPixelSize;\n\nfloat getDiscHollowAlpha(float mask) {\n  return vPixelSize * (0.5 - 2.0 * abs(sqrt(mask) - .75));\n}\n","point.alpha.generic":"varying float vPixelSize;\n\nfloat getGenericAlpha(float mask) {\n  return vPixelSize * 2.0 * (1.0 - mask);\n}\n","point.alpha.generic.hollow":"varying float vPixelSize;\n\nfloat getGenericHollowAlpha(float mask) {\n  return vPixelSize * (0.5 - 2.0 * abs(mask - .75));\n}\n","point.edge":"varying vec2 vSprite;\n\nfloat getSpriteMask(vec2 xy);\nfloat getSpriteAlpha(float mask);\n\nvoid setFragmentColorFill(vec4 color) {\n  float mask = getSpriteMask(vSprite);\n  if (mask > 1.0) {\n    discard;\n  }\n  float alpha = getSpriteAlpha(mask);\n  if (alpha >= 1.0) {\n    discard;\n  }\n  gl_FragColor = vec4(color.rgb, alpha * color.a);\n}\n","point.fill":"varying vec2 vSprite;\n\nfloat getSpriteMask(vec2 xy);\nfloat getSpriteAlpha(float mask);\n\nvoid setFragmentColorFill(vec4 color) {\n  float mask = getSpriteMask(vSprite);\n  if (mask > 1.0) {\n    discard;\n  }\n  float alpha = getSpriteAlpha(mask);\n  if (alpha < 1.0) {\n    discard;\n  }\n  gl_FragColor = color;\n}\n\n","point.mask.circle":"varying float vPixelSize;\n\nfloat getCircleMask(vec2 uv) {\n  return dot(uv, uv);\n}\n","point.mask.diamond":"varying float vPixelSize;\n\nfloat getDiamondMask(vec2 uv) {\n  vec2 a = abs(uv);\n  return a.x + a.y;\n}\n","point.mask.down":"varying float vPixelSize;\n\nfloat getTriangleDownMask(vec2 uv) {\n  uv.y += .25;\n  return max(uv.y, abs(uv.x) * .866 - uv.y * .5 + .6);\n}\n","point.mask.left":"varying float vPixelSize;\n\nfloat getTriangleLeftMask(vec2 uv) {\n  uv.x += .25;\n  return max(uv.x, abs(uv.y) * .866 - uv.x * .5 + .6);\n}\n","point.mask.right":"varying float vPixelSize;\n\nfloat getTriangleRightMask(vec2 uv) {\n  uv.x -= .25;\n  return max(-uv.x, abs(uv.y) * .866 + uv.x * .5 + .6);\n}\n","point.mask.square":"varying float vPixelSize;\n\nfloat getSquareMask(vec2 uv) {\n  vec2 a = abs(uv);\n  return max(a.x, a.y);\n}\n","point.mask.up":"varying float vPixelSize;\n\nfloat getTriangleUpMask(vec2 uv) {\n  uv.y -= .25;\n  return max(-uv.y, abs(uv.x) * .866 + uv.y * .5 + .6);\n}\n","point.position":"uniform float pointDepth;\n\nuniform float pixelUnit;\nuniform float renderScale;\nuniform float renderScaleInv;\nuniform float focusDepth;\n\nuniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec2 sprite;\n\nvarying vec2 vSprite;\nvarying float vPixelSize;\n\nconst float pointScale = POINT_SHAPE_SCALE;\n\n// External\nfloat getPointSize(vec4 xyzw);\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getPointPosition() {\n  vec4 p = min(geometryClip, position4);\n  vec3 center = getPosition(p, 1.0);\n\n  // Depth blending\n  // TODO: orthographic camera\n  // Workaround: set depth = 0\n  float z = -center.z;\n  float depth = mix(z, focusDepth, pointDepth);\n  \n  // Match device/unit mapping \n  // Sprite goes from -1..1, width = 2.\n  float pointSize = getPointSize(p);\n  float size = pointScale * pointSize * pixelUnit * .5;\n  float depthSize = depth * size;\n  \n  // Pad sprite by half a pixel to make the anti-aliasing straddle the pixel edge\n  // Note: pixelsize measures radius\n  float pixelSize = .5 * (pointDepth > 0.0 ? depthSize / z : size);\n  float paddedSize = pixelSize + 0.5;\n  float padFactor = paddedSize / pixelSize;\n\n  vPixelSize = paddedSize;\n  vSprite    = sprite;\n\n  return center + vec3(sprite * depthSize * renderScaleInv * padFactor, 0.0);\n}\n","point.size.uniform":"uniform float pointSize;\n\nfloat getPointSize(vec4 xyzw) {\n  return pointSize;\n}","point.size.varying":"uniform float pointSize;\n\nvec4 getSample(vec4 xyzw);\n\nfloat getPointSize(vec4 xyzw) {\n  return pointSize * getSample(xyzw).x;\n}","polar.position":"uniform float polarBend;\nuniform float polarFocus;\nuniform float polarAspect;\nuniform float polarHelix;\n\nuniform mat4 viewMatrix;\n\nvec4 getPolarPosition(vec4 position, inout vec4 stpq) {\n  if (polarBend > 0.0) {\n\n    if (polarBend < 0.001) {\n      // Factor out large addition/subtraction of polarFocus\n      // to avoid numerical error\n      // sin(x) ~ x\n      // cos(x) ~ 1 - x * x / 2\n      vec2 pb = position.xy * polarBend;\n      float ppbbx = pb.x * pb.x;\n      return viewMatrix * vec4(\n        position.x * (1.0 - polarBend + (pb.y * polarAspect)),\n        position.y * (1.0 - .5 * ppbbx) - (.5 * ppbbx) * polarFocus / polarAspect,\n        position.z + position.x * polarHelix * polarBend,\n        1.0\n      );\n    }\n    else {\n      vec2 xy = position.xy * vec2(polarBend, polarAspect);\n      float radius = polarFocus + xy.y;\n      return viewMatrix * vec4(\n        sin(xy.x) * radius,\n        (cos(xy.x) * radius - polarFocus) / polarAspect,\n        position.z + position.x * polarHelix * polarBend,\n        1.0\n      );\n    }\n  }\n  else {\n    return viewMatrix * vec4(position.xyz, 1.0);\n  }\n}",
"project.position":"uniform float styleZBias;\nuniform float styleZIndex;\n\nvoid setPosition(vec3 position) {\n  vec4 pos = projectionMatrix * vec4(position, 1.0);\n\n  // Apply relative Z bias\n  float bias  = (1.0 - styleZBias / 32768.0);\n  pos.z *= bias;\n  \n  // Apply large scale Z index changes\n  if (styleZIndex > 0.0) {\n    float z = pos.z / pos.w;\n    pos.z = ((z + 1.0) / (styleZIndex + 1.0) - 1.0) * pos.w;\n  }\n  \n  gl_Position = pos;\n}","project.readback":"// This is three.js' global uniform, missing from fragment shaders.\nuniform mat4 projectionMatrix;\n\nvec4 readbackPosition(vec3 position, vec4 stpq) {\n  vec4 pos = projectionMatrix * vec4(position, 1.0);\n  vec3 final = pos.xyz / pos.w;\n  if (final.z < -1.0) {\n    return vec4(0.0, 0.0, 0.0, -1.0);\n  }\n  else {\n    return vec4(final, -position.z);\n  }\n}\n","raw.position.scale":"uniform vec4 geometryScale;\nattribute vec4 position4;\n\nvec4 getRawPositionScale() {\n  return geometryScale * position4;\n}\n","repeat.position":"uniform vec4 repeatModulus;\n\nvec4 getRepeatXYZW(vec4 xyzw) {\n  return mod(xyzw + .5, repeatModulus) - .5;\n}\n","resample.padding":"uniform vec4 resampleBias;\n\nvec4 resamplePadding(vec4 xyzw) {\n  return xyzw + resampleBias;\n}","resample.relative":"uniform vec4 resampleFactor;\n\nvec4 resampleRelative(vec4 xyzw) {\n  return xyzw * resampleFactor;\n}","reveal.mask":"uniform float transitionEnter;\nuniform float transitionExit;\nuniform vec4  transitionScale;\nuniform vec4  transitionBias;\nuniform float transitionSkew;\nuniform float transitionActive;\n\nfloat getTransitionSDFMask(vec4 stpq) {\n  if (transitionActive < 0.5) return 1.0;\n\n  float enter   = transitionEnter;\n  float exit    = transitionExit;\n  float skew    = transitionSkew;\n  vec4  scale   = transitionScale;\n  vec4  bias    = transitionBias;\n\n  float factor  = 1.0 + skew;\n  float offset  = dot(vec4(1.0), stpq * scale + bias);\n\n  vec2 d = vec2(enter, exit) * factor + vec2(-offset, offset - skew);\n  if (exit  == 1.0) return d.x;\n  if (enter == 1.0) return d.y;\n  return min(d.x, d.y);\n}","root.position":"vec3 getRootPosition(vec4 position, in vec4 stpqIn, out vec4 stpqOut) {\n  stpqOut = stpqIn; // avoid inout confusion\n  return position.xyz;\n}","sample.2d":"uniform sampler2D dataTexture;\n\nvec4 sample2D(vec2 uv) {\n  return texture2D(dataTexture, uv);\n}\n","scale.position":"uniform vec4 scaleAxis;\nuniform vec4 scaleOffset;\n\nvec4 sampleData(float x);\n\nvec4 getScalePosition(vec4 xyzw) {\n  return scaleAxis * sampleData(xyzw.x).x + scaleOffset;\n}\n","screen.map.stpq":"uniform vec4 remapSTPQScale;\n\nvec4 screenMapSTPQ(vec4 xyzw, out vec4 stpq) {\n  stpq = xyzw * remapSTPQScale;\n  return xyzw;\n}\n","screen.map.xy":"uniform vec2 remapUVScale;\n\nvec4 screenMapXY(vec4 uvwo, vec4 stpq) {\n  return vec4(floor(remapUVScale * uvwo.xy), 0.0, 0.0);\n}\n","screen.map.xyzw":"uniform vec2 remapUVScale;\nuniform vec2 remapModulus;\nuniform vec2 remapModulusInv;\n\nvec4 screenMapXYZW(vec4 uvwo, vec4 stpq) {\n  vec2 st = floor(remapUVScale * uvwo.xy);\n  vec2 xy = st * remapModulusInv;\n  vec2 ixy = floor(xy);\n  vec2 fxy = xy - ixy;\n  vec2 zw = fxy * remapModulus;\n  return vec4(ixy.x, zw.y, ixy.y, zw.x);\n}\n","screen.pass.uv":"vec2 screenPassUV(vec4 uvwo, vec4 stpq) {\n  return uvwo.xy;\n}\n","screen.position":"void setScreenPosition(vec4 position) {\n  gl_Position = vec4(position.xy * 2.0 - 1.0, 0.5, 1.0);\n}\n","slice.position":"uniform vec4 sliceOffset;\n\nvec4 getSliceOffset(vec4 xyzw) {\n  return xyzw + sliceOffset;\n}\n","spherical.position":"uniform float sphericalBend;\nuniform float sphericalFocus;\nuniform float sphericalAspectX;\nuniform float sphericalAspectY;\nuniform float sphericalScaleY;\n\nuniform mat4 viewMatrix;\n\nvec4 getSphericalPosition(vec4 position, inout vec4 stpq) {\n  if (sphericalBend > 0.0001) {\n\n    vec3 xyz = position.xyz * vec3(sphericalBend, sphericalBend / sphericalAspectY * sphericalScaleY, sphericalAspectX);\n    float radius = sphericalFocus + xyz.z;\n    float cosine = cos(xyz.y) * radius;\n\n    return viewMatrix * vec4(\n      sin(xyz.x) * cosine,\n      sin(xyz.y) * radius * sphericalAspectY,\n      (cos(xyz.x) * cosine - sphericalFocus) / sphericalAspectX,\n      1.0\n    );\n  }\n  else {\n    return viewMatrix * vec4(position.xyz, 1.0);\n  }\n}","split.position":"uniform float splitStride;\n\nvec2 getIndices(vec4 xyzw);\nvec4 getRest(vec4 xyzw);\nvec4 injectIndex(float v);\n\nvec4 getSplitXYZW(vec4 xyzw) {\n  vec2 uv = getIndices(xyzw);\n  float offset = uv.x + uv.y * splitStride;\n  return injectIndex(offset) + getRest(xyzw);\n}\n","spread.position":"uniform vec4 spreadOffset;\nuniform mat4 spreadMatrix;\n\n// External\nvec4 getSample(vec4 xyzw);\n\nvec4 getSpreadSample(vec4 xyzw) {\n  vec4 sample = getSample(xyzw);\n  return sample + spreadMatrix * (spreadOffset + xyzw);\n}\n","sprite.fragment":"varying vec2 vSprite;\n\nvec4 getSample(vec2 xy);\n\nvec4 getSpriteColor() {\n  return getSample(vSprite);\n}","sprite.position":"uniform vec2 spriteOffset;\nuniform float spriteScale;\nuniform float spriteDepth;\nuniform float spriteSnap;\n\nuniform vec2 renderOdd;\nuniform float renderScale;\nuniform float renderScaleInv;\nuniform float pixelUnit;\nuniform float focusDepth;\n\nuniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec2 sprite;\n\nvarying float vPixelSize;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\nvec4 getSprite(vec4 xyzw);\n\nvec3 getSpritePosition() {\n  // Clip points\n  vec4 p = min(geometryClip, position4);\n  float diff = length(position4 - p);\n  if (diff > 0.0) {\n    return vec3(0.0, 0.0, 1000.0);\n  }\n\n  // Make sprites\n  vec3 center = getPosition(p, 1.0);\n  vec4 atlas = getSprite(p);\n\n  // Sprite goes from -1..1, width = 2.\n  // -1..1 -> -0.5..0.5\n  vec2 halfSprite = sprite * .5;\n  vec2 halfFlipSprite = vec2(halfSprite.x, -halfSprite.y);\n\n#ifdef POSITION_UV\n  // Assign UVs\n  vUV = atlas.xy + atlas.zw * (halfFlipSprite + .5);\n#endif\n\n  // Depth blending\n  // TODO: orthographic camera\n  // Workaround: set depth = 0\n  float depth = focusDepth, z;\n  z = -center.z;\n  if (spriteDepth < 1.0) {\n    depth = mix(z, focusDepth, spriteDepth);\n  }\n  \n  // Match device/unit mapping \n  float size = pixelUnit * spriteScale;\n  float depthSize = depth * size;\n\n  // Calculate pixelSize for anti-aliasing\n  float pixelSize = (spriteDepth > 0.0 ? depthSize / z : size);\n  vPixelSize = pixelSize;\n\n  // Position sprite\n  vec2 atlasOdd = fract(atlas.zw / 2.0);\n  vec2 offset = (spriteOffset + halfSprite * atlas.zw) * depthSize;\n  if (spriteSnap > 0.5) {\n    // Snap to pixel (w/ epsilon shift to avoid jitter)\n    return vec3(((floor(center.xy / center.z * renderScale + 0.001) + renderOdd + atlasOdd) * center.z + offset) * renderScaleInv, center.z);\n  }\n  else {\n    // Place directly\n    return center + vec3(offset * renderScaleInv, 0.0);\n  }\n\n}\n","stereographic.position":"uniform float stereoBend;\n\nuniform mat4 viewMatrix;\n\nvec4 getStereoPosition(vec4 position, inout vec4 stpq) {\n  if (stereoBend > 0.0001) {\n\n    vec3 pos = position.xyz;\n    float r = length(pos);\n    float z = r + pos.z;\n    vec3 project = vec3(pos.xy / z, r);\n    \n    vec3 lerped = mix(pos, project, stereoBend);\n\n    return viewMatrix * vec4(lerped, 1.0);\n  }\n  else {\n    return viewMatrix * vec4(position.xyz, 1.0);\n  }\n}","stereographic4.position":"uniform float stereoBend;\nuniform vec4 basisScale;\nuniform vec4 basisOffset;\nuniform mat4 viewMatrix;\nuniform vec2 view4D;\n\nvec4 getStereographic4Position(vec4 position, inout vec4 stpq) {\n  \n  vec4 transformed;\n  if (stereoBend > 0.0001) {\n\n    float r = length(position);\n    float w = r + position.w;\n    vec4 project = vec4(position.xyz / w, r);\n    \n    transformed = mix(position, project, stereoBend);\n  }\n  else {\n    transformed = position;\n  }\n\n  vec4 pos4 = transformed * basisScale - basisOffset;\n  vec3 xyz = (viewMatrix * vec4(pos4.xyz, 1.0)).xyz;\n  return vec4(xyz, pos4.w * view4D.y + view4D.x);\n}\n","stpq.sample.2d":"varying vec2 vST;\n\nvec4 getSample(vec2 st);\n\nvec4 getSTSample() {\n  return getSample(vST);\n}\n","stpq.xyzw.2d":"varying vec2 vUV;\n\nvoid setRawUV(vec4 xyzw) {\n  vUV = xyzw.xy;\n}\n","strip.position.normal":"uniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec3 strip;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvarying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvoid getStripGeometry(vec4 xyzw, vec3 strip, out vec3 pos, out vec3 normal) {\n  vec3 a, b, c;\n\n  a   = getPosition(xyzw, 1.0);\n  b   = getPosition(vec4(xyzw.xyz, strip.x), 0.0);\n  c   = getPosition(vec4(xyzw.xyz, strip.y), 0.0);\n\n  normal = normalize(cross(c - a, b - a)) * strip.z;\n  \n  pos = a;\n}\n\nvec3 getStripPositionNormal() {\n  vec3 center, normal;\n\n  vec4 p = min(geometryClip, position4);\n\n  getStripGeometry(p, strip, center, normal);\n  vNormal   = normal;\n  vLight    = normalize((viewMatrix * vec4(1.0, 2.0, 2.0, 0.0)).xyz);\n  vPosition = -center;\n\n  return center;\n}\n","style.color":"uniform vec3 styleColor;\nuniform float styleOpacity;\n\nvec4 getStyleColor() {\n  return vec4(styleColor, styleOpacity);\n}\n","subdivide.depth":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideDepth(vec4 xyzw) {\n  float x = xyzw.z;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(xyzw.xy, i + g, xyzw.w));\n}\n","subdivide.depth.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideDepthLerp(vec4 xyzw) {\n  float x = xyzw.z;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(xyzw.xy, i, xyzw.w);\n  vec4 xyzw2 = vec4(xyzw.xy, i + 1.0, xyzw.w);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","subdivide.height":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideHeight(vec4 xyzw) {\n  float x = xyzw.y;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(xyzw.x, i + g, xyzw.zw));\n}\n","subdivide.height.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideHeightLerp(vec4 xyzw) {\n  float x = xyzw.y;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(xyzw.x, i, xyzw.zw);\n  vec4 xyzw2 = vec4(xyzw.x, i + 1.0, xyzw.zw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","subdivide.items":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideItems(vec4 xyzw) {\n  float x = xyzw.w;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(xyzw.xyz, i + g));\n}\n","subdivide.items.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideItemsLerp(vec4 xyzw) {\n  float x = xyzw.w;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(xyzw.xyz, i);\n  vec4 xyzw2 = vec4(xyzw.xyz, i + 1.0);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","subdivide.width":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideWidth(vec4 xyzw) {\n  float x = xyzw.x;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(i + g, xyzw.yzw));\n}\n","subdivide.width.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideWidthLerp(vec4 xyzw) {\n  float x = xyzw.x;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(i, xyzw.yzw);\n  vec4 xyzw2 = vec4(i + 1.0, xyzw.yzw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","surface.mask.hollow":"attribute vec4 position4;\n\nfloat getSurfaceHollowMask(vec4 xyzw) {\n  vec4 df = abs(fract(position4) - .5);\n  vec2 df2 = min(df.xy, df.zw);\n  float df3 = min(df2.x, df2.y);\n  return df3;\n}","surface.position":"uniform vec4 geometryClip;\nuniform vec4 geometryResolution;\nuniform vec4 mapSize;\n\nattribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getSurfacePosition() {\n  vec4 p = min(geometryClip, position4);\n  vec3 xyz = getPosition(p, 1.0);\n\n  // Overwrite UVs\n#ifdef POSITION_UV\n#ifdef POSITION_UV_INT\n  vUV = -.5 + (position4.xy * geometryResolution.xy) * mapSize.xy;\n#else\n  vUV = position4.xy * geometryResolution.xy;\n#endif\n#endif\n\n  return xyz;\n}\n","surface.position.normal":"uniform vec4 mapSize;\nuniform vec4 geometryResolution;\nuniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec2 surface;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvoid getSurfaceGeometry(vec4 xyzw, float edgeX, float edgeY, out vec3 left, out vec3 center, out vec3 right, out vec3 up, out vec3 down) {\n  vec4 deltaX = vec4(1.0, 0.0, 0.0, 0.0);\n  vec4 deltaY = vec4(0.0, 1.0, 0.0, 0.0);\n\n  /*\n  // high quality, 5 tap\n  center =                  getPosition(xyzw, 1.0);\n  left   = (edgeX > -0.5) ? getPosition(xyzw - deltaX, 0.0) : center;\n  right  = (edgeX < 0.5)  ? getPosition(xyzw + deltaX, 0.0) : center;\n  down   = (edgeY > -0.5) ? getPosition(xyzw - deltaY, 0.0) : center;\n  up     = (edgeY < 0.5)  ? getPosition(xyzw + deltaY, 0.0) : center;\n  */\n  \n  // low quality, 3 tap\n  center =                  getPosition(xyzw, 1.0);\n  left   =                  center;\n  down   =                  center;\n  right  = (edgeX < 0.5)  ? getPosition(xyzw + deltaX, 0.0) : (2.0 * center - getPosition(xyzw - deltaX, 0.0));\n  up     = (edgeY < 0.5)  ? getPosition(xyzw + deltaY, 0.0) : (2.0 * center - getPosition(xyzw - deltaY, 0.0));\n}\n\nvec3 getSurfaceNormal(vec3 left, vec3 center, vec3 right, vec3 up, vec3 down) {\n  vec3 dx = right - left;\n  vec3 dy = up    - down;\n  vec3 n = cross(dy, dx);\n  if (length(n) > 0.0) {\n    return normalize(n);\n  }\n  return vec3(0.0, 1.0, 0.0);\n}\n\nvarying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvec3 getSurfacePositionNormal() {\n  vec3 left, center, right, up, down;\n\n  vec4 p = min(geometryClip, position4);\n\n  getSurfaceGeometry(p, surface.x, surface.y, left, center, right, up, down);\n  vNormal   = getSurfaceNormal(left, center, right, up, down);\n  vLight    = normalize((viewMatrix * vec4(1.0, 2.0, 2.0, 0.0)).xyz); // hardcoded directional light\n  vPosition = -center;\n\n#ifdef POSITION_UV\n#ifdef POSITION_UV_INT\n  vUV = -.5 + (position4.xy * geometryResolution.xy) * mapSize.xy;\n#else\n  vUV = position4.xy * geometryResolution.xy;\n#endif\n#endif\n  \n  return center;\n}\n","ticks.position":"uniform float worldUnit;\nuniform float focusDepth;\nuniform float tickSize;\nuniform float tickEpsilon;\nuniform vec3  tickNormal;\nuniform vec2  tickStrip;\n\nvec4 getSample(vec4 xyzw);\n\nvec3 transformPosition(vec4 position, in vec4 stpqIn, out vec4 stpqOut);\n\nvec3 getTickPosition(vec4 xyzw, in vec4 stpqIn, out vec4 stpqOut) {\n  float epsilon = tickEpsilon;\n\n  // determine tick direction\n  float leftX  = max(tickStrip.x, xyzw.y - 1.0);\n  float rightX = min(tickStrip.y, xyzw.y + 1.0);\n  \n  vec4 left    = getSample(vec4(leftX,  xyzw.zw, 0.0));\n  vec4 right   = getSample(vec4(rightX, xyzw.zw, 0.0));\n  vec4 diff    = right - left;\n\n  vec3 normal  = cross(normalize(diff.xyz + vec3(diff.w)), tickNormal);\n  float bias   = max(0.0, 1.0 - length(normal) * 2.0);\n       normal  = mix(normal, tickNormal.yzx, bias * bias);\n  \n  // transform (point) and (point + delta)\n  vec4 center  = getSample(vec4(xyzw.yzw, 0.0));\n  vec4 delta   = vec4(normal, 0.0) * epsilon;\n\n  vec4 a = center;\n  vec4 b = center + delta;\n\n  vec4 _;\n  vec3 c = transformPosition(a, stpqIn, stpqOut);\n  vec3 d = transformPosition(b, stpqIn, _);\n  \n  // sample on either side to create line\n  float line = xyzw.x - .5;\n  vec3  mid  = c;\n  vec3  side = normalize(d - c);\n\n  return mid + side * line * tickSize * worldUnit * focusDepth;\n}\n","transform3.position":"uniform mat4 transformMatrix;\n\nvec4 transformPosition(vec4 position, inout vec4 stpq) {\n  return transformMatrix * vec4(position.xyz, 1.0);\n}\n","transform4.position":"uniform mat4 transformMatrix;\nuniform vec4 transformOffset;\n\nvec4 transformPosition(vec4 position, inout vec4 stpq) {\n  return transformMatrix * position + transformOffset;\n}\n","view.position":"// Implicit three.js uniform\n// uniform mat4 viewMatrix;\n\nvec4 getViewPosition(vec4 position, inout vec4 stpq) {\n  return (viewMatrix * vec4(position.xyz, 1.0));\n}\n"}},{}],2:[function(t,e,n){function r(t){return function(e){return s(e,i(t))}}function i(t){for(var e in t)o(t,e)&&(t[e]=Function("return function(node, attr) { return node."+t[e]+" }"),t[e]=t[e]());return t}function o(t,e){return t.hasOwnProperty(e)&&"string"==typeof t[e]}function s(t,e){function n(t){var e;return"comma"===t.type?void _.unshift(y=[]):"op"===t.type||"any-child"===t.type?(y.unshift(v[t.data]),void y.unshift(i())):(y[0]=y[0]||i(),e=y[0],"!"===t.type?void(e.subject=_[0].subject=!0):void e.push("class"===t.type?o(t.type,t.data):"attr"===t.type?s(t):":"===t.type||"::"===t.type?m(t):"*"===t.type?Boolean:l(t.type,t.data)))}function r(t,e){function n(t){for(var e;t.length;)e=t.shift(),-1===u.indexOf(e)&&u.push(e)}var r,i,o,s,u;o=t,u=[];for(var l=0,p=_.length;p>l;++l){y=_[l],r=a,i=y.length,t=o,s=[];for(var h=0;i>h&&(t=r(t,y[h],s),t);h+=2)r=y[h+1];if(h>=i){if(e)return!0;n(y.subject?s:[o])}}return e?!1:u.length?1===u.length?u[0]:u:!1}function i(){function t(e,n){for(var r=0,i=t.bits.length;i>r;++r)if(!t.bits[r](e))return!1;return t.subject&&n.push(e),!0}return t.bits=[],t.subject=!1,t.push=function(e){t.bits.push(e)},t}function o(t,n){return function(r){var i=e[t](r);return i=Array.isArray(i)?i:i?i.toString().split(/\s+/):[],i.indexOf(n)>=0}}function s(t){return t.data.lhs?h(e.attr,t.data.lhs,t.data.cmp,t.data.rhs):h(e.attr,t.data)}function l(t,n){return function(r){return e[t](r)==n}}function p(t,n,r){do t=e.parent(t);while(t&&!n(t,r));return t}function c(t,n,r){return t=e.parent(t),t&&n(t,r)?t:null}function f(t,n,r){var i,o=e.parent(t),s=0;i=e.children(o);for(var a=0,u=i.length;u>a;++a)if(i[a]===t){s=a;break}return i[s-1]&&n(i[s-1],r)?i[s-1]:null}function d(t,n,r){var i,o=e.parent(t);i=e.children(o);for(var s=0,a=i.length;a>s;++s){if(i[s]===t)return null;if(n(i[s],r))return i[s]}return null}function m(t){return u(e,t.data)}var v,y,g=x(),_=[[]];return y=_[0],v={"":p,">":c,"+":f,"~":d},g.on("data",n).end(t),r}function a(t,e,n){return e(t,n)?t:null}function u(t,e){switch(e){case"empty":return d(t);case"first-child":return c(t);case"last-child":return f(t);case"root":return m(t)}return 0===e.indexOf("contains")?v(t,e.slice(9,-1)):0===e.indexOf("any")?p(t,e.slice(4,-1)):0===e.indexOf("not")?l(t,e.slice(4,-1)):function(){return!1}}function l(t,e){function n(t){return!r(t,!0)}var r=s(e,t);return n}function p(t,e){var n=s(e,t);return n}function h(t,e,n,r){return function(i){var o=t(i,e);return n?1===n.length?o==r:void 0===o||null===o?!1:k[n.charAt(0)](o,r):!!o}}function c(t){return function(e){return t.children(t.parent(e))[0]===e}}function f(t){return function(e){var n=t.children(t.parent(e));return n[n.length-1]===e}}function d(t){return function(e){return 0===t.children(e).length}}function m(t){return function(e){return!t.parent(e)}}function v(t,e){return function(n){return-1!==t.contents(n).indexOf(e)}}function y(t,e){return t.slice(t.length-e.length)===e}function g(t,e){return t.slice(0,e.length)===e}function _(t,e){return t.indexOf(e)>-1}function b(t,e){return t.split(/\s+/).indexOf(e)>-1}function w(t,e){return t.split("-").indexOf(e)>-1}e.exports=r;var x=t("./tokenizer"),k={$:y,"^":g,"*":_,"~":b,"|":w}},{"./tokenizer":4}],3:[function(t,e,n){(function(r){function i(t,e,n){function i(){for(;l.length&&!h.paused;){var t=l.shift();if(null===t)return h.emit("end");h.emit("data",t)}}function s(){h.writable=!1,e.call(h),!h.readable&&h.autoDestroy&&h.destroy()}t=t||function(t){this.queue(t)},e=e||function(){this.queue(null)};var a=!1,u=!1,l=[],p=!1,h=new o;return h.readable=h.writable=!0,h.paused=!1,h.autoDestroy=!(n&&n.autoDestroy===!1),h.write=function(e){return t.call(this,e),!h.paused},h.queue=h.push=function(t){return p?h:(null===t&&(p=!0),l.push(t),i(),h)},h.on("end",function(){h.readable=!1,!h.writable&&h.autoDestroy&&r.nextTick(function(){h.destroy()})}),h.end=function(t){return a?void 0:(a=!0,arguments.length&&h.write(t),s(),h)},h.destroy=function(){return u?void 0:(u=!0,a=!0,l.length=0,h.writable=h.readable=!1,h.emit("close"),h)},h.pause=function(){return h.paused?void 0:(h.paused=!0,h)},h.resume=function(){return h.paused&&(h.paused=!1,h.emit("resume")),i(),h.paused||h.emit("drain"),h},h}var o=t("stream");n=e.exports=i,i.through=i}).call(this,t("1YiZ5S"))},{"1YiZ5S":10,stream:12}],4:[function(t,e,n){function r(){function t(t){for(q=q.concat(t.split("")),C=q.length;C>V&&(U=q[V++]);)switch(B){case c:n();break;case a:E();break;case f:k();break;case s:M();break;case u:T();break;case l:O();break;case h:case p:S();break;case o:z();break;case b:case g:case d:A()}q=q.slice(V)}function e(e){arguments.length&&t(e),H.length&&R.queue(P())}function n(){switch(!0){case"#"===U:B=b;break;case"."===U:B=d;break;case":"===U:B=h;break;case"["===U:B=s;break;case"!"===U:r();break;case"*"===U:w();break;case","===U:x();break;case/[>\+~]/.test(U):B=f;break;case/\s/.test(U):B=a;break;case/[\w\d\-_]/.test(U):B=g,--V}}function r(){B=y,H=["!"],R.queue(P()),B=c}function w(){B=_,H=["*"],R.queue(P()),B=c}function x(){B=m,H=[","],R.queue(P()),B=c}function k(){return/[>\+~]/.test(U)?H.push(U):void(/\s/.test(U)||(R.queue(P()),B=c,--V))}function E(){if(!/\s/.test(U)){if(/[>\+~]/.test(U))return--V,B=f;R.queue(P()),B=c,--V}}function S(){if(j=B,A(!0),B===c){if("("===U)return L=H.join(""),B=o,H.length=0,D=1,void++V;B=h,R.queue(P()),B=c}}function z(){if(0!==H.length||I||!(I=/['"]/.test(U)?U:null)){if(I)return F||U!==I?"\\"===U?void(F?H.push(U):F=!0):(F=!1,void H.push(U)):void(I=null);H.push(U),"("===U?++D:")"===U&&--D,D||(H.pop(),R.queue({type:j,data:L+"("+H.join("")+")"}),B=c,L=j=N=null,H.length=0)}}function M(){if(A(!0),B===c){if("]"===U)return B=v,R.queue(P()),void(B=c);L=H.join(""),H.length=0,B=u}}function T(){return/[=~|$^*]/.test(U)&&H.push(U),2===H.length||"="===U?(N=H.join(""),H.length=0,B=l,void(I=null)):void 0}function O(){if(H.length||I||!(I=/['"]/.test(U)?U:null)){if(I)return F||U!==I?"\\"===U?(F&&H.push(U),void(F=!F)):(F=!1,void H.push(U)):void(I=null);A(!0),B===c&&(R.queue({type:v,data:{lhs:L,rhs:H.join(""),cmp:N}}),B=c,L=j=N=null,H.length=0)}}function A(t){return/[^\d\w\-_]/.test(U)&&!F?void("\\"===U?F=!0:(!t&&R.queue(P()),B=c,--V)):(F=!1,void H.push(U))}function P(){var t=H.join("");return H.length=0,{type:B,data:t}}var R,C,I,D,L,j,N,U,F=!1,H=[],B=c,q=[],V=0;return R=i(t,e)}e.exports=r;var i=t("through"),o="pseudo-start",s="attr-start",a="any-child",u="attr-comp",l="attr-end",p="::",h=":",c="(ready)",f="op",d="class",m="comma",v="attr",y="!",g="tag",_="*",b="id"},{through:3}],5:[function(t,e,n){function r(t,e,n){if(!(this instanceof r))return new r(t,e,n);var i=typeof t;if("base64"===e&&"string"===i)for(t=T(t);t.length%4!==0;)t+="=";var o;if("number"===i)o=A(t);else if("string"===i)o=r.byteLength(t,e);else{if("object"!==i)throw new Error("First argument needs to be a number, array or string.");o=A(t.length)}var s;r._useTypedArrays?s=r._augment(new Uint8Array(o)):(s=this,s.length=o,s._isBuffer=!0);var a;if(r._useTypedArrays&&"number"==typeof t.byteLength)s._set(t);else if(R(t))for(a=0;o>a;a++)r.isBuffer(t)?s[a]=t.readUInt8(a):s[a]=t[a];else if("string"===i)s.write(t,0,e);else if("number"===i&&!r._useTypedArrays&&!n)for(a=0;o>a;a++)s[a]=0;return s}function i(t,e,n,i){n=Number(n)||0;var o=t.length-n;i?(i=Number(i),i>o&&(i=o)):i=o;var s=e.length;q(s%2===0,"Invalid hex string"),i>s/2&&(i=s/2);for(var a=0;i>a;a++){var u=parseInt(e.substr(2*a,2),16);q(!isNaN(u),"Invalid hex string"),t[n+a]=u}return r._charsWritten=2*a,a}function o(t,e,n,i){var o=r._charsWritten=N(I(e),t,n,i);return o}function s(t,e,n,i){var o=r._charsWritten=N(D(e),t,n,i);return o}function a(t,e,n,r){return s(t,e,n,r)}function u(t,e,n,i){var o=r._charsWritten=N(j(e),t,n,i);return o}function l(t,e,n,i){var o=r._charsWritten=N(L(e),t,n,i);return o}function p(t,e,n){return 0===e&&n===t.length?V.fromByteArray(t):V.fromByteArray(t.slice(e,n))}function h(t,e,n){var r="",i="";n=Math.min(t.length,n);for(var o=e;n>o;o++)t[o]<=127?(r+=U(i)+String.fromCharCode(t[o]),i=""):i+="%"+t[o].toString(16);return r+U(i)}function c(t,e,n){var r="";n=Math.min(t.length,n);for(var i=e;n>i;i++)r+=String.fromCharCode(t[i]);return r}function f(t,e,n){return c(t,e,n)}function d(t,e,n){var r=t.length;(!e||0>e)&&(e=0),(!n||0>n||n>r)&&(n=r);for(var i="",o=e;n>o;o++)i+=C(t[o]);return i}function m(t,e,n){for(var r=t.slice(e,n),i="",o=0;o<r.length;o+=2)i+=String.fromCharCode(r[o]+256*r[o+1]);return i}function v(t,e,n,r){r||(q("boolean"==typeof n,"missing or invalid endian"),q(void 0!==e&&null!==e,"missing offset"),q(e+1<t.length,"Trying to read beyond buffer length"));var i=t.length;if(!(e>=i)){var o;return n?(o=t[e],i>e+1&&(o|=t[e+1]<<8)):(o=t[e]<<8,i>e+1&&(o|=t[e+1])),o}}function y(t,e,n,r){r||(q("boolean"==typeof n,"missing or invalid endian"),q(void 0!==e&&null!==e,"missing offset"),q(e+3<t.length,"Trying to read beyond buffer length"));var i=t.length;if(!(e>=i)){var o;return n?(i>e+2&&(o=t[e+2]<<16),i>e+1&&(o|=t[e+1]<<8),o|=t[e],i>e+3&&(o+=t[e+3]<<24>>>0)):(i>e+1&&(o=t[e+1]<<16),i>e+2&&(o|=t[e+2]<<8),i>e+3&&(o|=t[e+3]),o+=t[e]<<24>>>0),o}}function g(t,e,n,r){r||(q("boolean"==typeof n,"missing or invalid endian"),q(void 0!==e&&null!==e,"missing offset"),q(e+1<t.length,"Trying to read beyond buffer length"));var i=t.length;if(!(e>=i)){var o=v(t,e,n,!0),s=32768&o;return s?-1*(65535-o+1):o}}function _(t,e,n,r){r||(q("boolean"==typeof n,"missing or invalid endian"),q(void 0!==e&&null!==e,"missing offset"),q(e+3<t.length,"Trying to read beyond buffer length"));var i=t.length;if(!(e>=i)){var o=y(t,e,n,!0),s=2147483648&o;return s?-1*(4294967295-o+1):o}}function b(t,e,n,r){return r||(q("boolean"==typeof n,"missing or invalid endian"),q(e+3<t.length,"Trying to read beyond buffer length")),G.read(t,e,n,23,4)}function w(t,e,n,r){return r||(q("boolean"==typeof n,"missing or invalid endian"),q(e+7<t.length,"Trying to read beyond buffer length")),G.read(t,e,n,52,8)}function x(t,e,n,r,i){i||(q(void 0!==e&&null!==e,"missing value"),q("boolean"==typeof r,"missing or invalid endian"),q(void 0!==n&&null!==n,"missing offset"),q(n+1<t.length,"trying to write beyond buffer length"),F(e,65535));var o=t.length;if(!(n>=o))for(var s=0,a=Math.min(o-n,2);a>s;s++)t[n+s]=(e&255<<8*(r?s:1-s))>>>8*(r?s:1-s)}function k(t,e,n,r,i){i||(q(void 0!==e&&null!==e,"missing value"),q("boolean"==typeof r,"missing or invalid endian"),q(void 0!==n&&null!==n,"missing offset"),q(n+3<t.length,"trying to write beyond buffer length"),F(e,4294967295));var o=t.length;if(!(n>=o))for(var s=0,a=Math.min(o-n,4);a>s;s++)t[n+s]=e>>>8*(r?s:3-s)&255}function E(t,e,n,r,i){i||(q(void 0!==e&&null!==e,"missing value"),q("boolean"==typeof r,"missing or invalid endian"),q(void 0!==n&&null!==n,"missing offset"),q(n+1<t.length,"Trying to write beyond buffer length"),H(e,32767,-32768));var o=t.length;n>=o||(e>=0?x(t,e,n,r,i):x(t,65535+e+1,n,r,i))}function S(t,e,n,r,i){i||(q(void 0!==e&&null!==e,"missing value"),q("boolean"==typeof r,"missing or invalid endian"),q(void 0!==n&&null!==n,"missing offset"),q(n+3<t.length,"Trying to write beyond buffer length"),H(e,2147483647,-2147483648));var o=t.length;n>=o||(e>=0?k(t,e,n,r,i):k(t,4294967295+e+1,n,r,i))}function z(t,e,n,r,i){i||(q(void 0!==e&&null!==e,"missing value"),q("boolean"==typeof r,"missing or invalid endian"),q(void 0!==n&&null!==n,"missing offset"),q(n+3<t.length,"Trying to write beyond buffer length"),B(e,3.4028234663852886e38,-3.4028234663852886e38));var o=t.length;n>=o||G.write(t,e,n,r,23,4)}function M(t,e,n,r,i){i||(q(void 0!==e&&null!==e,"missing value"),q("boolean"==typeof r,"missing or invalid endian"),q(void 0!==n&&null!==n,"missing offset"),q(n+7<t.length,"Trying to write beyond buffer length"),B(e,1.7976931348623157e308,-1.7976931348623157e308));var o=t.length;n>=o||G.write(t,e,n,r,52,8)}function T(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")}function O(t,e,n){return"number"!=typeof t?n:(t=~~t,t>=e?e:t>=0?t:(t+=e,t>=0?t:0))}function A(t){return t=~~Math.ceil(+t),0>t?0:t}function P(t){return(Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)})(t)}function R(t){return P(t)||r.isBuffer(t)||t&&"object"==typeof t&&"number"==typeof t.length}function C(t){return 16>t?"0"+t.toString(16):t.toString(16)}function I(t){for(var e=[],n=0;n<t.length;n++){var r=t.charCodeAt(n);if(127>=r)e.push(t.charCodeAt(n));else{var i=n;r>=55296&&57343>=r&&n++;for(var o=encodeURIComponent(t.slice(i,n+1)).substr(1).split("%"),s=0;s<o.length;s++)e.push(parseInt(o[s],16))}}return e}function D(t){for(var e=[],n=0;n<t.length;n++)e.push(255&t.charCodeAt(n));return e}function L(t){for(var e,n,r,i=[],o=0;o<t.length;o++)e=t.charCodeAt(o),n=e>>8,r=e%256,i.push(r),i.push(n);return i}function j(t){return V.toByteArray(t)}function N(t,e,n,r){for(var i=0;r>i&&!(i+n>=e.length||i>=t.length);i++)e[i+n]=t[i];return i}function U(t){try{return decodeURIComponent(t)}catch(e){return String.fromCharCode(65533)}}function F(t,e){q("number"==typeof t,"cannot write a non-number as a number"),q(t>=0,"specified a negative value for writing an unsigned value"),q(e>=t,"value is larger than maximum value for type"),q(Math.floor(t)===t,"value has a fractional component")}function H(t,e,n){q("number"==typeof t,"cannot write a non-number as a number"),q(e>=t,"value larger than maximum allowed value"),q(t>=n,"value smaller than minimum allowed value"),q(Math.floor(t)===t,"value has a fractional component")}function B(t,e,n){q("number"==typeof t,"cannot write a non-number as a number"),q(e>=t,"value larger than maximum allowed value"),q(t>=n,"value smaller than minimum allowed value")}function q(t,e){if(!t)throw new Error(e||"Failed assertion")}var V=t("base64-js"),G=t("ieee754");n.Buffer=r,n.SlowBuffer=r,n.INSPECT_MAX_BYTES=50,r.poolSize=8192,r._useTypedArrays=function(){try{var t=new ArrayBuffer(0),e=new Uint8Array(t);return e.foo=function(){return 42},42===e.foo()&&"function"==typeof e.subarray}catch(n){return!1}}(),r.isEncoding=function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"raw":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},r.isBuffer=function(t){return!(null===t||void 0===t||!t._isBuffer)},r.byteLength=function(t,e){var n;switch(t+="",e||"utf8"){case"hex":n=t.length/2;break;case"utf8":case"utf-8":n=I(t).length;break;case"ascii":case"binary":case"raw":n=t.length;break;case"base64":n=j(t).length;break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":
n=2*t.length;break;default:throw new Error("Unknown encoding")}return n},r.concat=function(t,e){if(q(P(t),"Usage: Buffer.concat(list, [totalLength])\nlist should be an Array."),0===t.length)return new r(0);if(1===t.length)return t[0];var n;if("number"!=typeof e)for(e=0,n=0;n<t.length;n++)e+=t[n].length;var i=new r(e),o=0;for(n=0;n<t.length;n++){var s=t[n];s.copy(i,o),o+=s.length}return i},r.prototype.write=function(t,e,n,r){if(isFinite(e))isFinite(n)||(r=n,n=void 0);else{var p=r;r=e,e=n,n=p}e=Number(e)||0;var h=this.length-e;n?(n=Number(n),n>h&&(n=h)):n=h,r=String(r||"utf8").toLowerCase();var c;switch(r){case"hex":c=i(this,t,e,n);break;case"utf8":case"utf-8":c=o(this,t,e,n);break;case"ascii":c=s(this,t,e,n);break;case"binary":c=a(this,t,e,n);break;case"base64":c=u(this,t,e,n);break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":c=l(this,t,e,n);break;default:throw new Error("Unknown encoding")}return c},r.prototype.toString=function(t,e,n){var r=this;if(t=String(t||"utf8").toLowerCase(),e=Number(e)||0,n=void 0!==n?Number(n):n=r.length,n===e)return"";var i;switch(t){case"hex":i=d(r,e,n);break;case"utf8":case"utf-8":i=h(r,e,n);break;case"ascii":i=c(r,e,n);break;case"binary":i=f(r,e,n);break;case"base64":i=p(r,e,n);break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":i=m(r,e,n);break;default:throw new Error("Unknown encoding")}return i},r.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},r.prototype.copy=function(t,e,n,i){var o=this;if(n||(n=0),i||0===i||(i=this.length),e||(e=0),i!==n&&0!==t.length&&0!==o.length){q(i>=n,"sourceEnd < sourceStart"),q(e>=0&&e<t.length,"targetStart out of bounds"),q(n>=0&&n<o.length,"sourceStart out of bounds"),q(i>=0&&i<=o.length,"sourceEnd out of bounds"),i>this.length&&(i=this.length),t.length-e<i-n&&(i=t.length-e+n);var s=i-n;if(100>s||!r._useTypedArrays)for(var a=0;s>a;a++)t[a+e]=this[a+n];else t._set(this.subarray(n,n+s),e)}},r.prototype.slice=function(t,e){var n=this.length;if(t=O(t,n,0),e=O(e,n,n),r._useTypedArrays)return r._augment(this.subarray(t,e));for(var i=e-t,o=new r(i,void 0,!0),s=0;i>s;s++)o[s]=this[s+t];return o},r.prototype.get=function(t){return console.log(".get() is deprecated. Access using array indexes instead."),this.readUInt8(t)},r.prototype.set=function(t,e){return console.log(".set() is deprecated. Access using array indexes instead."),this.writeUInt8(t,e)},r.prototype.readUInt8=function(t,e){return e||(q(void 0!==t&&null!==t,"missing offset"),q(t<this.length,"Trying to read beyond buffer length")),t>=this.length?void 0:this[t]},r.prototype.readUInt16LE=function(t,e){return v(this,t,!0,e)},r.prototype.readUInt16BE=function(t,e){return v(this,t,!1,e)},r.prototype.readUInt32LE=function(t,e){return y(this,t,!0,e)},r.prototype.readUInt32BE=function(t,e){return y(this,t,!1,e)},r.prototype.readInt8=function(t,e){if(e||(q(void 0!==t&&null!==t,"missing offset"),q(t<this.length,"Trying to read beyond buffer length")),!(t>=this.length)){var n=128&this[t];return n?-1*(255-this[t]+1):this[t]}},r.prototype.readInt16LE=function(t,e){return g(this,t,!0,e)},r.prototype.readInt16BE=function(t,e){return g(this,t,!1,e)},r.prototype.readInt32LE=function(t,e){return _(this,t,!0,e)},r.prototype.readInt32BE=function(t,e){return _(this,t,!1,e)},r.prototype.readFloatLE=function(t,e){return b(this,t,!0,e)},r.prototype.readFloatBE=function(t,e){return b(this,t,!1,e)},r.prototype.readDoubleLE=function(t,e){return w(this,t,!0,e)},r.prototype.readDoubleBE=function(t,e){return w(this,t,!1,e)},r.prototype.writeUInt8=function(t,e,n){n||(q(void 0!==t&&null!==t,"missing value"),q(void 0!==e&&null!==e,"missing offset"),q(e<this.length,"trying to write beyond buffer length"),F(t,255)),e>=this.length||(this[e]=t)},r.prototype.writeUInt16LE=function(t,e,n){x(this,t,e,!0,n)},r.prototype.writeUInt16BE=function(t,e,n){x(this,t,e,!1,n)},r.prototype.writeUInt32LE=function(t,e,n){k(this,t,e,!0,n)},r.prototype.writeUInt32BE=function(t,e,n){k(this,t,e,!1,n)},r.prototype.writeInt8=function(t,e,n){n||(q(void 0!==t&&null!==t,"missing value"),q(void 0!==e&&null!==e,"missing offset"),q(e<this.length,"Trying to write beyond buffer length"),H(t,127,-128)),e>=this.length||(t>=0?this.writeUInt8(t,e,n):this.writeUInt8(255+t+1,e,n))},r.prototype.writeInt16LE=function(t,e,n){E(this,t,e,!0,n)},r.prototype.writeInt16BE=function(t,e,n){E(this,t,e,!1,n)},r.prototype.writeInt32LE=function(t,e,n){S(this,t,e,!0,n)},r.prototype.writeInt32BE=function(t,e,n){S(this,t,e,!1,n)},r.prototype.writeFloatLE=function(t,e,n){z(this,t,e,!0,n)},r.prototype.writeFloatBE=function(t,e,n){z(this,t,e,!1,n)},r.prototype.writeDoubleLE=function(t,e,n){M(this,t,e,!0,n)},r.prototype.writeDoubleBE=function(t,e,n){M(this,t,e,!1,n)},r.prototype.fill=function(t,e,n){if(t||(t=0),e||(e=0),n||(n=this.length),"string"==typeof t&&(t=t.charCodeAt(0)),q("number"==typeof t&&!isNaN(t),"value is not a number"),q(n>=e,"end < start"),n!==e&&0!==this.length){q(e>=0&&e<this.length,"start out of bounds"),q(n>=0&&n<=this.length,"end out of bounds");for(var r=e;n>r;r++)this[r]=t}},r.prototype.inspect=function(){for(var t=[],e=this.length,r=0;e>r;r++)if(t[r]=C(this[r]),r===n.INSPECT_MAX_BYTES){t[r+1]="...";break}return"<Buffer "+t.join(" ")+">"},r.prototype.toArrayBuffer=function(){if("undefined"!=typeof Uint8Array){if(r._useTypedArrays)return new r(this).buffer;for(var t=new Uint8Array(this.length),e=0,n=t.length;n>e;e+=1)t[e]=this[e];return t.buffer}throw new Error("Buffer.toArrayBuffer not supported in this browser")};var W=r.prototype;r._augment=function(t){return t._isBuffer=!0,t._get=t.get,t._set=t.set,t.get=W.get,t.set=W.set,t.write=W.write,t.toString=W.toString,t.toLocaleString=W.toString,t.toJSON=W.toJSON,t.copy=W.copy,t.slice=W.slice,t.readUInt8=W.readUInt8,t.readUInt16LE=W.readUInt16LE,t.readUInt16BE=W.readUInt16BE,t.readUInt32LE=W.readUInt32LE,t.readUInt32BE=W.readUInt32BE,t.readInt8=W.readInt8,t.readInt16LE=W.readInt16LE,t.readInt16BE=W.readInt16BE,t.readInt32LE=W.readInt32LE,t.readInt32BE=W.readInt32BE,t.readFloatLE=W.readFloatLE,t.readFloatBE=W.readFloatBE,t.readDoubleLE=W.readDoubleLE,t.readDoubleBE=W.readDoubleBE,t.writeUInt8=W.writeUInt8,t.writeUInt16LE=W.writeUInt16LE,t.writeUInt16BE=W.writeUInt16BE,t.writeUInt32LE=W.writeUInt32LE,t.writeUInt32BE=W.writeUInt32BE,t.writeInt8=W.writeInt8,t.writeInt16LE=W.writeInt16LE,t.writeInt16BE=W.writeInt16BE,t.writeInt32LE=W.writeInt32LE,t.writeInt32BE=W.writeInt32BE,t.writeFloatLE=W.writeFloatLE,t.writeFloatBE=W.writeFloatBE,t.writeDoubleLE=W.writeDoubleLE,t.writeDoubleBE=W.writeDoubleBE,t.fill=W.fill,t.inspect=W.inspect,t.toArrayBuffer=W.toArrayBuffer,t}},{"base64-js":6,ieee754:7}],6:[function(t,e,n){var r="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";!function(t){"use strict";function e(t){var e=t.charCodeAt(0);return e===s||e===h?62:e===a||e===c?63:u>e?-1:u+10>e?e-u+26+26:p+26>e?e-p:l+26>e?e-l+26:void 0}function n(t){function n(t){l[h++]=t}var r,i,s,a,u,l;if(t.length%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var p=t.length;u="="===t.charAt(p-2)?2:"="===t.charAt(p-1)?1:0,l=new o(3*t.length/4-u),s=u>0?t.length-4:t.length;var h=0;for(r=0,i=0;s>r;r+=4,i+=3)a=e(t.charAt(r))<<18|e(t.charAt(r+1))<<12|e(t.charAt(r+2))<<6|e(t.charAt(r+3)),n((16711680&a)>>16),n((65280&a)>>8),n(255&a);return 2===u?(a=e(t.charAt(r))<<2|e(t.charAt(r+1))>>4,n(255&a)):1===u&&(a=e(t.charAt(r))<<10|e(t.charAt(r+1))<<4|e(t.charAt(r+2))>>2,n(a>>8&255),n(255&a)),l}function i(t){function e(t){return r.charAt(t)}function n(t){return e(t>>18&63)+e(t>>12&63)+e(t>>6&63)+e(63&t)}var i,o,s,a=t.length%3,u="";for(i=0,s=t.length-a;s>i;i+=3)o=(t[i]<<16)+(t[i+1]<<8)+t[i+2],u+=n(o);switch(a){case 1:o=t[t.length-1],u+=e(o>>2),u+=e(o<<4&63),u+="==";break;case 2:o=(t[t.length-2]<<8)+t[t.length-1],u+=e(o>>10),u+=e(o>>4&63),u+=e(o<<2&63),u+="="}return u}var o="undefined"!=typeof Uint8Array?Uint8Array:Array,s="+".charCodeAt(0),a="/".charCodeAt(0),u="0".charCodeAt(0),l="a".charCodeAt(0),p="A".charCodeAt(0),h="-".charCodeAt(0),c="_".charCodeAt(0);t.toByteArray=n,t.fromByteArray=i}("undefined"==typeof n?this.base64js={}:n)},{}],7:[function(t,e,n){n.read=function(t,e,n,r,i){var o,s,a=8*i-r-1,u=(1<<a)-1,l=u>>1,p=-7,h=n?i-1:0,c=n?-1:1,f=t[e+h];for(h+=c,o=f&(1<<-p)-1,f>>=-p,p+=a;p>0;o=256*o+t[e+h],h+=c,p-=8);for(s=o&(1<<-p)-1,o>>=-p,p+=r;p>0;s=256*s+t[e+h],h+=c,p-=8);if(0===o)o=1-l;else{if(o===u)return s?NaN:(f?-1:1)*(1/0);s+=Math.pow(2,r),o-=l}return(f?-1:1)*s*Math.pow(2,o-r)},n.write=function(t,e,n,r,i,o){var s,a,u,l=8*o-i-1,p=(1<<l)-1,h=p>>1,c=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=r?0:o-1,d=r?1:-1,m=0>e||0===e&&0>1/e?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,s=p):(s=Math.floor(Math.log(e)/Math.LN2),e*(u=Math.pow(2,-s))<1&&(s--,u*=2),e+=s+h>=1?c/u:c*Math.pow(2,1-h),e*u>=2&&(s++,u/=2),s+h>=p?(a=0,s=p):s+h>=1?(a=(e*u-1)*Math.pow(2,i),s+=h):(a=e*Math.pow(2,h-1)*Math.pow(2,i),s=0));i>=8;t[n+f]=255&a,f+=d,a/=256,i-=8);for(s=s<<i|a,l+=i;l>0;t[n+f]=255&s,f+=d,s/=256,l-=8);t[n+f-d]|=128*m}},{}],8:[function(t,e,n){function r(){this._events=this._events||{},this._maxListeners=this._maxListeners||void 0}function i(t){return"function"==typeof t}function o(t){return"number"==typeof t}function s(t){return"object"==typeof t&&null!==t}function a(t){return void 0===t}e.exports=r,r.EventEmitter=r,r.prototype._events=void 0,r.prototype._maxListeners=void 0,r.defaultMaxListeners=10,r.prototype.setMaxListeners=function(t){if(!o(t)||0>t||isNaN(t))throw TypeError("n must be a positive number");return this._maxListeners=t,this},r.prototype.emit=function(t){var e,n,r,o,u,l;if(this._events||(this._events={}),"error"===t&&(!this._events.error||s(this._events.error)&&!this._events.error.length)){if(e=arguments[1],e instanceof Error)throw e;throw TypeError('Uncaught, unspecified "error" event.')}if(n=this._events[t],a(n))return!1;if(i(n))switch(arguments.length){case 1:n.call(this);break;case 2:n.call(this,arguments[1]);break;case 3:n.call(this,arguments[1],arguments[2]);break;default:for(r=arguments.length,o=new Array(r-1),u=1;r>u;u++)o[u-1]=arguments[u];n.apply(this,o)}else if(s(n)){for(r=arguments.length,o=new Array(r-1),u=1;r>u;u++)o[u-1]=arguments[u];for(l=n.slice(),r=l.length,u=0;r>u;u++)l[u].apply(this,o)}return!0},r.prototype.addListener=function(t,e){var n;if(!i(e))throw TypeError("listener must be a function");if(this._events||(this._events={}),this._events.newListener&&this.emit("newListener",t,i(e.listener)?e.listener:e),this._events[t]?s(this._events[t])?this._events[t].push(e):this._events[t]=[this._events[t],e]:this._events[t]=e,s(this._events[t])&&!this._events[t].warned){var n;n=a(this._maxListeners)?r.defaultMaxListeners:this._maxListeners,n&&n>0&&this._events[t].length>n&&(this._events[t].warned=!0,console.error("(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.",this._events[t].length),"function"==typeof console.trace&&console.trace())}return this},r.prototype.on=r.prototype.addListener,r.prototype.once=function(t,e){function n(){this.removeListener(t,n),r||(r=!0,e.apply(this,arguments))}if(!i(e))throw TypeError("listener must be a function");var r=!1;return n.listener=e,this.on(t,n),this},r.prototype.removeListener=function(t,e){var n,r,o,a;if(!i(e))throw TypeError("listener must be a function");if(!this._events||!this._events[t])return this;if(n=this._events[t],o=n.length,r=-1,n===e||i(n.listener)&&n.listener===e)delete this._events[t],this._events.removeListener&&this.emit("removeListener",t,e);else if(s(n)){for(a=o;a-->0;)if(n[a]===e||n[a].listener&&n[a].listener===e){r=a;break}if(0>r)return this;1===n.length?(n.length=0,delete this._events[t]):n.splice(r,1),this._events.removeListener&&this.emit("removeListener",t,e)}return this},r.prototype.removeAllListeners=function(t){var e,n;if(!this._events)return this;if(!this._events.removeListener)return 0===arguments.length?this._events={}:this._events[t]&&delete this._events[t],this;if(0===arguments.length){for(e in this._events)"removeListener"!==e&&this.removeAllListeners(e);return this.removeAllListeners("removeListener"),this._events={},this}if(n=this._events[t],i(n))this.removeListener(t,n);else for(;n.length;)this.removeListener(t,n[n.length-1]);return delete this._events[t],this},r.prototype.listeners=function(t){var e;return e=this._events&&this._events[t]?i(this._events[t])?[this._events[t]]:this._events[t].slice():[]},r.listenerCount=function(t,e){var n;return n=t._events&&t._events[e]?i(t._events[e])?1:t._events[e].length:0}},{}],9:[function(t,e,n){"function"==typeof Object.create?e.exports=function(t,e){t.super_=e,t.prototype=Object.create(e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})}:e.exports=function(t,e){t.super_=e;var n=function(){};n.prototype=e.prototype,t.prototype=new n,t.prototype.constructor=t}},{}],10:[function(t,e,n){function r(){}var i=e.exports={};i.nextTick=function(){var t="undefined"!=typeof window&&window.setImmediate,e="undefined"!=typeof window&&window.postMessage&&window.addEventListener;if(t)return function(t){return window.setImmediate(t)};if(e){var n=[];return window.addEventListener("message",function(t){var e=t.source;if((e===window||null===e)&&"process-tick"===t.data&&(t.stopPropagation(),n.length>0)){var r=n.shift();r()}},!0),function(t){n.push(t),window.postMessage("process-tick","*")}}return function(t){setTimeout(t,0)}}(),i.title="browser",i.browser=!0,i.env={},i.argv=[],i.on=r,i.addListener=r,i.once=r,i.off=r,i.removeListener=r,i.removeAllListeners=r,i.emit=r,i.binding=function(t){throw new Error("process.binding is not supported")},i.cwd=function(){return"/"},i.chdir=function(t){throw new Error("process.chdir is not supported")}},{}],11:[function(t,e,n){function r(t){return this instanceof r?(a.call(this,t),u.call(this,t),t&&t.readable===!1&&(this.readable=!1),t&&t.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,t&&t.allowHalfOpen===!1&&(this.allowHalfOpen=!1),void this.once("end",i)):new r(t)}function i(){if(!this.allowHalfOpen&&!this._writableState.ended){var t=this;s(function(){t.end()})}}e.exports=r;var o=t("inherits"),s=t("process/browser.js").nextTick,a=t("./readable.js"),u=t("./writable.js");o(r,a),r.prototype.write=u.prototype.write,r.prototype.end=u.prototype.end,r.prototype._write=u.prototype._write},{"./readable.js":15,"./writable.js":17,inherits:9,"process/browser.js":13}],12:[function(t,e,n){function r(){i.call(this)}e.exports=r;var i=t("events").EventEmitter,o=t("inherits");o(r,i),r.Readable=t("./readable.js"),r.Writable=t("./writable.js"),r.Duplex=t("./duplex.js"),r.Transform=t("./transform.js"),r.PassThrough=t("./passthrough.js"),r.Stream=r,r.prototype.pipe=function(t,e){function n(e){t.writable&&!1===t.write(e)&&l.pause&&l.pause()}function r(){l.readable&&l.resume&&l.resume()}function o(){p||(p=!0,t.end())}function s(){p||(p=!0,"function"==typeof t.destroy&&t.destroy())}function a(t){if(u(),0===i.listenerCount(this,"error"))throw t}function u(){l.removeListener("data",n),t.removeListener("drain",r),l.removeListener("end",o),l.removeListener("close",s),l.removeListener("error",a),t.removeListener("error",a),l.removeListener("end",u),l.removeListener("close",u),t.removeListener("close",u)}var l=this;l.on("data",n),t.on("drain",r),t._isStdio||e&&e.end===!1||(l.on("end",o),l.on("close",s));var p=!1;return l.on("error",a),t.on("error",a),l.on("end",u),l.on("close",u),t.on("close",u),t.emit("pipe",l),t}},{"./duplex.js":11,"./passthrough.js":14,"./readable.js":15,"./transform.js":16,"./writable.js":17,events:8,inherits:9}],13:[function(t,e,n){var r=e.exports={};r.nextTick=function(){var t="undefined"!=typeof window&&window.setImmediate,e="undefined"!=typeof window&&window.postMessage&&window.addEventListener;if(t)return function(t){return window.setImmediate(t)};if(e){var n=[];return window.addEventListener("message",function(t){var e=t.source;if((e===window||null===e)&&"process-tick"===t.data&&(t.stopPropagation(),n.length>0)){var r=n.shift();r()}},!0),function(t){n.push(t),window.postMessage("process-tick","*")}}return function(t){setTimeout(t,0)}}(),r.title="browser",r.browser=!0,r.env={},r.argv=[],r.binding=function(t){throw new Error("process.binding is not supported")},r.cwd=function(){return"/"},r.chdir=function(t){throw new Error("process.chdir is not supported")}},{}],14:[function(t,e,n){function r(t){return this instanceof r?void i.call(this,t):new r(t)}e.exports=r;var i=t("./transform.js"),o=t("inherits");o(r,i),r.prototype._transform=function(t,e,n){n(null,t)}},{"./transform.js":16,inherits:9}],15:[function(t,e,n){(function(n){function r(e,n){e=e||{};var r=e.highWaterMark;this.highWaterMark=r||0===r?r:16384,this.highWaterMark=~~this.highWaterMark,this.buffer=[],this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=!1,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.calledRead=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.objectMode=!!e.objectMode,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(k||(k=t("string_decoder").StringDecoder),this.decoder=new k(e.encoding),this.encoding=e.encoding)}function i(t){return this instanceof i?(this._readableState=new r(t,this),this.readable=!0,void S.call(this)):new i(t)}function o(t,e,n,r,i){var o=l(e,n);if(o)t.emit("error",o);else if(null===n||void 0===n)e.reading=!1,e.ended||p(t,e);else if(e.objectMode||n&&n.length>0)if(e.ended&&!i){var a=new Error("stream.push() after EOF");t.emit("error",a)}else if(e.endEmitted&&i){var a=new Error("stream.unshift() after end event");t.emit("error",a)}else!e.decoder||i||r||(n=e.decoder.write(n)),e.length+=e.objectMode?1:n.length,i?e.buffer.unshift(n):(e.reading=!1,e.buffer.push(n)),e.needReadable&&h(t),f(t,e);else i||(e.reading=!1);return s(e)}function s(t){return!t.ended&&(t.needReadable||t.length<t.highWaterMark||0===t.length)}function a(t){if(t>=O)t=O;else{t--;for(var e=1;32>e;e<<=1)t|=t>>e;t++}return t}function u(t,e){return 0===e.length&&e.ended?0:e.objectMode?0===t?0:1:isNaN(t)||null===t?e.flowing&&e.buffer.length?e.buffer[0].length:e.length:0>=t?0:(t>e.highWaterMark&&(e.highWaterMark=a(t)),t>e.length?e.ended?e.length:(e.needReadable=!0,0):t)}function l(t,e){var n=null;return z.isBuffer(e)||"string"==typeof e||null===e||void 0===e||t.objectMode||n||(n=new TypeError("Invalid non-string/buffer chunk")),n}function p(t,e){if(e.decoder&&!e.ended){var n=e.decoder.end();n&&n.length&&(e.buffer.push(n),e.length+=e.objectMode?1:n.length)}e.ended=!0,e.length>0?h(t):b(t)}function h(t){var e=t._readableState;e.needReadable=!1,e.emittedReadable||(e.emittedReadable=!0,e.sync?M(function(){c(t)}):c(t))}function c(t){t.emit("readable")}function f(t,e){e.readingMore||(e.readingMore=!0,M(function(){d(t,e)}))}function d(t,e){for(var n=e.length;!e.reading&&!e.flowing&&!e.ended&&e.length<e.highWaterMark&&(t.read(0),n!==e.length);)n=e.length;e.readingMore=!1}function m(t){return function(){var e=t._readableState;e.awaitDrain--,0===e.awaitDrain&&v(t)}}function v(t){function e(t,e,i){var o=t.write(n);!1===o&&r.awaitDrain++}var n,r=t._readableState;for(r.awaitDrain=0;r.pipesCount&&null!==(n=t.read());)if(1===r.pipesCount?e(r.pipes,0,null):w(r.pipes,e),t.emit("data",n),r.awaitDrain>0)return;return 0===r.pipesCount?(r.flowing=!1,void(E.listenerCount(t,"data")>0&&g(t))):void(r.ranOut=!0)}function y(){this._readableState.ranOut&&(this._readableState.ranOut=!1,v(this))}function g(t,e){var n=t._readableState;if(n.flowing)throw new Error("Cannot switch to old mode now.");var r=e||!1,i=!1;t.readable=!0,t.pipe=S.prototype.pipe,t.on=t.addListener=S.prototype.on,t.on("readable",function(){i=!0;for(var e;!r&&null!==(e=t.read());)t.emit("data",e);null===e&&(i=!1,t._readableState.needReadable=!0)}),t.pause=function(){r=!0,this.emit("pause")},t.resume=function(){r=!1,i?M(function(){t.emit("readable")}):this.read(0),this.emit("resume")},t.emit("readable")}function _(t,e){var n,r=e.buffer,i=e.length,o=!!e.decoder,s=!!e.objectMode;if(0===r.length)return null;if(0===i)n=null;else if(s)n=r.shift();else if(!t||t>=i)n=o?r.join(""):z.concat(r,i),r.length=0;else if(t<r[0].length){var a=r[0];n=a.slice(0,t),r[0]=a.slice(t)}else if(t===r[0].length)n=r.shift();else{n=o?"":new z(t);for(var u=0,l=0,p=r.length;p>l&&t>u;l++){var a=r[0],h=Math.min(t-u,a.length);o?n+=a.slice(0,h):a.copy(n,u,0,h),h<a.length?r[0]=a.slice(h):r.shift(),u+=h}}return n}function b(t){var e=t._readableState;if(e.length>0)throw new Error("endReadable called on non-empty stream");!e.endEmitted&&e.calledRead&&(e.ended=!0,M(function(){e.endEmitted||0!==e.length||(e.endEmitted=!0,t.readable=!1,t.emit("end"))}))}function w(t,e){for(var n=0,r=t.length;r>n;n++)e(t[n],n)}function x(t,e){for(var n=0,r=t.length;r>n;n++)if(t[n]===e)return n;return-1}e.exports=i,i.ReadableState=r;var k,E=t("events").EventEmitter,S=t("./index.js"),z=t("buffer").Buffer,M=t("process/browser.js").nextTick,T=t("inherits");T(i,S),i.prototype.push=function(t,e){var n=this._readableState;return"string"!=typeof t||n.objectMode||(e=e||n.defaultEncoding,e!==n.encoding&&(t=new z(t,e),e="")),o(this,n,t,e,!1)},i.prototype.unshift=function(t){var e=this._readableState;return o(this,e,t,"",!0)},i.prototype.setEncoding=function(e){k||(k=t("string_decoder").StringDecoder),this._readableState.decoder=new k(e),this._readableState.encoding=e};var O=8388608;i.prototype.read=function(t){var e=this._readableState;e.calledRead=!0;var n=t;if(("number"!=typeof t||t>0)&&(e.emittedReadable=!1),0===t&&e.needReadable&&(e.length>=e.highWaterMark||e.ended))return h(this),null;if(t=u(t,e),0===t&&e.ended)return 0===e.length&&b(this),null;var r=e.needReadable;e.length-t<=e.highWaterMark&&(r=!0),(e.ended||e.reading)&&(r=!1),r&&(e.reading=!0,e.sync=!0,0===e.length&&(e.needReadable=!0),this._read(e.highWaterMark),e.sync=!1),r&&!e.reading&&(t=u(n,e));var i;return i=t>0?_(t,e):null,null===i&&(e.needReadable=!0,t=0),e.length-=t,0!==e.length||e.ended||(e.needReadable=!0),e.ended&&!e.endEmitted&&0===e.length&&b(this),i},i.prototype._read=function(t){this.emit("error",new Error("not implemented"))},i.prototype.pipe=function(t,e){function r(t){t===p&&o()}function i(){t.end()}function o(){t.removeListener("close",a),t.removeListener("finish",u),t.removeListener("drain",d),t.removeListener("error",s),t.removeListener("unpipe",r),p.removeListener("end",i),p.removeListener("end",o),(!t._writableState||t._writableState.needDrain)&&d()}function s(e){l(),0===g&&0===E.listenerCount(t,"error")&&t.emit("error",e)}function a(){t.removeListener("finish",u),l()}function u(){t.removeListener("close",a),l()}function l(){p.unpipe(t)}var p=this,h=this._readableState;switch(h.pipesCount){case 0:h.pipes=t;break;case 1:h.pipes=[h.pipes,t];break;default:h.pipes.push(t)}h.pipesCount+=1;var c=(!e||e.end!==!1)&&t!==n.stdout&&t!==n.stderr,f=c?i:o;h.endEmitted?M(f):p.once("end",f),t.on("unpipe",r);var d=m(p);t.on("drain",d);var g=E.listenerCount(t,"error");return t.once("error",s),t.once("close",a),t.once("finish",u),t.emit("pipe",p),h.flowing||(this.on("readable",y),h.flowing=!0,M(function(){v(p)})),t},i.prototype.unpipe=function(t){var e=this._readableState;if(0===e.pipesCount)return this;if(1===e.pipesCount)return t&&t!==e.pipes?this:(t||(t=e.pipes),e.pipes=null,e.pipesCount=0,this.removeListener("readable",y),e.flowing=!1,t&&t.emit("unpipe",this),this);if(!t){var n=e.pipes,r=e.pipesCount;e.pipes=null,e.pipesCount=0,this.removeListener("readable",y),e.flowing=!1;for(var i=0;r>i;i++)n[i].emit("unpipe",this);return this}var i=x(e.pipes,t);return-1===i?this:(e.pipes.splice(i,1),e.pipesCount-=1,1===e.pipesCount&&(e.pipes=e.pipes[0]),t.emit("unpipe",this),this)},i.prototype.on=function(t,e){var n=S.prototype.on.call(this,t,e);if("data"!==t||this._readableState.flowing||g(this),"readable"===t&&this.readable){var r=this._readableState;r.readableListening||(r.readableListening=!0,r.emittedReadable=!1,r.needReadable=!0,r.reading?r.length&&h(this,r):this.read(0))}return n},i.prototype.addListener=i.prototype.on,i.prototype.resume=function(){g(this),this.read(0),this.emit("resume")},i.prototype.pause=function(){g(this,!0),this.emit("pause")},i.prototype.wrap=function(t){var e=this._readableState,n=!1,r=this;t.on("end",function(){if(e.decoder&&!e.ended){var t=e.decoder.end();t&&t.length&&r.push(t)}r.push(null)}),t.on("data",function(i){if(e.decoder&&(i=e.decoder.write(i)),i&&(e.objectMode||i.length)){var o=r.push(i);o||(n=!0,t.pause())}});for(var i in t)"function"==typeof t[i]&&"undefined"==typeof this[i]&&(this[i]=function(e){return function(){return t[e].apply(t,arguments)}}(i));var o=["error","close","destroy","pause","resume"];return w(o,function(e){t.on(e,function(t){return r.emit.apply(r,e,t)})}),r._read=function(e){n&&(n=!1,t.resume())},r},i._fromList=_}).call(this,t("1YiZ5S"))},{"./index.js":12,"1YiZ5S":10,buffer:5,events:8,inherits:9,"process/browser.js":13,string_decoder:18}],16:[function(t,e,n){function r(t,e){this.afterTransform=function(t,n){return i(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null}function i(t,e,n){var r=t._transformState;r.transforming=!1;var i=r.writecb;if(!i)return t.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,null!==n&&void 0!==n&&t.push(n),i&&i(e);var o=t._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&t._read(o.highWaterMark)}function o(t){if(!(this instanceof o))return new o(t);a.call(this,t);var e=(this._transformState=new r(t,this),this);this._readableState.needReadable=!0,this._readableState.sync=!1,this.once("finish",function(){"function"==typeof this._flush?this._flush(function(t){s(e,t)}):s(e)})}function s(t,e){if(e)return t.emit("error",e);var n=t._writableState,r=(t._readableState,t._transformState);if(n.length)throw new Error("calling transform done when ws.length != 0");if(r.transforming)throw new Error("calling transform done when still transforming");return t.push(null)}e.exports=o;var a=t("./duplex.js"),u=t("inherits");u(o,a),o.prototype.push=function(t,e){return this._transformState.needTransform=!1,a.prototype.push.call(this,t,e)},o.prototype._transform=function(t,e,n){throw new Error("not implemented")},o.prototype._write=function(t,e,n){var r=this._transformState;if(r.writecb=n,r.writechunk=t,r.writeencoding=e,!r.transforming){var i=this._readableState;(r.needTransform||i.needReadable||i.length<i.highWaterMark)&&this._read(i.highWaterMark)}},o.prototype._read=function(t){var e=this._transformState;e.writechunk&&e.writecb&&!e.transforming?(e.transforming=!0,this._transform(e.writechunk,e.writeencoding,e.afterTransform)):e.needTransform=!0}},{"./duplex.js":11,inherits:9}],17:[function(t,e,n){function r(t,e,n){this.chunk=t,this.encoding=e,this.callback=n}function i(t,e){t=t||{};var n=t.highWaterMark;this.highWaterMark=n||0===n?n:16384,this.objectMode=!!t.objectMode,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var r=t.decodeStrings===!1;this.decodeStrings=!r,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(t){f(e,t)},this.writecb=null,this.writelen=0,this.buffer=[]}function o(t){return this instanceof o||this instanceof k.Duplex?(this._writableState=new i(t,this),this.writable=!0,void k.call(this)):new o(t)}function s(t,e,n){var r=new Error("write after end");t.emit("error",r),E(function(){n(r)})}function a(t,e,n,r){var i=!0;if(!S.isBuffer(n)&&"string"!=typeof n&&null!==n&&void 0!==n&&!e.objectMode){var o=new TypeError("Invalid non-string/buffer chunk");t.emit("error",o),E(function(){r(o)}),i=!1}return i}function u(t,e,n){return t.objectMode||t.decodeStrings===!1||"string"!=typeof e||(e=new S(e,n)),e}function l(t,e,n,i,o){n=u(e,n,i);var s=e.objectMode?1:n.length;e.length+=s;var a=e.length<e.highWaterMark;return e.needDrain=!a,e.writing?e.buffer.push(new r(n,i,o)):p(t,e,s,n,i,o),a}function p(t,e,n,r,i,o){e.writelen=n,e.writecb=o,e.writing=!0,e.sync=!0,t._write(r,i,e.onwrite),e.sync=!1}function h(t,e,n,r,i){n?E(function(){i(r)}):i(r),t.emit("error",r)}function c(t){t.writing=!1,t.writecb=null,t.length-=t.writelen,t.writelen=0}function f(t,e){var n=t._writableState,r=n.sync,i=n.writecb;if(c(n),e)h(t,n,r,e,i);else{var o=y(t,n);o||n.bufferProcessing||!n.buffer.length||v(t,n),r?E(function(){d(t,n,o,i)}):d(t,n,o,i)}}function d(t,e,n,r){n||m(t,e),r(),n&&g(t,e)}function m(t,e){0===e.length&&e.needDrain&&(e.needDrain=!1,t.emit("drain"))}function v(t,e){e.bufferProcessing=!0;for(var n=0;n<e.buffer.length;n++){var r=e.buffer[n],i=r.chunk,o=r.encoding,s=r.callback,a=e.objectMode?1:i.length;if(p(t,e,a,i,o,s),e.writing){n++;break}}e.bufferProcessing=!1,n<e.buffer.length?e.buffer=e.buffer.slice(n):e.buffer.length=0}function y(t,e){return e.ending&&0===e.length&&!e.finished&&!e.writing}function g(t,e){var n=y(t,e);return n&&(e.finished=!0,t.emit("finish")),n}function _(t,e,n){e.ending=!0,g(t,e),n&&(e.finished?E(n):t.once("finish",n)),e.ended=!0}e.exports=o,o.WritableState=i;var b="undefined"!=typeof Uint8Array?function(t){return t instanceof Uint8Array}:function(t){return t&&t.constructor&&"Uint8Array"===t.constructor.name},w="undefined"!=typeof ArrayBuffer?function(t){return t instanceof ArrayBuffer}:function(t){return t&&t.constructor&&"ArrayBuffer"===t.constructor.name},x=t("inherits"),k=t("./index.js"),E=t("process/browser.js").nextTick,S=t("buffer").Buffer;x(o,k),o.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe. Not readable."))},o.prototype.write=function(t,e,n){var r=this._writableState,i=!1;return"function"==typeof e&&(n=e,e=null),!S.isBuffer(t)&&b(t)&&(t=new S(t)),w(t)&&"undefined"!=typeof Uint8Array&&(t=new S(new Uint8Array(t))),S.isBuffer(t)?e="buffer":e||(e=r.defaultEncoding),"function"!=typeof n&&(n=function(){}),r.ended?s(this,r,n):a(this,r,t,n)&&(i=l(this,r,t,e,n)),i},o.prototype._write=function(t,e,n){n(new Error("not implemented"))},o.prototype.end=function(t,e,n){var r=this._writableState;"function"==typeof t?(n=t,t=null,e=null):"function"==typeof e&&(n=e,e=null),"undefined"!=typeof t&&null!==t&&this.write(t,e),r.ending||r.finished||_(this,r,n)}},{"./index.js":12,buffer:5,inherits:9,"process/browser.js":13}],18:[function(t,e,n){function r(t){if(t&&!a.isEncoding(t))throw new Error("Unknown encoding: "+t)}function i(t){return t.toString(this.encoding)}function o(t){var e=this.charReceived=t.length%2;return this.charLength=e?2:0,e}function s(t){var e=this.charReceived=t.length%3;return this.charLength=e?3:0,e}var a=t("buffer").Buffer,u=n.StringDecoder=function(t){switch(this.encoding=(t||"utf8").toLowerCase().replace(/[-_]/,""),r(t),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=o;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=s;break;default:return void(this.write=i)}this.charBuffer=new a(6),this.charReceived=0,this.charLength=0};u.prototype.write=function(t){for(var e="",n=0;this.charLength;){var r=t.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:t.length;if(t.copy(this.charBuffer,this.charReceived,n,r),this.charReceived+=r-n,n=r,this.charReceived<this.charLength)return"";e=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var i=e.charCodeAt(e.length-1);if(!(i>=55296&&56319>=i)){if(this.charReceived=this.charLength=0,r==t.length)return e;t=t.slice(r,t.length);break}this.charLength+=this.surrogateSize,e=""}var o=this.detectIncompleteChar(t),s=t.length;this.charLength&&(t.copy(this.charBuffer,0,t.length-o,s),this.charReceived=o,s-=o),e+=t.toString(this.encoding,0,s);var s=e.length-1,i=e.charCodeAt(s);if(i>=55296&&56319>=i){var a=this.surrogateSize;return this.charLength+=a,this.charReceived+=a,this.charBuffer.copy(this.charBuffer,a,0,a),this.charBuffer.write(e.charAt(e.length-1),this.encoding),
e.substring(0,s)}return e},u.prototype.detectIncompleteChar=function(t){for(var e=t.length>=3?3:t.length;e>0;e--){var n=t[t.length-e];if(1==e&&n>>5==6){this.charLength=2;break}if(2>=e&&n>>4==14){this.charLength=3;break}if(3>=e&&n>>3==30){this.charLength=4;break}}return e},u.prototype.end=function(t){var e="";if(t&&t.length&&(e=this.write(t)),this.charReceived){var n=this.charReceived,r=this.charBuffer,i=this.encoding;e+=r.slice(0,n).toString(i)}return e}},{buffer:5}],19:[function(t,e,n){var r=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};n.setOrigin=function(t,e,n){var i,o,s,a;return+e===e&&(e=[e]),o=r.call(e,1)>=0?0:n.x,s=r.call(e,2)>=0?0:n.y,a=r.call(e,3)>=0?0:n.z,i=r.call(e,4)>=0?0:n.w,t.set(o,s,a,i)},n.addOrigin=function(){var t;return t=new THREE.Vector4,function(e,r,i){return n.setOrigin(t,r,i),e.add(t)}}(),n.setDimension=function(t,e){var n,r,i,o;return r=1===e?1:0,i=2===e?1:0,o=3===e?1:0,n=4===e?1:0,t.set(r,i,o,n)},n.setDimensionNormal=function(t,e){var n,r,i,o;return r=1===e?1:0,i=2===e?1:0,o=3===e?1:0,n=4===e?1:0,t.set(i,o+r,n,0)},n.recenterAxis=function(){var t;return t=[0,0],function(e,n,r,i){var o,s,a,u,l,p;return null==i&&(i=0),r>0&&(l=e,p=e+n,o=Math.max(Math.abs(l),Math.abs(p)),s=o*i,u=Math.min(l,p),a=Math.max(l,p),e=u+(-o+s-u)*r,n=a+(o+s-a)*r-e),t[0]=e,t[1]=n,t}}()},{}],20:[function(t,e,n){var r;n.getSizes=r=function(t){var e,n;for(n=[],e=t;"string"!=typeof e&&null!=(null!=e?e.length:void 0);)n.push(e.length),e=e[0];return n},n.getDimensions=function(t,e){var n,i,o,s,a,u,l,p,h,c,f,d,m,v,y;return null==e&&(e={}),a=e.items,n=e.channels,y=e.width,s=e.height,i=e.depth,o={},t&&t.length?(v=r(t),p=v.length,o.channels=1!==n&&v.length>1?v.pop():n,o.items=1!==a&&v.length>1?v.pop():a,o.width=1!==y&&v.length>1?v.pop():y,o.height=1!==s&&v.length>1?v.pop():s,o.depth=1!==i&&v.length>1?v.pop():i,u=p,1===n&&u++,1===a&&u>1&&u++,1===y&&u>2&&u++,1===s&&u>3&&u++,l=null!=(h=v.pop())?h:1,1>=u&&(l/=null!=(c=o.channels)?c:1),2>=u&&(l/=null!=(f=o.items)?f:1),3>=u&&(l/=null!=(d=o.width)?d:1),4>=u&&(l/=null!=(m=o.height)?m:1),l=Math.floor(l),null==o.width&&(o.width=l,l=1),null==o.height&&(o.height=l,l=1),null==o.depth&&(o.depth=l,l=1),o):{items:a,channels:n,width:null!=y?y:0,height:null!=s?s:0,depth:null!=i?i:0}},n.repeatCall=function(t,e){switch(e){case 0:return function(){return!0};case 1:return function(){return t()};case 2:return function(){return t(),t()};case 3:return function(){return t(),t(),t(),t()};case 4:return function(){return t(),t(),t(),t()};case 6:return function(){return t(),t(),t(),t(),t(),t()};case 8:return function(){return t(),t(),t(),t(),t(),t()}}},n.makeEmitter=function(t,e,n){var r,i,o,s;for(r=function(){switch(n){case 0:return function(){return!0};case 1:return function(e){return e(t())};case 2:return function(e){return e(t(),t())};case 3:return function(e){return e(t(),t(),t())};case 4:return function(e){return e(t(),t(),t(),t())};case 6:return function(e){return e(t(),t(),t(),t(),t(),t())};case 8:return function(e){return e(t(),t(),t(),t(),t(),t(),t(),t())}}}(),o=null;e>0;)i=Math.min(e,8),s=function(){switch(i){case 1:return function(t){return r(t)};case 2:return function(t){return r(t),r(t)};case 3:return function(t){return r(t),r(t),r(t)};case 4:return function(t){return r(t),r(t),r(t),r(t)};case 5:return function(t){return r(t),r(t),r(t),r(t),r(t)};case 6:return function(t){return r(t),r(t),r(t),r(t),r(t),r(t)};case 7:return function(t){return r(t),r(t),r(t),r(t),r(t),r(t),r(t)};case 8:return function(t){return r(t),r(t),r(t),r(t),r(t),r(t),r(t),r(t)}}}(),o=null!=o?function(t,e){return function(n){return t(n),e(n)}}(s,o):s,e-=i;return s=null!=o?o:function(){return!0},s.reset=t.reset,s.rebind=t.rebind,s},n.getThunk=function(t){var e,n,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T;switch(z=r(t),d=z.length,e=z.pop(),n=z.pop(),i=z.pop(),o=z.pop(),s=!1,d){case 0:T=function(){return 0},T.reset=function(){};break;case 1:l=0,T=function(){return t[l++]},T.reset=function(){return l=0};break;case 2:l=p=0,a=null!=(m=t[p])?m:[],T=function(){var n,r;return r=a[l++],l===e&&(l=0,p++,a=null!=(n=t[p])?n:[]),r},T.reset=function(){var e;l=p=0,a=null!=(e=t[p])?e:[]};break;case 3:l=p=h=0,S=null!=(v=t[h])?v:[],a=null!=(y=S[p])?y:[],T=function(){var r,i,o;return o=a[l++],l===e&&(l=0,p++,p===n&&(p=0,h++,S=null!=(r=t[h])?r:[]),a=null!=(i=S[p])?i:[]),o},T.reset=function(){var e,n;l=p=h=0,S=null!=(e=t[h])?e:[],a=null!=(n=S[p])?n:[]};break;case 4:l=p=h=c=0,M=null!=(g=t[c])?g:[],S=null!=(_=M[h])?_:[],a=null!=(b=S[p])?b:[],T=function(){var r,o,s,u;return u=a[l++],l===e&&(l=0,p++,p===n&&(p=0,h++,h===i&&(h=0,c++,M=null!=(r=t[c])?r:[]),S=null!=(o=M[h])?o:[]),a=null!=(s=S[p])?s:[]),u},T.reset=function(){var e,n,r;l=p=h=c=0,M=null!=(e=t[c])?e:[],S=null!=(n=M[h])?n:[],a=null!=(r=S[p])?r:[]};break;case 5:l=p=h=c=f=0,u=null!=(w=t[f])?w:[],M=null!=(x=u[c])?x:[],S=null!=(k=M[h])?k:[],a=null!=(E=S[p])?E:[],T=function(){var r,s,d,m,v;return v=a[l++],l===e&&(l=0,p++,p===n&&(p=0,h++,h===i&&(h=0,c++,c===o&&(c=0,f++,u=null!=(r=t[f])?r:[]),M=null!=(s=u[c])?s:[]),S=null!=(d=M[h])?d:[]),a=null!=(m=S[p])?m:[]),v},T.reset=function(){var e,n,r,i;l=p=h=c=f=0,u=null!=(e=t[f])?e:[],M=null!=(n=u[c])?n:[],S=null!=(r=M[h])?r:[],a=null!=(i=S[p])?i:[]}}return T.rebind=function(o){return t=o,z=r(t),z.length&&(e=z.pop()),z.length&&(n=z.pop()),z.length&&(i=z.pop()),z.length?o=z.pop():void 0},T},n.getStreamer=function(t,e,n,r){var i,o,s,a,u,l,p,h,c;return p=u=l=0,h=function(){return p=e*n*r,u=l=0},o=function(){return l},s=function(){return 0>=p-u},c=function(){switch(n){case 1:return function(t){u+=t,l+=t};case 2:return function(t){u+=2*t,l+=t};case 3:return function(t){u+=3*t,l+=t};case 4:return function(t){u+=4*t,l+=t}}}(),i=function(){switch(n){case 1:return function(e){e(t[u++]),++l};case 2:return function(e){e(t[u++],t[u++]),++l};case 3:return function(e){e(t[u++],t[u++],t[u++]),++l};case 4:return function(e){e(t[u++],t[u++],t[u++],t[u++]),++l}}}(),a=function(){switch(n){case 1:return function(e){t[u++]=e,++l};case 2:return function(e,n){t[u++]=e,t[u++]=n,++l};case 3:return function(e,n,r){t[u++]=e,t[u++]=n,t[u++]=r,++l};case 4:return function(e,n,r,i){t[u++]=e,t[u++]=n,t[u++]=r,t[u++]=i,++l}}}(),i.reset=h,a.reset=h,h(),{emit:a,consume:i,skip:c,count:o,done:s,reset:h}},n.getLerpEmitter=function(t,e){var n,r,i,o,s,a,u,l,p,h,c;return c=new Float32Array(4096),s=a=.5,u=l=p=h=0,r=function(t,e,n,r){return p++,c[u++]=t*s,c[u++]=e*s,c[u++]=n*s,c[u++]=r*s},i=function(t,e,n,r){return h++,c[l++]+=t*a,c[l++]+=e*a,c[l++]+=n*a,c[l++]+=r*a},n=Math.max(t.length,e.length),o=3>=n?function(n,o,s){var a,f,d,m,v,y;for(u=l=p=h=0,t(r,o,s),e(i,o,s),d=Math.min(p,h),f=0,y=[],a=m=0,v=d;v>=0?v>m:m>v;a=v>=0?++m:--m)y.push(n(c[f++],c[f++],c[f++],c[f++]));return y}:5>=n?function(n,o,s,a,f){var d,m,v,y,g,_;for(u=l=p=h=0,t(r,o,s,a,f),e(i,o,s,a,f),v=Math.min(p,h),m=0,_=[],d=y=0,g=v;g>=0?g>y:y>g;d=g>=0?++y:--y)_.push(n(c[m++],c[m++],c[m++],c[m++]));return _}:7>=n?function(n,o,s,a,f,d,m){var v,y,g,_,b;for(u=l=p=h=0,t(r,o,s,a,f,d,m),e(i,o,s,a,f,d,m),y=Math.min(p,h),v=0,b=[],m=g=0,_=y;_>=0?_>g:g>_;m=_>=0?++g:--g)b.push(n(c[v++],c[v++],c[v++],c[v++]));return b}:9>=n?function(n,o,s,a,f,d,m,v,y){var g,_,b,w;for(u=l=p=h=0,t(r,o,s,a,f,d,m,v,y),e(i,o,s,a,f,d,m,v,y),g=Math.min(p,h),y=0,w=[],v=_=0,b=g;b>=0?b>_:_>b;v=b>=0?++_:--_)w.push(n(c[y++],c[y++],c[y++],c[y++]));return w}:function(n,o,s,a,f,d,m,v,y,g,_){var b,w,x,k;for(u=l=0,t(r,o,s,a,f,d,m,v,y,g,_),e(i,o,s,a,f,d,m,v,y,g,_),b=Math.min(p,h),y=0,k=[],v=w=0,x=b;x>=0?x>w:w>x;v=x>=0?++w:--w)k.push(n(c[y++],c[y++],c[y++],c[y++]));return k},o.lerp=function(t){var e;return e=[1-t,t],s=e[0],a=e[1],e},o},n.getLerpThunk=function(t,e){var r,i,o,s,a,u;return i=n.getSizes(t).reduce(function(t,e){return t*e}),o=n.getSizes(e).reduce(function(t,e){return t*e}),r=Math.min(i,o),a=n.getThunk(t),u=n.getThunk(e),s=new Float32Array(r),s.lerp=function(t){var e,n,i,o;for(a.reset(),u.reset(),i=0,o=[];r>i;)e=a(),n=u(),o.push(s[i++]=e+(n-e)*t);return o},s}},{}],21:[function(t,e,n){var r,i;i=Math.PI,r={clamp:function(t,e,n){return Math.max(e,Math.min(n,t))},cosine:function(t){return.5-.5*Math.cos(r.clamp(t,0,1)*i)},binary:function(t){return+(t>=.5)},hold:function(t){return+(t>=1)}},e.exports=r},{}],22:[function(t,e,n){var r,i,o,s,a,u=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};i="xyzw".split(""),r={0:-1,x:0,y:1,z:2,w:3},o=function(t){return t===""+t&&(t=t.split("")),t===+t&&(t=[t]),t},a=function(t){return t===+t&&(t="vec"+t),"vec1"===t&&(t="float"),t},s=function(t){return t=""+t,t.indexOf(".")<0?t+=".0":void 0},n.mapByte2FloatOffset=function(t){var e;return null==t&&(t=4),e=s(t),"vec4 float2ByteIndex(vec4 xyzw, out float channelIndex) {\n  float relative = xyzw.w / "+e+";\n  float w = floor(relative);\n  channelIndex = (relative - w) * "+e+";\n  return vec4(xyzw.xyz, w);\n}"},n.sample2DArray=function(t){var e,n;return n=function(t,e){var r,i;return t===e?i="return texture2D(dataTextures["+t+"], uv);":(r=Math.ceil(t+(e-t)/2),i="if (z < "+(r-.5)+") {\n  "+n(t,r-1)+"\n}\nelse {\n  "+n(r,e)+"\n}"),i=i.replace(/\n/g,"\n  ")},e=n(0,t-1),"uniform sampler2D dataTextures["+t+"];\n\nvec4 sample2DArray(vec2 uv, float z) {\n  "+e+"\n}"},n.binaryOperator=function(t,e,n){return t=a(t),null!=n?t+" binaryOperator("+t+" a) {\n  return a "+e+" "+n+";\n}":t+" binaryOperator("+t+" a, "+t+" b) {\n  return a "+e+" b;\n}"},n.extendVec=function(t,e,r){var i,o,u,l;return null==r&&(r=0),t>e?n.truncateVec(t,e):(o=e-t,t=a(t),e=a(e),r=s(r),u=function(){l=[];for(var t=0;o>=0?o>=t:t>=o;o>=0?t++:t--)l.push(t);return l}.apply(this).map(function(t){return t?r:"v"}),i=u.join(","),e+" extendVec("+t+" v) { return "+e+"("+i+"); }")},n.truncateVec=function(t,e){var r;return e>t?n.extendVec(t,e):(r="."+"xyzw".substr(0,e),t=a(t),e=a(e),e+" truncateVec("+t+" v) { return v"+r+"; }")},n.injectVec4=function(t){var e,n,i,s,a,u,l;for(l=["0.0","0.0","0.0","0.0"],t=o(t),t=t.map(function(t){return t===""+t?r[t]:t}),i=s=0,a=t.length;a>s;i=++s)n=t[i],l[n]=["a","b","c","d"][i];return u=l.slice(0,4).join(", "),e=["float a","float b","float c","float d"].slice(0,t.length),"vec4 inject("+e+") {\n  return vec4("+u+");\n}"},n.swizzleVec4=function(t,e){var n,i;for(null==e&&(e=null),n=["0.0","xyzw.x","xyzw.y","xyzw.z","xyzw.w"],null==e&&(e=t.length),t=o(t),t=t.map(function(t){var e;return e=+t,u.call([0,1,2,3,4],e)>=0&&(t=+t),t===""+t&&(t=r[t]+1),n[t]});t.length<e;)t.push("0.0");return i=t.join(", "),("vec"+e+" swizzle(vec4 xyzw) {\n  return vec"+e+"("+i+");\n}").replace(/vec1/g,"float")},n.invertSwizzleVec4=function(t){var e,n,s,a,u,l,p,h;for(h=["0.0","0.0","0.0","0.0"],t=o(t),t=t.map(function(t){return t===+t?i[t-1]:t}),e=s=0,a=t.length;a>s;e=++s)u=t[e],p=i[e],n=r[u],h[n]="xyzw."+p;return l=h.join(", "),"vec4 invertSwizzle(vec4 xyzw) {\n  return vec4("+l+");\n}"},n.identity=function(t){var e;return e=[].slice.call(arguments),e.length>1?(e=e.map(function(t,e){return["inout",t,String.fromCharCode(97+e)].join(" ")}),e=e.join(", "),"void identity("+e+") { }"):t+" identity("+t+" x) {\n  return x;\n}"},n.constant=function(t,e){return t+" constant() {\n  return "+e+";\n}"},n.toType=a},{}],23:[function(t,e,n){n.Axis=t("./axis"),n.Data=t("./data"),n.Ease=t("./ease"),n.GLSL=t("./glsl"),n.JS=t("./js"),n.Pretty=t("./pretty"),n.Three=t("./three"),n.Ticks=t("./ticks"),n.VDOM=t("./vdom")},{"./axis":19,"./data":20,"./ease":21,"./glsl":22,"./js":24,"./pretty":25,"./three":26,"./ticks":27,"./vdom":28}],24:[function(t,e,n){n.merge=function(){var t,e,n,r,i,o;for(o={},t=0,n=arguments.length;n>t;t++){r=arguments[t];for(e in r)i=r[e],o[e]=i}return o},n.clone=function(t){return JSON.parse(JSON.serialize(t))},n.parseQuoted=function(t){var e,n,r,i,o,s,a,u,l,p;for(e="",p=function(t){return t=t.replace(/\\/g,"")},a=function(t){return e.length&&s.push(p(e)),e=null!=t?t:""},t=t.split(/(?=(?:\\.|["' ,]))/g),u=!1,s=[],i=0,o=t.length;o>i;i++)switch(r=t[i],n=r[0],l=r.slice(1),n){case'"':case"'":if(u)u===n?(u=!1,a(l)):e+=r;else{if(""!==e)throw new Error("ParseError: String `"+t+"` does not contain comma-separated quoted tokens.");u=n,e+=l}break;case" ":case",":u?e+=r:a(l);break;default:e+=r}return a(),s}},{}],25:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;r=5,i=1e-4,o=function(t,e){return Math.abs(t/e-Math.round(t/e))<i},s=function(t){return o(t,1)},p=function(t,e,n,r){var i;return i=Math.round(t/e),1===i?""+n:-1===i?"-"+n:"1"===n?""+i:r?""+i+n:i+"*"+n},l=function(t,e,n,r){var i;return i=Math.round(t*e),1===Math.abs(i)?(i=0>i?"-":"",i+=n):"1"!==n&&(i+=r?""+n:"*"+n),i+"/"+e},u=[{1:1},{1:1,"τ":2*Math.PI},{1:1,"π":Math.PI},{1:1,"τ":2*Math.PI,"π":Math.PI},{1:1,e:Math.E},{1:1,"τ":2*Math.PI,e:Math.E},{1:1,"π":Math.PI,e:Math.E},{1:1,"τ":2*Math.PI,"π":Math.PI,e:Math.E}],h=[[420,[2,3,5,7]],[88200,[2,3,5,7]],[60060,[2,3,5,7,11,13]],[861764,[2,17,19,23,29]],[65536,[2]],[1e6,[2,5]]],y=function(t){var e,n,o,a,c,f,d,m,v,y;return t&&(e=t.cache,o=t.compact,v=t.tau,d=t.pi,a=t.e,y=t.threshold,m=t.precision),o=+!!(null!=o?o:!0),v=+!!(null!=v?v:!0),d=+!!(null!=d?d:!0),a=+!!(null!=a?a:!0),e=+!!(null!=e?e:!0),y=+(null!=y?y:i),m=+(null!=m?m:r),c=v+2*d+4*a,n=c+y+m,f=e?{}:null,function(t){var e,n,i,a,d,m,v,y,g,_,b,w,x,k,E,S,z,M;if(null!=f){if(null!=(n=f[t]))return n;if(t===Math.round(t))return f[t]=""+t}E=""+t,e=E.length+E.indexOf(".")+2,w=function(t){var n;return n=t.length,e>=n?(E=""+t,e=n):void 0},z=u[c];for(y in z)if(d=z[y],s(t/d))w(""+p(t/d,1,y,o));else for(m=0,g=h.length;g>m;m++)if(M=h[m],a=M[0],b=M[1],k=t/d*a,s(k)){for(v=0,_=b.length;_>v;v++)for(S=b[v];s(x=k/S)&&s(i=a/S);)k=x,a=i;w(""+l(t/d,a,y,o));break}return(""+t).length>r&&w(""+t.toPrecision(r)),null!=f&&(f[t]=E),E}},g=function(t,e){return null==e&&(e="info"),t=v(t),console[e].apply(console,t)},v=function(t){var e,n,r,i,o,s,a,u;return a="color:rgb(128,0,128)",n="color:rgb(144,64,0)",s="color:rgb(0,0,192)",i="color:rgb(0,70,156)",u="color:inherit",o=!1,r=0,e=[],t=t.replace(/(\\[<={}> "'])|(=>|[<={}> "'])/g,function(t,l,p){var h;return(null!=l?l.length:void 0)?l:o&&'"'!==p&&"'"!==p?p:r&&'"'!==p&&"'"!==p&&"{"!==p&&"}"!==p?p:h=function(){switch(p){case"<":return e.push(a),"%c<";case">":return e.push(a),e.push(u),"%c>%c";case" ":return e.push(n)," %c";case"=":case"=>":return e.push(a),"%c"+p;case'"':case"'":return o=!o,o?(e.push(r?n:s),p+"%c"):(e.push(r?i:a),"%c"+p);case"{":return 0===r++?(e.push(i),"%c"+p):p;case"}":return 0===--r?(e.push(a),p+"%c"):p;default:return p}}()}),[t].concat(e)},m=function(t,e){return d(t,e,"=")},f=function(t,e){return d(t,e,"=>")},d=function(){var t;return t=y({compact:!1}),function(e,n,r){var i,o,s;return i=function(t){return t===""+ +t||t.match(/^[A-Za-z_][A-Za-z0-9]*$/)?t:JSON.stringify(t)},s=function(t){return t.match('\n*"')?t:"{"+t+"}"},o=function(e){var n,r;if(e instanceof Array)return"["+e.map(o).join(", ")+"]";switch(typeof e){case"string":return e.match("\n")?'"\n'+e+'"\n':'"'+e+'"';case"function":return e=""+e,e.match("\n"),e=e.replace(/^function (\([^)]+\))/,"$1 =>"),e=e.replace(/^(\([^)]+\)) =>\s*{\s*return\s*([^}]+)\s*;\s*}/,"$1 => $2");case"number":return t(e);default:return null!=e&&e!==!!e?null!=e._up?o(e.map(function(t){return t})):e.toMarkup?e.toString():"{"+function(){var t;t=[];for(n in e)r=e[n],e.hasOwnProperty(n)&&t.push(i(n)+": "+o(r));return t}().join(", ")+"}":""+JSON.stringify(e)}},[e,r,s(o(n))].join("")}}(),a=function(t){return t=t.replace(/&/g,"&amp;"),t=t.replace(/</g,"&lt;"),t=t.replace(/"/g,"&quot;")},c=function(t){var e,n,r,i,o;for(n=[].slice.call(arguments),n.shift(),o="<span>",t=a(t),r=0,i=n.length;i>r;r++)e=n[r],t=t.replace(/%([a-z])/,function(t,e){var r;switch(r=n.shift(),e){case"c":return'</span><span style="'+a(r)+'">';default:return a(r)}});return o+=t,o+="</span>"},e.exports={markup:v,number:y,print:g,format:c,JSX:{prop:m,bind:f}}},{}],26:[function(t,e,n){n.paramToGL=function(t,e){return e===THREE.RepeatWrapping?t.REPEAT:e===THREE.ClampToEdgeWrapping?t.CLAMP_TO_EDGE:e===THREE.MirroredRepeatWrapping?t.MIRRORED_REPEAT:e===THREE.NearestFilter?t.NEAREST:e===THREE.NearestMipMapNearestFilter?t.NEAREST_MIPMAP_NEAREST:e===THREE.NearestMipMapLinearFilter?t.NEAREST_MIPMAP_LINEAR:e===THREE.LinearFilter?t.LINEAR:e===THREE.LinearMipMapNearestFilter?t.LINEAR_MIPMAP_NEAREST:e===THREE.LinearMipMapLinearFilter?t.LINEAR_MIPMAP_LINEAR:e===THREE.UnsignedByteType?t.UNSIGNED_BYTE:e===THREE.UnsignedShort4444Type?t.UNSIGNED_SHORT_4_4_4_4:e===THREE.UnsignedShort5551Type?t.UNSIGNED_SHORT_5_5_5_1:e===THREE.UnsignedShort565Type?t.UNSIGNED_SHORT_5_6_5:e===THREE.ByteType?t.BYTE:e===THREE.ShortType?t.SHORT:e===THREE.UnsignedShortType?t.UNSIGNED_SHORT:e===THREE.IntType?t.INT:e===THREE.UnsignedIntType?t.UNSIGNED_INT:e===THREE.FloatType?t.FLOAT:e===THREE.AlphaFormat?t.ALPHA:e===THREE.RGBFormat?t.RGB:e===THREE.RGBAFormat?t.RGBA:e===THREE.LuminanceFormat?t.LUMINANCE:e===THREE.LuminanceAlphaFormat?t.LUMINANCE_ALPHA:e===THREE.AddEquation?t.FUNC_ADD:e===THREE.SubtractEquation?t.FUNC_SUBTRACT:e===THREE.ReverseSubtractEquation?t.FUNC_REVERSE_SUBTRACT:e===THREE.ZeroFactor?t.ZERO:e===THREE.OneFactor?t.ONE:e===THREE.SrcColorFactor?t.SRC_COLOR:e===THREE.OneMinusSrcColorFactor?t.ONE_MINUS_SRC_COLOR:e===THREE.SrcAlphaFactor?t.SRC_ALPHA:e===THREE.OneMinusSrcAlphaFactor?t.ONE_MINUS_SRC_ALPHA:e===THREE.DstAlphaFactor?t.DST_ALPHA:e===THREE.OneMinusDstAlphaFactor?t.ONE_MINUS_DST_ALPHA:e===THREE.DstColorFactor?t.DST_COLOR:e===THREE.OneMinusDstColorFactor?t.ONE_MINUS_DST_COLOR:e===THREE.SrcAlphaSaturateFactor?t.SRC_ALPHA_SATURATE:0},n.paramToArrayStorage=function(t){switch(t){case THREE.UnsignedByteType:return Uint8Array;case THREE.ByteType:return Int8Array;case THREE.ShortType:return Int16Array;case THREE.UnsignedShortType:return Uint16Array;case THREE.IntType:return Int32Array;case THREE.UnsignedIntType:return Uint32Array;case THREE.FloatType:return Float32Array}},n.swizzleToEulerOrder=function(t){return t.map(function(t){return["","X","Y","Z"][t]}).join("")},n.transformComposer=function(){var t,e,r,i,o;return t=new THREE.Euler,r=new THREE.Quaternion,e=new THREE.Vector3,i=new THREE.Vector3,o=new THREE.Matrix4,function(s,a,u,l,p,h){return null==h&&(h="XYZ"),null!=a?(h instanceof Array&&(h=n.swizzleToEulerOrder(h)),t.setFromVector3(a,h),r.setFromEuler(t)):r.set(0,0,0,1),null!=u&&r.multiply(u),null!=s?e.copy(s):e.set(0,0,0),null!=l?i.copy(l):i.set(1,1,1),o.compose(e,r,i),null!=p&&o.multiplyMatrices(o,p),o}}},{}],27:[function(t,e,n){var r,i,o,s,a;o=function(t,e,n,r,i,o,s,a,u,l){var p,h,c,f,d,m,v,y,g,_;return null==l&&(l=!0),n||(n=10),r||(r=1),i||(i=10),o||(o=1),v=e-t,d=v/n,l?(r||(r=1),i||(i=10),m=r*Math.pow(i,Math.floor(Math.log(d/r)/Math.log(i))),c=i%2===0?[i/2,1,.5]:i%3===0?[i/3,1,1/3]:[1],g=function(){var t,e,n;for(n=[],t=0,e=c.length;e>t;t++)h=c[t],n.push(m*h);return n}(),p=1/0,y=g.reduce(function(t,e){var n;return h=e/d,n=Math.max(h,1/h),p>n?(p=n,e):t},m),y*=o,t=Math.ceil(t/y+ +!s)*y,e=(Math.floor(e/y)-+!a)*y,n=Math.ceil((e-t)/y),_=function(){var e,r,i;for(i=[],f=e=0,r=n;r>=0?r>=e:e>=r;f=r>=0?++e:--e)i.push(t+f*y);return i}(),u||(_=_.filter(function(t){return 0!==t})),_):(_=function(){var e,r,i;for(i=[],f=e=0,r=n;r>=0?r>=e:e>=r;f=r>=0?++e:--e)i.push(t+f*d);return i}(),s||_.shift(),a||_.pop(),u||(_=_.filter(function(t){return 0!==t})),_)},s=function(t,e,n,r,i,o,s,a,u,l){throw new Error("Log ticks not yet implemented.")},r=0,i=1,a=function(t,e,n,a,u,l,p,h,c,f,d){switch(t){case r:return o(e,n,a,u,l,p,h,c,f,d);case i:return s(e,n,a,u,l,p,h,c,f,d)}},n.make=a,n.linear=o,n.log=s},{}],28:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;for(r=[],p=0,i={},a=function(){return{id:p++,type:null,props:null,children:null,rendered:null,instance:null}},l=function(t){var e,n,i,o;for(t*=2,t=Math.max(0,r.length-t),o=[],e=n=0,i=t;i>=0?i>n:n>i;e=i>=0?++n:--n)o.push(r.push(a()));return o},u=function(t,e,n){var i;return i=r.length?r.pop():a(),i.type=null!=t?t:"div",i.props=null!=e?e:null,i.children=null!=n?n:null,i},y=function(t){var e,n,i,o;if(t.type&&(n=t.children,t.type=t.props=t.children=t.instance=null,r.push(t),null!=n))for(i=0,o=n.length;o>i;i++)e=n[i],y(e)},o=function(t,e,n,r,s){var a,l,p,h,c,f,d,v,y,g,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H;if(null!=t){if(null==e)return m(t,r,s);if(t instanceof Node){if(j=t===e)return}else j=typeof t==typeof e&&null!==e&&null!==t&&t.type===e.type;if(j){if(t.instance=e.instance,U=(null!=(R=t.type)?R.isComponentClass:void 0)?t.type:i[t.type],A=null!=e?e.props:void 0,z=t.props,h=null!=(C=null!=e?e.children:void 0)?C:null,S=t.children,null!=z&&(z.children=S),null!=U){if(f=n._COMPONENT_DIRTY,null!=A!=(null!=z)&&(f=!0),h!==S&&(f=!0),null!=A&&null!=z){if(!f)for(g in A)z.hasOwnProperty(g)||(f=!0);if(!f)for(g in z)H=z[g],(P=A[g])!==H&&(f=!0)}if(f){c=e.instance,null==t.props&&(t.props={}),I=c.defaultProps;for(y in I)F=I[y],null==(a=t.props)[y]&&(a[y]=F);t.props.children=t.children,"function"==typeof c.willReceiveProps&&c.willReceiveProps(t.props),N=n._COMPONENT_FORCE||(null!=(D="function"==typeof c.shouldUpdate?c.shouldUpdate(t.props):void 0)?D:!0),N&&(M=c.getNextState(),"function"==typeof c.willUpdate&&c.willUpdate(t.props,M)),T=c.props,O=c.applyNextState(),c.props=t.props,c.children=t.children,N&&(t=t.rendered="function"==typeof c.render?c.render(u,t.props,t.children):void 0,o(t,e.rendered,n,r,s),"function"==typeof c.didUpdate&&c.didUpdate(T,O))}return}if(null!=A)for(g in A)z.hasOwnProperty(g)||w(n,g,A[g]);if(null!=z)for(g in z)H=z[g],(P=A[g])!==H&&"children"!==g&&_(n,g,H,P);if(null!=S)if("string"==(L=typeof S)||"number"===L)S!==h&&(n.textContent=S);else if(null!=S.type)o(S,h,n.childNodes[0],n,0);else if(p=n.childNodes,null!=h)for(d=v=0,k=S.length;k>v;d=++v)l=S[d],o(l,h[d],p[d],n,d);else for(d=x=0,E=S.length;E>x;d=++x)l=S[d],o(l,null,p[d],n,d);else null!=h&&(b(null,n),n.innerHTML="");return}return b(e.instance,n),n.remove(),m(t,r,s)}return null!=e?(b(e.instance,n),e.node.remove()):void 0},m=function(t,e,n){var r,o,s,a,l,p,h,c,f,d,v,y,g,b,w,x,k,E,S,z;if(null==n&&(n=0),E=(null!=(y=t.type)?y.isComponentClass:void 0)?t.type:i[t.type],t instanceof Node)v=t;else{if(null!=E){if(l=(null!=(g=t.type)?g.isComponentClass:void 0)?t.type:i[t.type],!l)return t=t.rendered=u("noscript"),v=m(t,e,n);t.instance=a=new l(e),null==t.props&&(t.props={}),b=a.defaultProps;for(c in b)S=b[c],null==(r=t.props)[c]&&(r[c]=S);return t.props.children=t.children,a.props=t.props,a.children=t.children,a.setState("function"==typeof a.getInitialState?a.getInitialState():void 0),"function"==typeof a.willMount&&a.willMount(),t=t.rendered="function"==typeof a.render?a.render(u,t.props,t.children):void 0,v=m(t,e,n),"function"==typeof a.didMount&&a.didMount(t),v._COMPONENT=a,v}if("string"==(w=typeof t)||"number"===w)v=document.createTextNode(t);else{v=document.createElement(t.type),x=t.props;for(f in x)z=x[f],_(v,f,z)}if(s=t.children,null!=s)if("string"==(k=typeof s)||"number"===k)v.textContent=s;else if(null!=s.type)m(s,v,0);else for(p=h=0,d=s.length;d>h;p=++h)o=s[p],m(o,v,p)}return e.insertBefore(v,e.childNodes[n]),v},b=function(t,e){var n,r,i,o,s,a;if(t){"function"==typeof t.willUnmount&&t.willUnmount();for(i in t)delete t[i]}for(s=e.childNodes,a=[],r=0,o=s.length;o>r;r++)n=s[r],b(n._COMPONENT,n),a.push(delete n._COMPONENT);return a},v=function(t){var e,n,r,i;if("undefined"==typeof document)return!0;if(null!=document.documentElement.style[t])return t;for(t=t[0].toUpperCase()+t.slice(1),i=["webkit","moz","ms","o"],e=0,n=i.length;n>e;e++)if(r=i[e],null!=document.documentElement.style[r+t])return r+t},d={},g=["transform"],h=0,f=g.length;f>h;h++)c=g[h],d[c]=v(c);_=function(t,e,n,r){var i,o,s;{if("style"!==e)return null!=t[e]?void(t[e]=n):void(t instanceof Node&&t.setAttribute(e,n));for(i in n)s=n[i],(null!=r?r[i]:void 0)!==s&&(t.style[null!=(o=d[i])?o:i]=s)}},w=function(t,e,n){var r,i,o;if("style"!==e)null!=t[e]&&(t[e]=void 0),t instanceof Node&&t.removeAttribute(e);else for(r in n)o=n[r],t.style[null!=(i=d[r])?i:r]=""},s=function(t){var e,n,r,i,o;r={willMount:"componentWillMount",didMount:"componentDidMount",willReceiveProps:"componentWillReceiveProps",shouldUpdate:"shouldComponentUpdate",willUpdate:"componentWillUpdate",didUpdate:"componentDidUpdate",willUnmount:"componentWillUnmount"};for(n in r)i=r[n],null==t[n]&&(t[n]=t[i]);return e=function(){function e(e,n,r,i){var o,s,a,u;this.props=null!=n?n:{},this.state=null!=r?r:null,this.children=null!=i?i:null,o=function(t,e){return"function"==typeof t?t.bind(e):t};for(s in t)u=t[s],this[s]=o(u,this);a=null,this.setState=function(t){null==a&&(a=t?null!=a?a:{}:null);for(s in t)u=t[s],a[s]=u;e._COMPONENT_DIRTY=!0},this.forceUpdate=function(){var t,n;for(e._COMPONENT_FORCE=e._COMPONENT_DIRTY=!0,t=e,n=[];t=t.parentNode;)t._COMPONENT?n.push(t._COMPONENT_FORCE=!0):n.push(void 0);return n},this.getNextState=function(){return a},this.applyNextState=function(){var t,n;return e._COMPONENT_FORCE=e._COMPONENT_DIRTY=!1,t=this.state,n=[null,a],a=n[0],this.state=n[1],t}}return e}(),e.isComponentClass=!0,e.prototype.defaultProps=null!=(o="function"==typeof t.getDefaultProps?t.getDefaultProps():void 0)?o:{},e},e.exports={element:u,recycle:y,apply:o,hint:l,Types:i,createClass:s}},{}],29:[function(t,e,n){var r,i,o,s,a,u,l,p;i=t("./model"),o=t("./overlay"),s=t("./primitives"),a=t("./render"),u=t("./shaders"),l=t("./stage"),p=t("./util"),r=function(){function t(t,e,n){var r;null==e&&(e=null),null==n&&(n=null),this.canvas=r=t.domElement,this.element=null,this.shaders=new u.Factory(u.Snippets),this.renderables=new a.Factory(a.Classes,t,this.shaders),this.overlays=new o.Factory(o.Classes,r),this.scene=this.renderables.make("scene",{scene:e}),this.camera=this.defaultCamera=null!=n?n:new THREE.PerspectiveCamera,this.attributes=new i.Attributes(s.Types,this),this.primitives=new s.Factory(s.Types,this),this.root=this.primitives.make("root"),this.model=new i.Model(this.root),this.guard=new i.Guard,this.controller=new l.Controller(this.model,this.primitives),this.animator=new l.Animator(this),this.api=new l.API(this),this.speed=1,this.time={now:+new Date/1e3,time:0,delta:0,clock:0,step:0}}return t.Namespace={Model:i,Overlay:o,Primitives:s,Render:a,Shaders:u,Stage:l,Util:p,DOM:p.VDOM},t.prototype.init=function(){return this.scene.inject(),this.overlays.inject(),this},t.prototype.destroy=function(){return this.scene.unject(),this.overlays.unject(),this},t.prototype.resize=function(t){return null==t&&(t={}),null==t.renderWidth&&(t.renderWidth=null!=t.viewWidth?t.viewWidth:t.viewWidth=1280),null==t.renderHeight&&(t.renderHeight=null!=t.viewHeight?t.viewHeight:t.viewHeight=720),null==t.pixelRatio&&(t.pixelRatio=t.renderWidth/Math.max(1e-6,t.viewWidth)),null==t.aspect&&(t.aspect=t.viewWidth/Math.max(1e-6,t.viewHeight)),this.root.controller.resize(t),this},t.prototype.frame=function(t){return this.pre(t),this.update(),this.render(),this.post(),this},t.prototype.pre=function(t){var e;return t||(t={now:+new Date/1e3,time:0,delta:0,clock:0,step:0},t.delta=null!=this.time.now?t.now-this.time.now:0,t.delta>1&&(t.delta=1/60),t.step=t.delta*this.speed,t.time=this.time.time+t.delta,t.clock=this.time.clock+t.step),this.time=t,"function"==typeof(e=this.root.controller).pre&&e.pre(),this},t.prototype.update=function(){var t;return this.animator.update(),this.attributes.compute(),this.guard.iterate({step:function(t){return function(){var e;return e=t.attributes.digest(),e||(e=t.model.digest())}}(this),last:function(){return{attribute:this.attributes.getLastTrigger(),model:this.model.getLastTrigger()}}}),"function"==typeof(t=this.root.controller).update&&t.update(),this.camera=this.root.controller.getCamera(),this.speed=this.root.controller.getSpeed(),this},t.prototype.render=function(){var t;return"function"==typeof(t=this.root.controller).render&&t.render(),this.scene.render(),this},t.prototype.post=function(){var t;return"function"==typeof(t=this.root.controller).post&&t.post(),this},t.prototype.setWarmup=function(t){return this.scene.warmup(t),this},t.prototype.getPending=function(){return this.scene.pending.length},t}(),e.exports=r},{"./model":34,"./overlay":40,"./primitives":43,"./render":149,"./shaders":164,"./stage":169,"./util":175}],30:[function(t,e,n){var r,i,o,s,a;o=function(t){var e,n;return n=THREE.Bootstrap(t),n.fallback||(n.Time||n.install("time"),n.MathBox||n.install(["mathbox","splash"])),null!=(e=n.mathbox)?e:n},window.π=Math.PI,window.τ=2*π,window.e=Math.E,window.MathBox=n,window.mathBox=n.mathBox=o,n.version="0.0.5",n.Context=r=t("./context"),s=r.Namespace;for(i in s)a=s[i],n[i]=a;t("./splash"),THREE.Bootstrap.registerPlugin("mathbox",{defaults:{init:!0,warmup:2,inspect:!0,splash:!0},listen:["ready","pre","update","post","resize"],install:function(t){var e;return e=!1,this.first=!0,t.MathBox={init:function(n){return function(i){var o,s;if(!e)return e=!0,s=(null!=i?i.scene:void 0)||n.options.scene||t.scene,o=(null!=i?i.camera:void 0)||n.options.camera||t.camera,n.context=new r(t.renderer,s,o),n.context.api.three=t.three=t,n.context.api.mathbox=t.mathbox=n.context.api,n.context.api.start=function(){return t.Loop.start()},n.context.api.stop=function(){return t.Loop.stop()},n.context.init(),n.context.resize(t.Size),n.context.setWarmup(n.options.warmup),n.pending=0,n.warm=!n.options.warmup,console.log("MathBox²",MathBox.version),t.trigger({type:"mathbox/init",version:MathBox.version,context:n.context})}}(this),destroy:function(n){return function(){return e?(e=!1,t.trigger({type:"mathbox/destroy",context:n.context}),n.context.destroy(),delete t.mathbox,delete n.context.api.three,delete n.context):void 0}}(this),object:function(t){return function(){var e;return null!=(e=t.context)?e.scene.root:void 0}}(this)}},uninstall:function(t){return t.MathBox.destroy(),delete t.MathBox},ready:function(t,e){return this.options.init?(e.MathBox.init(),setTimeout(function(t){return function(){return t.options.inspect?t.inspect(e):void 0}}(this))):void 0},inspect:function(t){return this.context.api.inspect(),this.options.warmup?void 0:this.info(t)},info:function(t){var e,n;return e=function(t){var e;for(e=[];t>=1e3;)e.unshift(("000"+t%1e3).slice(-3)),t=Math.floor(t/1e3);return e.unshift(t),e.join(",")},n=t.renderer.info.render,console.log("Geometry  ",e(n.faces)+" faces  ",e(n.vertices)+" vertices  ",e(n.calls)+" draw calls  ")},resize:function(t,e){var n;return null!=(n=this.context)?n.resize(e.Size):void 0},pre:function(t,e){var n;return null!=(n=this.context)?n.pre(e.Time):void 0},update:function(t,e){var n,r,i,o;return null!=(r=this.context)&&r.update(),(n=null!=(i=this.context)?i.camera:void 0)&&n!==e.camera&&(e.camera=n),e.Time.set({speed:this.context.speed}),this.progress(this.context.getPending(),e),null!=(o=this.context)?o.render():void 0},post:function(t,e){var n;return null!=(n=this.context)?n.post():void 0},progress:function(t,e){var n,r,i;if(t||this.pending)return r=Math.max(t+this.options.warmup,this.pending),n=r-t,i=r,e.trigger({type:"mathbox/progress",current:r-t,total:r}),0===t&&(r=0),this.pending=r,n===i&&!this.warm&&(this.warm=!0,this.options.inspect)?this.info(e):void 0}})},{"./context":29,"./splash":165}],31:[function(t,e,n){var r,i,o;r=function(){function t(t,e){this.context=e,this.traits=t.Traits,this.types=t.Types,this.pending=[],this.bound=[],this.last=null}return t.prototype.make=function(t){return{"enum":"function"==typeof t["enum"]?t["enum"]():void 0,type:"function"==typeof t.uniform?t.uniform():void 0,value:t.make()}},t.prototype.apply=function(t,e){return new i(t,e,this)},t.prototype.bind=function(t){return this.bound.push(t)},t.prototype.unbind=function(t){var e;return this.bound=function(){var n,r,i,o;for(i=this.bound,o=[],n=0,r=i.length;r>n;n++)e=i[n],e!==t&&o.push(e);return o}.call(this)},t.prototype.queue=function(t,e,n,r){return this.lastObject=e,this.lastKey=n,this.lastValue=r,this.pending.push(t)},t.prototype.invoke=function(t){return t(this.context.time.clock,this.context.time.step)},t.prototype.compute=function(){var t,e,n,r;if(this.bound.length)for(r=this.bound,e=0,n=r.length;n>e;e++)t=r[e],this.invoke(t)},t.prototype.digest=function(){var t,e,n,r,i;
if(!this.pending.length)return!1;for(i=[this.pending,[]],e=i[0],this.pending=i[1],n=0,r=e.length;r>n;n++)(t=e[n])();return!0},t.prototype.getTrait=function(t){return this.traits[t]},t.prototype.getLastTrigger=function(){return this.lastObject.toString()+" - "+this.lastKey+"=`"+this.lastValue+"`"},t}(),o=function(t){var e,n,r;n={};for(e in t)r=t[e],n[e]=r;return n},i=function(){function t(t,e,n){var r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H,B,q,V,G,W,X,Y,Z,J,Q,$,K,tt,et,nt,rt,it;for($=e.traits,B=e.props,E=e.finals,z=e.freeform,m=this,null!=t.props&&null!=t.expr&&null!=t.orig&&null!=t.computed&&null!=t.attributes&&(F=o(t.props),N=o(t.expr),U=t.orig(),j=t.computed(),null!=(q=t.attributes)&&q.dispose()),S={},H={},I={},Y=function(t){var e;return null!=(e=I[t])?e:t},v=function(e,n){if(I[n])throw new Error(t.toString()+" - Duplicate property `"+n+"`");return I[n]=e},M=function(t){var e,n,r;return null!=(e=null!=(n=m[t])?n.value:void 0)?e:null!=(r=m[Y(t)])?r.value:void 0},G=function(e,n,r,o){var s,l,p,c,f;if(e=Y(e),null==(s=m[e])){if(!z)throw new Error(t.toString()+" - Setting unknown property `"+e+"={"+n+"}`");s=m[e]={"short":e,type:null,last:null,value:null},nt[e]=function(t){return t}}if(!r){if(a[e])throw new Error(t.toString()+" - Can't set bound property `"+e+"={"+n+"}`");if(i[e])throw new Error(t.toString()+" - Can't set computed property `"+e+"={"+n+"}`");if(u[e])throw new Error(t.toString()+" - Can't set final property `"+e+"={"+n+"}`")}return c=!0,f=et(e,n,s.last,function(){return c=!1,null}),c&&(l=[f,s.value],s.value=l[0],s.last=l[1],p=s["short"],S[p]=f,r||(H[p]=n),o||b(e,s.value,s.last)||h(e,n)),c},d=function(t,e,n){return t=Y(t),G(t,e,!0,n),u[t]=!0},k={},r={},s={},a={},i={},u={},p=function(e,o,l){var p,h;if(null==l&&(l=!1),e=Y(e),"function"!=typeof o)throw new Error(t.toString()+" - Expression `"+e+"=>{"+k+"}` is not a function");if(a[e])throw new Error(t.toString()+" - Property `"+e+"=>{"+k+"}` is already bound");if(i[e])throw new Error(t.toString()+" - Property `"+e+"` is computed");if(u[e])throw new Error(t.toString()+" - Property `"+e+"` is final");return p=l?i:a,p[e]=o,h=null!=m[e]?m[e]["short"]:e,l||(k[h]=o),s[e]=o,o=o.bind(t),r[e]=function(n,r){var i,s;return(i=null!=(s=t.clock)?s.getTime():void 0)&&(n=i.clock,r=i.step),t.set(e,o(n,r),!0)},n.bind(r[e])},K=function(t,e){var o;return null==e&&(e=!1),t=Y(t),o=e?i:a,o[t]?(n.unbind(r[t]),delete r[t],delete o[t],null!=m[t]&&(t=m[t]["short"]),delete k[t]):void 0},w=function(t,e){var n;return t=Y(t),null!=(n="function"==typeof s[t]?s[t](e,0):void 0)?n:m[t].value},t.expr=k,t.props=S,t.evaluate=function(t,e){var n;if(null!=t)return w(t,e);n={};for(t in B)n[t]=w(t,e);return n},t.get=function(t){return null!=t?M(t):S},t.set=function(t,e,n,r){var i;if("string"==typeof t)G(t,e,n,r);else{r=n,n=e,i=t;for(t in i)e=i[t],G(t,e,n,r)}},t.bind=function(t,e,n){var r;if("string"==typeof t)p(t,e,n);else{n=e,r=t;for(t in r)e=r[t],p(t,e,n)}},t.unbind=function(t,e){var n;if("string"==typeof t)K(t,e);else{e=k,n=t;for(t in n)K(t,e)}},t.attribute=function(t){return null!=t?m[Y(t)]:m},t.orig=function(t){return null!=t?H[Y(t)]:o(H)},t.computed=function(t){return null!=t?i[Y(t)]:o(i)},C={},nt={},_={},b=function(t,e,n){return _[t](e,n)},et=function(t,e,n,r){return nt[t](e,n,r)},t.validate=function(e,n){var r,i;return e=Y(e),r=C[e],null!=r&&(i=r()),i=et(e,n,i,function(){throw new Error(t.toString()+" - Invalid value `"+e+"={"+n+"}`")})},g=!1,f={},J={},c={},Z={},T=function(t){return t.split(".")[0]},h=function(e,r){var i;return g||(g=!0,n.queue(y,t,e,r)),i=T(e),f[e]=!0,J[i]=!0},x={type:"change",changed:null,touched:null},y=function(){var e,n,r;x.changed=f,x.touched=J,f=c,J=Z,c=x.changed,Z=x.touched,g=!1;for(e in f)f[e]=!1;for(e in J)J[e]=!1;x.type="change",t.trigger(x),n=[];for(r in x.touched)x.type="change:"+r,n.push(t.trigger(x));return n},W=function(t){var e,n;return e=t.split(/\./g),n=e.pop(),e.pop(),e.unshift(n),e.reduce(function(t,e){return t+e.charAt(0).toUpperCase()+e.substring(1)})},l=function(t,e){var n,r,i,o,s,a,u,l;s=[];for(r in e)u=e[r],r=[t,r].join("."),a=W(r),m[r]=n={T:u,ns:t,"short":a,"enum":"function"==typeof u["enum"]?u["enum"]():void 0,type:"function"==typeof u.uniform?u.uniform():void 0,last:u.make(),value:l=u.make()},v(r,a),S[a]=l,C[r]=u.make,nt[r]=null!=(i=u.validate)?i:function(t){return t},s.push(_[r]=null!=(o=u.equals)?o:function(t,e){return t===e});return s},R=[],it={},O=0,P=$.length;P>O;O++)Q=$[O],V=Q.split(":"),Q=V[0],L=V[1],D=L?[L,Q].join("."):Q,X=n.getTrait(Q),R.push(Q),null!=X&&l(D,X);if(null!=B)for(L in B)X=B[L],l(L,X);if(tt=R.filter(function(t,e){return R.indexOf(t)===e}),t.traits=tt,null!=F&&t.set(F,!0,!0),null!=E)for(A in E)rt=E[A],d(A,rt,!0);null!=U&&t.set(U,!1,!0),null!=j&&t.bind(j,!0),null!=N&&t.bind(N,!1),this.dispose=function(){for(A in i)K(A,!0);for(A in a)K(A,!1);return B={},delete t.attributes,delete t.get,delete t.set}}return t}(),e.exports=r},{}],32:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./node"),r=function(t){function e(t,n,r,i,o,s){e.__super__.constructor.call(this,t,n,r,i,o,s),this.children=[],this.on("reindex",function(t){return function(e){var n,r,i,o,s;for(o=t.children,s=[],r=0,i=o.length;i>r;r++)n=o[r],s.push(n.trigger(e));return s}}(this))}return o(e,t),e.prototype.add=function(t){var e;return null!=(e=t.parent)&&e.remove(t),t._index(this.children.length,this),this.children.push(t),t._added(this)},e.prototype.remove=function(t){var e,n,r,i,o,s;if((null!=(o=t.children)?o.length:void 0)&&t.empty(),n=this.children.indexOf(t),-1!==n)for(this.children.splice(n,1),t._index(null),t._removed(this),s=this.children,e=r=0,i=s.length;i>r;e=++r)t=s[e],e>=n&&t._index(e)},e.prototype.empty=function(){var t,e,n,r;for(t=this.children.slice().reverse(),e=0,n=t.length;n>e;e++)r=t[e],this.remove(r)},e}(i),e.exports=r},{"./node":36}],33:[function(t,e,n){var r;r=function(){function t(t){this.limit=null!=t?t:10}return t.prototype.iterate=function(t){var e,n,r,i;for(i=t.step,e=t.last,n=this.limit;r=i();)if(!--n)throw console.warn("Last iteration","function"==typeof e?e():void 0),new Error("Exceeded iteration limit.");return null},t}(),e.exports=r},{}],34:[function(t,e,n){n.Attributes=t("./attributes"),n.Group=t("./group"),n.Guard=t("./guard"),n.Model=t("./model"),n.Node=t("./node")},{"./attributes":31,"./group":32,"./guard":33,"./model":35,"./node":36}],35:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};p=t("cssauron"),r="*",s=/^#([A-Za-z0-9_])$/,o=/^\.([A-Za-z0-9_]+)$/,u=/^\[([A-Za-z0-9_]+)\]$/,l=/^[A-Za-z0-9_]+$/,i=/^<([0-9]+|<*)$/,h=null,a=function(){function t(t){var e,n,r,i,o,s,a,u,l,c,f,d,m,v,y,g,_,b,w,x,k,E;this.root=t,this.root.model=this,this.root.root=this.root,this.ids={},this.classes={},this.traits={},this.types={},this.nodes=[],this.watchers=[],this.fire=!1,this.lastNode=null,this.event={type:"update"},null==h&&(h=p({tag:"type",id:"id","class":"classes.join(' ')",parent:"parent",children:"children",attr:"traits.hash[attr]"})),e=function(t){return function(t){return u(t.node)}}(this),v=function(t){return function(t){return c(t.node)}}(this),this.root.on("add",e),this.root.on("remove",v),u=function(t){return function(t){return i(t),a(t),s(t),t.on("change:node",E),E(null,t,!0),f(t)}}(this),c=function(t){return function(t){return _(t),x(t),w(t),g(t.id,t),y(t.classes,t),t.off("change:node",E),f(t)}}(this),m=function(t){return function(e){var n,r,i,o;for(i=t.watchers,n=0,r=i.length;r>n;n++)o=i[n],o.match=o.matcher(e);return null}}(this),l=function(t){return function(e){var n,r,i,o,s;for(o=t.watchers,r=0,i=o.length;i>r;r++)s=o[r],n=s.fire||(s.fire=s.match!==s.matcher(e)),n&&(t.lastNode=e),t.fire||(t.fire=n);return null}}(this),f=function(t){return function(e){var n,r,i,o,s;for(o=t.watchers,r=0,i=o.length;i>r;r++)s=o[r],n=s.fire||(s.fire=s.matcher(e)),n&&(t.lastNode=e),t.fire||(t.fire=n);return null}}(this),this.digest=function(t){return function(){var e,n,r,i;if(!t.fire)return!1;for(r=t.watchers.slice(),e=0,n=r.length;n>e;e++)i=r[e],i.fire&&(i.fire=!1,i.handler());return t.fire=!1,!0}}(this),E=function(t){return function(t,e,i){var o,s,a,u,p,h,c,f;return o=i||t.changed["node.id"],s=i||t.changed["node.classes"],h=!1,o&&(u=e.get("node.id"),u!==e.id&&(i||m(e),h=!0,null!=e.id&&g(e.id,e),r(u,e))),s&&(a=null!=(c=e.get("node.classes"))?c:[],p=a.join(","),p!==(null!=(f=e.classes)?f.klass:void 0)&&(a=a.slice(),i||h||m(e),h=!0,null!=e.classes&&y(e.classes,e),n(a,e),e.classes=a,e.classes.klass=p)),!i&&h&&l(e),null}}(this),o=function(t,e,n){var r,i,o,s,a;if(null!=e){for(r=0,o=e.length;o>r;r++)i=e[r],s=null!=(a=t[i])?a:[],s.push(n),t[i]=s;return null}},b=function(t,e,n){var r,i,o,s,a;if(null!=e){for(r=0,s=e.length;s>r;r++)o=e[r],a=t[o],i=a.indexOf(n),i>=0&&a.splice(i,1),0===a.length&&delete t[o];return null}},d=function(t){var e,n,r,i,o;if(t.length>0){for(e=t.hash={},o=[],n=0,i=t.length;i>n;n++)r=t[n],o.push(e[r]=!0);return o}},k=function(t){return delete t.hash},r=function(t){return function(e,n){if(t.ids[e])throw new Error("Duplicate node id `"+e+"`");return null!=e&&(t.ids[e]=[n]),n.id=null!=e?e:n._id}}(this),g=function(t){return function(e,n){return null!=e&&delete t.ids[e],n.id=n._id}}(this),n=function(t){return function(e,n){return o(t.classes,e,n),null!=e?d(e):void 0}}(this),y=function(t){return function(e,n){return b(t.classes,e,n),null!=e?k(e):void 0}}(this),i=function(t){return function(e){return t.nodes.push(e)}}(this),_=function(t){return function(e){return t.nodes.splice(t.nodes.indexOf(e),1)}}(this),a=function(t){return function(e){return o(t.types,[e.type],e)}}(this),x=function(t){return function(e){return b(t.types,[e.type],e)}}(this),s=function(t){return function(e){return o(t.traits,e.traits,e),d(e.traits)}}(this),w=function(t){return function(e){return b(t.traits,e.traits,e),k(e.traits)}}(this),u(this.root),this.root.trigger({type:"added"})}return t.prototype.filter=function(t,e){var n,r,i,o,s;for(i=this._matcher(e),s=[],n=0,r=t.length;r>n;n++)o=t[n],i(o)&&s.push(o);return s},t.prototype.ancestry=function(t,e){var n,r,i,o,s;for(o=[],n=0,r=t.length;r>n;n++)for(i=t[n],s=i.parent;null!=s;){if(c.call(e,s)>=0){o.push(i);break}s=s.parent}return o},t.prototype.select=function(t,e){var n;return n=this._select(t),null!=e&&(n=this.ancestry(n,e)),n.sort(function(t,e){return e.order-t.order}),n},t.prototype.watch=function(t,e){var n;return e.unwatch=function(t){return function(){return t.unwatch(e)}}(this),e.watcher=n={selector:t,handler:e,matcher:this._matcher(t),match:!1,fire:!1},this.watchers.push(n),this.select(t)},t.prototype.unwatch=function(t){var e;return e=t.watcher,null!=e?(this.watchers.splice(this.watchers.indexOf(e),1),delete t.unwatch,delete t.watcher):void 0},t.prototype._simplify=function(t){var e,n,a,p,h,c,f,d,m,v,y,g;return t=t.replace(/^\s+/,""),t=t.replace(/\s+$/,""),a=e=t===r,a||(a=p=null!=(c=t.match(s))?c[1]:void 0),a||(a=h=null!=(f=t.match(o))?f[1]:void 0),a||(a=y=null!=(d=t.match(u))?d[1]:void 0),a||(a=g=null!=(m=t.match(l))?m[0]:void 0),a||(a=n=null!=(v=t.match(i))?v[0]:void 0),[e,p,h,y,g,n]},t.prototype._matcher=function(t){var e,n,r,i,o,s,a;if(o=this._simplify(t),e=o[0],r=o[1],i=o[2],s=o[3],a=o[4],n=o[5],e)return function(t){return!0};if(r)return function(t){return t.id===r};if(i)return function(t){var e,n;return null!=(e=t.classes)&&null!=(n=e.hash)?n[i]:void 0};if(s)return function(t){var e,n;return null!=(e=t.traits)&&null!=(n=e.hash)?n[s]:void 0};if(a)return function(t){return t.type===a};if(n)throw"Auto-link matcher unsupported";return h(t)},t.prototype._select=function(t){var e,n,r,i,o,s,a,u,l,p;return i=this._simplify(t),e=i[0],n=i[1],r=i[2],l=i[3],p=i[4],e?this.nodes:n?null!=(o=this.ids[n])?o:[]:r?null!=(s=this.classes[r])?s:[]:l?null!=(a=this.traits[l])?a:[]:p?null!=(u=this.types[p])?u:[]:this.filter(this.nodes,t)},t.prototype.getRoot=function(){return this.root},t.prototype.getLastTrigger=function(){return this.lastNode.toString()},t}(),e.exports=a},{cssauron:2}],36:[function(t,e,n){var r,i,o,s;o=t("../util"),s=0,i=function(){function t(t,e,n,r,i,o){this.type=t,this._id=(++s).toString(),this.configure(i,o),this.parent=this.root=this.path=this.index=null,this.set(e,!0,!0),this.set(n,!1,!0),this.bind(r,!1)}return t.prototype.configure=function(t,e){var n,r,i,o,s,a,u,l,p,h,c,f;return f=t.traits,i=t.props,n=t.finals,r=t.freeform,null==f&&(f=null!=(o=null!=(s=this._config)?s.traits:void 0)?o:[]),null==i&&(i=null!=(a=null!=(u=this._config)?u.props:void 0)?a:{}),null==n&&(n=null!=(l=null!=(p=this._config)?p.finals:void 0)?l:{}),null==r&&(r=null!=(h=null!=(c=this._config)?c.freeform:void 0)?h:!1),this._config={traits:f,props:i,finals:n,freeform:r},this.attributes=e.apply(this,this._config)},t.prototype.dispose=function(){return this.attributes.dispose(),this.attributes=null},t.prototype._added=function(t){var e;return this.parent=t,this.root=t.root,e={type:"add",node:this,parent:this.parent},this.root&&this.root.trigger(e),e.type="added",this.trigger(e)},t.prototype._removed=function(){var t;return t={type:"remove",node:this},this.root&&this.root.trigger(t),t.type="removed",this.trigger(t),this.root=this.parent=null},t.prototype._index=function(t,e){var n,r;return null==e&&(e=this.parent),this.index=t,this.path=n=null!=t?(null!=(r=null!=e?e.path:void 0)?r:[]).concat([t]):null,this.order=null!=n?this._encode(n):1/0,null!=this.root?this.trigger({type:"reindex"}):void 0},t.prototype._encode=function(t){var e,n,r,i,o,s,a,u,l,p,h;for(a=3,p=function(t){return a/(t+a)},l=function(t){return n+(e-n)*t},e=1+1/a,n=0,o=0,u=t.length;u>o;o++)s=t[o],r=p(s+1),i=p(s+2),h=[l(r),l(i)],e=h[0],n=h[1];return e},t.prototype.toString=function(){var t,e,n,r,i,o,s;return t=null!=(r=this.id)?r:this._id,s=null!=(i=this.type)?i:"node",n=s,n+="#"+t,(null!=(o=this.classes)?o.length:void 0)&&(n+="."+this.classes.join(".")),null!=this.children?(e=this.children.length)?"<"+n+">…("+e+")…</"+s+">":"<"+n+"></"+s+">":"<"+n+" />"},t.prototype.toMarkup=function(t,e){var n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g;null==t&&(t=null),null==e&&(e=""),t&&"function"!=typeof t&&(t=null!=(f=null!=(d=this.root)?d.model._matcher(t):void 0)?f:function(){return!0}),y=null!=(m=this.type)?m:"node",a=this.expr,p={id:this._id},v="function"==typeof this.orig?this.orig():void 0;for(u in v)g=v[u],p[u]=g;return h=function(){var t;t=[];for(u in p)g=p[u],this.expr[u]||t.push(o.Pretty.JSX.prop(u,g));return t}.call(this),a=function(){var t;t=[];for(u in a)g=a[u],t.push(o.Pretty.JSX.bind(u,g));return t}(),n=[""],h.length&&(n=n.concat(h)),a.length&&(n=n.concat(a)),n=n.join(" "),r=e,c=function(e){return function(){var n,i;return(null!=(i=e.children)?i.length:void 0)?n=e.children.map(function(e){return e.toMarkup(t,r)}).filter(function(t){return null!=t&&t.length}).join("\n"):""}}(this),t&&!t(this)?c():null!=this.children?(l="<"+y+n+">",s="</"+y+">",r=e+"  ",i=c(),i.length&&(i="\n"+i+"\n"+e),null==i&&(i=""),e+l+i+s):e+"<"+y+n+" />"},t.prototype.print=function(t,e){return o.Pretty.print(this.toMarkup(t),e)},t}(),r=t("../util/binder"),r.apply(i.prototype),e.exports=i},{"../util":175,"../util/binder":171}],37:[function(t,e,n){var r;r={dom:t("./dom")},e.exports=r},{"./dom":38}],38:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./overlay"),o=t("../util").VDOM,r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.el=o.element,e.prototype.hint=o.hint,e.prototype.apply=o.apply,e.prototype.recycle=o.recycle,e.prototype.init=function(t){return this.last=null},e.prototype.dispose=function(){return this.unmount(),e.__super__.dispose.apply(this,arguments)},e.prototype.mount=function(){var t;return t=document.createElement("div"),t.classList.add("mathbox-overlay"),this.element.appendChild(t),this.overlay=t},e.prototype.unmount=function(t){return this.overlay.parentNode&&this.element.removeChild(this.overlay),this.overlay=null},e.prototype.render=function(t){var e,n,r,i,o,s;this.overlay||this.mount(),("string"==(s=typeof t)||"number"===s)&&(t=this.el("div",null,t)),t instanceof Array&&(t=this.el("div",null,t)),n="div"===t.type,e=this.last,i=this.overlay,r=n?i:i.childNodes[0],o=n?i.parentNode:i,!e&&r&&(e=this.el("div")),this.apply(t,e,r,o,0),this.last=t,null!=e&&this.recycle(e)},e}(i),e.exports=r},{"../util":175,"./overlay":41}],39:[function(t,e,n){var r;r=function(){function t(t,e){var n;this.classes=t,this.canvas=e,n=document.createElement("div"),n.classList.add("mathbox-overlays"),this.div=n}return t.prototype.inject=function(){var t;if(t=this.canvas.parentNode,!t)throw new Error("Canvas not inserted into document.");return t.insertBefore(this.div,this.canvas)},t.prototype.unject=function(){var t;return t=this.div.parentNode,t.removeChild(this.div)},t.prototype.getTypes=function(){return Object.keys(this.classes)},t.prototype.make=function(t,e){return new this.classes[t](this.div,e)},t}(),e.exports=r},{}],40:[function(t,e,n){n.Factory=t("./factory"),n.Classes=t("./classes"),n.Overlay=t("./overlay")},{"./classes":37,"./factory":39,"./overlay":41}],41:[function(t,e,n){var r;r=function(){function t(t,e){this.element=t,"function"==typeof this.init&&this.init(e)}return t.prototype.dispose=function(){},t}(),e.exports=r},{}],42:[function(t,e,n){var r,i;i=t("../util"),r=function(){function t(t,e){this.context=e,this.classes=t.Classes,this.helpers=t.Helpers}return t.prototype.getTypes=function(){return Object.keys(this.classes)},t.prototype.make=function(t,e,n){var r,i,o;if(null==e&&(e={}),null==n&&(n=null),r=this.classes[t],null==r)throw new Error("Unknown primitive class `"+t+"`");return i=new r.model(t,r.defaults,e,n,r,this.context.attributes),o=new r(i,this.context,this.helpers),i},t}(),e.exports=r},{"../util":175}],43:[function(t,e,n){n.Factory=t("./factory"),n.Primitive=t("./primitive"),n.Types=t("./types")},{"./factory":42,"./primitive":44,"./types":72}],44:[function(t,e,n){var r,i,o,s=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};i=t("../model"),o=function(){function t(t,e,n){this.node=t,this._context=e,this._renderables=this._context.renderables,this._attributes=this._context.attributes,this._shaders=this._context.shaders,this._overlays=this._context.overlays,this._animator=this._context.animator,this._types=this._attributes.types,this.node.controller=this,this.node.on("added",function(t){return function(e){return t._added()}}(this)),this.node.on("removed",function(t){return function(e){return t._removed()}}(this)),this.node.on("change",function(t){return function(e){return t._root?t.change(e.changed,e.touched):void 0}}(this)),this.reconfigure(),this._get=this.node.get.bind(this.node),this._helpers=n(this,this.node.traits),this._handlers={inherit:{},listen:[],watch:[],compute:[]},this._root=this._parent=null,this.init()}return t.Node=i.Node,t.Group=i.Group,t.model=t.Node,t.defaults=null,t.traits=null,t.props=null,t.finals=null,t.freeform=!1,t.prototype.is=function(t){return this.traits.hash[t]},t.prototype.init=function(){},t.prototype.make=function(){},t.prototype.made=function(){},t.prototype.unmake=function(t){},t.prototype.unmade=function(){},t.prototype.change=function(t,e,n){},t.prototype.refresh=function(){return this.change({},{},!0)},t.prototype.rebuild=function(){return this._root?(this._removed(!0),this._added()):void 0},t.prototype.reconfigure=function(t){return null!=t&&this.node.configure(t,this._attributes),this.traits=this.node.traits,this.props=this.node.props},t.prototype._added=function(){var t,e,n,r,i,o;this._parent=null!=(r=this.node.parent)?r.controller:void 0,this._root=null!=(i=this.node.root)?i.controller:void 0,this.node.clock=null!=(o=this._inherit("clock"))?o:this._root;try{try{return this.make(),this.refresh(),this.made()}catch(e){throw t=e,this.node.print("warn"),console.error(t),t}}catch(n){t=n;try{return this._removed()}catch(s){}}},t.prototype._removed=function(t){return null==t&&(t=!1),this.unmake(t),this._unlisten(),this._unattach(),this._uncompute(),this._root=null,this._parent=null,this.unmade(t)},t.prototype._listen=function(t,e,n,r){var i,o,s;if(null==r&&(r=this),t instanceof Array)for(i=0,o=t.length;o>i;i++)return s=t[i],this.__listen(s,e,n,r);return this.__listen(t,e,n,r)},t.prototype.__listen=function(t,e,n,r){var i;return null==r&&(r=this),"string"==typeof t&&(t=this._inherit(t)),null!=t&&(i=n.bind(r),i.node=this.node,t.on(e,i),this._handlers.listen.push([t,e,i])),t},t.prototype._unlisten=function(){var t,e,n,r,i,o,s;if(this._handlers.listen.length){for(i=this._handlers.listen,e=0,n=i.length;n>e;e++)o=i[e],r=o[0],s=o[1],t=o[2],r.off(s,t);return this._handlers.listen=[]}},t.prototype._inherit=function(t){var e,n;return e=this._handlers.inherit[t],void 0!==e?e:this._handlers.inherit[t]=null!=(n=this._parent)?n._find(null!=t?t:null):void 0},t.prototype._find=function(t){var e;return this.is(t)?this:null!=(e=this._parent)?e._find(t):void 0},t.prototype._uninherit=function(){return this._handlers.inherit={}},t.prototype._attach=function(t,e,n,r,o,a,u){var l,p,h,c,f;return null==r&&(r=this),null==o&&(o=this),null==a&&(a=!1),null==u&&(u=!1),l=function(t){return null!=t&&s.call(t.traits,e)>=0?t:void 0},h=function(t){return null!=t?t.controller:void 0},p=function(t){var e,n,r,i;if(null==t)return t;for(r=[],e=0,n=t.length;n>e;e++)i=t[e],i instanceof Array?r=r.concat(i):r.push(i);return r},f=function(t){return function(s){var h,c,d,m,v,y,g,_;if("object"==typeof s){if(d=s,null!=d?d._up:void 0)return s=u?d._targets:[d[0]];if(d instanceof Array)return s=u?p(d.map(f)):f(d[0]);if(d instanceof i.Node)return[d]}else if("string"==typeof s&&"<"===s[0]){for(h=0,(c=s.match(/^<([0-9])+$/))&&(h=+c[1]-1),s.match(/^<+$/)&&(h=+s.length-1),m=[],y=o.node;y&&(v=y.parent);)if(y=v.children[y.index-1],y||m.length||(y=v),d=null,l(y)&&(d=y),null!=d&&h--<=0&&m.push(d),!u&&m.length)return m;if(u&&m.length)return m}else if("string"==typeof s)if(_=n.bind(r),t._handlers.watch.push(_),g=t._root.watch(s,_),u){if(m=g.filter(l),m.length)return m}else if(l(g[0])&&(d=g[0]),null!=d)return[d];if(!a)throw console.warn(t.node.toMarkup()),new Error(t.node.toString()+" - Could not find "+e+" `"+s+"`");return u?[]:null}}(this),c=p(f(t)),u?null!=c?c.map(h):null:null!=c?h(c[0]):null},t.prototype._unattach=function(){var t,e,n,r;if(this._handlers.watch.length){for(n=this._handlers.watch,t=0,e=n.length;e>t;t++)r=n[t],null!=r&&r.unwatch();return this._handlers.watch=[]}},t.prototype._compute=function(t,e){return this._handlers.compute.push(t),this.node.bind(t,e,!0)},t.prototype._uncompute=function(){var t,e,n,r;if(this._handlers.compute.length){for(r=this._handlers.compute,t=0,n=r.length;n>t;t++)e=r[t],this.node.unbind(e,!0);return this._handlers.compute=[]}},t}(),r=t("../util/binder"),r.apply(o.prototype),e.exports=o},{"../model":34,"../util/binder":171}],45:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./parent"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","object","entity","visible","active"],e.prototype.make=function(){return this._helpers.visible.make(),this._helpers.active.make()},e.prototype.unmake=function(){return this._helpers.visible.unmake(),this._helpers.active.unmake()},e}(i),e.exports=r},{"./parent":47}],46:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty,a=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};i=t("./parent"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","bind"],e.prototype.make=function(){return this._helpers.bind.make([{to:"inherit.source",trait:"node"}])},e.prototype.unmake=function(){return this._helpers.bind.unmake()},e.prototype._find=function(t){return this.bind.source&&a.call(this.props.traits,t)>=0?this.bind.source._inherit(t):e.__super__._find.apply(this,arguments)},e}(i),e.exports=r},{"./parent":47}],47:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("../../primitive"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.model=i.Group,e.traits=["node"],e}(i),e.exports=r},{"../../primitive":44}],48:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./parent"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","root","clock","scene","vertex","unit"],e.prototype.init=function(){return this.size=null,this.cameraEvent={type:"root.camera"},this.preEvent={type:"root.pre"},this.updateEvent={type:"root.update"},this.renderEvent={type:"root.render"},this.postEvent={type:"root.post"},this.clockEvent={type:"clock.tick"},this.camera=null},e.prototype.make=function(){return this._helpers.unit.make()},e.prototype.unmake=function(){return this._helpers.unit.unmake()},e.prototype.change=function(t,e,n){return t["root.camera"]||n?(this._unattach(),this._attach(this.props.camera,"camera",this.setCamera,this,this,!0),this.setCamera()):void 0},e.prototype.adopt=function(t){var e,n,r,i,o;for(i=t.renders,o=[],e=0,n=i.length;n>e;e++)r=i[e],o.push(this._context.scene.add(r));return o},e.prototype.unadopt=function(t){var e,n,r,i,o;for(i=t.renders,o=[],e=0,n=i.length;n>e;e++)r=i[e],o.push(this._context.scene.remove(r));return o},e.prototype.select=function(t){return this.node.model.select(t)},e.prototype.watch=function(t,e){return this.node.model.watch(t,e)},e.prototype.unwatch=function(t){return this.node.model.unwatch(t)},e.prototype.resize=function(t){return this.size=t,this.trigger({type:"root.resize",size:t})},e.prototype.getSize=function(){return this.size},e.prototype.getSpeed=function(){return this.props.speed},e.prototype.getUnit=function(){return this._helpers.unit.get()},e.prototype.getUnitUniforms=function(){return this._helpers.unit.uniforms()},e.prototype.pre=function(){return this.getCamera().updateProjectionMatrix(),this.trigger(this.clockEvent),this.trigger(this.preEvent)},e.prototype.update=function(){return this.trigger(this.updateEvent)},e.prototype.render=function(){return this.trigger(this.renderEvent)},e.prototype.post=function(){return this.trigger(this.postEvent)},e.prototype.setCamera=function(){var t,e;return t=null!=(e=this.select(this.props.camera)[0])?e.controller:void 0,this.camera!==t?(this.camera=t,this.trigger({type:"root.camera"})):void 0},e.prototype.getCamera=function(){var t,e;return null!=(t=null!=(e=this.camera)?e.getCamera():void 0)?t:this._context.defaultCamera},e.prototype.getTime=function(){return this._context.time},e.prototype.vertex=function(t,e){return 2===e?t.pipe("view.position"):3===e?t.pipe("root.position"):t},e}(r),e.exports=i},{"../../../util":175,"./parent":47}],49:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","source","index"],e.prototype.made=function(){return this.trigger({type:"source.rebuild"})},e.prototype.indexShader=function(t){return t.pipe(o.GLSL.identity("vec4"))},e.prototype.sourceShader=function(t){return t.pipe(o.GLSL.identity("vec4"))},e.prototype.getDimensions=function(){return{items:1,width:1,height:1,depth:1}},e.prototype.getActiveDimensions=function(){return this.getDimensions()},e.prototype.getIndexDimensions=function(){return this.getActiveDimensions()},e.prototype.getFutureDimensions=function(){return this.getActiveDimensions()},e}(r),e.exports=i},{"../../../util":175,"../../primitive":44}],50:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./parent"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","unit"],e.prototype.make=function(){return this._helpers.unit.make()},e.prototype.unmake=function(){return this._helpers.unit.unmake()},e.prototype.getUnit=function(){return this._helpers.unit.get()},e.prototype.getUnitUniforms=function(){return this._helpers.unit.uniforms()},e}(r),e.exports=i},{"../../../util":175,"./parent":47}],51:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","camera"],e.prototype.init=function(){},e.prototype.make=function(){var t;return t=this._context.defaultCamera,this.camera=this.props.proxy?t:t.clone(),this.euler=new THREE.Euler,this.quat=new THREE.Quaternion},e.prototype.unmake=function(){},e.prototype.getCamera=function(){return this.camera},e.prototype.change=function(t,e,n){var r,i,s,a,u,l,p,h;return t["camera.position"]||t["camera.quaternion"]||t["camera.rotation"]||t["camera.lookAt"]||t["camera.up"]||t["camera.fov"]||n?(l=this.props,a=l.position,u=l.quaternion,p=l.rotation,s=l.lookAt,h=l.up,i=l.fov,r=l.aspect,null!=a&&this.camera.position.copy(a),(null!=u||null!=p||null!=s)&&(null!=s?this.camera.lookAt(s):this.camera.quaternion.set(0,0,0,1),null!=p&&(this.euler.setFromVector3(p,o.Three.swizzleToEulerOrder(this.props.eulerOrder)),this.quat.setFromEuler(this.euler),this.camera.quaternion.multiply(this.quat)),null!=u&&this.camera.quaternion.multiply(u)),null!=i&&null!=this.camera.fov&&(this.camera.fov=i),null!=h&&this.camera.up.copy(h),this.camera.updateMatrix()):void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],52:[function(t,e,n){var r;r={axis:t("./draw/axis"),face:t("./draw/face"),grid:t("./draw/grid"),line:t("./draw/line"),point:t("./draw/point"),strip:t("./draw/strip"),surface:t("./draw/surface"),ticks:t("./draw/ticks"),vector:t("./draw/vector"),view:t("./view/view"),cartesian:t("./view/cartesian"),cartesian4:t("./view/cartesian4"),polar:t("./view/polar"),spherical:t("./view/spherical"),stereographic:t("./view/stereographic"),stereographic4:t("./view/stereographic4"),transform:t("./transform/transform3"),transform4:t("./transform/transform4"),vertex:t("./transform/vertex"),fragment:t("./transform/fragment"),layer:t("./transform/layer"),mask:t("./transform/mask"),array:t("./data/array"),interval:t("./data/interval"),matrix:t("./data/matrix"),area:t("./data/area"),voxel:t("./data/voxel"),volume:t("./data/volume"),scale:t("./data/scale"),html:t("./overlay/html"),dom:t("./overlay/dom"),text:t("./text/text"),format:t("./text/format"),label:t("./text/label"),retext:t("./text/retext"),clamp:t("./operator/clamp"),grow:t("./operator/grow"),join:t("./operator/join"),lerp:t("./operator/lerp"),memo:t("./operator/memo"),readback:t("./operator/readback"),resample:t("./operator/resample"),
repeat:t("./operator/repeat"),swizzle:t("./operator/swizzle"),spread:t("./operator/spread"),split:t("./operator/split"),slice:t("./operator/slice"),subdivide:t("./operator/subdivide"),transpose:t("./operator/transpose"),group:t("./base/group"),inherit:t("./base/inherit"),root:t("./base/root"),unit:t("./base/unit"),shader:t("./shader/shader"),camera:t("./camera/camera"),rtt:t("./rtt/rtt"),compose:t("./rtt/compose"),clock:t("./time/clock"),now:t("./time/now"),move:t("./present/move"),play:t("./present/play"),present:t("./present/present"),reveal:t("./present/reveal"),slide:t("./present/slide"),step:t("./present/step")},e.exports=r},{"./base/group":45,"./base/inherit":46,"./base/root":48,"./base/unit":50,"./camera/camera":51,"./data/area":53,"./data/array":54,"./data/interval":57,"./data/matrix":58,"./data/scale":59,"./data/volume":60,"./data/voxel":61,"./draw/axis":62,"./draw/face":63,"./draw/grid":64,"./draw/line":65,"./draw/point":66,"./draw/strip":67,"./draw/surface":68,"./draw/ticks":69,"./draw/vector":70,"./operator/clamp":73,"./operator/grow":74,"./operator/join":75,"./operator/lerp":76,"./operator/memo":77,"./operator/readback":79,"./operator/repeat":80,"./operator/resample":81,"./operator/slice":82,"./operator/split":83,"./operator/spread":84,"./operator/subdivide":85,"./operator/swizzle":86,"./operator/transpose":87,"./overlay/dom":88,"./overlay/html":89,"./present/move":90,"./present/play":91,"./present/present":92,"./present/reveal":93,"./present/slide":94,"./present/step":95,"./rtt/compose":98,"./rtt/rtt":99,"./shader/shader":100,"./text/format":101,"./text/label":102,"./text/retext":103,"./text/text":104,"./time/clock":105,"./time/now":106,"./transform/fragment":108,"./transform/layer":109,"./transform/mask":110,"./transform/transform3":112,"./transform/transform4":113,"./transform/vertex":114,"./view/cartesian":116,"./view/cartesian4":117,"./view/polar":118,"./view/spherical":119,"./view/stereographic":120,"./view/stereographic4":121,"./view/view":122}],53:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./matrix"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","source","index","matrix","texture","raw","span:x","span:y","area","sampler:x","sampler:y"],e.prototype.updateSpan=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c;return n=this.props.axes,c=this.props.width,r=this.props.height,t=this.props.centeredX,e=this.props.centeredY,s=this.props.paddingX,a=this.props.paddingY,u=this._helpers.span.get("x.",n[0]),l=this._helpers.span.get("y.",n[1]),this.aX=u.x,this.aY=l.x,p=u.y-u.x,h=l.y-l.x,c+=2*s,r+=2*a,t?(i=1/Math.max(1,c),this.aX+=p*i/2):i=1/Math.max(1,c-1),e?(o=1/Math.max(1,r),this.aY+=h*o/2):o=1/Math.max(1,r-1),this.bX=p*i,this.bY=h*o,this.aX+=s*this.bX,this.aY+=a*this.bY},e.prototype.callback=function(t){return this.updateSpan(),this.last===t?this._callback:(this.last=t,t.length<=5?this._callback=function(e){return function(n,r,i){var o,s;return o=e.aX+e.bX*r,s=e.aY+e.bY*i,t(n,o,s,r,i)}}(this):this._callback=function(e){return function(n,r,i){var o,s;return o=e.aX+e.bX*r,s=e.aY+e.bY*i,t(n,o,s,r,i,e.bufferClock,e.bufferStep)}}(this))},e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this._helpers.span.make(),this._listen(this,"span.range",this.updateSpan)},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this._helpers.span.unmake()},e}(i),e.exports=r},{"../../../util":175,"./matrix":58}],54:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./buffer"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","source","index","array","texture","raw"],e.prototype.init=function(){return this.buffer=this.spec=null,this.space={width:0,history:0},this.used={width:0},this.storage="arrayBuffer",this.passthrough=function(t,e){return t(e,0,0,0)},e.__super__.init.apply(this,arguments)},e.prototype.sourceShader=function(t){var e;return e=this.getDimensions(),this.alignShader(e,t),this.buffer.shader(t)},e.prototype.getDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.history,depth:1}},e.prototype.getActiveDimensions=function(){return{items:this.items,width:this.used.width,height:this.buffer.getFilled(),depth:1}},e.prototype.getFutureDimensions=function(){return{items:this.items,width:this.used.width,height:this.space.history,depth:1}},e.prototype.getRawDimensions=function(){return{items:this.items,width:space.width,height:1,depth:1}},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d,m;return e.__super__.make.apply(this,arguments),u=null!=(l=this.minFilter)?l:this.props.minFilter,a=null!=(p=this.magFilter)?p:this.props.magFilter,d=null!=(h=this.type)?h:this.props.type,m=this.props.width,i=this.props.history,c=this.props.bufferWidth,t=this.props.channels,s=this.props.items,r=this.spec={channels:t,items:s,width:m},this.items=r.items,this.channels=r.channels,n=this.props.data,r=o.Data.getDimensions(n,r),f=this.space,f.width=Math.max(c,r.width||1),f.history=i,this.buffer=this._renderables.make(this.storage,{width:f.width,history:f.history,channels:t,items:s,minFilter:u,magFilter:a,type:d})},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.buffer?(this.buffer.dispose(),this.buffer=this.spec=null):void 0},e.prototype.change=function(t,e,n){var r;if(e.texture||t["history.history"]||t["buffer.channels"]||t["buffer.items"]||t["array.bufferWidth"])return this.rebuild();if(this.buffer)return t["array.width"]&&(r=this.props.width,r>this.space.width)?this.rebuild():t["data.map"]||t["data.data"]||t["data.resolve"]||t["data.expr"]||n?this.buffer.setCallback(this.emitter()):void 0},e.prototype.callback=function(t){return t.length<=2?t:function(e){return function(n,r){return t(n,r,e.bufferClock,e.bufferStep)}}(this)},e.prototype.update=function(){var t,e,n,r,i;if(this.buffer)return t=this.props.data,r=this.space,i=this.used,n=i.width,e=this.buffer.getFilled(),this.syncBuffer(function(e){return function(n){var s,a,u;return null!=t?(a=o.Data.getDimensions(t,e.spec),a.width>r.width?(n(),e.rebuild()):(i.width=a.width,e.buffer.setActive(i.width),"function"==typeof(s=e.buffer.callback).rebind&&s.rebind(t),e.buffer.update())):(u=e.spec.width||1,e.buffer.setActive(u),u=e.buffer.update(),i.width=u)}}(this)),i.width!==n||e!==this.buffer.getFilled()?this.trigger({type:"source.resize"}):void 0},e}(i),e.exports=r},{"../../../util":175,"./buffer":55}],55:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./data"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","source","index","texture"],e.prototype.init=function(){return this.bufferSlack=0,this.bufferFrames=0,this.bufferTime=0,this.bufferDelta=0,this.bufferClock=0,this.bufferStep=0,e.__super__.init.apply(this,arguments)},e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this.clockParent=this._inherit("clock")},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.rawBuffer=function(){return this.buffer},e.prototype.emitter=function(){var t,n,r;return r=this.props,t=r.channels,n=r.items,e.__super__.emitter.call(this,t,n)},e.prototype.change=function(t,e,n){var r;return t["buffer.fps"]||n?(r=this.props.fps,this.bufferSlack=r?.5/r:0):void 0},e.prototype.syncBuffer=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;if(this.buffer&&(d=this.props,h=d.live,i=d.fps,a=d.hurry,p=d.limit,f=d.realtime,c=d.observe,r=this.buffer.getFilled(),!r||h)){if(w=this.clockParent.getTime(),null!=i){for(y=this.bufferSlack,g=w.step/w.delta,n=f?w.delta:w.step,o=1/i,_=f&&c?g*o:o,this.bufferSlack=Math.min(p/i,y+n),this.bufferDelta=n,this.bufferStep=_,s=Math.min(a,Math.floor(y*i)),r||(s=Math.max(1,s)),b=!1,e=function(){return b=!0},v=[],u=l=0,m=s;(m>=0?m>l:l>m)&&(this.bufferTime+=n,this.bufferClock+=_,!b);u=m>=0?++l:--l)t(e,this.bufferFrames++,u,s),v.push(this.bufferSlack-=o);return v}return this.bufferTime=w.time,this.bufferDelta=w.delta,this.bufferClock=w.clock,this.bufferStep=w.step,t(function(){},this.bufferFrames++,0,1)}},e.prototype.alignShader=function(t,e){var n,r,i,o,s,a;return a=this.props,i=a.minFilter,r=a.magFilter,n=a.aligned,o=t.items>1&&t.width>1||t.height>1&&t.depth>1,!n&&o?(s=i===this.node.attributes["texture.minFilter"]["enum"].nearest&&r===this.node.attributes["texture.magFilter"]["enum"].nearest,s||console.warn(this.node.toString()+" - Cannot use linear min/magFilter with 3D/4D sampling"),e.pipe("map.xyzw.align")):void 0},e}(i),e.exports=r},{"../../../util":175,"./data":56}],56:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../base/source"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","data","source","index","entity","active"],e.prototype.init=function(){return this.dataEmitter=null,this.dataSizes=null},e.prototype.emitter=function(t,e){var n,r,i,s,a,u,l,p;return r=this.props.data,n=this.props.bind,s=this.props.expr,null!=r?(a=this.dataSizes,l=o.Data.getSizes(r),a&&a.length===l.length||(p=o.Data.getThunk(r),this.dataEmitter=this.callback(o.Data.makeEmitter(p,e,t)),this.dataSizes=l),i=this.dataEmitter):"undefined"!=typeof u&&null!==u?(u=this._inherit("resolve"),i=this.callback(u.callback(n))):i=null!=s?this.callback(s):this.callback(this.passthrough),i},e.prototype.callback=function(t){return null!=t?t:function(){}},e.prototype.update=function(){},e.prototype.make=function(){return this._helpers.active.make(),this.first=!0,this._listen("root","root.update",function(t){return function(){return(t.isActive||t.first)&&t.update(),t.first=!1}}(this))},e.prototype.unmake=function(){return this._helpers.active.unmake(),this.dataEmitter=null,this.dataSizes=null},e}(i),e.exports=r},{"../../../util":175,"../base/source":49}],57:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./array"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","source","index","texture","array","span","interval","sampler","raw"],e.prototype.updateSpan=function(){var t,e,n,r,i,o,s;return e=this.props.axis,s=this.props.width,t=this.props.centered,r=this.props.padding,i=this._helpers.span.get("",e),s+=2*r,this.a=i.x,o=i.y-i.x,t?(n=1/Math.max(1,s),this.a+=o*n/2):n=1/Math.max(1,s-1),this.b=o*n,this.a+=r*this.b},e.prototype.callback=function(t){return this.updateSpan(),this.last===t?this._callback:(this.last=t,t.length<=3?this._callback=function(e){return function(n,r){var i;return i=e.a+e.b*r,t(n,i,r)}}(this):this._callback=function(e){return function(n,r){var i;return i=e.a+e.b*r,t(n,i,r,e.bufferClock,e.bufferStep)}}(this))},e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this._helpers.span.make(),this._listen(this,"span.range",this.updateSpan)},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this._helpers.span.unmake()},e}(o),e.exports=r},{"../../../util":175,"./array":54}],58:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./buffer"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","source","index","texture","matrix","raw"],e.prototype.init=function(){return this.buffer=this.spec=null,this.space={width:0,height:0,history:0},this.used={width:0,height:0},this.storage="matrixBuffer",this.passthrough=function(t,e,n){return t(e,n,0,0)},e.__super__.init.apply(this,arguments)},e.prototype.sourceShader=function(t){var e;return e=this.getDimensions(),this.alignShader(e,t),this.buffer.shader(t)},e.prototype.getDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.height,depth:this.space.history}},e.prototype.getActiveDimensions=function(){return{items:this.items,width:this.used.width,height:this.used.height,depth:this.buffer.getFilled()}},e.prototype.getFutureDimensions=function(){return{items:this.items,width:this.used.width,height:this.used.height,depth:this.space.history}},e.prototype.getRawDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.height,depth:1}},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y;return e.__super__.make.apply(this,arguments),l=null!=(p=this.minFilter)?p:this.props.minFilter,u=null!=(h=this.magFilter)?h:this.props.magFilter,v=null!=(c=this.type)?c:this.props.type,y=this.props.width,i=this.props.height,s=this.props.history,f=this.props.bufferWidth,d=this.props.bufferHeight,t=this.props.channels,a=this.props.items,r=this.spec={channels:t,items:a,width:y,height:i},this.items=r.items,this.channels=r.channels,n=this.props.data,r=o.Data.getDimensions(n,r),m=this.space,m.width=Math.max(f,r.width||1),m.height=Math.max(d,r.height||1),m.history=s,this.buffer=this._renderables.make(this.storage,{width:m.width,height:m.height,history:m.history,channels:t,items:a,minFilter:l,magFilter:u,type:v})},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.buffer?(this.buffer.dispose(),this.buffer=this.spec=null):void 0},e.prototype.change=function(t,e,n){var r,i;if(e.texture||t["matrix.history"]||t["buffer.channels"]||t["buffer.items"]||t["matrix.bufferWidth"]||t["matrix.bufferHeight"])return this.rebuild();if(this.buffer)return t["matrix.width"]&&(i=this.props.width,i>this.space.width)?this.rebuild():t["matrix.height"]&&(r=this.props.height,r>this.space.height)?this.rebuild():t["data.map"]||t["data.data"]||t["data.resolve"]||t["data.expr"]||n?this.buffer.setCallback(this.emitter()):void 0},e.prototype.callback=function(t){return t.length<=3?t:function(e){return function(n,r,i){return t(n,r,i,e.bufferClock,e.bufferStep)}}(this)},e.prototype.update=function(){var t,e,n,r,i,s;if(this.buffer)return t=this.props.data,r=this.space,i=this.used,s=i.width,n=i.height,e=this.buffer.getFilled(),this.syncBuffer(function(e){return function(n){var s,a,u,l,p,h;return null!=t?(u=o.Data.getDimensions(t,e.spec),u.width>r.width||u.height>r.height?(n(),e.rebuild()):(i.width=u.width,i.height=u.height,e.buffer.setActive(i.width,i.height),"function"==typeof(a=e.buffer.callback).rebind&&a.rebind(t),e.buffer.update())):(h=e.spec.width||1,l=e.spec.height||1,e.buffer.setActive(h,l),p=e.buffer.update(),i.width=s=h,i.height=Math.ceil(p/s),1===i.height?i.width=p:void 0)}}(this)),i.width!==s||i.height!==n||e!==this.buffer.getFilled()?this.trigger({type:"source.resize"}):void 0},e}(r),e.exports=i},{"../../../util":175,"./buffer":55}],59:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../base/source"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","source","index","interval","span","scale","raw","origin"],e.prototype.init=function(){return this.used=this.space=this.scaleAxis=this.sampler=null},e.prototype.rawBuffer=function(){return this.buffer},e.prototype.sourceShader=function(t){return t.pipe(this.sampler)},e.prototype.getDimensions=function(){return{items:1,width:this.space,height:1,depth:1}},e.prototype.getActiveDimensions=function(){return{items:1,width:this.used,height:this.buffer.getFilled(),depth:1}},e.prototype.getRawDimensions=function(){return this.getDimensions()},e.prototype.make=function(){var t,e,n;return this.space=n=this._helpers.scale.divide(""),this.buffer=this._renderables.make("dataBuffer",{width:n,channels:1,items:1}),e={scaleAxis:this._attributes.make(this._types.vec4()),scaleOffset:this._attributes.make(this._types.vec4())},this.scaleAxis=e.scaleAxis.value,this.scaleOffset=e.scaleOffset.value,t=this.sampler=this._shaders.shader(),t.require(this.buffer.shader(this._shaders.shader(),1)),t.pipe("scale.position",e),this._helpers.span.make(),this._listen(this,"span.range",this.updateRanges)},e.prototype.unmake=function(){return this.scaleAxis=null,this._helpers.span.unmake()},e.prototype.change=function(t,e,n){return t["scale.divide"]?this.rebuild():e.view||e.interval||e.span||e.scale||n?this.updateRanges():void 0},e.prototype.updateRanges=function(){var t,e,n,r,i,s,a,u;return u=this.used,s=this.props,t=s.axis,r=s.origin,i=this._helpers.span.get("",t),n=i.x,e=i.y,a=this._helpers.scale.generate("",this.buffer,n,e),o.Axis.setDimension(this.scaleAxis,t),o.Axis.setOrigin(this.scaleOffset,t,r),this.used=a.length,this.used!==u?this.trigger({type:"source.resize"}):void 0},e}(i),e.exports=r},{"../../../util":175,"../base/source":49}],60:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./voxel"),r=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","source","index","texture","voxel","span:x","span:y","span:z","volume","sampler:x","sampler:y","sampler:z","raw"],e.prototype.updateSpan=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;return i=this.props.axes,g=this.props.width,o=this.props.height,r=this.props.depth,t=this.props.centeredX,e=this.props.centeredY,n=this.props.centeredZ,l=this.props.paddingX,p=this.props.paddingY,h=this.props.paddingZ,c=this._helpers.span.get("x.",i[0]),f=this._helpers.span.get("y.",i[1]),d=this._helpers.span.get("z.",i[2]),this.aX=c.x,this.aY=f.x,this.aZ=d.x,m=c.y-c.x,v=f.y-f.x,y=d.y-d.x,g+=2*l,o+=2*p,r+=2*h,t?(s=1/Math.max(1,g),this.aX+=m*s/2):s=1/Math.max(1,g-1),e?(a=1/Math.max(1,o),this.aY+=v*a/2):a=1/Math.max(1,o-1),n?(u=1/Math.max(1,r),this.aZ+=y*u/2):u=1/Math.max(1,r-1),this.bX=m*s,this.bY=v*a,this.bZ=y*u,this.aX+=this.bX*l,this.aY+=this.bY*p,this.aZ+=this.bZ*p},e.prototype.callback=function(t){return this.updateSpan(),this.last===t?this._callback:(this.last=t,t.length<=7?this._callback=function(e){return function(n,r,i,o){var s,a,u;return s=e.aX+e.bX*r,a=e.aY+e.bY*i,u=e.aZ+e.bZ*o,t(n,s,a,u,r,i,o)}}(this):this._callback=function(e){return function(n,r,i,o){var s,a,u;return s=e.aX+e.bX*r,a=e.aY+e.bY*i,u=e.aZ+e.bZ*o,t(n,s,a,u,r,i,o,e.bufferClock,e.bufferStep)}}(this))},e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this._helpers.span.make(),this._listen(this,"span.range",this.updateSpan)},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this._helpers.span.unmake()},e}(o),e.exports=i},{"../../../util":175,"./voxel":61}],61:[function(t,e,n){var r,i,o,s=function(t,e){return function(){return t.apply(e,arguments)}},a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;r=t("./buffer"),i=t("../../../util"),o=function(t){function e(){return this.update=s(this.update,this),e.__super__.constructor.apply(this,arguments)}return a(e,t),e.traits=["node","buffer","active","data","source","index","texture","voxel","raw"],e.prototype.init=function(){return this.buffer=this.spec=null,this.space={width:0,height:0,depth:0},this.used={width:0,height:0,depth:0},this.storage="voxelBuffer",this.passthrough=function(t,e,n,r){return t(e,n,r,0)},e.__super__.init.apply(this,arguments)},e.prototype.sourceShader=function(t){var e;return e=this.getDimensions(),this.alignShader(e,t),this.buffer.shader(t)},e.prototype.getDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.height,depth:this.space.depth}},e.prototype.getActiveDimensions=function(){return{items:this.items,width:this.used.width,height:this.used.height,depth:this.used.depth*this.buffer.getFilled()}},e.prototype.getRawDimensions=function(){return this.getDimensions()},e.prototype.make=function(){var t,n,r,o,s,a,u,l,p,h,c,f,d,m,v,y,g;return e.__super__.make.apply(this,arguments),l=null!=(p=this.minFilter)?p:this.props.minFilter,u=null!=(h=this.magFilter)?h:this.props.magFilter,y=null!=(c=this.type)?c:this.props.type,g=this.props.width,s=this.props.height,r=this.props.depth,f=this.props.bufferWidth,d=this.props.bufferHeight,m=this.props.bufferDepth,t=this.props.channels,a=this.props.items,o=this.spec={channels:t,items:a,width:g,height:s,depth:r},this.items=o.items,this.channels=o.channels,n=this.props.data,o=i.Data.getDimensions(n,o),v=this.space,v.width=Math.max(f,o.width||1),v.height=Math.max(d,o.height||1),v.depth=Math.max(m,o.depth||1),this.buffer=this._renderables.make(this.storage,{width:v.width,height:v.height,depth:v.depth,channels:t,items:a,minFilter:l,magFilter:u,type:y})},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.buffer?(this.buffer.dispose(),this.buffer=this.spec=null):void 0},e.prototype.change=function(t,e,n){var r,i,o;if(e.texture||t["buffer.channels"]||t["buffer.items"]||t["voxel.bufferWidth"]||t["voxel.bufferHeight"]||t["voxel.bufferDepth"])return this.rebuild();if(this.buffer)return t["voxel.width"]&&(o=this.props.width,o>this.space.width)?this.rebuild():t["voxel.height"]&&(i=this.props.height,i>this.space.height)?this.rebuild():t["voxel.depth"]&&(r=this.props.depth,r>this.space.depth)?this.rebuild():t["data.map"]||t["data.data"]||t["data.resolve"]||t["data.expr"]||n?this.buffer.setCallback(this.emitter()):void 0},e.prototype.callback=function(t){return t.length<=4?t:function(e){return function(n,r,i,o){return t(n,r,i,o,e.bufferClock,e.bufferStep)}}(this)},e.prototype.update=function(){var t,e,n,r,o,s,a;if(this.buffer)return e=this.props.data,o=this.space,s=this.used,a=s.width,r=s.height,t=s.depth,n=this.buffer.getFilled(),this.syncBuffer(function(t){return function(n){var r,a,u,l,p,h,c,f;return null!=e?(p=i.Data.getDimensions(e,t.spec),p.width>o.width||p.height>o.height||p.depth>o.depth?(n(),t.rebuild()):(s.width=p.width,s.height=p.height,s.depth=p.depth,t.buffer.setActive(s.width,s.height,s.depth),"function"==typeof(u=t.buffer.callback).rebind&&u.rebind(e),t.buffer.update())):(f=t.spec.width||1,h=t.spec.height||1,l=t.spec.depth||1,t.buffer.setActive(f,h,l),c=t.buffer.update(),s.width=a=f,s.height=r=h,s.depth=Math.ceil(c/a/r),1===s.depth&&(s.height=Math.ceil(c/a),1===s.height)?s.width=c:void 0)}}(this)),s.width!==a||s.height!==r||s.depth!==t||n!==this.buffer.getFilled()?this.trigger({type:"source.resize"}):void 0},e}(r),e.exports=o},{"../../../util":175,"./buffer":55}],62:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.axisPosition=this.axisStep=this.resolution=this.line=this.arrows=null}return s(e,t),e.traits=["node","object","visible","style","line","axis","span","interval","arrow","position","origin","shade"],e.defaults={end:!0,zBias:-1},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;return h={axisPosition:this._attributes.make(this._types.vec4()),axisStep:this._attributes.make(this._types.vec4())},this.axisPosition=h.axisPosition.value,this.axisStep=h.axisStep.value,p=this._shaders.shader(),p.pipe("axis.position",h),p=this._helpers.position.pipeline(p),g=this._helpers.style.uniforms(),a=this._helpers.line.uniforms(),t=this._helpers.arrow.uniforms(),w=this._inherit("unit").getUnitUniforms(),r=this.props.detail,m=r+1,this.resolution=1/r,c=this.props,v=c.start,i=c.end,f=this.props,y=f.stroke,s=f.join,u=this._helpers.object.mask(),l=this._helpers.shade.pipeline()||!1,d=this.props,n=d.crossed,e=d.axis,!n&&null!=u&&e>1&&(_=["x000","y000","z000","w000"][e],u=this._helpers.position.swizzle(u,_)),b=o.JS.merge(t,a,g,w),this.line=this._renderables.make("line",{uniforms:b,samples:m,position:p,clip:v||i,stroke:y,join:s,mask:u,material:l}),this.arrows=[],v&&this.arrows.push(this._renderables.make("arrow",{uniforms:b,flip:!0,samples:m,position:p,mask:u,material:l})),i&&this.arrows.push(this._renderables.make("arrow",{uniforms:b,samples:m,position:p,mask:u,material:l})),this._helpers.visible.make(),this._helpers.object.make(this.arrows.concat([this.line])),this._helpers.span.make(),this._listen(this,"span.range",this.updateRanges)},e.prototype.unmake=function(){return this._helpers.visible.unmake(),this._helpers.object.unmake(),this._helpers.span.unmake()},e.prototype.change=function(t,e,n){return t["axis.detail"]||t["line.stroke"]||t["line.join"]||t["axis.crossed"]||t["interval.axis"]&&this.props.crossed?this.rebuild():e.interval||e.span||e.view||n?this.updateRanges():void 0},e.prototype.updateRanges=function(){var t,e,n,r,i,s;return s=this.props,t=s.axis,r=s.origin,i=this._helpers.span.get("",t),n=i.x,e=i.y,o.Axis.setDimension(this.axisPosition,t).multiplyScalar(n),o.Axis.setDimension(this.axisStep,t).multiplyScalar((e-n)*this.resolution),o.Axis.addOrigin(this.axisPosition,t,r)},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],63:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.face=null}return s(e,t),e.traits=["node","object","visible","style","line","mesh","face","geometry","position","bind","shade"],e.prototype.resize=function(){var t,e,n,r,i,o;if(null!=this.bind.points)return e=this.bind.points.getActiveDimensions(),r=e.items,o=e.width,n=e.height,t=e.depth,this.face&&this.face.geometry.clip(o,n,t,r),this.line&&this.line.geometry.clip(r,o,n,t),null!=this.bind.map&&(i=this.bind.map.getActiveDimensions(),this.face)?this.face.geometry.map(i.width,i.height,i.depth,i.items):void 0},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"mesh.map",trait:"source"}]),null!=this.bind.points?(v=this.bind.points.sourceShader(this._shaders.shader()),v=this._helpers.position.pipeline(v),w=this._helpers.style.uniforms(),h=this._helpers.line.uniforms(),E=this._inherit("unit").getUnitUniforms(),z={},z.styleZBias=this._attributes.make(this._types.number()),this.wireZBias=z.styleZBias,n=this.bind.points.getDimensions(),a=n.items,S=n.width,s=n.height,e=n.depth,y=this.props,l=y.line,_=y.shaded,i=y.fill,b=y.stroke,u=y.join,this.bind.colors&&(t=this._shaders.shader(),this.bind.colors.sourceShader(t)),f=this._helpers.object.mask(),c=this._helpers.shade.map(null!=(g=this.bind.map)?g.sourceShader(this._shaders.shader()):void 0),d=this._helpers.shade.pipeline(),r=d||_,p=d||!1,m=[],l&&(x=this._shaders.shader(),x.pipe(o.GLSL.swizzleVec4("yzwx")),x.pipe(v),k=o.JS.merge(E,h,w,z),this.line=this._renderables.make("line",{uniforms:k,samples:a,strips:S,ribbons:s,layers:e,position:x,color:t,stroke:b,join:u,material:p,mask:f,closed:!0}),m.push(this.line)),i&&(k=o.JS.merge(E,w,{}),this.face=this._renderables.make("face",{uniforms:k,width:S,height:s,depth:e,items:a,position:v,color:t,material:r,mask:f,map:c}),m.push(this.face)),this._helpers.visible.make(),this._helpers.object.make(m)):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.face=this.line=null},e.prototype.change=function(t,e,n){var r,i,o,s;return t["geometry.points"]||e.mesh?this.rebuild():t["style.zBias"]||t["mesh.lineBias"]||n?(o=this.props,r=o.fill,s=o.zBias,i=o.lineBias,this.wireZBias.value=s+(r?i:0)):void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],64:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.axes=null}return s(e,t),e.traits=["node","object","visible","style","line","grid","area","position","origin","shade","axis:x","axis:y","scale:x","scale:y","span:x","span:y"],e.defaults={width:1,zBias:-2},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f;return u=this._helpers.object.mask(),l=this._helpers.shade.pipeline()||!1,e=function(t){return function(e,n,i){var s,a,p,h,f,d,m,v,y,g,_,b,w,x;return a=t._get(e+"axis.detail"),y=a+1,v=1/a,g=t._helpers.scale.divide(n),s=t._renderables.make("dataBuffer",{width:g,channels:1}),m={gridPosition:t._attributes.make(t._types.vec4()),gridStep:t._attributes.make(t._types.vec4()),gridAxis:t._attributes.make(t._types.vec4())},x={gridPosition:m.gridPosition.value,gridStep:m.gridStep.value,gridAxis:m.gridAxis.value},f=d=t._shaders.shader(),null!=i&&null!=u&&(u=t._helpers.position.swizzle(u,i)),f.require(s.shader(t._shaders.shader(),2)),f.pipe("grid.position",m),d=t._helpers.position.pipeline(f),_=t._helpers.style.uniforms(),h=t._helpers.line.uniforms(),w=t._inherit("unit").getUnitUniforms(),b=o.JS.merge(h,_,w),p=t._renderables.make("line",{uniforms:b,samples:y,strips:g,position:d,stroke:c,join:r,mask:u,material:l}),{first:e,second:n,resolution:v,samples:y,line:p,buffer:s,values:x}}}(this),p=this.props,i=p.lineX,s=p.lineY,n=p.crossed,t=p.axes,f=["0000","x000","y000","z000","w000"][t[1]],h=this.props,c=h.stroke,r=h.join,this.axes=[],i&&this.axes.push(e("x.","y.",null)),s&&this.axes.push(e("y.","x.",n?null:f)),a=function(){var t,n,r,i;for(r=this.axes,i=[],t=0,n=r.length;n>t;t++)e=r[t],i.push(e.line);return i}.call(this),this._helpers.visible.make(),this._helpers.object.make(a),this._helpers.span.make(),this._listen(this,"span.range",this.updateRanges)},e.prototype.unmake=function(){var t,e,n,r;for(this._helpers.visible.unmake(),this._helpers.object.unmake(),this._helpers.span.unmake(),r=this.axes,e=0,n=r.length;n>e;e++)t=r[e],t.buffer.dispose();return this.axes=null},e.prototype.change=function(t,e,n){return t["x.axis.detail"]||t["y.axis.detail"]||t["x.axis.factor"]||t["y.axis.factor"]||t["grid.lineX"]||t["grid.lineY"]||t["line.stroke"]||t["line.join"]||t["grid.crossed"]||t["grid.axes"]&&this.props.crossed?this.rebuild():e.x||e.y||e.area||e.grid||e.view||n?this.updateRanges():void 0},e.prototype.updateRanges=function(){var t,e,n,r,i,s,a,u,l;return e=function(e){return function(n,r,s,a,u){var l,p,h,c,f,d,m,v,y,g,_;return p=u.first,y=u.second,m=u.resolution,v=u.samples,h=u.line,l=u.buffer,_=u.values,f=s.x,c=s.y,o.Axis.setDimension(_.gridPosition,n).multiplyScalar(f),o.Axis.setDimension(_.gridStep,n).multiplyScalar((c-f)*m),
o.Axis.addOrigin(_.gridPosition,t,i),f=a.x,c=a.y,g=e._helpers.scale.generate(y,l,f,c),o.Axis.setDimension(_.gridAxis,r),d=g.length,h.geometry.clip(v,d,1,1)}}(this),u=this.props,t=u.axes,i=u.origin,s=this._helpers.span.get("x.",t[0]),a=this._helpers.span.get("y.",t[1]),l=this.props,n=l.lineX,r=l.lineY,n&&e(t[0],t[1],s,a,this.axes[0]),r?e(t[1],t[0],a,s,this.axes[+n]):void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],65:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.line=this.arrows=null}return s(e,t),e.traits=["node","object","visible","style","line","arrow","geometry","position","bind","shade"],e.prototype.resize=function(){var t,e,n,r,i,o,s,a,u,l;if(null!=this.bind.points){for(e=this.bind.points.getActiveDimensions(),u=e.width,l=e.height,a=e.depth,r=e.items,this.line.geometry.clip(u,l,a,r),o=this.arrows,s=[],n=0,i=o.length;i>n;n++)t=o[n],s.push(t.geometry.clip(u,l,a,r));return s}},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]),null!=this.bind.points?(p=this._shaders.shader(),p=this.bind.points.sourceShader(p),p=this._helpers.position.pipeline(p),_=this._helpers.style.uniforms(),a=this._helpers.line.uniforms(),t=this._helpers.arrow.uniforms(),w=this._inherit("unit").getUnitUniforms(),c=this.props,v=c.start,r=c.end,f=this.props,g=f.stroke,i=f.join,h=f.proximity,this.proximity=h,n=this.bind.points.getDimensions(),m=n.width,y=n.height,d=n.depth,s=n.items,this.bind.colors&&(e=this._shaders.shader(),this.bind.colors.sourceShader(e)),u=this._helpers.object.mask(),l=this._helpers.shade.pipeline()||!1,b=o.JS.merge(t,a,_,w),this.line=this._renderables.make("line",{uniforms:b,samples:m,strips:y,ribbons:d,layers:s,position:p,color:e,clip:v||r,stroke:g,join:i,proximity:h,mask:u,material:l}),this.arrows=[],v&&this.arrows.push(this._renderables.make("arrow",{uniforms:b,flip:!0,samples:m,strips:y,ribbons:d,layers:s,position:p,color:e,mask:u,material:l})),r&&this.arrows.push(this._renderables.make("arrow",{uniforms:b,samples:m,strips:y,ribbons:d,layers:s,position:p,color:e,mask:u,material:l})),this._helpers.visible.make(),this._helpers.object.make(this.arrows.concat([this.line]))):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.line=this.arrows=null},e.prototype.change=function(t,e,n){return t["geometry.points"]||t["line.stroke"]||t["line.join"]||t["arrow.start"]||t["arrow.end"]?this.rebuild():t["line.proximity"]&&null!=this.proximity!=(null!=this.props.proximity)?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],66:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.point=null}return s(e,t),e.traits=["node","object","visible","style","point","geometry","position","bind","shade"],e.prototype.resize=function(){var t,e,n,r,i;if(null!=this.bind.points)return e=this.bind.points.getActiveDimensions(),r=e.items,i=e.width,n=e.height,t=e.depth,this.point.geometry.clip(i,n,t,r)},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"point.sizes",trait:"source"}]),null!=this.bind.points?(h=this._shaders.shader(),h=this.bind.points.sourceShader(h),h=this._helpers.position.pipeline(h),n=this.bind.points.getDimensions(),s=n.items,y=n.width,i=n.height,e=n.depth,d=this._helpers.style.uniforms(),p=this._helpers.point.uniforms(),v=this._inherit("unit").getUnitUniforms(),this.bind.colors&&(t=this._shaders.shader(),this.bind.colors.sourceShader(t)),this.bind.sizes&&(f=this._shaders.shader(),this.bind.sizes.sourceShader(f)),a=this._helpers.object.mask(),u=this._helpers.shade.pipeline()||!1,c=this.props.shape,r=this.props.fill,l=this.props.optical,m=o.JS.merge(v,p,d),this.point=this._renderables.make("point",{uniforms:m,width:y,height:i,depth:e,items:s,position:h,color:t,size:f,shape:c,optical:l,fill:r,mask:a,material:u}),this._helpers.visible.make(),this._helpers.object.make([this.point])):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.point=null},e.prototype.change=function(t,e,n){return t["geometry.points"]||t["point.shape"]||t["point.fill"]?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],67:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),o=t("../../../util"),i=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.strip=null}return s(e,t),e.traits=["node","object","visible","style","line","mesh","strip","geometry","position","bind","shade"],e.prototype.resize=function(){var t,e,n,r,i,o;if(null!=this.bind.points)return e=this.bind.points.getActiveDimensions(),r=e.items,o=e.width,n=e.height,t=e.depth,this.strip&&this.strip.geometry.clip(o,n,t,r),this.line&&this.line.geometry.clip(r,o,n,t),null!=this.bind.map&&(i=this.bind.map.getActiveDimensions(),this.strip)?this.strip.geometry.map(i.width,i.height,i.depth,i.items):void 0},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"mesh.map",trait:"source"}]),null!=this.bind.points?(v=this._shaders.shader(),v=this.bind.points.sourceShader(v),v=this._helpers.position.pipeline(v),w=this._helpers.style.uniforms(),h=this._helpers.line.uniforms(),E=this._inherit("unit").getUnitUniforms(),l=this.props.line,_=this.props.shaded,i=this.props.fill,z={},z.styleZBias=this._attributes.make(this._types.number()),this.wireZBias=z.styleZBias,n=this.bind.points.getDimensions(),a=n.items,S=n.width,s=n.height,e=n.depth,y=this.props,l=y.line,_=y.shaded,i=y.fill,b=y.stroke,u=y.join,this.bind.colors&&(t=this._shaders.shader(),t=this.bind.colors.sourceShader(t)),f=this._helpers.object.mask(),c=this._helpers.shade.map(null!=(g=this.bind.map)?g.sourceShader(this._shaders.shader()):void 0),d=this._helpers.shade.pipeline(),r=d||_,p=d||!1,m=[],l&&(x=this._shaders.shader(),x.pipe(o.GLSL.swizzleVec4("yzwx")),x.pipe(v),k=o.JS.merge(E,h,w,z),this.line=this._renderables.make("line",{uniforms:k,samples:a,strips:S,ribbons:s,layers:e,position:x,color:t,stroke:b,join:u,mask:f,material:p}),m.push(this.line)),i&&(k=o.JS.merge(w,{}),this.strip=this._renderables.make("strip",{uniforms:k,width:S,height:s,depth:e,items:a,position:v,color:t,material:r}),m.push(this.strip)),this._helpers.visible.make(),this._helpers.object.make(m)):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.strip=null},e.prototype.change=function(t,e,n){var r,i,o,s;return t["geometry.points"]||e.mesh?this.rebuild():t["style.zBias"]||t["mesh.lineBias"]||n?(o=this.props,r=o.fill,s=o.zBias,i=o.lineBias,this.wireZBias.value=s+(r?i:0)):void 0},e}(r),e.exports=i},{"../../../util":175,"../../primitive":44}],68:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),o=t("../../../util"),i=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.lineX=this.lineY=this.surface=null}return s(e,t),e.traits=["node","object","visible","style","line","mesh","geometry","surface","position","grid","bind","shade"],e.defaults={lineX:!1,lineY:!1},e.prototype.resize=function(){var t,e,n,r,i,o;if(null!=this.bind.points)return e=this.bind.points.getActiveDimensions(),o=e.width,n=e.height,t=e.depth,r=e.items,this.surface&&this.surface.geometry.clip(o,n,t,r),this.lineX&&this.lineX.geometry.clip(o,n,t,r),this.lineY&&this.lineY.geometry.clip(n,o,t,r),null!=this.bind.map&&(i=this.bind.map.getActiveDimensions(),this.surface)?this.surface.geometry.map(i.width,i.height,i.depth,i.items):void 0},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"mesh.map",trait:"source"}]),null!=this.bind.points?(b=this._shaders.shader(),b=this.bind.points.sourceShader(b),b=this._helpers.position.pipeline(b),M=this._helpers.style.uniforms(),I=this._helpers.style.uniforms(),f=this._helpers.line.uniforms(),T=this._helpers.surface.uniforms(),R=this._inherit("unit").getUnitUniforms(),I.styleColor=this._attributes.make(this._types.color()),I.styleZBias=this._attributes.make(this._types.number()),this.wireColor=I.styleColor.value,this.wireZBias=I.styleZBias,this.wireScratch=new THREE.Color,s=this.bind.points.getDimensions(),C=s.width,l=s.height,i=s.depth,p=s.items,x=this.props,S=x.shaded,u=x.fill,d=x.lineX,m=x.lineY,t=x.closedX,e=x.closedY,z=x.stroke,h=x.join,w=x.proximity,r=x.crossed,_=[],this.proximity=w,this.bind.colors&&(n=this._shaders.shader(),this.bind.colors.sourceShader(n)),y=this._helpers.object.mask(),v=this._helpers.shade.map(null!=(k=this.bind.map)?k.sourceShader(this._shaders.shader()):void 0),g=this._helpers.shade.pipeline(),a=g||S,c=g||!1,E=this._helpers.position,O=E.swizzle,A=E.swizzle2,P=o.JS.merge(R,f,M,I),D=d||m?-50:0,d&&(this.lineX=this._renderables.make("line",{uniforms:P,samples:C,strips:l,ribbons:i,layers:p,position:b,color:n,zUnits:-D,stroke:z,join:h,mask:y,material:c,proximity:w,closed:t||closed}),_.push(this.lineX)),m&&(this.lineY=this._renderables.make("line",{uniforms:P,samples:l,strips:C,ribbons:i,layers:p,position:A(b,"yxzw","yxzw"),color:O(n,"yxzw"),zUnits:-D,stroke:z,join:h,mask:O(y,r?"xyzw":"yxzw"),material:c,proximity:w,closed:e||closed}),_.push(this.lineY)),u&&(P=o.JS.merge(R,T,M),this.surface=this._renderables.make("surface",{uniforms:P,width:C,height:l,surfaces:i,layers:p,position:b,color:n,zUnits:D,stroke:z,material:a,mask:y,map:v,intUV:!0,closedX:t||closed,closedY:e||closed}),_.push(this.surface)),this._helpers.visible.make(),this._helpers.object.make(_)):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.lineX=this.lineY=this.surface=null},e.prototype.change=function(t,e,n){var r,i,o,s,a,u;return t["geometry.points"]||t["mesh.shaded"]||t["mesh.fill"]||t["line.stroke"]||t["line.join"]||e.grid?this.rebuild():((t["style.color"]||t["style.zBias"]||t["mesh.fill"]||t["mesh.lineBias"]||n)&&(a=this.props,o=a.fill,i=a.color,u=a.zBias,s=a.lineBias,this.wireZBias.value=u+(o?s:0),this.wireColor.copy(i),o&&(r=this.wireScratch,r.setRGB(i.x,i.y,i.z),r.convertGammaToLinear().multiplyScalar(.75).convertLinearToGamma(),this.wireColor.x=r.r,this.wireColor.y=r.g,this.wireColor.z=r.b)),t["line.proximity"]&&null!=this.proximity!=(null!=this.props.proximity)?this.rebuild():void 0)},e}(r),e.exports=i},{"../../../util":175,"../../primitive":44}],69:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","object","visible","style","line","ticks","geometry","position","bind","shade"],e.prototype.init=function(){return this.tickStrip=this.line=null},e.prototype.resize=function(){var t,e,n,r,i;if(null!=this.bind.points)return e=this.bind.points.getActiveDimensions(),t=+(e.items>0),i=e.width*t,r=e.height*t,n=e.depth*t,this.line.geometry.clip(2,i,r,n),this.tickStrip.set(0,i-1)},e.prototype.make=function(){var t,e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]),null!=this.bind.points?(v=this._helpers.style.uniforms(),i=this._helpers.line.uniforms(),b=this._inherit("unit").getUnitUniforms(),_=o.JS.merge(i,v,b),p={tickEpsilon:this.node.attributes["ticks.epsilon"],tickSize:this.node.attributes["ticks.size"],tickNormal:this.node.attributes["ticks.normal"],tickStrip:this._attributes.make(this._types.vec2(0,0)),worldUnit:_.worldUnit,focusDepth:_.focusDepth},this.tickStrip=p.tickStrip.value,u=l=this._shaders.shader(),u.require(this.bind.points.sourceShader(this._shaders.shader())),u.require(this._helpers.position.pipeline(this._shaders.shader())),u.pipe("ticks.position",p),h=this.props,m=h.stroke,n=h.join,e=this.bind.points.getDimensions(),d=e.width,f=e.height,r=e.depth,this.bind.colors&&(t=this._shaders.shader(),this.bind.colors.sourceShader(t)),s=this._helpers.object.mask(),a=this._helpers.shade.pipeline()||!1,c=this._helpers.position,y=c.swizzle,g=c.swizzle2,this.line=this._renderables.make("line",{uniforms:_,samples:2,strips:d,ribbons:f,layers:r,position:l,color:t,stroke:m,join:n,mask:y(s,"yzwx"),material:a}),this._helpers.visible.make(),this._helpers.object.make([this.line])):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this.line=null,this._helpers.visible.unmake(),this._helpers.object.unmake()},e.prototype.change=function(t,e,n){return t["geometry.points"]||t["line.stroke"]||t["line.join"]?this.rebuild():void 0},e}(r),e.exports=i},{"../../../util":175,"../../primitive":44}],70:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),i=t("../../../util"),o=function(t){function e(t,n,r){e.__super__.constructor.call(this,t,n,r),this.line=this.arrows=null}return s(e,t),e.traits=["node","object","visible","style","line","arrow","geometry","position","bind","shade"],e.prototype.resize=function(){var t,e,n,r,i,o,s,a,u,l;if(null!=this.bind.points){for(e=this.bind.points.getActiveDimensions(),u=e.items,l=e.width,a=e.height,r=e.depth,this.line.geometry.clip(u,l,a,r),o=this.arrows,s=[],n=0,i=o.length;i>n;n++)t=o[n],s.push(t.geometry.clip(u,l,a,r));return s}},e.prototype.make=function(){var t,e,n,r,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E;return this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]),null!=this.bind.points?(p=this._shaders.shader(),this.bind.points.sourceShader(p),this._helpers.position.pipeline(p),b=this._helpers.style.uniforms(),a=this._helpers.line.uniforms(),t=this._helpers.arrow.uniforms(),E=this._inherit("unit").getUnitUniforms(),c=this.props,y=c.start,r=c.end,f=this.props,_=f.stroke,o=f.join,h=f.proximity,this.proximity=h,n=this.bind.points.getDimensions(),v=n.items,g=n.width,m=n.height,s=n.depth,this.bind.colors&&(e=this._shaders.shader(),this.bind.colors.sourceShader(e)),u=this._helpers.object.mask(),l=this._helpers.shade.pipeline()||!1,d=this._helpers.position,w=d.swizzle,x=d.swizzle2,p=x(p,"yzwx","yzwx"),e=w(e,"yzwx"),u=w(u,"yzwx"),l=w(l,"yzwx"),k=i.JS.merge(t,a,b,E),this.line=this._renderables.make("line",{uniforms:k,samples:v,ribbons:m,strips:g,layers:s,position:p,color:e,clip:y||r,stroke:_,join:o,proximity:h,mask:u,material:l}),this.arrows=[],y&&this.arrows.push(this._renderables.make("arrow",{uniforms:k,flip:!0,samples:v,ribbons:m,strips:g,layers:s,position:p,color:e,mask:u,material:l})),r&&this.arrows.push(this._renderables.make("arrow",{uniforms:k,samples:v,ribbons:m,strips:g,layers:s,position:p,color:e,mask:u,material:l})),this._helpers.visible.make(),this._helpers.object.make(this.arrows.concat([this.line]))):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.line=this.arrows=null},e.prototype.change=function(t,e,n){return t["geometry.points"]||t["line.stroke"]||t["line.join"]||t["arrow.start"]||t["arrow.end"]?this.rebuild():t["line.proximity"]&&null!=this.proximity!=(null!=this.props.proximity)?this.rebuild():void 0},e}(r),e.exports=o},{"../../../util":175,"../../primitive":44}],71:[function(t,e,n){var r,i,o,s=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};r=t("../../util"),i=t("./view/view"),o={bind:{make:function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;for(null==this.bind&&(this.bind={}),null==this.bound&&(this.bound=[]),r=0,s=t.length;s>r;r++){if(f=t[r],v=f.to,y=f.trait,p=f.optional,g=f.unique,u=f.multiple,e=f.callback,null==e&&(e=this.rebuild),l=v.split(/\./g).pop(),c=this._get(v),d=null,null!=c)for(m=this,n=!1;!n;)m=d=this._attach(c,y,e,this,m,p,u),i=g&&(null==d||this.bound.indexOf(d)<0),n=u||p||!g||i;if(null!=d)if(null!=this.resize&&this._listen(d,"source.resize",this.resize),e&&this._listen(d,"source.rebuild",e),u)for(o=0,a=d.length;a>o;o++)h=d[o],this.bound.push(h);else this.bound.push(d);this.bind[l]=d}return null},unmake:function(){return this.bind?(delete this.bind,delete this.bound):void 0}},span:{make:function(){return this.spanView=this._inherit("view"),this._listen("view","view.range",function(t){return function(){return t.trigger({type:"span.range"})}}(this))},unmake:function(){return delete this.spanView},get:function(){var t;return t=new THREE.Vector2(-1,1),function(e,n){var r,i,o;return r=this._get(e+"span.range"),null!=r?r:null!=(i=null!=(o=this.spanView)?o.axis(n):void 0)?i:t}}()},scale:{divide:function(t){var e,n;return e=this._get(t+"scale.divide"),n=this._get(t+"scale.factor"),Math.round(2.5*e/n)},generate:function(t,e,n,i){var o,s,a,u,l,p,h,c,f,d;return l=this._get(t+"scale.mode"),s=this._get(t+"scale.divide"),f=this._get(t+"scale.unit"),o=this._get(t+"scale.base"),u=this._get(t+"scale.factor"),h=this._get(t+"scale.start"),a=this._get(t+"scale.end"),d=this._get(t+"scale.zero"),p=this._get(t+"scale.nice"),c=r.Ticks.make(l,n,i,s,f,o,u,h,a,d,p),e.copy(c),c}},style:{uniforms:function(){return{styleColor:this.node.attributes["style.color"],styleOpacity:this.node.attributes["style.opacity"],styleZBias:this.node.attributes["style.zBias"],styleZIndex:this.node.attributes["style.zIndex"]}}},arrow:{uniforms:function(){var t,e,n,r,i;return r=this.props.start,t=this.props.end,n=this._attributes.make(this._types.number(1.25/(r+t))),i=this._attributes.make(this._types.vec2(+r,+t)),e=this.node.attributes["arrow.size"],{clipStyle:i,clipRange:e,clipSpace:n,arrowSpace:n,arrowSize:e}}},point:{uniforms:function(){return{pointSize:this.node.attributes["point.size"],pointDepth:this.node.attributes["point.depth"]}}},line:{uniforms:function(){return{lineWidth:this.node.attributes["line.width"],lineDepth:this.node.attributes["line.depth"],lineProximity:this.node.attributes["line.proximity"]}}},surface:{uniforms:function(){return{}}},shade:{pipeline:function(t){var e,n,r;if(!this._inherit("fragment"))return t;for(null==t&&(t=this._shaders.shader()),n=e=0;2>=e;n=++e)t=null!=(r=this._inherit("fragment"))?r.fragment(t,n):void 0;return t.pipe("fragment.map.rgba"),t},map:function(t){return t?t=this._shaders.shader().pipe("mesh.map.uvwo").pipe(t):t}},position:{pipeline:function(t){var e,n,r;if(!this._inherit("vertex"))return t;for(null==t&&(t=this._shaders.shader()),n=e=0;3>=e;n=++e)t=null!=(r=this._inherit("vertex"))?r.vertex(t,n):void 0;return t},swizzle:function(t,e){return t?this._shaders.shader().pipe(r.GLSL.swizzleVec4(e)).pipe(t):void 0},swizzle2:function(t,e,n){return t?this._shaders.shader().split().pipe(r.GLSL.swizzleVec4(e)).next().pipe(r.GLSL.swizzleVec4(n)).join().pipe(t):void 0}},visible:{make:function(){var t,e,n,r;return t={type:"visible.change"},n=null,this.setVisible=function(t){return null!=t&&(n=t),e()},e=function(e){return function(){var i,o,s;return i=e.isVisible,s=null!=(o=null!=n?n:e._get("object.visible"))?o:!0,"undefined"!=typeof r&&null!==r&&s&&(s=r.isVisible),e.isVisible=s,i!==e.isVisible?e.trigger(t):void 0}}(this),r=this._inherit("visible"),r&&this._listen(r,"visible.change",e),this.is("object")&&this._listen(this.node,"change:object",e),e()},unmake:function(){return delete this.isVisible}},active:{make:function(){var t,e,n,r;return n={type:"active.change"},t=null,this.setActive=function(e){return null!=e&&(t=e),r()},r=function(r){return function(){var i,o,s;return i=r.isActive,s=null!=(o=null!=t?t:r._get("entity.active"))?o:!0,"undefined"!=typeof e&&null!==e&&s&&(s=e.isActive),r.isActive=s,i!==r.isActive?r.trigger(n):void 0}}(this),e=this._inherit("active"),e&&this._listen(e,"active.change",r),this.is("entity")&&this._listen(this.node,"change:entity",r),r()},unmake:function(){return delete this.isActive}},object:{make:function(t){var e,n,r,i,o,a,u,l,p,h,c,f,d,m;for(this.objects=null!=t?t:[],this.renders=this.objects.reduce(function(t,e){return t.concat(e.renders)},[]),u=this._inherit("scene"),h=e=f=null,n=s.call(this.traits,"style")>=0,h=1,e=THREE.NormalBlending,m=!0,d=!0,n&&(h=this.props.opacity,e=this.props.blending,f=this.props.zOrder,m=this.props.zWrite,d=this.props.zTest),l=function(t){return function(n){var r,i;return r=n.changed,i=null,r["style.opacity"]&&(i=h=t.props.opacity),r["style.blending"]&&(i=e=t.props.blending),r["style.zOrder"]&&(i=f=t.props.zOrder),r["style.zWrite"]&&(i=m=t.props.zWrite),r["style.zTest"]&&(i=d=t.props.zTest),null!=i?p():void 0}}(this),i=null,p=function(t){return function(){var r,i,o,s,a,u,l,p,c,v,y,g,_,b,w,x;if(p=null!=f?-f:t.node.order,x=(null!=(c=t.isVisible)?c:!0)&&h>0){if(n){for(v=t.objects,_=[],r=0,s=v.length;s>r;r++)l=v[r],l.show(1>h,e,p),_.push(l.depth(m,d));return _}for(y=t.objects,b=[],i=0,a=y.length;a>i;i++)l=y[i],b.push(l.show(!0,e,p));return b}for(g=t.objects,w=[],o=0,u=g.length;u>o;o++)l=g[o],w.push(l.hide());return w}}(this),this._listen(this.node,"change:style",l),this._listen(this.node,"reindex",p),this._listen(this,"visible.change",p),c=this.objects,r=0,o=c.length;o>r;r++)a=c[r],u.adopt(a);return p()},unmake:function(t){var e,n,r,i,o,s,a,u,l;if(null==t&&(t=!0),this.objects){for(s=this._inherit("scene"),a=this.objects,e=0,r=a.length;r>e;e++)o=a[e],s.unadopt(o);if(t){for(u=this.objects,l=[],n=0,i=u.length;i>n;n++)o=u[n],l.push(o.dispose());return l}}},mask:function(){var t,e;if(t=this._inherit("mask"))return e=t.mask(e)}},unit:{make:function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v;return v=Math.PI,this.unitUniforms={renderScaleInv:l=this._attributes.make(this._types.number(1)),renderScale:u=this._attributes.make(this._types.number(1)),renderAspect:o=this._attributes.make(this._types.number(1)),renderWidth:p=this._attributes.make(this._types.number(0)),renderHeight:s=this._attributes.make(this._types.number(0)),viewWidth:d=this._attributes.make(this._types.number(0)),viewHeight:f=this._attributes.make(this._types.number(0)),pixelRatio:r=this._attributes.make(this._types.number(1)),pixelUnit:i=this._attributes.make(this._types.number(1)),worldUnit:m=this._attributes.make(this._types.number(1)),focusDepth:e=this._attributes.make(this._types.number(1)),renderOdd:a=this._attributes.make(this._types.vec2())},c=new THREE.Vector3,t=new THREE.Vector3,n=function(n){return function(){var y,g,_,b,w,x,k,E,S,z,M,T,O,A;if(null!=(O="undefined"!=typeof h&&null!==h?h.getSize():void 0))return v=Math.PI,T=n.props.scale,b=n.props.fov,_=null!=(z=n.props.focus)?z:n.inherit("unit").props.focus,x=null===T,E=1,(y="undefined"!=typeof h&&null!==h?h.getCamera():void 0)&&(k=y.projectionMatrix,c.set(0,-.5,1).applyProjection(k),t.set(0,.5,1).applyProjection(k),c.sub(t),E=c.y),g=O.renderHeight/O.viewHeight,w=null!=b?E*Math.tan(b*v/360):1,S=x?g:O.renderHeight/T*w,M=O.renderHeight*E/2,A=S/M,d.value=O.viewWidth,f.value=O.viewHeight,p.value=O.renderWidth,s.value=O.renderHeight,o.value=O.aspect,u.value=M,l.value=1/M,r.value=g,i.value=S,m.value=A,e.value=_,a.value.set(O.renderWidth%2,O.renderHeight%2).multiplyScalar(.5)}}(this),h=this.is("root")?this:this._inherit("root"),this._listen(h,"root.update",n),n()},unmake:function(){return delete this.unitUniforms},get:function(){var t,e,n,r;n={},e=this.unitUniforms;for(t in e)r=e[t],n[t]=r.value;return n},uniforms:function(){return this.unitUniforms}}},e.exports=function(t,e){var n,r,i,s,a,u,l;for(n={},r=0,s=e.length;s>r;r++)if(l=e[r],u=o[l]){n[l]={};for(i in u)a=u[i],n[l][i]=a.bind(t)}return n}},{"../../util":175,"./view/view":122}],72:[function(t,e,n){var r;r=t("../../model"),n.Classes=t("./classes"),n.Types=t("./types"),n.Traits=t("./traits"),n.Helpers=t("./helpers")},{"../../model":34,"./classes":52,"./helpers":71,"./traits":107,"./types":115}],73:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./operator"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","bind","operator","source","index","clamp"],e.prototype.indexShader=function(t){return t.pipe(this.operator),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator),e.__super__.sourceShader.call(this,t)},e.prototype.make=function(){var t,n;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(n={clampLimit:this._attributes.make(this._types.vec4())},this.clampLimit=n.clampLimit,t=this._shaders.shader(),t.pipe("clamp.position",n),this.operator=t):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.resize=function(){var t;return null!=this.bind.source&&(t=this.bind.source.getActiveDimensions(),this.clampLimit.value.set(t.width-1,t.height-1,t.depth-1,t.items-1)),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.operator||e.clamp?this.rebuild():void 0},e}(i),e.exports=r},{"./operator":78}],74:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./operator"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","bind","operator","source","index","grow"],e.prototype.sourceShader=function(t){return t.pipe(this.operator)},e.prototype.make=function(){var t,n;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(n={growScale:this.node.attributes["grow.scale"],growMask:this._attributes.make(this._types.vec4()),growAnchor:this._attributes.make(this._types.vec4())},this.growMask=n.growMask.value,this.growAnchor=n.growAnchor.value,t=this._shaders.shader(),t.require(this.bind.source.sourceShader(this._shaders.shader())),t.pipe("grow.position",n),this.operator=t):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.resize=function(){return this.update(),e.__super__.resize.apply(this,arguments)},e.prototype.update=function(){var t,e,n,r,i,o,s,a,u;for(e=this.bind.source.getFutureDimensions(),a=["width","height","depth","items"],s=function(t,e){return((t||1)-1)*(.5-.5*e)},u=[],n=r=0,o=a.length;o>r;n=++r)i=a[n],t=this.props[i],this.growMask.setComponent(n,+(null==t)),u.push(this.growAnchor.setComponent(n,null!=t?s(e[i],t):0));return u},e.prototype.change=function(t,e,n){return e.operator?this.rebuild():e.grow?this.update():void 0},e}(i),e.exports=r},{"./operator":78}],75:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./operator"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","join"],e.prototype.indexShader=function(t){return t.pipe(this.operator),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator),e.__super__.sourceShader.call(this,t)},e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype._resample=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v;for(p=this.order,e=this.axis,c=this.overlap,u=this.length,v=this.stride,s=["width","height","depth","items"],l=p.map(function(t){return s[t-1]}),i=p.indexOf(e),m=function(){var e,r,i;for(i=[],e=0,r=l.length;r>e;e++)n=l[e],i.push(t[n]);return i}(),f=(null!=(d=m[i+1])?d:1)*v,m.splice(i,2,f),m=m.slice(0,3),m.push(1),h={},r=o=0,a=l.length;a>o;r=++o)n=l[r],h[n]=m[r];return h},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(u=this.props.order,t=this.props.axis,l=this.props.overlap,p=u.join(""),null==t&&(t=u[0]),r=p.indexOf(t),h=p.replace(t,"00").substring(0,4),i=[null,"width","height","depth","items"],a=i[t],n=this.bind.source.getDimensions(),s=n[a],l=Math.min(s-1,l),c=s-l,d={joinStride:this._attributes.make(this._types.number(c)),joinStrideInv:this._attributes.make(this._types.number(1/c))},f=this._shaders.shader(),f.require(o.GLSL.swizzleVec4(t,1)),f.require(o.GLSL.swizzleVec4(h,4)),f.require(o.GLSL.injectVec4([r,r+1])),f.pipe("join.position",d),f.pipe(o.GLSL.invertSwizzleVec4(u)),this.operator=f,this.order=u,this.axis=t,this.overlap=l,this.length=s,this.stride=c):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.join||e.operator?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"./operator":78}],76:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./operator"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","lerp","sampler:x","sampler:y","sampler:z","sampler:w"],e.prototype.indexShader=function(t){return t.pipe(this.indexer),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator)},e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype._resample=function(t){var e,n,r;return r=this.resampled,e=this.centered,n=this.padding,this.relativeSize?(e.items||t.items--,e.width||t.width--,e.height||t.height--,e.depth||t.depth--,
null!=r.items&&(t.items*=r.items),null!=r.width&&(t.width*=r.width),null!=r.height&&(t.height*=r.height),null!=r.depth&&(t.depth*=r.depth),e.items||t.items++,e.width||t.width++,e.height||t.height++,e.depth||t.depth++,t.items-=2*n.items,t.width-=2*n.width,t.height-=2*n.height,t.depth-=2*n.depth):(null!=r.items&&(t.items=r.items),null!=r.width&&(t.width=r.width),null!=r.height&&(t.height=r.height),null!=r.depth&&(t.depth=r.depth)),t.items=Math.max(0,Math.floor(t.items)),t.width=Math.max(0,Math.floor(t.width)),t.height=Math.max(0,Math.floor(t.height)),t.depth=Math.max(0,Math.floor(t.depth)),t},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S;if(e.__super__.make.apply(this,arguments),null!=this.bind.source){for(v=this.props,x=v.size,l=v.items,S=v.width,i=v.height,r=v.depth,_=x===this.node.attributes["lerp.size"]["enum"].relative,this.resampled={},null!=l&&(this.resampled.items=l),null!=S&&(this.resampled.width=S),null!=i&&(this.resampled.height=i),null!=r&&(this.resampled.depth=r),this.centered={},this.centered.items=this.props.centeredW,this.centered.width=this.props.centeredX,this.centered.height=this.props.centeredY,this.centered.depth=this.props.centeredZ,this.padding={},this.padding.items=this.props.paddingW,this.padding.width=this.props.paddingX,this.padding.height=this.props.paddingY,this.padding.depth=this.props.paddingZ,m=this._shaders.shader(),u=this._shaders.shader(),k={resampleFactor:this._attributes.make(this._types.vec4(0,0,0,0)),resampleBias:this._attributes.make(this._types.vec4(0,0,0,0))},this.resampleFactor=k.resampleFactor,this.resampleBias=k.resampleBias,b=null!=l||null!=S||null!=i||null!=r,m.pipe("resample.padding",k),E=[],t=!1,y=["width","height","depth","items"],s=p=0,f=y.length;f>p;s=++p)c=y[s],n=this.centered[c],t||(t=n),E[s]=n?"0.5":"0.0";for(t&&b&&(E="vec4("+E+")",m.pipe(o.GLSL.binaryOperator(4,"+",vec4)),u.pipe(o.GLSL.binaryOperator(4,"+",vec4))),b?(m.pipe("resample.relative",k),u.pipe("resample.relative",k)):(m.pipe(o.GLSL.identity("vec4")),u.pipe(o.GLSL.identity("vec4"))),t&&b&&(m.pipe(o.GLSL.binaryOperator(4,"-",E)),u.pipe(o.GLSL.binaryOperator(4,"-",E))),w=this.bind.source.sourceShader(this._shaders.shader()),g=["width","height","depth","items"],s=h=0,d=g.length;d>h;s=++h)c=g[s],a="lerp."+c,null!=this.props[c]&&(w=this._shaders.shader().require(w),w.pipe(a,k));return m.pipe(w),this.operator=m,this.indexer=u,this.relativeSize=_}},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.operator=null},e.prototype.resize=function(){var t,n,r,i,o,s,a,u,l,p,h,c,f,d,m;if(null!=this.bind.source)return s=this.bind.source.getActiveDimensions(),m=this.getActiveDimensions(),t=function(t){return function(e){var n,r,i;return n=t.centered[e],r=t.padding[e],m[e]+=2*r,i=n?s[e]/Math.max(1,m[e]):Math.max(1,s[e]-1)/Math.max(1,m[e]-1),[i,r]}}(this),u=t("width"),d=u[0],o=u[1],l=t("height"),c=l[0],r=l[1],p=t("depth"),a=p[0],n=p[1],h=t("items"),f=h[0],i=h[1],this.resampleFactor.value.set(d,c,a,f),this.resampleBias.value.set(o,r,n,i),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.operator||e.lerp||e.sampler?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"./operator":78}],77:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./operator"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","active","operator","source","index","texture","memo"],e.prototype.sourceShader=function(t){return this.memo.shaderAbsolute(t,1)},e.prototype.make=function(){var t,n,r,i,o,s,a,u,l,p;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(this._helpers.active.make(),this._listen("root","root.update",function(t){return function(){return t.isActive?t.update():void 0}}(this)),u=this.props,s=u.minFilter,o=u.magFilter,l=u.type,n=this.bind.source.getDimensions(),i=n.items,p=n.width,r=n.height,t=n.depth,this.memo=this._renderables.make("memo",{items:i,width:p,height:r,depth:t,minFilter:s,magFilter:o,type:l}),a=this._shaders.shader(),this.bind.source.sourceShader(a),this.compose=this._renderables.make("memoScreen",{map:a,items:i,width:p,height:r,depth:t}),this.memo.adopt(this.compose),this.objects=[this.compose],this.renders=this.compose.renders):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),null!=this.bind.source?(this._helpers.active.unmake(),this.memo.unadopt(this.compose),this.memo.dispose(),this.memo=this.compose=null):void 0},e.prototype.update=function(){var t;return null!=(t=this.memo)?t.render():void 0},e.prototype.resize=function(){var t,n,r,i;if(null!=this.bind.source)return n=this.bind.source.getActiveDimensions(),i=n.width,r=n.height,t=n.depth,this.compose.cover(i,r,t),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.texture||e.operator?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"./operator":78}],78:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("../base/source"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","bind","operator","source","index"],e.prototype.indexShader=function(t){var e;return null!=(e=this.bind.source)&&"function"==typeof e.indexShader?e.indexShader(t):void 0},e.prototype.sourceShader=function(t){var e;return null!=(e=this.bind.source)&&"function"==typeof e.sourceShader?e.sourceShader(t):void 0},e.prototype.getDimensions=function(){return this.bind.source.getDimensions()},e.prototype.getFutureDimensions=function(){return this.bind.source.getFutureDimensions()},e.prototype.getActiveDimensions=function(){return this.bind.source.getActiveDimensions()},e.prototype.getIndexDimensions=function(){return this.bind.source.getIndexDimensions()},e.prototype.init=function(){return this.sourceSpec=[{to:"operator.source",trait:"source"}]},e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this._helpers.bind.make(this.sourceSpec)},e.prototype.made=function(){return this.resize(),e.__super__.made.apply(this,arguments)},e.prototype.unmake=function(){return this._helpers.bind.unmake()},e.prototype.resize=function(t){return this.trigger({type:"source.resize"})},e}(i),e.exports=r},{"../base/source":49}],79:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","readback","entity","active"],e.finals={channels:4},e.prototype.init=function(){return this.emitter=this.root=null,this.active={}},e.prototype.make=function(){var t,n,r,i,o,s,a,u,l,p;return e.__super__.make.apply(this,arguments),this._compute("readback.data",function(t){return function(){var e;return null!=(e=t.readback)?e.data:void 0}}(this)),this._compute("readback.items",function(t){return function(){var e;return null!=(e=t.readback)?e.items:void 0}}(this)),this._compute("readback.width",function(t){return function(){var e;return null!=(e=t.readback)?e.width:void 0}}(this)),this._compute("readback.height",function(t){return function(){var e;return null!=(e=t.readback)?e.height:void 0}}(this)),this._compute("readback.depth",function(t){return function(){var e;return null!=(e=t.readback)?e.depth:void 0}}(this)),this._helpers.bind.make([{to:"operator.source",trait:"source"}]),null!=this.bind.source?(s=this.props,l=s.type,t=s.channels,r=s.expr,this.root=this._inherit("root"),this._listen("root","root.update",this.update),a=this.bind.source.getDimensions(),o=a.items,p=a.width,i=a.height,n=a.depth,u=this.bind.source.sourceShader(this._shaders.shader()),this.readback=this._renderables.make("readback",{map:u,items:o,width:p,height:i,depth:n,channels:t,type:l}),null!=r&&this.readback.setCallback(r),this._helpers.active.make()):void 0},e.prototype.unmake=function(){return null!=this.readback&&(this.readback.dispose(),this.readback=null,this.root=null,this.emitter=null,this.active={}),this._helpers.active.unmake(),this._helpers.bind.unmake()},e.prototype.update=function(){var t;if(null!=this.readback)return this.isActive&&(this.readback.update(null!=(t=this.root)?t.getCamera():void 0),this.readback.post(),null!=this.props.expr)?this.readback.iterate():void 0},e.prototype.resize=function(){var t,e,n,r,i,o,s,a;if(null!=this.readback)return r=this.bind.source.getActiveDimensions(),n=r.items,a=r.width,e=r.height,t=r.depth,this.readback.setActive(n,a,e,t),this.strideI=i=n,this.strideJ=o=i*a,this.strideK=s=o*e},e.prototype.change=function(t,e,n){return t["readback.type"]?this.rebuild():t["readback.expr"]&&this.readback?this.readback.setCallback(this.props.expr):void 0},e}(r),e.exports=i},{"../../../util":175,"../../primitive":44}],80:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./operator"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","bind","operator","source","index","repeat"],e.prototype.indexShader=function(t){return t.pipe(this.operator),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator),e.__super__.sourceShader.call(this,t)},e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype._resample=function(t){var e;return e=this.resample,{items:e.items*t.items,width:e.width*t.width,height:e.height*t.height,depth:e.depth*t.depth}},e.prototype.make=function(){var t,n;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(this.resample={},n={repeatModulus:this._attributes.make(this._types.vec4())},this.repeatModulus=n.repeatModulus,t=this._shaders.shader(),t.pipe("repeat.position",n),this.operator=t):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.resize=function(){var t;return null!=this.bind.source&&(t=this.bind.source.getActiveDimensions(),this.repeatModulus.value.set(t.width,t.height,t.depth,t.items)),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){var r,i,o,s,a;if(e.operator||e.repeat)return this.rebuild();if(n){for(s=["items","width","height","depth"],a=[],r=0,o=s.length;o>r;r++)i=s[r],a.push(this.resample[i]=this.props[i]);return a}},e}(r),e.exports=i},{"./operator":78}],81:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./operator"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","resample","sampler:x","sampler:y","sampler:z","sampler:w","include"],e.prototype.indexShader=function(t){return t.pipe(this.indexer),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator)},e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype._resample=function(t){var e,n,r;return r=this.resampled,e=this.centered,n=this.padding,this.relativeSize?(e.items||t.items--,e.width||t.width--,e.height||t.height--,e.depth||t.depth--,null!=r.items&&(t.items*=r.items),null!=r.width&&(t.width*=r.width),null!=r.height&&(t.height*=r.height),null!=r.depth&&(t.depth*=r.depth),e.items||t.items++,e.width||t.width++,e.height||t.height++,e.depth||t.depth++,t.items-=2*n.items,t.width-=2*n.width,t.height-=2*n.height,t.depth-=2*n.depth):(null!=r.items&&(t.items=r.items),null!=r.width&&(t.width=r.width),null!=r.height&&(t.height=r.height),null!=r.depth&&(t.depth=r.depth)),t.items=Math.max(0,Math.floor(t.items)),t.width=Math.max(0,Math.floor(t.width)),t.height=Math.max(0,Math.floor(t.height)),t.depth=Math.max(0,Math.floor(t.depth)),t},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M;if(e.__super__.make.apply(this,arguments),null!=this.bind.source){for(this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:!0}]),m=this.props,l=m.indices,r=m.channels,x=this.bind.shader,v=this.props,w=v.sample,k=v.size,p=v.items,M=v.width,s=v.height,i=v.depth,g=w===this.node.attributes["resample.sample"]["enum"].relative,_=k===this.node.attributes["resample.size"]["enum"].relative,this.resampled={},null!=p&&(this.resampled.items=p),null!=M&&(this.resampled.width=M),null!=s&&(this.resampled.height=s),null!=i&&(this.resampled.depth=i),this.centered={},this.centered.items=this.props.centeredW,this.centered.width=this.props.centeredX,this.centered.height=this.props.centeredY,this.centered.depth=this.props.centeredZ,this.padding={},this.padding.items=this.props.paddingW,this.padding.width=this.props.paddingX,this.padding.height=this.props.paddingY,this.padding.depth=this.props.paddingZ,d=this._shaders.shader(),u=this._shaders.shader(),E=[null,this._types.number,this._types.vec2,this._types.vec3,this._types.vec4][l],S={dataSize:this._attributes.make(E(0,0,0,0)),dataResolution:this._attributes.make(E(0,0,0,0)),targetSize:this._attributes.make(E(0,0,0,0)),targetResolution:this._attributes.make(E(0,0,0,0)),resampleFactor:this._attributes.make(this._types.vec4(0,0,0,0)),resampleBias:this._attributes.make(this._types.vec4(0,0,0,0))},this.dataResolution=S.dataResolution,this.dataSize=S.dataSize,this.targetResolution=S.targetResolution,this.targetSize=S.targetSize,this.resampleFactor=S.resampleFactor,this.resampleBias=S.resampleBias,b=null!=p||null!=M||null!=s||null!=i,d.pipe("resample.padding",S),z=[],t=!1,y=["width","height","depth","items"],a=h=0,f=y.length;f>h;a=++h)c=y[a],n=this.centered[c],t||(t=n),z[a]=n?"0.5":"0.0";return t&&(z="vec4("+z+")",d.pipe(o.GLSL.binaryOperator(4,"+",vec4)),b&&u.pipe(o.GLSL.binaryOperator(4,"+",vec4))),g&&(b?(d.pipe("resample.relative",S),u.pipe("resample.relative",S)):u.pipe(o.GLSL.identity("vec4"))),null!=x?(4!==l&&d.pipe(o.GLSL.truncateVec(4,l)),d.callback(),4!==l&&d.pipe(o.GLSL.extendVec(l,4)),t&&d.pipe(o.GLSL.binaryOperator(4,"-",z)),d.pipe(this.bind.source.sourceShader(this._shaders.shader())),4!==r&&d.pipe(o.GLSL.truncateVec(4,r)),d.join(),null!=this.bind.shader&&d.pipe(this.bind.shader.shaderBind(S)),4!==r&&d.pipe(o.GLSL.extendVec(r,4))):(t&&d.pipe(o.GLSL.binaryOperator(4,"-",z)),d.pipe(this.bind.source.sourceShader(this._shaders.shader()))),t&&b&&u.pipe(o.GLSL.binaryOperator(4,"-",z)),this.operator=d,this.indexer=u,this.indices=l,this.relativeSample=g,this.relativeSize=_}},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.operator=null},e.prototype.resize=function(){var t,n,r,i,o,s,a,u,l,p,h,c,f,d,m;if(null!=this.bind.source)return s=this.bind.source.getActiveDimensions(),m=this.getActiveDimensions(),t=function(t){return function(e){var n,r,i;return n=t.centered[e],r=t.padding[e],m[e]+=2*r,i=n?s[e]/Math.max(1,m[e]):Math.max(1,s[e]-1)/Math.max(1,m[e]-1),[i,r]}}(this),u=t("width"),d=u[0],o=u[1],l=t("height"),c=l[0],r=l[1],p=t("depth"),a=p[0],n=p[1],h=t("items"),f=h[0],i=h[1],1===this.indices?(this.dataResolution.value=1/s.width,this.targetResolution.value=1/m.width,this.dataSize.value=s.width,this.targetSize.value=m.width):(this.dataResolution.value.set(1/s.width,1/s.height,1/s.depth,1/s.items),this.targetResolution.value.set(1/m.width,1/m.height,1/m.depth,1/m.items),this.dataSize.value.set(s.width,s.height,s.depth,s.items),this.targetSize.value.set(m.width,m.height,m.depth,m.items)),this.resampleFactor.value.set(d,c,a,f),this.resampleBias.value.set(o,r,n,i),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.operator||e.resample||e.sampler||e.include?this.rebuild():void 0},e}(r),e.exports=i},{"../../../util":175,"./operator":78}],82:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./operator"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","slice"],e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype.sourceShader=function(t){return t.pipe("slice.position",this.uniforms),this.bind.source.sourceShader(t)},e.prototype._resolve=function(t,e){var n,r,i,o,s;return o=this.props[t],n=e[t],null==o?[0,n]:(i=function(t,e){return 0>t?e+t:t},s=i(Math.round(o.x),n),r=i(Math.round(o.y),n),r=Math.max(s,r),[s,r-s])},e.prototype._resample=function(t){return t.width=this._resolve("width",t)[1],t.height=this._resolve("height",t)[1],t.depth=this._resolve("depth",t)[1],t.items=this._resolve("items",t)[1],t},e.prototype.make=function(){return e.__super__.make.apply(this,arguments),null!=this.bind.source?this.uniforms={sliceOffset:this._attributes.make(this._types.vec4())}:void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.resize=function(){var t;if(null!=this.bind.source)return t=this.bind.source.getActiveDimensions(),this.uniforms.sliceOffset.value.set(this._resolve("width",t)[0],this._resolve("height",t)[0],this._resolve("depth",t)[0],this._resolve("items",t)[0]),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.operator?this.rebuild():e.slice?this.resize():void 0},e}(r),e.exports=i},{"../../../util":175,"./operator":78}],83:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./operator"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","split"],e.prototype.indexShader=function(t){return t.pipe(this.operator),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator),e.__super__.sourceShader.call(this,t)},e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype._resample=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m;for(p=this.order,e=this.axis,c=this.overlap,u=this.length,m=this.stride,s=["width","height","depth","items"],l=p.map(function(t){return s[t-1]}),i=p.indexOf(e),d=function(){var e,r,i;for(i=[],e=0,r=l.length;r>e;e++)n=l[e],i.push(t[n]);return i}(),f=Math.floor((d[i]-c)/m),d.splice(i,1,u,f),d=d.slice(0,4),h={},r=o=0,a=l.length;a>o;r=++o)n=l[r],h[n]=d[r];return h},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(i=this.props.order,t=this.props.axis,s=this.props.overlap,r=this.props.length,a=i.join(""),null==t&&(t=i[0]),n=a.indexOf(t),p=a[n]+(null!=(u=a[n+1])?u:0),l=a.replace(p[1],"").replace(p[0],"0")+"0",s=Math.min(r-1,s),h=r-s,f={splitStride:this._attributes.make(this._types.number(h))},c=this._shaders.shader(),c.require(o.GLSL.swizzleVec4(p,2)),c.require(o.GLSL.swizzleVec4(l,4)),c.require(o.GLSL.injectVec4(n)),c.pipe("split.position",f),c.pipe(o.GLSL.invertSwizzleVec4(i)),this.operator=c,this.order=i,this.axis=t,this.overlap=s,this.length=r,this.stride=h):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.change=function(t,e,n){return t["split.axis"]||t["split.order"]||e.operator?this.rebuild():void 0},e}(r),e.exports=i},{"../../../util":175,"./operator":78}],84:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./operator"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","bind","operator","source","index","spread"],e.prototype.sourceShader=function(t){return t.pipe(this.operator)},e.prototype.make=function(){var t,n;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(n={spreadMatrix:this._attributes.make(this._types.mat4()),spreadOffset:this._attributes.make(this._types.vec4())},this.spreadMatrix=n.spreadMatrix,this.spreadOffset=n.spreadOffset,t=this._shaders.shader(),t.require(this.bind.source.sourceShader(this._shaders.shader())),t.pipe("spread.position",n),this.operator=t):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)},e.prototype.resize=function(){return this.update(),e.__super__.resize.apply(this,arguments)},e.prototype.update=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_;for(r=this.bind.source.getFutureDimensions(),h=this.spreadMatrix.value,i=h.elements,f=["width","height","depth","items"],t=["alignWidth","alignHeight","alignDepth","alignItems"],y=this.props.unit,g=this.node.attributes["spread.unit"]["enum"],p=function(){switch(y){case g.relative:return function(t,e,n,o){return i[4*e+n]=o/Math.max(1,r[t]-1)};case g.absolute:return function(t,e,n,r){return i[4*e+n]=r}}}(),m=[],o=s=0,l=f.length;l>s;o=++s)u=f[o],v=this.props[u],e=this.props[t[o]],null!=v?(n=null!=(d=r[u])?d:1,c=-(n-1)*(.5-.5*e)):c=0,this.spreadOffset.value.setComponent(o,c),m.push(function(){var t,e,n;for(n=[],a=t=0;3>=t;a=++t)_=null!=(e=null!=v?v.getComponent(a):void 0)?e:0,n.push(i[4*o+a]=p(u,o,a,_));return n}());return m},e.prototype.change=function(t,e,n){return e.operator?this.rebuild():e.spread?this.update():void 0},e}(r),e.exports=i},{"./operator":78}],85:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./operator"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","subdivide"],e.prototype.indexShader=function(t){return t.pipe(this.indexer),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return t.pipe(this.operator)},e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())},e.prototype._resample=function(t){var e;return e=this.resampled,t.items--,t.width--,t.height--,t.depth--,null!=e.items&&(t.items*=e.items),null!=e.width&&(t.width*=e.width),null!=e.height&&(t.height*=e.height),null!=e.depth&&(t.depth*=e.depth),t.items++,t.width++,t.height++,t.depth++,t},e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_;if(e.__super__.make.apply(this,arguments),null!=this.bind.source){for(f=this.props,y=f.size,a=f.items,_=f.width,n=f.height,t=f.depth,h=f.lerp,this.resampled={},null!=a&&(this.resampled.items=a),null!=_&&(this.resampled.width=_),null!=n&&(this.resampled.height=n),null!=t&&(this.resampled.depth=t),c=this._shaders.shader(),s=this._shaders.shader(),g={resampleFactor:this._attributes.make(this._types.vec4(0,0,0,0)),subdivideBevel:this.node.attributes["subdivide.bevel"]},this.resampleFactor=g.resampleFactor,this.resampleBias=g.resampleBias,m=null!=a||null!=_||null!=n||null!=t,m?(c.pipe("resample.relative",g),s.pipe("resample.relative",g)):(c.pipe(o.GLSL.identity("vec4")),s.pipe(o.GLSL.identity("vec4"))),v=this.bind.source.sourceShader(this._shaders.shader()),h=h?".lerp":"",d=["width","height","depth","items"],r=u=0,p=d.length;p>u;r=++u)l=d[r],i="subdivide."+l+h,null!=this.props[l]&&(v=this._shaders.shader().require(v),v.pipe(i,g));return c.pipe(v),this.operator=c,this.indexer=s}},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.operator=null},e.prototype.resize=function(){var t,n,r,i,o,s,a;if(null!=this.bind.source)return n=this.bind.source.getActiveDimensions(),a=this.getActiveDimensions(),t=function(t){return Math.max(1,n[t]-1)/Math.max(1,a[t]-1)},s=t("width"),i=t("height"),r=t("depth"),o=t("items"),this.resampleFactor.value.set(s,i,r,o),e.__super__.resize.apply(this,arguments)},e.prototype.change=function(t,e,n){return e.operator||e.subdivide?this.rebuild():void 0},e}(r),e.exports=i},{"../../../util":175,"./operator":78}],86:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./operator"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","source","index","swizzle"],e.prototype.sourceShader=function(t){return t=e.__super__.sourceShader.call(this,t),this.swizzler&&t.pipe(this.swizzler),t},e.prototype.make=function(){var t;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(t=this.props.order,"1234"!==t.join()?this.swizzler=o.GLSL.swizzleVec4(t,4):void 0):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.swizzler=null},e.prototype.change=function(t,e,n){return e.swizzle||e.operator?this.rebuild():void 0},e}(r),e.exports=i},{"../../../util":175,"./operator":78}],87:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;r=t("./operator"),o=t("../../../util"),s={1:"width",2:"height",3:"depth",4:"items"},i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return a(e,t),e.traits=["node","bind","operator","source","index","transpose"],e.prototype.indexShader=function(t){return this.swizzler&&t.pipe(this.swizzler),e.__super__.indexShader.call(this,t)},e.prototype.sourceShader=function(t){return this.swizzler&&t.pipe(this.swizzler),e.__super__.sourceShader.call(this,t)},e.prototype.getDimensions=function(){return this._remap(this.transpose,this.bind.source.getDimensions())},e.prototype.getActiveDimensions=function(){return this._remap(this.transpose,this.bind.source.getActiveDimensions())},e.prototype.getFutureDimensions=function(){return this._remap(this.transpose,this.bind.source.getFutureDimensions())},e.prototype.getIndexDimensions=function(){return this._remap(this.transpose,this.bind.source.getIndexDimensions())},e.prototype._remap=function(t,e){var n,r,i,o,a,u;for(o={},r=i=0;3>=i;r=++i)n=s[r+1],u=s[t[r]],o[n]=null!=(a=e[u])?a:1;return o},e.prototype.make=function(){var t;return e.__super__.make.apply(this,arguments),null!=this.bind.source?(t=this.props.order,"1234"!==t.join()&&(this.swizzler=o.GLSL.invertSwizzleVec4(t)),this.transpose=t,this.trigger({type:"source.rebuild"})):void 0},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.swizzler=null},e.prototype.change=function(t,e,n){return e.transpose||e.operator?this.rebuild():void 0},e}(r),e.exports=i},{"../../../util":175,"./operator":78}],88:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","object","visible","overlay","dom","attach","position"],e.prototype.init=function(){return this.emitter=this.root=null,this.active={}},e.prototype.make=function(){var t,n,r,i,o,s,a,u,l;return e.__super__.make.apply(this,arguments),this._helpers.bind.make([{to:"dom.html",trait:"html"},{to:"dom.points",trait:"source"}]),null!=this.bind.points&&null!=this.bind.html?(this.root=this._inherit("root"),this._listen("root","root.update",this.update),this._listen("root","root.post",this.post),s=this.bind.points.getDimensions(),r=this.bind.html.getDimensions(),o=Math.min(s.items,r.items),l=Math.min(s.width,r.width),n=Math.min(s.height,r.height),t=Math.min(s.depth,r.depth),a=this.bind.points.sourceShader(this._shaders.shader()),a=this._helpers.position.pipeline(a),u=this._shaders.shader({globals:["projectionMatrix"]}),u.pipe("project.readback"),a.pipe(u),i=this._shaders.shader(),this.readback=this._renderables.make("readback",{map:a,indexer:i,items:o,width:l,height:n,depth:t,channels:4,stpq:!0}),this.dom=this._overlays.make("dom"),this.dom.hint(o*l*n*t*2),this.readback.setCallback(this.emitter=this.callback(this.bind.html.nodes())),this._helpers.visible.make()):void 0},e.prototype.unmake=function(){return null!=this.readback&&(this.readback.dispose(),this.dom.dispose(),this.readback=this.dom=null,this.root=null,this.emitter=null,this.active={}),this._helpers.bind.unmake(),this._helpers.visible.unmake()},e.prototype.update=function(){var t;if(null!=this.readback)return this.props.visible?(this.readback.update(null!=(t=this.root)?t.getCamera():void 0),this.readback.post(),this.readback.iterate()):void 0},e.prototype.post=function(){return null!=this.readback?this.dom.render(this.isVisible?this.emitter.nodes():[]):void 0},e.prototype.callback=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k;return b=this._inherit("unit").getUnitUniforms(),w=b.viewWidth,u=b.viewHeight,e=this.node.attributes["dom.attributes"],d=this.node.attributes["dom.size"],k=this.node.attributes["dom.zoom"],r=this.node.attributes["dom.color"],c=this.node.attributes["dom.outline"],f=this.node.attributes["dom.pointerEvents"],h=this.node.attributes["overlay.opacity"],x=this.node.attributes["overlay.zIndex"],p=this.node.attributes["attach.offset"],o=this.node.attributes["attach.depth"],m=this.node.attributes["attach.snap"],s=this.dom.el,l=[],_=null,n=null,v=y=g=0,i="",a=function(r,i,a,c,f,d,b,x){var E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U;O=x+v*f+y*d+g*b,z=t[O],M=0>c,A=1/c,T=1+(A-1)*o.value,
L=M?0:T,P=+p.value.x*L,R=+p.value.y*L,N=(r+1)*w.value*.5+P,U=(i-1)*u.value*.5+R,N/=k.value,U/=k.value,m.value&&(N=Math.round(N),U=Math.round(U)),S=Math.min(.999,M?0:h.value),C={className:n,style:{transform:"translate3d("+N+"px, "+-U+"px, "+(1-c)+"px) translate(-50%, -50%) scale("+L+","+L+")",opacity:S}};for(b in _)j=_[b],C.style[b]=j;if(E=e.value,null!=E){D=E.style;for(b in E)j=E[b],"style"!==b&&"className"!==b&&(C[b]=j);if(null!=D)for(b in D)j=D[b],C.style[b]=j}return C.className+=" "+(null!=(I=null!=E?E.className:void 0)?I:"mathbox-label"),l.push(s("div",C,z))},a.reset=function(t){return function(){var e,o,s;return l=[],s=[t.strideI,t.strideJ,t.strideK],v=s[0],y=s[1],g=s[2],e=r.value,o=function(t){return Math.floor(255*t)},i=e?"rgb("+[o(e.x),o(e.y),o(e.z)]+")":"",n="mathbox-outline-"+Math.round(c.value),_={},e&&(_.color=i),_.fontSize=d.value+"px",1!==k.value&&(_.zoom=k.value),x.value>0&&(_.zIndex=x.value),f.value?_.pointerEvents="auto":void 0}}(this),a.nodes=function(){return l},a},e.prototype.resize=function(){var t,e,n,r,i,o,s,a,u;if(null!=this.readback)return i=this.bind.points.getActiveDimensions(),n=this.bind.html.getActiveDimensions(),r=Math.min(i.items,n.items),u=Math.min(i.width,n.width),e=Math.min(i.height,n.height),t=Math.min(i.depth,n.depth),this.readback.setActive(r,u,e,t),this.strideI=o=n.items,this.strideJ=s=o*n.width,this.strideK=a=s*n.height},e.prototype.change=function(t,e,n){return t["dom.html"]||t["dom.points"]?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],89:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("../data/voxel"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","buffer","active","data","voxel","html"],e.finals={channels:1},e.prototype.init=function(){return e.__super__.init.apply(this,arguments),this.storage="pushBuffer"},e.prototype.make=function(){var t,n,r,i,o;return e.__super__.make.apply(this,arguments),i=this.getDimensions(),r=i.items,o=i.width,n=i.height,t=i.depth,this.dom=this._overlays.make("dom"),this.dom.hint(r*o*n*t)},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),null!=this.dom?(this.dom.dispose(),this.dom=null):void 0},e.prototype.update=function(){return e.__super__.update.apply(this,arguments)},e.prototype.change=function(t,n,r){return n.html?this.rebuild():e.__super__.change.call(this,t,n,r)},e.prototype.nodes=function(){return this.buffer.read()},e.prototype.callback=function(t){var e;return e=this.dom.el,t.length<=6?function(n,r,i,o,s){return t(n,e,r,i,o,s)}:function(n){return function(r,i,o,s,a){return t(r,e,i,o,s,a,n.bufferClock,n.bufferStep)}}(this)},e}(o),e.exports=r},{"../../../util":175,"../data/voxel":61}],90:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./transition"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","transition","vertex","move","visible","active"],e.prototype.make=function(){var t,n,r;e.__super__.make.apply(this,arguments),n={moveFrom:this.node.attributes["move.from"],moveTo:this.node.attributes["move.to"]};for(t in n)r=n[t],this.uniforms[t]=r},e.prototype.vertex=function(t,e){var n,r;return e===this.props.pass&&t.pipe("move.position",this.uniforms),null!=(n=null!=(r=this._inherit("vertex"))?r.vertex(t,e):void 0)?n:t},e}(i),e.exports=r},{"./transition":97}],91:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./track"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","track","trigger","play","bind"],e.prototype.init=function(){return e.__super__.init.apply(this,arguments),this.skew=null,this.start=null},e.prototype.reset=function(t){return null==t&&(t=!0),this.skew=t?0:null,this.start=null},e.prototype.make=function(){var t;return e.__super__.make.apply(this,arguments),this._listen("slide","slide.step",function(t){return function(e){var n;return n=t.props.trigger,null!=n&&e.index===n?t.reset():null!=n&&0===e.index?t.reset(!1):void 0}}(this)),this.props.trigger&&null!=this._inherit("slide")||this.reset(),t=this._inherit("clock"),this._listen(t,"clock.tick",function(e){return function(){var n,r,i,o,s,a,u,l,p,h,c,f;return p=e.props,i=p.from,f=p.to,h=p.speed,a=p.pace,n=p.delay,l=p.realtime,c=t.getTime(),null!=e.skew?(o=l?c.time:c.clock,r=l?c.delta:c.step,u=h/a,null==e.start&&(e.start=o),e.skew+=r*(u-1),s=Math.max(0,o-e.start+e.skew-n*u),e.props.loop&&(s%=f-i),e.playhead=Math.min(f,i+s)):e.playhead=0,e.update()}}(this))},e.prototype.update=function(){return e.__super__.update.apply(this,arguments)},e.prototype.change=function(t,n,r){return t["trigger.trigger"]||t["play.realtime"]?this.rebuild():e.__super__.change.call(this,t,n,r)},e}(i),e.exports=r},{"./track":96}],92:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../base/parent"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","present"],e.prototype.init=function(){},e.prototype.make=function(){return this.nodes=[],this.steps=[],this.length=0,this.last=[],this.index=0,this.dirty=[],this._listen("root","root.update",this.update),this._compute("present.length",function(t){return function(){return t.length}}(this))},e.prototype.adopt=function(t){var e;return e=t.node,this.nodes.indexOf(t)<0&&this.nodes.push(e),this.dirty.push(t)},e.prototype.unadopt=function(t){var e;return e=t.node,this.nodes=this.nodes.filter(function(e){return e!==t}),this.dirty.push(t)},e.prototype.update=function(){var t,e,n,r,i;if(this.dirty.length){for(r=this.dirty,e=0,n=r.length;n>e;e++)t=r[e],this.slideReset(t);return i=this.process(this.nodes),this.steps=i[0],this.indices=i[1],this.length=this.steps.length,this.index=null,this.go(this.props.index),this.dirty=[]}},e.prototype.slideLatch=function(t,e,n){return t.slideLatch(e,n)},e.prototype.slideStep=function(t,e,n){return t.slideStep(this.mapIndex(t,e),n)},e.prototype.slideRelease=function(t,e){return t.slideRelease()},e.prototype.slideReset=function(t){return t.slideReset()},e.prototype.mapIndex=function(t,e){return e-this.indices[t.node._id]},e.prototype.process=function(t){var e,n,r,i,o,s,a,u,l,p,h,c;return l=function(t){var e,n,r,i;for(i=[],n=0,r=t.length;r>n;n++)e=t[n],i.push(a(e).filter(o));return i},c=function(t){return function(e){var n,r,i;for(i=[];e&&(r=[t(e),e],e=r[0],n=r[1],r);)i.push(n);return i}},a=c(function(t){return t.parent.traits.hash.present?null:t.parent}),o=function(e){return t.indexOf(e)>=0},i=function(t,e){var n,r,i,o,s,a;if(n=t.length,r=e.length,i=n-r,0!==i)return!1;for(i=Math.min(n,r),o=s=a=i-1;0>=a?0>s:s>0;o=0>=a?++s:--s)if(t[o]!==e[o])return!1;return!0},s=function(t){return t.sort(function(t,e){var n,r,i,o,s,a,u,l,p,h;for(n=t.length,r=e.length,i=Math.min(n,r),a=u=1,h=i;h>=1?h>=u:u>=h;a=h>=1?++u:--u){if(l=t[n-a],p=e[r-a],o=l.props.order,s=p.props.order,null!=o||null!=s){if(null!=o&&null!=s&&0!==(i=o-s))return i;if(null!=o)return-1;if(null!=s)return 1}if(p.order!==l.order)return p.order-l.order}return i=n-r,0!==i?i:0})},p=function(t){var e,n,r,i,o,s;for(o=[],e=[],n=0,r=t.length;r>n;n++)s=t[n],(null!=(i=s[0]).props.steps?o:e).push(s);return[o,e]},n=function(t){var n,i,o,s,a,u,l,p,h,c,f,d;for(h=t[0],n=t[1],p=100,o={},d=[],c=function(t,e){var n,r,i,s,a,u,l,h,c,f,m,v;for(c=(u=t[0]).props,l=t[1],h=null!=l?o[l._id]:0,n=e,r=null!=c.from?h+c.from:n-c.early,v=null!=c.to?h+c.to:n+c.steps+c.late,r=Math.max(0,r),v=Math.min(p,v),null==o[a=u._id]&&(o[a]=r),i=s=f=r,m=v;m>=f?m>s:s>m;i=m>=f?++s:--s)d[i]=(null!=d[i]?d[i]:d[i]=[]).concat(t);return c.steps},i=0,s=0,u=h.length;u>s;s++)f=h[s],i+=c(f,i);for(a=0,l=n.length;l>a;a++)f=n[a],c(f,0);return d=function(){var t,n,i;for(i=[],t=0,n=d.length;n>t;t++)f=d[t],i.push(r(e(f)));return i}(),[d,o]},e=function(t){var e,n,r,i,o;if(t){for(o=[],e=n=0,r=t.length;r>n;e=++n)i=t[e],t.indexOf(i)===e&&o.push(i);return o}return[]},r=function(t){return t.sort(function(t,e){return t.order-e.order})},u=l(t),h=s(u),n(p(h))},e.prototype.go=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D;for(t=Math.max(0,Math.min(this.length+1,+t||0)),l=this.last,e=null!=(z=this.steps[t-1])?z:[],I=this.props.directed?t-this.index:1,this.index=t,i=function(){var t,n,r;for(r=[],t=0,n=e.length;n>t;t++)w=e[t],this.last.indexOf(w)<0&&r.push(w);return r}.call(this),o=function(){var t,n,r,i;for(r=this.last,i=[],t=0,n=r.length;n>t;t++)w=r[t],e.indexOf(w)<0&&i.push(w);return i}.call(this),C=function(){var t,n,r;for(r=[],t=0,n=e.length;n>t;t++)w=e[t],i.indexOf(w)<0&&o.indexOf(w)<0&&r.push(w);return r}(),n=function(t){return t.sort(function(t,e){return t.order-e.order})},r=function(t){return t.sort(function(t,e){return e.order-t.order})},D=function(t){return t.toString()},M=n(i),s=0,p=M.length;p>s;s++)w=M[s],this.slideLatch(w.controller,!0,I);for(T=n(C),a=0,h=T.length;h>a;a++)w=T[a],this.slideLatch(w.controller,null,I);for(O=n(o),u=0,c=O.length;c>u;u++)w=O[u],this.slideLatch(w.controller,!1,I);for(_=0,f=i.length;f>_;_++)w=i[_],this.slideStep(w.controller,t,I);for(b=0,d=C.length;d>b;b++)w=C[b],this.slideStep(w.controller,t,I);for(x=0,m=o.length;m>x;x++)w=o[x],this.slideStep(w.controller,t,I);for(A=r(i),k=0,v=A.length;v>k;k++)w=A[k],this.slideRelease(w.controller);for(P=r(C),E=0,y=P.length;y>E;E++)w=P[E],this.slideRelease(w.controller);for(R=r(o),S=0,g=R.length;g>S;S++)w=R[S],this.slideRelease(w.controller);this.last=e},e.prototype.change=function(t,e,n){return t["present.index"]||n?this.go(this.props.index):void 0},e}(r),e.exports=i},{"../../../util":175,"../base/parent":47}],93:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./transition"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","transition","mask","visible","active"],e.prototype.mask=function(t){var e,n,r;return t?(r=this._shaders.shader(),r.pipe(o.GLSL.identity("vec4")),r.fan(),r.pipe(t,this.uniforms),r.next(),r.pipe("reveal.mask",this.uniforms),r.end(),r.pipe("float combine(float a, float b) { return min(a, b); }")):(r=this._shaders.shader(),r.pipe("reveal.mask",this.uniforms)),null!=(e=null!=(n=this._inherit("mask"))?n.mask(r):void 0)?e:r},e}(i),e.exports=r},{"../../../util":175,"./transition":97}],94:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("../base/parent"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","slide","visible","active"],e.prototype.make=function(){if(this._helpers.visible.make(),this._helpers.active.make(),!this._inherit("present"))throw new Error(this.node.toString()+" must be placed inside <present></present>");return this._inherit("present").adopt(this)},e.prototype.unmake=function(){return this._helpers.visible.unmake(),this._helpers.active.unmake(),this._inherit("present")(unadopt(this))},e.prototype.change=function(t,e,n){return t["slide.early"]||t["slide.late"]||t["slide.steps"]||t["slide.from"]||t["slide.to"]?this.rebuild():void 0},e.prototype.slideLatch=function(t,e){return this.trigger({type:"transition.latch",step:e}),null!=t?this._instant(t):void 0},e.prototype.slideStep=function(t,e){return this.trigger({type:"slide.step",index:t,step:e})},e.prototype.slideRelease=function(){return this.trigger({type:"transition.release"})},e.prototype.slideReset=function(){return this._instant(!1),this.trigger({type:"slide.reset"})},e.prototype._instant=function(t){return this.setVisible(t),this.setActive(t)},e}(r),e.exports=i},{"../base/parent":47}],95:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./track"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","track","step","trigger","bind"],e.prototype.make=function(){var t,n,r;return e.__super__.make.apply(this,arguments),t=this._inherit("clock"),null==this.actualIndex&&(this.actualIndex=null),this.animateIndex=this._animator.make(this._types.number(0),{clock:t,realtime:this.props.realtime,step:function(t){return function(e){return t.actualIndex=e}}(this)}),null==this.lastIndex&&(this.lastIndex=null),this.animateStep=this._animator.make(this._types.number(0),{clock:t,realtime:this.props.realtime,step:function(t){return function(e){return t.playhead=e,t.update()}}(this)}),this.stops=null!=(n=this.props.stops)?n:function(){r=[];for(var t=0,e=this.script.length;e>=0?e>t:t>e;e>=0?t++:t--)r.push(t);return r}.apply(this),this._listen("slide","slide.reset",function(t){return function(e){return t.lastIndex=null}}(this)),this._listen("slide","slide.step",function(t){return function(e){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k;if(f=t.props,n=f.delay,r=f.duration,h=f.pace,_=f.speed,c=f.playback,v=f.rewind,y=f.skip,k=f.trigger,a=Math.max(0,Math.min(t.stops.length-1,e.index-k)),s=t.playhead,x=t.stops[a],null==t.lastIndex&&k)return t.lastIndex=a,t.animateStep.set(x),void t.animateIndex.set(a);for(l=null!=(d=null!=(m=t.actualIndex)?m:t.lastIndex)?d:0,b=a-l,g=t.stops.slice(Math.min(l,a),Math.max(l,a)),o=0,l=g.shift(),u=0,p=g.length;p>u;u++)w=g[u],l===w&&o++,l=w;return t.lastIndex=a,i=_*(e.step>=0?1:v),i*=y?Math.max(1,Math.abs(b)-o):1,r+=Math.abs(x-s)*h/i,s!==x?(t.animateIndex.immediate(a,{delay:n,duration:r,ease:c}),t.animateStep.immediate(x,{delay:n,duration:r,ease:c})):void 0}}(this))},e.prototype.made=function(){return this.update()},e.prototype.unmake=function(){return this.animateIndex.dispose(),this.animateStep.dispose(),this.animateIndex=this.animateStep=null,e.__super__.unmake.apply(this,arguments)},e.prototype.change=function(t,n,r){return t["step.stops"]||t["step.realtime"]?this.rebuild():e.__super__.change.call(this,t,n,r)},e}(i),e.exports=r},{"./track":96}],96:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;i=t("../../primitive"),r=t("../../../util").Ease,s=function(t){var e,n,r;n={};for(e in t)r=t[e],r instanceof Array?n[e]=r.slice():null!=r&&"object"==typeof r?n[e]=s(r):n[e]=r;return n},o=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return a(e,t),e.traits=["node","track","seek","bind"],e.prototype.init=function(){return this.handlers={},this.script=null,this.values=null,this.playhead=0,this.velocity=null,this.section=null,this.expr=null},e.prototype.make=function(){var t,e,n;return this._helpers.bind.make([{to:"track.target",trait:"node",callback:null}]),n=this.props.script,t=this.bind.target.node,this.targetNode=t,e=this._process(t,n),this.script=e[0],this.values=e[1],this.start=e[2],this.end=e[3],e},e.prototype.unmake=function(){return this.unbindExpr(),this._helpers.bind.unmake(),this.script=this.values=this.start=this.end=this.section=this.expr=null,this.playhead=0},e.prototype.bindExpr=function(t){var e;return this.unbindExpr(),this.expr=t,this.targetNode.bind(t,!0),e=this.targetNode.clock,this._attributes.bind(this.measure=function(){var t;return t=null,function(n){return function(){var r;return r=e.getTime().step,null!=t&&(n.velocity=(n.playhead-t)/r),t=n.playhead}}(this)}())},e.prototype.unbindExpr=function(){return null!=this.expr&&this.targetNode.unbind(this.expr,!0),null!=this.measure&&this._attributes.unbind(this.measure),this.expr=this.measure=null},e.prototype._process=function(t,e){var n,r,i,o,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x;if(e instanceof Array){for(g={},r=i=0,p=e.length;p>i;r=++i)b=e[r],g[r]=b;e=g}g=[];for(a in e)b=e[a],null==b&&(b=[]),b instanceof Array?b={key:+a,props:null!=b[0]?s(b[0]):{},expr:null!=b[1]?s(b[1]):{}}:(b=null!=b.key||b.props||b.expr?s(b):{props:s(b)},b.key=null!=b.key?+b.key:+a,null==b.props&&(b.props={}),null==b.expr&&(b.expr={})),g.push(b);if(e=g,!e.length)return[[],{},0,0];e.sort(function(t,e){return t.key-e.key}),_=e[0].key,n=e[e.length-1].key;for(a in e)b=e[a],"undefined"!=typeof l&&null!==l&&(l.next=b),l=b;l.next=l,e=g,f={},x={};for(a in e){b=e[a],d=b.props;for(o in d)w=d[o],f[o]=!0}for(a in e){b=e[a],m=b.expr;for(o in m)w=m[o],f[o]=!0}for(o in f)f[o]=t.get(o);try{for(o in f)x[o]=[t.attribute(o).T.make(),t.attribute(o).T.make(),t.attribute(o).T.make()]}catch(k){throw console.warn(this.node.toMarkup()),c=this.node.toString()+" - Target "+t+" has no `"+o+"` property",new Error(c)}for(y=[],u=0,h=e.length;h>u;u++){b=e[u];for(o in f)if(w=f[o],w=t.validate(o,null!=(v=b.props[o])?v:w),f[o]=b.props[o]=w,null!=b.expr[o]&&"function"!=typeof b.expr[o])throw console.warn(this.node.toMarkup()),c=this.node.toString()+" - Expression `"+b.expr[o]+"` on property `"+o+"` is not a function",new Error(c);y.push(b)}return[y,x,_,n]},e.prototype.update=function(){var t,e,n,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_;if(f=this.playhead,m=this.script,d=this.props,e=d.ease,y=d.seek,c=this.targetNode,null!=y&&(f=y),m.length){if(s=function(){var t,e,n,r,i;for(n=m[0],t=e=0,r=m.length;r>e&&(i=m[t],!(i.key>f));t=++e)n=i;return n},v=this.section,(!v||f<v.key||f>v.next.key)&&(v=s(m,f)),v===this.section)return;this.section=v,a=v,_=v.next,g=a.key,i=_.key,n=function(){switch(e){case"linear":case 0:return r.clamp;case"cosine":case 1:return r.cosine;case"binary":case 2:return r.binary;case"hold":case 3:return r.hold;default:return r.cosine}}(),t=c.clock,l=function(e){return function(n){var r;return null==e.velocity?e.playhead:(r=t.getTime(),e.playhead+e.velocity*(n-r.time))}}(this),u=function(){var t;return t=1/Math.max(1e-4,i-g),function(e){return n((l(e)-g)*t,0,1)}}(),h=function(t){return function(e){var n,r,i,o,s,l,p,h;return i=a.expr[e],l=_.expr[e],o=a.props[e],p=_.props[e],s=function(){throw console.warn(c.toMarkup()),new Error(this.node.toString()+" - Invalid expression result on track `"+e+"`")},r=c.attribute(e),h=t.values[e],n=t._animator,i&&l?function(t,e,o){return function(e,o){var a,p;return t[0]=a=r.T.validate(i(e,o),t[0],s),t[1]=p=r.T.validate(l(e,o),t[1],s),t[2]=n.lerp(r.T,a,p,u(e),t[2])}}(h,a,_):i?function(t,e,o){return function(e,o){var a;return t[0]=a=r.T.validate(i(e,o),t[0],s),t[1]=n.lerp(r.T,a,p,u(e),t[1])}}(h,a,_):l?function(t,e,i){return function(e,i){var a;return t[0]=a=r.T.validate(l(e,i),t[0],s),t[1]=n.lerp(r.T,o,a,u(e),t[1])}}(h,a,_):function(t,e,i){return function(e,i){return t[0]=n.lerp(r.T,o,p,u(e),t[0])}}(h,a,_)}}(this),o={};for(p in a.expr)null==o[p]&&(o[p]=h(p));for(p in _.expr)null==o[p]&&(o[p]=h(p));for(p in a.props)null==o[p]&&(o[p]=h(p));for(p in _.props)null==o[p]&&(o[p]=h(p));return this.bindExpr(o)}},e.prototype.change=function(t,e,n){return t["track.target"]||t["track.script"]||t["track.mode"]?this.rebuild():t["seek.seek"]||n?this.update():void 0},e}(i),e.exports=o},{"../../../util":175,"../../primitive":44}],97:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../base/parent"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","transition","transform","mask","visible","active"],e.prototype.init=function(){return this.animate=null,this.uniforms=null,this.state={isVisible:!0,isActive:!0,enter:1,exit:1},this.latched=null,this.locked=null},e.prototype.make=function(){var t,e,n;return this.uniforms={transitionFrom:this._attributes.make(this._types.vec4()),transitionTo:this._attributes.make(this._types.vec4()),transitionActive:this._attributes.make(this._types.bool()),transitionScale:this._attributes.make(this._types.vec4()),transitionBias:this._attributes.make(this._types.vec4()),transitionEnter:this._attributes.make(this._types.number()),transitionExit:this._attributes.make(this._types.number()),transitionSkew:this._attributes.make(this._types.number())},e=this._inherit("slide"),n=this._inherit("visible"),t=this._inherit("active"),this._listen(e,"transition.latch",function(t){return function(e){return t.latch(e.step)}}(this)),this._listen(e,"transition.release",function(t){return function(){return t.release()}}(this)),this._listen(n,"visible.change",function(t){return function(){return t.update(t.state.isVisible=n.isVisible)}}(this)),this._listen(t,"active.change",function(e){return function(){return e.update(e.state.isActive=t.isActive)}}(this)),this.animate=this._animator.make(this._types.vec2(1,1),{step:function(t){return function(e){return t.state.enter=e.x,t.state.exit=e.y,t.update()}}(this),complete:function(t){return function(e){return t.complete(e)}}(this)}),this.move=null!=this.props.from||null!=this.props.to},e.prototype.unmake=function(){return this.animate.dispose()},e.prototype.latch=function(t){var e,n,r,i,o,s;return this.locked=null,this.latched=i={isVisible:this.state.isVisible,isActive:this.state.isActive,step:t},s=this.isVisible,s?void 0:(r=i.step>=0,o=r?[0,1]:[1,0],e=o[0],n=o[1],this.animate.set(e,n))},e.prototype.release=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d;return l=this.latched,f=this.state,this.latched=null,l.isVisible!==f.isVisible&&(u=l.step>=0,d=f.isVisible,p=d?[1,1]:u?[1,0]:[0,1],s=p[0],a=p[1],h=this.props,r=h.duration,i=h.durationEnter,o=h.durationExit,null==i&&(i=r),null==o&&(o=r),r=d*i+!d*o,c=this.props,t=c.delay,e=c.delayEnter,n=c.delayExit,null==e&&(e=t),null==n&&(n=t),t=d*e+!d*n,this.animate.immediate({x:s,y:a},{duration:r,delay:t,ease:"linear"}),this.locked={isVisible:!0,isActive:l.isActive||f.isActive}),this.update()},e.prototype.complete=function(t){return t?(this.locked=null,this.update()):void 0},e.prototype.update=function(){var t,e,n,r,i,o,s,a;if(null==this.latched)return o=this.props,e=o.enter,n=o.exit,null==e&&(e=this.state.enter),null==n&&(n=this.state.exit),r=e*n,a=r>0,i=1>r,this.uniforms.transitionEnter.value=e,this.uniforms.transitionExit.value=n,this.uniforms.transitionActive.value=i,a&&(a=!!this.state.isVisible),null!=this.locked&&(a=this.locked.isVisible),this.isVisible!==a&&(this.isVisible=a,this.trigger({type:"visible.change"})),t=!!(this.state.isActive||(null!=(s=this.locked)?s.isActive:void 0)),this.isActive!==t?(this.isActive=t,this.trigger({type:"active.change"})):void 0},e.prototype.change=function(t,e,n){var r,i,o,s,a,u,l,p,h;return(t["transition.enter"]||t["transition.exit"]||n)&&this.update(),t["transition.stagger"]||n?(a=this.props.stagger,i=a.x<0,o=a.y<0,s=a.z<0,r=a.w<0,l=Math.abs(a.x),p=Math.abs(a.y),h=Math.abs(a.z),u=Math.abs(a.w),this.uniforms.transitionSkew.value=l+p+h+u,this.uniforms.transitionScale.value.set((1-2*i)*l,(1-2*o)*p,(1-2*s)*h,(1-2*r)*u),this.uniforms.transitionBias.value.set(i*l,o*p,s*h,r*u)):void 0},e}(r),e.exports=i},{"../../../util":175,"../base/parent":47}],98:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","object","visible","operator","style","compose"],e.defaults={zWrite:!1,zTest:!1,color:"#ffffff"},e.prototype.init=function(){return this.compose=null},e.prototype.resize=function(){var t,e,n,r,i;if(this.compose&&this.bind.source)return e=this.bind.source.getActiveDimensions(),i=e.width,n=e.height,t=e.depth,r=e.items,this.remapUVScale.set(i,n)},e.prototype.make=function(){var t,e,n,r;return this._helpers.bind.make([{to:"operator.source",trait:"source"}]),null!=this.bind.source?(r={remapUVScale:this._attributes.make(this._types.vec2())},this.remapUVScale=r.remapUVScale.value,n=this._shaders.shader(),t=this.props.alpha,this.bind.source.is("image")?(n.pipe("screen.pass.uv",r),n=this.bind.source.imageShader(n)):(n.pipe("screen.map.xy",r),n=this.bind.source.sourceShader(n)),t||n.pipe("color.opaque"),e=this._helpers.style.uniforms(),this.compose=this._renderables.make("screen",{map:n,uniforms:e,linear:!0}),this._helpers.visible.make(),this._helpers.object.make([this.compose])):void 0},e.prototype.made=function(){return this.resize()},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake()},e.prototype.change=function(t,e,n){return t["operator.source"]||t["compose.alpha"]?this.rebuild():void 0},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],99:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../base/parent"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","root","scene","vertex","texture","rtt","source","index","image"],e.defaults={minFilter:"linear",magFilter:"linear",type:"unsignedByte"},e.prototype.init=function(){return this.rtt=this.scene=this.camera=this.width=this.height=this.history=this.rootSize=this.size=null},e.prototype.indexShader=function(t){return t},e.prototype.imageShader=function(t){return this.rtt.shaderRelative(t)},e.prototype.sourceShader=function(t){return this.rtt.shaderAbsolute(t,this.history)},e.prototype.getDimensions=function(){return{items:1,width:this.width,height:this.height,depth:this.history}},e.prototype.getActiveDimensions=function(){return this.getDimensions()},e.prototype.make=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d;return this.parentRoot=this._inherit("root"),this.rootSize=this.parentRoot.getSize(),this._listen(this.parentRoot,"root.pre",this.pre),this._listen(this.parentRoot,"root.update",this.update),this._listen(this.parentRoot,"root.render",this.render),this._listen(this.parentRoot,"root.post",this.post),this._listen(this.parentRoot,"root.camera",this.setCamera),this._listen(this.parentRoot,"root.resize",function(t){return this.resize(t.size)}),null!=this.rootSize?(s=this.props,o=s.minFilter,i=s.magFilter,p=s.type,a=this.props,f=a.width,e=a.height,r=a.history,l=a.size,u=l===this.node.attributes["rtt.size"]["enum"].relative,d=u?this.rootSize.renderWidth:1,n=u?this.rootSize.renderHeight:1,this.width=Math.round(null!=f?f*d:this.rootSize.renderWidth),this.height=Math.round(null!=e?e*n:this.rootSize.renderHeight),this.history=r,this.aspect=t=this.width/this.height,null==this.scene&&(this.scene=this._renderables.make("scene")),this.rtt=this._renderables.make("renderToTexture",{scene:this.scene,camera:this._context.defaultCamera,width:this.width,height:this.height,frames:this.history,minFilter:o,magFilter:i,type:p}),t=f||e?t:this.rootSize.aspect,c=null!=f?f:this.rootSize.viewWidth,h=null!=e?e:this.rootSize.viewHeight,this.size={renderWidth:this.width,renderHeight:this.height,aspect:t,viewWidth:c,viewHeight:h,pixelRatio:this.height/h}):void 0},e.prototype.made=function(){return this.trigger({type:"source.rebuild"}),this.size?this.trigger({type:"root.resize",size:this.size}):void 0},e.prototype.unmake=function(t){return null!=this.rtt?(this.rtt.dispose(),t||this.scene.dispose(),this.rtt=this.width=this.height=this.history=null):void 0},e.prototype.change=function(t,e,n){return e.texture||t["rtt.width"]||t["rtt.height"]?this.rebuild():t["root.camera"]||n?(this._unattach(),this._attach(this.props.camera,"camera",this.setCamera,this,this,!0),this.setCamera()):void 0},e.prototype.adopt=function(t){var e,n,r,i,o;for(i=t.renders,o=[],e=0,n=i.length;n>e;e++)r=i[e],o.push(this.scene.add(r));return o},e.prototype.unadopt=function(t){var e,n,r,i,o;for(i=t.renders,o=[],e=0,n=i.length;n>e;e++)r=i[e],o.push(this.scene.remove(r));return o},e.prototype.resize=function(t){var e,n,r,i;return this.rootSize=t,n=this.props,i=n.width,e=n.height,t=n.size,r=t===this.node.attributes["rtt.size"]["enum"].relative,!this.rtt||null==i||null==e||r?this.rebuild():void 0},e.prototype.select=function(t){return this._root.node.model.select(t,[this.node])},e.prototype.watch=function(t,e){return this._root.node.model.watch(t,e)},e.prototype.unwatch=function(t){return this._root.node.model.unwatch(t)},e.prototype.pre=function(t){return this.trigger(t)},e.prototype.update=function(t){var e;return null!=(e=this.getOwnCamera())&&(e.aspect=this.aspect||1,e.updateProjectionMatrix()),this.trigger(t)},e.prototype.render=function(t){var e;return this.trigger(t),null!=(e=this.rtt)?e.render(this.getCamera()):void 0},e.prototype.post=function(t){return this.trigger(t)},e.prototype.setCamera=function(){var t,e;return t=null!=(e=this.select(this.props.camera)[0])?e.controller:void 0,this.camera!==t?(this.camera=t,this.rtt.camera=this.getCamera(),this.trigger({type:"root.camera"})):this.camera?void 0:this.trigger({type:"root.camera"})},e.prototype.getOwnCamera=function(){var t;return null!=(t=this.camera)?t.getCamera():void 0},e.prototype.getCamera=function(){var t;return null!=(t=this.getOwnCamera())?t:this._inherit("root").getCamera()},e.prototype.vertex=function(t,e){return 2===e?t.pipe("view.position"):3===e?t.pipe("root.position"):t},e}(r),e.exports=i},{"../../../util":175,"../base/parent":47}],100:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../../primitive"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","shader"],e.freeform=!0,e.prototype.init=function(){return this.shader=null},e.prototype.make=function(){var t,e,n,r,i,o,s,a,u,l,p,h;if(s=this.props,r=s.language,t=s.code,"glsl"!==r)throw new Error("GLSL required");for(this._helpers.bind.make([{to:"shader.sources",trait:"source",multiple:!0}]),u=this._shaders.fetch(t),p=this._types,h={},o=function(t){return function(t){var e;switch(t){case"i":return p["int"]();case"f":return p.number();case"v2":return p.vec2();case"v3":return p.vec3();case"v4":return p.vec4();case"m3":return p.mat3();case"m4":return p.mat4();case"t":return p.object();default:return e=t.split(""),"v"===e.pop()?p.array(o(e.join(""))):null}}}(this),a=u._signatures.uniform,n=0,i=a.length;i>n;n++)e=a[n],(l=o(e.type))&&(h[e.name]=l);return this.reconfigure({props:{uniform:h}})},e.prototype.made=function(){return this.trigger({type:"source.rebuild"})},e.prototype.unmake=function(){return this.shader=null},e.prototype.change=function(t,e,n){return t["shader.uniforms"]||t["shader.code"]||t["shader.language"]?this.rebuild():void 0},e.prototype.shaderBind=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f;null==t&&(t={}),a=this.props,i=a.language,e=a.code,u=this.node.attributes;for(r in u)f=u[r],null!=f.type&&null!=f["short"]&&"uniform"===f.ns&&null==t[s=f["short"]]&&(t[s]=f);if(null!=(c=this.props.uniforms))for(r in c)f=c[r],t[r]=f;if(p=this._shaders.shader(),null!=this.bind.sources)for(l=this.bind.sources,n=0,
o=l.length;o>n;n++)h=l[n],p.require(h.sourceShader(this._shaders.shader()));return p.pipe(e,t)},e}(r),e.exports=i},{"../../../util":175,"../../primitive":44}],101:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../operator/operator"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","texture","text","format","font"],e.defaults={minFilter:"linear",magFilter:"linear"},e.prototype.init=function(){return e.__super__.init.apply(this,arguments),this.atlas=this.buffer=this.used=this.time=null,this.filled=!1},e.prototype.sourceShader=function(t){return this.buffer.shader(t)},e.prototype.textShader=function(t){return this.atlas.shader(t)},e.prototype.textIsSDF=function(){return this.props.sdf>0},e.prototype.textHeight=function(){return this.props.detail},e.prototype.make=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y;return this._helpers.bind.make([{to:"operator.source",trait:"raw"}]),p=this.props,l=p.minFilter,u=p.magFilter,d=p.type,h=this.props,o=h.font,f=h.style,m=h.variant,v=h.weight,n=h.detail,c=h.sdf,this.atlas=this._renderables.make("textAtlas",{font:o,size:n,style:f,variant:m,weight:v,outline:c,minFilter:l,magFilter:u,type:d}),l=THREE.NearestFilter,u=THREE.NearestFilter,d=THREE.FloatType,r=this.bind.source.getDimensions(),a=r.items,y=r.width,s=r.height,e=r.depth,this.buffer=this._renderables.make("voxelBuffer",{width:y,height:s,depth:e,channels:4,items:a,minFilter:l,magFilter:u,type:d}),t=this.atlas,i=this.buffer.streamer.emit,this.buffer.streamer.emit=function(e){return t.map(e,i)},this.clockParent=this._inherit("clock"),this._listen("root","root.update",this.update)},e.prototype.made=function(){return e.__super__.made.apply(this,arguments),this.resize()},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.buffer&&(this.buffer.dispose(),this.buffer=null),this.atlas?(this.atlas.dispose(),this.atlas=null):void 0},e.prototype.update=function(){var t,e,n;return e=this.bind.source.rawBuffer(),t=this.buffer,this.filled&&!this.props.live||!this.through?void 0:(this.time=this.clockParent.getTime(),n=this.used,this.atlas.begin(),this.used=this.through(),this.buffer.write(this.used),this.atlas.end(),this.filled=!0,n!==this.used?this.trigger({type:"source.resize"}):void 0)},e.prototype.change=function(t,e,n){var r,i,o,s,a,u;return e.font?this.rebuild():t["format.expr"]||t["format.digits"]||t["format.data"]||n?(u=this.props,i=u.digits,o=u.expr,r=u.data,null==o&&(o=null!=r?function(t,e,n,i,o){return r[o]}:function(t){return t}),s=o.length,null!=i&&(o=function(t){return function(e,n,r,o,s,a,u,l,p,h){return+t(e,n,r,o,s,a,u,l,p,h).toPrecision(i)}}(o)),a=s>8?function(t){return function(e,n,r,i,s,a,u,l,p,h,c){return e(o(n,r,i,s,a,u,l,p,t.time.clock,t.time.step))}}(this):function(t){return function(t,e,n,r,i,s,a,u,l){return t(o(e,n,r,i,s,a,u,l))}}(this),this.through=this.bind.source.rawBuffer().through(a,this.buffer)):void 0},e}(i),e.exports=r},{"../../../util":175,"../operator/operator":78}],102:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../../primitive"),o=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","object","visible","style","label","attach","geometry","position"],e.prototype.make=function(){var t,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_;return e.__super__.make.apply(this,arguments),this._helpers.bind.make([{to:"label.text",trait:"text"},{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]),null!=this.bind.points&&null!=this.bind.text?(p=this.bind.points.getDimensions(),m=this.bind.text.getDimensions(),v=this.bind.text.textIsSDF(),s=Math.min(p.items,m.items),_=Math.min(p.width,m.width),i=Math.min(p.height,m.height),r=Math.min(p.depth,m.depth),h=this.bind.points.sourceShader(this._shaders.shader()),h=this._helpers.position.pipeline(h),f=this.bind.text.sourceShader(this._shaders.shader()),u=this._shaders.shader().pipe("label.map"),u.pipe(this.bind.text.textShader(this._shaders.shader())),a={spriteDepth:this.node.attributes["attach.depth"],spriteOffset:this.node.attributes["attach.offset"],spriteSnap:this.node.attributes["attach.snap"],spriteScale:this._attributes.make(this._types.number()),outlineStep:this._attributes.make(this._types.number()),outlineExpand:this._attributes.make(this._types.number()),outlineColor:this.node.attributes["label.background"]},this.spriteScale=a.spriteScale,this.outlineStep=a.outlineStep,this.outlineExpand=a.outlineExpand,c=v?"label.outline":"label.alpha",n=this._shaders.shader().pipe(c,a),this.bind.colors&&(t=this._shaders.shader(),this.bind.colors.sourceShader(t)),l=this._helpers.object.mask(),d=this._helpers.style.uniforms(),g=this._inherit("unit").getUnitUniforms(),y=o.JS.merge(g,d,a),this.sprite=this._renderables.make("sprite",{uniforms:y,width:_,height:i,depth:r,items:s,position:h,sprite:f,map:u,combine:n,color:t,mask:l,linear:!0}),this._helpers.visible.make(),this._helpers.object.make([this.sprite])):void 0},e.prototype.unmake=function(){return this._helpers.bind.unmake(),this._helpers.visible.unmake(),this._helpers.object.unmake(),this.sprite=null},e.prototype.resize=function(){var t,e,n,r,i,o;return r=this.bind.points.getActiveDimensions(),i=this.bind.text.getActiveDimensions(),n=Math.min(r.items,i.items),o=Math.min(r.width,i.width),e=Math.min(r.height,i.height),t=Math.min(r.depth,i.depth),this.sprite.geometry.clip(o,e,t,n)},e.prototype.change=function(t,e,n){var r,i,o,s,a;if(e.geometry||t["label.text"])return this.rebuild();if(null!=this.bind.points)return a=this.props.size,o=this.props.outline,r=this.props.expand,i=this.bind.text.textHeight(),s=a/i,this.outlineExpand.value=r/s*16/255,this.outlineStep.value=o/s*16/255,this.spriteScale.value=s},e}(i),e.exports=r},{"../../../util":175,"../../primitive":44}],103:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("../operator/resample"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","bind","operator","resample","sampler:x","sampler:y","sampler:z","sampler:w","include","text"],e.prototype.init=function(){return this.sourceSpec=[{to:"operator.source",trait:"text"}]},e.prototype.textShader=function(t){return this.bind.source.textShader(t)},e.prototype.textIsSDF=function(){var t;return(null!=(t=this.bind.source)?t.props.sdf:void 0)>0},e.prototype.textHeight=function(){var t;return null!=(t=this.bind.source)?t.props.detail:void 0},e}(r),e.exports=i},{"../../../util":175,"../operator/resample":81}],104:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;r=t("../data/buffer"),s=t("../data/voxel"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return a(e,t),e.traits=["node","buffer","active","data","texture","voxel","text","font"],e.defaults={minFilter:"linear",magFilter:"linear"},e.finals={channels:1},e.prototype.init=function(){return e.__super__.init.apply(this,arguments),this.atlas=null},e.prototype.textShader=function(t){return this.atlas.shader(t)},e.prototype.textIsSDF=function(){return this.props.sdf>0},e.prototype.textHeight=function(){return this.props.detail},e.prototype.make=function(){var t,e,n,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T;return d=this.props,f=d.minFilter,c=d.magFilter,S=d.type,m=this.props,l=m.font,E=m.style,z=m.variant,M=m.weight,s=m.detail,x=m.sdf,this.atlas=this._renderables.make("textAtlas",{font:l,size:s,style:E,variant:z,weight:M,outline:x,minFilter:f,magFilter:c,type:S}),this.minFilter=THREE.NearestFilter,this.magFilter=THREE.NearestFilter,this.type=THREE.FloatType,r.prototype.make.call(this),f=null!=(v=this.minFilter)?v:this.props.minFilter,c=null!=(y=this.magFilter)?y:this.props.magFilter,S=null!=(g=this.type)?g:this.props.type,T=this.props.width,p=this.props.height,i=this.props.depth,_=this.props.bufferWidth,b=this.props.bufferHeight,w=this.props.bufferDepth,e=this.props.channels,h=this.props.items,a=this.spec={channels:e,items:h,width:T,height:p,depth:i},this.items=a.items,this.channels=a.channels,n=this.props.data,a=o.Data.getDimensions(n,a),k=this.space,k.width=Math.max(_,a.width||1),k.height=Math.max(b,a.height||1),k.depth=Math.max(w,a.depth||1),this.buffer=this._renderables.make(this.storage,{width:k.width,height:k.height,depth:k.depth,channels:4,items:h,minFilter:f,magFilter:c,type:S}),t=this.atlas,u=this.buffer.streamer.emit,this.buffer.streamer.emit=function(e){return t.map(e,u)}},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),this.atlas?(this.atlas.dispose(),this.atlas=null):void 0},e.prototype.update=function(){return this.atlas.begin(),e.__super__.update.apply(this,arguments),this.atlas.end()},e.prototype.change=function(t,n,r){return n.font?this.rebuild():e.__super__.change.call(this,t,n,r)},e}(s),e.exports=i},{"../../../util":175,"../data/buffer":55,"../data/voxel":61}],105:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("../base/parent"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","clock","seek","play"],e.prototype.init=function(){return this.skew=0,this.last=0,this.time={now:+new Date/1e3,time:0,delta:0,clock:0,step:0}},e.prototype.make=function(){return this._listen("clock","clock.tick",this.tick)},e.prototype.reset=function(){return this.skew=0},e.prototype.tick=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f;return l=this.props,i=l.from,f=l.to,h=l.speed,p=l.seek,o=l.pace,n=l.delay,u=l.realtime,s=this._inherit("clock").getTime(),c=u?s.time:s.clock,r=u?s.delta:s.step,a=h/o,this.skew+=r*(a-1),this.last>c&&(this.skew=0),this.time.now=s.now+this.skew,this.time.time=s.time,this.time.delta=s.delta,e=null!=p?p:s.clock+this.skew,this.time.clock=Math.min(f,i+Math.max(0,e-n*a)),this.time.step=r*a,this.last=c,this.trigger(t)},e.prototype.getTime=function(){return this.time},e}(i),e.exports=r},{"../base/parent":47}],106:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("../base/parent"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","clock","now"],e.prototype.init=function(){var t;return this.now=t=+new Date/1e3,this.skew=0,this.time={now:t,time:0,delta:0,clock:0,step:0}},e.prototype.make=function(){return this.clockParent=this._inherit("clock"),this._listen("clock","clock.tick",this.tick)},e.prototype.unmake=function(){return this.clockParent=null},e.prototype.change=function(t,e,n){return t["date.now"]?this.skew=0:void 0},e.prototype.tick=function(t){var e,n,r,i,o,s,a;return i=this.props,e=i.now,s=i.seek,n=i.pace,a=i.speed,r=this.clockParent.getTime(),this.skew+=r.step*n/a,null!=s&&(this.skew=s),this.time.now=this.time.time=this.time.clock=(null!=(o=this.props.now)?o:this.now)+this.skew,this.time.delta=this.time.step=r.delta,this.trigger(t)},e.prototype.getTime=function(){return this.time},e}(i),e.exports=r},{"../base/parent":47}],107:[function(t,e,n){var r,i;i=t("./types"),r={node:{id:i.nullable(i.string()),classes:i.classes()},entity:{active:i.bool(!0)},object:{visible:i.bool(!0)},unit:{scale:i.nullable(i.number()),fov:i.nullable(i.number()),focus:i.nullable(i.number(1),!0)},span:{range:i.nullable(i.vec2(-1,1))},view:{range:i.array(i.vec2(-1,1),4)},view3:{position:i.vec3(),quaternion:i.quat(),rotation:i.vec3(),scale:i.vec3(1,1,1),eulerOrder:i.swizzle("xyz")},view4:{position:i.vec4(),scale:i.vec4(1,1,1,1)},layer:{depth:i.number(1),fit:i.fit("y")},vertex:{pass:i.vertexPass()},fragment:{pass:i.fragmentPass(),gamma:i.bool(!1)},transform3:{position:i.vec3(),quaternion:i.quat(),rotation:i.vec3(),eulerOrder:i.swizzle("xyz"),scale:i.vec3(1,1,1),matrix:i.mat4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},transform4:{position:i.vec4(),scale:i.vec4(1,1,1,1),matrix:i.mat4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},camera:{proxy:i.bool(!1),position:i.nullable(i.vec3()),quaternion:i.nullable(i.quat()),rotation:i.nullable(i.vec3()),lookAt:i.nullable(i.vec3()),up:i.nullable(i.vec3()),eulerOrder:i.swizzle("xyz"),fov:i.nullable(i.number(1))},polar:{bend:i.number(1),helix:i.number(0)},spherical:{bend:i.number(1)},stereographic:{bend:i.number(1)},interval:{axis:i.axis()},area:{axes:i.swizzle([1,2],2)},volume:{axes:i.swizzle([1,2,3],3)},origin:{origin:i.vec4()},scale:{divide:i.number(10),unit:i.number(1),base:i.number(10),mode:i.scale(),start:i.bool(!0),end:i.bool(!0),zero:i.bool(!0),factor:i.positive(i.number(1)),nice:i.bool(!0)},grid:{lineX:i.bool(!0),lineY:i.bool(!0),crossed:i.bool(!1),closedX:i.bool(!1),closedY:i.bool(!1)},axis:{detail:i["int"](1),crossed:i.bool(!1)},data:{data:i.nullable(i.data()),expr:i.nullable(i.emitter()),bind:i.nullable(i.func()),live:i.bool(!0)},buffer:{channels:i["enum"](4,[1,2,3,4]),items:i["int"](1),fps:i.nullable(i["int"](60)),hurry:i["int"](5),limit:i["int"](60),realtime:i.bool(!1),observe:i.bool(!1),aligned:i.bool(!1)},sampler:{centered:i.bool(!1),padding:i.number(0)},array:{width:i.nullable(i.positive(i["int"](1),!0)),bufferWidth:i["int"](1),history:i["int"](1)},matrix:{width:i.nullable(i.positive(i["int"](1),!0)),height:i.nullable(i.positive(i["int"](1),!0)),history:i["int"](1),bufferWidth:i["int"](1),bufferHeight:i["int"](1)},voxel:{width:i.nullable(i.positive(i["int"](1),!0)),height:i.nullable(i.positive(i["int"](1),!0)),depth:i.nullable(i.positive(i["int"](1),!0)),bufferWidth:i["int"](1),bufferHeight:i["int"](1),bufferDepth:i["int"](1)},resolve:{expr:i.nullable(i.func()),items:i["int"](1)},style:{opacity:i.positive(i.number(1)),color:i.color(),blending:i.blending(),zWrite:i.bool(!0),zTest:i.bool(!0),zIndex:i.positive(i.round()),zBias:i.number(0),zOrder:i.nullable(i["int"]())},geometry:{points:i.select(),colors:i.nullable(i.select())},point:{size:i.positive(i.number(4)),sizes:i.nullable(i.select()),shape:i.shape(),optical:i.bool(!0),fill:i.bool(!0),depth:i.number(1)},line:{width:i.positive(i.number(2)),depth:i.positive(i.number(1)),join:i.join(),stroke:i.stroke(),proximity:i.nullable(i.number(1/0)),closed:i.bool(!1)},mesh:{fill:i.bool(!0),shaded:i.bool(!1),map:i.nullable(i.select()),lineBias:i.number(5)},strip:{line:i.bool(!1)},face:{line:i.bool(!1)},arrow:{size:i.number(3),start:i.bool(!1),end:i.bool(!1)},ticks:{normal:i.vec3(0,0,1),size:i.positive(i.number(10)),epsilon:i.positive(i.number(.001))},attach:{offset:i.vec2(0,-20),snap:i.bool(!1),depth:i.number(0)},format:{digits:i.nullable(i.positive(i.number(3))),data:i.nullable(i.data()),expr:i.nullable(i.func()),live:i.bool(!0)},font:{font:i.font("sans-serif"),style:i.string(),variant:i.string(),weight:i.string(),detail:i.number(24),sdf:i.number(5)},label:{text:i.select(),size:i.number(16),outline:i.number(2),expand:i.number(0),background:i.color(1,1,1)},overlay:{opacity:i.number(1),zIndex:i.positive(i.round(0))},dom:{points:i.select(),html:i.select(),size:i.number(16),outline:i.number(2),zoom:i.number(1),color:i.nullable(i.color()),attributes:i.nullable(i.object()),pointerEvents:i.bool(!1)},texture:{minFilter:i.filter("nearest"),magFilter:i.filter("nearest"),type:i.type("float")},shader:{sources:i.nullable(i.select()),language:i.string("glsl"),code:i.string(),uniforms:i.nullable(i.object())},include:{shader:i.select()},operator:{source:i.select()},spread:{unit:i.mapping(),items:i.nullable(i.vec4()),width:i.nullable(i.vec4()),height:i.nullable(i.vec4()),depth:i.nullable(i.vec4()),alignItems:i.anchor(),alignWidth:i.anchor(),alignHeight:i.anchor(),alignDepth:i.anchor()},grow:{scale:i.number(1),items:i.nullable(i.anchor()),width:i.nullable(i.anchor()),height:i.nullable(i.anchor()),depth:i.nullable(i.anchor())},split:{order:i.transpose("wxyz"),axis:i.nullable(i.axis()),length:i["int"](1),overlap:i["int"](0)},join:{order:i.transpose("wxyz"),axis:i.nullable(i.axis()),overlap:i["int"](0)},swizzle:{order:i.swizzle()},transpose:{order:i.transpose()},repeat:{items:i.number(1),width:i.number(1),height:i.number(1),depth:i.number(1)},slice:{items:i.nullable(i.vec2()),width:i.nullable(i.vec2()),height:i.nullable(i.vec2()),depth:i.nullable(i.vec2())},lerp:{size:i.mapping("absolute"),items:i.nullable(i.number()),width:i.nullable(i.number()),height:i.nullable(i.number()),depth:i.nullable(i.number())},subdivide:{items:i.nullable(i.positive(i["int"](),!0)),width:i.nullable(i.positive(i["int"](),!0)),height:i.nullable(i.positive(i["int"](),!0)),depth:i.nullable(i.positive(i["int"](),!0)),bevel:i.number(1),lerp:i.bool(!0)},resample:{indices:i.number(4),channels:i.number(4),sample:i.mapping(),size:i.mapping("absolute"),items:i.nullable(i.number()),width:i.nullable(i.number()),height:i.nullable(i.number()),depth:i.nullable(i.number())},readback:{type:i.type("float"),expr:i.nullable(i.func()),data:i.data(),channels:i["enum"](4,[1,2,3,4]),items:i.nullable(i["int"]()),width:i.nullable(i["int"]()),height:i.nullable(i["int"]()),depth:i.nullable(i["int"]())},root:{speed:i.number(1),camera:i.select("[camera]")},inherit:{source:i.select(),traits:i.array(i.string())},rtt:{size:i.mapping("absolute"),width:i.nullable(i.number()),height:i.nullable(i.number()),history:i["int"](1)},compose:{alpha:i.bool(!1)},present:{index:i["int"](1),directed:i.bool(!0),length:i.number(0)},slide:{order:i.nullable(i["int"](0)),steps:i.number(1),early:i["int"](0),late:i["int"](0),from:i.nullable(i["int"](0)),to:i.nullable(i["int"](1))},transition:{stagger:i.vec4(),enter:i.nullable(i.number(1)),exit:i.nullable(i.number(1)),delay:i.number(0),delayEnter:i.nullable(i.number(0)),delayExit:i.nullable(i.number(0)),duration:i.number(.3),durationEnter:i.nullable(i.number(0)),durationExit:i.nullable(i.number(0))},move:{from:i.vec4(),to:i.vec4()},seek:{seek:i.nullable(i.number(0))},track:{target:i.select(),script:i.object({}),ease:i.ease("cosine")},trigger:{trigger:i.nullable(i["int"](1),!0)},step:{playback:i.ease("linear"),stops:i.nullable(i.array(i.number())),delay:i.number(0),duration:i.number(.3),pace:i.number(0),speed:i.number(1),rewind:i.number(2),skip:i.bool(!0),realtime:i.bool(!1)},play:{delay:i.number(0),pace:i.number(1),speed:i.number(1),from:i.number(0),to:i.number(1/0),realtime:i.bool(!1),loop:i.bool(!1)},now:{now:i.nullable(i.timestamp()),seek:i.nullable(i.number(0)),pace:i.number(1),speed:i.number(1)}},e.exports=r},{"./types":115}],108:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./transform"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","include","fragment","bind"],e.prototype.make=function(){return this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:!0}])},e.prototype.unmake=function(){return this._helpers.bind.unmake()},e.prototype.change=function(t,e,n){return e.include||t["fragment.gamma"]?this.rebuild():void 0},e.prototype.fragment=function(t,n){return null!=this.bind.shader&&n===this.props.pass&&(this.props.gamma&&t.pipe("mesh.gamma.out"),t.pipe(this.bind.shader.shaderBind()),t.split(),this.props.gamma&&t.pipe("mesh.gamma.in"),t.pass()),e.__super__.fragment.call(this,t,n)},e}(i),e.exports=r},{"./transform":111}],109:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./transform"),o=Math.PI,r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","vertex","layer"],e.prototype.make=function(){return this._listen("root","root.resize",this.update),this.uniforms={layerScale:this._attributes.make(this._types.vec4()),layerBias:this._attributes.make(this._types.vec4())}},e.prototype.update=function(){var t,e,n,r,i,s,a,u,l,p,h,c;switch(n=this._inherit("root").getCamera(),c=this._inherit("root").getSize(),e=null!=(u=n.aspect)?u:1,s=null!=(l=n.fov)?l:1,a=Math.tan(s*o/360),t=this.node.attributes["layer.fit"]["enum"],p=this.props,i=p.fit,r=p.depth,h=p.scale,i){case t.contain:i=e>1?t.y:t.x;break;case t.cover:i=e>1?t.x:t.y}switch(i){case t.x:this.uniforms.layerScale.value.set(a*e,a*e);break;case t.y:this.uniforms.layerScale.value.set(a,a)}return this.uniforms.layerBias.value.set(0,0,-r,0)},e.prototype.change=function(t,e,n){return t["layer.fit"]||t["layer.depth"]||n?this.update():void 0},e.prototype.vertex=function(t,e){return 2===e?t.pipe("layer.position",this.uniforms):3===e?t.pipe("root.position"):t},e}(i),e.exports=r},{"./transform":111}],110:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("../base/parent"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","include","mask","bind"],e.prototype.make=function(){return this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:!0}])},e.prototype.unmake=function(){return this._helpers.bind.unmake()},e.prototype.change=function(t,e,n){return e.include?this.rebuild():void 0},e.prototype.mask=function(t){var e,n,r;return null!=this.bind.shader?t?(r=this._shaders.shader(),r.pipe(Util.GLSL.identity("vec4")),r.fan(),r.pipe(t),r.next(),r.pipe(this.bind.shader.shaderBind()),r.end(),r.pipe("float combine(float a, float b) { return min(a, b); }")):(r=this._shaders.shader(),r.pipe(this.bind.shader.shaderBind())):r=t,null!=(e=null!=(n=this._inherit("mask"))?n.mask(r):void 0)?e:r},e}(i),e.exports=r},{"../base/parent":47}],111:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("../base/parent"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","vertex","fragment"],e.prototype.vertex=function(t,e){var n,r;return null!=(n=null!=(r=this._inherit("vertex"))?r.vertex(t,e):void 0)?n:t},e.prototype.fragment=function(t,e){var n,r;return null!=(n=null!=(r=this._inherit("fragment"))?r.fragment(t,e):void 0)?n:t},e}(r),e.exports=i},{"../base/parent":47}],112:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./transform"),o=t("../../../util"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","vertex","transform3"],e.prototype.make=function(){return this.uniforms={transformMatrix:this._attributes.make(this._types.mat4())},this.composer=o.Three.transformComposer()},e.prototype.unmake=function(){return delete this.uniforms},e.prototype.change=function(t,e,n){var r,i,o,s,a,u;if(t["transform3.pass"])return this.rebuild();if(e.transform3||n)return o=this.props.position,s=this.props.quaternion,a=this.props.rotation,u=this.props.scale,i=this.props.matrix,r=this.props.eulerOrder,this.uniforms.transformMatrix.value=this.composer(o,a,s,u,i,r)},e.prototype.vertex=function(t,n){return n===this.props.pass&&t.pipe("transform3.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e}(r),e.exports=i},{"../../../util":175,"./transform":111}],113:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./transform"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","vertex","transform4"],e.prototype.make=function(){return this.uniforms={transformMatrix:this._attributes.make(this._types.mat4()),transformOffset:this.node.attributes["transform4.position"]},this.transformMatrix=this.uniforms.transformMatrix.value},e.prototype.unmake=function(){return delete this.uniforms},e.prototype.change=function(t,e,n){var r,i,o;if(t["transform4.pass"])return this.rebuild();if(e.transform4||n)return i=this.props.scale,r=this.props.matrix,o=this.transformMatrix,o.copy(r),o.scale(i)},e.prototype.vertex=function(t,n){return n===this.props.pass&&t.pipe("transform4.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e}(r),e.exports=i},{"./transform":111}],114:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./transform"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","include","vertex","bind"],e.prototype.make=function(){return this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:!0}])},e.prototype.unmake=function(){return this._helpers.bind.unmake()},e.prototype.change=function(t,e,n){return e.include?this.rebuild():void 0},e.prototype.vertex=function(t,n){return null!=this.bind.shader&&n===this.props.pass&&t.pipe(this.bind.shader.shaderBind()),e.__super__.vertex.call(this,t,n)},e}(r),e.exports=i},{"./transform":111}],115:[function(t,e,n){var r,i,o,s=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};i=t("../../util"),r={array:function(t,e,n){var r,i;return null==n&&(n=null),r=t.lerp?function(e,n,r,i){var o,s,a,u;for(a=Math.min(e.length,n.length),o=s=0,u=a;u>=0?u>s:s>u;o=u>=0?++s:--s)r[o]=t.lerp(e[o],n[o],r[o],i);return r}:void 0,i=t.op?function(e,n,r,i){var o,s,a,u;for(a=Math.min(e.length,n.length),o=s=0,u=a;u>=0?u>s:s>u;o=u>=0?++s:--s)r[o]=t.op(e[o],n[o],r[o],i);return r}:void 0,null==n||n instanceof Array||(n=[n]),{uniform:function(){return t.uniform?t.uniform()+"v":void 0},make:function(){var r,i,o,s;if(null!=n)return n.slice();if(!e)return[];for(s=[],r=i=0,o=e;o>=0?o>i:i>o;r=o>=0?++i:--i)s.push(t.make());return s},validate:function(n,r,i){var o,s,a,u,l,p;for(n instanceof Array||(n=[n]),u=r.length=e?e:n.length,o=a=0,l=u;l>=0?l>a:a>l;o=l>=0?++a:--a)s=null!=(p=n[o])?p:t.make(),r[o]=t.validate(s,r[o],i);return r},equals:function(e,n){var r,i,o,s,a,u;if(r=e.length,i=n.length,r!==i)return!1;for(a=Math.min(r,i),o=s=0,u=a;u>=0?u>s:s>u;o=u>=0?++s:--s)if(!("function"==typeof t.equals?t.equals(e[o],n[o]):void 0))return!1;return!0},lerp:r,op:i,clone:function(e){var n,r,i,o;for(i=[],n=0,r=e.length;r>n;n++)o=e[n],i.push(t.clone(o));return i}}},letters:function(t,e,n){var i,o,s,a,u;if(null==n&&(n=null),null!=n)for(n===""+n&&(n=n.split("")),o=s=0,a=n.length;a>s;o=++s)u=n[o],n[o]=t.validate(u,u);return i=r.array(t,e,n),{uniform:function(){return i.uniform()},make:function(){return i.make()},validate:function(t,e,n){return t===""+t&&(t=t.split("")),i.validate(t,e,n)},equals:function(t,e){return i.equals(t,e)},clone:i.clone}},nullable:function(t,e){var n,r,i,o;return null==e&&(e=!1),o=e?t.make():null,n=t.emitter?function(e,n){return null==n?e:null==e?n:t.emitter(e,n)}:void 0,r=t.lerp?function(e,n,r,i){return null===e||null===n?.5>i?e:n:(null==r&&(r=t.make()),o=t.lerp(e,n,r,i),r)}:void 0,i=t.op?function(e,n,r,i){return null===e||null===n?null:(null==r&&(r=t.make()),o=t.op(e,n,r,i))}:void 0,{make:function(){return o},validate:function(e,n,r){return null===e?e:(null===n&&(n=t.make()),t.validate(e,n,r))},uniform:function(){return"function"==typeof t.uniform?t.uniform():void 0},equals:function(e,n){var r,i,o;return r=null===e,i=null===n,r&&i?!0:r^i?!1:null!=(o="function"==typeof t.equals?t.equals(e,n):void 0)?o:e===n},lerp:r,op:i,emitter:n}},"enum":function(t,e,n){var r,i,o,s,a,u,l;for(null==e&&(e=[]),null==n&&(n={}),r=0,l={},i=0,s=e.length;s>i;i++)o=e[i],o!==+o&&null==n[o]&&(n[o]=r++);for(u=0,a=e.length;a>u;u++)o=e[u],o===+o&&(l[o]=o);for(o in n)r=n[o],l[r]=!0;return null==l[t]&&(t=n[t]),{"enum":function(){return n},make:function(){return t},validate:function(t,e,r){var i;return i=l[t]?t:n[t],null!=i?i:r()}}},enumber:function(t,e,n){var i;return null==n&&(n={}),i=r["enum"](t,e,n),{"enum":i["enum"],uniform:function(){return"f"},make:function(){var e;return null!=(e=i.make())?e:+t},validate:function(t,e,n){return t===+t?t:i.validate(t,e,n)},op:function(t,e,n,r){return r(t,e)}}},select:function(t){return null==t&&(t="<"),{make:function(){return t},validate:function(t,e,n){return"string"==typeof t?t:"object"==typeof t?t:n()}}},bool:function(t){return t=!!t,{uniform:function(){return"f"},make:function(){return t},validate:function(t,e,n){return!!t}}},"int":function(t){return null==t&&(t=0),t=+Math.round(t),{uniform:function(){return"i"},make:function(){return t},validate:function(t,e,n){var r;return t!==(r=+t)?n():Math.round(r)||0},op:function(t,e,n,r){return r(t,e)}}},round:function(t){return null==t&&(t=0),t=+Math.round(t),{uniform:function(){return"f"},make:function(){return t},validate:function(t,e,n){var r;return t!==(r=+t)?n():Math.round(r)||0},op:function(t,e,n,r){return r(t,e)}}},number:function(t){return null==t&&(t=0),{uniform:function(){return"f"},make:function(){return+t},validate:function(t,e,n){var r;return t!==(r=+t)?n():r||0},op:function(t,e,n,r){return r(t,e)}}},positive:function(t,e){return null==e&&(e=!1),{uniform:t.uniform,make:t.make,validate:function(n,r,i){return n=t.validate(n,r,i),0>n||e&&0>=n?i():n},op:function(t,e,n,r){return r(t,e)}}},string:function(t){return null==t&&(t=""),{make:function(){return""+t},validate:function(t,e,n){var r;return t!==(r=""+t)?n():r}}},func:function(){return{make:function(){return function(){}},validate:function(t,e,n){return"function"==typeof t?t:n()}}},emitter:function(){return{make:function(){return function(t){return t(1,1,1,1)}},validate:function(t,e,n){return"function"==typeof t?t:n()},emitter:function(t,e){return i.Data.getLerpEmitter(t,e)}}},object:function(t){return{make:function(){return null!=t?t:{}},validate:function(t,e,n){return"object"==typeof t?t:n()},clone:function(t){return JSON.parse(JSON.stringify(t))}}},timestamp:function(t){return null==t&&(t=null),"string"==typeof t&&(t=Date.parse(t)),{uniform:function(){return"f"},make:function(){return null!=t?t:+new Date},validate:function(t,e,n){var r;return t=Date.parse(t),t!==(r=+t)?n():t},op:function(t,e,n,r){return r(t,e)}}},vec2:function(t,e){var n;return null==t&&(t=0),null==e&&(e=0),n=[t,e],{uniform:function(){return"v2"},make:function(){return new THREE.Vector2(t,e)},validate:function(r,i,o){var s,a,u,l;if(r===+r&&(r=[r]),r instanceof THREE.Vector2)i.copy(r);else if(r instanceof Array)r=r.concat(n.slice(r.length)),i.set.apply(i,r);else{if(null==r)return o();u=null!=(s=r.x)?s:t,l=null!=(a=r.y)?a:e,i.set(u,l)}return i},equals:function(t,e){return t.x===e.x&&t.y===e.y},op:function(t,e,n,r){return n.x=r(t.x,e.x),n.y=r(t.y,e.y),n}}},ivec2:function(t,e){var n,i;return null==t&&(t=0),null==e&&(e=0),i=r.vec2(t,e),n=i.validate,i.validate=function(t,e,r){return n(t,e,r),e.x=Math.round(e.x),e.y=Math.round(e.y),e},i},vec3:function(t,e,n){var r;return null==t&&(t=0),
null==e&&(e=0),null==n&&(n=0),r=[t,e,n],{uniform:function(){return"v3"},make:function(){return new THREE.Vector3(t,e,n)},validate:function(i,o,s){var a,u,l,p,h,c;if(i===+i&&(i=[i]),i instanceof THREE.Vector3)o.copy(i);else if(i instanceof Array)i=i.concat(r.slice(i.length)),o.set.apply(o,i);else{if(null==i)return s();p=null!=(a=i.x)?a:t,h=null!=(u=i.y)?u:e,c=null!=(l=i.z)?l:n,o.set(p,h,c)}return o},equals:function(t,e){return t.x===e.x&&t.y===e.y&&t.z===e.z},op:function(t,e,n,r){return n.x=r(t.x,e.x),n.y=r(t.y,e.y),n.z=r(t.z,e.z),n}}},ivec3:function(t,e,n){var i,o;return null==t&&(t=0),null==e&&(e=0),null==n&&(n=0),o=r.vec3(t,e,n),i=o.validate,o.validate=function(t,e){return i(t,e,invalid),e.x=Math.round(e.x),e.y=Math.round(e.y),e.z=Math.round(e.z),e},o},vec4:function(t,e,n,r){var i;return null==t&&(t=0),null==e&&(e=0),null==n&&(n=0),null==r&&(r=0),i=[t,e,n,r],{uniform:function(){return"v4"},make:function(){return new THREE.Vector4(t,e,n,r)},validate:function(o,s,a){var u,l,p,h,c,f,d,m;if(o===+o&&(o=[o]),o instanceof THREE.Vector4)s.copy(o);else if(o instanceof Array)o=o.concat(i.slice(o.length)),s.set.apply(s,o);else{if(null==o)return a();f=null!=(u=o.x)?u:t,d=null!=(l=o.y)?l:e,m=null!=(p=o.z)?p:n,c=null!=(h=o.w)?h:r,s.set(f,d,m,c)}return s},equals:function(t,e){return t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},op:function(t,e,n,r){return n.x=r(t.x,e.x),n.y=r(t.y,e.y),n.z=r(t.z,e.z),n.w=r(t.w,e.w),n}}},ivec4:function(t,e,n,i){var o,s;return null==t&&(t=0),null==e&&(e=0),null==n&&(n=0),null==i&&(i=0),s=r.vec4(t,e,n,i),o=s.validate,s.validate=function(t,e){return o(t,e,invalid),e.x=Math.round(e.x),e.y=Math.round(e.y),e.z=Math.round(e.z),e.w=Math.round(e.w),e},s},mat3:function(t,e,n,r,i,o,s,a,u){var l;return null==t&&(t=1),null==e&&(e=0),null==n&&(n=0),null==r&&(r=0),null==i&&(i=1),null==o&&(o=0),null==s&&(s=0),null==a&&(a=0),null==u&&(u=1),l=[t,e,n,r,i,o,s,a,u],{uniform:function(){return"m4"},make:function(){var l;return l=new THREE.Matrix3,l.set(t,e,n,r,i,o,s,a,u),l},validate:function(t,e,n){if(t instanceof THREE.Matrix3)e.copy(t);else{if(!(t instanceof Array))return n();t=t.concat(l.slice(t.length)),e.set.apply(e,t)}return e}}},mat4:function(t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m){var v;return null==t&&(t=1),null==e&&(e=0),null==n&&(n=0),null==r&&(r=0),null==i&&(i=0),null==o&&(o=1),null==s&&(s=0),null==a&&(a=0),null==u&&(u=0),null==l&&(l=0),null==p&&(p=1),null==h&&(h=0),null==c&&(c=0),null==f&&(f=0),null==d&&(d=0),null==m&&(m=1),v=[t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m],{uniform:function(){return"m4"},make:function(){var v;return v=new THREE.Matrix4,v.set(t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m),v},validate:function(t,e,n){if(t instanceof THREE.Matrix4)e.copy(t);else{if(!(t instanceof Array))return n();t=t.concat(v.slice(t.length)),e.set.apply(e,t)}return e}}},quat:function(t,e,n,i){var o;return null==t&&(t=0),null==e&&(e=0),null==n&&(n=0),null==i&&(i=1),o=r.vec4(t,e,n,i),{uniform:function(){return"v4"},make:function(){return new THREE.Quaternion},validate:function(t,e,n){return t instanceof THREE.Quaternion?e.copy(t):e=o.validate(t,e,n),e.normalize(),e},equals:function(t,e){return t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},op:function(t,e,n,r){return n.x=r(t.x,e.x),n.y=r(t.y,e.y),n.z=r(t.z,e.z),n.w=r(t.w,e.w),n.normalize(),n},lerp:function(t,e,n,r){return THREE.Quaternion.slerp(t,e,n,r),n}}},color:function(t,e,n){var r;return null==t&&(t=.5),null==e&&(e=.5),null==n&&(n=.5),r=[t,e,n],{uniform:function(){return"c"},make:function(){return new THREE.Color(t,e,n)},validate:function(i,o,s){var a,u,l,p,h,c;if(i===""+i?i=(new THREE.Color).setStyle(i):i===+i&&(i=new THREE.Color(i)),i instanceof THREE.Color)o.copy(i);else if(i instanceof Array)i=i.concat(r.slice(i.length)),o.setRGB.apply(o,i);else{if(null==i)return s();c=null!=(l=i.r)?l:t,u=null!=(p=i.g)?p:e,a=null!=(h=i.b)?h:n,o.set(c,u,a)}return o},equals:function(t,e){return t.r===e.r&&t.g===e.g&&t.b===e.b},op:function(t,e,n,r){return n.r=r(t.r,e.r),n.g=r(t.g,e.g),n.b=r(t.b,e.b),n}}},axis:function(t,e){var n,r,i;return null==t&&(t=1),null==e&&(e=!1),n={x:1,y:2,z:3,w:4,W:1,H:2,D:3,I:4,zero:0,"null":0,width:1,height:2,depth:3,items:4},r=e?[0,1,2,3,4]:[1,2,3,4],null!=(i=n[t])&&(t=i),{make:function(){return t},validate:function(t,e,o){var a;return null!=(i=n[t])&&(t=i),t=null!=(a=Math.round(t))?a:0,s.call(r,t)>=0?t:o()}}},transpose:function(t){var e,n;return null==t&&(t=[1,2,3,4]),n=r.letters(r.axis(null,!1),0,t),e=r.letters(r.axis(null,!1),4,t),{make:function(){return e.make()},validate:function(t,r,i){var o,s,a,u,l;return u=[1,2,3,4],n.validate(t,u,i),u.length<4&&(a=[1,2,3,4].filter(function(t){return-1===u.indexOf(t)}),u=u.concat(a)),l=function(){var t,e,n;for(n=[],o=t=0,e=u.length;e>t;o=++t)s=u[o],n.push(u.indexOf(s)===o);return n}(),l.indexOf(!1)<0?e.validate(u,r,i):i()},equals:e.equals,clone:e.clone}},swizzle:function(t,e){var n,i;return null==t&&(t=[1,2,3,4]),null==e&&(e=null),null==e&&(e=t.length),t=t.slice(0,e),i=r.letters(r.axis(null,!1),0,t),n=r.letters(r.axis(null,!0),e,t),{make:function(){return n.make()},validate:function(r,o,s){var a;return a=t.slice(),i.validate(r,a,s),a.length<e&&(a=a.concat([0,0,0,0]).slice(0,e)),n.validate(a,o,s)},equals:n.equals,clone:n.clone}},classes:function(){var t;return t=r.array(r.string()),{make:function(){return t.make()},validate:function(e,n,r){return e===""+e&&(e=e.split(" ")),e=e.filter(function(t){return!!t.length}),t.validate(e,n,r)},equals:t.equals,clone:t.clone}},blending:function(t){var e;return null==t&&(t="normal"),e=["no","normal","add","subtract","multiply","custom"],r["enum"](t,e)},filter:function(t){var e;return null==t&&(t="nearest"),e={nearest:THREE.NearestFilter,nearestMipMapNearest:THREE.NearestMipMapNearestFilter,nearestMipMapLinear:THREE.NearestMipMapLinearFilter,linear:THREE.LinearFilter,linearMipMapNearest:THREE.LinearMipMapNearestFilter,linearMipmapLinear:THREE.LinearMipMapLinearFilter},r["enum"](t,[],e)},type:function(t){var e;return null==t&&(t="unsignedByte"),e={unsignedByte:THREE.UnsignedByteType,"byte":THREE.ByteType,"short":THREE.ShortType,unsignedShort:THREE.UnsignedShortType,"int":THREE.IntType,unsignedInt:THREE.UnsignedIntType,"float":THREE.FloatType},r["enum"](t,[],e)},scale:function(t){var e;return null==t&&(t="linear"),e=["linear","log"],r["enum"](t,e)},mapping:function(t){var e;return null==t&&(t="relative"),e=["relative","absolute"],r["enum"](t,e)},indexing:function(t){var e;return null==t&&(t="original"),e=["original","final"],r["enum"](t,e)},shape:function(t){var e;return null==t&&(t="circle"),e=["circle","square","diamond","up","down","left","right"],r["enum"](t,e)},join:function(t){var e;return null==t&&(t="miter"),e=["miter","round","bevel"],r["enum"](t,e)},stroke:function(t){var e;return null==t&&(t="solid"),e=["solid","dotted","dashed"],r["enum"](t,e)},vertexPass:function(t){var e;return null==t&&(t="view"),e=["data","view","world","eye"],r["enum"](t,e)},fragmentPass:function(t){var e;return null==t&&(t="light"),e=["color","light","rgba"],r["enum"](t,e)},ease:function(t){var e;return null==t&&(t="linear"),e=["linear","cosine","binary","hold"],r["enum"](t,e)},fit:function(t){var e;return null==t&&(t="contain"),e=["x","y","contain","cover"],r["enum"](t,e)},anchor:function(t){var e;return null==t&&(t="middle"),e={first:1,middle:0,last:-1},r.enumber(t,[],e)},transitionState:function(t){var e;return null==t&&(t="enter"),e={enter:-1,visible:0,exit:1},r.enumber(t,[],e)},font:function(t){var e,n;return null==t&&(t="sans-serif"),e=i.JS.parseQuoted,t instanceof Array||(t=e(t)),n=r.array(r.string(),0,t),{make:function(){return n.make()},validate:function(t,r,i){try{t instanceof Array||(t=e(t))}catch(o){return i()}return t=t.filter(function(t){return!!t.length}),n.validate(t,r,i)},equals:n.equals,clone:n.clone}},data:function(t){return null==t&&(t=[]),{make:function(){return[]},validate:function(t,e,n){return t instanceof Array?t:null!=(null!=t?t.length:void 0)?t:n()},emitter:function(t,e){return i.Data.getLerpThunk(t,e)}}}},o=function(t){var e,n;for(e in t)n=t[e],t[e]=function(t){return function(){var e;return e=t.apply(t,arguments),null==e.validate&&(e.validate=function(t){return null!=t}),null==e.equals&&(e.equals=function(t,e){return t===e}),null==e.clone&&(e.clone=function(t){var e;return null!=(e=null!=t&&"function"==typeof t.clone?t.clone():void 0)?e:t}),e}}(n);return t},e.exports=o(r)},{"../../util":175}],116:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./view"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","object","visible","view","view3","vertex"],e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this.uniforms={viewMatrix:this._attributes.make(this._types.mat4())},this.viewMatrix=this.uniforms.viewMatrix.value,this.composer=i.Three.transformComposer()},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),delete this.viewMatrix,delete this.objectMatrix,delete this.uniforms},e.prototype.change=function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;if(e.view||e.view3||n)return u=this.props.position,h=this.props.scale,l=this.props.quaternion,p=this.props.rotation,a=this.props.range,s=this.props.eulerOrder,v=a[0].x,y=a[1].x,g=a[2].x,r=a[0].y-v||1,i=a[1].y-y||1,o=a[2].y-g||1,c=h.x,f=h.y,d=h.z,this.viewMatrix.set(2/r,0,0,-(2*v+r)/r,0,2/i,0,-(2*y+i)/i,0,0,2/o,-(2*g+o)/o,0,0,0,1),m=this.composer(u,p,l,h,null,s),this.viewMatrix.multiplyMatrices(m,this.viewMatrix),t["view.range"]?this.trigger({type:"view.range"}):void 0},e.prototype.vertex=function(t,n){return 1===n&&t.pipe("cartesian.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e}(o),e.exports=r},{"../../../util":175,"./view":122}],117:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./view"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","object","visible","view","view4","vertex"],e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this.uniforms={basisOffset:this._attributes.make(this._types.vec4()),basisScale:this._attributes.make(this._types.vec4())},this.basisScale=this.uniforms.basisScale.value,this.basisOffset=this.uniforms.basisOffset.value},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),delete this.basisScale,delete this.basisOffset,delete this.uniforms},e.prototype.change=function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d;if(e.view||e.view4||n)return l=this.props.position,p=this.props.scale,a=this.props.range,c=a[0].x,f=a[1].x,d=a[2].x,h=a[3].x,i=a[0].y-c||1,o=a[1].y-f||1,s=a[2].y-d||1,r=a[3].y-h||1,u=function(t,e){return t.x*=e.x,t.y*=e.y,t.z*=e.z,t.w*=e.w},this.basisScale.set(2/i,2/o,2/s,2/r),this.basisOffset.set(-(2*c+i)/i,-(2*f+o)/o,-(2*d+s)/s,-(2*h+r)/r),u(this.basisScale,p),u(this.basisOffset,p),this.basisOffset.add(l),t["view.range"]?this.trigger({type:"view.range"}):void 0},e.prototype.vertex=function(t,n){return 1===n&&t.pipe("cartesian4.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e}(i),e.exports=r},{"./view":122}],118:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./view"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","object","visible","view","view3","polar","vertex"],e.prototype.make=function(){var t;return e.__super__.make.apply(this,arguments),t=this._attributes.types,this.uniforms={polarBend:this.node.attributes["polar.bend"],polarHelix:this.node.attributes["polar.helix"],polarFocus:this._attributes.make(t.number()),polarAspect:this._attributes.make(t.number()),viewMatrix:this._attributes.make(t.mat4())},this.viewMatrix=this.uniforms.viewMatrix.value,this.composer=i.Three.transformComposer(),this.aspect=1},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),delete this.viewMatrix,delete this.objectMatrix,delete this.aspect,delete this.uniforms},e.prototype.change=function(t,e,n){var r,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O;if(e.view||e.view3||e.polar||n)return this.helix=d=this.props.helix,this.bend=s=this.props.bend,this.focus=c=s>0?1/s-1:0,v=this.props.position,b=this.props.scale,y=this.props.quaternion,g=this.props.rotation,f=this.props.range,p=this.props.eulerOrder,M=f[0].x,T=f[1].x,O=f[2].x,a=f[0].y-M||1,u=f[1].y-T||1,l=f[2].y-O||1,k=b.x,E=b.y,S=b.z,m=a>0?1:-1,_=i.Axis.recenterAxis(T,u,s),T=_[0],u=_[1],r=Math.abs(u),h=a+(r*m-a)*s,w=h/k,x=u/E,this.aspect=o=Math.abs(w/x),this.uniforms.polarFocus.value=c,this.uniforms.polarAspect.value=o,this.viewMatrix.set(2/h,0,0,-(2*M+a)/a,0,2/u,0,-(2*T+u)/u,0,0,2/l,-(2*O+l)/l,0,0,0,1),z=this.composer(v,g,y,b,null,p),this.viewMatrix.multiplyMatrices(z,this.viewMatrix),t["view.range"]||e.polar?this.trigger({type:"view.range"}):void 0},e.prototype.vertex=function(t,n){return 1===n&&t.pipe("polar.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e.prototype.axis=function(t){var e,n,r;return r=this.props.range[t-1],n=r.x,e=r.y,2===t&&this.bend>0&&(e=Math.max(Math.abs(e),Math.abs(n)),n=Math.max(-this.focus/this.aspect,n)),new THREE.Vector2(n,e)},e}(o),e.exports=r},{"../../../util":175,"./view":122}],119:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./view"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","object","visible","view","view3","spherical","vertex"],e.prototype.make=function(){var t;return e.__super__.make.apply(this,arguments),t=this._attributes.types,this.uniforms={sphericalBend:this.node.attributes["spherical.bend"],sphericalFocus:this._attributes.make(this._types.number()),sphericalAspectX:this._attributes.make(this._types.number()),sphericalAspectY:this._attributes.make(this._types.number()),sphericalScaleY:this._attributes.make(this._types.number()),viewMatrix:this._attributes.make(this._types.mat4())},this.viewMatrix=this.uniforms.viewMatrix.value,this.composer=i.Three.transformComposer(),this.aspectX=1,this.aspectY=1},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),delete this.viewMatrix,delete this.objectMatrix,delete this.aspectX,delete this.aspectY,delete this.uniforms},e.prototype.change=function(t,e,n){var r,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D;if(e.view||e.view3||e.spherical||n)return this.bend=u=this.props.bend,this.focus=m=u>0?1/u-1:0,_=this.props.position,E=this.props.scale,b=this.props.quaternion,w=this.props.rotation,v=this.props.range,c=this.props.eulerOrder,C=v[0].x,I=v[1].x,D=v[2].x,l=v[0].y-C||1,p=v[1].y-I||1,h=v[2].y-D||1,O=E.x,A=E.y,P=E.z,x=i.Axis.recenterAxis(I,p,u),I=x[0],p=x[1],k=i.Axis.recenterAxis(D,h,u),D=k[0],h=k[1],y=l>0?1:-1,g=p>0?1:-1,r=Math.abs(h),f=l+(r*y-l)*u,d=p+(r*g-p)*u,z=f/O,M=d/A,T=h/P,this.aspectX=o=Math.abs(z/T),this.aspectY=s=Math.abs(M/T/o),a=p/l*O/A*2,this.scaleY=S=Math.min(s/u,1+(a-1)*u),this.uniforms.sphericalBend.value=u,this.uniforms.sphericalFocus.value=m,this.uniforms.sphericalAspectX.value=o,this.uniforms.sphericalAspectY.value=s,this.uniforms.sphericalScaleY.value=S,this.viewMatrix.set(2/f,0,0,-(2*C+l)/l,0,2/d,0,-(2*I+p)/p,0,0,2/h,-(2*D+h)/h,0,0,0,1),R=this.composer(_,w,b,E,null,c),this.viewMatrix.multiplyMatrices(R,this.viewMatrix),t["view.range"]||e.spherical?this.trigger({type:"view.range"}):void 0},e.prototype.vertex=function(t,n){return 1===n&&t.pipe("spherical.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e.prototype.axis=function(t){var e,n,r;return r=this.props.range[t-1],n=r.x,e=r.y,3===t&&this.bend>0&&(e=Math.max(Math.abs(e),Math.abs(n)),n=Math.max(-this.focus/this.aspectX+.001,n)),new THREE.Vector2(n,e)},e}(o),e.exports=r},{"../../../util":175,"./view":122}],120:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./view"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","object","visible","view","view3","stereographic","vertex"],e.prototype.make=function(){var t;return e.__super__.make.apply(this,arguments),t=this._attributes.types,this.uniforms={stereoBend:this.node.attributes["stereographic.bend"],viewMatrix:this._attributes.make(this._types.mat4())},this.viewMatrix=this.uniforms.viewMatrix.value,this.composer=i.Three.transformComposer()},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),delete this.viewMatrix,delete this.rotationMatrix,delete this.uniforms},e.prototype.change=function(t,e,n){var r,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;if(e.view||e.view3||e.stereographic||n)return this.bend=r=this.props.bend,p=this.props.position,d=this.props.scale,h=this.props.quaternion,c=this.props.rotation,l=this.props.range,u=this.props.eulerOrder,_=l[0].x,b=l[1].x,w=l[2].x,o=l[0].y-_||1,s=l[1].y-b||1,a=l[2].y-w||1,m=d.x,v=d.y,y=d.z,f=i.Axis.recenterAxis(w,a,r,1),w=f[0],a=f[1],this.uniforms.stereoBend.value=r,this.viewMatrix.set(2/o,0,0,-(2*_+o)/o,0,2/s,0,-(2*b+s)/s,0,0,2/a,-(2*w+a)/a,0,0,0,1),g=this.composer(p,c,h,d,null,u),this.viewMatrix.multiplyMatrices(g,this.viewMatrix),t["view.range"]||e.stereographic?this.trigger({type:"view.range"}):void 0},e.prototype.vertex=function(t,n){return 1===n&&t.pipe("stereographic.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e}(o),e.exports=r},{"../../../util":175,"./view":122}],121:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./view"),i=t("../../../util"),r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.traits=["node","object","visible","view","view4","stereographic","vertex"],e.prototype.make=function(){return e.__super__.make.apply(this,arguments),this.uniforms={basisOffset:this._attributes.make(this._types.vec4()),basisScale:this._attributes.make(this._types.vec4()),stereoBend:this.node.attributes["stereographic.bend"]},this.basisScale=this.uniforms.basisScale.value,this.basisOffset=this.uniforms.basisOffset.value},e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments),delete this.basisScale,delete this.basisOffset,delete this.uniforms},e.prototype.change=function(t,e,n){var r,o,s,a,u,l,p,h,c,f,d,m,v,y;if(e.view||e.view4||e.stereographic||n)return this.bend=r=this.props.bend,h=this.props.position,f=this.props.scale,l=this.props.range,m=l[0].x,v=l[1].x,y=l[2].x,d=l[3].x,s=l[0].y-m||1,a=l[1].y-v||1,u=l[2].y-y||1,o=l[3].y-d||1,p=function(t,e){return t.x*=e.x,t.y*=e.y,t.z*=e.z,t.w*=e.w},c=i.Axis.recenterAxis(d,o,r,1),d=c[0],o=c[1],this.basisScale.set(2/s,2/a,2/u,2/o),this.basisOffset.set(-(2*m+s)/s,-(2*v+a)/a,-(2*y+u)/u,-(2*d+o)/o),p(this.basisScale,f),p(this.basisOffset,f),this.basisOffset.add(h),t["view.range"]||e.stereographic?this.trigger({type:"view.range"}):void 0},e.prototype.vertex=function(t,n){return 1===n&&t.pipe("stereographic4.position",this.uniforms),e.__super__.vertex.call(this,t,n)},e}(o),e.exports=r},{"../../../util":175,"./view":122}],122:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("../transform/transform"),i=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return o(e,t),e.traits=["node","object","visible","view","vertex"],e.prototype.make=function(){return this._helpers.visible.make()},e.prototype.unmake=function(){return this._helpers.visible.unmake()},e.prototype.axis=function(t){return this.props.range[t-1]},e}(r),e.exports=i},{"../transform/transform":111}],123:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./databuffer"),o=t("../../util"),r=function(t){function e(t,n,r){this.width=r.width||1,this.history=r.history||1,this.samples=this.width,this.wrap=this.history>1,r.width=this.width,r.height=this.history,r.depth=1,e.__super__.constructor.call(this,t,n,r)}return s(e,t),e.prototype.build=function(t){return e.__super__.build.apply(this,arguments),this.index=0,this.pad=0,this.streamer=this.generate(this.data)},e.prototype.setActive=function(t){return this.pad=Math.max(0,this.width-t)},e.prototype.fill=function(){var t,e,n,r,i,o,s,a,u;for(t=this.callback,"function"==typeof t.reset&&t.reset(),s=this.streamer,r=s.emit,u=s.skip,e=s.count,n=s.done,a=s.reset,a(),o=this.samples-this.pad,i=0;!n()&&o>i&&t(r,i++)!==!1;);return Math.floor(e()/this.items)},e.prototype.write=function(t){return null==t&&(t=this.samples),t*=this.items,this.texture.write(this.data,0,this.index,t,1),this.dataPointer.set(.5,this.index+.5),this.index=(this.index+this.history-1)%this.history,this.filled=Math.min(this.history,this.filled+1)},e.prototype.through=function(t,e){var n,r,i,s,a,u,l,p;return l=p=this.streamer,n=l.consume,r=l.done,s=(i=e.streamer).emit,a=0,u=function(){return n(function(e,n,r,i){return t(s,e,n,r,i,a)})},u=o.Data.repeatCall(u,this.items),function(t){return function(){var e;for(p.reset(),i.reset(),e=t.samples-t.pad,a=0;!r()&&e>a;)u(),a++;return p.count()}}(this)},e}(i),e.exports=r},{"../../util":175,"./databuffer":126}],124:[function(t,e,n){var r,i,o,s,a,u,l=function(t,e){function n(){this.constructor=t}for(var r in e)p.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},p={}.hasOwnProperty;s=t("../renderable"),u=t("../../util"),o=t("./texture/datatexture"),i=t("./texture/backedtexture"),r=function(t){function e(t,n,r){null==this.width&&(this.width=r.width||512),null==this.height&&(this.height=r.height||512),null==this.channels&&(this.channels=r.channels||4),null==this.backed&&(this.backed=r.backed||!1),this.samples=this.width*this.height,e.__super__.constructor.call(this,t,n),this.build(r)}return l(e,t),e.prototype.shader=function(t){return t.pipe("map.2d.data",this.uniforms),t.pipe("sample.2d",this.uniforms),this.channels<4&&t.pipe(u.GLSL.swizzleVec4(["0000","x000","xw00","xyz0"][this.channels])),t},e.prototype.build=function(t){var e;return this.klass=e=this.backed?i:o,this.texture=new e(this.gl,this.width,this.height,this.channels,t),this.uniforms={dataPointer:{type:"v2",value:new THREE.Vector2(0,0)}},this._adopt(this.texture.uniforms),this.reset()},e.prototype.reset=function(){return this.rows=[],this.bottom=0},e.prototype.resize=function(t,e){if(!this.backed)throw new Error("Cannot resize unbacked texture atlas");return t>2048&&e>2048?console.warn("Giant text atlas "+t+"x"+e+"."):console.info("Resizing text atlas "+t+"x"+e+"."),this.texture.resize(t,e),this.width=t,this.height=e,this.samples=t*e},e.prototype.collapse=function(t){var e,n,r;return r=this.rows,r.splice(r.indexOf(t),1),this.bottom=null!=(e=null!=(n=r[r.length-1])?n.bottom:void 0)?e:0,this.last===t?this.last=null:void 0},e.prototype.allocate=function(t,e,n,r){var i,o,s,u,l,p,h,c,f,d,m,v;if(v=this.width,s=this.height,c=2*n,e>v)return this.resize(2*v,2*s),this.last=null,this.allocate(t,e,n,r);if(d=this.last,null!=d&&d.height>=n&&d.height<c&&d.width+e<=v)return void d.append(t,e,n,r);for(i=0,l=-1,m=0,f=this.rows,u=p=0,h=f.length;h>p;u=++p)if(d=f[u],o=d.top-i,o>=n&&0>l&&(l=u,m=i),i=d.bottom,d.height>=n&&d.height<c&&d.width+e<=v)return d.append(t,e,n,r),void(this.last=d);if(l>=0)d=new a(m,n),this.rows.splice(l,0,d);else{if(m=i,i+=n,i>=s)return this.resize(2*v,2*s),this.last=null,this.allocate(t,e,n,r);d=new a(m,n),this.rows.push(d),this.bottom=i}d.append(t,e,n,r),this.last=d},e.prototype.read=function(){return this.texture.textureObject},e.prototype.write=function(t,e,n,r,i){return this.texture.write(t,e,n,r,i)},e.prototype.dispose=function(){return this.texture.dispose(),this.data=null,e.__super__.dispose.apply(this,arguments)},e}(s),a=function(){function t(t,e){this.top=t,this.bottom=t+e,this.width=0,this.height=e,this.alive=0,this.keys=[]}return t.prototype.append=function(t,e,n,r){var i,o;return i=this.width,o=this.top,this.alive++,this.width+=e,this.keys.push(t),r(this,i,o)},t}(),e.exports=r},{"../../util":175,"../renderable":161,"./texture/backedtexture":133,"./texture/datatexture":134}],125:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../renderable"),o=t("../../util"),r=function(t){function e(t,n,r){null==this.items&&(this.items=r.items||1),null==this.samples&&(this.samples=r.samples||1),null==this.channels&&(this.channels=r.channels||4),null==this.callback&&(this.callback=r.callback||function(){}),e.__super__.constructor.call(this,t,n)}return s(e,t),e.prototype.dispose=function(){return e.__super__.dispose.apply(this,arguments)},e.prototype.update=function(){var t;return t=this.fill(),this.write(t),t},e.prototype.setActive=function(t,e,n,r){},e.prototype.setCallback=function(t){this.callback=t},e.prototype.write=function(){},e.prototype.fill=function(){},e.prototype.generate=function(t){return o.Data.getStreamer(t,this.samples,this.channels,this.items)},e}(i),e.exports=r},{"../../util":175,"../renderable":161}],126:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;r=t("./buffer"),o=t("./texture/datatexture"),s=t("../../util"),i=function(t){function e(t,n,r){this.width=r.width||1,this.height=r.height||1,this.depth=r.depth||1,null==this.samples&&(this.samples=this.width*this.height*this.depth),e.__super__.constructor.call(this,t,n,r),this.build(r)}return a(e,t),e.prototype.shader=function(t,e){var n;return null==e&&(e=4),this.items>1||this.depth>1?(4!==e&&t.pipe(s.GLSL.extendVec(e,4)),t.pipe("map.xyzw.texture",this.uniforms)):2!==e&&t.pipe(s.GLSL.truncateVec(e,2)),n=this.wrap?".wrap":"",t.pipe("map.2d.data"+n,this.uniforms),t.pipe("sample.2d",this.uniforms),this.channels<4&&t.pipe(s.GLSL.swizzleVec4(["0000","x000","xw00","xyz0"][this.channels])),t},e.prototype.build=function(t){return this.data=new Float32Array(this.samples*this.channels*this.items),this.texture=new o(this.gl,this.items*this.width,this.height*this.depth,this.channels,t),this.filled=0,this.used=0,this._adopt(this.texture.uniforms),this._adopt({dataPointer:{type:"v2",value:new THREE.Vector2},textureItems:{type:"f",value:this.items},textureHeight:{type:"f",value:this.height}}),this.dataPointer=this.uniforms.dataPointer.value,this.streamer=this.generate(this.data)},e.prototype.dispose=function(){return this.data=null,this.texture.dispose(),e.__super__.dispose.apply(this,arguments)},e.prototype.getFilled=function(){return this.filled},e.prototype.setCallback=function(t){return this.callback=t,this.filled=0},e.prototype.copy=function(t){var e,n,r,i,o;for(i=Math.min(t.length,this.samples*this.channels*this.items),e=this.data,n=r=0,o=i;o>=0?o>r:r>o;n=o>=0?++r:--r)e[n]=t[n];return this.write(Math.ceil(i/this.channels/this.items))},e.prototype.write=function(t){var e,n;return null==t&&(t=this.samples),e=t/this.width,t*=this.items,n=1>e?t:this.items*this.width,e=Math.ceil(e),this.texture.write(this.data,0,0,n,e),this.dataPointer.set(.5,.5),this.filled=1,this.used=t},e.prototype.through=function(t,e){var n,r,i,o,a,u,l,p;return l=p=this.streamer,n=l.consume,r=l.done,o=(i=e.streamer).emit,a=0,u=function(){return n(function(e,n,r,i){return t(o,e,n,r,i,a)})},u=s.Data.repeatCall(u,this.items),function(t){return function(){var e;for(p.reset(),i.reset(),e=t.used,a=0;!r()&&e>a;)u(),a++;return p.count()}}(this)},e}(r),e.exports=i},{"../../util":175,"./buffer":125,"./texture/datatexture":134}],127:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./databuffer"),o=t("../../util"),i=function(t){function e(t,n,r){this.width=r.width||1,this.height=r.height||1,this.history=r.history||1,this.samples=this.width*this.height,this.wrap=this.history>1,r.depth=this.history,e.__super__.constructor.call(this,t,n,r)}return s(e,t),e.prototype.build=function(t){return e.__super__.build.apply(this,arguments),this.index=0,this.pad={x:0,y:0},this.streamer=this.generate(this.data)},e.prototype.getFilled=function(){return this.filled},e.prototype.setActive=function(t,e){var n;return n=[Math.max(0,this.width-t),Math.max(0,this.height-e)],this.pad.x=n[0],this.pad.y=n[1],n},e.prototype.fill=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f;if(t=this.callback,"function"==typeof t.reset&&t.reset(),p=this.streamer,r=p.emit,f=p.skip,e=p.count,n=p.done,c=p.reset,c(),u=this.width,l=this.pad.x,a=this.samples-this.pad.y*u,i=o=s=0,l)for(;!n()&&a>s&&(s++,h=t(r,i,o),++i===u-l&&(f(l),i=0,o++),h!==!1););else for(;!n()&&a>s&&(s++,h=t(r,i,o),++i===u&&(i=0,o++),h!==!1););return Math.floor(e()/this.items)},e.prototype.write=function(t){var e,n;return null==t&&(t=this.samples),t*=this.items,n=this.width*this.items,e=Math.ceil(t/n),this.texture.write(this.data,0,this.index*this.height,n,e),this.dataPointer.set(.5,this.index*this.height+.5),this.index=(this.index+this.history-1)%this.history,this.filled=Math.min(this.history,this.filled+1)},e.prototype.through=function(t,e){var n,r,i,s,a,u,l,p,h;return p=h=this.streamer,n=p.consume,r=p.done,s=(i=e.streamer).emit,a=u=0,l=function(){return n(function(e,n,r,i){return t(s,e,n,r,i,a,u)})},l=o.Data.repeatCall(l,this.items),function(t){return function(){var e,n,o,s;if(h.reset(),i.reset(),o=t.width,s=t.pad.x,n=t.samples-t.pad.y*o,a=u=e=0,s)for(;!r()&&n>e;)e++,l(),++a===o-s&&(skip(s),a=0,u++);else for(;!r()&&n>e;)e++,l(),++a===o&&(a=0,u++);return h.count()}}(this)},e}(r),e.exports=i},{"../../util":175,"./databuffer":126}],128:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;o=t("../renderable"),i=t("./rendertotexture"),s=t("../../util"),r=function(t){function e(t,n,r){null==this.items&&(this.items=r.items||1),null==this.channels&&(this.channels=r.channels||4),null==this.width&&(this.width=r.width||1),null==this.height&&(this.height=r.height||1),null==this.depth&&(this.depth=r.depth||1),r.format=THREE.RGBAFormat,r.width=this._width=this.items*this.width,r.height=this._height=this.height*this.depth,r.frames=1,delete r.items,delete r.depth,delete r.channels,e.__super__.constructor.call(this,t,n,r),this._adopt({textureItems:{type:"f",value:this.items},textureHeight:{type:"f",value:this.height}})}return a(e,t),e.prototype.shaderAbsolute=function(t){return null==t&&(t=this.shaders.shader()),t.pipe("map.xyzw.texture",this.uniforms),e.__super__.shaderAbsolute.call(this,t,1,2)},e}(i),e.exports=r},{"../../util":175,"../renderable":161,"./rendertotexture":131}],129:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,
t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./buffer"),o=t("../../util"),i=function(t){function e(t,n,r){this.width=r.width||1,this.height=r.height||1,this.depth=r.depth||1,null==this.samples&&(this.samples=this.width*this.height*this.depth),e.__super__.constructor.call(this,t,n,r),this.build(r)}return s(e,t),e.prototype.build=function(t){return this.data=[],this.data.length=this.samples,this.filled=0,this.pad={x:0,y:0,z:0},this.streamer=this.generate(this.data)},e.prototype.dispose=function(){return this.data=null,e.__super__.dispose.apply(this,arguments)},e.prototype.getFilled=function(){return this.filled},e.prototype.setActive=function(t,e,n){var r;return r=[this.width-t,this.height-e,this.depth-n],this.pad.x=r[0],this.pad.y=r[1],this.pad.z=r[2],r},e.prototype.read=function(){return this.data},e.prototype.copy=function(t){var e,n,r,i,o,s;for(r=Math.min(t.length,this.samples),e=this.data,s=[],n=i=0,o=r;o>=0?o>i:i>o;n=o>=0?++i:--i)s.push(e[n]=t[n]);return s},e.prototype.fill=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y;if(t=this.callback,"function"==typeof t.reset&&t.reset(),d=this.streamer,r=d.emit,y=d.skip,e=d.count,n=d.done,v=d.reset,v(),p=this.width,l=this.height,h=this.depth,c=this.pad.x,f=this.pad.y,u=this.samples-this.pad.z*p*l,i=o=s=a=0,c>0||f>0)for(;!n()&&u>a&&(a++,m=t(r,i,o,s),++i===p-c&&(y(c),i=0,++o===l-f&&(y(p*f),o=0,s++)),m!==!1););else for(;!n()&&u>a&&(a++,m=t(r,i,o,s),++i===p&&(i=0,++o===l&&(o=0,s++)),m!==!1););return this.filled=1,e()},e}(r),e.exports=i},{"../../util":175,"./buffer":125}],130:[function(t,e,n){var r,i,o,s,a,u,l=function(t,e){function n(){this.constructor=t}for(var r in e)p.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},p={}.hasOwnProperty;a=t("../renderable"),r=t("./buffer"),i=t("./memo"),o=t("../meshes/memoscreen"),u=t("../../util"),s=function(t){function e(t,n,r){null==this.items&&(this.items=r.items||1),null==this.channels&&(this.channels=r.channels||4),null==this.width&&(this.width=r.width||1),null==this.height&&(this.height=r.height||1),null==this.depth&&(this.depth=r.depth||1),null==this.type&&(this.type=r.type||THREE.FloatType),null==this.stpq&&(this.stpq=r.stpq||!1),this.isFloat=this.type===THREE.FloatType,this.active=this.sampled=this.rect=this.pad=null,e.__super__.constructor.call(this,t,n),this.build(r)}return l(e,t),e.prototype.build=function(t){var e,n,r,s,a,l,p,h,c,f,d,m,v,y;return c=t.map,l=t.indexer,p=null!=l&&!l.empty(),h=this.items,y=this.width,a=this.height,n=this.depth,d=this.stpq,f=c,p&&(this._adopt({indexModulus:{type:"v4",value:new THREE.Vector4(h,h*y,h*y*a,1)}}),f=this.shaders.shader(),f.require(c),f.require(l),f.pipe("float.index.pack",this.uniforms)),this.isFloat&&this.channels>1&&(this.floatMemo=new i(this.renderer,this.shaders,{items:h,channels:4,width:y,height:a,depth:n,history:0,type:THREE.FloatType}),this.floatCompose=new o(this.renderer,this.shaders,{map:f,items:h,width:y,height:a,depth:n,stpq:d}),this.floatMemo.adopt(this.floatCompose),d=!1,f=this.shaders.shader(),this.floatMemo.shaderAbsolute(f)),this.isFloat?(m=this.channels,e=4):(m=1,e=this.channels),m>1?(r=this.shaders.shader(),r.pipe(u.GLSL.mapByte2FloatOffset(m)),r.require(f),r.pipe("float.stretch"),r.pipe("float.encode"),f=r):this.isFloat&&(r=this.shaders.shader(),r.pipe(f),r.pipe(u.GLSL.truncateVec4(4,1)),r.pipe("float.encode"),f=r),this.byteMemo=new i(this.renderer,this.shaders,{items:h*m,channels:4,width:y,height:a,depth:n,history:0,type:THREE.UnsignedByteType}),this.byteCompose=new o(this.renderer,this.shaders,{map:f,items:h*m,width:y,height:a,depth:n,stpq:d}),this.byteMemo.adopt(this.byteCompose),v=h*y*m,s=a*n,this.samples=this.width*this.height*this.depth,this.bytes=new Uint8Array(v*s*4),this.isFloat&&(this.floats=new Float32Array(this.bytes.buffer)),this.data=this.isFloat?this.floats:this.bytes,this.streamer=this.generate(this.data),this.active={items:0,width:0,height:0,depth:0},this.sampled={items:0,width:0,height:0,depth:0},this.rect={w:0,h:0},this.pad={x:0,y:0,z:0,w:0},this.stretch=m,this.isIndexed=p,this.setActive(h,y,a,n)},e.prototype.generate=function(t){return u.Data.getStreamer(t,this.samples,4,this.items)},e.prototype.setActive=function(t,e,n,r){var i,o,s,a,u,l,p,h;if(t!==this.active.items||e!==this.active.width||n!==this.active.height||r!==this.active.depth)return o=[t,e,n,r],this.active.items=o[0],this.active.width=o[1],this.active.height=o[2],this.active.depth=o[3],null!=(s=this.floatCompose)&&s.cover(e,n,r),null!=(a=this.byteCompose)&&a.cover(e*this.stretch,n,r),t=this.items,e=this.active.width,n=1===this.depth?this.active.height:this.height,r=this.active.depth,h=t*e*this.stretch,i=n*r,u=[t,e,n,r],this.sampled.items=u[0],this.sampled.width=u[1],this.sampled.height=u[2],this.sampled.depth=u[3],l=[h,i],this.rect.w=l[0],this.rect.h=l[1],p=[this.sampled.width-this.active.width,this.sampled.height-this.active.height,this.sampled.depth-this.active.depth,this.sampled.items-this.active.items],this.pad.x=p[0],this.pad.y=p[1],this.pad.z=p[2],this.pad.w=p[3],p},e.prototype.update=function(t){var e,n;return null!=(e=this.floatMemo)&&e.render(t),null!=(n=this.byteMemo)?n.render(t):void 0},e.prototype.post=function(){return this.renderer.setRenderTarget(this.byteMemo.target.write),this.gl.readPixels(0,0,this.rect.w,this.rect.h,gl.RGBA,gl.UNSIGNED_BYTE,this.bytes)},e.prototype.readFloat=function(t){var e;return null!=(e=this.floatMemo)?e.read(t):void 0},e.prototype.readByte=function(t){var e;return null!=(e=this.byteMemo)?e.read(t):void 0},e.prototype.setCallback=function(t){return this.emitter=this.callback(t)},e.prototype.callback=function(t){var e,n,r,i,o;return this.isIndexed?(r=this.width,n=this.height,i=this.depth,o=this.items,e=function(e,i,s,a){var u,l,p,h,c;return u=a,c=u%o,u=(u-c)/o,l=u%r,u=(u-l)/r,p=u%n,u=(u-p)/n,h=u,t(e,i,s,a,l,p,h,c)},e.reset=function(){return"function"==typeof t.reset?t.reset():void 0},e):t},e.prototype.iterate=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;for(i=this.emitter,"function"==typeof i.reset&&i.reset(),g=this.streamer,e=g.consume,w=g.skip,n=g.count,r=g.done,b=g.reset,b(),h=0|this.sampled.width,p=0|this.sampled.height,c=0|this.sampled.depth,f=0|this.sampled.items,m=0|this.pad.x,v=0|this.pad.y,y=0|this.pad.z,d=0|this.pad.w,l=h*p*f*(c-y),this.isIndexed||(t=i,i=function(e,n,r,i){return t(e,n,r,i,o,s,a,u)}),o=s=a=u=p=0;!r()&&l>p&&(p++,_=e(i),++u===f-d&&(w(m),u=0,++o===h-m&&(w(f*m),o=0,++s===p-v&&(w(f*h*v),s=0,a++))),_!==!1););return Math.floor(n()/f)},e.prototype.dispose=function(){var t,e,n,r,i,o;return null!=(t=this.floatMemo)&&t.unadopt(this.floatCompose),null!=(e=this.floatMemo)&&e.dispose(),null!=(n=this.floatCompose)&&n.dispose(),null!=(r=this.byteMemo)&&r.unadopt(this.byteCompose),null!=(i=this.byteMemo)&&i.dispose(),null!=(o=this.byteCompose)&&o.dispose(),this.floatMemo=this.byteMemo=this.floatCompose=this.byteCompose=null},e}(a),e.exports=s},{"../../util":175,"../meshes/memoscreen":155,"../renderable":161,"./buffer":125,"./memo":128}],131:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;o=t("../renderable"),r=t("./texture/rendertarget"),s=t("../../util"),i=function(t){function e(t,n,r){var i;this.scene=null!=(i=r.scene)?i:new THREE.Scene,this.camera=r.camera,e.__super__.constructor.call(this,t,n),this.build(r)}return a(e,t),e.prototype.shaderRelative=function(t){return null==t&&(t=this.shaders.shader()),t.pipe("sample.2d",this.uniforms)},e.prototype.shaderAbsolute=function(t,e,n){var r;return null==e&&(e=1),null==n&&(n=4),null==t&&(t=this.shaders.shader()),1>=e?(n>2&&t.pipe(s.GLSL.truncateVec(n,2)),t.pipe("map.2d.data",this.uniforms),t.pipe("sample.2d",this.uniforms)):(r=s.GLSL.sample2DArray(Math.min(e,this.target.frames)),4>n&&t.pipe(s.GLSL.extendVec(n,4)),t.pipe("map.xyzw.2dv"),t.split(),t.pipe("map.2d.data",this.uniforms),t.pass(),t.pipe(r,this.uniforms))},e.prototype.build=function(t){var e;return this.camera||(this.camera=new THREE.PerspectiveCamera,this.camera.position.set(0,0,3),this.camera.lookAt(new THREE.Vector3)),"function"==typeof(e=this.scene).inject&&e.inject(),this.target=new r(this.gl,t.width,t.height,t.frames,t),this.target.warmup(function(t){return function(e){return t.renderer.setRenderTarget(e)}}(this)),this.renderer.setRenderTarget(null),this._adopt(this.target.uniforms),this._adopt({dataPointer:{type:"v2",value:new THREE.Vector2(.5,.5)}}),this.filled=0},e.prototype.adopt=function(t){var e,n,r,i,o;for(i=t.renders,o=[],e=0,n=i.length;n>e;e++)r=i[e],o.push(this.scene.add(r));return o},e.prototype.unadopt=function(t){var e,n,r,i,o;for(i=t.renders,o=[],e=0,n=i.length;n>e;e++)r=i[e],o.push(this.scene.remove(r));return o},e.prototype.render=function(t){var e;return null==t&&(t=this.camera),this.renderer.render(null!=(e=this.scene.scene)?e:this.scene,t,this.target.write),this.target.cycle(),this.filled<this.target.frames?this.filled++:void 0},e.prototype.read=function(t){return null==t&&(t=0),this.target.reads[Math.abs(t)]},e.prototype.getFrames=function(){return this.target.frames},e.prototype.getFilled=function(){return this.filled},e.prototype.dispose=function(){var t;return"function"==typeof(t=this.scene).unject&&t.unject(),this.scene=this.camera=null,this.target.dispose(),e.__super__.dispose.apply(this,arguments)},e}(o),e.exports=i},{"../../util":175,"../renderable":161,"./texture/rendertarget":135}],132:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./atlas"),i=32,o=function(t){function e(t,n,r){var i,o,s,a,u,l,p;this.font=null!=(i=r.font)?i:["sans-serif"],this.size=r.size||24,this.style=null!=(o=r.style)?o:"normal",this.variant=null!=(s=r.variant)?s:"normal",this.weight=null!=(a=r.weight)?a:"normal",this.outline=null!=(u=+(null!=(l=r.outline)?l:5))?u:0,r.width||(r.width=256),r.height||(r.height=256),r.type=THREE.UnsignedByteType,r.channels=1,r.backed=!0,this.gamma=1,"undefined"!=typeof navigator&&(p=navigator.userAgent,p.match(/Chrome/)&&p.match(/OS X/)&&(this.gamma=.5)),this.scratchW=this.scratchH=0,e.__super__.constructor.call(this,t,n,r)}return s(e,t),e.prototype.build=function(t){var n,r,o,s,a,u,l,p,h,c,f,d,m;for(e.__super__.build.call(this,t),h=16,h=this.size,h+=4+2*Math.min(1,this.outline),c=i*h,n=document.createElement("canvas"),n.width=c,n.height=h,f=function(t){return'"'+t.replace(/(['"\\])/g,"\\$1")+'"'},a=this.font.map(f).join(", "),o=n.getContext("2d"),o.font=this.style+" "+this.variant+" "+this.weight+" "+this.size+"px "+this.font,o.fillStyle="#FF0000",o.textAlign="left",o.textBaseline="bottom",o.lineJoin="round",r=[],s=3*this.outline,l=p=0,d=s;d>=0?d>p:p>d;l=d>=0?++p:--p)u=("00"+Math.max(0,8*-l+128-8*!l).toString(16)).slice(-2),r.push("#"+u+u+u);return m=new Uint8Array(c*h*2),this.canvas=n,this.context=o,this.lineHeight=h,this.maxWidth=c,this.colors=r,this.scratch=m,this._allocate=this.allocate.bind(this),this._write=this.write.bind(this)},e.prototype.reset=function(){return e.__super__.reset.apply(this,arguments),this.mapped={}},e.prototype.begin=function(){var t,e,n,r,i;for(n=this.rows,r=[],t=0,e=n.length;e>t;t++)i=n[t],r.push(i.alive=0);return r},e.prototype.end=function(){var t,e,n,r,i,o,s,a,u;for(o=this.mapped,s=this.rows.slice(),t=0,r=s.length;r>t;t++)if(u=s[t],0===u.alive){for(a=u.keys,n=0,i=a.length;i>n;n++)e=a[n],delete o[e];this.collapse(u)}},e.prototype.map=function(t,e){var n,r,i,o,s,a,u;return s=this.mapped,r=s[t],null!=r?(r.row.alive++,e(r.x,r.y,r.w,r.h)):(this.draw(t),i=this.scratch,a=this.scratchW,o=this.scratchH,n=this._allocate,u=this._write,n(t,a,o,function(n,r,l){return s[t]={x:r,y:l,w:a,h:o,row:n},u(i,r,l,a,o),e(r,l,a,o)}))},e.prototype.draw=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S;if(k=this.width,l=this.lineHeight,_=this.outline,o=this.context,a=this.scratch,y=this.maxWidth,i=this.colors,E=_+1,S=Math.round(1.05*l-1),m=o.measureText(t),k=Math.min(y,Math.ceil(m.width+2*E+1)),o.clearRect(0,0,k,l),0===this.outline){for(o.fillText(t,E,S),s=(h=o.getImageData(0,0,k,l)).data,c=3,p=f=0,b=s.length/4;b>=0?b>f:f>b;p=b>=0?++f:--f)a[p]=s[c],c+=4;return this.scratchW=k,this.scratchH=l}for(o.globalCompositeOperation="source-over",p=d=w=_+1;1>=w?1>=d:d>=1;p=1>=w?++d:--d)c=p>1?2*p-2:p,o.strokeStyle=i[c-1],o.lineWidth=c,o.strokeText(t,E,S);for(o.globalCompositeOperation="multiply",o.fillText(t,E,S),s=(h=o.getImageData(0,0,k,l)).data,c=0,u=this.gamma,p=g=0,x=s.length/4;x>=0?x>g:g>x;p=x>=0?++g:--g)e=s[c],v=e?s[c+1]/e:1,.5===u&&(v=Math.sqrt(v)),v=Math.min(1,Math.max(0,v)),n=256-e,r=n+(e-n)*v,a[p]=Math.max(0,Math.min(255,r+2)),c+=4;return this.scratchW=k,this.scratchH=l},e}(r),e.exports=o},{"./atlas":124}],133:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("../../../Util"),i=t("./datatexture"),r=function(t){function e(t,n,r,i,o){e.__super__.constructor.call(this,t,n,r,i,o),this.data=new this.ctor(this.n)}return s(e,t),e.prototype.resize=function(t,e){var n,r,i,o;return r=this.data,o=this.width,i=this.height,this.width=t,this.height=e,this.n=t*e*this.channels,this.data=new this.ctor(this.n),n=this.gl,n.bindTexture(n.TEXTURE_2D,this.texture),n.pixelStorei(n.UNPACK_ALIGNMENT,1),n.texImage2D(n.TEXTURE_2D,0,this.format,t,e,0,this.format,this.type,this.data),this.uniforms.dataResolution.value.set(1/t,1/e),this.write(r,0,0,o,i)},e.prototype.write=function(t,n,r,i,o){var s,a,u,l,p,h,c,f,d,m,v,y;if(f=this.width,a=this.data,s=this.channels,u=0,f===i&&0===n)for(l=r*i*s,h=i*o*s;h>u;)a[l++]=t[u++];else for(c=f*s,d=i*s,m=n*s,y=r,v=r+o;v>y;){for(p=0,l=m+y*c;p++<d;)a[l++]=t[u++];y++}return e.__super__.write.call(this,t,n,r,i,o)},e.prototype.dispose=function(){return this.data=null,e.__super__.dispose.apply(this,arguments)},e}(i),e.exports=r},{"../../../Util":23,"./datatexture":134}],134:[function(t,e,n){var r,i;i=t("../../../Util"),r=function(){function t(t,e,n,r,o){var s,a,u,l,p,h,c;this.gl=t,this.width=e,this.height=n,this.channels=r,this.n=this.width*this.height*this.channels,s=this.gl,u=null!=(l=o.minFilter)?l:THREE.NearestFilter,a=null!=(p=o.magFilter)?p:THREE.NearestFilter,c=null!=(h=o.type)?h:THREE.FloatType,this.minFilter=i.Three.paramToGL(s,u),this.magFilter=i.Three.paramToGL(s,a),this.type=i.Three.paramToGL(s,c),this.ctor=i.Three.paramToArrayStorage(c),this.build(o)}return t.prototype.build=function(t){var e;return e=this.gl,this.texture=e.createTexture(),this.format=[null,e.LUMINANCE,e.LUMINANCE_ALPHA,e.RGB,e.RGBA][this.channels],this.format3=[null,THREE.LuminanceFormat,THREE.LuminanceAlphaFormat,THREE.RGBFormat,THREE.RGBAFormat][this.channels],e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,this.minFilter),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,this.magFilter),this.data=new this.ctor(this.n),e.pixelStorei(e.UNPACK_ALIGNMENT,1),e.texImage2D(e.TEXTURE_2D,0,this.format,this.width,this.height,0,this.format,this.type,this.data),this.textureObject=new THREE.Texture(new Image,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,t.minFilter,t.magFilter),this.textureObject.__webglInit=!0,this.textureObject.__webglTexture=this.texture,this.textureObject.format=this.format3,this.textureObject.type=THREE.FloatType,this.textureObject.unpackAlignment=1,this.textureObject.flipY=!1,this.textureObject.generateMipmaps=!1,this.uniforms={dataResolution:{type:"v2",value:new THREE.Vector2(1/this.width,1/this.height)},dataTexture:{type:"t",value:this.textureObject}}},t.prototype.write=function(t,e,n,r,i){var o;return o=this.gl,o.bindTexture(o.TEXTURE_2D,this.texture),o.pixelStorei(o.UNPACK_ALIGNMENT,1),o.texSubImage2D(o.TEXTURE_2D,0,e,n,r,i,this.format,this.type,t)},t.prototype.dispose=function(){return this.gl.deleteTexture(this.texture),this.textureObject.__webglInit=!1,this.textureObject.__webglTexture=null,this.textureObject=this.texture=null},t}(),e.exports=r},{"../../../Util":23}],135:[function(t,e,n){var r;r=function(){function t(t,e,n,r,i){this.gl=t,null==i&&(i={}),null==i.minFilter&&(i.minFilter=THREE.NearestFilter),null==i.magFilter&&(i.magFilter=THREE.NearestFilter),null==i.format&&(i.format=THREE.RGBAFormat),null==i.type&&(i.type=THREE.UnsignedByteType),this.options=i,this.width=e||1,this.height=n||1,this.frames=r||1,this.buffers=this.frames+1,this.build()}return t.prototype.build=function(){var t,e;return e=function(t){return function(){return new THREE.WebGLRenderTarget(t.width,t.height,t.options)}}(this),this.targets=function(){var n,r,i;for(i=[],t=n=0,r=this.buffers;r>=0?r>n:n>r;t=r>=0?++n:--n)i.push(e());return i}.call(this),this.reads=function(){var n,r,i;for(i=[],t=n=0,r=this.buffers;r>=0?r>n:n>r;t=r>=0?++n:--n)i.push(e());return i}.call(this),this.write=e(),this.index=0,this.uniforms={dataResolution:{type:"v2",value:new THREE.Vector2(1/this.width,1/this.height)},dataTexture:{type:"t",value:this.reads[0]},dataTextures:{type:"tv",value:this.reads}}},t.prototype.cycle=function(){var t,e,n,r,i,o,s,a,u;for(o=["__webglTexture","__webglFramebuffer","__webglRenderbuffer"],e=this.buffers,n=function(t,e){var n,r,i;for(n=0,i=o.length;i>n;n++)r=o[n],e[r]=t[r];return null},t=function(t,n){return(t+n+2*e)%e},n(this.write,this.targets[this.index]),u=this.reads,r=i=0,s=u.length;s>i;r=++i)a=u[r],n(this.targets[t(this.index,-r)],a);return this.index=t(this.index,1),n(this.targets[this.index],this.write)},t.prototype.warmup=function(t){var e,n,r,i;for(i=[],e=n=0,r=this.buffers;r>=0?r>n:n>r;e=r>=0?++n:--n)t(this.write),i.push(this.cycle());return i},t.prototype.dispose=function(){var t,e,n,r;for(n=this.targets,t=0,e=n.length;e>t;t++)r=n[t],r.dispose();return this.targets=this.reads=this.write=null},t}(),e.exports=r},{}],136:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./databuffer"),i=t("../../util"),o=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.build=function(t){return e.__super__.build.apply(this,arguments),this.pad={x:0,y:0,z:0},this.streamer=this.generate(this.data)},e.prototype.setActive=function(t,e,n){var r;return r=[Math.max(0,this.width-t),Math.max(0,this.height-e),Math.max(0,this.depth-n)],this.pad.x=r[0],this.pad.y=r[1],this.pad.z=r[2],r},e.prototype.fill=function(){var t,e,n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y;if(t=this.callback,"function"==typeof t.reset&&t.reset(),d=this.streamer,r=d.emit,y=d.skip,e=d.count,n=d.done,v=d.reset,v(),p=this.width,l=this.height,h=this.depth,c=this.pad.x,f=this.pad.y,u=this.samples-this.pad.z*p*l,i=o=s=a=0,c>0||f>0)for(;!n()&&u>a&&(a++,m=t(r,i,o,s),++i===p-c&&(y(c),i=0,++o===l-f&&(y(p*f),o=0,s++)),m!==!1););else for(;!n()&&u>a&&(a++,m=t(r,i,o,s),++i===p&&(i=0,++o===l&&(o=0,s++)),m!==!1););return Math.floor(e()/this.items)},e.prototype.through=function(t,e){var n,r,o,s,a,u,l,p,h,c;return h=c=this.streamer,n=h.consume,r=h.done,s=(o=e.streamer).emit,a=u=l=0,p=function(){return n(function(e,n,r,i){return t(s,e,n,r,i,a,u,l)})},p=i.Data.repeatCall(p,this.items),function(t){return function(){var e,n,i,s,h,f,d;if(c.reset(),o.reset(),s=t.width,i=t.height,h=t.depth,f=t.pad.x,d=t.pad.y,n=t.samples-t.pad.z*s*i,a=u=l=e=0,f>0||d>0)for(;!r()&&n>e;)e++,p(),++a===s-f&&(skip(f),a=0,++u===i-d&&(skip(s*d),u=0,l++));else for(;!r()&&n>e;)e++,p(),++a===s&&(a=0,++u===i&&(u=0,l++));return c.count()}}(this)},e}(r),e.exports=o},{"../../util":175,"./databuffer":126}],137:[function(t,e,n){var r;r={sprite:t("./meshes/sprite"),point:t("./meshes/point"),line:t("./meshes/line"),surface:t("./meshes/surface"),face:t("./meshes/face"),strip:t("./meshes/strip"),arrow:t("./meshes/arrow"),screen:t("./meshes/screen"),memoScreen:t("./meshes/memoscreen"),debug:t("./meshes/debug"),dataBuffer:t("./buffer/databuffer"),arrayBuffer:t("./buffer/arraybuffer"),matrixBuffer:t("./buffer/matrixbuffer"),voxelBuffer:t("./buffer/voxelbuffer"),pushBuffer:t("./buffer/pushbuffer"),renderToTexture:t("./buffer/rendertotexture"),memo:t("./buffer/memo"),readback:t("./buffer/readback"),atlas:t("./buffer/atlas"),textAtlas:t("./buffer/textatlas"),scene:t("./scene")},e.exports=r},{"./buffer/arraybuffer":123,"./buffer/atlas":124,"./buffer/databuffer":126,"./buffer/matrixbuffer":127,"./buffer/memo":128,"./buffer/pushbuffer":129,"./buffer/readback":130,"./buffer/rendertotexture":131,"./buffer/textatlas":132,"./buffer/voxelbuffer":136,"./meshes/arrow":150,"./meshes/debug":152,"./meshes/face":153,"./meshes/line":154,"./meshes/memoscreen":155,"./meshes/point":156,"./meshes/screen":157,"./meshes/sprite":158,"./meshes/strip":159,"./meshes/surface":160,"./scene":162}],138:[function(t,e,n){var r;r=function(){function t(t,e,n){this.classes=t,this.renderer=e,this.shaders=n}return t.prototype.getTypes=function(){return Object.keys(this.classes)},t.prototype.make=function(t,e){return new this.classes[t](this.renderer,this.shaders,e)},t}(),e.exports=r},{}],139:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./clipgeometry"),r=function(t){function e(t){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H,B,q,V,G,W,X,Y;for(e.__super__.constructor.call(this,t),this._clipUniforms(),this.sides=H=+t.sides||12,this.samples=F=+t.samples||2,this.strips=q=+t.strips||1,this.ribbons=U=+t.ribbons||1,this.layers=b=+t.layers||1,this.flip=d=null!=(A=t.flip)?A:!1,this.anchor=r=null!=(P=t.anchor)?P:d?0:F-1,s=q*U*b,z=(H+2)*s,G=2*H*s,this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(3*G),1)),this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(4*z),4)),this.addAttribute("arrow",new THREE.BufferAttribute(new Float32Array(3*z),3)),this.addAttribute("attach",new THREE.BufferAttribute(new Float32Array(2*z),2)),this._autochunk(),v=this._emitter("index"),M=this._emitter("position4"),o=this._emitter("arrow"),a=this._emitter("attach"),c=[],g=y=0,R=H;R>=0?R>y:y>R;g=R>=0?++y:--y)i=g/H*τ,c.push([Math.cos(i),Math.sin(i),1]);for(p=0,m=w=0,C=s;C>=0?C>w:w>C;m=C>=0?++w:--w){for(V=p++,l=V+H+1,g=x=0,I=H;I>=0?I>x:x>I;g=I>=0?++x:--x)n=p+g%H,u=p+(g+1)%H,v(V),v(n),v(u),v(u),v(n),v(l);p+=H+1}for(B=d?1:-1,f=d?F-1:0,k=r+B,W=r,_=E=0,D=b;D>=0?D>E:E>D;_=D>=0?++E:--E)for(Y=S=0,L=U;L>=0?L>S:S>L;Y=L>=0?++S:--S)for(X=T=0,j=q;j>=0?j>T:T>j;X=j>=0?++T:--T){for(M(W,X,Y,_),o(0,0,0),a(k,f),g=O=0,N=H;N>=0?N>O:O>N;g=N>=0?++O:--O)M(W,X,Y,_),h=c[g],o(h[0],h[1],h[2]),a(k,f);M(W,X,Y,_),o(0,0,1),a(k,f)}this._finalize(),this.clip()}return o(e,t),e.prototype.clip=function(t,e,n,r){var i,o,s,a;return null==t&&(t=this.samples),null==e&&(e=this.strips),null==n&&(n=this.ribbons),null==r&&(r=this.layers),a=Math.max(0,t-1),this._clipGeometry(t,e,n,r),t>this.anchor?(i=[r,n,e],o=[this.layers,this.ribbons,this.strips],s=this.sides*this._reduce(i,o)):s=0,this._offsets([{start:0,count:6*s}])},e}(i),e.exports=r},{"./clipgeometry":140}],140:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;i=t("./geometry"),o=!1,s=function(){var t;return t=+new Date,function(e){var n;return n=+new Date-t,console.log(e,n+" ms"),n}},r=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return a(e,t),e.prototype._clipUniforms=function(){return this.geometryClip=new THREE.Vector4(1e10,1e10,1e10,1e10),this.geometryResolution=new THREE.Vector4,this.mapSize=new THREE.Vector4,null==this.uniforms&&(this.uniforms={}),this.uniforms.geometryClip={type:"v4",value:this.geometryClip},this.uniforms.geometryResolution={type:"v4",value:this.geometryResolution},this.uniforms.mapSize={type:"v4",value:this.mapSize}},e.prototype._clipGeometry=function(t,e,n,r){var i,o;return i=function(t){return Math.max(0,t-1)},o=function(t){return 1/Math.max(1,t-1)},this.geometryClip.set(i(t),i(e),i(n),i(r)),this.geometryResolution.set(o(t),o(e),o(n),o(r))},e.prototype._clipMap=function(t,e,n,r){return this.mapSize.set(t,e,n,r)},e.prototype._clipOffsets=function(t,e,n,r,i,o,s,a,u){var l,p,h;return l=[r,n,e,i],h=[a,s,o,u],p=this._reduce(l,h),this._offsets([{start:0,count:p*t}])},e}(i),e.exports=r},{"./geometry":142}],141:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./clipgeometry"),i=function(t){function e(t){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A;for(e.__super__.constructor.call(this,t),this._clipUniforms(),this.items=a=+t.items||2,this.width=M=+t.width||1,this.height=i=+t.height||1,this.depth=r=+t.depth||1,this.sides=S=Math.max(0,a-2),E=M*i*r,m=a*E,z=S*E,this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(3*z),1)),this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(4*m),4)),this._autochunk(),s=this._emitter("index"),v=this._emitter("position4"),n=0,o=l=0,g=E;g>=0?g>l:l>g;o=g>=0?++l:--l){for(u=h=0,_=S;_>=0?_>h:h>_;u=_>=0?++h:--h)s(n),s(n+u+1),s(n+u+2);n+=a}for(A=c=0,b=r;b>=0?b>c:c>b;A=b>=0?++c:--c)for(O=f=0,w=i;w>=0?w>f:f>w;O=w>=0?++f:--f)for(T=d=0,x=M;x>=0?x>d:d>x;T=x>=0?++d:--d)for(p=y=0,k=a;k>=0?k>y:y>k;p=k>=0?++y:--y)v(T,O,A,p);this._finalize(),this.clip()}return o(e,t),e.prototype.clip=function(t,e,n,r){var i;return null==t&&(t=this.width),null==e&&(e=this.height),null==n&&(n=this.depth),null==r&&(r=this.items),i=Math.max(0,r-2),this._clipGeometry(t,e,n,r),this._clipOffsets(3,t,e,n,i,this.width,this.height,this.depth,this.sides)},e}(r),e.exports=i},{"./clipgeometry":140}],142:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=!1,o=function(){var t;return t=+new Date,function(e){var n;return n=+new Date-t,console.log(e,n+" ms"),n}},r=function(t){function e(){THREE.BufferGeometry.call(this),null==this.uniforms&&(this.uniforms={}),null==this.offsets&&(this.offsets=[]),i&&(this.tock=o()),this.chunked=!1,this.limit=65535}return s(e,t),e.prototype._reduce=function(t,e){var n,r,i,o,s,a,u;for(a=!1,r=i=0,o=t.length;o>i;r=++i)n=t[r],s=e[r],a&&(t[r]=s),n>1&&(a=!0);return u=t.reduce(function(t,e){return t*e})},e.prototype._emitter=function(t){var e,n,r,i,o,s,a,u;return n=this.attributes[t],r=n.itemSize,e=n.array,o=0,s=function(t){return e[o++]=t},u=function(t,n){return e[o++]=t,e[o++]=n},a=function(t,n,r){return e[o++]=t,e[o++]=n,e[o++]=r},i=function(t,n,r,i){return e[o++]=t,e[o++]=n,e[o++]=r,e[o++]=i},[null,s,u,a,i][r]},e.prototype._autochunk=function(){var t,e,n,r,i,o;n=this.attributes.index,o=this.attributes;for(r in o)if(e=o[r],"index"!==r&&n){i=e.array.length/e.itemSize,i>this.limit&&(this.chunked=!0);break}return this.chunked&&!n.u16?(n.u16=t=n.array,n.array=new Uint32Array(t.length)):void 0},e.prototype._finalize=function(){var t;if(this.chunked)return t=this.attributes.index,this.chunks=this._chunks(t.array,this.limit),this._chunkify(t,this.chunks),i?this.tock(this.constructor.name):void 0},e.prototype._chunks=function(t,e){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;for(i=[],f=0,g=t[0],o=t[0],v=function(t){var e,n,r;return r=3*f,n=3*t,e=n-r,i.push({index:g,start:r,count:e,end:n})},d=Math.floor(t.length/3),m=0,s=a=0,y=d;y>=0?y>a:a>y;s=y>=0?++a:--a)u=t[m++],l=t[m++],p=t[m++],c=Math.min(u,l,p),h=Math.max(u,l,p),n=Math.min(g,c),r=Math.max(o,h),r-n>e&&(v(s),n=c,r=h,f=s),g=n,o=r;return v(d),i},e.prototype._chunkify=function(t,e){var n,r,i,o,s,a,u,l,p,h;if(t.u16){for(r=t.array,h=t.u16,o=0,a=e.length;a>o;o++)for(n=e[o],u=n.index,i=s=l=n.start,p=n.end;p>=l?p>s:s>p;i=p>=l?++s:--s)h[i]=r[i]-u;return t.array=t.u16,delete t.u16}},e.prototype._offsets=function(t){var e,n,r,i,o,s,a,u,l,p,h,c;if(this.chunked)for(i=this.chunks,h=this.offsets,h.length=null,s=0,u=t.length;u>s;s++)for(p=t[s],c=p.start,o=p.count-c,a=0,l=i.length;l>a;a++)r=i[a],n=r.start,e=r.end,(n>=c&&o>n||e>c&&o>=e||c>n&&e>o)&&(n=Math.max(c,n),e=Math.min(o,e),h.push({index:r.index,start:n,count:e-n}));else this.offsets=t;return null},e}(THREE.BufferGeometry),e.exports=r},{}],143:[function(t,e,n){n.Geometry=t("./geometry"),n.ArrowGeometry=t("./arrowgeometry"),n.FaceGeometry=t("./facegeometry"),n.LineGeometry=t("./linegeometry"),n.ScreenGeometry=t("./screengeometry"),n.SpriteGeometry=t("./spritegeometry"),n.StripGeometry=t("./stripgeometry"),n.SurfaceGeometry=t("./surfacegeometry")},{"./arrowgeometry":139,"./facegeometry":141,"./geometry":142,"./linegeometry":144,"./screengeometry":145,"./spritegeometry":146,"./stripgeometry":147,"./surfacegeometry":148}],144:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./clipgeometry"),i=function(t){function e(t){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H,B,q,V,G,W,X,Y,Z,J,Q,$,K,tt,et;for(e.__super__.constructor.call(this,t),this._clipUniforms(),this.closed=o=t.closed||!1,this.samples=B=(+t.samples||2)+(o?1:0),this.strips=G=+t.strips||1,this.ribbons=F=+t.ribbons||1,this.layers=v=+t.layers||1,this.detail=s=+t.detail||1,g=B-1,this.joints=f=s-1,this.vertices=J=(g-1)*f+B,this.segments=q=(g-1)*f+g,$=B-(o?1:0),k=J*G*F*v*2,z=q*G*F*v,X=2*z,this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(3*X),1)),this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(4*k),4)),this.addAttribute("line",new THREE.BufferAttribute(new Float32Array(2*k),2)),this.addAttribute("strip",new THREE.BufferAttribute(new Float32Array(2*k),2)),s>1&&this.addAttribute("joint",new THREE.BufferAttribute(new Float32Array(k),1)),this._autochunk(),p=this._emitter("index"),E=this._emitter("position4"),y=this._emitter("line"),V=this._emitter("strip"),s>1&&(c=this._emitter("joint")),i=0,l=b=0,T=F*v;T>=0?T>b:b>T;l=T>=0?++b:--b)for(h=w=0,O=G;O>=0?O>w:w>O;h=O>=0?++w:--w){for(d=x=0,R=q;R>=0?R>x:x>R;d=R>=0?++x:--x)p(i),p(i+1),p(i+2),p(i+2),p(i+1),p(i+3),i+=2;i+=2}if(u=o?function(){return 0}:function(t){return 0===t?-1:t===B-1?1:0},s>1)for(m=S=0,C=v;C>=0?C>S:S>C;m=C>=0?++S:--S)for(et=M=0,I=F;I>=0?I>M:M>I;et=I>=0?++M:--M)for(tt=H=0,D=G;D>=0?D>H:H>D;tt=D>=0?++H:--H)for(K=W=0,L=B;L>=0?L>W:W>L;K=L>=0?++W:--W)if(o&&(K%=$),a=u(K),0!==a)E(K,tt,et,m),E(K,tt,et,m),y(a,1),y(a,-1),V(0,q),V(0,q),c(.5),c(.5);else for(_=Y=0,j=s;j>=0?j>Y:Y>j;_=j>=0?++Y:--Y)E(K,tt,et,m),E(K,tt,et,m),y(a,1),y(a,-1),V(0,q),V(0,q),c(_/f),c(_/f);else for(m=Z=0,N=v;N>=0?N>Z:Z>N;m=N>=0?++Z:--Z)for(et=Q=0,U=F;U>=0?U>Q:Q>U;et=U>=0?++Q:--Q)for(tt=n=0,A=G;A>=0?A>n:n>A;tt=A>=0?++n:--n)for(K=r=0,P=B;P>=0?P>r:r>P;K=P>=0?++r:--r)o&&(K%=$),a=u(K),E(K,tt,et,m),E(K,tt,et,m),y(a,1),y(a,-1),V(0,q),V(0,q);this._finalize(),this.clip()}return o(e,t),e.prototype.clip=function(t,e,n,r){var i,o;return null==t&&(t=this.samples-this.closed),null==e&&(e=this.strips),null==n&&(n=this.ribbons),null==r&&(r=this.layers),i=Math.max(0,t-(this.closed?0:1)),o=t+(t-2)*this.joints,i=o-1,this._clipGeometry(o,e,n,r),this._clipOffsets(6,i,e,n,r,this.segments,this.strips,this.ribbons,this.layers)},e}(r),e.exports=i},{"./clipgeometry":140}],145:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,
t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;i=t("./surfacegeometry"),r=function(t){function e(t){var n,r;null==this.uniforms&&(this.uniforms={}),this.uniforms.geometryScale={type:"v4",value:new THREE.Vector4},t.width=Math.max(2,null!=(n=+t.width)?n:2),t.height=Math.max(2,null!=(r=+t.height)?r:2),this.cover(),e.__super__.constructor.call(this,t)}return o(e,t),e.prototype.cover=function(t,e,n,r){this.scaleX=null!=t?t:1,this.scaleY=null!=e?e:1,this.scaleZ=null!=n?n:1,this.scaleW=null!=r?r:1},e.prototype.clip=function(t,n,r,i){var o;return null==t&&(t=this.width),null==n&&(n=this.height),null==r&&(r=this.surfaces),null==i&&(i=this.layers),e.__super__.clip.call(this,t,n,r,i),o=function(t){return 1/Math.max(1,t-1)},this.uniforms.geometryScale.value.set(o(t)*this.scaleX,o(n)*this.scaleY,o(r)*this.scaleZ,o(i)*this.scaleW)},e}(i),e.exports=r},{"./surfacegeometry":148}],146:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./clipgeometry"),i=function(t){function e(t){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P;for(e.__super__.constructor.call(this,t),this._clipUniforms(),this.items=a=+t.items||2,this.width=T=+t.width||1,this.height=i=+t.height||1,this.depth=r=+t.depth||1,E=a*T*i*r,v=4*E,z=2*E,this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(3*z),1)),this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(4*v),4)),this.addAttribute("sprite",new THREE.BufferAttribute(new Float32Array(2*v),2)),this._autochunk(),s=this._emitter("index"),y=this._emitter("position4"),S=this._emitter("sprite"),g=[[-1,-1],[-1,1],[1,-1],[1,1]],n=0,o=u=0,_=E;_>=0?_>u:u>_;o=_>=0?++u:--u)s(n),s(n+1),s(n+2),s(n+1),s(n+2),s(n+3),n+=4;for(P=l=0,b=r;b>=0?b>l:l>b;P=b>=0?++l:--l)for(A=c=0,w=i;w>=0?w>c:c>w;A=w>=0?++c:--c)for(O=f=0,x=T;x>=0?x>f:f>x;O=x>=0?++f:--f)for(p=d=0,k=a;k>=0?k>d:d>k;p=k>=0?++d:--d)for(m=0,h=g.length;h>m;m++)M=g[m],y(O,A,P,p),S(M[0],M[1]);this._finalize(),this.clip()}return o(e,t),e.prototype.clip=function(t,e,n,r){return null==t&&(t=this.width),null==e&&(e=this.height),null==n&&(n=this.depth),null==r&&(r=this.items),this._clipGeometry(t,e,n,r),this._clipOffsets(6,t,e,n,r,this.width,this.height,this.depth,this.items)},e}(r),e.exports=i},{"./clipgeometry":140}],147:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./clipgeometry"),i=function(t){function e(t){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I;for(e.__super__.constructor.call(this,t),this._clipUniforms(),this.items=u=+t.items||2,this.width=P=+t.width||1,this.height=o=+t.height||1,this.depth=r=+t.depth||1,this.sides=T=Math.max(0,u-2),M=P*o*r,y=u*M,A=T*M,this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(3*A),1)),this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(4*y),4)),this.addAttribute("strip",new THREE.BufferAttribute(new Float32Array(3*y),3)),this._autochunk(),a=this._emitter("index"),g=this._emitter("position4"),O=this._emitter("strip"),n=0,s=p=0,w=M;w>=0?w>p:p>w;s=w>=0?++p:--p){for(m=n,l=f=0,x=T;x>=0?x>f:f>x;l=x>=0?++f:--f)1&l?(a(m+1),a(m),a(m+2)):(a(m),a(m+1),a(m+2)),m++;n+=u}for(c=u-1,I=d=0,k=r;k>=0?k>d:d>k;I=k>=0?++d:--d)for(C=v=0,E=o;E>=0?E>v:v>E;C=E>=0?++v:--v)for(R=_=0,S=P;S>=0?S>_:_>S;R=S>=0?++_:--_){for(i=1,g(R,C,I,0),O(1,2,i),h=b=1,z=c;z>=1?z>b:b>z;h=z>=1?++b:--b)g(R,C,I,h),O(h-1,h+1,i=-i);g(R,C,I,c),O(c-2,c-1,-i)}this._finalize(),this.clip()}return o(e,t),e.prototype.clip=function(t,e,n,r){var i;return null==t&&(t=this.width),null==e&&(e=this.height),null==n&&(n=this.depth),null==r&&(r=this.items),i=Math.max(0,r-2),this._clipGeometry(t,e,n,r),this._clipOffsets(3,t,e,n,i,this.width,this.height,this.depth,this.sides)},e}(r),e.exports=i},{"./clipgeometry":140}],148:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./clipgeometry"),i=function(t){function e(t){var n,r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H,B,q;for(e.__super__.constructor.call(this,t),this._clipUniforms(),this.closedX=r=t.closedX||!1,this.closedY=i=t.closedY||!1,this.width=N=(+t.width||2)+(r?1:0),this.height=l=(+t.height||2)+(i?1:0),this.surfaces=L=+t.surfaces||1,this.layers=m=+t.layers||1,U=N-(r?1:0),F=l-(i?1:0),this.segmentsX=C=Math.max(0,N-1),this.segmentsY=I=Math.max(0,l-1),b=N*l*L*m,k=C*I*L*m,j=2*k,this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(3*j),1)),this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(4*b),4)),this.addAttribute("surface",new THREE.BufferAttribute(new Float32Array(2*b),2)),this._autochunk(),h=this._emitter("index"),w=this._emitter("position4"),D=this._emitter("surface"),n=0,p=v=0,S=L*m;S>=0?S>v:v>S;p=S>=0?++v:--v){for(c=y=0,z=I;z>=0?z>y:y>z;c=z>=0?++y:--y){for(f=g=0,M=C;M>=0?M>g:g>M;f=M>=0?++g:--g)h(n),h(n+1),h(n+N),h(n+N),h(n+1),h(n+N+1),n++;n++}n+=N}for(a=r?function(){return 0}:function(t){return 0===t?-1:t===C?1:0},u=i?function(){return 0}:function(t){return 0===t?-1:t===I?1:0},d=_=0,T=m;T>=0?T>_:_>T;d=T>=0?++_:--_)for(q=x=0,O=L;O>=0?O>x:x>O;q=O>=0?++x:--x)for(B=E=0,A=l;A>=0?A>E:E>A;B=A>=0?++E:--E)for(i&&(B%=F),s=u(B),H=R=0,P=N;P>=0?P>R:R>P;H=P>=0?++R:--R)r&&(H%=U),o=a(H),w(H,B,q,d),D(o,s);this._finalize(),this.clip()}return o(e,t),e.prototype.clip=function(t,e,n,r){var i,o;return null==t&&(t=this.width),null==e&&(e=this.height),null==n&&(n=this.surfaces),null==r&&(r=this.layers),i=Math.max(0,t-1),o=Math.max(0,e-1),this._clipGeometry(t,e,n,r),this._clipOffsets(6,i,o,n,r,this.segmentsX,this.segmentsY,this.surfaces,this.layers)},e.prototype.map=function(t,e,n,r){return null==t&&(t=this.width),null==e&&(e=this.height),null==n&&(n=this.surfaces),null==r&&(r=this.layers),this._clipMap(t,e,n,r)},e}(r),e.exports=i},{"./clipgeometry":140}],149:[function(t,e,n){n.Scene=t("./scene"),n.Factory=t("./factory"),n.Renderable=t("./scene"),n.Classes=t("./classes")},{"./classes":137,"./factory":138,"./scene":162}],150:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("./base"),i=t("../geometry").ArrowGeometry,r=function(t){function e(t,n,r){var o,s,a,u,l,p,h,c,f,d,m,v,y,g;e.__super__.constructor.call(this,t,n,r),y=r.uniforms,f=r.material,m=r.position,o=r.color,c=r.mask,h=r.map,s=r.combine,v=r.stpq,p=r.linear,null==y&&(y={}),l=null!=y.styleColor,this.geometry=new i({sides:r.sides,samples:r.samples,strips:r.strips,ribbons:r.ribbons,layers:r.layers,anchor:r.anchor,flip:r.flip}),this._adopt(y),this._adopt(this.geometry.uniforms),u=n.material(),g=u.vertex,g.pipe(this._vertexColor(o,c)),g.require(this._vertexPosition(m,f,h,1,v)),g.pipe("arrow.position",this.uniforms),g.pipe("project.position",this.uniforms),u.fragment=a=this._fragmentColor(l,f,o,c,h,1,v,s,p),a.pipe("fragment.color",this.uniforms),this.material=this._material(u.link({})),d=new THREE.Mesh(this.geometry,this.material),d.frustumCulled=!1,d.matrixAutoUpdate=!1,this._raw(d),this.renders=[d]}return s(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.renders=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(o),e.exports=r},{"../geometry":143,"./base":151}],151:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../renderable"),o=t("../../util"),r=function(t){function e(t,n,r){var i;e.__super__.constructor.call(this,t,n,r),this.zUnits=null!=(i=r.zUnits)?i:0}return s(e,t),e.prototype.raw=function(){var t,e,n,r;for(r=this.renders,t=0,e=r.length;e>t;t++)n=r[t],this._raw(n);return null},e.prototype.depth=function(t,e){var n,r,i,o;for(o=this.renders,n=0,r=o.length;r>n;n++)i=o[n],this._depth(i,t,e);return null},e.prototype.polygonOffset=function(t,e){var n,r,i,o;for(o=this.renders,n=0,r=o.length;r>n;n++)i=o[n],this._polygonOffset(i,t,e);return null},e.prototype.show=function(t,e,n){var r,i,o,s,a;for(s=this.renders,a=[],r=0,i=s.length;i>r;r++)o=s[r],a.push(this._show(o,t,e,n));return a},e.prototype.hide=function(){var t,e,n,r;for(r=this.renders,t=0,e=r.length;e>t;t++)n=r[t],this._hide(n);return null},e.prototype._material=function(t){var e,n,r,i,o,s,a,u;for(s=this.renderer.getPrecision(),u="    precision "+s+" float;\n    precision "+s+" int;\nuniform mat4 modelMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;",e="    precision "+s+" float;\n    precision "+s+" int;\nuniform mat4 viewMatrix;\nuniform vec3 cameraPosition;",o=new THREE.RawShaderMaterial(t),a=["vertexGraph","fragmentGraph"],n=0,i=a.length;i>n;n++)r=a[n],o[r]=t[r];return o.vertexShader=[u,o.vertexShader].join("\n"),o.fragmentShader=[e,o.fragmentShader].join("\n"),o},e.prototype._raw=function(t){return t.rotationAutoUpdate=!1,t.frustumCulled=!1,t.matrixAutoUpdate=!1,t.material.defaultAttributeValues=void 0},e.prototype._depth=function(t,e,n){var r;return r=t.material,r.depthWrite=e,r.depthTest=n},e.prototype._polygonOffset=function(t,e,n){var r,i;return n-=this.zUnits,r=0!==n,i=t.material,i.polygonOffset=r,r?(i.polygonOffsetFactor=e,i.polygonOffsetUnits=n):void 0},e.prototype._show=function(t,e,n,r){var i;return e=!0,i=t.material,t.renderOrder=-r,t.visible=!0,i.transparent=e,i.blending=n,null},e.prototype._hide=function(t){return t.visible=!1},e.prototype._vertexColor=function(t,e){var n;if(t||e)return n=this.shaders.shader(),t&&(n.require(t),n.pipe("mesh.vertex.color",this.uniforms)),e&&(n.require(e),n.pipe("mesh.vertex.mask",this.uniforms)),n},e.prototype._vertexPosition=function(t,e,n,r,i){var o,s;return s=this.shaders.shader(),(n||e&&e!==!0)&&(o={},(r>0||i)&&(o.POSITION_MAP=""),r>0&&(o[["POSITION_U","POSITION_UV","POSITION_UVW","POSITION_UVWO"][r-1]]=""),i&&(o.POSITION_STPQ="")),s.require(t),s.pipe("mesh.vertex.position",this.uniforms,o)},e.prototype._fragmentColor=function(t,e,n,r,i,s,a,u,l){var p,h,c,f;return h=this.shaders.shader(),f=!1,c=!1,p={},s>0&&(p[["POSITION_U","POSITION_UV","POSITION_UVW","POSITION_UVWO"][s-1]]=""),a&&(p.POSITION_STPQ=""),t&&(h.pipe("style.color",this.uniforms),f=!0,(n||i||e)&&((!l||n)&&h.pipe("mesh.gamma.in"),c=!0)),n&&(h.isolate(),h.pipe("mesh.fragment.color",this.uniforms),(!l||f)&&h.pipe("mesh.gamma.in"),h.end(),f&&h.pipe(o.GLSL.binaryOperator("vec4","*")),l&&f&&h.pipe("mesh.gamma.out"),f=!0,c=!0),i&&(!f&&u&&h.pipe(o.GLSL.constant("vec4","vec4(1.0)")),h.isolate(),h.require(i),h.pipe("mesh.fragment.map",this.uniforms,p),l||h.pipe("mesh.gamma.in"),h.end(),u?h.pipe(u):f&&h.pipe(o.GLSL.binaryOperator("vec4","*")),f=!0,c=!0),e&&(f||h.pipe(o.GLSL.constant("vec4","vec4(1.0)")),e===!0?h.pipe("mesh.fragment.shaded",this.uniforms):(h.require(e),h.pipe("mesh.fragment.material",this.uniforms,p)),c=!0),c&&!l&&h.pipe("mesh.gamma.out"),r&&(h.pipe("mesh.fragment.mask",this.uniforms),f&&h.pipe(o.GLSL.binaryOperator("vec4","*"))),h},e}(i),e.exports=r},{"../../util":175,"../renderable":161}],152:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./base"),i=function(t){function e(t,n,r){var i;e.__super__.constructor.call(this,t,n,r),this.geometry=new THREE.PlaneGeometry(1,1),this.material=new THREE.MeshBasicMaterial({map:r.map}),this.material.side=THREE.DoubleSide,i=new THREE.Mesh(this.geometry,this.material),i.position.x+=r.x||0,i.position.y+=r.y||0,i.frustumCulled=!1,i.scale.set(2,2,2),i.__debug=!0,this.objects=[i]}return o(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.objects=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"./base":151}],153:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./base"),o=t("../geometry").FaceGeometry,i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d,m,v,y,g;e.__super__.constructor.call(this,t,n,r),y=r.uniforms,f=r.material,m=r.position,i=r.color,c=r.mask,h=r.map,s=r.combine,v=r.stpq,p=r.linear,null==y&&(y={}),null==f&&(f=!0),l=null!=y.styleColor,this.geometry=new o({items:r.items,width:r.width,height:r.height,depth:r.depth}),this._adopt(y),this._adopt(this.geometry.uniforms),u=n.material(),g=u.vertex,g.pipe(this._vertexColor(i,c)),g.require(this._vertexPosition(m,f,h,2,v)),f||g.pipe("face.position",this.uniforms),f&&g.pipe("face.position.normal",this.uniforms),g.pipe("project.position",this.uniforms),u.fragment=a=this._fragmentColor(l,f,i,c,h,2,v,s,p),a.pipe("fragment.color",this.uniforms),this.material=this._material(u.link({side:THREE.DoubleSide})),d=new THREE.Mesh(this.geometry,this.material),this._raw(d),this.renders=[d]}return s(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.renders=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../geometry":143,"./base":151}],154:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./base"),o=t("../geometry").LineGeometry,i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S;e.__super__.constructor.call(this,t,n,r),E=r.uniforms,y=r.material,_=r.position,s=r.color,v=r.mask,m=r.map,a=r.combine,x=r.stpq,d=r.linear,i=r.clip,k=r.stroke,f=r.join,b=r.proximity,null==E&&(E={}),k=[null,"dotted","dashed"][k],c=null!=E.styleColor,f=null!=(w=["miter","round","bevel"][f])?w:"miter",l={miter:1,round:4,bevel:2}[f],this.geometry=new o({samples:r.samples,strips:r.strips,ribbons:r.ribbons,layers:r.layers,anchor:r.anchor,closed:r.closed,detail:l}),this._adopt(E),this._adopt(this.geometry.uniforms),h=n.material(),u={},k&&(u.LINE_STROKE=""),i&&(u.LINE_CLIP=""),null!=b&&(u.LINE_PROXIMITY=""),u["LINE_JOIN_"+f.toUpperCase()]="",l>1&&(u.LINE_JOIN_DETAIL=l),S=h.vertex,S.pipe(this._vertexColor(s,v)),S.require(this._vertexPosition(_,y,m,2,x)),S.pipe("line.position",this.uniforms,u),S.pipe("project.position",this.uniforms),p=h.fragment,k&&p.pipe("fragment.clip."+k,this.uniforms),i&&p.pipe("fragment.clip.ends",this.uniforms),null!=b&&p.pipe("fragment.clip.proximity",this.uniforms),p.pipe(this._fragmentColor(c,y,s,v,m,2,x,a,d)),p.pipe("fragment.color",this.uniforms),this.material=this._material(h.link({side:THREE.DoubleSide})),g=new THREE.Mesh(this.geometry,this.material),this._raw(g),this.renders=[g]}return s(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.renders=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../geometry":143,"./base":151}],155:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("./screen"),o=t("../../util"),r=function(t){function e(t,n,r){var i,o,s,a,u,l,p,h,c,f,d,m;for(this.memo=(l=r.items,m=r.width,o=r.height,i=r.depth,d=r.stpq,r),a=function(t){return 1/Math.max(1,t)},u=function(t){return 1/Math.max(1,t-1)},this.uniforms={remapUVScale:{type:"v2",value:new THREE.Vector2(l*m,o*i)},remapModulus:{type:"v2",value:new THREE.Vector2(l,o)},remapModulusInv:{type:"v2",value:new THREE.Vector2(a(l),a(o))},remapSTPQScale:{type:"v4",value:new THREE.Vector4(u(m),u(o),u(i),u(l))}},h=n.shader(),h.pipe("screen.map.xyzw",this.uniforms),null!=r.map&&(d&&h.pipe("screen.map.stpq",this.uniforms),h.pipe(r.map)),e.__super__.constructor.call(this,t,n,{map:h,linear:!0}),f=this.renders,s=0,p=f.length;p>s;s++)c=f[s],c.transparent=!1}return s(e,t),e.prototype.cover=function(t,e,n,r){var i,o,s;return null==t&&(t=this.memo.width),null==e&&(e=this.memo.height),null==n&&(n=this.memo.depth),null==r&&(r=this.memo.items),i=function(t){return 1/Math.max(1,t-1)},this.uniforms.remapSTPQScale.value.set(i(t),i(e),i(n),i(r)),o=t/this.memo.width,s=n/this.memo.depth,1===this.memo.depth&&(s=e/this.memo.height),this.geometry.cover(o,s)},e}(i),e.exports=r},{"../../util":175,"./screen":157}],156:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./base"),o=t("../geometry").SpriteGeometry,i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D;e.__super__.constructor.call(this,t,n,r),I=r.uniforms,b=r.material,E=r.position,u=r.color,R=r.size,_=r.mask,g=r.map,l=r.combine,y=r.linear,A=r.shape,w=r.optical,d=r.fill,C=r.stpq,null==I&&(I={}),A=null!=(S=+A)?S:0,null==d&&(d=!0),v=null!=I.styleColor,P=["circle","square","diamond","up","down","left","right"],k=["circle","generic","generic","generic","generic","generic","generic"],O=[1.2,1,1.414,1.16,1.16,1.16,1.16],x=null!=(z=k[A])?z:k[0],s=null!=(M=P[A])?M:P[0],i=null!=(T=w&&O[A])?T:1,a=d?x:x+".hollow",this.geometry=new o({items:r.items,width:r.width,height:r.height,depth:r.depth}),this._adopt(I),this._adopt(this.geometry.uniforms),p={POINT_SHAPE_SCALE:+(i+1e-5)},f=n.material(),D=f.vertex,D.pipe(this._vertexColor(u,_)),R?(D.isolate(),D.require(R),D.require("point.size.varying",this.uniforms),D.end()):D.require("point.size.uniform",this.uniforms),D.require(this._vertexPosition(E,b,g,2,C)),D.pipe("point.position",this.uniforms,p),D.pipe("project.position",this.uniforms),f.fragment=c=this._fragmentColor(v,b,u,_,g,2,C,l,y),h=n.material(),h.vertex.pipe(D),c=h.fragment.pipe(f.fragment),c.require("point.mask."+s,this.uniforms),c.require("point.alpha."+a,this.uniforms),c.pipe("point.edge",this.uniforms),m=n.material(),m.vertex.pipe(D),c=m.fragment.pipe(f.fragment),c.require("point.mask."+s,this.uniforms),c.require("point.alpha."+a,this.uniforms),c.pipe("point.fill",this.uniforms),this.fillMaterial=this._material(m.link({side:THREE.DoubleSide})),this.edgeMaterial=this._material(h.link({side:THREE.DoubleSide})),this.fillObject=new THREE.Mesh(this.geometry,this.fillMaterial),this.edgeObject=new THREE.Mesh(this.geometry,this.edgeMaterial),this._raw(this.fillObject),this._raw(this.edgeObject),this.renders=[this.fillObject,this.edgeObject]}return s(e,t),e.prototype.show=function(t,e,n,r){return this._show(this.edgeObject,!0,e,n,r),this._show(this.fillObject,t,e,n,r)},e.prototype.dispose=function(){return this.geometry.dispose(),this.edgeMaterial.dispose(),this.fillMaterial.dispose(),this.renders=this.edgeObject=this.fillObject=this.geometry=this.edgeMaterial=this.fillMaterial=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../geometry":143,"./base":151}],157:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;r=t("./base"),o=t("../geometry").ScreenGeometry,s=t("../../util"),i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d;e.__super__.constructor.call(this,t,n,r),f=r.uniforms,p=r.map,i=r.combine,c=r.stpq,l=r.linear,null==f&&(f={}),u=null!=f.styleColor,this.geometry=new o({width:r.width,height:r.height}),this._adopt(f),this._adopt(this.geometry.uniforms),a=n.material(),d=a.vertex,d.pipe("raw.position.scale",this.uniforms),d.fan(),d.pipe("stpq.xyzw.2d",this.uniforms),d.next(),d.pipe("screen.position",this.uniforms),d.join(),a.fragment=s=this._fragmentColor(u,!1,null,null,p,2,c,i,l),s.pipe("fragment.color",this.uniforms),this.material=this._material(a.link({side:THREE.DoubleSide})),h=new THREE.Mesh(this.geometry,this.material),h.frustumCulled=!1,this._raw(h),this.renders=[h]}return a(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.renders=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../../util":175,"../geometry":143,"./base":151}],158:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./base"),o=t("../geometry").SpriteGeometry,i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b;e.__super__.constructor.call(this,t,n,r),_=r.uniforms,m=r.material,v=r.position,y=r.sprite,f=r.map,s=r.combine,c=r.linear,i=r.color,d=r.mask,g=r.stpq,null==_&&(_={}),h=null!=_.styleColor,this.geometry=new o({items:r.items,width:r.width,height:r.height,depth:r.depth}),this._adopt(_),this._adopt(this.geometry.uniforms),l=n.material(),b=l.vertex,b.pipe(this._vertexColor(i,d)),b.require(this._vertexPosition(v,m,f,2,g)),b.require(y),b.pipe("sprite.position",this.uniforms),b.pipe("project.position",this.uniforms),l.fragment=u=this._fragmentColor(h,m,i,d,f,2,g,s,c),a=n.material(),a.vertex.pipe(b),a.fragment.pipe(u),a.fragment.pipe("fragment.transparent",this.uniforms),p=n.material(),p.vertex.pipe(b),p.fragment.pipe(u),p.fragment.pipe("fragment.solid",this.uniforms),this.fillMaterial=this._material(p.link({side:THREE.DoubleSide})),this.edgeMaterial=this._material(a.link({side:THREE.DoubleSide})),this.fillObject=new THREE.Mesh(this.geometry,this.fillMaterial),this.edgeObject=new THREE.Mesh(this.geometry,this.edgeMaterial),this._raw(this.fillObject),this._raw(this.edgeObject),this.renders=[this.fillObject,this.edgeObject]}return s(e,t),e.prototype.show=function(t,e,n,r){return this._show(this.edgeObject,!0,e,n,r),this._show(this.fillObject,t,e,n,r)},e.prototype.dispose=function(){return this.geometry.dispose(),this.edgeMaterial.dispose(),this.fillMaterial.dispose(),this.nreders=this.geometry=this.edgeMaterial=this.fillMaterial=this.edgeObject=this.fillObject=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../geometry":143,"./base":151}],159:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;r=t("./base"),o=t("../geometry").StripGeometry,i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d,m,v,y,g;e.__super__.constructor.call(this,t,n,r),y=r.uniforms,f=r.material,m=r.position,i=r.color,c=r.mask,h=r.map,s=r.combine,p=r.linear,v=r.stpq,null==y&&(y={}),null==f&&(f=!0),l=null!=y.styleColor,this.geometry=new o({items:r.items,width:r.width,height:r.height,depth:r.depth}),this._adopt(y),this._adopt(this.geometry.uniforms),u=n.material(),g=u.vertex,g.pipe(this._vertexColor(i,c)),g.require(this._vertexPosition(m,f,h,2,v)),f||g.pipe("mesh.position",this.uniforms),f&&g.pipe("strip.position.normal",this.uniforms),g.pipe("project.position",this.uniforms),u.fragment=a=this._fragmentColor(l,f,i,c,h,2,v,s,p),a.pipe("fragment.color",this.uniforms),this.material=this._material(u.link({side:THREE.DoubleSide})),d=new THREE.Mesh(this.geometry,this.material),this._raw(d),this.renders=[d]}return s(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.renders=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../geometry":143,"./base":151}],160:[function(t,e,n){var r,i,o,s,a=function(t,e){function n(){this.constructor=t}for(var r in e)u.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},u={}.hasOwnProperty;r=t("./base"),o=t("../geometry").SurfaceGeometry,s=t("../../util"),i=function(t){function e(t,n,r){var i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;e.__super__.constructor.call(this,t,n,r),b=r.uniforms,v=r.material,g=r.position,i=r.color,m=r.mask,d=r.map,s=r.combine,f=r.linear,_=r.stpq,c=r.intUV,null==b&&(b={}),null==v&&(v=!0),h=null!=b.styleColor,p=null!=b.surfaceHollow,this.geometry=new o({width:r.width,height:r.height,surfaces:r.surfaces,layers:r.layers,closedX:r.closedX,closedY:r.closedY}),this._adopt(b),this._adopt(this.geometry.uniforms),l=n.material(),w=l.vertex,c&&(a={POSITION_UV_INT:""}),w.pipe(this._vertexColor(i,m)),w.require(this._vertexPosition(g,v,d,2,_)),v||w.pipe("surface.position",this.uniforms,a),v&&w.pipe("surface.position.normal",this.uniforms,a),w.pipe("project.position",this.uniforms),l.fragment=u=this._fragmentColor(h,v,i,m,d,2,_,s,f),u.pipe("fragment.color",this.uniforms),this.material=this._material(l.link({side:THREE.DoubleSide})),y=new THREE.Mesh(this.geometry,this.material),this._raw(y),this.renders=[y]}return a(e,t),e.prototype.dispose=function(){return this.geometry.dispose(),this.material.dispose(),this.renders=this.geometry=this.material=null,e.__super__.dispose.apply(this,arguments)},e}(r),e.exports=i},{"../../util":175,"../geometry":143,"./base":151}],161:[function(t,e,n){var r;r=function(){function t(t,e){this.renderer=t,this.shaders=e,this.gl=this.renderer.context,null==this.uniforms&&(this.uniforms={})}return t.prototype.dispose=function(){return this.uniforms=null},t.prototype._adopt=function(t){var e,n;for(e in t)n=t[e],this.uniforms[e]=n},t.prototype._set=function(t){var e,n;for(e in t)n=t[e],null!=this.uniforms[e]&&(this.uniforms[e].value=n)},t}(),e.exports=r},{}],162:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty,u=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};i=t("./renderable"),r=function(t){function e(){e.__super__.constructor.apply(this,arguments),this.rotationAutoUpdate=!1,this.frustumCulled=!1,this.matrixAutoUpdate=!1}return s(e,t),e}(THREE.Object3D),o=function(t){function e(t,n,i){e.__super__.constructor.call(this,t,n,i),this.root=new r,null!=(null!=i?i.scene:void 0)&&(this.scene=i.scene),null==this.scene&&(this.scene=new THREE.Scene),this.pending=[],this.async=0,this.scratch=new THREE.WebGLRenderTarget(1,1),this.camera=new THREE.PerspectiveCamera}return s(e,t),e.prototype.inject=function(t){return null!=t&&(this.scene=t),this.scene.add(this.root)},e.prototype.unject=function(){var t;return null!=(t=this.scene)?t.remove(this.root):void 0},e.prototype.add=function(t){return this.async?this.pending.push(t):this._add(t)},e.prototype.remove=function(t){return this.pending=this.pending.filter(function(e){return e!==t}),null!=t.parent?this._remove(t):void 0},e.prototype._add=function(t){return this.root.add(t)},e.prototype._remove=function(t){return this.root.remove(t)},e.prototype.dispose=function(){return null!=this.root.parent?this.unject():void 0},e.prototype.warmup=function(t){return this.async=+t||0},e.prototype.render=function(){var t,e,n,r,i,o,s;if(this.pending.length){for(e=this.root.children,t=[],n=r=0,o=this.async;(o>=0?o>r:r>o)&&(i=this.pending.shift(),i);n=o>=0?++r:--r)this._add(i),t.push(t);return s=e.map(function(t){var e;return e=t.visible}),e.map(function(e){return e.visible=u.call(t,e)<0}),this.renderer.render(this.scene,this.camera,this.scratch),e.map(function(t,e){return t.visible=s[e]})}},e.prototype.toJSON=function(){return this.root.toJSON()},e}(i),e.exports=o},{"./renderable":161}],163:[function(t,e,n){var r,i;i=t("../../vendor/shadergraph/src"),r=function(t){var e;return e=function(e){var n,r,i,o,s;if(o=t[e],null!=o)return o;if(r="#"===(i=e[0])||"."===i||":"===i||"["===i,s=r?e:"#"+e,n=document.querySelector(s),null!=n&&"SCRIPT"===n.tagName)return n.textContent||n.innerText;throw new Error("Unknown shader `"+e+"`")},new i(e,{autoInspect:!0})},e.exports=r},{"../../vendor/shadergraph/src":208}],164:[function(t,e,n){n.Factory=t("./factory"),n.Snippets=t("../../build/shaders")},{"../../build/shaders":1,"./factory":163}],165:[function(t,e,n){THREE.Bootstrap.registerPlugin("splash",{defaults:{color:"mono",fancy:!0},listen:["ready","mathbox/init:init","mathbox/progress:progress","mathbox/destroy:destroy"],uninstall:function(){return this.destroy()},ready:function(t,e){return e.MathBox&&!this.div?init(t,e):void 0},init:function(t,e){var n,r,i,o,s,a,u;return this.destroy(),n=this.options.color,i='<div class="mathbox-loader mathbox-splash-'+n+'">\n  <div class="mathbox-logo">\n    <div> <div></div><div></div><div></div> </div>\n    <div> <div></div><div></div><div></div> </div>\n  </div>\n  <div class="mathbox-progress"><div></div></div>\n</div>',this.div=r=document.createElement("div"),r.innerHTML=i,e.element.appendChild(r),s=2*Math.random()-1,a=2*Math.random()-1,u=2*Math.random()-1,o=1/Math.sqrt(s*s+a*a+u*u),this.loader=r.querySelector(".mathbox-loader"),this.bar=r.querySelector(".mathbox-progress > div"),this.gyro=r.querySelectorAll(".mathbox-logo > div"),this.transforms=["rotateZ(22deg) rotateX(24deg) rotateY(30deg)","rotateZ(11deg) rotateX(12deg) rotateY(15deg) scale3d(.6, .6, .6)"],this.random=[s*o,a*o,u*o],this.start=e.Time.now,this.timer=null},progress:function(t,e){var n,r,i,o,s,a,u,l,p,h,c,f,d,m;if(this.div&&(n=t.current,c=t.total,f=c>n,clearTimeout(this.timer),f?(this.loader.classList.remove("mathbox-exit"),this.loader.style.display="block"):(this.loader.classList.add("mathbox-exit"),this.timer=setTimeout(function(t){return function(){return t.loader.style.display="none"}}(this),150)),m=c>n?.1*Math.round(1e3*n/c)+"%":"100%",this.bar.style.width=m,this.options.fancy)){for(d=this.random,i=Math.max(0,Math.min(1,e.Time.now-this.start)),s=function(t,n){return null==n&&(n=0),t.replace(/(-?[0-9.e]+)deg/g,function(t,r){return+r+d[n++]*i*e.Time.step*60+"deg"})},l=this.gyro,p=[],o=a=0,u=l.length;u>a;o=++a)r=l[o],this.transforms[o]=h=s(this.transforms[o]),p.push(r.style.transform=r.style.WebkitTransform=h);return p}},destroy:function(){var t;return null!=(t=this.div)&&t.remove(),this.div=null}})},{}],166:[function(t,e,n){var r,i,o;o=t("../util").Ease,i=function(){function t(t){this.context=t,this.anims=[]}return t.prototype.make=function(t,e){var n;return n=new r(this,this.context.time,t,e),this.anims.push(n),n},t.prototype.unmake=function(t){var e;return this.anims=function(){var n,r,i,o;for(i=this.anims,o=[],n=0,r=i.length;r>n;n++)e=i[n],e!==t&&o.push(e);return o}.call(this)},t.prototype.update=function(){var t,e;return e=this.context.time,this.anims=function(){var n,r,i,o;for(i=this.anims,o=[],n=0,r=i.length;r>n;n++)t=i[n],t.update(e)!==!1&&o.push(t);return o}.call(this)},t.prototype.lerp=function(t,e,n,r,i){var o,s,a,u;if(null==i&&(i=t.make()),t.lerp)i=t.lerp(e,n,i,r);else if(t.emitter){if(s=e.emitterFrom,u=n.emitterTo,null!=s&&null!=u&&s===u)return s.lerp(r),s;o=t.emitter(e,n),e.emitterFrom=o,n.emitterTo=o}else t.op?(a=function(t,e){return t===+t&&e===+e?t+(e-t)*r:r>.5?e:t},i=t.op(e,n,i,a)):i=r>.5?n:e;return i},t}(),r=function(){function t(t,e,n,r){this.animator=t,this.time=e,this.type=n,this.options=r,this.value=this.type.make(),this.target=this.type.make(),this.queue=[]}return t.prototype.dispose=function(){return this.animator.unmake(this)},t.prototype.set=function(){var t,e,n;return e=this.target,n=arguments.length>1?[].slice.call(arguments):arguments[0],t=!1,n=this.type.validate(n,e,function(){return t=!0}),t||(e=n),this.cancel(),this.target=this.value,this.value=e,this.notify()},t.prototype.getTime=function(){var t,e;return t=this.options.clock,e=t?t.getTime():this.time,
this.options.realtime?e.time:e.clock},t.prototype.cancel=function(t){var e,n,r,i,o,s;for(null==t&&(t=this.getTime()),o=this.queue,n=function(){var e,n,r;for(r=[],e=0,n=o.length;n>e;e++)s=o[e],s.end>=t&&r.push(s);return r}(),this.queue=function(){var e,n,r;for(r=[],e=0,n=o.length;n>e;e++)s=o[e],s.end<t&&r.push(s);return r}(),r=0,i=n.length;i>r;r++)s=n[r],"function"==typeof s.complete&&s.complete(!1);"function"==typeof(e=this.options).complete&&e.complete(!1)},t.prototype.notify=function(){var t;return"function"==typeof(t=this.options).step?t.step(this.value):void 0},t.prototype.immediate=function(t,e){var n,r,i,o,s,a,u,l,p,h;return i=e.duration,r=e.delay,o=e.ease,l=e.step,n=e.complete,h=this.getTime(),u=h+r,s=u+i,a=!1,p=this.type.make(),t=this.type.validate(t,p,function(){return a=!0,null}),void 0!==t&&(p=t),this.cancel(u),this.queue.push({from:null,to:p,start:u,end:s,ease:o,step:l,complete:n})},t.prototype.update=function(t){var e,n,r,i,s,a,u,l,p,h,c,f,d,m,v,y;if(this.time=t,0===this.queue.length)return!0;for(r=this.getTime(),y=this.value,h=this.queue,e=!1;!e;){if(c=f=h[0],l=c.from,v=c.to,d=c.start,a=c.end,m=c.step,i=c.complete,s=c.ease,null==l&&(l=f.from=this.type.clone(this.value)),u=o.clamp((r-d)/Math.max(1e-5,a-d)||0,0,1),0===u)return;if(p=function(){switch(s){case"linear":case 0:return null;case"cosine":case 1:return o.cosine;case"binary":case 2:return o.binary;case"hold":case 3:return o.hold;default:return o.cosine}}(),null!=p&&(u=p(u)),e=1>u,y=e?this.animator.lerp(this.type,l,v,u,y):v,"function"==typeof m&&m(y),!e&&("function"==typeof i&&i(!0),"function"==typeof(n=this.options).complete&&n.complete(!0),h.shift(),0===h.length))break}return this.value=y,this.notify()},t}(),e.exports=i},{"../util":175}],167:[function(t,e,n){var r,i;i=t("../util"),r=function(){function t(t,e,n){var r,i,o,s,a,u,l,p,h,c;for(this._context=t,this._up=e,this._targets=n,p=this._context.controller.getRoot(),null==this._targets&&(this._targets=[p]),this.isRoot=1===this._targets.length&&this._targets[0]===p,this.isLeaf=1===this._targets.length&&null==this._targets[0].children,u=this._targets,r=i=0,s=u.length;s>i;r=++i)h=u[r],this[r]=h;for(this.length=this._targets.length,l=this._context.controller.getTypes(),o=0,a=l.length;a>o;o++)c=l[o],"root"!==c&&!function(t){return function(e){return t[e]=function(n,r){return t.add(e,n,r)}}}(this)(c)}return t.prototype.v2=function(){return this},t.prototype.select=function(t){var e;return e=this._context.model.select(t,this.isRoot?null:this._targets),this._push(e)},t.prototype.eq=function(t){return this._targets.length>t?this._push([this._targets[t]]):this._push([])},t.prototype.filter=function(t){var e;return"string"==typeof t&&(e=this._context.model._matcher(t),t=function(t){return e(t)}),this._push(this._targets.filter(t))},t.prototype.map=function(t){var e,n,r,i;for(i=[],e=n=0,r=this.length;r>=0?r>n:n>r;e=r>=0?++n:--n)i.push(t(this[e],e,this));return i},t.prototype.each=function(t){var e,n,r;for(e=n=0,r=this.length;r>=0?r>n:n>r;e=r>=0?++n:--n)t(this[e],e,this);return this},t.prototype.add=function(t,e,n){var r,i,o,s,a,u,l;if(r=this._context.controller,this.isLeaf)return this._pop().add(t,e,n);for(a=[],u=this._targets,i=0,o=u.length;o>i;i++)l=u[i],s=r.make(t,e,n),r.add(s,l),a.push(s);return this._push(a)},t.prototype.remove=function(t){var e,n,r,i;if(t)return this.select(t).remove();for(r=this._targets.slice().reverse(),e=0,n=r.length;n>e;e++)i=r[e],this._context.controller.remove(i);return this._pop()},t.prototype.set=function(t,e){var n,r,i,o;for(i=this._targets,n=0,r=i.length;r>n;n++)o=i[n],this._context.controller.set(o,t,e);return this},t.prototype.getAll=function(t){var e,n,r,i,o;for(r=this._targets,i=[],e=0,n=r.length;n>e;e++)o=r[e],i.push(this._context.controller.get(o,t));return i},t.prototype.get=function(t){var e;return null!=(e=this._targets[0])?e.get(t):void 0},t.prototype.evaluate=function(t,e){var n;return null!=(n=this._targets[0])?n.evaluate(t,e):void 0},t.prototype.bind=function(t,e){var n,r,i,o;for(i=this._targets,n=0,r=i.length;r>n;n++)o=i[n],this._context.controller.bind(o,t,e);return this},t.prototype.unbind=function(t){var e,n,r,i;for(r=this._targets,e=0,n=r.length;n>e;e++)i=r[e],this._context.controller.unbind(i,t);return this},t.prototype.end=function(){return(this.isLeaf?this._pop():this)._pop()},t.prototype._push=function(e){return new t(this._context,this,e)},t.prototype._pop=function(){var t;return null!=(t=this._up)?t:this},t.prototype._reset=function(){var t,e;return null!=(t=null!=(e=this._up)?e.reset():void 0)?t:this},t.prototype.map=function(t){return this._targets.map(t)},t.prototype.on=function(){var t;return t=arguments,this._targets.map(function(e){return e.on.apply(e,t)}),this},t.prototype.off=function(){var t;return t=arguments,this._targets.map(function(e){return e.on.apply(e,t)}),this},t.prototype.toString=function(){var t;return t=this._targets.map(function(t){return t.toString()}),this._targets.length>1?"["+t.join(", ")+"]":t[0]},t.prototype.toMarkup=function(){var t;return t=this._targets.map(function(t){return t.toMarkup()}),t.join("\n\n")},t.prototype.print=function(){return i.Pretty.print(this._targets.map(function(t){return t.toMarkup()}).join("\n\n")),this},t.prototype.debug=function(){var t,e,n,r,i,o,s,a;for(e=this.inspect(),console.log("Renderables: ",e.renderables),console.log("Renders: ",e.renders),console.log("Shaders: ",e.shaders),t=function(t){return t.constructor.toString().match("function +([^(]*)")[1]},a=[],o=e.shaders,n=0,r=o.length;r>n;n++)s=o[n],i=t(s.owner),a.push(i+" - Vertex"),a.push(s.vertex),a.push(i+" - Fragment"),a.push(s.fragment);return ShaderGraph.inspect(a)},t.prototype.inspect=function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m;for("boolean"==typeof e&&(n=e,e=null),null==n&&(n=!0),p=function(t){var e,n;return null!=(e=null!=(n=t.controller)?n.objects:void 0)?e:[]},h=d=function(t,n){var r,i,o,s;if(null==n&&(n=[]),(!e||t.traits.hash[e])&&n.push(p(t)),null!=t.children)for(s=t.children,i=0,o=s.length;o>i;i++)r=s[i],d(r,n);return n},i=function(t){return t=t.reduce(function(t,e){return t.concat(e)},[]),t=t.filter(function(e,n){return null!=e&&t.indexOf(e)===n})},l=function(t,e){var n;return n={},n.owner=t,n.geometry=e.geometry,n.material=e.material,n.vertex=e.material.vertexGraph,n.fragment=e.material.fragmentGraph,n},o={nodes:this._targets.slice(),renderables:[],renders:[],shaders:[]},c=this._targets,s=0,u=c.length;u>s;s++){m=c[s],n&&m.print(t,"info"),r={renderables:f=i(h(m)),renders:i(f.map(function(t){return t.renders})),shaders:i(f.map(function(t){var e;return null!=(e=t.renders)?e.map(function(e){return l(t,e)}):void 0}))};for(a in r)o[a]=o[a].concat(r[a])}return o},t}(),e.exports=r},{"../util":175}],168:[function(t,e,n){var r,i;i=t("../util"),r=function(){function t(t,e){this.model=t,this.primitives=e}return t.prototype.getRoot=function(){return this.model.getRoot()},t.prototype.getTypes=function(){return this.primitives.getTypes()},t.prototype.make=function(t,e,n){return this.primitives.make(t,e,n)},t.prototype.get=function(t,e){return t.get(e)},t.prototype.set=function(t,e,n){var r,i;try{return t.set(e,n)}catch(i){return r=i,t.print(null,"warn"),console.error(r)}},t.prototype.bind=function(t,e,n){var r,i;try{return t.bind(e,n)}catch(i){return r=i,t.print(null,"warn"),console.error(r)}},t.prototype.unbind=function(t,e){var n,r;try{return t.unbind(e)}catch(r){return n=r,t.print(null,"warn"),console.error(n)}},t.prototype.add=function(t,e){return null==e&&(e=this.model.getRoot()),e.add(t)},t.prototype.remove=function(t){var e;return e=t.parent,e?e.remove(t):void 0},t}(),e.exports=r},{"../util":175}],169:[function(t,e,n){n.Animator=t("./animator"),n.API=t("./api"),n.Controller=t("./controller")},{"./animator":166,"./api":167,"./controller":168}],170:[function(t,e,n){var r=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};n.setOrigin=function(t,e,n){var i,o,s,a;return+e===e&&(e=[e]),o=r.call(e,1)>=0?0:n.x,s=r.call(e,2)>=0?0:n.y,a=r.call(e,3)>=0?0:n.z,i=r.call(e,4)>=0?0:n.w,t.set(o,s,a,i)},n.addOrigin=function(){var t;return t=new THREE.Vector4,function(e,r,i){return n.setOrigin(t,r,i),e.add(t)}}(),n.setDimension=function(t,e){var n,r,i,o;return r=1===e?1:0,i=2===e?1:0,o=3===e?1:0,n=4===e?1:0,t.set(r,i,o,n)},n.setDimensionNormal=function(t,e){var n,r,i,o;return r=1===e?1:0,i=2===e?1:0,o=3===e?1:0,n=4===e?1:0,t.set(i,o+r,n,0)},n.recenterAxis=function(){var t;return t=[0,0],function(e,n,r,i){var o,s,a,u,l,p;return null==i&&(i=0),r>0&&(l=e,p=e+n,o=Math.max(Math.abs(l),Math.abs(p)),s=o*i,u=Math.min(l,p),a=Math.max(l,p),e=u+(-o+s-u)*r,n=a+(o+s-a)*r-e),t[0]=e,t[1]=n,t}}()},{}],171:[function(t,e,n){e.exports=self={bind:function(t,e){return function(n,r){r.__binds||(r.__binds=[]);var i=t;_.isArray(n)&&(i=n[0],n=n[1]);for(var o=/^([^.:]*(?:\.[^.:]+)*)?(?:\:(.*))?$/.exec(n),s=o[1].split(/\./g),a=s.pop(),u=o[2]||a,l=s.shift(),p={"this":r}[l]||e[l]||t[l]||i;p&&(n=s.shift());)p=p[n];if(p&&(p.on||p.addEventListener)){var h=function(e){r[u]&&r[u](e,t)};self._polyfill(p,["addEventListener","on"],function(t){p[t](a,h)});var c={target:p,name:a,callback:h};return r.__binds.push(c),h}throw"Cannot bind '"+n+"' in "+this.__name}},unbind:function(){return function(t){t.__binds&&(t.__binds.forEach(function(t){self._polyfill(t.target,["removeEventListener","off"],function(e){t.target[e](t.name,t.callback)})}.bind(this)),t.__binds=[])}},apply:function(t){THREE.EventDispatcher.prototype.apply(t),t.trigger=self._trigger,t.triggerOnce=self._triggerOnce,t.on=t.addEventListener,t.off=t.removeEventListener,t.dispatchEvent=t.trigger},_triggerOnce:function(t){this.trigger(t),this._listeners&&delete this._listeners[t.type]},_trigger:function(t){if(void 0!==this._listeners){var e=t.type,n=this._listeners[e];if(void 0!==n){n=n.slice();var r=n.length;t.target=this;for(var i=0;r>i;i++)n[i].call(this,t,this)}}},_polyfill:function(t,e,n){e.map(function(e){return t.method}),e.length&&n(e[0])}}},{}],172:[function(t,e,n){var r;n.getSizes=r=function(t){var e,n;for(n=[],e=t;"string"!=typeof e&&null!=(null!=e?e.length:void 0);)n.push(e.length),e=e[0];return n},n.getDimensions=function(t,e){var n,i,o,s,a,u,l,p,h,c,f,d,m,v,y;return null==e&&(e={}),a=e.items,n=e.channels,y=e.width,s=e.height,i=e.depth,o={},t&&t.length?(v=r(t),p=v.length,o.channels=1!==n&&v.length>1?v.pop():n,o.items=1!==a&&v.length>1?v.pop():a,o.width=1!==y&&v.length>1?v.pop():y,o.height=1!==s&&v.length>1?v.pop():s,o.depth=1!==i&&v.length>1?v.pop():i,u=p,1===n&&u++,1===a&&u>1&&u++,1===y&&u>2&&u++,1===s&&u>3&&u++,l=null!=(h=v.pop())?h:1,1>=u&&(l/=null!=(c=o.channels)?c:1),2>=u&&(l/=null!=(f=o.items)?f:1),3>=u&&(l/=null!=(d=o.width)?d:1),4>=u&&(l/=null!=(m=o.height)?m:1),l=Math.floor(l),null==o.width&&(o.width=l,l=1),null==o.height&&(o.height=l,l=1),null==o.depth&&(o.depth=l,l=1),o):{items:a,channels:n,width:null!=y?y:0,height:null!=s?s:0,depth:null!=i?i:0}},n.repeatCall=function(t,e){switch(e){case 0:return function(){return!0};case 1:return function(){return t()};case 2:return function(){return t(),t()};case 3:return function(){return t(),t(),t(),t()};case 4:return function(){return t(),t(),t(),t()};case 6:return function(){return t(),t(),t(),t(),t(),t()};case 8:return function(){return t(),t(),t(),t(),t(),t()}}},n.makeEmitter=function(t,e,n){var r,i,o,s;for(r=function(){switch(n){case 0:return function(){return!0};case 1:return function(e){return e(t())};case 2:return function(e){return e(t(),t())};case 3:return function(e){return e(t(),t(),t())};case 4:return function(e){return e(t(),t(),t(),t())};case 6:return function(e){return e(t(),t(),t(),t(),t(),t())};case 8:return function(e){return e(t(),t(),t(),t(),t(),t(),t(),t())}}}(),o=null;e>0;)i=Math.min(e,8),s=function(){switch(i){case 1:return function(t){return r(t)};case 2:return function(t){return r(t),r(t)};case 3:return function(t){return r(t),r(t),r(t)};case 4:return function(t){return r(t),r(t),r(t),r(t)};case 5:return function(t){return r(t),r(t),r(t),r(t),r(t)};case 6:return function(t){return r(t),r(t),r(t),r(t),r(t),r(t)};case 7:return function(t){return r(t),r(t),r(t),r(t),r(t),r(t),r(t)};case 8:return function(t){return r(t),r(t),r(t),r(t),r(t),r(t),r(t),r(t)}}}(),o=null!=o?function(t,e){return function(n){return t(n),e(n)}}(s,o):s,e-=i;return s=null!=o?o:function(){return!0},s.reset=t.reset,s.rebind=t.rebind,s},n.getThunk=function(t){var e,n,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T;switch(z=r(t),d=z.length,e=z.pop(),n=z.pop(),i=z.pop(),o=z.pop(),s=!1,d){case 0:T=function(){return 0},T.reset=function(){};break;case 1:l=0,T=function(){return t[l++]},T.reset=function(){return l=0};break;case 2:l=p=0,a=null!=(m=t[p])?m:[],T=function(){var n,r;return r=a[l++],l===e&&(l=0,p++,a=null!=(n=t[p])?n:[]),r},T.reset=function(){var e;l=p=0,a=null!=(e=t[p])?e:[]};break;case 3:l=p=h=0,S=null!=(v=t[h])?v:[],a=null!=(y=S[p])?y:[],T=function(){var r,i,o;return o=a[l++],l===e&&(l=0,p++,p===n&&(p=0,h++,S=null!=(r=t[h])?r:[]),a=null!=(i=S[p])?i:[]),o},T.reset=function(){var e,n;l=p=h=0,S=null!=(e=t[h])?e:[],a=null!=(n=S[p])?n:[]};break;case 4:l=p=h=c=0,M=null!=(g=t[c])?g:[],S=null!=(_=M[h])?_:[],a=null!=(b=S[p])?b:[],T=function(){var r,o,s,u;return u=a[l++],l===e&&(l=0,p++,p===n&&(p=0,h++,h===i&&(h=0,c++,M=null!=(r=t[c])?r:[]),S=null!=(o=M[h])?o:[]),a=null!=(s=S[p])?s:[]),u},T.reset=function(){var e,n,r;l=p=h=c=0,M=null!=(e=t[c])?e:[],S=null!=(n=M[h])?n:[],a=null!=(r=S[p])?r:[]};break;case 5:l=p=h=c=f=0,u=null!=(w=t[f])?w:[],M=null!=(x=u[c])?x:[],S=null!=(k=M[h])?k:[],a=null!=(E=S[p])?E:[],T=function(){var r,s,d,m,v;return v=a[l++],l===e&&(l=0,p++,p===n&&(p=0,h++,h===i&&(h=0,c++,c===o&&(c=0,f++,u=null!=(r=t[f])?r:[]),M=null!=(s=u[c])?s:[]),S=null!=(d=M[h])?d:[]),a=null!=(m=S[p])?m:[]),v},T.reset=function(){var e,n,r,i;l=p=h=c=f=0,u=null!=(e=t[f])?e:[],M=null!=(n=u[c])?n:[],S=null!=(r=M[h])?r:[],a=null!=(i=S[p])?i:[]}}return T.rebind=function(o){return t=o,z=r(t),z.length&&(e=z.pop()),z.length&&(n=z.pop()),z.length&&(i=z.pop()),z.length?o=z.pop():void 0},T},n.getStreamer=function(t,e,n,r){var i,o,s,a,u,l,p,h,c;return p=u=l=0,h=function(){return p=e*n*r,u=l=0},o=function(){return l},s=function(){return 0>=p-u},c=function(){switch(n){case 1:return function(t){u+=t,l+=t};case 2:return function(t){u+=2*t,l+=t};case 3:return function(t){u+=3*t,l+=t};case 4:return function(t){u+=4*t,l+=t}}}(),i=function(){switch(n){case 1:return function(e){e(t[u++]),++l};case 2:return function(e){e(t[u++],t[u++]),++l};case 3:return function(e){e(t[u++],t[u++],t[u++]),++l};case 4:return function(e){e(t[u++],t[u++],t[u++],t[u++]),++l}}}(),a=function(){switch(n){case 1:return function(e){t[u++]=e,++l};case 2:return function(e,n){t[u++]=e,t[u++]=n,++l};case 3:return function(e,n,r){t[u++]=e,t[u++]=n,t[u++]=r,++l};case 4:return function(e,n,r,i){t[u++]=e,t[u++]=n,t[u++]=r,t[u++]=i,++l}}}(),i.reset=h,a.reset=h,h(),{emit:a,consume:i,skip:c,count:o,done:s,reset:h}},n.getLerpEmitter=function(t,e){var n,r,i,o,s,a,u,l,p,h,c;return c=new Float32Array(4096),s=a=.5,u=l=p=h=0,r=function(t,e,n,r){return p++,c[u++]=t*s,c[u++]=e*s,c[u++]=n*s,c[u++]=r*s},i=function(t,e,n,r){return h++,c[l++]+=t*a,c[l++]+=e*a,c[l++]+=n*a,c[l++]+=r*a},n=Math.max(t.length,e.length),o=3>=n?function(n,o,s){var a,f,d,m,v,y;for(u=l=p=h=0,t(r,o,s),e(i,o,s),d=Math.min(p,h),f=0,y=[],a=m=0,v=d;v>=0?v>m:m>v;a=v>=0?++m:--m)y.push(n(c[f++],c[f++],c[f++],c[f++]));return y}:5>=n?function(n,o,s,a,f){var d,m,v,y,g,_;for(u=l=p=h=0,t(r,o,s,a,f),e(i,o,s,a,f),v=Math.min(p,h),m=0,_=[],d=y=0,g=v;g>=0?g>y:y>g;d=g>=0?++y:--y)_.push(n(c[m++],c[m++],c[m++],c[m++]));return _}:7>=n?function(n,o,s,a,f,d,m){var v,y,g,_,b;for(u=l=p=h=0,t(r,o,s,a,f,d,m),e(i,o,s,a,f,d,m),y=Math.min(p,h),v=0,b=[],m=g=0,_=y;_>=0?_>g:g>_;m=_>=0?++g:--g)b.push(n(c[v++],c[v++],c[v++],c[v++]));return b}:9>=n?function(n,o,s,a,f,d,m,v,y){var g,_,b,w;for(u=l=p=h=0,t(r,o,s,a,f,d,m,v,y),e(i,o,s,a,f,d,m,v,y),g=Math.min(p,h),y=0,w=[],v=_=0,b=g;b>=0?b>_:_>b;v=b>=0?++_:--_)w.push(n(c[y++],c[y++],c[y++],c[y++]));return w}:function(n,o,s,a,f,d,m,v,y,g,_){var b,w,x,k;for(u=l=0,t(r,o,s,a,f,d,m,v,y,g,_),e(i,o,s,a,f,d,m,v,y,g,_),b=Math.min(p,h),y=0,k=[],v=w=0,x=b;x>=0?x>w:w>x;v=x>=0?++w:--w)k.push(n(c[y++],c[y++],c[y++],c[y++]));return k},o.lerp=function(t){var e;return e=[1-t,t],s=e[0],a=e[1],e},o},n.getLerpThunk=function(t,e){var r,i,o,s,a,u;return i=n.getSizes(t).reduce(function(t,e){return t*e}),o=n.getSizes(e).reduce(function(t,e){return t*e}),r=Math.min(i,o),a=n.getThunk(t),u=n.getThunk(e),s=new Float32Array(r),s.lerp=function(t){var e,n,i,o;for(a.reset(),u.reset(),i=0,o=[];r>i;)e=a(),n=u(),o.push(s[i++]=e+(n-e)*t);return o},s}},{}],173:[function(t,e,n){var r,i;i=Math.PI,r={clamp:function(t,e,n){return Math.max(e,Math.min(n,t))},cosine:function(t){return.5-.5*Math.cos(r.clamp(t,0,1)*i)},binary:function(t){return+(t>=.5)},hold:function(t){return+(t>=1)}},e.exports=r},{}],174:[function(t,e,n){var r,i,o,s,a,u=[].indexOf||function(t){for(var e=0,n=this.length;n>e;e++)if(e in this&&this[e]===t)return e;return-1};i="xyzw".split(""),r={0:-1,x:0,y:1,z:2,w:3},o=function(t){return t===""+t&&(t=t.split("")),t===+t&&(t=[t]),t},a=function(t){return t===+t&&(t="vec"+t),"vec1"===t&&(t="float"),t},s=function(t){return t=""+t,t.indexOf(".")<0?t+=".0":void 0},n.mapByte2FloatOffset=function(t){var e;return null==t&&(t=4),e=s(t),"vec4 float2ByteIndex(vec4 xyzw, out float channelIndex) {\n  float relative = xyzw.w / "+e+";\n  float w = floor(relative);\n  channelIndex = (relative - w) * "+e+";\n  return vec4(xyzw.xyz, w);\n}"},n.sample2DArray=function(t){var e,n;return n=function(t,e){var r,i;return t===e?i="return texture2D(dataTextures["+t+"], uv);":(r=Math.ceil(t+(e-t)/2),i="if (z < "+(r-.5)+") {\n  "+n(t,r-1)+"\n}\nelse {\n  "+n(r,e)+"\n}"),i=i.replace(/\n/g,"\n  ")},e=n(0,t-1),"uniform sampler2D dataTextures["+t+"];\n\nvec4 sample2DArray(vec2 uv, float z) {\n  "+e+"\n}"},n.binaryOperator=function(t,e,n){return t=a(t),null!=n?t+" binaryOperator("+t+" a) {\n  return a "+e+" "+n+";\n}":t+" binaryOperator("+t+" a, "+t+" b) {\n  return a "+e+" b;\n}"},n.extendVec=function(t,e,r){var i,o,u,l;return null==r&&(r=0),t>e?n.truncateVec(t,e):(o=e-t,t=a(t),e=a(e),r=s(r),u=function(){l=[];for(var t=0;o>=0?o>=t:t>=o;o>=0?t++:t--)l.push(t);return l}.apply(this).map(function(t){return t?r:"v"}),i=u.join(","),e+" extendVec("+t+" v) { return "+e+"("+i+"); }")},n.truncateVec=function(t,e){var r;return e>t?n.extendVec(t,e):(r="."+"xyzw".substr(0,e),t=a(t),e=a(e),e+" truncateVec("+t+" v) { return v"+r+"; }")},n.injectVec4=function(t){var e,n,i,s,a,u,l;for(l=["0.0","0.0","0.0","0.0"],t=o(t),t=t.map(function(t){return t===""+t?r[t]:t}),i=s=0,a=t.length;a>s;i=++s)n=t[i],l[n]=["a","b","c","d"][i];return u=l.slice(0,4).join(", "),e=["float a","float b","float c","float d"].slice(0,t.length),"vec4 inject("+e+") {\n  return vec4("+u+");\n}"},n.swizzleVec4=function(t,e){var n,i;for(null==e&&(e=null),n=["0.0","xyzw.x","xyzw.y","xyzw.z","xyzw.w"],null==e&&(e=t.length),t=o(t),t=t.map(function(t){var e;return e=+t,u.call([0,1,2,3,4],e)>=0&&(t=+t),t===""+t&&(t=r[t]+1),n[t]});t.length<e;)t.push("0.0");return i=t.join(", "),("vec"+e+" swizzle(vec4 xyzw) {\n  return vec"+e+"("+i+");\n}").replace(/vec1/g,"float")},n.invertSwizzleVec4=function(t){var e,n,s,a,u,l,p,h;for(h=["0.0","0.0","0.0","0.0"],t=o(t),t=t.map(function(t){return t===+t?i[t-1]:t}),e=s=0,a=t.length;a>s;e=++s)u=t[e],p=i[e],n=r[u],h[n]="xyzw."+p;return l=h.join(", "),"vec4 invertSwizzle(vec4 xyzw) {\n  return vec4("+l+");\n}"},n.identity=function(t){var e;return e=[].slice.call(arguments),e.length>1?(e=e.map(function(t,e){return["inout",t,String.fromCharCode(97+e)].join(" ")}),e=e.join(", "),"void identity("+e+") { }"):t+" identity("+t+" x) {\n  return x;\n}"},n.constant=function(t,e){return t+" constant() {\n  return "+e+";\n}"},n.toType=a},{}],175:[function(t,e,n){n.Axis=t("./axis"),n.Data=t("./data"),n.Ease=t("./ease"),n.GLSL=t("./glsl"),n.JS=t("./js"),n.Pretty=t("./pretty"),n.Three=t("./three"),n.Ticks=t("./ticks"),n.VDOM=t("./vdom")},{"./axis":170,"./data":172,"./ease":173,"./glsl":174,"./js":176,"./pretty":177,"./three":178,"./ticks":179,"./vdom":180}],176:[function(t,e,n){n.merge=function(){var t,e,n,r,i,o;for(o={},t=0,n=arguments.length;n>t;t++){r=arguments[t];for(e in r)i=r[e],o[e]=i}return o},n.clone=function(t){return JSON.parse(JSON.serialize(t))},n.parseQuoted=function(t){var e,n,r,i,o,s,a,u,l,p;for(e="",p=function(t){return t=t.replace(/\\/g,"")},a=function(t){return e.length&&s.push(p(e)),e=null!=t?t:""},t=t.split(/(?=(?:\\.|["' ,]))/g),u=!1,s=[],i=0,o=t.length;o>i;i++)switch(r=t[i],n=r[0],l=r.slice(1),n){case'"':case"'":if(u)u===n?(u=!1,a(l)):e+=r;else{if(""!==e)throw new Error("ParseError: String `"+t+"` does not contain comma-separated quoted tokens.");u=n,e+=l}break;case" ":case",":u?e+=r:a(l);break;default:e+=r}return a(),s}},{}],177:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;r=5,i=1e-4,o=function(t,e){return Math.abs(t/e-Math.round(t/e))<i},s=function(t){return o(t,1)},p=function(t,e,n,r){var i;return i=Math.round(t/e),1===i?""+n:-1===i?"-"+n:"1"===n?""+i:r?""+i+n:i+"*"+n},l=function(t,e,n,r){var i;return i=Math.round(t*e),1===Math.abs(i)?(i=0>i?"-":"",i+=n):"1"!==n&&(i+=r?""+n:"*"+n),i+"/"+e},u=[{1:1},{1:1,"τ":2*Math.PI},{1:1,"π":Math.PI},{1:1,"τ":2*Math.PI,"π":Math.PI},{1:1,e:Math.E},{1:1,"τ":2*Math.PI,e:Math.E},{1:1,"π":Math.PI,e:Math.E},{1:1,"τ":2*Math.PI,"π":Math.PI,e:Math.E}],h=[[420,[2,3,5,7]],[88200,[2,3,5,7]],[60060,[2,3,5,7,11,13]],[861764,[2,17,19,23,29]],[65536,[2]],[1e6,[2,5]]],y=function(t){var e,n,o,a,c,f,d,m,v,y;return t&&(e=t.cache,o=t.compact,v=t.tau,d=t.pi,a=t.e,y=t.threshold,m=t.precision),o=+!!(null!=o?o:!0),v=+!!(null!=v?v:!0),d=+!!(null!=d?d:!0),a=+!!(null!=a?a:!0),e=+!!(null!=e?e:!0),y=+(null!=y?y:i),m=+(null!=m?m:r),c=v+2*d+4*a,n=c+y+m,f=e?{}:null,function(t){var e,n,i,a,d,m,v,y,g,_,b,w,x,k,E,S,z,M;if(null!=f){if(null!=(n=f[t]))return n;if(t===Math.round(t))return f[t]=""+t}E=""+t,e=E.length+E.indexOf(".")+2,w=function(t){var n;return n=t.length,e>=n?(E=""+t,e=n):void 0},z=u[c];for(y in z)if(d=z[y],s(t/d))w(""+p(t/d,1,y,o));else for(m=0,g=h.length;g>m;m++)if(M=h[m],a=M[0],b=M[1],k=t/d*a,s(k)){for(v=0,_=b.length;_>v;v++)for(S=b[v];s(x=k/S)&&s(i=a/S);)k=x,a=i;w(""+l(t/d,a,y,o));break}return(""+t).length>r&&w(""+t.toPrecision(r)),null!=f&&(f[t]=E),E}},g=function(t,e){return null==e&&(e="info"),t=v(t),console[e].apply(console,t)},v=function(t){var e,n,r,i,o,s,a,u;return a="color:rgb(128,0,128)",n="color:rgb(144,64,0)",s="color:rgb(0,0,192)",i="color:rgb(0,70,156)",u="color:inherit",o=!1,r=0,e=[],t=t.replace(/(\\[<={}> "'])|(=>|[<={}> "'])/g,function(t,l,p){var h;return(null!=l?l.length:void 0)?l:o&&'"'!==p&&"'"!==p?p:r&&'"'!==p&&"'"!==p&&"{"!==p&&"}"!==p?p:h=function(){switch(p){case"<":return e.push(a),"%c<";case">":return e.push(a),e.push(u),"%c>%c";case" ":return e.push(n)," %c";case"=":case"=>":return e.push(a),"%c"+p;case'"':case"'":return o=!o,o?(e.push(r?n:s),p+"%c"):(e.push(r?i:a),"%c"+p);case"{":return 0===r++?(e.push(i),"%c"+p):p;case"}":return 0===--r?(e.push(a),p+"%c"):p;default:return p}}()}),[t].concat(e)},m=function(t,e){return d(t,e,"=")},f=function(t,e){return d(t,e,"=>")},d=function(){var t;return t=y({compact:!1}),function(e,n,r){var i,o,s;return i=function(t){return t===""+ +t||t.match(/^[A-Za-z_][A-Za-z0-9]*$/)?t:JSON.stringify(t)},s=function(t){return t.match('\n*"')?t:"{"+t+"}"},o=function(e){var n,r;if(e instanceof Array)return"["+e.map(o).join(", ")+"]";switch(typeof e){case"string":return e.match("\n")?'"\n'+e+'"\n':'"'+e+'"';case"function":return e=""+e,e.match("\n"),e=e.replace(/^function (\([^)]+\))/,"$1 =>"),e=e.replace(/^(\([^)]+\)) =>\s*{\s*return\s*([^}]+)\s*;\s*}/,"$1 => $2");case"number":return t(e);default:return null!=e&&e!==!!e?null!=e._up?o(e.map(function(t){return t})):e.toMarkup?e.toString():"{"+function(){var t;t=[];for(n in e)r=e[n],e.hasOwnProperty(n)&&t.push(i(n)+": "+o(r));return t}().join(", ")+"}":""+JSON.stringify(e)}},[e,r,s(o(n))].join("")}}(),a=function(t){return t=t.replace(/&/g,"&amp;"),t=t.replace(/</g,"&lt;"),t=t.replace(/"/g,"&quot;")},c=function(t){var e,n,r,i,o;for(n=[].slice.call(arguments),n.shift(),o="<span>",t=a(t),r=0,i=n.length;i>r;r++)e=n[r],t=t.replace(/%([a-z])/,function(t,e){var r;switch(r=n.shift(),e){case"c":return'</span><span style="'+a(r)+'">';default:return a(r)}});return o+=t,o+="</span>"},e.exports={markup:v,number:y,print:g,format:c,JSX:{prop:m,bind:f}}},{}],178:[function(t,e,n){n.paramToGL=function(t,e){return e===THREE.RepeatWrapping?t.REPEAT:e===THREE.ClampToEdgeWrapping?t.CLAMP_TO_EDGE:e===THREE.MirroredRepeatWrapping?t.MIRRORED_REPEAT:e===THREE.NearestFilter?t.NEAREST:e===THREE.NearestMipMapNearestFilter?t.NEAREST_MIPMAP_NEAREST:e===THREE.NearestMipMapLinearFilter?t.NEAREST_MIPMAP_LINEAR:e===THREE.LinearFilter?t.LINEAR:e===THREE.LinearMipMapNearestFilter?t.LINEAR_MIPMAP_NEAREST:e===THREE.LinearMipMapLinearFilter?t.LINEAR_MIPMAP_LINEAR:e===THREE.UnsignedByteType?t.UNSIGNED_BYTE:e===THREE.UnsignedShort4444Type?t.UNSIGNED_SHORT_4_4_4_4:e===THREE.UnsignedShort5551Type?t.UNSIGNED_SHORT_5_5_5_1:e===THREE.UnsignedShort565Type?t.UNSIGNED_SHORT_5_6_5:e===THREE.ByteType?t.BYTE:e===THREE.ShortType?t.SHORT:e===THREE.UnsignedShortType?t.UNSIGNED_SHORT:e===THREE.IntType?t.INT:e===THREE.UnsignedIntType?t.UNSIGNED_INT:e===THREE.FloatType?t.FLOAT:e===THREE.AlphaFormat?t.ALPHA:e===THREE.RGBFormat?t.RGB:e===THREE.RGBAFormat?t.RGBA:e===THREE.LuminanceFormat?t.LUMINANCE:e===THREE.LuminanceAlphaFormat?t.LUMINANCE_ALPHA:e===THREE.AddEquation?t.FUNC_ADD:e===THREE.SubtractEquation?t.FUNC_SUBTRACT:e===THREE.ReverseSubtractEquation?t.FUNC_REVERSE_SUBTRACT:e===THREE.ZeroFactor?t.ZERO:e===THREE.OneFactor?t.ONE:e===THREE.SrcColorFactor?t.SRC_COLOR:e===THREE.OneMinusSrcColorFactor?t.ONE_MINUS_SRC_COLOR:e===THREE.SrcAlphaFactor?t.SRC_ALPHA:e===THREE.OneMinusSrcAlphaFactor?t.ONE_MINUS_SRC_ALPHA:e===THREE.DstAlphaFactor?t.DST_ALPHA:e===THREE.OneMinusDstAlphaFactor?t.ONE_MINUS_DST_ALPHA:e===THREE.DstColorFactor?t.DST_COLOR:e===THREE.OneMinusDstColorFactor?t.ONE_MINUS_DST_COLOR:e===THREE.SrcAlphaSaturateFactor?t.SRC_ALPHA_SATURATE:0},n.paramToArrayStorage=function(t){switch(t){case THREE.UnsignedByteType:return Uint8Array;case THREE.ByteType:return Int8Array;case THREE.ShortType:return Int16Array;case THREE.UnsignedShortType:return Uint16Array;case THREE.IntType:return Int32Array;case THREE.UnsignedIntType:return Uint32Array;case THREE.FloatType:return Float32Array}},n.swizzleToEulerOrder=function(t){return t.map(function(t){return["","X","Y","Z"][t]}).join("")},n.transformComposer=function(){var t,e,r,i,o;return t=new THREE.Euler,r=new THREE.Quaternion,e=new THREE.Vector3,i=new THREE.Vector3,o=new THREE.Matrix4,function(s,a,u,l,p,h){return null==h&&(h="XYZ"),null!=a?(h instanceof Array&&(h=n.swizzleToEulerOrder(h)),t.setFromVector3(a,h),r.setFromEuler(t)):r.set(0,0,0,1),null!=u&&r.multiply(u),null!=s?e.copy(s):e.set(0,0,0),null!=l?i.copy(l):i.set(1,1,1),o.compose(e,r,i),null!=p&&o.multiplyMatrices(o,p),o}}},{}],179:[function(t,e,n){var r,i,o,s,a;o=function(t,e,n,r,i,o,s,a,u,l){var p,h,c,f,d,m,v,y,g,_;return null==l&&(l=!0),n||(n=10),r||(r=1),i||(i=10),o||(o=1),v=e-t,d=v/n,l?(r||(r=1),i||(i=10),m=r*Math.pow(i,Math.floor(Math.log(d/r)/Math.log(i))),c=i%2===0?[i/2,1,.5]:i%3===0?[i/3,1,1/3]:[1],g=function(){var t,e,n;for(n=[],t=0,e=c.length;e>t;t++)h=c[t],n.push(m*h);return n}(),p=1/0,y=g.reduce(function(t,e){var n;return h=e/d,n=Math.max(h,1/h),p>n?(p=n,e):t},m),y*=o,t=Math.ceil(t/y+ +!s)*y,e=(Math.floor(e/y)-+!a)*y,n=Math.ceil((e-t)/y),_=function(){var e,r,i;for(i=[],f=e=0,r=n;r>=0?r>=e:e>=r;f=r>=0?++e:--e)i.push(t+f*y);return i}(),u||(_=_.filter(function(t){return 0!==t})),_):(_=function(){var e,r,i;for(i=[],f=e=0,r=n;r>=0?r>=e:e>=r;f=r>=0?++e:--e)i.push(t+f*d);return i}(),s||_.shift(),a||_.pop(),u||(_=_.filter(function(t){return 0!==t})),_)},s=function(t,e,n,r,i,o,s,a,u,l){throw new Error("Log ticks not yet implemented.")},r=0,i=1,a=function(t,e,n,a,u,l,p,h,c,f,d){switch(t){case r:return o(e,n,a,u,l,p,h,c,f,d);case i:return s(e,n,a,u,l,p,h,c,f,d)}},n.make=a,n.linear=o,n.log=s},{}],180:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;for(r=[],p=0,i={},a=function(){return{id:p++,type:null,props:null,children:null,rendered:null,instance:null}},l=function(t){var e,n,i,o;for(t*=2,t=Math.max(0,r.length-t),o=[],e=n=0,i=t;i>=0?i>n:n>i;e=i>=0?++n:--n)o.push(r.push(a()));return o},u=function(t,e,n){var i;return i=r.length?r.pop():a(),i.type=null!=t?t:"div",i.props=null!=e?e:null,i.children=null!=n?n:null,i},y=function(t){var e,n,i,o;if(t.type&&(n=t.children,t.type=t.props=t.children=t.instance=null,r.push(t),null!=n))for(i=0,o=n.length;o>i;i++)e=n[i],y(e)},o=function(t,e,n,r,s){var a,l,p,h,c,f,d,v,y,g,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H;if(null!=t){if(null==e)return m(t,r,s);if(t instanceof Node){if(j=t===e)return}else j=typeof t==typeof e&&null!==e&&null!==t&&t.type===e.type;if(j){if(t.instance=e.instance,U=(null!=(R=t.type)?R.isComponentClass:void 0)?t.type:i[t.type],A=null!=e?e.props:void 0,z=t.props,h=null!=(C=null!=e?e.children:void 0)?C:null,S=t.children,null!=z&&(z.children=S),null!=U){if(f=n._COMPONENT_DIRTY,null!=A!=(null!=z)&&(f=!0),h!==S&&(f=!0),null!=A&&null!=z){if(!f)for(g in A)z.hasOwnProperty(g)||(f=!0);if(!f)for(g in z)H=z[g],(P=A[g])!==H&&(f=!0)}if(f){c=e.instance,null==t.props&&(t.props={}),I=c.defaultProps;for(y in I)F=I[y],null==(a=t.props)[y]&&(a[y]=F);t.props.children=t.children,"function"==typeof c.willReceiveProps&&c.willReceiveProps(t.props),N=n._COMPONENT_FORCE||(null!=(D="function"==typeof c.shouldUpdate?c.shouldUpdate(t.props):void 0)?D:!0),N&&(M=c.getNextState(),"function"==typeof c.willUpdate&&c.willUpdate(t.props,M)),T=c.props,O=c.applyNextState(),c.props=t.props,c.children=t.children,N&&(t=t.rendered="function"==typeof c.render?c.render(u,t.props,t.children):void 0,o(t,e.rendered,n,r,s),"function"==typeof c.didUpdate&&c.didUpdate(T,O))}return}if(null!=A)for(g in A)z.hasOwnProperty(g)||w(n,g,A[g]);if(null!=z)for(g in z)H=z[g],(P=A[g])!==H&&"children"!==g&&_(n,g,H,P);if(null!=S)if("string"==(L=typeof S)||"number"===L)S!==h&&(n.textContent=S);else if(null!=S.type)o(S,h,n.childNodes[0],n,0);else if(p=n.childNodes,null!=h)for(d=v=0,k=S.length;k>v;d=++v)l=S[d],o(l,h[d],p[d],n,d);else for(d=x=0,E=S.length;E>x;d=++x)l=S[d],o(l,null,p[d],n,d);else null!=h&&(b(null,n),n.innerHTML="");return}return b(e.instance,n),n.remove(),m(t,r,s)}return null!=e?(b(e.instance,n),e.node.remove()):void 0},m=function(t,e,n){var r,o,s,a,l,p,h,c,f,d,v,y,g,b,w,x,k,E,S,z;if(null==n&&(n=0),E=(null!=(y=t.type)?y.isComponentClass:void 0)?t.type:i[t.type],t instanceof Node)v=t;else{if(null!=E){if(l=(null!=(g=t.type)?g.isComponentClass:void 0)?t.type:i[t.type],!l)return t=t.rendered=u("noscript"),v=m(t,e,n);t.instance=a=new l(e),null==t.props&&(t.props={}),b=a.defaultProps;for(c in b)S=b[c],null==(r=t.props)[c]&&(r[c]=S);return t.props.children=t.children,a.props=t.props,a.children=t.children,a.setState("function"==typeof a.getInitialState?a.getInitialState():void 0),"function"==typeof a.willMount&&a.willMount(),t=t.rendered="function"==typeof a.render?a.render(u,t.props,t.children):void 0,v=m(t,e,n),"function"==typeof a.didMount&&a.didMount(t),v._COMPONENT=a,v}if("string"==(w=typeof t)||"number"===w)v=document.createTextNode(t);else{v=document.createElement(t.type),x=t.props;for(f in x)z=x[f],_(v,f,z)}if(s=t.children,null!=s)if("string"==(k=typeof s)||"number"===k)v.textContent=s;else if(null!=s.type)m(s,v,0);else for(p=h=0,d=s.length;d>h;p=++h)o=s[p],m(o,v,p)}return e.insertBefore(v,e.childNodes[n]),v},b=function(t,e){var n,r,i,o,s,a;if(t){"function"==typeof t.willUnmount&&t.willUnmount();for(i in t)delete t[i]}for(s=e.childNodes,a=[],r=0,o=s.length;o>r;r++)n=s[r],b(n._COMPONENT,n),a.push(delete n._COMPONENT);return a},v=function(t){var e,n,r,i;if("undefined"==typeof document)return!0;if(null!=document.documentElement.style[t])return t;for(t=t[0].toUpperCase()+t.slice(1),i=["webkit","moz","ms","o"],
e=0,n=i.length;n>e;e++)if(r=i[e],null!=document.documentElement.style[r+t])return r+t},d={},g=["transform"],h=0,f=g.length;f>h;h++)c=g[h],d[c]=v(c);_=function(t,e,n,r){var i,o,s;{if("style"!==e)return null!=t[e]?void(t[e]=n):void(t instanceof Node&&t.setAttribute(e,n));for(i in n)s=n[i],(null!=r?r[i]:void 0)!==s&&(t.style[null!=(o=d[i])?o:i]=s)}},w=function(t,e,n){var r,i,o;if("style"!==e)null!=t[e]&&(t[e]=void 0),t instanceof Node&&t.removeAttribute(e);else for(r in n)o=n[r],t.style[null!=(i=d[r])?i:r]=""},s=function(t){var e,n,r,i,o;r={willMount:"componentWillMount",didMount:"componentDidMount",willReceiveProps:"componentWillReceiveProps",shouldUpdate:"shouldComponentUpdate",willUpdate:"componentWillUpdate",didUpdate:"componentDidUpdate",willUnmount:"componentWillUnmount"};for(n in r)i=r[n],null==t[n]&&(t[n]=t[i]);return e=function(){function e(e,n,r,i){var o,s,a,u;this.props=null!=n?n:{},this.state=null!=r?r:null,this.children=null!=i?i:null,o=function(t,e){return"function"==typeof t?t.bind(e):t};for(s in t)u=t[s],this[s]=o(u,this);a=null,this.setState=function(t){null==a&&(a=t?null!=a?a:{}:null);for(s in t)u=t[s],a[s]=u;e._COMPONENT_DIRTY=!0},this.forceUpdate=function(){var t,n;for(e._COMPONENT_FORCE=e._COMPONENT_DIRTY=!0,t=e,n=[];t=t.parentNode;)t._COMPONENT?n.push(t._COMPONENT_FORCE=!0):n.push(void 0);return n},this.getNextState=function(){return a},this.applyNextState=function(){var t,n;return e._COMPONENT_FORCE=e._COMPONENT_DIRTY=!1,t=this.state,n=[null,a],a=n[0],this.state=n[1],t}}return e}(),e.isComponentClass=!0,e.prototype.defaultProps=null!=(o="function"==typeof t.getDefaultProps?t.getDefaultProps():void 0)?o:{},e},e.exports={element:u,recycle:y,apply:o,hint:l,Types:i,createClass:s}},{}],181:[function(t,e,n){var r;r=function(){function t(e,n){this.parent=null!=n?n:null,this.id=t.id(),this.nodes=[],e&&this.add(e)}return t.index=0,t.id=function(e){return++t.index},t.IN=0,t.OUT=1,t.prototype.inputs=function(){var t,e,n,r,i,o,s,a,u;for(e=[],a=this.nodes,t=0,r=a.length;r>t;t++)for(o=a[t],u=o.inputs,n=0,i=u.length;i>n;n++)s=u[n],null===s.input&&e.push(s);return e},t.prototype.outputs=function(){var t,e,n,r,i,o,s,a,u;for(s=[],a=this.nodes,t=0,n=a.length;n>t;t++)for(i=a[t],u=i.outputs,e=0,r=u.length;r>e;e++)o=u[e],0===o.output.length&&s.push(o);return s},t.prototype.getIn=function(t){var e;return function(){var n,r,i,o;for(i=this.inputs(),o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.getOut=function(t){var e;return function(){var n,r,i,o;for(i=this.outputs(),o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.add=function(t,e){var n,r,i;{if(!t.length){if(t.graph&&!e)throw new Error("Adding node to two graphs at once");return t.graph=this,this.nodes.push(t)}for(r=0,i=t.length;i>r;r++)n=t[r],this.add(n)}},t.prototype.remove=function(t,e){var n,r,i;{if(!t.length){if(t.graph!==this)throw new Error("Removing node from wrong graph.");return e||t.disconnect(),this.nodes.splice(this.nodes.indexOf(t),1),t.graph=null}for(r=0,i=t.length;i>r;r++)n=t[r],this.remove(n)}},t.prototype.adopt=function(t){var e,n,r;{if(!t.length)return t.graph.remove(t,!0),this.add(t,!0);for(n=0,r=t.length;r>n;n++)e=t[n],this.adopt(e)}},t}(),e.exports=r},{}],182:[function(t,e,n){n.Graph=t("./graph"),n.Node=t("./node"),n.Outlet=t("./outlet"),n.IN=n.Graph.IN,n.OUT=n.Graph.OUT},{"./graph":181,"./node":183,"./outlet":184}],183:[function(t,e,n){var r,i,o;r=t("./graph"),o=t("./outlet"),i=function(){function t(e,n){this.owner=e,this.graph=null,this.inputs=[],this.outputs=[],this.all=[],this.outlets=null,this.id=t.id(),this.setOutlets(n)}return t.index=0,t.id=function(e){return++t.index},t.prototype.getIn=function(t){var e;return function(){var n,r,i,o;for(i=this.inputs,o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.getOut=function(t){var e;return function(){var n,r,i,o;for(i=this.outputs,o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.get=function(t){return this.getIn(t)||this.getOut(t)},t.prototype.setOutlets=function(t){var e,n,r,i,s,a,u,l,p,h,c,f;if(null!=t){if(null==this.outlets){for(this.outlets={},r=0,u=t.length;u>r;r++)c=t[r],c instanceof o||(c=o.make(c)),this._add(c);return}for(n=function(t){return[t.name,t.inout,t.type].join("-")},h={},i=0,l=t.length;l>i;i++)c=t[i],h[n(c)]=!0;f=this.outlets;for(a in f)c=f[a],a=n(c),h[a]?h[a]=c:this._remove(c);for(s=0,p=t.length;p>s;s++)c=t[s],e=h[n(c)],e instanceof o?this._morph(e,c):(c instanceof o||(c=o.make(c)),this._add(c))}return this.outlets},t.prototype.connect=function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;for(d={},s={},w=function(t){return b+"/"+t.hint},m=t.inputs,a=0,p=m.length;p>a;a++)r=m[a],(n||!r.input)&&(b=r.type,o=w(r),s[o]||(s[o]=r),d[b]=f=d[b]||[],f.push(r));for(_=this.outputs,_=_.filter(function(t){return!(e&&t.output.length)}),v=_.slice(),u=0,h=v.length;h>u;u++)g=v[u],b=g.type,o=w(g),i=d[b],(r=s[o])&&(g.connect(r),delete s[o],i.splice(i.indexOf(r),1),_.splice(_.indexOf(g),1));if(!_.length)return this;for(y=_.slice(),l=0,c=y.length;c>l;l++)g=y[l],b=g.type,i=d[b],i&&i.length&&g.connect(i.shift());return this},t.prototype.disconnect=function(t){var e,n,r,i,o,s,a;for(s=this.inputs,e=0,r=s.length;r>e;e++)o=s[e],o.disconnect();for(a=this.outputs,n=0,i=a.length;i>n;n++)o=a[n],o.disconnect();return this},t.prototype._key=function(t){return[t.name,t.inout].join("-")},t.prototype._add=function(t){var e;if(e=this._key(t),t.node)throw new Error("Adding outlet to two nodes at once.");if(this.outlets[e])throw new Error("Adding two identical outlets to same node. ("+e+")");return t.node=this,t.inout===r.IN&&this.inputs.push(t),t.inout===r.OUT&&this.outputs.push(t),this.all.push(t),this.outlets[e]=t},t.prototype._morph=function(t,e){var n;return n=this._key(e),delete this.outlets[n],t.morph(e),n=this._key(e),this.outlets[n]=e},t.prototype._remove=function(t){var e,n;if(n=this._key(t),e=t.inout,t.node!==this)throw new Error("Removing outlet from wrong node.");return t.disconnect(),t.node=null,delete this.outlets[n],t.inout===r.IN&&this.inputs.splice(this.inputs.indexOf(t),1),t.inout===r.OUT&&this.outputs.splice(this.outputs.indexOf(t),1),this.all.splice(this.all.indexOf(t),1),this},t}(),e.exports=i},{"./graph":181,"./outlet":184}],184:[function(t,e,n){var r,i;r=t("./graph"),i=function(){function t(e,n,r,i,o,s){this.inout=e,this.name=n,this.hint=r,this.type=i,this.meta=null!=o?o:{},this.id=s,null==this.hint&&(this.hint=t.hint(this.name)),this.node=null,this.input=null,this.output=[],null==this.id&&(this.id=t.id(this.hint))}return t.make=function(e,n){var r,i,o,s;if(null==n&&(n={}),i=n,null!=e.meta){o=e.meta;for(r in o)s=o[r],i[r]=s}return new t(e.inout,e.name,e.hint,e.type,i)},t.index=0,t.id=function(e){return"_io_"+ ++t.index+"_"+e},t.hint=function(t){return t=t.replace(/^_io_[0-9]+_/,""),t=t.replace(/_i_o$/,""),t=t.replace(/(In|Out|Inout|InOut)$/,"")},t.prototype.morph=function(t){return this.inout=t.inout,this.name=t.name,this.hint=t.hint,this.type=t.type,this.meta=t.meta},t.prototype.dupe=function(e){var n;return null==e&&(e=this.id),n=t.make(this),n.name=e,n},t.prototype.connect=function(t){if(this.inout===r.IN&&t.inout===r.OUT)return t.connect(this);if(this.inout!==r.OUT||t.inout!==r.IN)throw new Error("Can only connect out to in.");if(t.input!==this)return t.disconnect(),t.input=this,this.output.push(t)},t.prototype.disconnect=function(t){var e,n,r,i;if(this.input&&this.input.disconnect(this),this.output.length){if(!t){for(i=this.output,e=0,r=i.length;r>e;e++)t=i[e],t.input=null;return this.output=[]}if(n=this.output.indexOf(t),n>=0)return this.output.splice(n,1),t.input=null}},t}(),e.exports=i},{"./graph":181}],185:[function(t,e,n){var r,i,o,s,a,u;i=t("../graph"),a=t("../linker").Program,o=t("../linker").Layout,u=!1,r=function(){function t(){var t;null==this.namespace&&(this.namespace=a.entry()),this.node=new i.Node(this,null!=(t="function"==typeof this.makeOutlets?this.makeOutlets():void 0)?t:{})}return t.previous=function(t){var e;return null!=(e=t.input)?e.node.owner:void 0},t.prototype.refresh=function(){var t;return this.node.setOutlets(null!=(t="function"==typeof this.makeOutlets?this.makeOutlets():void 0)?t:{})},t.prototype.clone=function(){return new t},t.prototype.compile=function(t,e){var n;return n=new a(t,null!=e?e:a.entry(),this.node.graph),this.call(n,0),n.assemble()},t.prototype.link=function(t,e){var n,r;return r=this.compile(t,e),n=new o(t,this.node.graph),this._include(r,n,0),this["export"](n,0),n.link(r)},t.prototype.call=function(t,e){},t.prototype.callback=function(t,e,n,r,i){},t.prototype["export"]=function(t,e){},t.prototype._info=function(t){var e,n,r;return r=null!=(e=null!=(n=this.node.owner.snippet)?n._name:void 0)?e:this.node.owner.namespace,null!=t?r+="."+t:void 0},t.prototype._outlet=function(t,e){var n;return n=i.Outlet.make(t,e),n.meta.def=t,n},t.prototype._call=function(t,e,n){return e.call(this.node,t,n)},t.prototype._require=function(t,e){return e.require(this.node,t)},t.prototype._inputs=function(e,n,r){var i,o,s,a,u,l,p;for(u=e.main.signature,p=[],o=0,s=u.length;s>o;o++)i=u[o],a=this.node.get(i.name),p.push(null!=(l=t.previous(a))?l.call(n,r+1):void 0);return p},t.prototype._callback=function(t,e,n,r,i,o){return e.callback(this.node,t,n,r,i,o)},t.prototype._include=function(t,e,n){return e.include(this.node,t,n)},t.prototype._link=function(e,n,r){var i,o,a,l,p,h,c,f,d,m,v,y;for(u&&console.log("block::_link",this.toString(),e.namespace),d=e.symbols,y=[],a=0,p=d.length;p>a;a++){if(l=d[a],o=e.externals[l],c=this.node.get(o.name),!c)throw new s("External not found on "+this._info(o.name));if(null==c.meta.child){for(m=[c,c,null],h=m[0],f=m[1],i=m[2];!i&&f;)v=[c.meta.parent,f],f=v[0],c=v[1];if(i=t.previous(c),!i)throw new s("Missing connection on "+this._info(o.name));u&&console.log("callback -> ",this.toString(),o.name,c),i.callback(n,r+1,l,o,c.input),y.push(null!=i?i["export"](n,r+1):void 0)}}return y},t.prototype._trace=function(e,n,r){var i,o,s,a,l,p,h;for(u&&console.log("block::_trace",this.toString(),e.namespace),l=e.main.signature,h=[],o=0,s=l.length;s>o;o++)i=l[o],a=this.node.get(i.name),h.push(null!=(p=t.previous(a))?p["export"](n,r+1):void 0);return h},t}(),s=function(t){var e;return e=new Error(t),e.name="OutletError",e},s.prototype=new Error,e.exports=r},{"../graph":205,"../linker":210}],186:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./block"),i=function(t){function e(t){this.snippet=t,this.namespace=this.snippet.namespace,e.__super__.constructor.apply(this,arguments)}return o(e,t),e.prototype.clone=function(){return new e(this.snippet)},e.prototype.makeOutlets=function(){var t,e,n,r,i,o,s;return r=this.snippet.main.signature,e=this.snippet.externals,s=this.snippet.symbols,o=function(){var t,e,n;for(n=[],t=0,e=r.length;e>t;t++)i=r[t],n.push(this._outlet(i,{callback:!1}));return n}.call(this),t=function(){var t,r,i;for(i=[],t=0,r=s.length;r>t;t++)n=s[t],i.push(this._outlet(e[n],{callback:!0}));return i}.call(this),o.concat(t)},e.prototype.call=function(t,e){return this._call(this.snippet,t,e),this._inputs(this.snippet,t,e)},e.prototype["export"]=function(t,e){return t.visit(this.namespace,e)?(this._link(this.snippet,t,e),this._trace(this.snippet,t,e)):void 0},e}(r),e.exports=i},{"./block":185}],187:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;o=t("../graph"),r=t("./block"),i=function(t){function e(t){this.graph=t,e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.refresh=function(){return e.__super__.refresh.apply(this,arguments),delete this.subroutine},e.prototype.clone=function(){return new e(this.graph)},e.prototype.makeOutlets=function(){var t,e,n,r,i,s,a,u,l,p,h,c;for(this.make(),u=[],n=[],l=[],t=function(t){return function(t,e){var n,r;return t.meta.callback?t.inout===o.IN?(r=t.dupe(),null==(n=r.meta).child&&(n.child=t),t.meta.parent=r,u.push(r)):void 0:e.push(t.type)}}(this),p=this.graph.inputs(),e=0,i=p.length;i>e;e++)a=p[e],t(a,n);for(h=this.graph.outputs(),r=0,s=h.length;s>r;r++)a=h[r],t(a,l);return n=n.join(","),l=l.join(","),c="("+n+")("+l+")",u.push({name:"callback",type:c,inout:o.OUT,meta:{callback:!0,def:this.subroutine.main}}),u},e.prototype.make=function(){return this.subroutine=this.graph.compile(this.namespace)},e.prototype["export"]=function(t,e){return t.visit(this.namespace,e)?(this._link(this.subroutine,t,e),this.graph["export"](t,e)):void 0},e.prototype.call=function(t,e){return this._require(this.subroutine,t,e)},e.prototype.callback=function(t,e,n,r,i){return this._include(this.subroutine,t,e),this._callback(this.subroutine,t,e,n,r,i)},e}(r),e.exports=i},{"../graph":205,"./block":185}],188:[function(t,e,n){n.Block=t("./block"),n.Call=t("./call"),n.Callback=t("./callback"),n.Isolate=t("./isolate"),n.Join=t("./join")},{"./block":185,"./call":186,"./callback":187,"./isolate":189,"./join":190}],189:[function(t,e,n){var r,i,o,s=function(t,e){function n(){this.constructor=t}for(var r in e)a.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},a={}.hasOwnProperty;i=t("../graph"),r=t("./block"),o=function(t){function e(t){this.graph=t,e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.refresh=function(){return e.__super__.refresh.apply(this,arguments),delete this.subroutine},e.prototype.clone=function(){return new e(this.graph)},e.prototype.makeOutlets=function(){var t,e,n,r,o,s,a,u,l,p,h,c,f,d,m;for(this.make(),p=[],d={},e={},h=["inputs","outputs"],r=0,s=h.length;s>r;r++)for(m=h[r],c=this.graph[m](),o=0,a=c.length;a>o;o++)l=c[o],u=void 0,"return"!==(f=l.hint)&&"callback"!==f||l.inout!==i.OUT||(u=l.hint),null!=d[u]&&(u=void 0),n=l.dupe(u),null==(t=n.meta).child&&(t.child=l),l.meta.parent=n,null!=u&&(d[u]=!0),e[l.name]=n,p.push(n);return p},e.prototype.make=function(){return this.subroutine=this.graph.compile(this.namespace)},e.prototype.call=function(t,e){return this._call(this.subroutine,t,e),this._inputs(this.subroutine,t,e)},e.prototype["export"]=function(t,e){return t.visit(this.namespace,e)?(this._link(this.subroutine,t,e),this._trace(this.subroutine,t,e),this.graph["export"](t,e)):void 0},e.prototype.callback=function(t,e,n,r,i){return i=i.meta.child,i.node.owner.callback(t,e,n,r,i)},e}(r),e.exports=o},{"../graph":205,"./block":185}],190:[function(t,e,n){var r,i,o=function(t,e){function n(){this.constructor=t}for(var r in e)s.call(e,r)&&(t[r]=e[r]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},s={}.hasOwnProperty;r=t("./block"),i=function(t){function e(t){this.nodes=t,e.__super__.constructor.apply(this,arguments)}return o(e,t),e.prototype.clone=function(){return new e(this.nodes)},e.prototype.makeOutlets=function(){return[]},e.prototype.call=function(t,e){var n,r,i,o,s,a;for(s=this.nodes,a=[],r=0,i=s.length;i>r;r++)o=s[r],n=o.owner,a.push(n.call(t,e));return a},e.prototype["export"]=function(t,e){var n,r,i,o,s,a;for(s=this.nodes,a=[],r=0,i=s.length;i>r;r++)o=s[r],n=o.owner,a.push(n["export"](t,e));return a},e}(r),e.exports=i},{"./block":185}],191:[function(t,e,n){var r,i,o;o=t("./queue"),i=t("./hash"),r=function(t){var e,n;return e={},n=o(100),function(r){var o,s;return s=r.length>32?"##"+i(r).toString(16):r,o=n(s),null!=o&&delete e[o],null==e[s]&&(e[s]=t(r)),e[s].clone()}},e.exports=r},{"./hash":193,"./queue":197}],192:[function(t,e,n){var r,i,o,s,a;o=t("../graph").Graph,r=t("../block"),a=t("../visualize"),i=function(){function t(t,e,n){this.language=t,this.fetch=e,this.config=n,this.graph()}return t.prototype.pipe=function(e,n,r,i){return e instanceof t?this._concat(e):null!=e&&this._call(e,n,r,i),this},t.prototype.call=function(t,e,n,r){return this.pipe(t,e,n,r)},t.prototype.require=function(e,n,r,i){return e instanceof t?this._import(e):null!=e&&(this.callback(),this._call(e,n,r,i),this.end()),this},t.prototype["import"]=function(t,e,n,r){return this.require(t,e,n,r)},t.prototype.split=function(){return this._group("_combine",!0),this},t.prototype.fan=function(){return this._group("_combine",!1),this},t.prototype.isolate=function(){return this._group("_isolate"),this},t.prototype.callback=function(){return this._group("_callback"),this},t.prototype.next=function(){return this._next(),this},t.prototype.pass=function(){var t;return t=this._stack[2].end,this.end(),this._state.end=this._state.end.concat(t),this},t.prototype.end=function(){var t,e,n,r;return n=this._exit(),r=n[0],t=n[1],e=r.op,this[e]&&this[e](r,t),this},t.prototype.join=function(){return this.end()},t.prototype.graph=function(){for(var t,e;(null!=(e=this._stack)?e.length:void 0)>1;)this.end();return this._graph&&this._tail(this._state,this._graph),t=this._graph,this._graph=new o,this._state=new s,this._stack=[this._state],t},t.prototype.compile=function(t){return null==t&&(t="main"),this.graph().compile(t)},t.prototype.link=function(t){return null==t&&(t="main"),this.graph().link(t)},t.prototype.serialize=function(){return a.serialize(this._graph)},t.prototype.empty=function(){return 0===this._graph.nodes.length},t.prototype._concat=function(t){var e,n,i;if(0===t._state.nodes.length)return this;this._tail(t._state,t._graph);try{e=new r.Isolate(t._graph)}catch(i){throw n=i,this.config.autoInspect&&a.inspect(n,this._graph,t),n}return this._auto(e),this},t.prototype._import=function(t){var e,n,i;if(0===t._state.nodes.length)throw"Can't import empty callback";this._tail(t._state,t._graph);try{e=new r.Callback(t._graph)}catch(i){throw n=i,this.config.autoInspect&&a.inspect(n,this._graph,t),n}return this._auto(e),this},t.prototype._combine=function(t,e){var n,r,i,o,s,a,u,l;for(a=t.start,r=0,o=a.length;o>r;r++)for(l=a[r],u=e.end,i=0,s=u.length;s>i;i++)n=u[i],n.connect(l,t.multi);return e.end=t.end,e.nodes=e.nodes.concat(t.nodes)},t.prototype._isolate=function(t,e){var n,i,o,s;if(t.nodes.length){s=this._subgraph(t),this._tail(t,s);try{n=new r.Isolate(s)}catch(o){throw i=o,this.config.autoInspect&&a.inspect(i,this._graph,s),i}return this._auto(n)}},t.prototype._callback=function(t,e){var n,i,o,s;if(t.nodes.length){s=this._subgraph(t),this._tail(t,s);try{n=new r.Callback(s)}catch(o){throw i=o,this.config.autoInspect&&a.inspect(i,this._graph,s),i}return this._auto(n)}},t.prototype._call=function(t,e,n,i){var o,s;return s=this.fetch(t),s.bind(this.config,e,n,i),o=new r.Call(s),this._auto(o)},t.prototype._subgraph=function(t){var e;return e=new o(null,this._graph),e.adopt(t.nodes),e},t.prototype._tail=function(t,e){var n;if(n=t.end.concat(t.tail),n=n.filter(function(t,e){return n.indexOf(t)===e}),n.length>1&&(n=new r.Join(n),n=[n.node],this._graph.add(n)),e.tail=n[0],t.end=n,t.tail=[],!e.tail)throw new Error("Cannot finalize empty graph");return e.compile=function(t){return function(n){var r,i;null==n&&(n="main");try{return e.tail.owner.compile(t.language,n)}catch(i){throw r=i,t.config.autoInspect&&e.inspect(r),r}}}(this),e.link=function(t){return function(n){var r,i;null==n&&(n="main");try{return e.tail.owner.link(t.language,n)}catch(i){throw r=i,t.config.autoInspect&&e.inspect(r),r}}}(this),e["export"]=function(t){return function(t,n){return e.tail.owner["export"](t,n)}}(this),e.inspect=function(t){return null==t&&(t=null),a.inspect(t,e)}},t.prototype._group=function(t,e){return this._push(t,e),this._push(),this},t.prototype._next=function(){var t;return t=this._pop(),this._state.start=this._state.start.concat(t.start),this._state.end=this._state.end.concat(t.end),this._state.nodes=this._state.nodes.concat(t.nodes),this._state.tail=this._state.tail.concat(t.tail),this._push()},t.prototype._exit=function(){return this._next(),this._pop(),[this._pop(),this._state]},t.prototype._push=function(t,e){return this._stack.unshift(new s(t,e)),this._state=this._stack[0]},t.prototype._pop=function(){var t;return this._state=this._stack[1],null==this._state&&(this._state=new s),null!=(t=this._stack.shift())?t:new s},t.prototype._auto=function(t){return t.node.inputs.length?this._append(t):this._insert(t)},t.prototype._append=function(t){var e,n,r,i,o;for(i=t.node,this._graph.add(i),o=this._state.end,n=0,r=o.length;r>n;n++)e=o[n],e.connect(i);return this._state.start.length||(this._state.start=[i]),this._state.end=[i],this._state.nodes.push(i),i.outputs.length?void 0:this._state.tail.push(i)},t.prototype._prepend=function(t){var e,n,r,i,o;for(r=t.node,this._graph.add(r),i=this._state.start,e=0,n=i.length;n>e;e++)o=i[e],r.connect(o);return this._state.end.length||(this._state.end=[r]),this._state.start=[r],this._state.nodes.push(r),r.outputs.length?void 0:this._state.tail.push(r)},t.prototype._insert=function(t){var e;return e=t.node,this._graph.add(e),this._state.start.push(e),this._state.end.push(e),this._state.nodes.push(e),e.outputs.length?void 0:this._state.tail.push(e)},t}(),s=function(){function t(t,e,n,r,i,o){this.op=null!=t?t:null,this.multi=null!=e?e:!1,this.start=null!=n?n:[],this.end=null!=r?r:[],this.nodes=null!=i?i:[],this.tail=null!=o?o:[]}return t}(),e.exports=i},{"../block":188,"../graph":205,"../visualize":216}],193:[function(t,e,n){var r,i,o,s,a,u,l,p;r=3432918353,i=461845907,o=3864292196,s=2246822507,a=3266489909,l=function(t,e){var n,r,i,o;return n=t>>>16&65535,r=65535&t,i=e>>>16&65535,o=65535&e,r*o+(n*o+r*i<<16>>>0)|0},null!=Math.imul&&(p=Math.imul(4294967295,5),-5===p&&(l=Math.imul)),u=function(t){var e,n,u,p,h,c;for(h=t.length,p=Math.floor(h/2),u=e=0,c=function(){return t.charCodeAt(u++)},n=function(t,n){var s;return s=t|n<<16,s^=s<<9,s=l(s,r),s=s<<15|s>>>17,s=l(s,i),e^=s,e=e<<13|e>>>19,e=l(e,5),e=e+o|0};p--;)n(c(),c());return 1&h&&n(c(),0),e^=h,e^=e>>>16,e=l(e,s),e^=e>>>13,e=l(e,a),e^=e>>>16},e.exports=u},{}],194:[function(t,e,n){n.Factory=t("./factory"),n.Material=t("./material"),n.library=t("./library"),n.cache=t("./cache"),n.queue=t("./queue"),n.hash=t("./hash")},{"./cache":191,"./factory":192,"./hash":193,"./library":195,"./material":196,"./queue":197}],195:[function(t,e,n){var r;r=function(t,e,n){var r,i,o,s;return r=null,s={},null!=e&&("function"==typeof e?r=function(r){return n(t,r,e(r))}:"object"==typeof e&&(r=function(r){if(null==e[r])throw new Error("Unknown snippet `"+r+"`");return n(t,r,e[r])})),o=function(e){return n(t,"",e)},null==r?o:(i=function(t){return t.match(/[{;]/)?o(t):(s[t]=!0,r(t))},i.used=function(t){return null==t&&(t=s),s=t},i)},e.exports=r},{}],196:[function(t,e,n){var r,i,o,s;o=!1,i=t("../visualize"),s=function(){var t;return t=+new Date,function(e){var n;return n=+new Date-t,console.log(e,n+" ms"),n}},r=function(){function t(t,e){this.vertex=t,this.fragment=e,o&&(this.tock=s())}return t.prototype.build=function(t){return this.link(t)},t.prototype.link=function(t){var e,n,r,s,a,u,l,p,h,c,f,d,m,v;for(null==t&&(t={}),f={},m={},e={},v=this.vertex.link("main"),n=this.fragment.link("main"),u=[v,n],r=0,a=u.length;a>r;r++){c=u[r],l=c.uniforms;for(s in l)d=l[s],f[s]=d;p=c.varyings;for(s in p)d=p[s],m[s]=d;h=c.attributes;for(s in h)d=h[s],e[s]=d}return t.vertexShader=v.code,t.vertexGraph=v.graph,t.fragmentShader=n.code,t.fragmentGraph=n.graph,t.attributes=e,t.uniforms=f,t.varyings=m,t.inspect=function(){return i.inspect("Vertex Shader",v,"Fragment Shader",n.graph)},o&&this.tock("Material build"),t},t.prototype.inspect=function(){return i.inspect("Vertex Shader",this.vertex,"Fragment Shader",this.fragment.graph)},t}(),e.exports=r},{"../visualize":216}],197:[function(t,e,n){var r;r=function(t){var e,n,r,i,o,s;return null==t&&(t=100),i={},r=null,s=null,n=0,e=function(t){return t.prev=null,t.next=r,null!=r&&(r.prev=t),r=t,null==s?s=t:void 0},o=function(t){var e,n;return n=t.prev,e=t.next,null!=n&&(n.next=e),null!=e&&(e.prev=n),r===t&&(r=e),s===t?s=n:void 0},function(a){var u,l;return(l=i[a]&&l!==r)?(o(l),e(l)):(n===t?(u=s.key,o(s),delete i[u]):n++,l={next:r,prev:null,key:a},e(l),i[a]=l),u}},e.exports=r},{}],198:[function(t,e,n){var r,i,o,s;r=function(t){var e,n,r,s,a;return n=t.ast,r=t.code,a=t.signatures,s=i(a),e=o(r,s),[a,e]},s=function(){var t;return t=+new Date,function(e){var n;return n=+new Date-t,console.log(e,n+" ms"),n}},i=function(t){var e,n,r,i,o,s,a,u,l,p;for(s={},l=function(t){return s[t.name]=!0},l(t.main),a=["external","internal","varying","uniform","attribute"],e=0,i=a.length;i>e;e++)for(r=a[e],u=t[r],n=0,o=u.length;o>n;n++)p=u[n],l(p);return s},o=function(t,e){var n,r;return r=new RegExp("\\b("+function(){var t;t=[];for(n in e)t.push(n);return t}().join("|")+")\\b","g"),t=t.replace(/\/\/[^\n]*/g,""),t=t.replace(/\/\*([^*]|\*[^\/])*\*\//g,""),function(i,o,s){var a,u,l,p;null==i&&(i=""),null==o&&(o={}),null==s&&(s={}),l={};for(n in e)l[n]=null!=o[n]?n:i+n;return a=t.replace(r,function(t){return l[t]}),u=function(){var t;t=[];for(n in s)p=s[n],t.push("#define "+n+" "+p);return t}(),u.length&&u.push(""),u.join("\n")+a}},e.exports=r},{}],199:[function(t,e,n){e.exports={SHADOW_ARG:"_i_o",RETURN_ARG:"return"}},{}],200:[function(t,e,n){var r,i,o,s,a,u,l;e.exports=i={},i["in"]=0,i.out=1,i.inout=2,s=function(t){return t.token.data},i.node=function(t){var e,n;return"function"===(null!=(e=t.children[5])?e.type:void 0)?i["function"](t):"keyword"===(null!=(n=t.token)?n.type:void 0)?i.external(t):void 0},i.external=function(t){var e,n,r,i,o,a,u,l,p,h,c,f,d;for(e=t.children,c=s(e[1]),f=s(e[3]),d=s(e[4]),a=e[5],"attribute"!==c&&"uniform"!==c&&"varying"!==c&&(c="global"),l=[],h=a.children,n=i=0,o=h.length;o>i;n=++i)e=h[n],"ident"===e.type&&(r=s(e),u=a.children[n+1],p="quantifier"===(null!=u?u.type:void 0),l.push({decl:"external",storage:c,type:d,ident:r,quant:!!p,count:p}));return l},i["function"]=function(t){var e,n,r,o,a,u,l,p,h,c;return r=t.children,p=s(r[1]),h=s(r[3]),c=s(r[4]),u=r[5],l=s(u.children[0]),e=u.children[1],n=u.children[2],a=function(){var t,n,r,s;for(r=e.children,s=[],t=0,n=r.length;n>t;t++)o=r[t],s.push(i.argument(o));return s}(),[{decl:"function",storage:p,type:c,ident:l,body:!!n,args:a}]},i.argument=function(t){var e,n,r,i,o,a,u,l;return e=t.children,u=s(e[1]),i=s(e[2]),l=s(e[4]),o=e[5],r=s(o.children[0]),a=o.children[1],n=a?a.children[0].token.data:void 0,{decl:"argument",storage:u,inout:i,type:l,ident:r,quant:!!a,count:n}},i.param=function(t,e,n,r,o){var s,a,u;return a=[],null!=e&&a.push(e),null!=n&&a.push(n),a.push(""),a=a.join(" "),u=r?"["+o+"]":"",""!==t&&(t+=" "),s=function(e,n){return(n?t:"")+(""+a+e+u)},s.split=function(t){return i.param(t,e,n,r,o)},s},l="undefined"!=typeof window,u=l&&!!window.THREE,o={"int":0,"float":0,vec2:u?THREE.Vector2:null,vec3:u?THREE.Vector3:null,vec4:u?THREE.Vector4:null,mat2:null,mat3:u?THREE.Matrix3:null,mat4:u?THREE.Matrix4:null,sampler2D:0,samplerCube:0},a={"int":"i","float":"f",vec2:"v2",vec3:"v3",vec4:"v4",mat2:"m2",mat3:"m3",mat4:"m4",sampler2D:"t",samplerCube:"t"},i.type=function(t,e,n,s,u,l){var p,h,c,f,d,m,v;return p={"in":i["in"],out:i.out,inout:i.inout},d={"const":"const"},m=a[e],n&&(m+="v"),v=o[e],(null!=v?v.call:void 0)&&(v=new v),n&&(v=[v]),h=null!=(f=p[u])?f:p["in"],l=d[l],c=i.param(u,l,e,n,s),new r(t,m,e,c,v,h)},r=function(){function t(t,e,n,r,i,o,s){this.name=t,this.type=e,this.spec=n,this.param=r,this.value=i,this.inout=o,this.meta=s}return t.prototype.split=function(){var e,n,r,o;return r=null!=this.meta.shadowed,e=r?"in":"out",n=r?i["in"]:i.out,o=this.param.split(e),new t(this.name,this.type,this.spec,o,this.value,n)},t.prototype.copy=function(e,n){var r;return r=new t(null!=e?e:this.name,this.type,this.spec,this.param,this.value,this.inout,n)},t}()},{}],201:[function(t,e,n){var r,i,o;i=t("../graph"),r=t("./constants"),e.exports=o={unshadow:function(t){var e;return e=t.replace(r.SHADOW_ARG,""),e!==t?e:null},lines:function(t){return t.join("\n")},list:function(t){return t.join(", ")},statements:function(t){return t.join(";\n")},body:function(t){return{entry:t,type:"void",params:[],signature:[],"return":"",vars:{},calls:[],post:[],chain:{}}},define:function(t,e){return"#define "+t+" "+e},"function":function(t,e,n,r,i){return t+" "+e+"("+n+") {\n"+r+i+"}"},invoke:function(t,e,n){return t=t?t+" = ":"",n=o.list(n),"  "+t+e+"("+n+")"},same:function(t,e){var n,i,o,s,a;for(o=s=0,a=t.length;a>s;o=++s){if(n=t[o],i=e[o],!i)return!1;if(n.type!==i.type)return!1;if(n.name===r.RETURN_ARG!=(i.name===r.RETURN_ARG))return!1}return!0},call:function(t,e,n,i,s){var a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E;for(u=[],x="",k=1,f=0,d=i.length;d>f;f++){if(a=i[f],v=a.name,l=p=t(v),_=null,m=null,y=!1,h=a.inout,c=v===r.RETURN_ARG,(E=null!=(b=a.meta)?b.shadowed:void 0)&&(_=t(E),_&&(s.vars[_]="  "+a.param(_),s.calls.push("  "+_+" = "+p),e(E)?m={shadowed:_}:a=a.split())),(E=null!=(w=a.meta)?w.shadow:void 0)&&(_=t(E))){if(e(E)){m={shadow:_};continue}a=a.split(),y=!0}c?x=p:y||u.push(null!=_?_:p),e(v)?(g="push",c?""===s["return"]?(g="unshift",l=v,s.type=a.spec,s["return"]="  return "+p,s.vars[p]="  "+a.param(p)):(s.vars[p]="  "+a.param(p),s.params.push(a.param(p,!0))):s.params.push(a.param(p,!0)),a=a.copy(l,m),s.signature[g](a)):s.vars[p]="  "+a.param(p)}return s.calls.push(o.invoke(x,n,u))},build:function(t,e){var n,r,i,s,a,u,l,p,h,c,f;return a=t.entry,i=null,e&&1===e.length&&"main"!==a&&(n=t,r=e[0].module,o.same(t.signature,r.main.signature)&&(i=o.define(a,r.entry))),null==i&&(f=function(){var e,n;e=t.vars,n=[];for(c in e)s=e[c],n.push(s);return n}(),e=t.calls,l=t.post,u=t.params,h=t.type,p=t["return"],e=e.concat(l),""!==p&&e.push(p),e.push(""),f.length?(f.push(""),f=o.statements(f)+"\n"):f="",e=o.statements(e),u=o.list(u),i=o["function"](h,a,u,f,e)),{signature:t.signature,code:i,name:a}},links:function(t){var e,n,r,i;for(i={defs:[],bodies:[]},e=0,r=t.length;r>e;e++)n=t[e],o.link(n,i);return i.defs=o.lines(i.defs),i.bodies=o.statements(i.bodies),""===i.defs&&delete i.defs,""===i.bodies&&delete i.bodies,i},link:function(t){return function(t,e){var n,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T;if(_=t.module,w=t.name,p=t.external,y=_.main,l=_.entry,o.same(y.signature,p.signature))return e.defs.push(o.define(w,l));for(c=[],E=[],g={},M=[_.namespace,r.RETURN_ARG].join(""),S=p.signature,f=0,d=S.length;d>f;f++)u=S[f],v=u.inout===i.IN?c:E,v.push(u);for(z=y.signature,b=0,m=z.length;m>b;b++)u=z[b],v=u.inout===i.IN?c:E,x=v.shift(),a=x.name,a===r.RETURN_ARG&&(a=M),g[u.name]=a;return s=function(t){return g[t]},n=function(){return!0},h=o.body(),o.call(s,n,l,y.signature,h),h.entry=l,g={"return":M},s=function(t){var e;return null!=(e=g[t])?e:t},k=o.body(),T=o.call(s,n,l,p.signature,k),k.calls=h.calls,k.entry=w,e.bodies.push(o.build(h).code.split(" {")[0]),e.bodies.push(o.build(k).code)}}(this),defuse:function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m;for(f=/([A-Za-z0-9_]+\s+)?[A-Za-z0-9_]+\s+[A-Za-z0-9_]+\s*\([^)]*\)\s*;\s*/gm,m=function(t){return t.replace(f,function(t){return""})},n=t.split(/(?=[{}])/g),p=0,o=a=0,u=n.length;u>a;o=++a){switch(e=n[o],e[0]){case"{":p++;break;case"}":p--}if(0===p){for(r=e.split(/^[ \t]*#/m),s=c=0,l=r.length;l>c;s=++c)h=r[s],s>0?(h=h.split(/\n/),i=h.shift(),d=h.join("\n"),r[s]=[i,m(d)].join("\n")):r[s]=m(h);n[o]=r.join("#")}}return t=n.join("")},dedupe:function(t){var e,n;return e={},n=/((attribute|uniform|varying)\s+)[A-Za-z0-9_]+\s+([A-Za-z0-9_]+)\s*(\[[^\]]*\]\s*)?;\s*/gm,t.replace(n,function(t,n,r,i,o){return e[i]?"":(e[i]=!0,t)})},hoist:function(t){var e,n,r,i,o,s,a,u;for(u=/^#define ([^ ]+ _pg_[0-9]+_|_pg_[0-9]+_ [^ ]+)$/,o=t.split(/\n/g),e=[],a=[],n=0,r=o.length;r>n;n++)i=o[n],s=i.match(u)?e:a,s.push(i);return e.concat(a).join("\n")}}},{"../graph":205,"./constants":199}],202:[function(t,e,n){var r,i,o,s,a;for(n.compile=t("./compile"),n.parse=t("./parse"),n.generate=t("./generate"),s=t("./constants"),a=r=0,o=s.length;o>r;a=++r)i=s[a],n[i]=a},{"./compile":198,"./constants":199,"./generate":201,"./parse":203}],203:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v;
m=t("../../vendor/glsl-tokenizer"),h=t("../../vendor/glsl-parser"),s=t("./decl"),r=t("./constants"),o=!1,l=function(t,e){var n,r;return n=p(t,e),r=c(n,e)},p=function(t,e){var n,r,i,s,a,u,l,p,c,f,v;o&&(v=d());try{c=m().process(h(),e),f=c[0],n=f[0],a=c[1]}catch(s){r=s,a=[{message:r}]}if(o&&v("GLSL Tokenize & Parse"),u=function(t){var e,n;return t=t.split("\n"),e=(""+t.length).length,n=function(t){return(t=""+t).length<e?("       "+t).slice(-e):t},t.map(function(t,e){return n(e+1)+": "+t}).join("\n")},!n||a.length){for(t||(t="(inline code)"),console.warn(u(e)),l=0,p=a.length;p>l;l++)i=a[l],console.error(t+" -",i.message);throw new Error("GLSL parse error")}return n},c=function(t,e){var n,r,s,l,p,h,c;return o&&(c=d()),h=[],v(u,i(h),t,""),l=f(h),s=l[0],r=l[1],n=l[2],p=a(s,r,n),o&&c("GLSL AST"),{ast:t,code:e,signatures:p}},u=function(t,e){switch(t.type){case"decl":return e(s.node(t)),!1}return!0},i=function(t){return function(e){var n,r,i,o;if(null!=e){for(o=[],n=0,r=e.length;r>n;n++)i=e[n],o.push(t.push(i));return o}}},f=function(t){var e,n,r,i,o,s,a,u,l;for(a=null,i=[],n=[],u={},r=!1,o=0,s=t.length;s>o;o++)l=t[o],l.body?(u[l.ident]&&(n=function(){var t,r,i;for(i=[],t=0,r=n.length;r>t;t++)e=n[t],e.ident!==l.ident&&i.push(e);return i}(),delete u[l.ident]),i.push(l),"main"===l.ident?(a=l,r=!0):r||(a=l)):"global"===l.storage?i.push(l):(n.push(l),u[l.ident]=!0);return[a,i,n]},a=function(t,e,n){var i,o,a,u,l,p,h,c,f;for(c={uniform:[],attribute:[],varying:[],external:[],internal:[],global:[],main:null},o=function(t){return s.type(t.ident,t.type,t.quant,t.count,t.inout,t.storage)},a=function(t,e){var n,i,a,u,l,p,h,c,f,d,m;for(d=function(){var e,n,r,s;for(r=t.args,s=[],e=0,n=r.length;n>e;e++)i=r[e],s.push(o(i));return s}(),h=0,c=d.length;c>h;h++)u=d[h],u.inout===s.inout&&(n=u,a=u.copy(),n.inout=s["in"],a.inout=s.out,a.meta={shadow:n.name},a.name+=r.SHADOW_ARG,n.meta={shadowed:a.name},d.push(a));return"void"!==t.type&&d.unshift(s.type(r.RETURN_ARG,t.type,!1,"","out")),p=function(){var t,e,n;for(n=[],t=0,e=d.length;e>t;t++)u=d[t],u.inout===s["in"]&&n.push(u.type);return n}().join(","),f=function(){var t,e,n;for(n=[],t=0,e=d.length;e>t;t++)u=d[t],u.inout===s.out&&n.push(u.type);return n}().join(","),m="("+p+")("+f+")",l={name:t.ident,type:m,signature:d,inout:e,spec:t.type}},c.main=a(t,s.out),u=0,p=e.length;p>u;u++)f=e[u],c.internal.push({name:f.ident});for(l=0,h=n.length;h>l;l++)switch(f=n[l],f.decl){case"external":i=o(f),c[f.storage].push(i);break;case"function":i=a(f,s["in"]),c.external.push(i)}return c},o=!1,v=function(t,e,n,r){var i,s,a,u,l,p,h,c;if(o&&console.log(r,n.type,null!=(p=n.token)?p.data:void 0,null!=(h=n.token)?h.type:void 0),l=t(n,e))for(c=n.children,s=a=0,u=c.length;u>a;s=++a)i=c[s],v(t,e,i,r+"  ",o);return null},d=function(){var t;return t=+new Date,function(e){var n;return n=+new Date-t,console.log(e,n+" ms"),n}},e.exports=v,e.exports=l},{"../../vendor/glsl-parser":219,"../../vendor/glsl-tokenizer":223,"./constants":199,"./decl":200}],204:[function(t,e,n){var r;r=function(){function t(e,n){this.parent=null!=n?n:null,this.id=t.id(),this.nodes=[],e&&this.add(e)}return t.index=0,t.id=function(e){return++t.index},t.IN=0,t.OUT=1,t.prototype.inputs=function(){var t,e,n,r,i,o,s,a,u;for(e=[],a=this.nodes,t=0,r=a.length;r>t;t++)for(o=a[t],u=o.inputs,n=0,i=u.length;i>n;n++)s=u[n],null===s.input&&e.push(s);return e},t.prototype.outputs=function(){var t,e,n,r,i,o,s,a,u;for(s=[],a=this.nodes,t=0,n=a.length;n>t;t++)for(i=a[t],u=i.outputs,e=0,r=u.length;r>e;e++)o=u[e],0===o.output.length&&s.push(o);return s},t.prototype.getIn=function(t){var e;return function(){var n,r,i,o;for(i=this.inputs(),o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.getOut=function(t){var e;return function(){var n,r,i,o;for(i=this.outputs(),o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.add=function(t,e){var n,r,i;{if(!t.length){if(t.graph&&!e)throw new Error("Adding node to two graphs at once");return t.graph=this,this.nodes.push(t)}for(r=0,i=t.length;i>r;r++)n=t[r],this.add(n)}},t.prototype.remove=function(t,e){var n,r,i;{if(!t.length){if(t.graph!==this)throw new Error("Removing node from wrong graph.");return e||t.disconnect(),this.nodes.splice(this.nodes.indexOf(t),1),t.graph=null}for(r=0,i=t.length;i>r;r++)n=t[r],this.remove(n)}},t.prototype.adopt=function(t){var e,n,r;{if(!t.length)return t.graph.remove(t,!0),this.add(t,!0);for(n=0,r=t.length;r>n;n++)e=t[n],this.adopt(e)}},t}(),e.exports=r},{}],205:[function(t,e,n){n.Graph=t("./graph"),n.Node=t("./node"),n.Outlet=t("./outlet"),n.IN=n.Graph.IN,n.OUT=n.Graph.OUT},{"./graph":204,"./node":206,"./outlet":207}],206:[function(t,e,n){var r,i,o;r=t("./graph"),o=t("./outlet"),i=function(){function t(e,n){this.owner=e,this.graph=null,this.inputs=[],this.outputs=[],this.all=[],this.outlets=null,this.id=t.id(),this.setOutlets(n)}return t.index=0,t.id=function(e){return++t.index},t.prototype.getIn=function(t){var e;return function(){var n,r,i,o;for(i=this.inputs,o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.getOut=function(t){var e;return function(){var n,r,i,o;for(i=this.outputs,o=[],n=0,r=i.length;r>n;n++)e=i[n],e.name===t&&o.push(e);return o}.call(this)[0]},t.prototype.get=function(t){return this.getIn(t)||this.getOut(t)},t.prototype.setOutlets=function(t){var e,n,r,i,s,a,u,l,p,h,c,f;if(null!=t){if(null==this.outlets){for(this.outlets={},r=0,u=t.length;u>r;r++)c=t[r],c instanceof o||(c=o.make(c)),this._add(c);return}for(n=function(t){return[t.name,t.inout,t.type].join("-")},h={},i=0,l=t.length;l>i;i++)c=t[i],h[n(c)]=!0;f=this.outlets;for(a in f)c=f[a],a=n(c),h[a]?h[a]=c:this._remove(c);for(s=0,p=t.length;p>s;s++)c=t[s],e=h[n(c)],e instanceof o?this._morph(e,c):(c instanceof o||(c=o.make(c)),this._add(c))}return this.outlets},t.prototype.connect=function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w;for(d={},s={},w=function(t){return b+"/"+t.hint},m=t.inputs,a=0,p=m.length;p>a;a++)r=m[a],(n||!r.input)&&(b=r.type,o=w(r),s[o]||(s[o]=r),d[b]=f=d[b]||[],f.push(r));for(_=this.outputs,_=_.filter(function(t){return!(e&&t.output.length)}),v=_.slice(),u=0,h=v.length;h>u;u++)g=v[u],b=g.type,o=w(g),i=d[b],(r=s[o])&&(g.connect(r),delete s[o],i.splice(i.indexOf(r),1),_.splice(_.indexOf(g),1));if(!_.length)return this;for(y=_.slice(),l=0,c=y.length;c>l;l++)g=y[l],b=g.type,i=d[b],i&&i.length&&g.connect(i.shift());return this},t.prototype.disconnect=function(t){var e,n,r,i,o,s,a;for(s=this.inputs,e=0,r=s.length;r>e;e++)o=s[e],o.disconnect();for(a=this.outputs,n=0,i=a.length;i>n;n++)o=a[n],o.disconnect();return this},t.prototype._key=function(t){return[t.name,t.inout].join("-")},t.prototype._add=function(t){var e;if(e=this._key(t),t.node)throw new Error("Adding outlet to two nodes at once.");if(this.outlets[e])throw new Error("Adding two identical outlets to same node. ("+e+")");return t.node=this,t.inout===r.IN&&this.inputs.push(t),t.inout===r.OUT&&this.outputs.push(t),this.all.push(t),this.outlets[e]=t},t.prototype._morph=function(t,e){var n;return n=this._key(e),delete this.outlets[n],t.morph(e),n=this._key(e),this.outlets[n]=e},t.prototype._remove=function(t){var e,n;if(n=this._key(t),e=t.inout,t.node!==this)throw new Error("Removing outlet from wrong node.");return t.disconnect(),t.node=null,delete this.outlets[n],t.inout===r.IN&&this.inputs.splice(this.inputs.indexOf(t),1),t.inout===r.OUT&&this.outputs.splice(this.outputs.indexOf(t),1),this.all.splice(this.all.indexOf(t),1),this},t}(),e.exports=i},{"./graph":204,"./outlet":207}],207:[function(t,e,n){var r,i;r=t("./graph"),i=function(){function t(e,n,r,i,o,s){this.inout=e,this.name=n,this.hint=r,this.type=i,this.meta=null!=o?o:{},this.id=s,null==this.hint&&(this.hint=t.hint(this.name)),this.node=null,this.input=null,this.output=[],null==this.id&&(this.id=t.id(this.hint))}return t.make=function(e,n){var r,i,o,s;if(null==n&&(n={}),i=n,null!=e.meta){o=e.meta;for(r in o)s=o[r],i[r]=s}return new t(e.inout,e.name,e.hint,e.type,i)},t.index=0,t.id=function(e){return"_io_"+ ++t.index+"_"+e},t.hint=function(t){return t=t.replace(/^_io_[0-9]+_/,""),t=t.replace(/_i_o$/,""),t=t.replace(/(In|Out|Inout|InOut)$/,"")},t.prototype.morph=function(t){return this.inout=t.inout,this.name=t.name,this.hint=t.hint,this.type=t.type,this.meta=t.meta},t.prototype.dupe=function(e){var n;return null==e&&(e=this.id),n=t.make(this),n.name=e,n},t.prototype.connect=function(t){if(this.inout===r.IN&&t.inout===r.OUT)return t.connect(this);if(this.inout!==r.OUT||t.inout!==r.IN)throw new Error("Can only connect out to in.");if(t.input!==this)return t.disconnect(),t.input=this,this.output.push(t)},t.prototype.disconnect=function(t){var e,n,r,i;if(this.input&&this.input.disconnect(this),this.output.length){if(!t){for(i=this.output,e=0,r=i.length;r>e;e++)t=i[e],t.input=null;return this.output=[]}if(n=this.output.indexOf(t),n>=0)return this.output.splice(n,1),t.input=null}},t}(),e.exports=i},{"./graph":204}],208:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m;r=t("./block"),i=t("./factory"),o=t("./glsl"),s=t("./graph"),a=t("./linker"),p=t("./visualize"),f=i.library,h=i.cache,m=p.visualize,c=p.inspect,l=a.Snippet,d=function(t,e){var n,r,i,o;null==e&&(e={}),r={};for(n in t)o=t[n],r[n]=null!=(i=e[n])?i:t[n];return r},u=function(){function t(e,n){var r;return this instanceof t?(r={globalUniforms:!1,globalVaryings:!0,globalAttributes:!0,globals:[],autoInspect:!1},this.config=d(r,n),void(this.fetch=h(f(o,e,l.load)))):new t(e,n)}return t.prototype.shader=function(t){var e;return null==t&&(t={}),e=d(this.config,t),new i.Factory(o,this.fetch,e)},t.prototype.material=function(t){return new i.Material(this.shader(t),this.shader(t))},t.prototype.inspect=function(e){return t.inspect(e)},t.prototype.visualize=function(e){return t.visualize(e)},t.Block=r,t.Factory=i,t.GLSL=o,t.Graph=s,t.Linker=a,t.Visualize=p,t.inspect=function(t){return c(t)},t.visualize=function(t){return m(t)},t}(),e.exports=u,"undefined"!=typeof window&&(window.ShaderGraph=u)},{"./block":188,"./factory":194,"./glsl":202,"./graph":205,"./linker":210,"./visualize":216}],209:[function(t,e,n){var r,i,o;r=t("../graph"),i=t("./priority"),o=function(t,e,n,o){var s,a,u,l,p,h,c,f,d,m,v,y,g,_;return l=t.generate,u={},y=[],g={},_={},a={},f={},m=function(){var t,r,s,h,c,d,m,b,w;for(d in o)m=o[d],v(m.node,m.module);return b=p(n),t=b[0],n=b[1],null!=e&&(t.entry=e),c=l.build(t,n),w=function(){var t;t=[];for(d in f)h=f[d],t.push(h);return t}().sort(function(t,e){return i.compare(t.priority,e.priority)}),s=w.map(function(t){return t.code}),s.push(c.code),r=l.lines(s),{namespace:c.name,library:f,body:c.code,code:r,main:c,entry:c.name,symbols:y,externals:u,uniforms:g,varyings:_,attributes:a}},p=function(t){return function(t){var e,n,r,i,o,s;for(t=function(){var e;e=[];for(s in t)n=t[s],e.push(n);return e}(),t.sort(function(t,e){return e.priority-t.priority}),r=function(t,n,r){var i,o,s,a;return h(t,n,r),a=n.main,s=n.entry,o=function(e){return d(t,e)},i=function(e){return c(t,e)},l.call(o,i,s,a.signature,e)},e=l.body(),i=0,o=t.length;o>i;i++)n=t[i],r(n.node,n.module,n.priority);return[e,t]}}(this),s=function(t,e,n){var r;return r=f[t],null!=r?r.priority=i.max(r.priority,n):f[t]={code:e,priority:n}},h=function(t,e,n){var r,o,u,l,p,h,c,f;n=i.make(n),p=e.library;for(l in p)u=p[l],s(l,u.code,i.nest(n,u.priority));s(e.namespace,e.body,n),h=e.uniforms;for(o in h)r=h[o],g[o]=r;c=e.varyings;for(o in c)r=c[o],_[o]=r;f=e.attributes;for(o in f)r=f[o],a[o]=r;return v(t,e)},v=function(t,e){var n,r,i,o,s,a,l,p,h;for(l=e.symbols,p=[],i=0,a=l.length;a>i;i++)if(s=l[i],r=e.externals[s],c(t,r.name)){n={};for(o in r)h=r[o],n[o]=h;n.name=d(t,r.name),u[s]=n,p.push(y.push(s))}else p.push(void 0);return p},c=function(t,e){var n;return n=t.get(e),n.inout===r.IN?null===n.input:n.inout===r.OUT?0===n.output.length:void 0},d=function(t,e){var n;return(n=t.get(e))?(n.input&&(n=n.input),e=n.name,n.id):null},m()},e.exports=o},{"../graph":205,"./priority":213}],210:[function(t,e,n){n.Snippet=t("./snippet"),n.Program=t("./program"),n.Layout=t("./layout"),n.assemble=t("./assemble"),n.link=t("./link"),n.priority=t("./priority"),n.load=n.Snippet.load},{"./assemble":209,"./layout":211,"./link":212,"./priority":213,"./program":214,"./snippet":215}],211:[function(t,e,n){var r,i,o,s;i=t("./snippet"),s=t("./link"),o=!1,r=function(){function t(t,e){this.language=t,this.graph=e,this.links=[],this.includes=[],this.modules={},this.visits={}}return t.prototype.callback=function(t,e,n,r,i){return this.links.push({node:t,module:e,priority:n,name:r,external:i})},t.prototype.include=function(t,e,n){var r;return null!=(r=this.modules[e.namespace])?r.priority=Math.max(n,r.priority):(this.modules[e.namespace]=!0,this.includes.push({node:t,module:e,priority:n}))},t.prototype.visit=function(t){return o&&console.log("Visit",t,!this.visits[t]),this.visits[t]?!1:this.visits[t]=!0},t.prototype.link=function(t){var e,n,r;e=s(this.language,this.links,this.includes,t),r=new i;for(n in e)r[n]=e[n];return r.graph=this.graph,r},t}(),e.exports=r},{"./link":212,"./snippet":215}],212:[function(t,e,n){var r,i,o;r=t("../graph"),i=t("./priority"),o=function(t,e,n,o){var s,a,u,l,p,h,c,f,d,m,v,y;return l=t.generate,h=[],m=[],u={},v={},a={},y={},f={},d=function(){var t,r,s,c,d,m,g,_,b,w;for(s=l.links(e),c=[],null!=s.defs&&c.push(s.defs),null!=s.bodies&&c.push(s.bodies),d=0,m=n.length;m>d;d++)_=n[d],p(_.node,_.module,_.priority);return w=function(){var t;t=[];for(b in f)g=f[b],t.push(g);return t}().sort(function(t,e){return i.compare(t.priority,e.priority)}),h=w.map(function(t){return t.code}),t=l.lines(h),t=l.defuse(t),c.length&&(t=[l.lines(c),t].join("\n")),t=l.hoist(t),t=l.dedupe(t),r=o,{namespace:r.main.name,code:t,main:r.main,entry:r.main.name,externals:u,uniforms:v,attributes:a,varyings:y}},s=function(t,e,n){var r;return r=f[t],null!=r?r.priority=i.max(r.priority,n):f[t]={code:e,priority:n}},p=function(t,e,n){var r,o,l,p,h,f,d,g,_,b,w,x,k;n=i.make(n),g=e.library;for(d in g)f=g[d],s(d,f.code,i.nest(n,f.priority));s(e.namespace,e.body,n),_=e.uniforms;for(p in _)r=_[p],v[p]=r;b=e.varyings;for(p in b)r=b[p],y[p]=r;w=e.attributes;for(p in w)r=w[p],a[p]=r;for(x=e.symbols,k=[],l=0,h=x.length;h>l;l++)p=x[l],o=e.externals[p],c(t,o.name)?(u[p]=o,k.push(m.push(p))):k.push(void 0);return k},c=function(t,e){var n,i,o,s;if(i=t.get(e),!i)throw n=null!=(o=null!=(s=t.owner.snippet)?s._name:void 0)?o:t.owner.namespace,new Error("Unable to link program. Unlinked callback `"+e+"` on `"+n+"`");return i.inout===r.IN?null===i.input:i.inout===r.OUT?0===i.output.length:void 0},d()},e.exports=o},{"../graph":205,"./priority":213}],213:[function(t,e,n){n.make=function(t){var e;return null==t&&(t=[]),t instanceof Array||(t=[null!=(e=+t)?e:0]),t},n.nest=function(t,e){return t.concat(e)},n.compare=function(t,e){var n,r,i,o,s,a;for(i=Math.min(t.length,e.length),n=r=0,a=i;a>=0?a>r:r>a;n=a>=0?++r:--r){if(o=t[n],s=e[n],o>s)return-1;if(s>o)return 1}return t=t.length,e=e.length,t>e?-1:e>t?1:0},n.max=function(t,e){return n.compare(t,e)>0?e:t}},{}],214:[function(t,e,n){var r,i,o;i=t("./snippet"),o=t("./assemble"),r=function(){function t(t,e,n){this.language=t,this.namespace=e,this.graph=n,this.calls={},this.requires={}}return t.index=0,t.entry=function(){return"_pg_"+ ++t.index+"_"},t.prototype.call=function(t,e,n){var r,i;return i=e.namespace,(r=this.calls[i])?r.priority=Math.max(r.priority,n):this.calls[i]={node:t,module:e,priority:n},this},t.prototype.require=function(t,e){var n;return n=e.namespace,this.requires[n]={node:t,module:e}},t.prototype.assemble=function(){var e,n,r,s;e=o(this.language,null!=(r=this.namespace)?r:t.entry,this.calls,this.requires),s=new i;for(n in e)s[n]=e[n];return s.graph=this.graph,s},t}(),e.exports=r},{"./assemble":209,"./snippet":215}],215:[function(t,e,n){var r;r=function(){function t(t,e,n,r,i){var o;this.language=t,this._signatures=e,this._compiler=n,this._name=r,this._original=i,this.namespace=null,this.code=null,this.main=null,this.entry=null,this.uniforms=null,this.externals=null,this.symbols=null,this.attributes=null,this.varyings=null,this.language||delete this.language,this._signatures||delete this._signatures,this._compiler||delete this._compiler,this._original||delete this._original,this._name||(this._name=null!=(o=this._signatures)?o.main.name:void 0)}return t.index=0,t.namespace=function(){return"_sn_"+ ++t.index+"_"},t.load=function(e,n,r){var i,o,s,a;return o=e.parse(n,r),s=e.compile(o),a=s[0],i=s[1],new t(e,a,i,n,r)},t.prototype.clone=function(){return new t(this.language,this._signatures,this._compiler,this._name,this._original)},t.prototype.bind=function(e,n,r,i){var o,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R,C,I,D,L,j,N,U,F,H,B,q,V;if(n===""+n?(C=[n,null!=r?r:{},null!=i?i:{}],r=C[0],n=C[1],i=C[2]):r!==""+r&&(I=[null!=r?r:{},void 0],i=I[0],r=I[1]),this.main=this._signatures.main,this.namespace=null!=(D=null!=r?r:this.namespace)?D:t.namespace(),this.entry=this.namespace+this.main.name,this.uniforms={},this.varyings={},this.attributes={},this.externals={},this.symbols=[],d={},f={},m=function(t){return f[t]=!0,t},M=function(t){return function(e){return t.namespace+e}}(this),e.globals)for(L=e.globals,v=0,w=L.length;w>v;v++)_=L[v],m(_);for(a=e.globalUniforms?m:M,u=e.globalVaryings?m:M,o=e.globalAttributes?m:M,s=M,V=function(t){return function(t){return d[t.name]=!0}}(this),B=function(t){return function(e,n){return t.uniforms[a(null!=n?n:e.name)]=e}}(this),q=function(t){return function(e){return t.varyings[u(e.name)]=e}}(this),l=function(t){return function(e){return t.attributes[o(e.name)]=e}}(this),c=function(t){return function(e){var n;return n=s(e.name),t.externals[n]=e,t.symbols.push(n)}}(this),R=function(t){return{type:t.type,name:t.name,value:t.value}},j=this._signatures.uniform,y=0,x=j.length;x>y;y++)p=j[y],V(p);for(N=this._signatures.uniform,b=0,k=N.length;k>b;b++)p=N[b],B(R(p));for(U=this._signatures.varying,T=0,E=U.length;E>T;T++)p=U[T],q(R(p));for(F=this._signatures.external,O=0,S=F.length;S>O;O++)p=F[O],c(p);for(H=this._signatures.attribute,P=0,z=H.length;z>P;P++)p=H[P],l(R(p));for(A in n)p=n[A],d[A]&&B(p,A);return this.body=this.code=this._compiler(this.namespace,f,i),i&&(h=function(){var t;t=[];for(g in i)q=i[g],t.push("#define "+g+" "+q);return t}().join("\n"),h.length&&(this._original=[h,"//----------------------------------------",this._original].join("\n"))),null},t}(),e.exports=r},{}],216:[function(t,e,n){var r,i,o,s,a,u;r=t("../Graph").Graph,n.serialize=a=t("./serialize"),n.markup=i=t("./markup"),u=function(t){var e;if(t)return t.nodes?(e=a(t),i.process(e)):t},s=function(t){return null==t?t:t instanceof Array?t.map(s):null!=t.vertex&&null!=t.fragment?[s(t.vertex,s(t.fragment))]:null!=t._graph?t._graph:null!=t.graph?t.graph:t},o=function(t){var e,n,r,i;for(i=[],n=0,r=t.length;r>n;n++)e=t[n],e instanceof Array?i=i.concat(o(e)):null!=e&&i.push(e);return i},n.visualize=function(){var t,e;return e=o(s([].slice.call(arguments))),i.merge(function(){var n,r,i;for(i=[],n=0,r=e.length;r>n;n++)t=e[n],t&&i.push(u(t));return i}())},n.inspect=function(){var t,e,r,o,s,a;for(t=n.visualize.apply(null,arguments),r=i.overlay(t),a=document.querySelectorAll(".shadergraph-overlay"),o=0,s=a.length;s>o;o++)e=a[o],e.remove();return document.body.appendChild(r),t.update(),r}},{"../Graph":182,"./markup":217,"./serialize":218}],217:[function(t,e,n){var r,i,o,s,a,u,l,p,h,c,f,d,m,v,y,g;l=t("../factory/hash"),y=function(t){return(""+t).replace(/^\s+|\s+$/g,"")},a=function(t,e,n,r){return"rgba("+[t,e,n,r].join(", ")+")"},p=function(t,e){var n,r,i,o,s,u,p;return null==e&&(e=1),r=1193046^l(t),p=255&r,i=r>>>8&255,n=r>>>16&255,o=Math.max(p,i,n),u=140/o,s=Math.round(o/3),p=Math.min(255,Math.round(u*Math.max(p,s))),i=Math.min(255,Math.round(u*Math.max(i,s))),n=Math.min(255,Math.round(u*Math.max(n,s))),a(p,i,n,e)},u=function(t){return t=null!=t?t:"",t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/'/g,"&#39;").replace(/"/g,"&quot;")},m=function(t){var e,n;return n=[],e=i(t,n),e.update=function(){return s(e,n)},r(e),e},r=function(t){var e,n,r,i,o;for(n=t.querySelectorAll(".shadergraph-code"),o=[],r=0,i=n.length;i>r;r++)e=n[r],o.push(function(){var t;return t=e,t.parentNode.classList.add("shadergraph-has-code"),t.parentNode.addEventListener("click",function(e){return t.style.display={block:"none",none:"block"}[t.style.display||"none"]})}());return o},o=function(t){var e,n,r,i,o,s,a,u,l,p,h,c,f,d,m;for(h={},u={},f=t.nodes,e=0,i=f.length;i>e;e++)p=f[e],h[p.id]=p;for(d=t.links,n=0,o=d.length;o>n;n++)a=d[n],null==u[l=a.from]&&(u[l]=[]),u[a.from].push(a);for(c=function(t,e){var n,r,i,o;if(null==e&&(e=0),t.depth=Math.max(null!=(o=t.depth)?o:0,e),i=u[t.id])for(n=0,r=i.length;r>n;n++)a=i[n],c(h[a.to],e+1);return null},m=t.nodes,r=0,s=m.length;s>r;r++)p=m[r],null==p.depth&&c(p);return null},i=function(t,e){var n,r,s,a,l,h,c,f,d,m,v,g,_,b,w,x,k,E,S,z,M,T,O,A,P,R;for(o(t),R=document.createElement("div"),R.classList.add("shadergraph-graph"),h=[],M={},T=t.nodes,f=0,g=T.length;g>f;f++){for(S=T[f],r=document.createElement("div"),r.classList.add("shadergraph-node"),r.classList.add("shadergraph-node-"+S.type),r.innerHTML='<div class="shadergraph-header">'+u(S.name)+"</div>",n=function(t,e){var n,i;return n=p(t.type),i=document.createElement("div"),i.classList.add("shadergraph-outlet"),i.classList.add("shadergraph-outlet-"+e),i.innerHTML='<div class="shadergraph-point" style="background: '+n+'"></div>\n<div class="shadergraph-type" style="color: '+n+'">'+u(t.type)+'</div>\n<div class="shadergraph-name">'+u(t.name)+"</div>",r.appendChild(i),M[t.id]=i.querySelector(".shadergraph-point")},O=S.inputs,d=0,_=O.length;_>d;d++)z=O[d],n(z,"in");for(A=S.outputs,m=0,b=A.length;b>m;m++)z=A[m],n(z,"out");null!=S.graph?r.appendChild(i(S.graph,e)):(s=document.createElement("div"),s.classList.add("shadergraph-clear"),r.appendChild(s)),null!=S.code&&(c=document.createElement("div"),c.classList.add("shadergraph-code"),c.innerHTML=u(y(S.code)),r.appendChild(c)),l=h[S.depth],null==l&&(l=document.createElement("div"),l.classList.add("shadergraph-column"),h[S.depth]=l),l.appendChild(r)}for(v=0,w=h.length;w>v;v++)l=h[v],null!=l&&R.appendChild(l);for(P=t.links,E=0,x=P.length;x>E;E++)k=P[E],a=p(k.type),e.push({color:a,out:M[k.out],"in":M[k["in"]]});return R},v=function(t){return t*t},d=function(t,e,n,r){var i,o,s,a,u,l,p,h;return o=n-t,s=r-e,i=Math.sqrt(v(o)+v(s)),h=Math.abs(s)>Math.abs(o),h?(l=(t+n)/2,p=(e+r)/2,a=s>0?.3:-.3,u=Math.min(Math.abs(o)/2,20+i/8),["M",t,e,"C",t+u,e+",",l,p-i*a,l,p,"C",l,p+i*a,n-u,r+",",n,r].join(" ")):(u=Math.min(Math.abs(o)/2.5,20+i/4),["M",t,e,"C",t+u,e+",",n-u,r+",",n,r].join(" "))},h=function(t){return null==t&&(t="svg"),document.createElementNS("http://www.w3.org/2000/svg",t)},s=function(t,e){var n,r,i,o,s,a,u,l,p,c,f,m;if(null!=t.parentNode){for(f=t.getBoundingClientRect(),s=0,u=e.length;u>s;s++)c=e[s],n=c.out.getBoundingClientRect(),r=c["in"].getBoundingClientRect(),c.coords={x1:(n.left+n.right)/2-f.left,y1:(n.top+n.bottom)/2-f.top,x2:(r.left+r.right)/2-f.left,y2:(r.top+r.bottom)/2-f.top};for(m=t.querySelector("svg"),null!=m&&t.removeChild(m),i=t;i.parentNode&&0===i.offsetHeight;)i=i.parentNode;for(m=h(),m.setAttribute("width",i.offsetWidth),m.setAttribute("height",i.offsetHeight),a=0,l=e.length;l>a;a++)c=e[a],o=c.coords,p=h("path"),p.setAttribute("d",d(o.x1,o.y1,o.x2,o.y2)),p.setAttribute("stroke",c.color),p.setAttribute("stroke-width",3),p.setAttribute("fill","transparent"),m.appendChild(p);return t.appendChild(m)}},f=function(t){var e,n,r,i;return n=document.createElement("div"),n.setAttribute("class","shadergraph-overlay"),e=document.createElement("div"),e.setAttribute("class","shadergraph-close"),e.innerHTML="&times;",i=document.createElement("div"),i.setAttribute("class","shadergraph-view"),r=document.createElement("div"),r.setAttribute("class","shadergraph-inside"),r.appendChild(t),i.appendChild(r),n.appendChild(i),n.appendChild(e),e.addEventListener("click",function(){return n.parentNode.removeChild(n)}),n},g=function(t){var e;return t instanceof Node?t:(e=document.createElement("span"),e.innerText=null!=t?t:"",e)},c=function(t){var e,n,r,i;if(1!==t.length){for(e=document.createElement("div"),r=0,i=t.length;i>r;r++)n=t[r],e.appendChild(g(n));return e.update=function(){var e,r,i;for(i=[],e=0,r=t.length;r>e;e++)n=t[e],i.push("function"==typeof n.update?n.update():void 0);return i},e}return g(t[0])},e.exports={process:m,merge:c,overlay:f}},{"../factory/hash":193}],218:[function(t,e,n){var r,i,o;r=t("../block"),i=function(t){return"("===t.type[0]},o=function(t){var e,n,i,s,a,u,l,p,h,c,f,d,m,v,y,g,_,b,w,x,k,E,S;for(v=[],d=[],w=t.nodes,i=0,p=w.length;p>i;i++){for(m=w[i],b={id:m.id,name:null,type:null,depth:null,graph:null,inputs:[],outputs:[]},v.push(b),s=b.inputs,_=b.outputs,e=m.owner,e instanceof r.Call?(b.name=e.snippet._name,b.type="call",b.code=e.snippet._original):e instanceof r.Callback?(b.name="Callback",b.type="callback",b.graph=o(e.graph)):e instanceof r.Isolate?(b.name="Isolate",b.type="isolate",b.graph=o(e.graph)):e instanceof r.Join?(b.name="Join",b.type="join"):null!=e&&(null==b.name&&(b.name=null!=(x=e.name)?x:e.type),null==b.type&&(b.type=e.type),null==b.code&&(b.code=e.code),null!=e.graph&&(b.graph=o(e.graph))),n=function(t){return t=t.replace(")(",")→("),t=t.replace("()","")},k=m.inputs,a=0,h=k.length;h>a;a++)g=k[a],s.push({id:g.id,name:g.name,type:n(g.type),open:null==g.input});for(E=m.outputs,u=0,c=E.length;c>u;u++)for(g=E[u],_.push({id:g.id,name:g.name,type:n(g.type),open:!g.output.length}),S=g.output,l=0,f=S.length;f>l;l++)y=S[l],d.push({from:m.id,out:g.id,to:y.node.id,"in":y.id,type:n(g.type)})}return{nodes:v,links:d}},e.exports=o},{"../block":188}],219:[function(t,e,n){e.exports=t("./lib/index")},{"./lib/index":221}],220:[function(t,e,n){function r(){return this}function i(t,e){var n=g[t];return e=e||0,n?e>n.lbp&&(n.lbp=e):(n=Object.create(y),n.id=t,n.lbp=e,g[t]=n),n}function o(t){var e,n=d;for(h(),e=n.nud();t<d.lbp;)n=d,h(),e=n.led(e);return e}function s(t,e,n){var r=i(t,e);r.led=n||function(t){return this.children=[t,o(e)],this.type="binary",this}}function a(t,e,n){var r=i(t,e);return r.led=n||function(t){return this.children=[t,o(e-1)],this.type="binary",this},r}function u(t,e){var n=i(t);return n.nud=e||function(){return this.children=[o(70)],this.type="unary",this},n}function l(t){var e=i(t,150);e.led=function(t){return this.children=[t],this.type="suffix",this}}function p(t){return a(t,10,function(t){return this.children=[t,o(9)],this.assignment=!0,this.type="assign",this})}function h(t){var e,n,i,o;if(t&&d.data!==t)return f.unexpected("expected `"+t+"`, got `"+d.data+"`");if(v>=m.length)return void(d=g["(end)"]);if(e=m[v++],n=e.data,i=e.type,"ident"===i)o=f.scope.find(n)||f.create_node(),i=o.type;else if("builtin"===i)o=g["(builtin)"];else if("keyword"===i)o=g["(keyword)"];else if("operator"===i){if(o=g[n],!o)return f.unexpected("unknown operator `"+n+"`")}else{if("float"!==i&&"integer"!==i)return f.unexpected("unexpected token.");i="literal",o=g["(literal)"]}return o&&(o.nud||(o.nud=r),o.children||(o.children=[])),o=Object.create(o),o.token=e,o.type=i,o.data||(o.data=n),d=o}function c(t){return function(){return f.unexpected(t)}}var f,d,m,v,y={nud:function(){return this.children&&this.children.length?this:c("unexpected")()},led:c("missing operator")},g={};i("(ident)").nud=r,i("(keyword)").nud=r,i("(builtin)").nud=r,i("(literal)").nud=r,i("(end)"),i(":"),i(";"),i(","),i(")"),i("]"),i("}"),a("&&",30),a("||",30),s("|",43),s("^",44),s("&",45),s("==",46),s("!=",46),s("<",47),s("<=",47),s(">",47),s(">=",47),s(">>",48),s("<<",48),s("+",50),s("-",50),s("*",60),s("/",60),s("%",60),s("?",20,function(t){return this.children=[t,o(0),(h(":"),o(0))],this.type="ternary",this}),s(".",80,function(t){return d.type="literal",f.fake(d),this.children=[t,d],h(),this}),s("[",80,function(t){return this.children=[t,o(0)],this.type="binary",h("]"),this}),s("(",80,function(t){if(this.children=[t],this.type="call",")"!==d.data)for(;;){if(this.children.push(o(0)),","!==d.data)break;h(",")}return h(")"),this}),u("-"),u("+"),u("!"),u("~"),u("defined"),u("(",function(){return this.type="group",this.children=[o(0)],h(")"),this}),u("++"),u("--"),l("++"),l("--"),p("="),p("+="),p("-="),p("*="),p("/="),p("%="),p("&="),p("|="),p("^="),p(">>="),p("<<="),e.exports=function(t,e){function n(t){f.unshift(t,!1);for(var e=0,r=t.children.length;r>e;++e)n(t.children[e]);f.shift()}f=t,m=e,v=0;var r;if(m.length){if(h(),r=o(0),r.parent=f[0],n(r),v<m.length)throw new Error("did not use all tokens");r.parent.children=[r]}}},{}],221:[function(t,e,n){function r(){function t(t){if("whitespace"===t.type||"line-comment"===t.type||"block-comment"===t.type)return void Jt.push(t);for(Zt.push(t),Pt=Pt||Zt[0],Pt&&Jt.length&&(Pt.preceding=Pt.preceding||[],Pt.preceding=Pt.preceding.concat(Jt),Jt=[]);n();)switch(Yt[0].mode){case m:F();break;case v:T();break;case b:Q();break;case w:$();break;case S:nt();break;case y:bt(!0,!0);break;case z:wt();break;case d:et();break;case O:tt();break;case A:K();break;case g:Tt();break;case _:Ot();break;case x:kt();break;case k:zt();break;case D:Mt();break;case P:St();break;case E:Et();break;case j:xt()}}function e(e){return arguments.length&&t(e),Yt.length>1?void lt("unexpected EOF"):void Wt.emit("end")}function n(){return Qt||!Yt.length?!1:(Pt=Zt[0])&&!Wt.paused}function r(t){Yt.unshift(t),Yt.shift()}function f(t,e){t.parent=Yt[0];var n=[].unshift.call(this,t);if(e=void 0===e?!0:e,c){for(var r="",i=0,o=this.length-1;o>i;++i)r+=" |";console.log(r,"\\"+t.type,t.token.data)}return e&&Rt!==t&&Rt.children.push(t),Rt=t,n}function M(){var t=[].shift.call(this),e=Xt[this.length],n=!1;if(c){for(var r="",i=0,o=this.length;o>i;++i)r+=" |";console.log(r,"/"+t.type)}return Xt.length?"function"==typeof Xt[0]?n=Xt[0](t):void 0!==e&&(n=e.test?e.test(t.type):e===t.type):n=!0,n&&Wt.emit("data",t),Rt=t.parent,t}function T(){function t(){if(Pt.data===Yt[0].expecting)return Yt.scope.exit(),Yt.shift();switch(Pt.type){case"preprocessor":return Yt.fake(it()),void Zt.shift();default:return void Yt.unshift(It())}}return ct(function(){return Yt.scope.enter(),h},t)()}function F(){if(Yt[0].brace)return"}"!==Pt.data?lt("expected `}`, got "+Pt.data):(Yt[0].brace=!1,Zt.shift(),Yt.shift());switch(Pt.type){case"eof":return Yt.shift();case"keyword":switch(Pt.data){case"for":return Yt.unshift(Ft());case"if":return Yt.unshift(Ht());case"while":return Yt.unshift(Bt());case"do":return Yt.unshift(Vt());case"break":return Yt.fake(i(R,Pt)),Zt.shift();case"continue":return Yt.fake(i(C,Pt)),Zt.shift();case"discard":return Yt.fake(i(I,Pt)),Zt.shift();case"return":return Yt.unshift(qt());case"precision":return Yt.unshift(Lt())}return Yt.unshift(ot(G));case"ident":var t;if(t=Yt.scope.find(Pt.data))return"struct"===t.parent.type?Yt.unshift(ot(G)):Yt.unshift(at(";"));case"operator":if("{"===Pt.data){Yt[0].brace=!0;var e=Ct();return e.expecting="}",Zt.shift(),Yt.unshift(e)}if(";"===Pt.data)return Zt.shift(),Yt.shift();default:return Yt.unshift(at(";"))}}function Q(){function t(){return"invariant"===Pt.data?d.flags&H?(Yt.unshift(ut()),h):lt("`invariant` is not allowed here"):(Yt.fake(i(L,{data:"",position:Pt.position})),h)}function e(){return o(Pt)?d.flags&B?(Yt.unshift(ut()),h):lt("storage is not allowed here"):(Yt.fake(i(L,{data:"",position:Pt.position})),h)}function n(){return s(Pt)?d.flags&q?lt("parameter is not allowed here"):(Yt.unshift(ut()),h):(Yt.fake(i(L,{data:"",position:Pt.position})),h)}function r(){return a(Pt)?(Yt.unshift(ut()),h):(Yt.fake(i(L,{data:"",position:Pt.position})),h)}function u(){if("struct"===Pt.data)return d.flags&V?(Yt.unshift(st()),h):lt("cannot nest structs");if("keyword"===Pt.type)return Yt.unshift(ut()),h;var t=Yt.scope.find(Pt.data);return t?(Yt.fake(Object.create(t)),Zt.shift(),h):lt("expected user defined type, struct or keyword, got "+Pt.data)}function l(){return","!==Pt.data||d.flags&U?"["===Pt.data?void Yt.unshift(Gt()):")"===Pt.data?Yt.shift():";"===Pt.data?d.stage+3:"ident"!==Pt.type?(console.log(Pt),
lt("expected identifier, got "+Pt.data)):(d.collected_name=Zt.shift(),h):Yt.shift()}function p(){return"("===Pt.data?(Zt.unshift(d.collected_name),delete d.collected_name,Yt.unshift(Nt()),d.stage+2):h}function c(){return Zt.unshift(d.collected_name),delete d.collected_name,Yt.unshift(Dt()),h}function f(){return Yt.shift()}var d=Yt[0];return ct(t,e,n,r,u,l,p,c,f)()}function $(){if("ident"===Pt.type){var t=Pt.data;return Yt.unshift(jt()),void Yt.scope.define(t)}if("operator"===Pt.type){if(","===Pt.data)return Yt[1].flags&U?Zt.shift():Yt.shift();if("="===Pt.data)return Yt[1].flags&N?(Zt.shift(),void Yt.unshift(at(",",";"))):lt("`=` is not allowed here.");if("["===Pt.data)return void Yt.unshift(Gt())}return Yt.shift()}function K(){return"keyword"===Pt.type?(Yt[0].type="keyword",void(Yt[0].mode=O)):"ident"===Pt.type?(Yt[0].type="ident",void(Yt[0].mode=d)):lt("expected keyword or user-defined name, got "+Pt.data)}function tt(){return"keyword"!==Pt.type?lt("expected keyword, got "+Pt.data):(Yt.shift(),Zt.shift())}function et(){return"ident"!==Pt.type?lt("expected user-defined name, got "+Pt.data):(Yt[0].data=Pt.data,Yt.shift(),Zt.shift())}function nt(){function t(t){return l(Yt,t),Yt.shift()}var e=Yt[0].expecting;if(Yt[0].tokens=Yt[0].tokens||[],void 0===Yt[0].parenlevel&&(Yt[0].parenlevel=0,Yt[0].bracelevel=0),Yt[0].parenlevel<1&&e.indexOf(Pt.data)>-1)return t(Yt[0].tokens);switch("("===Pt.data?++Yt[0].parenlevel:")"===Pt.data&&--Yt[0].parenlevel,Pt.data){case"{":++Yt[0].bracelevel;break;case"}":--Yt[0].bracelevel;break;case"(":++Yt[0].parenlevel;break;case")":--Yt[0].parenlevel}return Yt[0].parenlevel<0?lt("unexpected `)`"):Yt[0].bracelevel<0?lt("unexpected `}`"):void Yt[0].tokens.push(Zt.shift())}function rt(t){return function(){return i(t,Pt)}}function it(){return i(J[Pt.type],Pt,Rt)}function ot(t){var e=i(b,Pt,Rt);return e.flags=t,e}function st(t,e){var n=i(y,Pt,Rt);return n.allow_assign=void 0===t?!0:t,n.allow_comma=void 0===e?!0:e,n}function at(){var t=i(S,Pt,Rt);return t.expecting=[].slice.call(arguments),t}function ut(t){var e=Pt;return t&&(e={type:"(implied)",data:"(default)",position:e.position}),i(O,e,Rt)}function lt(t){Qt=!0,Wt.emit("error",new Error((t||"unexpected "+Yt)+" at line "+Yt[0].token.line))}function pt(t,e){return ht(t,Pt.type)&&ht(e,Pt.data)}function ht(t,e){switch(typeof t){case"string":return e!==t&&lt("expected `"+t+"`, got "+e+"\n"+Pt.data),!Qt;case"object":return t&&-1===t.indexOf(e)&&lt("expected one of `"+t.join("`, `")+"`, got "+e),!Qt}return!0}function ct(){var t,e,n=[].slice.call(arguments);return function(){var r=Yt[0];return r.stage||(r.stage=0),(t=n[r.stage])?(e=t(),e===h?++r.stage:void(void 0!==e&&(r.stage=e))):lt("parser in undefined state!")}}function ft(t,e){return e=e||"operator",function(){if(pt(e,t)){var n=Zt.shift(),r=Yt[0].children,i=r[r.length-1];return i&&i.token&&n.preceding&&(i.token.succeeding=i.token.succeeding||[],i.token.succeeding=i.token.succeeding.concat(n.preceding)),h}}}function dt(t){return function(){return Yt.unshift(at(t)),h}}function mt(t){return t?function(){var t=Pt.data;return pt("ident")&&(Yt.unshift(jt()),Yt.scope.define(t),h)}:function(){if(pt("ident")){var t=Object.create(Yt.scope.find(Pt.data));return t.token=Pt,Zt.shift(),h}}}function vt(){return function(){var t=Ct();return t.expecting="}",Yt.unshift(t),h}}function yt(t){return function(){var e=Yt[0].stage;return"{"!==Pt.data?(Yt.unshift(It()),e+t):(Zt.shift(),h)}}function gt(){return function(){return Yt.shift(),Yt.shift()}}function _t(){bt=ct(ft("struct","keyword"),function(){return"{"===Pt.data?(Yt.fake(i(d,{data:"",position:Pt.position,type:"ident"})),h):mt(!0)()},function(){return Yt.scope.enter(),h},ft("{"),function(){return"}"===Pt.data?(Yt.scope.exit(),Zt.shift(),Yt.shift()):";"===Pt.data?void Zt.shift():void Yt.unshift(ot(X))}),wt=ct(function(){return Zt.shift(),h},function(){return pt("keyword",["lowp","mediump","highp"])&&(Yt.unshift(ut()),h)},function(){return Yt.unshift(ut()),h},function(){return Yt.shift()}),xt=ct(ft("["),dt("]"),ft("]"),function(){return Yt.shift()}),kt=ct(ft("for","keyword"),ft("("),function(){var t;if("ident"===Pt.type){if((t=Yt.scope.find(Pt.data))||(t=Yt.create_node()),"struct"===t.parent.type)return Yt.unshift(ot(G)),h}else if("builtin"===Pt.type||"keyword"===Pt.type)return Yt.unshift(ot(G)),h;return dt(";")()},ft(";"),dt(";"),ft(";"),dt(")"),ft(")"),yt(3),vt(),ft("}"),gt()),Et=ct(ft("if","keyword"),ft("("),dt(")"),ft(")"),yt(3),vt(),ft("}"),function(){return"else"===Pt.data?(Zt.shift(),Yt.unshift(It()),h):gt()()},gt()),St=ct(ft("return","keyword"),function(){return";"===Pt.data?h:(Yt.unshift(at(";")),h)},function(){Zt.shift(),gt()()}),zt=ct(ft("while","keyword"),ft("("),dt(")"),ft(")"),yt(3),vt(),ft("}"),gt()),Mt=ct(ft("do","keyword"),yt(3),vt(),ft("}"),ft("while","keyword"),ft("("),dt(")"),ft(")"),gt()),Tt=ct(function(){for(var t=1,e=Yt.length;e>t;++t)if(Yt[t].mode===g)return lt("function definition is not allowed within another function");return h},function(){if(pt("ident")){var t=Pt.data,e=Yt.scope.find(t);return Yt.unshift(jt()),Yt.scope.define(t),Yt.scope.enter(e?e.scope:null),h}},ft("("),function(){return Yt.unshift(Ut()),h},ft(")"),function(){return";"===Pt.data?(Yt.scope.exit(),Yt.shift(),Yt.shift()):h},ft("{"),vt(),ft("}"),function(){return Yt.scope.exit(),h},function(){return Yt.shift(),Yt.shift(),Yt.shift()}),Ot=ct(function(){return"void"===Pt.data?(Yt.fake(ut()),Zt.shift(),h):")"===Pt.data?void Yt.shift():"struct"===Pt.data?(Yt.unshift(st(Y,Z)),h):(Yt.unshift(ot(W)),h)},function(){return","===Pt.data?(Zt.shift(),0):")"===Pt.data?void Yt.shift():void lt("expected one of `,` or `)`, got "+Pt.data)})}var bt,wt,xt,kt,Et,St,zt,Mt,Tt,Ot,At,Pt,Rt,Ct=rt(v),It=rt(m),Dt=rt(w),Lt=rt(z),jt=rt(d),Nt=(rt(A),rt(g)),Ut=rt(_),Ft=rt(x),Ht=rt(E),Bt=rt(k),qt=rt(P),Vt=rt(D),Gt=rt(j),Wt=u(t,e),Xt=arguments.length?[].slice.call(arguments):[],Yt=[],Zt=[],Jt=[],Qt=!1;return Yt.shift=M,Yt.unshift=f,Yt.fake=r,Yt.unexpected=lt,Yt.scope=new p(Yt),Yt.create_node=function(){var t=i(d,Pt);return t.parent=Wt.program,t},_t(),Rt=Ct(),Rt.expecting="(eof)",Rt.mode=v,Rt.token={type:"(program)",data:"(program)"},At=Rt,Wt.program=At,Wt.scope=function(t){return 1===arguments.length&&(Yt.scope=t),Yt.scope},Yt.unshift(Rt),Wt}function i(t,e){return{mode:t,token:e,children:[],type:Q[t]}}function o(t){return"const"===t.data||"attribute"===t.data||"uniform"===t.data||"varying"===t.data}function s(t){return"in"===t.data||"inout"===t.data||"out"===t.data}function a(t){return"highp"===t.data||"mediump"===t.data||"lowp"===t.data}e.exports=r;var u=t("../../through"),l=t("./expr"),p=t("./scope"),h=new Object,c=!1,f=0,d=f++,m=f++,v=f++,y=f++,g=f++,_=f++,b=f++,w=f++,x=f++,k=f++,E=f++,S=f++,z=f++,M=f++,T=f++,O=f++,A=f++,P=f++,R=f++,C=f++,I=f++,D=f++,L=f++,j=f++,N=1,U=2,F=4,H=8,B=16,q=32,V=64,G=255,W=G&~(N|U|q|H|F),X=G&~(N|H|B|V),Y=!1,Z=!1,J={"block-comment":M,"line-comment":M,preprocessor:T},Q=f=["ident","stmt","stmtlist","struct","function","functionargs","decl","decllist","forloop","whileloop","if","expr","precision","comment","preprocessor","keyword","keyword_or_ident","return","break","continue","discard","do-while","placeholder","quantifier"]},{"../../through":227,"./expr":220,"./scope":222}],222:[function(t,e,n){function r(t){return this.constructor!==r?new r(t):(this.state=t,this.scopes=[],void(this.current=null))}e.exports=r;var i=r,o=i.prototype;o.enter=function(t){this.scopes.push(this.current=this.state[0].scope=t||{})},o.exit=function(){this.scopes.pop(),this.current=this.scopes[this.scopes.length-1]},o.define=function(t){this.current[t]=this.state[0]},o.find=function(t,e){for(var n=this.scopes.length-1;n>-1;--n)if(this.scopes[n].hasOwnProperty(t))return this.scopes[n][t];return null}},{}],223:[function(t,e,n){function r(){function t(t){t.length&&L.queue({type:x[U],data:t,position:B,line:H})}function e(t){for(j=0,G+=t.toString(),D=G.length;C=G[j],D>j;)switch(U){case p:j=z();break;case h:j=S();break;case c:j=E();break;case f:j=M();break;case d:j=A();break;case w:j=O();break;case m:j=P();break;case l:j=R();break;case _:j=k();break;case u:j=r()}N+=j,G=G.slice(j)}function n(e){F.length&&t(F.join("")),U=b,t("(eof)"),L.queue(null)}function r(){return F=F.length?[]:F,"/"===I&&"*"===C?(B=N+j-1,U=p,I=C,j+1):"/"===I&&"/"===C?(B=N+j-1,U=h,I=C,j+1):"#"===C?(U=c,B=N+j,j):/\s/.test(C)?(U=_,B=N+j,j):(q=/\d/.test(C),V=/[^\w_]/.test(C),B=N+j,U=q?d:V?f:l,j)}function k(){return"\n"===C&&++H,/[^\s]/g.test(C)?(t(F.join("")),U=u,j):(F.push(C),I=C,j+1)}function E(){return"\n"===C&&++H,"\n"===C&&"\\"!==I?(t(F.join("")),U=u,j):(F.push(C),I=C,j+1)}function S(){return E()}function z(){return"/"===C&&"*"===I?(F.push(C),t(F.join("")),U=u,j+1):("\n"===C&&++H,F.push(C),I=C,j+1)}function M(){if("."===I&&/\d/.test(C))return U=m,j;if("/"===I&&"*"===C)return U=p,j;if("/"===I&&"/"===C)return U=h,j;if("."===C&&F.length){for(;T(F););return U=m,j}if(";"===C){if(F.length)for(;T(F););return t(C),U=u,j+1}var e=2===F.length&&"="!==C;if(/[\w_\d\s]/.test(C)||e){for(;T(F););return U=u,j}return F.push(C),I=C,j+1}function T(e){for(var n,r=0,i=e.length;;){n=s.indexOf(e.slice(0,e.length+r).join(""));{if(-1!==n)return t(s[n]),B+=s[n].length,F=F.slice(s[n].length),F.length;if(r-=1,i-=1,0>i)return 0}}}function O(){return/[^a-fA-F0-9]/.test(C)?(t(F.join("")),U=u,j):(F.push(C),I=C,j+1)}function A(){return"."===C?(F.push(C),U=m,I=C,j+1):/[eE]/.test(C)?(F.push(C),U=m,I=C,j+1):"x"===C&&1===F.length&&"0"===F[0]?(U=w,F.push(C),I=C,j+1):/[^\d]/.test(C)?(t(F.join("")),U=u,j):(F.push(C),I=C,j+1)}function P(){return"f"===C&&(F.push(C),I=C,j+=1),/[eE]/.test(C)?(F.push(C),I=C,j+1):/[^\d]/.test(C)?(t(F.join("")),U=u,j):(F.push(C),I=C,j+1)}function R(){if(/[^\d\w_]/.test(C)){var e=F.join("");return U=o.indexOf(e)>-1?g:a.indexOf(e)>-1?y:v,t(F.join("")),U=u,j}return F.push(C),I=C,j+1}var C,I,D,L=i(e,n),j=0,N=0,U=u,F=[],H=1,B=0,q=!1,V=!1,G="";return L}e.exports=r;var i=t("../through"),o=t("./lib/literals"),s=t("./lib/operators"),a=t("./lib/builtins"),u=999,l=9999,p=0,h=1,c=2,f=3,d=4,m=5,v=6,y=7,g=8,_=9,b=10,w=11,x=["block-comment","line-comment","preprocessor","operator","integer","float","ident","builtin","keyword","whitespace","eof","integer"]},{"../through":227,"./lib/builtins":224,"./lib/literals":225,"./lib/operators":226}],224:[function(t,e,n){e.exports=["gl_Position","gl_PointSize","gl_ClipVertex","gl_FragCoord","gl_FrontFacing","gl_FragColor","gl_FragData","gl_FragDepth","gl_Color","gl_SecondaryColor","gl_Normal","gl_Vertex","gl_MultiTexCoord0","gl_MultiTexCoord1","gl_MultiTexCoord2","gl_MultiTexCoord3","gl_MultiTexCoord4","gl_MultiTexCoord5","gl_MultiTexCoord6","gl_MultiTexCoord7","gl_FogCoord","gl_MaxLights","gl_MaxClipPlanes","gl_MaxTextureUnits","gl_MaxTextureCoords","gl_MaxVertexAttribs","gl_MaxVertexUniformComponents","gl_MaxVaryingFloats","gl_MaxVertexTextureImageUnits","gl_MaxCombinedTextureImageUnits","gl_MaxTextureImageUnits","gl_MaxFragmentUniformComponents","gl_MaxDrawBuffers","gl_ModelViewMatrix","gl_ProjectionMatrix","gl_ModelViewProjectionMatrix","gl_TextureMatrix","gl_NormalMatrix","gl_ModelViewMatrixInverse","gl_ProjectionMatrixInverse","gl_ModelViewProjectionMatrixInverse","gl_TextureMatrixInverse","gl_ModelViewMatrixTranspose","gl_ProjectionMatrixTranspose","gl_ModelViewProjectionMatrixTranspose","gl_TextureMatrixTranspose","gl_ModelViewMatrixInverseTranspose","gl_ProjectionMatrixInverseTranspose","gl_ModelViewProjectionMatrixInverseTranspose","gl_TextureMatrixInverseTranspose","gl_NormalScale","gl_DepthRangeParameters","gl_DepthRange","gl_ClipPlane","gl_PointParameters","gl_Point","gl_MaterialParameters","gl_FrontMaterial","gl_BackMaterial","gl_LightSourceParameters","gl_LightSource","gl_LightModelParameters","gl_LightModel","gl_LightModelProducts","gl_FrontLightModelProduct","gl_BackLightModelProduct","gl_LightProducts","gl_FrontLightProduct","gl_BackLightProduct","gl_FogParameters","gl_Fog","gl_TextureEnvColor","gl_EyePlaneS","gl_EyePlaneT","gl_EyePlaneR","gl_EyePlaneQ","gl_ObjectPlaneS","gl_ObjectPlaneT","gl_ObjectPlaneR","gl_ObjectPlaneQ","gl_FrontColor","gl_BackColor","gl_FrontSecondaryColor","gl_BackSecondaryColor","gl_TexCoord","gl_FogFragCoord","gl_Color","gl_SecondaryColor","gl_TexCoord","gl_FogFragCoord","gl_PointCoord","radians","degrees","sin","cos","tan","asin","acos","atan","pow","exp","log","exp2","log2","sqrt","inversesqrt","abs","sign","floor","ceil","fract","mod","min","max","clamp","mix","step","smoothstep","length","distance","dot","cross","normalize","faceforward","reflect","refract","matrixCompMult","lessThan","lessThanEqual","greaterThan","greaterThanEqual","equal","notEqual","any","all","not","texture2D","texture2DProj","texture2DLod","texture2DProjLod","textureCube","textureCubeLod"]},{}],225:[function(t,e,n){e.exports=["precision","highp","mediump","lowp","attribute","const","uniform","varying","break","continue","do","for","while","if","else","in","out","inout","float","int","void","bool","true","false","discard","return","mat2","mat3","mat4","vec2","vec3","vec4","ivec2","ivec3","ivec4","bvec2","bvec3","bvec4","sampler1D","sampler2D","sampler3D","samplerCube","sampler1DShadow","sampler2DShadow","struct","asm","class","union","enum","typedef","template","this","packed","goto","switch","default","inline","noinline","volatile","public","static","extern","external","interface","long","short","double","half","fixed","unsigned","input","output","hvec2","hvec3","hvec4","dvec2","dvec3","dvec4","fvec2","fvec3","fvec4","sampler2DRect","sampler3DRect","sampler2DRectShadow","sizeof","cast","namespace","using"]},{}],226:[function(t,e,n){e.exports=["<<=",">>=","++","--","<<",">>","<=",">=","==","!=","&&","||","+=","-=","*=","/=","%=","&=","^=","|=","(",")","[","]",".","!","~","*","/","%","+","-","<",">","&","^","|","?",":","=",",",";","{","}"]},{}],227:[function(t,e,n){var r;r=function(t,e){var n,r;return r=[],n=[],{output:r,parser:null,write:t,end:e,process:function(e,n){return this.parser=e,t(n),this.flush(),this.parser.flush()},flush:function(){return e(),[r,n]},queue:function(t){var e;return null!=t&&null!=(e=this.parser)?e.write(t):void 0},emit:function(t,e){return"data"===t&&null==e.parent&&r.push(e),"error"===t?n.push(e):void 0}}},e.exports=r},{}]},{},[30]);