#ifndef __SONGS_H__
#define __SONGS_H__

typedef enum {
  C3, Cd3, D3, Dd3, E3, F3, Fd3, G3, Gd3, A3, Ad3, B3,
  C4, Cd4, D4, Dd4, E4, F4, Fd4, G4, Gd4, A4, Ad4, B4,
  C5, Cd5, D5, Dd5, E5, F5, Fd5, G5, Gd5, A5, Ad5, B5,
  C6, Cd6, D6, Dd6, E6, F6, Fd6, G6, Gd6, A6, Ad6, B6,
  C7, Cd7, D7, Dd7, E7, F7, Fd7, G7, Gd7, A7, Ad7, B7,
  C8, Cd8, D8, Dd8, E8, F8, Fd8, G8, Gd8, A8, Ad8, B8,
  SILENCE
} Pitch;

const UWORD frequencies[] = { //values based on a formula used by the GB processor
  44, 156, 262, 363, 457, 547, 631, 710, 786, 854, 923, 986,
  1046, 1102, 1155, 1205, 1253, 1297, 1339, 1379, 1417, 1452, 1486, 1517,
  1546, 1575, 1602, 1627, 1650, 1673, 1694, 1714, 1732, 1750, 1767, 1783,
  1798, 1812, 1825, 1837, 1849, 1860, 1871, 1881, 1890, 1899, 1907, 1915,
  1923, 1930, 1936, 1943, 1949, 1954, 1959, 1964, 1969, 1974, 1978, 1982,
  1985, 1988, 1992, 1995, 1998, 2001, 2004, 2006, 2009, 2011, 2013, 2015,
  0
};

enum DurationNote
{
    LONG = 0x84U,
    SHORT = 0x81U,
    LONG_LONG = 135
};

//Define Instrument names
//Instruments should be confined to one channel
//due to different registers used between ch1, 2, 3, 4
typedef enum {
	NONE,
	MELODY,  //channel 1
	HARMONY, //channel 1
	SNARE,   //channel 2
    WAVE,    //channel 3
	CYMBAL   //channel 4
} Instrument;

//Define a Note as having a Pitch, Instrument, and volume envelope
typedef struct {
	Instrument i;
	Pitch p;
	UINT16 env;
} Note;

const Note song_menu_ch1[] = { //Notes to be played on channel 1
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, C5, LONG},
    {MELODY, C5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, B4, LONG},
    {MELODY, B4, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, C5, LONG},
    {MELODY, B4, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A5, LONG},
    {MELODY, G5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, F5, LONG},
    {MELODY, F5, LONG},
    {MELODY, E5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, E5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, C5, LONG},
    {MELODY, B4, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A5, LONG},
    {MELODY, G5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, F5, LONG},
    {MELODY, F5, LONG},
    {MELODY, E5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
};

const Note song_menu_ch2[] = { //Notes to be played on channel 1
	{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
};

const Note song_menu_ch4[] = { //Notes to be played on channel 1
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},

    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},{NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
};

const Note song_gameover_ch1[] = {
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {MELODY, G5, SHORT},
    {MELODY, C6, SHORT},
    {MELODY, F5, SHORT},
    {MELODY, G5, SHORT},
    {MELODY, Gd5, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {MELODY, Dd5, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {MELODY, C7, SHORT},
    {MELODY, C8, SHORT},
};

const Note song_gameover_ch2[] = {
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {SNARE, C3, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {SNARE, Cd3, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {SNARE, Dd3, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {SNARE, C3, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG},
};

const Note song_gameplay_ch1[] = {
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, C5, LONG},
    {MELODY, C5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, B4, LONG},
    {MELODY, B4, LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, C5, LONG},
    {MELODY, B4, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A5, LONG},
    {MELODY, G5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, F5, LONG},
    {MELODY, F5, LONG},
    {MELODY, E5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, E5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, C5, LONG},
    {MELODY, B4, LONG_LONG},
    {NONE, SILENCE, LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, G4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A4, LONG},
    {MELODY, G4, LONG},
    {MELODY, A5, LONG},
    {MELODY, G5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, F5, LONG},
    {MELODY, F5, LONG},
    {MELODY, E5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, E5, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {MELODY, D5, LONG},
    {MELODY, C5, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
};

const Note song_gameplay_ch2[] = {
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {CYMBAL, G3, SHORT},
    
};

const Note song_gameplay_ch4[] = {
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    {SNARE, G5, SHORT},
    {NONE, SILENCE, LONG_LONG},
    
};

#endif
