/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.Oscillator;
import processing.sound.SoundObject;

public class SawOsc
implements Oscillator {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private int[] m_freqId = new int[]{-1, -1};
    private int[] m_ampId = new int[]{-1, -1};
    private int[] m_addId = new int[]{-1, -1};
    private int[] m_posId = new int[]{-1, -1};
    private float m_freq = 440.0f;
    private float m_amp = 0.5f;
    private float m_add = 0.0f;
    private float m_pos = 0.0f;
    private int m_panBusId;

    public SawOsc(PApplet pApplet) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        SawOsc sawOsc = this;
        sawOsc.m_engine.start();
        SawOsc sawOsc2 = this;
        this.m_panBusId = sawOsc2.m_engine.busConstructMono();
    }

    @Override
    public void play(float f, float f2, float f3, float f4) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_add = f3;
        this.m_pos = f4;
        this.m_nodeId = Engine.sawPlay(this.m_freq, this.m_amp, this.m_add, this.m_pos, this.m_panBusId);
    }

    @Override
    public void play(float f, float f2, float f3) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_add = f3;
        this.m_nodeId = Engine.sawPlay(this.m_freq, this.m_amp, this.m_add, this.m_pos, this.m_panBusId);
    }

    @Override
    public void play(float f, float f2) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_nodeId = Engine.sawPlay(this.m_freq, this.m_amp, this.m_add, this.m_pos, this.m_panBusId);
    }

    @Override
    public void play() {
        this.m_nodeId = Engine.sawPlay(this.m_freq, this.m_amp, this.m_add, this.m_pos, this.m_panBusId);
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.oscSet(this.m_freq, this.m_amp, this.m_add, this.m_pos, this.m_nodeId);
        }
    }

    private void audioSet() {
        if (this.m_nodeId[0] != -1) {
            Engine.oscAudioSet(this.m_freqId, this.m_ampId, this.m_addId, this.m_posId, this.m_nodeId);
        }
    }

    @Override
    public void set(float f, float f2, float f3, float f4) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_add = f3;
        this.m_pos = f4;
        this.set();
    }

    @Override
    public void freq(float f) {
        this.m_freq = f;
        this.set();
    }

    public void freq(SoundObject soundObject) {
        this.m_freqId = soundObject.returnId();
        this.audioSet();
    }

    @Override
    public void amp(float f) {
        this.m_amp = f;
        this.set();
    }

    public void amp(SoundObject soundObject) {
        this.m_ampId = soundObject.returnId();
        this.audioSet();
    }

    @Override
    public void add(float f) {
        this.m_add = f;
        this.set();
    }

    public void add(SoundObject soundObject) {
        this.m_addId = soundObject.returnId();
        this.audioSet();
    }

    @Override
    public void pan(float f) {
        this.m_pos = f;
        this.set();
    }

    public void pan(SoundObject soundObject) {
        this.m_posId = soundObject.returnId();
        this.audioSet();
    }

    @Override
    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    @Override
    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

