<?
require_once 'check_access.php';
//--- constant
$sin_rad = 8;
$setka_sinus_img = isset($_GET['setka_sinus_img']) ? (int)$_GET['setka_sinus_img'] : 3;
$setka_sinus_img_size = 3;
$bg = isset($_GET['bg']) ? (int)$_GET['bg'] : 1;
$hsize = isset($_GET['hsize']) ? (int)$_GET['hsize'] : 4;
$itl = isset($_GET['itl']) ? (int)$_GET['itl'] : 1;
$sin1_begin = 0;
$sin2_begin = 64;
$sin1_step = -3 + ($hsize==8 ? -3 : 0);
$sin2_step = 1 + ($hsize==8 ? 1 : 0);
$sin1_step_frame = 8;
$sin2_step_frame = 4;
$sin1 = isset($_GET['sin1']) ? (int)$_GET['sin1'] : $sin1_begin;
$sin2 = isset($_GET['sin2']) ? (int)$_GET['sin2'] : $sin2_begin;
if ($sin1 < 0) {$sin1 += 256;}
if ($sin1 >= 256) {$sin1 -= 256;}
if ($sin2 < 0) {$sin2 += 256;}
if ($sin2 >= 256) {$sin2 -= 256;}
//--- prepare
$setka_img = imagecreatefrompng('fx/setka_sinus/setka_sinus' . $setka_sinus_img_size . $setka_sinus_img . '.png');
$img = imagecreatetruecolor(384, 300);
//--- fx
$y_add = 0;
$accum = $sin1;
$accum_limit = 32;
$y = 0;
$ln = 0;
while ($y < 300) {
	$sin_val = (($sin_rad + $sin_rad * sin(M_PI * ($ln + $sin1) / 128)))
			 + (($sin_rad + $sin_rad * sin(M_PI * ($ln + $sin2) / 128)));
	$sin_val = (int)$sin_val;
	//$sin_val = (int)($sin_rad + ($sin_rad * sin(M_PI * $sin1 / 128)));
	for ($j=0; $j<$hsize; $j++) {
		imagecopy($img, $setka_img, 0, $y + $j, 0, $sin_val + $y_add, 384, 1);
	}
	if ($itl === 1) {
		$ln = $ln ^ 24;
	}
	$sin1 = $sin1 + $sin1_step;
	$sin2 = $sin2 + $sin2_step;
	if ($sin1 < 0) {$sin1 += 256;}
	if ($sin1 >= 256) {$sin1 -= 256;}
	if ($sin2 < 0) {$sin2 += 256;}
	if ($sin2 >= 256) {$sin2 -= 256;}
	$accum += (64 - $sin_val) / ($hsize==8 ? 8 : 16); //$sin_val = 0..31
	if ($accum >= $accum_limit) {
		$accum -= $accum_limit;
		$y_add = $y_add ^ 32;
	}
	//echo $sin_val . '<br>';
	$y += $hsize;
}
if (isset($_GET['ajax'])) {
	header("Content-type: image/png");
	imagepng($img);
} else {?>
	<html>
		<head>
			<title>FX: setka sinus</title>
			<style>
				div.fx {
					position: relative;
					zoom: 2;
				}
				img.fx {
					border: 1px solid #000;
					width: 384px;
					height: 300px;
				}
				img.pix {
					border: 1px solid #000;
					position: absolute;
					left: 0px;
					top: 0px;
				}
				div.selector {
					display: inline-block;
				}
				div.selector a {
					display: inline-block;
					border: 1px solid;
					padding: 2px 10px;
					font-weight: bold;
				}
				div.selector a.active {
					background-color: #00d0e0;
				}
			</style>
			<script>
				var sin1 = <?=$sin1_begin?>;
				var sin2 = <?=$sin2_begin?>;
				var sin1_step_frame = <?=$sin1_step_frame?>;
				var sin2_step_frame = <?=$sin2_step_frame?>;
				var frame = 0;
				var frame_wait = 3;
				var setka_sinus_img = <?=$setka_sinus_img?>;
				var setka_sinus_img_size = <?=$setka_sinus_img_size?>;
				var hsize = <?=$hsize?>;
				var itl = <?=$itl?>;
				function renderFrame() {
					frame++;
					if (frame == frame_wait) {
						frame = 0;
						sin1 += sin1_step_frame;
						sin2 += sin2_step_frame;
						if (sin1 >= 256) {sin1 -= 256;}
						if (sin1 < 0) {sin1 += 256;}
						if (sin2 >= 256) {sin2 -= 256;}
						if (sin2 < 0) {sin2 += 256;}
						document.title = sin1;
						document.getElementById('img_fx').src = 'setka_sinus.php?ajax=1&sin1=' + sin1 + '&sin2=' + sin2 + '&setka_sinus_img=' + setka_sinus_img + '&setka_sinus_img_size=' + setka_sinus_img_size + '&hsize=' + hsize + '&itl=' + itl;
					}
					window.requestAnimationFrame(renderFrame);
					
				}
				setTimeout(renderFrame, 500);
			</script>
		</head>
		<body>
			<div class="selector"><a href="index.php">back</a></div>
			<br />
			<div class="fx">
				<img class="fx" id="img_fx" src="" />
				<img class="pix" src="foreground/man-cya.png" />
			</div>
			<br />
			<div class="selector">Color:
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=<?=$hsize?>&setka_sinus_img=1&setka_sinus_img_size=<?=$setka_sinus_img_size?>" <?=$setka_sinus_img==1 ? 'class="active"' : ''?>>1</a>
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=<?=$hsize?>&setka_sinus_img=2&setka_sinus_img_size=<?=$setka_sinus_img_size?>" <?=$setka_sinus_img==2 ? 'class="active"' : ''?>>2</a>
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=<?=$hsize?>&setka_sinus_img=3&setka_sinus_img_size=<?=$setka_sinus_img_size?>" <?=$setka_sinus_img==3 ? 'class="active"' : ''?>>3</a>
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=<?=$hsize?>&setka_sinus_img=4&setka_sinus_img_size=<?=$setka_sinus_img_size?>" <?=$setka_sinus_img==4 ? 'class="active"' : ''?>>4</a>
			</div>
			<div class="selector">Y-Size:
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=2&setka_sinus_img_size=<?=$setka_sinus_img_size?>&setka_sinus_img=<?=$setka_sinus_img?>" <?=$hsize==2 ? 'class="active"' : ''?>>x2</a>
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=4&setka_sinus_img_size=<?=$setka_sinus_img_size?>&setka_sinus_img=<?=$setka_sinus_img?>" <?=$hsize==4 ? 'class="active"' : ''?>>x4</a>
				<a href="setka_sinus.php?itl=<?=$itl?>&bg=<?=$bg?>&hsize=8&setka_sinus_img_size=<?=$setka_sinus_img_size?>&setka_sinus_img=<?=$setka_sinus_img?>" <?=$hsize==8 ? 'class="active"' : ''?>>x8</a>
			</div>
			<div class="selector">Interlace:
				<a href="setka_sinus.php?itl=0&bg=<?=$bg?>&hsize=<?=$hsize?>&setka_sinus_img_size=<?=$setka_sinus_img_size?>&setka_sinus_img=<?=$setka_sinus_img?>" <?=$itl==0 ? 'class="active"' : ''?>>nop</a>
				<a href="setka_sinus.php?itl=1&bg=<?=$bg?>&hsize=<?=$hsize?>&setka_sinus_img_size=<?=$setka_sinus_img_size?>&setka_sinus_img=<?=$setka_sinus_img?>" <?=$itl==1 ? 'class="active"' : ''?>>yep</a>
			</div>
		</body>
	</html>
<?}