<?
error_reporting(E_ALL);
ini_set('display_errors', true);
$img = imagecreatefrompng('fx/horiz_3d/horiz.png');
$img_new = imagecreatefrompng('fx/horiz_3d/horiz.png');
$fazes_qty = 20;
$color_replace_tbl = array(
	//--- bg
	0x000000 =>	0x000000,
	//--- long part
	0x0000D0 => 0x0000CA,
	0x0000FF => 0x0000FE,
	0x00D0D0 => 0x00CACA,
	0x00FFFF => 0x00FEFE,
	0xFFFFFF => 0xFEFEFE,
	//--- small part
	0xD00000 => 0xCA0000,
	0xFF0000 => 0xFE0000,
	0xFF00FF => 0xFE00FE,
	0xFFFF00 => 0xFEFE00,
	0xFEFE9D => 0xFEFEFE,
);
$zxcolors = array(
	0x000000 =>	0x00,
	0x0000CA => 0x01,
	0x0000FE => 0x41,
	0x00CA00 => 0x04,
	0x00FE00 => 0x44,
	0x00CACA => 0x05,
	0x00FEFE => 0x45,
	0xCA0000 => 0x02,
	0xFE0000 => 0x42,
	0xCA00CA => 0x03,
	0xFE00FE => 0x43,
	0xCACA00 => 0x06,
	0xFEFE00 => 0x46,
	0xCACACA => 0x07,
	0xFEFEFE => 0x47,
);

$select_colors = array(
	0x000000,
	0x0000CA,
	0x0000FE,
	0xCA0000,
	0xFE0000,
	0xCA00CA,
	0xFE00FE,
	0x00CA00,
	0x00FE00,
	0x00CACA,
	0x00FEFE,
	0xCACA00,
	0xFEFE00,
	0xCACACA,
	0xFEFEFE,
);
if (isset($_POST['colors'])) {
	foreach ($_POST['colors'] as $name=>$clr) {
		$color_replace_tbl[hexdec($name)] = hexdec($clr);
	}
}

$jptbl = array(
	'PATTR0',
	'PATTR1',
	'PATTR2',
	'PATTR3',
	'PATTR4',
	'PATTR5',
	'PATTR6',
	'PATTR7',
	'PATTR8',
);


$bits_tbl = array(
	0 => '11111111',
	1 => '01111111',
	2 => '00111111',
	3 => '00011111',
	4 => '00001111',
	5 => '00000111',
	6 => '00000011',
	7 => '00000001',
);
for ($f=0; $f<20; $f++) {
	$zxclrimg = file_get_contents('../demo/kernal/effects/01/generated/color' . $f . '.asm');
	$zxclrimg = explode("\r\n", $zxclrimg);
	$fl = fopen('../demo/kernal/effects/01/generated/bits' . $f . '.asm', 'w');
	$fc = fopen('../demo/kernal/effects/01/generated/color' . $f . '.asm', 'w');
	for ($y=0; $y<96; $y++) {
		$by = $f*96 + $y;
		//--- redraw
		if (isset($_POST['colors'])) {
			for ($x=0; $x<256; $x++) {
				$clr = imagecolorat($img, $x, $by);
				$clr = $color_replace_tbl[$clr];
				imagesetpixel($img_new, $x, $by, $clr);
			}
		}
		//--- calc zx data
		$clr = imagecolorat($img, 128, $by);
		$clr = $color_replace_tbl[$clr];
		$zxclr = $zxcolors[$clr];
		$x = 0;
		while ($x < 256 && imagecolorat($img, $x, $by) == 0) {
			$x++;
		}
		if ($x == 256) {
			$x = 0;
		}
		$bx = $x & 7;
		$adr_hi = ($y%2==0 ? 0x40 : 0xC0) + 8*floor($y / 32) + 2*($y & 3);
		$adr_lo = 32*(floor(($y & 31) / 4));
		$adr_lo_xl = $adr_lo + floor($x/8);
		$adr_lo_xr = $adr_lo + 31 - floor($x/8);
		fwrite($fl,"\tDW\t#" . strtoupper(dechex(256*$adr_hi + $adr_lo_xl)) . "\r\n");
		fwrite($fl,"\tDB\t%" . $bits_tbl[$bx] . "\r\n");
		fwrite($fl,"\tDB\t#" . strtoupper(dechex($adr_lo_xr)) . "\r\n");
		$zxclr = $zxclr + 8*($zxclr % 8);
		if (strlen($zxclr)==1) {
			$zxclr = '0' . $zxclr;
		}
		fwrite($fc,$zxclrimg[$y*2] . "\r\n");
		fwrite($fc,"\tDB\t#" . strtoupper(dechex($zxclr)) . "\r\n");
		
	}
	fclose($fc);
	fclose($fl);
}
imagepng($img_new, 'fx/horiz_3d/horiz_new.png');

?>
<!DOCTYPE html>
<html>
	<head>
		<style>
			div.img {
				border: 1px solid #808080;
				width: 512px;
				height: 384px;
				overflow: hidden;
			}
		</style>
		<script>
			var f = 0;
			function do_anim() {
				f++;
				if (f>=20) {
					f = 0;
				}
				document.title = f;
				document.getElementById('img').style = 'margin-top:-' + (f*384) + 'px';
			};
			function js_setcolor(name, clr) {
				document.getElementById('div' + name).style.backgroundColor = '#' + clr;
				document.getElementById('clr' + name).value = clr;
			}
			$frm = setInterval(function(){
				do_anim();
			}, 100);
			
		</script>
	</head>
	<body>
		<div class="img">
			<img id="img" src="fx/horiz_3d/horiz_new.png" width="512px" height="7680px" />
		</div>
		<div style="clear:both"></div>
		<br />
		<form action="" method="post">
			<div><b>LONG PART COLOR GRADIENT:</b></div>
			<div><?show_select_colors('0000D0', $color_replace_tbl[0x0000D0]);?></div>
			<div><?show_select_colors('0000FF', $color_replace_tbl[0x0000FF]);?></div>
			<div><?show_select_colors('00D0D0', $color_replace_tbl[0x00D0D0]);?></div>
			<div><?show_select_colors('00FFFF', $color_replace_tbl[0x00FFFF]);?></div>
			<div><?show_select_colors('FFFFFF', $color_replace_tbl[0xFFFFFF]);?></div>
			<br />
			<div><b>SHORT PART COLOR GRADIENT:</b></div>
			<div><?show_select_colors('D00000', $color_replace_tbl[0xD00000]);?></div>
			<div><?show_select_colors('FF0000', $color_replace_tbl[0xFF0000]);?></div>
			<div><?show_select_colors('FF00FF', $color_replace_tbl[0xFF00FF]);?></div>
			<div><?show_select_colors('FFFF00', $color_replace_tbl[0xFFFF00]);?></div>
			<div><?show_select_colors('FEFE9D', $color_replace_tbl[0xFEFE9D]);?></div>
			<br />
			<button>APPLY</button>
		</form>
	</body>
</html>
<?
function show_select_colors($name, $curr) {
	global $select_colors;
	echo '<input id="clr' . $name . '" name="colors[' . $name . ']" type="hidden" value="' . gethex($curr) . '" />';
	echo '<div id="div' . $name . '" style="display:inline-block;width:32px;height:32px;border:1px solid #000;margin:0px 30px 5px 0px;background-color:#' . gethex($curr) . ';">&nbsp;</div>';
	foreach ($select_colors as $clr) {
		echo '<div style="display:inline-block;width:32px;height:32px;border:1px solid #000;margin:0px 5px 5px 0px;background-color:#' . gethex($clr) . ';" onclick="js_setcolor(\'' . $name . '\', \'' . gethex($clr) . '\')">&nbsp;</div>';
	}

}
function gethex($clr) {
	$clr = strtoupper(dechex($clr));
	while (strlen($clr) < 6) {
		$clr = '0' . $clr;
	}
	return $clr;
}



