//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_MAN_IN	;EFF_RUN_CIRC
//======================================================== FX_CONST
BLINK_TBL_FIX	EQU	5
MAN_Y0		EQU	0
MAN_IN_DY	EQU	9*2
RGBBUF_Y	EQU	48+MAN_IN_DY
RGB_DX		EQU	24
RGB_QTY_T	EQU	18
RGB_QTY_B	EQU	24-RGB_QTY_T
RGBBUF_LEN	EQU	#0700
RGBBUF0	EQU	#B000
RGBBUF1	EQU	#B800	;24*48 =1152
;ae = 10101110
;b6 = 10110110
INK_TBL		EQU	#8000-256*8
//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6144
	LD	(HL),L
	LDIR
	LD	BC,767
	LD	(HL),#47
	LDIR
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR
	;---
	LD	HL,RGBBUF0
	LD	DE,RGBBUF0+1
	LD	BC,#BE00-RGBBUF0-1
	LD	(HL),0	;3*8+6
	LDIR
	;---
	CALL	FADEINI
	CALL	MAN_IN_RGB
	RET
FADEINI
	LD	H,INK_TBL/256
	LD	HX,INK_TBL/256
	LD	C,0
	;--
FD4	LD	L,63
	LD	LX,127
	LD	E,8
FD3	LD	A,E
	DEC	A
	SUB	C
	JP	NC,FD2
	XOR	A
FD2	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	D,A
	LD	B,8
FD0	LD	A,B
	DEC	A
	SUB	C
	JP	NC,FD1
	XOR	A
FD1	OR	D
	LD	(HL),A
	DEC	L
	OR	#40
	LD	(IX),A
	DEC	LX
	DEC	B
	JP	NZ,FD0
	DEC	E
	JP	NZ,FD3
	;---
	INC	H
	INC	HX
	INC	C
	LD	A,C
	CP	8
	JP	NZ,FD4
	RET
EPAGE	DB	#17
//======================================================== FX_MAINLOOP
EFF_RUN_CIRC
	EI
	HALT
	;---
	LD	A,#17
SWP_PG	EQU	$-1
	LD	BC,#7FFD
	OUT	(C),A
	;---
	LD	A,125-57
	DEC	A
	JP	NZ,$-1
	LD 	A,R
	DEC	HL
	;---
	CALL	OUTFRAME
	;---
	LD	A,(SWP_ATTR)
	XOR	#80
	LD	(SWP_ATTR),A
	LD	A,(SWP_PG)
	XOR	#08
	LD	(SWP_PG),A
	;---
	LD	BC,#7FFD
	OUT	(C),A
	;---
	CALL	NEXT_FRAME
	CALL	RGB_BLINK
	;---
	SCF
	;RET	NC
	;RET	NC
	RET	NC
	;---
	RET
	
;-- colors table for circles + blink
;---------------------------- blink giga
;CLR1A_0	EQU	3
;CLR1B_0	EQU	1
;--
;CLR1A_4	EQU	3
;CLR1B_4	EQU	3
;--
;CLR1A_5	EQU	6
;CLR1B_5	EQU	2
;--
;CLR1A_6	EQU	6
;CLR1B_6	EQU	6
;--
;CLR1A_7	EQU	7
;CLR1B_7	EQU	7
;-----------------
;CLR0A_0	EQU	0
;CLR0B_0	EQU	0
;--
;CLR0A_4	EQU	1
;CLR0B_4	EQU	0
;--
;CLR0A_5	EQU	1
;CLR0B_5	EQU	1
;--
;CLR0A_6	EQU	5
;CLR0B_6	EQU	1
;--
;CLR0A_7	EQU	7
;CLR0B_7	EQU	5

;---------------------------- blink mono
CLR1A_0	EQU	3
CLR1B_0	EQU	1
;--
CLR1A_4	EQU	3
CLR1B_4	EQU	4	
;--
CLR1A_5	EQU	5
CLR1B_5	EQU	3
;--
CLR1A_6	EQU	7
CLR1B_6	EQU	7
;--
CLR1A_7	EQU	7
CLR1B_7	EQU	7
;-----------------
CLR0A_0	EQU	0
CLR0B_0	EQU	0
;--
CLR0A_4	EQU	0
CLR0B_4	EQU	0
;--
CLR0A_5	EQU	0
CLR0B_5	EQU	0
;--
CLR0A_6	EQU	1
CLR0B_6	EQU	0
;--
CLR0A_7	EQU	1
CLR0B_7	EQU	0


//======================================================== FX_ROUTINES
; HL` - attr adr
; D` - ink+ink
; E` - pap+pap
; B` - ink+pap
; C` - ink+0
; A` - pap+0

OUTFRAME
	LD	(SOHRSP1),SP
	LD	SP,FAZEJP1
JP_FZ	EQU	$-2
	LD	HL,CLR_TBL_1
SWP_CLR_TBL EQU	$-2
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	A,(HL)
	INC	HL
	EX AF,AF
	LD	A,(HL)
	LD	C,A
	LD	HL,#5800
SWP_ATTR EQU	$-1
	EXX
	LD	E,A
	EX AF,AF
	LD	D,A
	LD	BC,#00FE
	AND	A
	RET
FRAME_RET
	XOR	A
	OUT	(#FE),A
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;---------------------------
LN_RET	EXX	;4
	NOP:NOP:RET C
	JP (IX)	;8
;---------------------------
NF_HALT	EQU	4
NEXT_FRAME
	LD	A,NF_HALT
NF1	EQU	$-1
	DEC	A
	JP	Z,NF2
	OR	0
	LD	C,0
	JP	NF3
NF2	LD	A,NF_HALT
	LD	C,1
	JP	NF3
NF3	LD 	(NF1),A
	LD	A,0
NF4	EQU	$-1
	ADD	A,C
	AND	7
	LD	(NF4),A
	ADD	A,A
	ADD	A,A
	LD	C,A
	LD	B,0
	LD	HL,JP_FZ_TBL
	ADD	HL,BC
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(JP_FZ),DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(CLR_TBL_BLINK),DE
	RET
;----------------------------------
RGB_BLINK
	LD	BC,#FFFD

	LD	HL,BLINK_TBL + BLINK_TBL_FIX
BLINK_TBL_ADR EQU	$-2
	LD	A,(HL)
	INC	HL
	LD	(BLINK_TBL_ADR),HL

	CP	1
	
	
	JP	Z,RBLNK0
	LD	E,0
	JP	RBLNK1
RBLNK0	LD	E,7
	JP	RBLNK1
RBLNK1	LD	A,0
	INC	A
	AND	3
	LD	(RBLNK1 + 1),A
	PUSH	AF
	AND	1
	LD	C,A
	ADD	A,A
	ADD	A,A
	ADD	A,C
	LD	C,A
	POP	AF
RBLNK2	LD	A,7
	JP	Z,RBLNK3
	LD	D,0
	JP	RBLNK4
RBLNK3	LD	D,1
	JP	RBLNK4
RBLNK4	SUB	D
	ADC	A,0
	OR	E
	LD	(RBLNK2+1),A
	;---
	ADD	A,A
	LD	E,A
	ADD	A,A
	ADD	A,A
	ADD	A,E
	ADD	A,C
	LD	C,A
	LD	B,0
	LD	HL,CLR_TBL_1
CLR_TBL_BLINK	EQU	$-2
	ADD	HL,BC
	LD	(SWP_CLR_TBL),HL
	RET
//======================================================== FX_TABLES
JP_FZ_TBL
	DW	FAZEJP1
	DW	CLR_TBL_1
	DW	FAZEJP2
	DW	CLR_TBL_1
	DW	FAZEJP3
	DW	CLR_TBL_1
	DW	FAZEJP4
	DW	CLR_TBL_1
	DW	FAZEJP1
	DW	CLR_TBL_2
	DW	FAZEJP2
	DW	CLR_TBL_2
	DW	FAZEJP3
	DW	CLR_TBL_2
	DW	FAZEJP4
	DW	CLR_TBL_2
	
PRE_BLINK	EQU	5
CLR_TBL_1
	DUP	PRE_BLINK
	DB	CLR0A_0*8 + CLR0A_0
	DB	CLR1A_0*8 + CLR1A_0
	DB	CLR1A_0*8 + CLR0A_0
	DB	CLR0A_0
	DB	CLR1A_0
	DB	CLR0B_0*8 + CLR0B_0
	DB	CLR1B_0*8 + CLR1B_0
	DB	CLR1B_0*8 + CLR0B_0
	DB	CLR0B_0
	DB	CLR1B_0
	EDUP
	;---
	DB	CLR0A_4*8 + CLR0A_4
	DB	CLR1A_4*8 + CLR1A_4
	DB	CLR1A_4*8 + CLR0A_4
	DB	CLR0A_4
	DB	CLR1A_4
	DB	CLR0B_4*8 + CLR0B_4
	DB	CLR1B_4*8 + CLR1B_4
	DB	CLR1B_4*8 + CLR0B_4
	DB	CLR0B_4
	DB	CLR1B_4
	;---
	DB	CLR0A_5*8 + CLR0A_5
	DB	CLR1A_5*8 + CLR1A_5
	DB	CLR1A_5*8 + CLR0A_5
	DB	CLR0A_5
	DB	CLR1A_5
	DB	CLR0B_5*8 + CLR0B_5
	DB	CLR1B_5*8 + CLR1B_5
	DB	CLR1B_5*8 + CLR0B_5
	DB	CLR0B_5
	DB	CLR1B_5
	;---
	DB	CLR0A_6*8 + CLR0A_6
	DB	CLR1A_6*8 + CLR1A_6
	DB	CLR1A_6*8 + CLR0A_6
	DB	CLR0A_6
	DB	CLR1A_6
	DB	CLR0B_6*8 + CLR0B_6
	DB	CLR1B_6*8 + CLR1B_6
	DB	CLR1B_6*8 + CLR0B_6
	DB	CLR0B_6
	DB	CLR1B_6
	;---
	DB	CLR0A_7*8 + CLR0A_7
	DB	CLR1A_7*8 + CLR1A_7
	DB	CLR1A_7*8 + CLR0A_7
	DB	CLR0A_7
	DB	CLR1A_7
	DB	CLR0B_7*8 + CLR0B_7
	DB	CLR1B_7*8 + CLR1B_7
	DB	CLR1B_7*8 + CLR0B_7
	DB	CLR0B_7
	DB	CLR1B_7
	;---
	DUP	1
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7
	DB	7
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7
	DB	7
	EDUP
	
;--------------------------
CLR_TBL_2
	DUP	PRE_BLINK
	DB	CLR1A_0*8 + CLR1A_0
	DB	CLR0A_0*8 + CLR0A_0
	DB	CLR0A_0*8 + CLR1A_0
	DB	CLR1A_0
	DB	CLR0A_0
	DB	CLR1B_0*8 + CLR1B_0
	DB	CLR0B_0*8 + CLR0B_0
	DB	CLR0B_0*8 + CLR1B_0
	DB	CLR1B_0
	DB	CLR0B_0
	EDUP
	;---
	DB	CLR1A_4*8 + CLR1A_4
	DB	CLR0A_4*8 + CLR0A_4
	DB	CLR0A_4*8 + CLR1A_4
	DB	CLR1A_4
	DB	CLR0A_4
	DB	CLR1B_4*8 + CLR1B_4
	DB	CLR0B_4*8 + CLR0B_4
	DB	CLR0B_4*8 + CLR1B_4
	DB	CLR1B_4
	DB	CLR0B_4
	;---
	DB	CLR1A_5*8 + CLR1A_5
	DB	CLR0A_5*8 + CLR0A_5
	DB	CLR0A_5*8 + CLR1A_5
	DB	CLR1A_5
	DB	CLR0A_5
	DB	CLR1B_5*8 + CLR1B_5
	DB	CLR0B_5*8 + CLR0B_5
	DB	CLR0B_5*8 + CLR1B_5
	DB	CLR1B_5
	DB	CLR0B_5
	;---
	DB	CLR1A_6*8 + CLR1A_6
	DB	CLR0A_6*8 + CLR0A_6
	DB	CLR0A_6*8 + CLR1A_6
	DB	CLR1A_6
	DB	CLR0A_6
	DB	CLR1B_6*8 + CLR1B_6
	DB	CLR0B_6*8 + CLR0B_6
	DB	CLR0B_6*8 + CLR1B_6
	DB	CLR1B_6
	DB	CLR0B_6
	;---
	DB	CLR1A_7*8 + CLR1A_7
	DB	CLR0A_7*8 + CLR0A_7
	DB	CLR0A_7*8 + CLR1A_7
	DB	CLR1A_7
	DB	CLR0A_7
	DB	CLR1B_7*8 + CLR1B_7
	DB	CLR0B_7*8 + CLR0B_7
	DB	CLR0B_7*8 + CLR1B_7
	DB	CLR1B_7
	DB	CLR0B_7
	;---
	DUP	1
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7
	DB	7
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7*8 + 7
	DB	7
	DB	7
	EDUP
	
;-----------------------
; 22*24=528 *2 = 1056
;--- max top takts ~ 15k
;--- bottom ~ 8k
RGBOUT_B ;7.5k
	LD	DE,0
	LD	BC,0
	LD	LX,RGB_QTY_B
	JR	RGBO2
RGBOUT_T	;12.5k
	LD	DE,32 * RGB_QTY_B
	LD	BC,RGB_DX * (RGB_QTY_B) * 2
	LD	LX,RGB_QTY_T
RGBO2	LD	HL,#5805
RGBO_TO	EQU	$-2
	ADD	HL,DE
	EX	DE,HL	;DE = rgb address
	LD	HL,RGBBUF0 + 24*5
RGBO_FROM EQU	$-2
	ADD	HL,BC
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	LD	A,LX
RGBO1	;---
	DUP	24
	LDI	;16*24 = 384
	EDUP
	EX	DE,HL	;4
	LD	BC,#8000-24
	ADD	HL,BC	;11
	EX	DE,HL	;4
	;---
	DUP	24
	LDI	;16*24 = 384
	EDUP
	EX	DE,HL	;4
	LD	BC,#8000 + 32 - 24
	ADD	HL,BC	;11
	EX	DE,HL	;4
	;---
	DEC	A		;4
	JP	NZ,RGBO1	;10 /417 * 48 = 20016
	RET
;-----------------------------
MAN_IN_RGB
	LD	BC,RGBBUF0 + 24*9
	LD	HL,MAN1_RGB
	LD	D,INK_TBL/256 + 6;// debug=0, default=7
INK_TBL_DB EQU	$-1
	LD	LX,48
	EXX
	LD	A,(EPAGE)
	LD	E,A
	LD	D,#08
	LD	BC,#7FFD
	OUT	(C),E
	EXX
	;-----
MIR0	DUP	8
	LD	A,(HL)	;7
	INC	HL	;6
	ADD	A,C	;4
	LD	C,A	;4
	ADC	A,B	;4
	SUB	C	;4
	LD	B,A	;4 /33
	;--
	RES	3,B
	LD	E,(HL)	;7	; 0bpppiii
	INC	HL	;6
	LD	A,(DE)	;7
	LD	(BC),A	;7
	;--
	SET	3,B
	LD	E,(HL)	;7	; 0bpppiii
	INC	HL	;6
	LD	A,(DE)	;7
	LD	(BC),A	;7 /70 //103
	EDUP
	;--- //721
	EXX		;4
	LD	A,E	;4
	XOR	D	;4
	LD	E,A	;4

	RRA ;4
	AND 0 ;7
	OUT (#FE),A ;11

	OUT	(C),E	;12
	EXX		;4 /32
	;---
	;pause 22
	;NOP:NOP:NOP:NOP:INC DE
	;---
	DEC	LX
	JP	NZ,MIR0 //771
	RET
;-----------------------------
MAN_IN
	LD	(SOHRSP0),SP
	LD	D,TBL_MAN_Y/256
MAN_IN_TBL_Y	EQU	$-1
	LD	LX,8
MAN_POS_Y EQU $-1
	LD	HX,48
	EXX
	LD	A,(EPAGE)
	LD	E,A
	LD	D,#08
	LD	BC,#7FFD
	OUT	(C),E
	EXX
	LD	SP,MAN1
MLP0	;tbl Yt - 0..48 - меняя таблицу изменим порядок #00 #04 - верх/низ знакоместа
	;tbl X - 0.255 (в т.ч. сожержит Y)
	;--- 128t max
	DUP	7
	;---
	POP	HL	;10
	LD	A,LX	;8
	ADD	A,H	;4
	LD	E,A	;4
	LD	A,(DE)	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	E	;4
	LD	A,(DE)	;7
	LD	H,A	;4 /56
	;---
	POP	BC	;10
	LD	(HL),C	;7
	INC	H	;4
	LD	(HL),B	;7
	INC	H	;4
	POP	BC	;10
	LD	(HL),C	;7
	INC	H	;4
	LD	(HL),B	;7 /60 //116 * 7 => 812 - 84 free
	;---
	EDUP
	;---
	EXX		;4
	LD	A,E	;4
	XOR	D	;4
	LD	E,A	;4
	
	RRA:RRA ;8
	AND 0;7
	OUT (#FE),A ;12
	
	OUT	(C),E	;12
	EXX		;4 /32
	;---
	NOP:NOP
	;NOP:NOP:NOP:NOP:NOP:NOP:NOP:DEC BC
	;---
	DEC	HX	;4
	JP	NZ,MLP0	;10
	;---
	LD	SP,0
SOHRSP0	EQU	$-2
	RET
EFF_RUN_MAN_IN
	;---
	EI
	HALT
	CALL	RGBOUT_T
	;---
	LD	A,3
	DEC	A
	JP	NZ,$-1
	;---
	CALL	MAN_IN
	CALL	SWAPRGB
	CALL	RGBOUT_B
	;--------------
	EI
	HALT
	CALL	RGBOUT_T
	;---
	LD	A,6
	DEC	A
	JP	NZ,$-1
	;---
	CALL	MAN_IN_RGB
	CALL	SWAPPER
	CALL	SWAPRGB
	CALL	RGBOUT_B
	;---
	LD	A,48	;148
FZ1	EQU	$-1
	DEC	A
	LD	(FZ1),A
	RET	NZ
	LD	HL,EFF_RUN_BLINK
	LD	(EFF_RUN+1),HL
	RET
SWAPRGB	LD	A,0
	XOR	#FF
	LD	(SWAPRGB+1),A
	LD	HL,RGBBUF0+24*5
	JP	NZ,SWAPRGB1
	LD	HL,RGBBUF1+24*5
SWAPRGB1 ;---
	LD	BC,0
SWPRGB	EQU	$-2
	ADD	HL,BC
	LD	(RGBO_FROM),HL
	RET
;-----------------------
SWAPPER	LD	A,0
SWPRGB_	EQU	$-1
	LD	(SWPRGB),A
	;--- swap buffers
	LD	A,(EPAGE)
	XOR	#08
	LD	(EPAGE),A
	AND	#08
	LD	A,TBL_MAN_Y/256
	LD	DE,#D805
	JP	Z,SWAP1
	LD	A,TBL_MAN_Y2/256
	LD	DE,#5805
SWAP1	;--
	LD	(MAN_IN_TBL_Y),A
	LD	(RGBO_TO),DE
	;---
SWAP5	LD	HL,MAN_IN_TBL
MANINTBL EQU $-2
	LD	A,(HL)
	LD	(MAN_POS_Y),A
	INC	HL
	LD	A,(HL)
	ADD	A,24*4	;96
	LD	(SWPRGB_),A
SWAP4	LD	A,48
	SUB	1
	JP	Z,SWAP6
	INC	HL
	LD	(MANINTBL),HL
	LD	(SWAP4+1),A
SWAP6	;--	
	LD	A,14
INKTBL_	EQU	$-1
	SUB	1
	JP	C,SWAP2
	LD	(INKTBL_),A
	RRA
	LD	H,INK_TBL/256
	ADD	A,H
	LD	(INK_TBL_DB),A ;debug
SWAP2	;----
	RET
;--------------------------------
EFF_RUN_BLINK
	EI
	HALT
	;---
	LD	A,#17
	CALL	PAGER
	;---
	LD	A,7
	OUT	(#FE),A
	;---
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7*8+7
	LDIR
	;-
	LD	A,MAN_CIRC_PG
	CALL	PAGER
	;-
	LD	HL,MAN_CIRC_PIX
	LD	DE,#4000
	LD	BC,6144
	LDIR
	;-
	LD	A,#17
	CALL	PAGER
	;-
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	;-
	LD	HL,MAN_CIRC_ATTR_1
	LD	BC,768
	LDIR
	;---
	LD	HL,MAN_CIRC_ATTR_0
	LD	DE,#5800
	LD	BC,768
	LDIR
	;---
	LD	HL,EFF_RUN_CIRC
	LD	(EFF_RUN+1),HL
	RET
//======================================================== FX_INCLUDE_DATA
	include "generated/diff_border.asm"
	include "generated/diff_lines_code.asm"
	include "generated/diff_scr_code.asm"
	
	include "generated/fazejp1.asm"
	include "generated/fazejp2.asm"
	include "generated/fazejp3.asm"
	include "generated/fazejp4.asm"

MAN_CIRC_ATTR_1
	INCBIN "circles_man_mask_attr_1.bin"
BLINK_TBL
	DS	21,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	11-1,0
	DB	1
	DS	10-1,0
;-
	DS	21,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	11-1,0
	DB	1
	DS	10-1,0
;-
	DS	21,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	11-1,0
	DB	1
	DS	10-1,0
;-
	DS	21,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	32-1,0
	DB	1
	DS	16-1,0
	DB	1
	DS	36-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	21-1,0
	DB	1
	DS	11-1,0
	DB	1
	DS	10-1,0
;-
	