//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
;------------------------ fx colors
B_CLR_01	EQU	1
B_CLR_11	EQU	3
;---
B_CLR_02	EQU	6
B_CLR_12	EQU	2
;---
B_CLR_03	EQU	6
B_CLR_13	EQU	6
;---
B_CLR_04	EQU	7
B_CLR_14	EQU	7
;------------------------ text colors
TXT_CLR_0A	EQU	0
TXT_CLR_0B	EQU	1
;---
TXT_CLR_1A	EQU	7
TXT_CLR_1B	EQU	7
;--
TXT_CLR_2A	EQU	5
TXT_CLR_2B	EQU	7
;--
TXT_CLR_3A	EQU	5
TXT_CLR_3B	EQU	5

TXT_CLR_4A	EQU	1
TXT_CLR_4B	EQU	5
;--
TXT_CLR_5A	EQU	0
TXT_CLR_5B	EQU	5
;--
TXT_CLR_6A	EQU	4
TXT_CLR_6B	EQU	4
;--
TXT_CLR_7A	EQU	6
TXT_CLR_7B	EQU	6
;--
TXT_CLR_8A	EQU	7
TXT_CLR_8B	EQU	7
;--
TXT_CLR_0	DW	TXT_CLR_1A + TXT_CLR_5A * 256
TXT_CLR_1	DW	TXT_CLR_2A + TXT_CLR_6A * 256
TXT_CLR_2	DW	TXT_CLR_3A + TXT_CLR_7A * 256
TXT_CLR_3	DW	TXT_CLR_4A + TXT_CLR_8A * 256
TXT_CLR_BG	DB	0
;--
TXT_CLR_A	DW	TXT_CLR_1A + TXT_CLR_5A * 256
		DW	TXT_CLR_2A + TXT_CLR_6A * 256
		DW	TXT_CLR_3A + TXT_CLR_7A * 256
		DW	TXT_CLR_4A + TXT_CLR_8A * 256
		DB	TXT_CLR_0A
;--
TXT_CLR_B	DW	TXT_CLR_1B + TXT_CLR_5B * 256
		DW	TXT_CLR_2B + TXT_CLR_6B * 256
		DW	TXT_CLR_3B + TXT_CLR_7B * 256
		DW	TXT_CLR_4B + TXT_CLR_8B * 256
		DB	TXT_CLR_0B

//======================================================== FX_INIT
EFF_INI_
	LD	A,#10
	CALL	PAGER
	LD	HL,MAN_CYAN
	LD	DE,#4000
	LD	BC,6144
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	LD	HL,MAN_CYAN_RGB_1
	LD	DE,#D800
	LD	BC,768
	LDIR
	LD	HL,MAN_CYAN_RGB_0
	LD	DE,#5800
	LD	BC,768
	LDIR
	
	
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	DUP	42 + 280 + 108
	NOP
	EDUP
	LD	A,64
	LD	A,64
	DEC	A
	JP	NZ,$-1
	
	
	LD	A,(FAZE)	
	OR	A
	JP	Z,TXT0
	LD	HL,TXT_CLR_A
	JR	TXT1
TXT0	LD	HL,TXT_CLR_B
	JR	TXT1
TXT1	LD	DE,TXT_CLR_0
	DUP	8
	LDI
	EDUP
	LD	A,(HL)
	LD	BC,#00FE
	SCF
	;---
	CALL	ACROSS_0
	;---	
	LD	A,128-8 -4
	DEC	A
	JP	NZ,$-1
	NOP:NOP

	LD	A,(FPAGE)
	AND	#08
	JP	Z,BINI0
	LD	HL,B_CLR_01 + 256 * B_CLR_02	;10
	LD	DE,B_CLR_03 + 256 * B_CLR_04	;10
	JR	BINI1
BINI0	LD	HL,B_CLR_11 + 256 * B_CLR_12	;10
	LD	DE,B_CLR_13 + 256 * B_CLR_14	;10
	JR	BINI1
BINI1	;---
	LD	(SOHRSP1),SP
	LD	SP,TBL_FX_JP
	LD	BC,#00FE
	AND	A
	EXX
	LD	HL,#0000
	LD	DE,#5820
SWPATTR	EQU	$-1
		LD	BC,1
	EXX
	RET
LN_RET	XOR	A
	OUT	(#FE),A
	LD	SP,0
SOHRSP1	EQU	$-2
	
	LD	A,0
FAZE	EQU	$-1
	XOR	#FF
	LD	(FAZE),A
	;---
	LD	A,#17
FPAGE	EQU	$-1
	XOR	#08
	LD	(FPAGE),A
	CALL	PAGER
	LD	A,(SWPATTR)
	XOR	#80
	LD	(SWPATTR),A
	;---
	
	LD	A,50
	DEC	A
	JP	NZ,$-1
	NOP:NOP
	
	LD	A,(FAZE)	
	OR	A
	JP	Z,TXT00
	LD	HL,TXT_CLR_A
	JR	TXT10
TXT00	LD	HL,TXT_CLR_B
	JR	TXT10
TXT10	LD	DE,TXT_CLR_0
	DUP	8
	LDI
	EDUP
	LD	A,(HL)
	LD	BC,#00FE
	SCF
	
	CALL	SIN_CALC
	;CALL	EDGE_0
	;---
	
	;---
	SCF
	;RET	NC
	RET	NC
	RET	NC
	RET

//======================================================== FX_PROCEDURES
LINE_CODE ;118t for code
	;BC - line
	;HL - scr attr
	EXX	;4
	;---
	LD	A,(BC)	;7
	INC	C	;4
	AND	(HL)	;7
	INC	L	;4
	LD	(DE),A	;7
	INC	E	;4 /33
	;---
	LD	A,(BC)	;7
	INC	BC	;6
	AND	(HL)	;7
	INC	L	;4
	LD	(DE),A	;7
	INC	DE	;6 /37 //70 104
	;---
	EXX	;4
	JP	(HL);4
;------------
SIN_CALC
; DE - sin1 tbl
; HL - sin2 tbl
; HL` - accum add tbl
; HX` - accum
; B` - accum chess xor tbl

	LD	A,(PAGE)
	AND	#08
	JP	Z,SC2
	LD	HL,JPX_TBL0
	JP	SC3
SC2	LD	HL,JPX_TBL1
	JP	SC3
SC3	LD	(JPX_TBL),HL
	;---
	LD	A,(ACCUM)
	ADD	A,0-4;0-14	;0-12
	LD	(ACCUM),A
	LD	A,(SIN1)
	ADD	A,0-4	;0-4
	LD	(SIN1),A
	LD	A,(SIN2)
	ADD	A,0-2	;2
	LD	(SIN2),A
	;---
	LD	(SOHRSP3),SP
	LD	SP,TBL_FX_JP_END-4
	LD	B,24
	LD	DE,SINTBL
SIN1	EQU	$-2
	LD	HL,SINTBL+64
SIN2	EQU	$-2
	LD	C,0-6
	LD	A,E
	ADD	A,A
	ADD	A,0
ACCUM	EQU	$-1
	LD	LX,A
	;LD	LX,0
;ACCUM	EQU	$-1
	EXX
	LD	HL,JPX_TBL0
JPX_TBL	EQU	$-2
	EXX
	;---
SC1	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
;	LD	C,(HL)	;7
;	INC	L	;4
;	LD	B,(HL)	;7 /44
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;---
	DJNZ	SC1	;
	;----------------------
	LD	B,3
	INC SP:INC SP
	;---
SC4	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	LD H,ACC_TBL0/256 ;7
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	;---
	LD	H,JPZ_TBL/256
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	8
	PUSH DE
	EDUP
	;---
	EXX		;4 /124
	DJNZ	SC4	;
	
	
	
	
	
	
	LD	SP,0
SOHRSP3	EQU	$-2
	LD	A,3
	OUT	(#FE),A
	RET
	
	INCLUDE "txt_across.asm"
	INCLUDE "txt_edge.asm"
//======================================================== FX_TABLES
TBL_FX_JP
	INCLUDE "generated/jp_tbl.asm"
TBL_FX_JP_END
//======================================================== FX_INCLUDE_DATA
	INCLUDE "generated/border_lines1.asm"
	INCLUDE "generated/diff_lines_code1.asm"
	INCLUDE "generated/diff_scr_code1.asm"
//======================================================== FX_OLD
	ORG	(($/256)+1)*256
SINTBL	INCBIN	"sintbl.bin"
ACC_TBL0	;DS	256,0
	INCBIN	"generated/accum.bin"
JPX_TBL0 INCLUDE	"generated/jpx_tbl_0.asm"
ACC_TBL1	;DS	256,0
	INCBIN	"generated/accum.bin"
JPX_TBL1 INCLUDE	"generated/jpx_tbl_1.asm"
JPZ_TBL  INCLUDE	"generated/jpz_tbl.asm"
;	LD	A,0
;FAZE	EQU	$-1
;	XOR	#FF
;	LD	(FAZE),A
;	JP	Z,BINI0
;	LD	HL,B_CLR_01 * 256 + B_CLR_02	;10
;	LD	DE,B_CLR_03 * 256 + B_CLR_04	;10
;	LD	B,B_CLR_05			;7
;	JR	BINI1
;BINI0	LD	HL,B_CLR_11 * 256 + B_CLR_12	;10
;	LD	DE,B_CLR_13 * 256 + B_CLR_14	;10
;	LD	B,B_CLR_15			;7
;	JR	BINI1
;BINI1	;---


