//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
SIN1STEP	EQU	0-6
ACCUM_STEP	EQU	0-6
SIN1_ADD	EQU	0-4
SIN2_ADD	EQU	0-2

SIN1DW_ADD	EQU	0 - #0444	;#0444
SIN2DW_ADD	EQU	0 - #0222	;#0222
SIN1DW_INI	EQU	24+12 + 6
SIN1DW_0	EQU	256 * (16) + (SIN1DW_ADD * SIN1DW_INI)
SIN2DW_0	EQU	256 * (64+16) + (SIN1DW_ADD * SIN1DW_INI)

;------------------------ fx colors
B_CLR_01	EQU	1
B_CLR_11	EQU	3
;---
B_CLR_02	EQU	6
B_CLR_12	EQU	2
;---
B_CLR_03	EQU	6
B_CLR_13	EQU	6
;---
B_CLR_04	EQU	7
B_CLR_14	EQU	7
;------------------------ text colors
TXT_CLR_0A	EQU	0
TXT_CLR_0B	EQU	1
;---
TXT_CLR_1A	EQU	7
TXT_CLR_1B	EQU	7
;--
TXT_CLR_2A	EQU	5
TXT_CLR_2B	EQU	7
;--
TXT_CLR_3A	EQU	5
TXT_CLR_3B	EQU	5

TXT_CLR_4A	EQU	1
TXT_CLR_4B	EQU	5
;--
TXT_CLR_5A	EQU	0
TXT_CLR_5B	EQU	5
;--
TXT_CLR_6A	EQU	4
TXT_CLR_6B	EQU	4
;--
TXT_CLR_7A	EQU	6
TXT_CLR_7B	EQU	6
;--
TXT_CLR_8A	EQU	7
TXT_CLR_8B	EQU	7
;--
TXT_CLR_0	DW	TXT_CLR_1A + TXT_CLR_5A * 256
TXT_CLR_1	DW	TXT_CLR_2A + TXT_CLR_6A * 256
TXT_CLR_2	DW	TXT_CLR_3A + TXT_CLR_7A * 256
TXT_CLR_3	DW	TXT_CLR_4A + TXT_CLR_8A * 256
TXT_CLR_BG	DB	0
;--
TXT_CLR_A	DW	TXT_CLR_1A + TXT_CLR_5A * 256
		DW	TXT_CLR_2A + TXT_CLR_6A * 256
		DW	TXT_CLR_3A + TXT_CLR_7A * 256
		DW	TXT_CLR_4A + TXT_CLR_8A * 256
		DB	TXT_CLR_0A
;--
TXT_CLR_B	DW	TXT_CLR_1B + TXT_CLR_5B * 256
		DW	TXT_CLR_2B + TXT_CLR_6B * 256
		DW	TXT_CLR_3B + TXT_CLR_7B * 256
		DW	TXT_CLR_4B + TXT_CLR_8B * 256
		DB	TXT_CLR_0B

//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	LD	HL,MAN_CYAN_RGB_1
	LD	DE,#D800
	LD	BC,768
	LDIR
	LD	HL,MAN_CYAN_RGB_0
	LD	DE,#5800
	LD	BC,768
	LDIR
	SCF
	RET	NC
	RET	NC
	;RET	NC
	JP	FN_START
	
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	LD	A,0
BG_CLR_1 EQU	$-1
	OUT	(#FE),A
	;---------------------------- RECALC SIN NEXT
	LD	A,#17
FPAGE	EQU	$-1
	AND	#08
	JP	Z,RSCx2
	LD	HL,JPX_TBL0
	JP	RSCx3
RSCx2	LD	HL,JPX_TBL1
	JP	RSCx3
RSCx3	LD	BC,0
BC_0	EQU	$-2
	EXX
	LD	(SOHRSP5),SP
	LD	SP,0
SP_0	EQU	$-2
	LD	HL,0
HL_0	EQU $-2
	LD	DE,0
DE_0	EQU $-2
	LD	C,SIN1STEP
	;-----------------
	DUP	9
	;-----------------
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;-----------------
	EDUP
	;-----------------
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	
	PUSH	HL
	PUSH	BC
	LD	BC,#00FE
BG_CLR_2 EQU	$-1
	INCLUDE "txt_across.asm"
	POP	BC
	POP	HL
	
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;-----------------
	DUP	1
	;-----------------
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;-----------------
	EDUP
	;-----------------
	INC SP:INC SP
	;---
	DUP	3
	;---
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	LD H,ACC_TBL0/256 ;7
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	;---
	LD	H,JPZ_TBL/256
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	8
	PUSH DE
	EDUP
	;---
	EXX
	;---
	EDUP
	;---
	EXX
	LD	H,B
	LD	L,C
	LD	A,(SWPATTR)
	LD	D,A
	LD	E,0
	DUP	32
	LDI
	EDUP
	EXX
	;---
	LD	SP,0
SOHRSP5	EQU	$-2
	;-----
	NOP:NOP:OR 0
	LD	A,(FPAGE)	
	AND	#08
	JP	Z,TXT0
	LD	HL,TXT_CLR_A
	JR	TXT1
TXT0	LD	HL,TXT_CLR_B
	JR	TXT1
TXT1	LD	DE,TXT_CLR_0
	DUP	8
	LDI
	EDUP
	LD	A,(HL)
	LD	(BG_CLR_1),A
	LD	(BG_CLR_2),A
	LD	(BG_CLR_3),A
	LD	(BG_CLR_4),A
	;------------------------------------------------- FX
	LD	A,(FPAGE)
	AND	#08
	JP	Z,BINI0
	LD	HL,B_CLR_01 + 256 * B_CLR_02	;10
	LD	DE,B_CLR_03 + 256 * B_CLR_04	;10
	JR	BINI1
BINI0	LD	HL,B_CLR_11 + 256 * B_CLR_12	;10
	LD	DE,B_CLR_13 + 256 * B_CLR_14	;10
	JR	BINI1
BINI1	;---
	LD	(SOHRSP1),SP
	LD	SP,TBL_FX_JP + 2
	LD	BC,#00FE
	AND	A
	EXX
	LD	HL,#0000
	LD	DE,#5820
SWPATTR	EQU	$-1
	LD	BC,1
	EXX
	RET
	;---
LN_RET	LD	A,0
BG_CLR_4 EQU	$-1
	OUT	(C),A
	LD	SP,0
SOHRSP1	EQU	$-2
;-----------------------
FN_START ;---------------------------- SWAP
	LD	A,(FPAGE)
	XOR	#08
	LD	(FPAGE),A
	CALL	PAGER
	;---
	LD	A,(SWPATTR)
	XOR	#80
	LD	(SWPATTR),A
	;---------------------------- RECALC SIN
	LD	A,(FPAGE)
	AND	#08
	JP	Z,RSC2
	LD	HL,JPX_TBL0
	JP	RSC3
RSC2	LD	HL,JPX_TBL1
	JP	RSC3
RSC3	EXX
	;---
	LD	A,(ACCUM)
	ADD	A,ACCUM_STEP	;0-6
	LD	(ACCUM),A
	;LD	A,(SIN1)
	;ADD	A,SIN1_ADD	;0-4
	;LD	(SIN1),A
	;LD	A,(SIN2)
	;ADD	A,SIN2_ADD	;0-2
	;LD	(SIN2),A
	
	LD	HL,(SIN1DW)
	LD	DE,SIN1DW_ADD
	ADD	HL,DE
	LD	(SIN1DW),HL
	LD	A,H
	LD	(SIN1),A
	
	LD	HL,(SIN2DW)
	LD	DE,SIN2DW_ADD
	ADD	HL,DE
	LD	(SIN2DW),HL
	LD	A,H
	LD	(SIN2),A
	

	
	;---
	LD	(SOHRSP4),SP
	LD	SP,TBL_FX_JP_END-4
	LD	DE,SINTBL+16
SIN1	EQU	$-2
	LD	HL,SINTBL+64+16
SIN2	EQU	$-2
	LD	C,SIN1STEP
	LD	A,E
	ADD	A,A
	ADD	A,0
ACCUM	EQU	$-1
	LD	LX,A
	;---
	DUP	4
	;---
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;-----------------
	EDUP
	;-----------------
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	
	LD	(HL_1),HL
	PUSH	BC
	
	LD	BC,#00FE
BG_CLR_3 EQU	$-1
	INCLUDE "txt_edge.asm"
	POP	BC
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	;---
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	HL,0
HL_1	EQU	$-2
	INC	L	;4
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;---------------------------- RECALC SIN NEXT
	DUP	8
	;---
	LD	A,E	;4
	ADD	A,C	;4
	LD	E,A	;4
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	EXX		;4 /26
	;---
	DEC	H	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	ADD	A,LX	;8
	LD	LX,A	;8
	AND	128	;7
	ADD	A,L	;4
	LD	L,A	;4
	INC	H	;4 /50
	;---
	LD	E,(HL)	;7
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4
	;---
	DUP	6
	PUSH DE:DEC SP:DEC SP
	EDUP
	PUSH DE: PUSH BC
	DEC SP:DEC SP
	PUSH DE:DEC SP:DEC SP
	;---
	LD	C,(HL)	;7
	INC	L	;4
	LD	B,(HL)	;7 /44
	EXX		;4 /124
	;-----------------
	EDUP
	;-----------------
	;---
	EXX
	LD	(BC_0),BC
	EXX
	LD	(HL_0),HL
	LD	(DE_0),DE
	LD	(SP_0),SP
	LD	SP,0
SOHRSP4	EQU	$-2
	;---
	SCF
	RET	NC
	RET	NC
	;RET	NC
	RET
	
SIN1DW	DW	SIN1DW_0
SIN2DW	DW	SIN2DW_0
//======================================================== FX_PROCEDURES
//======================================================== FX_TABLES
TBL_FX_JP
	INCLUDE "generated/jp_tbl.asm"
TBL_FX_JP_END
//======================================================== FX_INCLUDE_DATA
	INCLUDE "generated/border_lines1.asm"
	INCLUDE "generated/diff_lines_code1.asm"
	INCLUDE "generated/diff_scr_code1.asm"
//======================================================== FX_OLD
	ORG	(($/256)+1)*256
SINTBL		INCBIN	"sintbl.bin"
ACC_TBL0	INCBIN	"generated/accum.bin"
JPX_TBL0	INCLUDE	"generated/jpx_tbl_0.asm"
ACC_TBL1	INCBIN	"generated/accum.bin"
JPX_TBL1	INCLUDE	"generated/jpx_tbl_1.asm"
JPZ_TBL		INCLUDE	"generated/jpz_tbl.asm"	
	
