//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
FZ1LN	EQU	84+42		;120+60+30 right line
FZ2LN	EQU	42		;30	clear demarche
FZ3LN	EQU	84+42		;120+60+30 bottom line
FZ4LN	EQU	42		;30	clear presents
FZ6LN	EQU	168		;120	zoom board
FZ8LN	EQU	84 - 10		;120	across logo lines
FZ8AND	EQU	3	;lines speed
FZ9LN	EQU	20-6;20-3		;blink board
FZ9_CLR	EQU	3

DMC0A	EQU	6
DMC0B	EQU	6
;---
DMC1A	EQU	6
DMC1B	EQU	4
;---
DMC2A	EQU	5
DMC2B	EQU	3
;---
DMC3A	EQU	5
DMC3B	EQU	1
;---
DMC4A	EQU	3
DMC4B	EQU	1


BG_CLR_0	EQU	0
BG_CLR_1	EQU	1

LNCLR0	EQU	3
LNCLR1	EQU	7


AY_REG_CTRL	EQU	7
AY_REG_B_LO	EQU	2
AY_REG_B_HI	EQU	3

AY_REG_B_VOL	EQU	9
PILOT_LEN EQU	32 * 100
SVHDR	EQU	#A5	;//#A4

TAP_PORT EQU	#7FFD
TAP_HLT	EQU	144-1
//======================================================== FX_INIT
EFF_INI_
	DI
	LD	A,#17
	CALL	PAGER
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,256
	LD	(HL),7*8 + 7
	LDIR
	LD	(HL),7*8 + 0; none
	LD	BC,256
	LDIR
	LD	(HL),7*8 + 7; none
	LD	BC,255
	LDIR
	LD	HL,#5800
	LD	DE,#D800
	LD	BC,768
	LDIR
	;--
	LD	HL,#C000
	LD	DE,#C001
	LD	BC,6143
	LD	(HL),L
	LDIR
	

	CALL	IM2DEMO
	LD	A,3
WAIT1	EI
	HALT
	DEC	A
	JP	NZ,WAIT1
	
	AND	A
	RET	C
	RET	C
	;RET	C
	
;------- loading
;	LD	HL,TAP_CODE
;	LD	(HL),#ED	;ld a,r (1 byte)
;	INC	HL
;	LD	(HL),#5F	;ld a,r (1 byte)

	EI
	HALT

	CALL	PILOT
	
	;--- hdr
	LD	HL,TAPHEADER
	LD	DE,#3D00
	LD	BC,17
	CALL	TAPER
	
	CALL	PILOT
	
	;--- scr
	LD	HL,#4000
	LD	DE,#4800
	LD	BC,#0800
	CALL	TAPER
	
	;--- attr
	LD	HL,TAP_CODE
	LD	(HL),#23	;inc hl
	INC	HL
	LD	(HL),#F6	;or N
	
	LD	HL,DM_RGB
	LD	DE,#5900
	LD	BC,32*5
	CALL	TAPER
	
	AND	A
	RET	C
	RET	C
	;RET	C
	
	RET
//======================================================== FX_MAINLOOP
EFF_FZ	DB	0
FAZE_JP 
	DW	EFF_FZ_1, EFF_FZ_2, EFF_FZ_3, EFF_FZ_4, EFF_FZ_6, EFF_FZ_8, EFF_FZ_9, EFF_FZ_5, EFF_FZ_7

EFF_RUN_
	EI
	HALT
	LD	A,(EFF_FZ) ;13
	ADD	A,A	;4
	LD	E,A	;4
	LD	D,0	;7
	LD	HL,FAZE_JP ;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	INC	HL	;6
	LD	H,(HL)	;7
	LD	L,A	;4
	JP	(HL)	;4 /77
;-----------------------	
EFF_FZ_1
	LD	A,5
	OUT	(#FE),A
	LD	A,126
	DEC	A
	JP	NZ,$-1
	DEC HL:NOP
	;---
	LD	HL,#5800
CURV_SCR EQU	$-2
	LD	DE,256*7*8 + 7
	LD	BC,32
	EXX
	LD	HL,TAP_PAGES + 48
	LD	BC,#7FFD
	LD	DE,#0007
	LD	LX,24
CURV_LX	EQU	$-1
	LD	HX,252
	CALL	WAVE_0
CURV_FX	EQU	$-2
	CALL	CURVE_NEXT
	;---------------
	AND	A
	;RET	C
	;RET	C
	;RET	C
	;---------------
	LD	BC,FZ1LN ;10
FZ_A_1	EQU	$-2
	DEC	BC	;6
	LD	A,B	;4
	OR	C	;4
	LD	(FZ_A_1),BC ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
FX_RET	RET
;---------------------------
EFF_FZ_2
	CALL	CLR_SPR
	NOP:NOP:NOP:NOP:NOP
	
	;---
	LD	HL,#5800+14
	LD	DE,256*7*8 + 7
	LD	BC,32
	EXX
	LD	HL,TAP_PAGES + 48
	LD	BC,#7FFD
	LD	DE,#0007
	LD	LX,24
	LD	HX,252
	CALL	WAVE_24
	CALL	CURVE_NEXT
	;---------------
	AND	A
	;RET	C
	;RET	C
	;RET	C
	;---------------
	LD	BC,FZ2LN ;10
FZ_A_2	EQU	$-2
	DEC	BC	;6
	LD	A,B	;4
	OR	C	;4
	LD	(FZ_A_2),BC ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
	RET
;-------------------------------	
EFF_FZ_3
	LD	A,#17	;7
	LD	BC,#7FFD ;10
	OUT	(C),A	;12

	CALL	OUT_PRESENT
	
	
	LD	HL,#4800	;10
	LD	(CLR_HL),HL	;16
	LD	A,46		;7
	LD	(CLR_SPR_Y),A	;13 /46
	
	;p30
	LD	HL,0
	LD	HL,0
	LD	HL,0
	
	CALL	CURVE_NEXT2	;17+145+31 /193
	
	;---
	LD	HL,RGBADR_0
WH_SCR	EQU	$-2
	LD	BC,RGBADR_0	;// + #8000
WH_SCR2	EQU	$-2
	LD	DE,256*7*8 + 7
	EXX
	LD	HL,TAP_PAGES + 48
	LD	BC,#7FFD
	LD	DE,#0007
	LD	LX,16+8+8	;3
	LD	LY,1	;3
	LD	HX,252
WH_TOP	EQU	$-1
	LD	HY,1
WH_BOT	EQU	$-1
	LD	A,2
	EX	AF,AF
	CALL	WAVEH0
	XOR	A
	OUT	(#FE),A
	
	;CALL	CURVE_NEXT2
	;---------------
	AND	A
	RET	C
	RET	C
	;RET	C
	;---------------
	LD	A,FZ3LN ;10
FZ_A_3	EQU	$-1
	DEC	A	;6
	LD	(FZ_A_3),A ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
	RET
;----------------------------
EFF_FZ_4
	CALL	CLR_SPR
	RET	NZ
	;---
	LD	HL,RGBADR_18
	LD	BC,RGBADR_18 + #8000
	LD	DE,#3807
	EXX
	LD	HL,TAP_PAGES + 48
	LD	DE,#0007
	LD	IX,#6803
	LD	IY,#9403
	LD	A,2
	EX	AF,AF
	CALL	WAVEH
	;---------------
	XOR	A
	OUT	(#FE),A
	;---------------
	AND	A
	RET	C
	RET	C
	;RET	C
	;---------------
	LD	BC,FZ4LN ;10
FZ_A_4	EQU	$-2
	DEC	BC	;6
	LD	A,B	;4
	OR	C	;4
	LD	(FZ_A_4),BC ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
	RET
;----------------------------
EFF_FZ_5
	LD	A,#17
	CALL	PAGER
	;---
	LD	A,7
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	(HL),7*8+7
	LD	BC,767
	LDIR
	;---
	EI
	HALT
	;---
	CALL	BL_OUT
	;----------------
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	;--- fix scr0
	LD	A,255
	LD	HL,#4000 + 218
	LD	(HL),A
	INC	H
	LD	(HL),A
	INC	H
	LD	(HL),A
	INC	H
	LD	(HL),A
	INC	H
	LD	(HL),63
	INC	H
	LD	(HL),15
	INC	H
	LD	(HL),3
	;---
	LD	HL,#4000 + 117
	LD	(HL),A
	INC	H
	LD	(HL),A
	INC	H
	LD	(HL),A
	;---
	LD	HL,#4000 + 3349
	LD	(HL),A
	INC	H
	LD	(HL),A
	INC	H
	LD	(HL),A
	;---
	LD	HL,#4000 + 3661
	LD	(HL),15
	INC	H
	LD	(HL),15
	;---
	LD	HL,#4000 + 4715
	LD	(HL),7
	INC	H
	LD	(HL),7
	INC	H
	LD	(HL),7
	INC	H
	LD	(HL),3
	INC	H
	LD	(HL),3
	INC	H
	LD	(HL),3
	;---
	LD	HL,ATTR0
	LD	BC,768
	LDIR
	;---
	LD	BC,770
EFZ5_1	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,EFZ5_1
	;---
	LD	HL,ATTR1
	LD	DE,#5800
	LD	BC,768
	LDIR
	;---
	LD	HL,EFF_FZ
	INC	(HL)
	;---
	
	;---
	AND	A
	RET	C
	RET	C
	RET	C
	RET
;----------------------------
EFF_FZ_6
	LD	A,#17
	XOR	#00
	LD	(EFF_FZ_6+1),A
	LD	BC,#7FFD
	OUT	(C),A
	;---
	CALL	BZOOM6
BZOOM_ADR EQU	$-2
	;---------------
	LD	A,0
BZWAIT	EQU	$-1	
	INC	A
	AND	0
	LD	(BZWAIT),A
	RET	C
	JP	NZ,BZOOM_NOT
	DEC	BC
	LD	HL,TBL_BZOOM
TBL_BZOOM_ADR	EQU	$-2
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	A,D
	OR	A
	JP	Z,BZOOM_NOT
	LD	(TBL_BZOOM_ADR),HL	;16
	LD	(BZOOM_ADR),DE	;20
BZOOM_NOT
	;--- 354
	LD	LX,1
	CALL	CHLINES
	;---
	AND	A
	;RET	C
	;RET	C
	;RET	C
	;---------------
	
	
	LD	BC,FZ6LN ;10//240
FZ_A_6	EQU	$-2
	DEC	BC	;6
	LD	A,B	;4
	OR	C	;4
	LD	(FZ_A_6),BC ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
	RET
	
;---------------------------------------
EFF_FZ_8
	LD	A,#17
	XOR	#00
	LD	(EFF_FZ_8+1),A
	LD	BC,#7FFD
	OUT	(C),A
	;---
	CALL	BZOOM0Y
	;---
	EXX
	LD	A,0
FX8A3	EQU	$-1
	INC	A
	AND	FZ8AND
	LD	(FX8A3),A
	JP	NZ,FX8A4
	;--
	LD	A,(HL)	;7
	OR	0	;7
	JP	Z,FX8A4	;10
	;--
	LD	(LNATTR_ADR1),HL
FX8A4	;--
	AND	A
	RET	C
	;RET	C
	;RET	C
	
;-------
	EI
	HALT
;126
	LD	A,8
	DEC	A
	JP	NZ,$-1
	NOP:NOP
	;---
	CALL	BZOOM0X
	;---
	EXX
	LD	A,0
FX8A1	EQU	$-1
	INC	A
	AND	FZ8AND
	LD	(FX8A1),A
	JP	NZ,FX8A2
	;--
	LD	A,(HL)	;7
	OR	0	;7
	JP	Z,FX8A2	;10
	;--
	LD	(LNATTR_ADR),HL
FX8A2	;--
	AND	A
	RET	C
	RET	C
	RET	C
	;---------------
	LD	BC,FZ8LN ;10
FZ_A_8	EQU	$-2
	DEC	BC	;6
	LD	A,B	;4
	OR	C	;4
	LD	(FZ_A_8),BC ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
	RET
;---------------
EFF_FZ_7
	LD	A,#17+#08
EFZ7PG	EQU	$-1
	XOR	#08
	LD	(EFZ7PG),A
	LD	BC,#7FFD
	OUT	(C),A	
	;--- pause 1246
	LD	A,87	;120-35+2
	DEC	A
	JP	NZ,$-1
	NOP:NOP:NOP:LD A,R
	;---
	LD	HL,BMV_A_0
BOARD_ATTR_ADR	EQU	$-2
	LD	DE,#5800
BOARD_SCR	EQU	$-1
	;---
	DUP	14
	LDI
	EDUP
	INC DE:INC HL
	INC DE:INC HL
	INC DE:INC HL
	INC DE:INC HL
	DUP	14
	LDI
	EDUP
	;---
	EXX
	LD	(SOHRSP1),SP
	LD	SP,BMV_SP_0
BMV_JP_SP EQU	$-2	
	XOR	A
	LD	BC,#07FE
	AND	A
	LD	DE,BG_CLR_1*256 + BG_CLR_0
BMV_CLR	EQU	$-1
	JR	$+2
BMV_JP_DX EQU $-1
	NOP:NOP:NOP
	RET
BMV_RET	;---
	OUT	(C),A
	;---
	LD	SP,0
SOHRSP1	EQU	$-2
	;---
	CALL	BMV_NEXT
	;---
	LD	A,(BMV_CLR)
	XOR	0
	LD	(BMV_CLR),A
	OR	0
	;---
	LD	A,(BOARD_SCR)
	XOR	#80
	LD	(BOARD_SCR),A
	OR	0
	;---
	AND	A
	RET	C
	RET	C
	RET	C
	
	RET
;----------------------------
EFF_FZ_9
	LD	A,#17
	XOR	#00	;7
	LD	(EFF_FZ_6+1),A	;13
	LD	BC,#7FFD	;10
	OUT	(C),A
	;---
	CALL	BZOOM0

	;---
	AND	A
	RET	C
	RET	C
	;RET	C
	;---------------
	
	LD	A,7
A_9	EQU	$-1
	SUB	1
	ADC	A,0
	LD	(A_9),A
	;--
	INC	A
	LD	(ADR_BZ_RGB_0),A
	LD	L,FZ9_CLR
	LD	H,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	OR	L
	LD	H,A
	LD	(ADR_BZ_RGB_0_DW),HL
	;256 * (BZ_RGB_0*8 + BZ_RGB_0)

	LD	BC,FZ9LN ;10//240
FZ_A_9	EQU	$-2
	DEC	BC	;6
	LD	A,B	;4
	OR	C	;4
	LD	(FZ_A_9),BC ;20
	LD	HL,EFF_FZ ;10
	JP	NZ,FX_RET ;10
	INC	(HL)	;11
	LD	A,R
	RET
//======================================================== FX_ROUTINES
BMV_Y0		EQU	64*256
BMV_X0		EQU	0
BMV_STEP_X	EQU	#030C;#0222
BMV_STEP_Y	EQU	#0186;#0111 + #0088
;---
BMV_NEXT
	LD	D,COS/256
	LD	HL,BMV_Y0
COS_X	EQU	$-2
	LD	BC,BMV_STEP_X
	ADD	HL,BC
	LD	(COS_X),HL
	LD	E,H
	LD	A,(DE)
	AND	3
	LD	(BOARD_ATTR_ADR),A
	AND	3
	LD	(BMV_JP_DX),A
	LD	A,(DE)
	AND	4
	LD	LX,A
	;---
	LD	HL,BMV_X0
COS_Y	EQU	$-2
	LD	BC,BMV_STEP_Y
	ADD	HL,BC
	LD	(COS_Y),HL
	LD	E,H
	LD	A,(DE)
	AND	7
	XOR	LX
	ADD	A,A	;4
	ADD	A,A	;4
	LD	L,A	;4
	LD	H,0	;7
	LD	DE,BMV_JP ;10
	ADD	HL,DE	;11
	LD	E,(HL)	;7
	INC	HL	;4
	LD	D,(HL)	;7
	INC	HL	;7
	LD	(BMV_JP_SP),DE
	LD	A,(HL)	;7
	LD	(BOARD_ATTR_ADR+1),A

	;---
	RET

WAVEH0L	OR 0:NOP ;11
WAVEH0	LD	A,E	;4
	OUT	(#FE),A	;11
	;---
	DS 23,0
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- 73
	LD A,4
	DEC A
	JP NZ,$-1
	RET NZ:RET NZ
	;---
	DEC	LX	;8
	JP	NZ,WAVEH0L ;10
	;------
	LD	LX,1	;11
WAVEH
WAVEH_0	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(HL)	;7
	LD	A,(HL)	;7
	OR	D	;4 /15
	;---
	DUP	6
	LD	(HL),A	;7
	INC	L	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(HL)	;7
	OR	D	;4
	DUP	2
	LD	(HL),A	;7
	INC	L	;4 /11*2=22
	EDUP
	;---
	EXX		;4
	;---25
	LD A,R:NOP:NOP:NOP
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx0 ;10
	EX	AF,AF	;4
	NOP:NOP:JP WAVEH_0 ;18
WAVEHx0	LD	A,2	;7
	EX	AF,AF	;4
	LD	A,0	;7 /18
	NOP
WAVEH_1	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(BC)	;7
	LD	A,(BC)	;7
	OR	D	;4 /15
	;---
	DUP	6
	LD	(BC),A	;7
	INC	C	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(BC)	;7
	OR	D	;4
	DUP	2
	LD	(BC),A	;7
	INC	C	;4 /11*2=22
	EDUP
	;---
	EXX		;4
	LD A,R:NOP:NOP:NOP
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx1 ;10
	EX	AF,AF	;4
	NOP:NOP:JP WAVEH_1 ;18
WAVEHx1	LD	A,2	;7
	EX	AF,AF	;4
	LD	A,0	;7 /18
	NOP
WAVEH_2	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(HL)	;7
	LD	A,(HL)	;7
	AND	E	;4 /15
	;---
	DUP	6
	LD	(HL),A	;7
	INC	L	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(HL)	;7
	AND	E	;4
	LD	(HL),A	;7
	INC	L	;4
	LD	(HL),A	;7
	INC	HL	;6
	;---
	EXX		;4
	;--- p34
	LD	BC,#7FFD
	LD	A,R
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx2 ;10
	EX	AF,AF	;4
	NOP:NOP:JP WAVEH_2 ;18
WAVEHx2	LD	A,2	;7
	EX	AF,AF	;4
	LD	A,0	;7 /18
	NOP
WAVEH_3	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(BC)	;7
	LD	A,(BC)	;7
	AND	E	;4 /15
	;---
	DUP	6
	LD	(BC),A	;7
	INC	C	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(BC)	;7
	AND	E	;4
	LD	(BC),A	;7
	INC	C	;4
	LD	(BC),A	;7
	INC	BC	;6
	;---
	EXX		;4
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx3 ;10
	EX	AF,AF	;4
	OR	0
	DS	5,0
	JP	WAVEH_3 ;18
WAVEHx3	LD	A,2	;7
	RET	NZ
	EX	AF,AF	;4
	LD	A,0	;7 /18
	;---
	DEC	LY	;8
	JP	NZ,WAVEH_0 ;10
WAVEH_4	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(HL)	;7
	LD	A,(HL)	;7
	AND	E	;4 /15
	;---
	DUP	6
	LD	(HL),A	;7
	INC	L	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(HL)	;7
	AND	E	;4
	DUP	2
	LD	(HL),A	;7
	INC	L	;4 /11*2=22
	EDUP
	;---
	EXX		;4
	;---25
	LD A,R:NOP:NOP:NOP
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx4 ;10
	EX	AF,AF	;4
	NOP:NOP:JP WAVEH_4 ;18
WAVEHx4	LD	A,2	;7
	EX	AF,AF	;4
	LD	A,0	;7 /18
	NOP
WAVEH_5	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(BC)	;7
	LD	A,(BC)	;7
	AND	E	;4 /15
	;---
	DUP	6
	LD	(BC),A	;7
	INC	C	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(BC)	;7
	AND	E	;4
	DUP	2
	LD	(BC),A	;7
	INC	C	;4 /11*2=22
	EDUP
	;---
	EXX		;4
	LD A,R:NOP:NOP:NOP
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx5 ;10
	EX	AF,AF	;4
	NOP:NOP:JP WAVEH_5 ;18
WAVEHx5	LD	A,2	;7
	EX	AF,AF	;4
	LD	A,0	;7 /18
	NOP
WAVEH_6	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(HL)	;7
	LD	A,(HL)	;7
	OR	D	;4 /15
	;---
	DUP	6
	LD	(HL),A	;7
	INC	L	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(HL)	;7
	OR	D	;4
	LD	(HL),A	;7
	INC	L	;4
	LD	(HL),A	;7
	INC	HL	;6
	;---
	EXX		;4
	;--- p34
	LD	BC,#7FFD
	LD	A,R
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx6 ;10
	EX	AF,AF	;4
	NOP:NOP:JP WAVEH_6 ;18
WAVEHx6	LD	A,2	;7
	EX	AF,AF	;4
	LD	A,0	;7 /18
	NOP
WAVEH_7	;-------------------
	LD	A,E	;4
	OUT	(#FE),A	;11
	;--- next 92t
	EXX		;4
	LD	A,(BC)	;7
	LD	A,(BC)	;7
	OR	D	;4 /15
	;---
	DUP	6
	LD	(BC),A	;7
	INC	C	;4 /11*6=66
	EDUP
	;---
	EXX		;4
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;--- next 102t
	EXX		;4
	;---
	LD	A,(BC)	;7
	OR	D	;4
	LD	(BC),A	;7
	INC	C	;4
	LD	(BC),A	;7
	INC	BC	;6
	;---
	EXX		;4
	;---
	EX	AF,AF	;4
	DEC	A	;4
	JP	Z,WAVEHx7 ;10
	EX	AF,AF	;4
	OR	0
	DS	5,0
	JP	WAVEH_7 ;18
WAVEHx7	LD	A,2	;7
	RET	NZ
	EX	AF,AF	;4
	LD	A,0	;7 /18
	;---
	DEC	LX	;8
	JP	NZ,WAVEH_4 ;10
	;---------------
WAVEH_8	LD	A,E	;4
	OUT	(#FE),A	;11
	;---
	OUTI: INC B
	;---
	DS 18,0
	;---
	LD	A,D	;4
	OUT	(#FE),A	;11
	;---
	DS	21,0
	;---
	DEC	HX	;8
	JP	NZ,WAVEH_8	;10
	;----------------
WAVEH_9	LD	A,D	;4
	OUT	(#FE),A	;11
	;---
	OUTI: INC B
	;---
	DS 18,0
	;---
	LD	A,E	;4
	OUT	(#FE),A	;11
	;---
	DS	21,0
	;---
	DEC	HY	;8
	JP	NZ,WAVEH_9	;10
XXXRT	RET
;---------------------------
CURVE_NEXT
	LD	HL,CURVE	;10
CURV_HL	EQU	$-2
	LD	A,(HL)	;7
	OR	A	;4
	RET	Z	;11
	;---
	INC	HL	;6
	LD	(CURV_SCR),A ;13
	LD	A,(HL)	;7
	INC	HL	;6
	LD	(CURV_LX),A ;13
	LD	E,(HL)	;7
	INC	HL	;6
	LD	D,(HL)	;7
	INC	HL	;6
	LD	(CURV_FX),DE ;20
	LD	(CURV_HL),HL ;16
	LD	A,R
	RET	;10 /117
;---------------------------	
CURVE_NEXT2
	LD	HL,CURVE2 ;10
CURV_HL2 EQU	$-2
	LD	A,(HL)	;7
	OR	A	;4
	JP	Z,NONXT2 ;10 /31
	;---
	INC	HL	;6
	LD	(WH_TOP),A ;13
	LD	A,(HL)	;7
	INC	HL	;6
	LD	(WH_BOT),A ;13
	LD	E,(HL)	;7
	INC	HL	;6
	LD	D,(HL)	;7
	INC	HL	;6
	LD	(WH_SCR),DE ;20
	SET	7,D	;8
	LD	(WH_SCR2),DE ;20
	LD	(CURV_HL2),HL ;16
	RET	;10  /145
	;----
NONXT2	LD	A,8
	DEC	A
	JP	NZ,$-1
	NOP:NOP:NOP:NOP
	RET
	
;------------------------
OUT_PRESENT
	LD	A,#17
	CALL	PAGER
	LD	HL,#5000
OP_SPR	EQU	$-2
	LD	DE,#4800
OP_SCR	EQU	$-2
	;----------------
	PUSH	HL
	PUSH	DE
	;---
	DUP	32
	LDI
	EDUP
	;---
	POP	DE
	POP	HL
	;---DOWNHL
	INC	D
	LD	A,D
	AND	7
	JP	Z,DDE1x
	JP	$+3
	JP	$+3
	JP	DDE2x
DDE1x	LD	A,E
	ADD	A,#20
	LD	E,A
	LD	A,D
	SUB	#08
	LD	D,A
DDE2x	;---
	LD	L,E
	LD	A,D
	ADD	A,#08
	LD	H,A
	;----------------
	PUSH	HL
	PUSH	DE
	SET	7,D
	;---
	DUP	32
	LDI
	EDUP
	;---
	POP	DE
	POP	HL
	;---DOWNHL
	INC	D
	LD	A,D
	AND	7
	JP	Z,DDE1z
	JP	$+3
	JP	$+3
	JP	DDE2z
DDE1z	LD	A,E
	ADD	A,#20
	LD	E,A
	LD	A,D
	SUB	#08
	LD	D,A
DDE2z	;---
	LD	L,E
	LD	A,D
	ADD	A,#08
	LD	H,A



	LD	A,32
OP_SPR_Y EQU	$-1
	SUB	1
	ADC	A,0
	LD	(OP_SPR_Y),A
	JP	NZ,OP_SPR_0
	NOP:NOP:NOP:NOP
	NOP:NOP:NOP:NOP:NOP
	RET
OP_SPR_0
	LD	(OP_SPR),HL
	LD	(OP_SCR),DE
	RET
;---------------------------
CLR_SPR	LD	BC,#0200
	LD	HL,#4800
CLR_HL	EQU	$-2
CLR_LP	;---
	PUSH	HL
	DUP	31
	LD	(HL),C	;7
	INC	L	;4 /*32 = 352
	EDUP
	LD	(HL),C
	;---
	LD	A,L
	SUB	31
	LD	L,A
	;---
	SET	7,H
	;---
	DUP	31
	LD	(HL),C	;7
	INC	L	;4 /*32 = 352
	EDUP
	LD	(HL),C
	;---
	POP	HL
	;---DOWNHL
	INC	H
	LD	A,H
	AND	7
	JP	Z,DHL1
	JP	$+3
	JP	$+3
	JP	DHL2
DHL1	LD	A,L
	ADD	A,#20
	LD	L,A
	LD	A,H
	SUB	#08
	LD	H,A
DHL2	;---
	LD	A,36
CLR_SPR_Y EQU	$-1
	SUB	1
	ADC	A,C
	LD	(CLR_SPR_Y),A
	JP	NZ,CLR_SPR_0
	DEC	HL
	JP	CLR_SPR_1
CLR_SPR_0
	LD	(CLR_HL),HL
CLR_SPR_1
	DEC	B
	JP	NZ,CLR_LP
	RET
	;~1500..2000t
;-----------
SPR_OUT	LD	C,#FF
	LD	A,E
	DUP	32
	LDI
	EDUP
	DEC	DE
	LD	E,A
	CALL	DOWNDE
	DJNZ	SPR_OUT
	RET
;-------------------
DOWNDE	INC	D
	LD	A,D
	AND	7
	RET	NZ
	LD	A,E
	ADD	A,#20
	LD	E,A
	RET	C
	LD	A,D
	SUB	#08
	LD	D,A
	RET
;----------------
PILOT
	LD	A,#02
	LD	C,3
SVL00	LD	B,50
SVL01	OUT	(#FE),A
	EI
	HALT
	DJNZ	SVL01
	XOR	#07
	DEC	C
	JP	NZ,SVL00

	LD	HL,PILOT_LEN
	LD	C,#02
SVL0	LD	B,SVHDR		;7 (164)
	DJNZ	$		;8/13 2137
	LD	A,C		;4
	XOR	#0F
	LD	C,A
	OUT	(#FE),A 	;12
	DEC	HL		;6
	LD	A,L		;4
	OR	H		;4
	JP	NZ,SVL0		;10 /2177
	RET
;----------------
TAPER	EXX
	LD	HL,TAP_PAGES
	LD	BC,TAP_PORT
	EXX
	LD	LX,TAP_HLT
TAPER2	;---
	LD	A,(HL)	;7
	LD	(DE),A	;7
	SET	7,D	;8
TAP_CODE
	LD	A,R	; 9
	NOP		;4
	;---
	LD	A,(HL)	;7
	INC	HL	;6
	LD	(DE),A	;7
	RES	7,D	;8
	INC	DE	;6
	EXX		;4
	LD	E,A	;4
	LD	D,8	;7 /45
	;-------
TAPER3	RL	E		;4
	JP	C,TAP_1	;10 /14
	;---
TAP_0	LD	A,#01	;7
	OUT	(#FE),A	;11
	;--
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12 /25
	LD	A,13
	DEC	A
	JP	NZ,$-1
	;---
	DUP	2
	;---
	LD	BC,TAP_PORT
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12
	LD	A,13	;7 /32
	DEC	A
	JP	NZ,$-1
	;---
	EDUP
	;---
	LD	BC,TAP_PORT
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12
	LD	A,11	;7 /32
	DEC	A
	JP	NZ,$-1
	NOP:NOP:NOP:NOP:NOP
	;-----------------
	;---
	LD	A,#06+#08 ;7
	OUT	(#FE),A	;11
	;---
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12 /25
	LD	A,13
	DEC	A
	JP	NZ,$-1
	;---
	DUP	2
	;---
	LD	BC,TAP_PORT
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12
	LD	A,13	;7 /32
	DEC	A
	JP	NZ,$-1
	;---
	EDUP
	;---
	NOP ;wx
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12 /25
	;---
	LD	A,LX	;8
	SUB	4	;7
	JP	TAPER4
	;-------
TAP_1	LD	A,#01	;7
	OUT	(#FE),A	;11
	;---
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12 /25
	LD	A,13
	DEC	A
	JP	NZ,$-1
	;---
	DUP	6
	;---
	LD	BC,TAP_PORT
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12
	LD	A,13	;7 /32
	DEC	A
	JP	NZ,$-1
	;---
	EDUP
	;---

	LD	BC,TAP_PORT
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12
	LD	A,11	;7 /32
	DEC	A
	JP	NZ,$-1
	NOP:NOP:NOP:NOP:NOP
	;-----------------
	LD	A,#06+#08 ;7
	OUT	(#FE),A	;11
	;---
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12 /25
	LD	A,13
	DEC	A
	JP	NZ,$-1
	;---
	DUP	6
	;---
	LD	BC,TAP_PORT
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12
	LD	A,13	;7 /32
	DEC	A
	JP	NZ,$-1
	;---
	EDUP
	;---
	NOP ;wx
	LD	A,(HL)	;7
	INC	HL	;6
	OUT	(C),A	;12 /25
	;---
	LD	A,LX	;8
	SUB	8	;7	
	JP	TAPER4 ;10 /10 ->69
	;----------
TAPER4	LD	LX,A	;8
	JP	NC,TAPER5 ;10
	;------- taper halt ix= FC/F8
	
	LD	A,0
TAP_MV	EQU	$-1
	DEC	A
	AND	7
	LD	B,A
	
	LD	A,LX
	CP	#FF
	LD	A,10+8
	JP	Z,TAP_MV1
	LD	A,10
TAP_MV1	
	SUB	B
	RRA
	RRA
	AND	7
	JP	Z,TAPER_6
	LD	HX,A
	LD	LX,#06+#08
TAP_MV2	LD	A,LX	;8
	XOR	#07+#08	;7
	LD	LX,A	;8
	OUT	(#FE),A	;11
	LD	A,11+16+16+16	;7
	DEC	A
	JP	NZ,$-1
	NOP:OR 0
	DEC	HX	;8
	JP	NZ,TAP_MV2 ;10 /60
	;---
TAPER_6	EI
	HALT
	LD	A,#06+#08
	OUT	(#FE),A
	;---
	
	LD	A,(TAP_MV)
	DEC	A
	AND	7
	LD	(TAP_MV),A

	ADD	A,1
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	DEC	A
	JP	NZ,$-1
	;---
	PUSH	BC
	LD	HL,TAP_PAGES
	LD	A,(TAP_MV)
	LD	B,0
	LD	C,A
	ADD	HL,BC
	POP	BC
	LD	LX,TAP_HLT
	;---
	LD	A,7
	DEC	A
	JP	NZ,$-1
	;---
TAPER5	DEC	D		;4
	JP	NZ,TAPER30	;10 /14
	;-------
	EXX			;4
	DEC	BC		;6
	LD	A,B		;4
	OR	C		;4
	JP	NZ,TAPER2	;10 /36
	RET
TAPER30	LD	A,4
	DEC	A
	JP	NZ,$-1
	NOP:NOP:NOP:OR 0
	LD	BC,TAP_PORT
	LD	BC,TAP_PORT
	JP	TAPER3 ;10
;--------------------------------------
;0 w1323	lx=4	w=194
;1 w1323	lx=4	w=194
;2 w1349	lx=4	w=220
;3 w1349	lx=4	w=220
;4 w1025	lx=3	w=153
;5 w1377	lx=4	w=248
;6 w1725	lx=6	w=82

;w-101/253

; call: ld lx,0:call = 28
; ini: = 27
; lp:  = 24+10+172+33+18 = 253 => 257
; out: = 46
CHLINES
	LD	D,CHLN_TBL/256	;7
	LD	HL,CHLN_DATA	;10
CHLN_DATA_ADR EQU	$-2
	LD	BC,#4000	;10 /27
CHLN_SCR	EQU	$-2
CHLN0	;------- 253t
	LD	A,(HL)	;7
	CP	#FF	;7
	JP	NZ,CHLN3 ;10 /24
	;-------w215
	LD	A,13
	DEC	A
	JP	NZ,$-1
	NOP:NOP:NOP:NOP
	JP	CHLN2
CHLN3	;-------
	LD	E,A	;4
	INC	HL	;6 /10
	;-------
	LD	A,(DE)	;7
	LD	(BC),A	;7
	INC	E	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	INC	E	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	INC	E	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	INC	D	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	DEC	E	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	DEC	E	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	DEC	E	;4
	INC	B	;4
	;-
	LD	A,(DE)	;7
	LD	(BC),A	;7
	DEC	D	;4	/22*7+18 = 172t per 8x8
	;-------
	INC	C	;4
	JP	NZ,CHLN1 ;10
	;-- w19
	RET NZ:INC B:JP CHLN2
CHLN1	;---
	NOP		;4
	LD	A,B	;4
	SUB	7	;7
	LD	B,A	;4 /33
CHLN2	;---
	DEC	LX	;8
	JP	NZ,CHLN0 ;10 /18
	;------
	LD	(CHLN_DATA_ADR),HL	;16
	LD	(CHLN_SCR),BC		;20
	RET				;10 /46
	
BL_OUT	LD	DE,BL_DATA
	EXX
	LD	DE,#4000
	LD	BC,BL_CHUNKS
	LD	IX,#4003
	;---
BL_OUT1	EXX
	LD	A,(DE)
	INC	DE
	EXX
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,BC
	;---
	DUP	8
	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	D
	EDUP
	
	INC	E
	JP	Z,BL_OUT0
	LD	D,HX
	JP	BL_OUT1
BL_OUT0	LD	HX,D
	DEC	LX
	JP	NZ,BL_OUT1
	RET
TAPHEADER
	DB 0
	DB 1
	DB "ACROSS_SCR"
	DW 2048 + 32*5
	DW #4800
	DB {TAPHEADER}
//======================================================== FX_INCLUDE_DATA
CURVE2	INCLUDE	"curve_bott.asm"
CURVE	INCLUDE	"curve_left.asm"

	INCLUDE	"waves_24.asm"
	INCLUDE	"board_zoom.asm"


;-------
	ORG (($/256)+1)*256
ATTR0	INCBIN "begin-logo/begin-logo-rgb-0.bin"
ATTR1	INCBIN "begin-logo/begin-logo-rgb-1.bin"

//======================================================== FX_TABLES

RGBADR_0	EQU	#3800
RGBADR_1	EQU	#3800
RGBADR_2	EQU	#3800
RGBADR_3	EQU	#5AE0
RGBADR_4	EQU	#5AC0
RGBADR_5	EQU	#5AA0
RGBADR_6	EQU	#5A80
RGBADR_7	EQU	#5A60
RGBADR_8	EQU	#5A40
RGBADR_9	EQU	#5A20

RGBADR_10	EQU	#5A00
RGBADR_11	EQU	#59E0
RGBADR_12	EQU	#59C0
RGBADR_13	EQU	#59A0
RGBADR_14	EQU	#5980
RGBADR_15	EQU	#5960
RGBADR_16	EQU	#5940
RGBADR_17	EQU	#5920
	
RGBADR_18	EQU	#5900


;--------------
WAVE_TBL
;--------------
DM_RGB
	DUP	32
		DB	DMC0A + 7*8, DMC0B + 7*8
	EDUP
	;---
	DUP	32
		DB	DMC1A + 7*8, DMC1B + 7*8
	EDUP
	;---
	DUP	32
		DB	DMC2A + 7*8, DMC2B + 7*8
	EDUP
	;---
	DUP	32
		DB	DMC3A + 7*8, DMC3B + 7*8
	EDUP
	;---
	DUP	32
		DB	DMC4A + 7*8, DMC4B + 7*8
	EDUP
;--------------
TAP_PAGES
	DS	48, #17
	DS	64, #17+#08
	DUP	32+8
	DB	#17, #17+#08
	EDUP
	DS	160, #17+#08
	
	
BL_CHUNKS	INCBIN "begin-logo-chunks.bin"
BL_DATA		INCBIN "begin-logo-data.bin"