#version 120

#define M_PI 3.1415926535897932384626433832795

uniform sampler2D texture;
uniform float time = 1.0;
uniform float fade = 0.0;
uniform float angle = 0.0;
uniform float zoom = 1.0;

vec4 rotozoom()
{
	vec2 coord=gl_TexCoord[0].xy;
	float x = (-1.0 + 2.0 * coord.x);
	float y = (-1.0 + 2.0 * coord.y);
	float dist = sqrt(x*x + y*y);

	coord.x = (x*cos(angle) - y*sin(angle)) * zoom;
	coord.y = (y*cos(angle) + x*sin(angle)) * zoom;

	vec4 uv = texture2D(texture, coord + vec2(time));
	uv.a -= fade/dist;

	return uv;
}

void main()
{
	gl_FragColor = rotozoom() * gl_Color;
}
