#version 120

#define M_PI 3.1415926535897932384626433832795

uniform float time = 1.0f;
uniform vec2 scale = vec2(20,20);

vec4 plasma()
{
    vec2 coord = gl_TexCoord[0].st * scale;
    float d = 0.0;
    d+=sin(coord.x+time)*0.3;
    d+=cos(coord.y+time)*0.8;
    d-=sin(coord.x+coord.y+time);
    coord += vec2(sin(coord.x+time*2), cos(coord.y+time*3));
    d += sin(sqrt(d*10+coord.x*coord.x+coord.y*coord.y)+time);
    d = cos(M_PI*1.4*d);

    return vec4(vec3(d), 1);
}

void main()
{
    gl_FragColor = plasma() * gl_Color;
}
