#version 330
OJ_INCLUDE_UTILS

in vec2 fragCoord;
out vec4 fragColor;

uniform vec2 windowSize;

#define UNCALCULATED 0
#define UNKNOWN 1
#define HIDDEN 2

uniform float tick;
uniform sampler2D noiseP;
//uniform vec3 positions[NUM_AIRCRAFTS]; //
uniform vec3 playerPos;
//uniform vec3 ups[10];//
uniform vec3 playerUp;
//uniform vec3 forwards[NUM_AIRCRAFTS]; //
uniform vec3 playerForward;
uniform float rollVel;
uniform float pitchVel;
uniform float yawVel;

uniform float battery;

mat3 invAircraftRot;



uniform vec3 nextNodePos;
uniform float playerSpeed;

#define MAT_CHEESE 4.0
#define MAT_TUNNEL 5.0
#define MAT_CAVE 6.0
#define MAT_PLAYER 7.0
#define MAT_BLOCK 9.0
#define MAT_NODE 10.0
#define MAT_STONE 11.0
#define MAT_OBSTACLE 12.0
#define MAT_OBSTACLE_WALL 13.0
#define MAT_TURNING 14.0
#define MAT_TURNING_WALL 15.0

uniform float shake;
uniform float shakeTick;

#define EPS 0.01

vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}

vec2 unn(vec2 a, float dis, float mat)
{
	return a.x < dis ? a : vec2(dis, mat);
}



mat3 rot(float x, float y, float z)
{
	float cx = cos(x);
	float sx = sin(x);
	float cy = cos(y);
	float sy = sin(y);
	float cz = cos(z);
	float sz = sin(z);
	mat3 xm = mat3(1, 0, 0,
					0, cx, -sx,
					0, sx, cx);
	mat3 ym = mat3(cy, 0, sy,
			  		0, 1, 0,
			  		-sy, 0, cy);
	mat3 zm = mat3(cz, -sz, 0,
					sz, cz, 0,
					0, 0, 1);
	return xm * ym * zm; //inverse(xm * ym * zm);
}

float pyrField(vec2 p, float base, float h )
{
	vec2 pyr = min(mod(p, base), base -  mod(p, base));
	return min(pyr.x, pyr.y) * h;
}

#define TORUS 0.0
#define OBSTACLE 1.0
#define CAVE 2.0
#define CHEESE 3.0
#define NOISE_TUNNEL 4.0
#define MOD_BLOCKS 5.0
#define TURNING 6.0

#define LEN_TORUS 350.0
#define LEN_OBSTACLE 500.0
#define LEN_CAVE 200.0
#define LEN_CHEESE 100.0
#define LEN_NOISE_TUNNEL 200.0
#define LEN_MOD_BLOCKS 300.0
#define LEN_TOT LEN_TORUS + LEN_OBSTACLE + LEN_CAVE + LEN_CHEESE + LEN_NOISE_TUNNEL + LEN_MOD_BLOCKS 

vec2 map(vec3 p, vec3 rd)
{
	vec3 s = vec3(1);
	vec3 q = mod(p,s)-0.5*s;
	ivec3 n = ivec3(trunc(p / s));
	float t = trunc(mod(n.z, LEN_TOT));  // % 4
	if (p.z <= 0) {
		t = 0;
	}
	if (t < LEN_TORUS) { // n.x % 1000 < 200
		vec3 ms = vec3(200, 40, 200);
		float dis = -sdTorus(mod(n + vec3(-13, -21, 37), ms) - ms * 0.5, vec2(100, 15)); //float dis = sdTorus(n % 100 - 50, vec2(40, 20));
		
		//return vec2(dis, MAT_BLOCK);
		if (dis < 0) {
			//return vec2(sdBox(q, vec3(0.5)), MAT_BLOCK);
			return vec2(udRoundBox(q , vec3(0.25), 0.23), MAT_BLOCK);
		} else if (p.z > 0){
			vec3 d = (s * 0.5 -  sign(rd)* q) / abs(rd);
			float b = min(d.x, min(d.y, d.z));
			float a = max(dis - 1.73, b + EPS);
			
			float z =((sign(rd.z) == 1.0 ? 1.0 : 0.0) * LEN_TORUS - sign(rd.z) * mod(p.z, LEN_TOT)) / abs(rd.z);
			return vec2(max(EPS, min(a, z + EPS)), -1);
		} else {
			vec3 d = (s * 0.5 -  sign(rd)* q) / abs(rd);
			float b = min(d.x, min(d.y, d.z));
			float a = max(dis - 1.73, b + EPS);
			
			return vec2(max(EPS, a), -1);
		}
	} else if (t < LEN_TORUS + LEN_OBSTACLE ) {
		vec3 np = vec3(n.x + sin(n.z * 0.01) * 35 + sin(n.z * 0.004) * 35,  n.y, n.z);
		//mat3 rm = rot(0, 0, max(0, sin(n.z * 0.003)));
		//np = inverse(rm) * np;
		vec2 res = vec2(-sdBox(np, vec3(12 + sin(np.z * 0.008) * 3, 12 + sin(np.z * 0.005) * 3, 40000)), MAT_OBSTACLE_WALL);
		res = unn(res, sdCylinder(vec3(np.x, np.y, mod(np.z, 200) - 100), vec3(0, 0, 4)), MAT_OBSTACLE);
		res = unn(res, sdCylinder(vec3(np.y, np.z, mod(np.z + 50, 100) - 50), vec3(0, 0, 4)), MAT_OBSTACLE);
		vec3 hp = vec3(np.x, np.y, mod(np.z, 300) - 150);
		res = unn(res, max(-sdHexPrism(hp, vec2(5, 5))
							,sdBox(hp, vec3(15, 15, 3))), MAT_OBSTACLE);
		if (res.x < 0) {
			//return vec2(udRoundBox(q , vec3(0.4), 0.1), res.y);
			if(res.y == MAT_OBSTACLE) {
				return vec2(udRoundBox(q , vec3(0.3), 0.2), res.y); 
			}else{
				//return vec2(sdHexPrism(q, vec2(0.5, 0.5)), res.y);
				return vec2(udRoundBox(q , vec3(0.4), 0.1), res.y);
			}
			
		}
	} else if (t < LEN_TORUS + LEN_OBSTACLE + LEN_CAVE) {
		n = n.xzy;
		/*float tex = mix(texture(noiseP, vec2(n.x * 0.01  + sin(n.z * 0.001) +  sin(n.z * 0.002), n.y  * 0.01)).x, 
						texture(noiseP, vec2(n.x * 0.01, n.y  * 0.01   + sin(n.z * 0.001) +  sin(n.z * 0.002))).x,
						0.5);*/
		float tex = texture(noiseP, vec2(n.x * 0.01, n.y  * 0.01)).x;
						
		if (tex < 0.9 - abs(sin(n.z * 0.1 + 1))  * 0.5) {
			vec2 np = vec2(p.x + p.z, p.y);
			//if (tex < 0.9 - abs(sin(n.z * 0.1 + 1))  * 0.5) {
				return vec2(sdHexPrism(q.xzy + 0.07 * (0.5 - texture(noiseP, np * 0.5).x), vec2(0.5)), MAT_CAVE);
			/*} else {
				//n.z--;				
				vec3 ts = vec3(0,0, 0.25);
		 		float hex = sdHexPrism(q.xzy + 0.07 * (0.5 - texture(noiseP, np * 0.5).x), vec2(0.0 + (q.y+0.5)/2, 0.5));
				return vec2(hex, MAT_CAVE);
			}*/
			
		}
	} else if (t < LEN_TORUS + LEN_OBSTACLE + LEN_CAVE + LEN_CHEESE) {
		float modSize = 39;
		vec3 mo = mod(n, modSize) - modSize * 0.5;
		float dis = max(-sphere(mo, 22), sdBox(mo, vec3(20))); // 22 20
		if (dis < 0) {
			vec2 np = vec2(p.x + p.y * 0.5, p.y * 0.5 + p.z);
			return vec2(udRoundBox(q + 0.07 * (0.5 - texture(noiseP, np).x), vec3(0.38) , 0.1), MAT_CHEESE);
		} else { 
			vec3 d = (s * 0.5 -  sign(rd)* q) / abs(rd);
			float b = min(d.x, min(d.y, d.z));
			float a = max(EPS, max(dis - 1.73, b + EPS));
			
			float z =((sign(rd.z) == 1.0 ? 1.0 : 0.0) * LEN_CHEESE - sign(rd.z) * (p.z - (LEN_TORUS + LEN_OBSTACLE + LEN_CAVE) )) / abs(rd.z);
			return vec2(min(a, z + EPS), -1);
		}
	} else if (t < LEN_TORUS + LEN_OBSTACLE + LEN_CAVE + LEN_CHEESE + LEN_NOISE_TUNNEL) { // (n.x + 3 * n.y) % 100 > 50
		float tex = texture(noiseP, vec2(n.x * 0.01 + sin(n.z * 0.01), n.y * 0.01 + sin(n.z * 0.02))).x;
		if (tex > 0.6) {
			return vec2(udRoundBox(q , vec3(0.3), 0.2), MAT_TUNNEL);
		}
	} else { 
		bool mo = mod(abs(n.x), 6) >= 3 && mod(abs(n.y), 4) >= 2 && mod(abs(n.z), 7) >= 4;
		if (mo) {
			vec2 np = vec2(p.x + p.y * 0.5, p.y * 0.5 + p.z);
			return vec2(udRoundBox(q + 0.07 * (0.5 - texture(noiseP, np).x) , vec3(0.2) , 0.4), MAT_STONE);
			
			/*float f1 = udRoundBox(q, vec3(0.3) , 0.2);
			float f2 = udRoundBox(q + rd * 0.001 , vec3(0.3) , 0.2);
			if(f2 < f1)
				return vec2(f2, MAT_STONE);*/
		}
	} 
		
	vec3 d = (s * 0.5 -  sign(rd)* q) / abs(rd);
	return vec2(max(EPS, min(d.x, min(d.y, d.z)) + EPS) , -1);
}



mat3 camRot()
{
	vec3 right = cross(playerForward, playerUp);
	return mat3(playerForward.x, playerForward.y, playerForward.z, playerUp.x, playerUp.y, playerUp.z, right.x, right.y, right.z);
}


float player(vec3 p)
{
	vec3 pt = p - playerPos; 
	float s = clamp(playerSpeed * 0.005, 0, 0.1); 
	float r = max(abs(yawVel), max(abs(pitchVel), abs(rollVel)));
	vec3 ptr = invAircraftRot * pt;
	return smin(sdTorus(ptr, vec2(0.5 +  r,0.15 - r)), max(sdBox(ptr+vec3(0, -0.5, 0), vec3(0.5)) , sphere(ptr, 0.4f)));
}

vec2 node(vec3 p, vec3 rd)
{	
	vec3 pn = p - nextNodePos;
	pn = pn * rot(tick * 0.5, tick, tick * 0.75);
	/*float s = 2;
	float r = 1.0;
	float dis =  sdTorus(pn, vec2(2, 1.5));
	//dis = sminNode(dis, sdTorus(pn.yzx, vec2(1.5, 1.0)));
	//dis = sminNode(dis, sdTorus(pn.zxy, vec2(2, 1.5)));
	dis = sminNode(dis, sphere(pn + vec3(sin(tick * s) * 3, 0, cos(tick * s) * 3), r));
	dis = sminNode(dis, sphere(pn + vec3(sin(tick * s) * 3, cos(tick * s) * 3, 0), r));
	dis = sminNode(dis, sphere(pn + vec3(0, sin(tick * s) * 3, cos(tick * s) * 3), r));
	dis = sminNode(dis, sphere(pn + vec3(sin(tick * s + 3.14) * 3, 0, cos(tick * s + 3.14) * 3), r));
	dis = sminNode(dis, sphere(pn + vec3(sin(tick * s + 3.14) * 3, cos(tick * s + 3.14) * 3, 0), r));
	dis = sminNode(dis, sphere(pn + vec3(0, sin(tick * s + 3.14) * 3, cos(tick * s + 3.14) * 3), r));*/
	
	float dis = sphere(pn, 3) +
		0.3 * sin(- tick * 4 + pn.y * 0.75 ) +
	  	0.2 * sin( tick * 2 + pn.x*2) +
		0.4 * sin( tick * 5 + pn.z);
	return vec2(dis, MAT_NODE); 
	
	//return vec2(sphere(p - nextNodePos, 4), MAT_NODE);
}

vec2 scene(vec3 p, vec3 rd)
{
	//vec2 res = vec2(9999999.0, -1.0);
	//res = un(res, player(p, rd, invCamRot, ro));
	//res = un(res, map(p, rd));
	//res = un(res, node(p, rd));
	//return res;
	return map(p, rd);
}


vec3 getNormal(vec3 p, vec3 rd, vec3 ro)
{
    vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = scene(p + ep.xyz, rd).x - scene(p - ep.xyz, rd).x;
    normal.y = scene(p + ep.yxz, rd).x - scene(p - ep.yxz, rd).x;
    normal.z = scene(p + ep.yzx, rd).x - scene(p - ep.yzx, rd).x;
    return normalize(normal);
}


float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    //return pow(max(dot(reflect(eye,normal),light), 0.0), 8.0);
    return  pow(k, s);
}

mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

float shadow(in vec3 ro, in vec3 rd, float mint, float maxt )
{
    for( float t=mint; t < maxt; )
    {
        float h = scene(ro + rd*t, rd).x;
        if( h<0.01 )
            return 0.3;
        t += h;
    }
    return 1.0;
}

void main()
{
	float iGlobalTime = float(tick);
    vec2 iResolution = vec2(4, 3);
    //vec3 eye = playerPos - playerForward * (3 + abs(playerSpeed)/1.0f)  + playerUp * (0.75 + abs(playerSpeed)/4.0f);
    vec3 eye = playerPos - playerForward * (2 + abs(playerSpeed)/0.5f)  + playerUp * (0.5 + abs(playerSpeed)/2.0f);
	vec3 eyeDir = vec3(0, -0.5, -1);
	vec3 tar = vec3(0 , 15, 0);//eye + eyeDir;
	vec3 forward = normalize(playerForward);//normalize(tar - eye);
	
	//vec4 upw = rotationMatrix(forward, tick)*vec4(0, 1, 0, 1);
    vec3 up = normalize(playerUp);//upw.xyz;
    vec3 right = (cross(playerForward, up));

    
    float f = 1;
    float u = fragCoord.x;
    float v = windowSize.y/windowSize.x*fragCoord.y; //FIXA 16 9
    //vec3 ro = eye + forward * f + right * u + up * v;
	//vec3 rd = normalize(ro - eye);

    vec3 color = vec3(0, 0, 0); //vec3(0.01, 0.01, 0.01); // Sky color
    vec3 skyColor = color;
   	vec3 ambient = vec3(0.5, 0.5, 0.1);
    //vec3 invLight = -normalize(vec3(0, -0.06, 1)); 
            
    float t = 0.0;
    int N = 1;

    vec3 ro = eye + (forward -0.05*sin((tick-shakeTick)*7)*shake*right) * f + right * u + up * v;
	vec3 rd = normalize(ro - eye);
	vec3 rdStart = rd;
	float ref = 1.0;

	/*for (int i = 0; i < NUM_AIRCRAFTS; i++) {
		invAircraftRots[i] = inverse(camRot(i));
	}
	*/
	invAircraftRot = inverse(camRot());
	//mat3 invCamRot = inverse(camRot(i));

	bool nodeBool = true;
	
	
	int imax = 200;// - int(141*sqrt(u*u + v*v)); //300
	float tmax = 300; //800
	//tmax = tmax - 212*sqrt(u*u + v*v);
	for(int j = 0; j < 2; ++j)
    {
    	t = 0;
    	 for(int i = 0; i < imax && t < tmax; ++i)
   		 {
	        vec3 p = ro + rd * t;
	        vec2 dm = scene(p, rd);
	        float d = dm.x;
	        float m = dm.y;
	        float dt = max(d, EPS);
			bool t2found = false;
	        if(d < EPS || i == imax - 1 || t + dt >= tmax)
	        {
	        	vec3 normal = getNormal(p, rd, ro);
				//vec3 oc = ro - playerPos - vec3(i*10);
				vec3 oc = ro - playerPos;
				float val = dot(rd, oc)*dot(rd, oc) - dot(oc, oc) + 0.45; //0.49;
	        	float t2 = 0;
				if (val > 0 && length(oc) < t) {
		        	for(int i2 = 0; i2 < 30 && t2 < 10; ++i2) {
		        		vec3 p2 = ro + rd * t2;
		        		float d2 = player(p2);
				        if(d2 < EPS){
				        	if (t2 < t) {
				        		t2found = true;
				        		d = d2;
				        		m = MAT_PLAYER;
				        		p = p2;
				        		
							    vec3 ep = vec3(0.01,0,0);
							    normal.x = player(p + ep.xyz) - player(p - ep.xyz);
							    normal.y = player(p + ep.yxz) - player(p - ep.yxz);
							    normal.z = player(p + ep.yzx) - player(p - ep.yzx);
							    normal = normalize(normal);
				        	}
				        	break;
				        }
				        t2 += d2;
		        	}
	        	} 
	        	
	        	/////////////////////////////
	        	{
					//vec3 oc = ro - playerPos - vec3(i*10);
					vec3 oc = ro - nextNodePos;
					float val = dot(rd, oc)*dot(rd, oc) - dot(oc, oc) + 20; //0.49;
		        	float t3 = 0;
					if (val > 0 && length(oc) < t) {
			        	for(int i3 = 0; i3 < 200 && t3 < 200; ++i3) {
			        		vec3 p3 = ro + rd * t3;
			        		vec2 res = node(p3, rd);
							float d3 = res.x;
					        if(d3 < EPS){
					        	if ((t3 < t && t3 < t2 && t2found) || (t3 < t && !t2found)) {
					        		d = res.x;
					        		m = res.y;
					        		p = p3;
					        		
								    vec3 ep = vec3(0.01,0,0);
								    normal.x = node(p + ep.xyz, rd).x - node(p - ep.xyz, rd).x;
								    normal.y = node(p + ep.yxz, rd).x - node(p - ep.yxz, rd).x;
								    normal.z = node(p + ep.yzx, rd).x - node(p - ep.yzx, rd).x;
								    normal = normalize(normal);
					        		
					        		normal.x +=  0.3 * (0.5 - texture(noiseP, vec2(p.x*0.5 + sin(p.y*0.5), p.z*0.5) * 1).x);
									normal.y +=  0.3 * (0.5 - texture(noiseP, vec2(p.z*0.5 + sin(p.x*0.5), p.y*0.5) * 1).x);
									normal.z +=  0.3 * (0.5 - texture(noiseP, vec2(p.y*0.5 + sin(p.z*0.5), p.x*0.5) * 1).x);
									normal = normalize(normal);
	        	
					        		
					        	}
					        	break;
					        }
					        t3 += d3;
			        	}
		        	}
		        	
	        	}
	        	///////////////////////
	        	
	        
	        	vec3 realNormal = normal;
				vec3 invLight = normalize(playerPos - p);
				//normal.x +=  0.2 * (0.5 - texture(noiseP, vec2(p.x + sin(p.y), p.z) * 1).x);
				//normal.y +=  0.2 * (0.5 - texture(noiseP, vec2(p.z + sin(p.x), p.y) * 1).x);
				//normal.z +=  0.2 * (0.5 - texture(noiseP, vec2(p.y + sin(p.z), p.x) * 1).x);
				//normal = normalize(normal);
	        	float diffuse = max(0.,dot(invLight, normal));
	        	float realDiffuse = max(0.,dot(invLight, realNormal));
	        	 if (m == MAT_PLAYER) {
	        		color = mix(color, 0.0*vec3(0.3,0.4,0.2) * (1.0 + realDiffuse), ref); 
	        		if (j == 0) 
	        		color += ref*vec3(specular(realNormal, -invLight, normalize(eye - p), 70.0));
	        		//color = vec3(0, 1, 0);
	        	} else if (m == MAT_BLOCK){
	        		//vec3 s = vec3(1);
					//vec3 q = mod(p,s)-0.5*s;
					//ivec3 n = ivec3(p / s);
					vec3 n = trunc(p);
					vec3 c = vec3(sin(n.y) * 0.1 + 0.5, sin(n.y) * 0.1 + 0.1, sin(n.y) * 0.1 + 0.1);
	        		//vec3 c = vec3(sin(n.x * 0.02) * 0.5 + 0.5, sin(n.y * 0.02) * 0.5 + 0.5, sin(n.z * 0.02) * 0.5 + 0.5);
	        		//vec3 c = texture(noiseP, p.xy).xyz;
	        		color = mix(color, 0.7*c * (1.0 + diffuse), ref);
	        		if (j == 0) 
        				color += ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
	 			} else if (m == MAT_NODE) {
	 				vec3 c = vec3(0.3,0.8 ,0.2)*0.6;
	 				//c *= texture(noiseP, 0.1 * vec2(p.y + p.z * 0.5, p.x + p.z * 0.5)).x;
	 				color = mix(color, 0.7* c * (1.0 + diffuse), ref); 
	        		color += 0.5*ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
	        		nodeBool = false;
 				} else if (m == MAT_STONE) {
 					color = mix(color, 0.7*vec3(0.5) * (1.0 + diffuse), ref);
 					if (j == 0)  
	        			color += ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				} else if (m == MAT_CAVE) {
 					vec3 n = trunc(p);
 					vec3 c = vec3(0.0, 0.1, 0.6 + sin(n.y * 0.3) * 0.4);
 					c = 0.5*vec3(11,34,72)/255.0 + (0.5*(sin(p.y*0.3) + 0.2*sin(p.x) + 0.2*sin(p.z)) + 0.5)*0.3;
 					color = mix(color, 0.7*c * (1.0 + diffuse), ref); 
 					if (j == 0) 
	        			color += 0.5*ref*vec3(specular(normal, -invLight, normalize(eye - p), 100.0));
 				}else if (m == MAT_TUNNEL) {
 					vec3 n = trunc(p);
 					vec3 c = vec3(sin(n.x * 0.04) * 0.5 + 0.5, sin(n.y * 0.04) * 0.5 + 0.5, sin(n.z * 0.04) * 0.5 + 0.5);
 					c = mix(c, vec3(sin(n.y * 2) * 0.1 + 0.8, sin(n.y * 2) * 0.2 + 0.5, sin(n.y * 2) * 0.2 + 0.2), 0.3);
 					color = mix(color, 0.7*c * (1.0 + diffuse), ref); 
 					if (j == 0) 
	        			color += 0.5*ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				}else if (m == MAT_CHEESE) {
 					vec3 n = trunc(p);
 					vec3 c = vec3(1, 1, 0.5);
 					vec3 q = mod(p, 1);
 					float f = length(sin(n));
 					color = (1 - 0.25*f)*mix(color, 0.7*c * (1.0 + diffuse), ref); 
 					if (j == 0) 
	        			color += ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				}else if (m == MAT_OBSTACLE) {
 					vec3 n = trunc(p);
 					vec3 c = vec3(0.9, 0.1, 0.1);
 					color = mix(color, 0.7*c * (1.0 + diffuse), ref); 
 					if (j == 0) 
	        			color += ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				}else if (m == MAT_OBSTACLE_WALL) {
 					if (mod(-tick*50 + (p.z), 300) > 5 
 						|| trunc(mod(p.z, LEN_TOT)) == LEN_TORUS || trunc(mod(p.z, LEN_TOT)) == LEN_TORUS + LEN_OBSTACLE - 1) {
	 					color = mix(color, 0.7*vec3(0.8) * (1.0 + diffuse), ref);
 					} else {
	 					color = mix(color, 0.7*vec3(1, 0, 0) * (1.0 + diffuse), ref);
 					}
 					if (j == 0)  
	        			color += ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				} else if (m == MAT_TURNING) {
 					vec3 c = vec3(sin(p.x * 0.05) * 0.5 + 0.5, sin(p.y * 0.05) * 0.5 + 0.5, sin(p.z * 0.05) * 0.5 + 0.5);
 					color = mix(color, 0.7*c * (1.0 + diffuse), ref);
 					if (j == 0)  
	        			color += ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				}else if (m == MAT_TURNING_WALL) {
 					vec3 c = 0.5*vec3(0.4, 0.254, 0.17);
 					color = mix(color, c * (1.0 + diffuse), ref);
 					if (j == 0)  
	        			color += 0.5*ref*vec3(specular(normal, -invLight, normalize(eye - p), 70.0));
 				}
 				
				//color = applyFog(color, 0.001*distance(eye, p)*distance(eye, p), rd, invLight);
				
			
				//float df = max(0, pow(length(playerPos - p), 2*(1-battery)));
				float df = max(0, pow(length(playerPos - p), 2));
				

				//float f = (1.0) / (1 + 0.04*df);
				float f = (1.0) / (1 + 0.1*df);
				float ang = acos(dot(forward + 0.1*sin((tick-shakeTick)*7)*shake*right, normalize(p - (playerPos + forward))));
				
				
				float batteryLight = 2*clamp(battery, 0, 0.5);
				float maxang = 10*3.14/180.0 *batteryLight;
				
				
				//0 -> maxang ljust, sen smooth mot noll
				//float f2 = (1 - smoothstep2(0, 1*maxang, ang))*10.0;
				float f2 = (1 - smoothstep(maxang, maxang + 0.5*batteryLight, ang))*30;
				
				if(m == MAT_NODE) {
					f = 1;
				}
				if(j == 0){
					color *= clamp(max(f, (smoothstep(0, 1, batteryLight)*5)*f*f2), 0, 1); //f*
				} else if (nodeBool) {
					color *= clamp((f * 10 * smoothstep(0, 1, batteryLight)), 0, 1);
				}
				//color *= ref;	
				color = clamp(color, 0, 1);
	            rd = reflect(rd, realNormal);
	            ro = p + rd*0.02;
	            
	        	if(m == MAT_BLOCK) {
	        		ref *= 0.0;
	        	} else if (m == MAT_PLAYER){
	        		ref *= 0.8;
	        	} else if (m == MAT_NODE) {
	        		ref *= 0.0; //0.2;
	        	} else if (m == MAT_STONE) {
	        		ref = 0.0;
	        	} else {
	        		ref = 0.0;
	        	}
	        	
	        	if (ref <= 0.01) {
	        		j = 10000;
	        	} 
	        	
	           	break;
	        }
	
	        t += dt;
    	}
    }
 
    
   
  // 	color = pow( color, vec3(0.4545) ); //It's not randomly chose. 0.4545 is 1/2.2, which is the standard gamma value for most monitors.
    fragColor = vec4(color,  1.0); //(fragCoord.x < -0.9999 && fragCoord.y < -0.9999) ? 1.0 : 0.3
}


  