/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class WNDCLASSEX
implements Pointer {
    public static final int SIZEOF;
    public static final int SIZE;
    public static final int STYLE;
    public static final int WNDPROC;
    public static final int CLSEXTRA;
    public static final int WNDEXTRA;
    public static final int INSTANCE;
    public static final int ICON;
    public static final int CURSOR;
    public static final int BACKGROUND;
    public static final int MENUNAME;
    public static final int CLASSNAME;
    public static final int ICONSM;
    private final ByteBuffer struct;

    public WNDCLASSEX() {
        this(WNDCLASSEX.malloc());
    }

    public WNDCLASSEX(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setSize(int size) {
        WNDCLASSEX.size(this.struct, size);
    }

    public void setStyle(int style) {
        WNDCLASSEX.style(this.struct, style);
    }

    public void setWndProc(long wndProc) {
        WNDCLASSEX.wndProc(this.struct, wndProc);
    }

    public void setClsExtra(int clsExtra) {
        WNDCLASSEX.clsExtra(this.struct, clsExtra);
    }

    public void setWndExtra(int wndExtra) {
        WNDCLASSEX.wndExtra(this.struct, wndExtra);
    }

    public void setInstance(long instance) {
        WNDCLASSEX.instance(this.struct, instance);
    }

    public void setIcon(long icon) {
        WNDCLASSEX.icon(this.struct, icon);
    }

    public void setCursor(long cursor) {
        WNDCLASSEX.cursor(this.struct, cursor);
    }

    public void setBackground(long background) {
        WNDCLASSEX.background(this.struct, background);
    }

    public void setMenuName(long menuName) {
        WNDCLASSEX.menuName(this.struct, menuName);
    }

    public void setMenuName(ByteBuffer menuName) {
        WNDCLASSEX.menuName(this.struct, menuName);
    }

    public void setClassName(long className) {
        WNDCLASSEX.className(this.struct, className);
    }

    public void setClassName(ByteBuffer className) {
        WNDCLASSEX.className(this.struct, className);
    }

    public void setIconSm(long iconSm) {
        WNDCLASSEX.iconSm(this.struct, iconSm);
    }

    public int getSize() {
        return WNDCLASSEX.size(this.struct);
    }

    public int getStyle() {
        return WNDCLASSEX.style(this.struct);
    }

    public long getWndProc() {
        return WNDCLASSEX.wndProc(this.struct);
    }

    public int getClsExtra() {
        return WNDCLASSEX.clsExtra(this.struct);
    }

    public int getWndExtra() {
        return WNDCLASSEX.wndExtra(this.struct);
    }

    public long getInstance() {
        return WNDCLASSEX.instance(this.struct);
    }

    public long getIcon() {
        return WNDCLASSEX.icon(this.struct);
    }

    public long getCursor() {
        return WNDCLASSEX.cursor(this.struct);
    }

    public long getBackground() {
        return WNDCLASSEX.background(this.struct);
    }

    public long getMenuName() {
        return WNDCLASSEX.menuName(this.struct);
    }

    public ByteBuffer getMenuNameBuffer() {
        return WNDCLASSEX.menuNameBuffer(this.struct);
    }

    public String getMenuNameString() {
        return WNDCLASSEX.menuNameString(this.struct);
    }

    public long getClassName() {
        return WNDCLASSEX.className(this.struct);
    }

    public ByteBuffer getClassNameBuffer() {
        return WNDCLASSEX.classNameBuffer(this.struct);
    }

    public String getClassNameString() {
        return WNDCLASSEX.classNameString(this.struct);
    }

    public long getIconSm() {
        return WNDCLASSEX.iconSm(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int size, int style, long wndProc, int clsExtra, int wndExtra, long instance, long icon, long cursor, long background, ByteBuffer menuName, ByteBuffer className, long iconSm) {
        ByteBuffer wndclassex = WNDCLASSEX.malloc();
        WNDCLASSEX.size(wndclassex, size);
        WNDCLASSEX.style(wndclassex, style);
        WNDCLASSEX.wndProc(wndclassex, wndProc);
        WNDCLASSEX.clsExtra(wndclassex, clsExtra);
        WNDCLASSEX.wndExtra(wndclassex, wndExtra);
        WNDCLASSEX.instance(wndclassex, instance);
        WNDCLASSEX.icon(wndclassex, icon);
        WNDCLASSEX.cursor(wndclassex, cursor);
        WNDCLASSEX.background(wndclassex, background);
        WNDCLASSEX.menuName(wndclassex, menuName);
        WNDCLASSEX.className(wndclassex, className);
        WNDCLASSEX.iconSm(wndclassex, iconSm);
        return wndclassex;
    }

    public static void size(ByteBuffer wndclassex, int size) {
        wndclassex.putInt(wndclassex.position() + SIZE, size);
    }

    public static void style(ByteBuffer wndclassex, int style) {
        wndclassex.putInt(wndclassex.position() + STYLE, style);
    }

    public static void wndProc(ByteBuffer wndclassex, long wndProc) {
        PointerBuffer.put(wndclassex, wndclassex.position() + WNDPROC, wndProc);
    }

    public static void clsExtra(ByteBuffer wndclassex, int clsExtra) {
        wndclassex.putInt(wndclassex.position() + CLSEXTRA, clsExtra);
    }

    public static void wndExtra(ByteBuffer wndclassex, int wndExtra) {
        wndclassex.putInt(wndclassex.position() + WNDEXTRA, wndExtra);
    }

    public static void instance(ByteBuffer wndclassex, long instance) {
        PointerBuffer.put(wndclassex, wndclassex.position() + INSTANCE, instance);
    }

    public static void icon(ByteBuffer wndclassex, long icon) {
        PointerBuffer.put(wndclassex, wndclassex.position() + ICON, icon);
    }

    public static void cursor(ByteBuffer wndclassex, long cursor) {
        PointerBuffer.put(wndclassex, wndclassex.position() + CURSOR, cursor);
    }

    public static void background(ByteBuffer wndclassex, long background) {
        PointerBuffer.put(wndclassex, wndclassex.position() + BACKGROUND, background);
    }

    public static void menuName(ByteBuffer wndclassex, long menuName) {
        PointerBuffer.put(wndclassex, wndclassex.position() + MENUNAME, menuName);
    }

    public static void menuName(ByteBuffer wndclassex, ByteBuffer menuName) {
        if (LWJGLUtil.CHECKS && menuName != null) {
            Checks.checkNT2(menuName);
        }
        WNDCLASSEX.menuName(wndclassex, MemoryUtil.memAddressSafe(menuName));
    }

    public static void className(ByteBuffer wndclassex, long className) {
        PointerBuffer.put(wndclassex, wndclassex.position() + CLASSNAME, className);
    }

    public static void className(ByteBuffer wndclassex, ByteBuffer className) {
        if (LWJGLUtil.CHECKS && className != null) {
            Checks.checkNT2(className);
        }
        WNDCLASSEX.className(wndclassex, MemoryUtil.memAddressSafe(className));
    }

    public static void iconSm(ByteBuffer wndclassex, long iconSm) {
        PointerBuffer.put(wndclassex, wndclassex.position() + ICONSM, iconSm);
    }

    public static int size(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + SIZE);
    }

    public static int style(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + STYLE);
    }

    public static long wndProc(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + WNDPROC);
    }

    public static int clsExtra(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + CLSEXTRA);
    }

    public static int wndExtra(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + WNDEXTRA);
    }

    public static long instance(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + INSTANCE);
    }

    public static long icon(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + ICON);
    }

    public static long cursor(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + CURSOR);
    }

    public static long background(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + BACKGROUND);
    }

    public static long menuName(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + MENUNAME);
    }

    public static ByteBuffer menuNameBuffer(ByteBuffer wndclassex) {
        return MemoryUtil.memByteBufferNT2(WNDCLASSEX.menuName(wndclassex));
    }

    public static String menuNameString(ByteBuffer wndclassex) {
        return MemoryUtil.memDecodeUTF16(WNDCLASSEX.menuName(wndclassex));
    }

    public static long className(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + CLASSNAME);
    }

    public static ByteBuffer classNameBuffer(ByteBuffer wndclassex) {
        return MemoryUtil.memByteBufferNT2(WNDCLASSEX.className(wndclassex));
    }

    public static String classNameString(ByteBuffer wndclassex) {
        return MemoryUtil.memDecodeUTF16(WNDCLASSEX.className(wndclassex));
    }

    public static long iconSm(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + ICONSM);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(12);
        SIZEOF = WNDCLASSEX.offsets(MemoryUtil.memAddress(offsets));
        SIZE = offsets.get(0);
        STYLE = offsets.get(1);
        WNDPROC = offsets.get(2);
        CLSEXTRA = offsets.get(3);
        WNDEXTRA = offsets.get(4);
        INSTANCE = offsets.get(5);
        ICON = offsets.get(6);
        CURSOR = offsets.get(7);
        BACKGROUND = offsets.get(8);
        MENUNAME = offsets.get(9);
        CLASSNAME = offsets.get(10);
        ICONSM = offsets.get(11);
    }
}

