/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINT;

public final class MSG
implements Pointer {
    public static final int SIZEOF;
    public static final int WINDOW;
    public static final int MESSAGE;
    public static final int WPARAM;
    public static final int LPARAM;
    public static final int TIME;
    public static final int POINT;
    private final ByteBuffer struct;

    public MSG() {
        this(MSG.malloc());
    }

    public MSG(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setWindow(long window) {
        MSG.window(this.struct, window);
    }

    public void setMessage(int message) {
        MSG.message(this.struct, message);
    }

    public void setWParam(long wParam) {
        MSG.wParam(this.struct, wParam);
    }

    public void setLParam(long lParam) {
        MSG.lParam(this.struct, lParam);
    }

    public void setTime(int time) {
        MSG.time(this.struct, time);
    }

    public void setPoint(ByteBuffer point) {
        MSG.pointSet(this.struct, point);
    }

    public void setPointX(int x) {
        MSG.pointX(this.struct, x);
    }

    public void setPointY(int y) {
        MSG.pointY(this.struct, y);
    }

    public long getWindow() {
        return MSG.window(this.struct);
    }

    public int getMessage() {
        return MSG.message(this.struct);
    }

    public long getWParam() {
        return MSG.wParam(this.struct);
    }

    public long getLParam() {
        return MSG.lParam(this.struct);
    }

    public int getTime() {
        return MSG.time(this.struct);
    }

    public void getPoint(ByteBuffer point) {
        MSG.pointGet(this.struct, point);
    }

    public int getPointX() {
        return MSG.pointX(this.struct);
    }

    public int getPointY() {
        return MSG.pointY(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long window, int message, long wParam, long lParam, int time, ByteBuffer point) {
        ByteBuffer msg = MSG.malloc();
        MSG.window(msg, window);
        MSG.message(msg, message);
        MSG.wParam(msg, wParam);
        MSG.lParam(msg, lParam);
        MSG.time(msg, time);
        MSG.pointSet(msg, point);
        return msg;
    }

    public static void window(ByteBuffer msg, long window) {
        PointerBuffer.put(msg, msg.position() + WINDOW, window);
    }

    public static void message(ByteBuffer msg, int message) {
        msg.putInt(msg.position() + MESSAGE, message);
    }

    public static void wParam(ByteBuffer msg, long wParam) {
        PointerBuffer.put(msg, msg.position() + WPARAM, wParam);
    }

    public static void lParam(ByteBuffer msg, long lParam) {
        PointerBuffer.put(msg, msg.position() + LPARAM, lParam);
    }

    public static void time(ByteBuffer msg, int time) {
        msg.putInt(msg.position() + TIME, time);
    }

    public static void pointSet(ByteBuffer msg, ByteBuffer point) {
        if (point != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(point), MemoryUtil.memAddress(msg) + (long)POINT, org.lwjgl.system.windows.POINT.SIZEOF);
        }
    }

    public static void pointX(ByteBuffer msg, int x) {
        msg.putInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.X, x);
    }

    public static void pointY(ByteBuffer msg, int y) {
        msg.putInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.Y, y);
    }

    public static long window(ByteBuffer msg) {
        return PointerBuffer.get(msg, msg.position() + WINDOW);
    }

    public static int message(ByteBuffer msg) {
        return msg.getInt(msg.position() + MESSAGE);
    }

    public static long wParam(ByteBuffer msg) {
        return PointerBuffer.get(msg, msg.position() + WPARAM);
    }

    public static long lParam(ByteBuffer msg) {
        return PointerBuffer.get(msg, msg.position() + LPARAM);
    }

    public static int time(ByteBuffer msg) {
        return msg.getInt(msg.position() + TIME);
    }

    public static void pointGet(ByteBuffer msg, ByteBuffer point) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)point, org.lwjgl.system.windows.POINT.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(msg) + (long)POINT, MemoryUtil.memAddress(point), org.lwjgl.system.windows.POINT.SIZEOF);
    }

    public static int pointX(ByteBuffer msg) {
        return msg.getInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.X);
    }

    public static int pointY(ByteBuffer msg) {
        return msg.getInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.Y);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = MSG.offsets(MemoryUtil.memAddress(offsets));
        WINDOW = offsets.get(0);
        MESSAGE = offsets.get(1);
        WPARAM = offsets.get(2);
        LPARAM = offsets.get(3);
        TIME = offsets.get(4);
        POINT = offsets.get(5);
    }
}

