/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINTL;

public final class DEVMODE
implements Pointer {
    public static final int SIZEOF;
    public static final int DEVICENAME;
    public static final int SPECVERSION;
    public static final int DRIVERVERSION;
    public static final int SIZE;
    public static final int DRIVEREXTRA;
    public static final int FIELDS;
    public static final int POSITION;
    public static final int LOGPIXELS;
    public static final int BITSPERPEL;
    public static final int PELSWIDTH;
    public static final int PELSHEIGHT;
    public static final int DISPLAYFLAGS;
    public static final int DISPLAYFREQUENCY;
    private final ByteBuffer struct;

    public DEVMODE() {
        this(DEVMODE.malloc());
    }

    public DEVMODE(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setDeviceName(ByteBuffer deviceName) {
        DEVMODE.deviceNameSet(this.struct, deviceName);
    }

    public void setDeviceName(CharSequence deviceName) {
        DEVMODE.deviceName(this.struct, deviceName);
    }

    public void setSpecVersion(int specVersion) {
        DEVMODE.specVersion(this.struct, specVersion);
    }

    public void setDriverVersion(int driverVersion) {
        DEVMODE.driverVersion(this.struct, driverVersion);
    }

    public void setSize(int size) {
        DEVMODE.size(this.struct, size);
    }

    public void setDriverExtra(int driverExtra) {
        DEVMODE.driverExtra(this.struct, driverExtra);
    }

    public void setFields(int fields) {
        DEVMODE.fields(this.struct, fields);
    }

    public void setPosition(ByteBuffer position) {
        DEVMODE.positionSet(this.struct, position);
    }

    public void setPositionX(int x) {
        DEVMODE.positionX(this.struct, x);
    }

    public void setPositionY(int y) {
        DEVMODE.positionY(this.struct, y);
    }

    public void setLogPixels(int logPixels) {
        DEVMODE.logPixels(this.struct, logPixels);
    }

    public void setBitsPerPel(int bitsPerPel) {
        DEVMODE.bitsPerPel(this.struct, bitsPerPel);
    }

    public void setPelsWidth(int pelsWidth) {
        DEVMODE.pelsWidth(this.struct, pelsWidth);
    }

    public void setPelsHeight(int pelsHeight) {
        DEVMODE.pelsHeight(this.struct, pelsHeight);
    }

    public void setDisplayFlags(int displayFlags) {
        DEVMODE.displayFlags(this.struct, displayFlags);
    }

    public void setDisplayFrequency(int displayFrequency) {
        DEVMODE.displayFrequency(this.struct, displayFrequency);
    }

    public void getDeviceName(ByteBuffer deviceName) {
        DEVMODE.deviceNameGet(this.struct, deviceName);
    }

    public String getDeviceNameString() {
        return DEVMODE.deviceNameString(this.struct);
    }

    public String getDeviceNameString(int byteLen) {
        return DEVMODE.deviceNameString(this.struct, byteLen);
    }

    public int getSpecVersion() {
        return DEVMODE.specVersion(this.struct);
    }

    public int getDriverVersion() {
        return DEVMODE.driverVersion(this.struct);
    }

    public int getSize() {
        return DEVMODE.size(this.struct);
    }

    public int getDriverExtra() {
        return DEVMODE.driverExtra(this.struct);
    }

    public int getFields() {
        return DEVMODE.fields(this.struct);
    }

    public void getPosition(ByteBuffer position) {
        DEVMODE.positionGet(this.struct, position);
    }

    public int getPositionX() {
        return DEVMODE.positionX(this.struct);
    }

    public int getPositionY() {
        return DEVMODE.positionY(this.struct);
    }

    public int getLogPixels() {
        return DEVMODE.logPixels(this.struct);
    }

    public int getBitsPerPel() {
        return DEVMODE.bitsPerPel(this.struct);
    }

    public int getPelsWidth() {
        return DEVMODE.pelsWidth(this.struct);
    }

    public int getPelsHeight() {
        return DEVMODE.pelsHeight(this.struct);
    }

    public int getDisplayFlags() {
        return DEVMODE.displayFlags(this.struct);
    }

    public int getDisplayFrequency() {
        return DEVMODE.displayFrequency(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer deviceName, int specVersion, int driverVersion, int size, int driverExtra, int fields, ByteBuffer position, int logPixels, int bitsPerPel, int pelsWidth, int pelsHeight, int displayFlags, int displayFrequency) {
        ByteBuffer devmode = DEVMODE.malloc();
        DEVMODE.deviceNameSet(devmode, deviceName);
        DEVMODE.specVersion(devmode, specVersion);
        DEVMODE.driverVersion(devmode, driverVersion);
        DEVMODE.size(devmode, size);
        DEVMODE.driverExtra(devmode, driverExtra);
        DEVMODE.fields(devmode, fields);
        DEVMODE.positionSet(devmode, position);
        DEVMODE.logPixels(devmode, logPixels);
        DEVMODE.bitsPerPel(devmode, bitsPerPel);
        DEVMODE.pelsWidth(devmode, pelsWidth);
        DEVMODE.pelsHeight(devmode, pelsHeight);
        DEVMODE.displayFlags(devmode, displayFlags);
        DEVMODE.displayFrequency(devmode, displayFrequency);
        return devmode;
    }

    public static ByteBuffer malloc(CharSequence deviceName, int specVersion, int driverVersion, int size, int driverExtra, int fields, ByteBuffer position, int logPixels, int bitsPerPel, int pelsWidth, int pelsHeight, int displayFlags, int displayFrequency) {
        ByteBuffer devmode = DEVMODE.malloc();
        DEVMODE.deviceName(devmode, deviceName);
        DEVMODE.specVersion(devmode, specVersion);
        DEVMODE.driverVersion(devmode, driverVersion);
        DEVMODE.size(devmode, size);
        DEVMODE.driverExtra(devmode, driverExtra);
        DEVMODE.fields(devmode, fields);
        DEVMODE.positionSet(devmode, position);
        DEVMODE.logPixels(devmode, logPixels);
        DEVMODE.bitsPerPel(devmode, bitsPerPel);
        DEVMODE.pelsWidth(devmode, pelsWidth);
        DEVMODE.pelsHeight(devmode, pelsHeight);
        DEVMODE.displayFlags(devmode, displayFlags);
        DEVMODE.displayFrequency(devmode, displayFrequency);
        return devmode;
    }

    public static void deviceNameSet(ByteBuffer devmode, ByteBuffer deviceName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(deviceName);
            Checks.checkBufferGT(deviceName, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(deviceName), MemoryUtil.memAddress(devmode) + (long)DEVICENAME, deviceName.remaining());
    }

    public static void deviceName(ByteBuffer devmode, CharSequence deviceName) {
        MemoryUtil.memEncodeUTF16(deviceName, true, devmode, DEVICENAME);
    }

    public static void specVersion(ByteBuffer devmode, int specVersion) {
        devmode.putShort(devmode.position() + SPECVERSION, (short)specVersion);
    }

    public static void driverVersion(ByteBuffer devmode, int driverVersion) {
        devmode.putShort(devmode.position() + DRIVERVERSION, (short)driverVersion);
    }

    public static void size(ByteBuffer devmode, int size) {
        devmode.putShort(devmode.position() + SIZE, (short)size);
    }

    public static void driverExtra(ByteBuffer devmode, int driverExtra) {
        devmode.putShort(devmode.position() + DRIVEREXTRA, (short)driverExtra);
    }

    public static void fields(ByteBuffer devmode, int fields) {
        devmode.putInt(devmode.position() + FIELDS, fields);
    }

    public static void positionSet(ByteBuffer devmode, ByteBuffer position) {
        if (position != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(position), MemoryUtil.memAddress(devmode) + (long)POSITION, POINTL.SIZEOF);
        }
    }

    public static void positionX(ByteBuffer devmode, int x) {
        devmode.putInt(devmode.position() + POSITION + POINTL.X, x);
    }

    public static void positionY(ByteBuffer devmode, int y) {
        devmode.putInt(devmode.position() + POSITION + POINTL.Y, y);
    }

    public static void logPixels(ByteBuffer devmode, int logPixels) {
        devmode.putShort(devmode.position() + LOGPIXELS, (short)logPixels);
    }

    public static void bitsPerPel(ByteBuffer devmode, int bitsPerPel) {
        devmode.putInt(devmode.position() + BITSPERPEL, bitsPerPel);
    }

    public static void pelsWidth(ByteBuffer devmode, int pelsWidth) {
        devmode.putInt(devmode.position() + PELSWIDTH, pelsWidth);
    }

    public static void pelsHeight(ByteBuffer devmode, int pelsHeight) {
        devmode.putInt(devmode.position() + PELSHEIGHT, pelsHeight);
    }

    public static void displayFlags(ByteBuffer devmode, int displayFlags) {
        devmode.putInt(devmode.position() + DISPLAYFLAGS, displayFlags);
    }

    public static void displayFrequency(ByteBuffer devmode, int displayFrequency) {
        devmode.putInt(devmode.position() + DISPLAYFREQUENCY, displayFrequency);
    }

    public static void deviceNameGet(ByteBuffer devmode, ByteBuffer deviceName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(deviceName, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(devmode) + (long)DEVICENAME, MemoryUtil.memAddress(deviceName), deviceName.remaining());
    }

    public static String deviceNameString(ByteBuffer devmode) {
        return MemoryUtil.memDecodeUTF16(devmode, MemoryUtil.memStrLen2(devmode, DEVICENAME), DEVICENAME);
    }

    public static String deviceNameString(ByteBuffer devmode, int byteLen) {
        return MemoryUtil.memDecodeUTF16(devmode, byteLen, DEVICENAME);
    }

    public static int specVersion(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + SPECVERSION);
    }

    public static int driverVersion(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + DRIVERVERSION);
    }

    public static int size(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + SIZE);
    }

    public static int driverExtra(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + DRIVEREXTRA);
    }

    public static int fields(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + FIELDS);
    }

    public static void positionGet(ByteBuffer devmode, ByteBuffer position) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)position, POINTL.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(devmode) + (long)POSITION, MemoryUtil.memAddress(position), POINTL.SIZEOF);
    }

    public static int positionX(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + POSITION + POINTL.X);
    }

    public static int positionY(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + POSITION + POINTL.Y);
    }

    public static int logPixels(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + LOGPIXELS);
    }

    public static int bitsPerPel(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + BITSPERPEL);
    }

    public static int pelsWidth(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + PELSWIDTH);
    }

    public static int pelsHeight(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + PELSHEIGHT);
    }

    public static int displayFlags(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + DISPLAYFLAGS);
    }

    public static int displayFrequency(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + DISPLAYFREQUENCY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(13);
        SIZEOF = DEVMODE.offsets(MemoryUtil.memAddress(offsets));
        DEVICENAME = offsets.get(0);
        SPECVERSION = offsets.get(1);
        DRIVERVERSION = offsets.get(2);
        SIZE = offsets.get(3);
        DRIVEREXTRA = offsets.get(4);
        FIELDS = offsets.get(5);
        POSITION = offsets.get(6);
        LOGPIXELS = offsets.get(7);
        BITSPERPEL = offsets.get(8);
        PELSWIDTH = offsets.get(9);
        PELSHEIGHT = offsets.get(10);
        DISPLAYFLAGS = offsets.get(11);
        DISPLAYFREQUENCY = offsets.get(12);
    }
}

