/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.macosx.EnumerationMutationHandler;
import org.lwjgl.system.macosx.ObjCMethodDescription;
import org.lwjgl.system.macosx.ObjCPropertyAttribute;

public final class ObjCRuntime {
    public static final long nil = 0L;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BFLD = 'b';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_CONST = 'r';
    public static final int OBJC_ASSOCIATION_ASSIGN = 0;
    public static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
    public static final int OBJC_ASSOCIATION_COPY_NONATOMIC = 3;
    public static final int OBJC_ASSOCIATION_RETAIN = 1401;
    public static final int OBJC_ASSOCIATION_COPY = 1403;

    private ObjCRuntime() {
    }

    public static native long nobject_copy(long var0, long var2);

    public static long object_copy(long obj, long size) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobject_copy(obj, size);
    }

    public static native long nobject_dispose(long var0);

    public static long object_dispose(long obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobject_dispose(obj);
    }

    public static native long object_getClass(long var0);

    public static native long nobject_setClass(long var0, long var2);

    public static long object_setClass(long obj, long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        return ObjCRuntime.nobject_setClass(obj, cls);
    }

    public static native long nobject_getClassName(long var0);

    public static String object_getClassName(long obj) {
        long __result = ObjCRuntime.nobject_getClassName(obj);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nobject_getIndexedIvars(long var0);

    public static long object_getIndexedIvars(long obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobject_getIndexedIvars(obj);
    }

    public static native long nobject_getIvar(long var0, long var2);

    public static long object_getIvar(long obj, long ivar) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ivar);
        }
        return ObjCRuntime.nobject_getIvar(obj, ivar);
    }

    public static native void nobject_setIvar(long var0, long var2, long var4);

    public static void object_setIvar(long obj, long ivar, long value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
            Checks.checkPointer(ivar);
            Checks.checkPointer(value);
        }
        ObjCRuntime.nobject_setIvar(obj, ivar, value);
    }

    public static native long nobject_setInstanceVariable(long var0, long var2, long var4);

    public static long object_setInstanceVariable(long obj, ByteBuffer name, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobject_setInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(value));
    }

    public static long object_setInstanceVariable(long obj, CharSequence name, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobject_setInstanceVariable(obj, __buffer.address(nameEncoded), MemoryUtil.memAddress(value));
    }

    public static native long nobject_getInstanceVariable(long var0, long var2, long var4);

    public static long object_getInstanceVariable(long obj, ByteBuffer name, ByteBuffer outValue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobject_getInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(outValue));
    }

    public static long object_getInstanceVariable(long obj, ByteBuffer name, PointerBuffer outValue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobject_getInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(outValue));
    }

    public static long object_getInstanceVariable(long obj, CharSequence name, PointerBuffer outValue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobject_getInstanceVariable(obj, __buffer.address(nameEncoded), MemoryUtil.memAddress(outValue));
    }

    public static native long nobjc_getClass(long var0);

    public static long objc_getClass(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(name));
    }

    public static long objc_getClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getClass(__buffer.address(nameEncoded));
    }

    public static native long nobjc_getMetaClass(long var0);

    public static long objc_getMetaClass(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(name));
    }

    public static long objc_getMetaClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getMetaClass(__buffer.address(nameEncoded));
    }

    public static native long nobjc_lookUpClass(long var0);

    public static long objc_lookUpClass(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(name));
    }

    public static long objc_lookUpClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_lookUpClass(__buffer.address(nameEncoded));
    }

    public static native long nobjc_getRequiredClass(long var0);

    public static long objc_getRequiredClass(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(name));
    }

    public static long objc_getRequiredClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getRequiredClass(__buffer.address(nameEncoded));
    }

    public static native int nobjc_getClassList(long var0, int var2);

    public static int objc_getClassList(ByteBuffer buffer, int bufferCount) {
        if (LWJGLUtil.CHECKS && buffer != null) {
            Checks.checkBuffer((Buffer)buffer, bufferCount << Pointer.POINTER_SHIFT);
        }
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(buffer), bufferCount);
    }

    public static int objc_getClassList(PointerBuffer buffer) {
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(buffer), buffer == null ? 0 : buffer.remaining());
    }

    public static native long nobjc_copyClassList(long var0);

    public static PointerBuffer objc_copyClassList() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyClassList(__buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nclass_getName(long var0);

    public static String class_getName(long cls) {
        long __result = ObjCRuntime.nclass_getName(cls);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native byte class_isMetaClass(long var0);

    public static native long class_getSuperclass(long var0);

    public static native int nclass_getVersion(long var0);

    public static int class_getVersion(long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        return ObjCRuntime.nclass_getVersion(cls);
    }

    public static native void nclass_setVersion(long var0, int var2);

    public static void class_setVersion(long cls, int version) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        ObjCRuntime.nclass_setVersion(cls, version);
    }

    public static native long class_getInstanceSize(long var0);

    public static native long nclass_getInstanceVariable(long var0, long var2);

    public static long class_getInstanceVariable(long cls, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getInstanceVariable(cls, MemoryUtil.memAddress(name));
    }

    public static long class_getInstanceVariable(long cls, CharSequence name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_getInstanceVariable(cls, __buffer.address(nameEncoded));
    }

    public static native long nclass_getClassVariable(long var0, long var2);

    public static long class_getClassVariable(long cls, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getClassVariable(cls, MemoryUtil.memAddress(name));
    }

    public static long class_getClassVariable(long cls, CharSequence name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_getClassVariable(cls, __buffer.address(nameEncoded));
    }

    public static native long nclass_copyIvarList(long var0, long var2);

    public static PointerBuffer class_copyIvarList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyIvarList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nclass_getInstanceMethod(long var0, long var2);

    public static long class_getInstanceMethod(long cls, long name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return ObjCRuntime.nclass_getInstanceMethod(cls, name);
    }

    public static native long nclass_getClassMethod(long var0, long var2);

    public static long class_getClassMethod(long cls, long name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return ObjCRuntime.nclass_getClassMethod(cls, name);
    }

    public static native long nclass_getMethodImplementation(long var0, long var2);

    public static long class_getMethodImplementation(long cls, long name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(name);
        }
        return ObjCRuntime.nclass_getMethodImplementation(cls, name);
    }

    public static native byte nclass_respondsToSelector(long var0, long var2);

    public static byte class_respondsToSelector(long cls, long name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return ObjCRuntime.nclass_respondsToSelector(cls, name);
    }

    public static native long nclass_copyMethodList(long var0, long var2);

    public static PointerBuffer class_copyMethodList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyMethodList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native byte nclass_conformsToProtocol(long var0, long var2);

    public static byte class_conformsToProtocol(long cls, long protocol) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(protocol);
        }
        return ObjCRuntime.nclass_conformsToProtocol(cls, protocol);
    }

    public static native long nclass_copyProtocolList(long var0, long var2);

    public static PointerBuffer class_copyProtocolList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyProtocolList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nclass_getProperty(long var0, long var2);

    public static long class_getProperty(long cls, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getProperty(cls, MemoryUtil.memAddress(name));
    }

    public static long class_getProperty(long cls, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_getProperty(cls, __buffer.address(nameEncoded));
    }

    public static native long nclass_copyPropertyList(long var0, long var2);

    public static PointerBuffer class_copyPropertyList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyPropertyList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nclass_getIvarLayout(long var0);

    public static String class_getIvarLayout(long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        long __result = ObjCRuntime.nclass_getIvarLayout(cls);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static native long nclass_getWeakIvarLayout(long var0);

    public static String class_getWeakIvarLayout(long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        long __result = ObjCRuntime.nclass_getWeakIvarLayout(cls);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static native byte nclass_addMethod(long var0, long var2, long var4, long var6);

    public static byte class_addMethod(long cls, long name, long imp, ByteBuffer types) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_addMethod(cls, name, imp, MemoryUtil.memAddress(types));
    }

    public static byte class_addMethod(long cls, long name, long imp, CharSequence types) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        return ObjCRuntime.nclass_addMethod(cls, name, imp, __buffer.address(typesEncoded));
    }

    public static native long nclass_replaceMethod(long var0, long var2, long var4, long var6);

    public static long class_replaceMethod(long cls, long name, long imp, ByteBuffer types) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_replaceMethod(cls, name, imp, MemoryUtil.memAddress(types));
    }

    public static long class_replaceMethod(long cls, long name, long imp, CharSequence types) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        return ObjCRuntime.nclass_replaceMethod(cls, name, imp, __buffer.address(typesEncoded));
    }

    public static native byte nclass_addIvar(long var0, long var2, long var4, byte var6, long var7);

    public static byte class_addIvar(long cls, ByteBuffer name, long size, byte alignment, ByteBuffer types) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(name);
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_addIvar(cls, MemoryUtil.memAddress(name), size, alignment, MemoryUtil.memAddress(types));
    }

    public static byte class_addIvar(long cls, CharSequence name, long size, byte alignment, CharSequence types) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        return ObjCRuntime.nclass_addIvar(cls, __buffer.address(nameEncoded), size, alignment, __buffer.address(typesEncoded));
    }

    public static native byte nclass_addProtocol(long var0, long var2);

    public static byte class_addProtocol(long cls, long protocol) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(protocol);
        }
        return ObjCRuntime.nclass_addProtocol(cls, protocol);
    }

    public static native byte nclass_addProperty(long var0, long var2, long var4, int var6);

    public static byte class_addProperty(long cls, ByteBuffer name, ByteBuffer attributes, int attributeCount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(name);
            Checks.checkBuffer((Buffer)attributes, attributeCount * ObjCPropertyAttribute.SIZEOF);
        }
        return ObjCRuntime.nclass_addProperty(cls, MemoryUtil.memAddress(name), MemoryUtil.memAddress(attributes), attributeCount);
    }

    public static byte class_addProperty(long cls, ByteBuffer name, ByteBuffer attributes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        return ObjCRuntime.nclass_addProperty(cls, MemoryUtil.memAddress(name), MemoryUtil.memAddress(attributes), attributes.remaining());
    }

    public static byte class_addProperty(long cls, CharSequence name, ByteBuffer attributes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_addProperty(cls, __buffer.address(nameEncoded), MemoryUtil.memAddress(attributes), attributes.remaining());
    }

    public static native void nclass_replaceProperty(long var0, long var2, long var4, int var6);

    public static void class_replaceProperty(long cls, ByteBuffer name, ByteBuffer attributes, int attributeCount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(name);
            Checks.checkBuffer((Buffer)attributes, attributeCount * ObjCPropertyAttribute.SIZEOF);
        }
        ObjCRuntime.nclass_replaceProperty(cls, MemoryUtil.memAddress(name), MemoryUtil.memAddress(attributes), attributeCount);
    }

    public static void class_replaceProperty(long cls, ByteBuffer name, ByteBuffer attributes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        ObjCRuntime.nclass_replaceProperty(cls, MemoryUtil.memAddress(name), MemoryUtil.memAddress(attributes), attributes.remaining());
    }

    public static void class_replaceProperty(long cls, CharSequence name, ByteBuffer attributes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        ObjCRuntime.nclass_replaceProperty(cls, __buffer.address(nameEncoded), MemoryUtil.memAddress(attributes), attributes.remaining());
    }

    public static native void nclass_setIvarLayout(long var0, long var2);

    public static void class_setIvarLayout(long cls, ByteBuffer layout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(layout);
        }
        ObjCRuntime.nclass_setIvarLayout(cls, MemoryUtil.memAddress(layout));
    }

    public static void class_setIvarLayout(long cls, CharSequence layout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int layoutEncoded = __buffer.stringParamASCII(layout, true);
        ObjCRuntime.nclass_setIvarLayout(cls, __buffer.address(layoutEncoded));
    }

    public static native void nclass_setWeakIvarLayout(long var0, long var2);

    public static void class_setWeakIvarLayout(long cls, ByteBuffer layout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkNT1(layout);
        }
        ObjCRuntime.nclass_setWeakIvarLayout(cls, MemoryUtil.memAddress(layout));
    }

    public static void class_setWeakIvarLayout(long cls, CharSequence layout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int layoutEncoded = __buffer.stringParamASCII(layout, true);
        ObjCRuntime.nclass_setWeakIvarLayout(cls, __buffer.address(layoutEncoded));
    }

    public static native long nclass_createInstance(long var0, long var2);

    public static long class_createInstance(long cls, long extraBytes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        return ObjCRuntime.nclass_createInstance(cls, extraBytes);
    }

    public static native long nobjc_constructInstance(long var0, long var2);

    public static long objc_constructInstance(long cls, ByteBuffer bytes) {
        return ObjCRuntime.nobjc_constructInstance(cls, MemoryUtil.memAddressSafe(bytes));
    }

    public static native long nobjc_destructInstance(long var0);

    public static long objc_destructInstance(long obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobjc_destructInstance(obj);
    }

    public static native long nobjc_allocateClassPair(long var0, long var2, long var4);

    public static long objc_allocateClassPair(long superclass, ByteBuffer name, long extraBytes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_allocateClassPair(superclass, MemoryUtil.memAddress(name), extraBytes);
    }

    public static long objc_allocateClassPair(long superclass, CharSequence name, long extraBytes) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_allocateClassPair(superclass, __buffer.address(nameEncoded), extraBytes);
    }

    public static native void nobjc_registerClassPair(long var0);

    public static void objc_registerClassPair(long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        ObjCRuntime.nobjc_registerClassPair(cls);
    }

    public static native void nobjc_disposeClassPair(long var0);

    public static void objc_disposeClassPair(long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        ObjCRuntime.nobjc_disposeClassPair(cls);
    }

    public static native long nmethod_getName(long var0);

    public static long method_getName(long m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        return ObjCRuntime.nmethod_getName(m);
    }

    public static native long nmethod_getImplementation(long var0);

    public static long method_getImplementation(long m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        return ObjCRuntime.nmethod_getImplementation(m);
    }

    public static native long nmethod_getTypeEncoding(long var0);

    public static String method_getTypeEncoding(long m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        long __result = ObjCRuntime.nmethod_getTypeEncoding(m);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native int nmethod_getNumberOfArguments(long var0);

    public static int method_getNumberOfArguments(long m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        return ObjCRuntime.nmethod_getNumberOfArguments(m);
    }

    public static native long nmethod_copyReturnType(long var0);

    public static String method_copyReturnType(long m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        long __result = ObjCRuntime.nmethod_copyReturnType(m);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nmethod_copyArgumentType(long var0, int var2);

    public static String method_copyArgumentType(long m, int index) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        long __result = ObjCRuntime.nmethod_copyArgumentType(m, index);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void nmethod_getReturnType(long var0, long var2, long var4);

    public static void method_getReturnType(long m, ByteBuffer dst, long dst_len) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
            Checks.checkBuffer((Buffer)dst, dst_len);
        }
        ObjCRuntime.nmethod_getReturnType(m, MemoryUtil.memAddress(dst), dst_len);
    }

    public static void method_getReturnType(long m, ByteBuffer dst) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        ObjCRuntime.nmethod_getReturnType(m, MemoryUtil.memAddress(dst), dst.remaining());
    }

    public static String method_getReturnType(long m, long dst_len) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int dst = __buffer.bufferParam((int)dst_len);
        ObjCRuntime.nmethod_getReturnType(m, __buffer.address(dst), dst_len);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(__buffer.address(dst), (int)dst_len));
    }

    public static native void nmethod_getArgumentType(long var0, int var2, long var3, long var5);

    public static void method_getArgumentType(long m, int index, ByteBuffer dst, long dst_len) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
            Checks.checkBuffer((Buffer)dst, dst_len);
        }
        ObjCRuntime.nmethod_getArgumentType(m, index, MemoryUtil.memAddress(dst), dst_len);
    }

    public static void method_getArgumentType(long m, int index, ByteBuffer dst) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        ObjCRuntime.nmethod_getArgumentType(m, index, MemoryUtil.memAddress(dst), dst.remaining());
    }

    public static String method_getArgumentType(long m, int index, long dst_len) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int dst = __buffer.bufferParam((int)dst_len);
        ObjCRuntime.nmethod_getArgumentType(m, index, __buffer.address(dst), dst_len);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(__buffer.address(dst), (int)dst_len));
    }

    public static native long nmethod_setImplementation(long var0, long var2);

    public static long method_setImplementation(long m, long imp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m);
            Checks.checkPointer(imp);
        }
        return ObjCRuntime.nmethod_setImplementation(m, imp);
    }

    public static native void nmethod_exchangeImplementations(long var0, long var2);

    public static void method_exchangeImplementations(long m1, long m2) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(m1);
            Checks.checkPointer(m2);
        }
        ObjCRuntime.nmethod_exchangeImplementations(m1, m2);
    }

    public static native long nivar_getName(long var0);

    public static String ivar_getName(long v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(v);
        }
        long __result = ObjCRuntime.nivar_getName(v);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nivar_getTypeEncoding(long var0);

    public static String ivar_getTypeEncoding(long v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(v);
        }
        long __result = ObjCRuntime.nivar_getTypeEncoding(v);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nivar_getOffset(long var0);

    public static long ivar_getOffset(long v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(v);
        }
        return ObjCRuntime.nivar_getOffset(v);
    }

    public static native long nproperty_getName(long var0);

    public static String property_getName(long property) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(property);
        }
        long __result = ObjCRuntime.nproperty_getName(property);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nproperty_getAttributes(long var0);

    public static String property_getAttributes(long property) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(property);
        }
        long __result = ObjCRuntime.nproperty_getAttributes(property);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nproperty_copyAttributeList(long var0, long var2);

    public static ByteBuffer property_copyAttributeList(long property, ByteBuffer outCount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(property);
        }
        long __result = ObjCRuntime.nproperty_copyAttributeList(property, MemoryUtil.memAddress(outCount));
        return MemoryUtil.memByteBuffer(__result, outCount.getInt(outCount.position()) * ObjCPropertyAttribute.SIZEOF);
    }

    public static ByteBuffer property_copyAttributeList(long property, IntBuffer outCount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(property);
        }
        long __result = ObjCRuntime.nproperty_copyAttributeList(property, MemoryUtil.memAddress(outCount));
        return MemoryUtil.memByteBuffer(__result, outCount.get(outCount.position()) * ObjCPropertyAttribute.SIZEOF);
    }

    public static native long nproperty_copyAttributeValue(long var0, long var2);

    public static String property_copyAttributeValue(long property, ByteBuffer attributeName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(property);
        }
        long __result = ObjCRuntime.nproperty_copyAttributeValue(property, MemoryUtil.memAddress(attributeName));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static String property_copyAttributeValue(long property, CharSequence attributeName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(property);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attributeNameEncoded = __buffer.stringParamUTF8(attributeName, true);
        long __result = ObjCRuntime.nproperty_copyAttributeValue(property, __buffer.address(attributeNameEncoded));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nobjc_getProtocol(long var0);

    public static long objc_getProtocol(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(name));
    }

    public static long objc_getProtocol(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getProtocol(__buffer.address(nameEncoded));
    }

    public static native long nobjc_copyProtocolList(long var0);

    public static PointerBuffer objc_copyProtocolList() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyProtocolList(__buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native byte nprotocol_conformsToProtocol(long var0, long var2);

    public static byte protocol_conformsToProtocol(long proto, long other) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(other);
        }
        return ObjCRuntime.nprotocol_conformsToProtocol(proto, other);
    }

    public static native byte nprotocol_isEqual(long var0, long var2);

    public static byte protocol_isEqual(long proto, long other) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(other);
        }
        return ObjCRuntime.nprotocol_isEqual(proto, other);
    }

    public static native long nprotocol_getName(long var0);

    public static String protocol_getName(long p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(p);
        }
        long __result = ObjCRuntime.nprotocol_getName(p);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void nprotocol_getMethodDescription(long var0, long var2, byte var4, byte var5, long var6);

    public static void protocol_getMethodDescription(long p, long aSel, byte isRequiredMethod, byte isInstanceMethod, ByteBuffer __result) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(p);
            Checks.checkPointer(aSel);
        }
        ObjCRuntime.nprotocol_getMethodDescription(p, aSel, isRequiredMethod, isInstanceMethod, MemoryUtil.memAddress(__result));
    }

    public static native long nprotocol_copyMethodDescriptionList(long var0, byte var2, byte var3, long var4);

    public static ByteBuffer protocol_copyMethodDescriptionList(long p, byte isRequiredMethod, byte isInstanceMethod, ByteBuffer outCount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(p);
        }
        long __result = ObjCRuntime.nprotocol_copyMethodDescriptionList(p, isRequiredMethod, isInstanceMethod, MemoryUtil.memAddress(outCount));
        return MemoryUtil.memByteBuffer(__result, outCount.getInt(outCount.position()) * ObjCMethodDescription.SIZEOF);
    }

    public static ByteBuffer protocol_copyMethodDescriptionList(long p, byte isRequiredMethod, byte isInstanceMethod, IntBuffer outCount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(p);
        }
        long __result = ObjCRuntime.nprotocol_copyMethodDescriptionList(p, isRequiredMethod, isInstanceMethod, MemoryUtil.memAddress(outCount));
        return MemoryUtil.memByteBuffer(__result, outCount.get(outCount.position()) * ObjCMethodDescription.SIZEOF);
    }

    public static native long nprotocol_getProperty(long var0, long var2, byte var4, byte var5);

    public static long protocol_getProperty(long proto, ByteBuffer name, byte isRequiredProperty, byte isInstanceProperty) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nprotocol_getProperty(proto, MemoryUtil.memAddress(name), isRequiredProperty, isInstanceProperty);
    }

    public static long protocol_getProperty(long proto, CharSequence name, byte isRequiredProperty, byte isInstanceProperty) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nprotocol_getProperty(proto, __buffer.address(nameEncoded), isRequiredProperty, isInstanceProperty);
    }

    public static native long nprotocol_copyPropertyList(long var0, long var2);

    public static PointerBuffer protocol_copyPropertyList(long proto) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nprotocol_copyPropertyList(proto, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nprotocol_copyProtocolList(long var0, long var2);

    public static PointerBuffer protocol_copyProtocolList(long proto) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nprotocol_copyProtocolList(proto, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nobjc_allocateProtocol(long var0);

    public static long objc_allocateProtocol(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(name));
    }

    public static long objc_allocateProtocol(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_allocateProtocol(__buffer.address(nameEncoded));
    }

    public static native void nobjc_registerProtocol(long var0);

    public static void objc_registerProtocol(long proto) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
        }
        ObjCRuntime.nobjc_registerProtocol(proto);
    }

    public static native void nprotocol_addMethodDescription(long var0, long var2, long var4, byte var6, byte var7);

    public static void protocol_addMethodDescription(long proto, long name, ByteBuffer types, byte isRequiredMethod, byte isInstanceMethod) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(name);
            Checks.checkNT1(types);
        }
        ObjCRuntime.nprotocol_addMethodDescription(proto, name, MemoryUtil.memAddress(types), isRequiredMethod, isInstanceMethod);
    }

    public static void protocol_addMethodDescription(long proto, long name, CharSequence types, byte isRequiredMethod, byte isInstanceMethod) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(name);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        ObjCRuntime.nprotocol_addMethodDescription(proto, name, __buffer.address(typesEncoded), isRequiredMethod, isInstanceMethod);
    }

    public static native void nprotocol_addProtocol(long var0, long var2);

    public static void protocol_addProtocol(long proto, long addition) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(addition);
        }
        ObjCRuntime.nprotocol_addProtocol(proto, addition);
    }

    public static native void nprotocol_addProperty(long var0, long var2, long var4, int var6, byte var7, byte var8);

    public static void protocol_addProperty(long proto, ByteBuffer name, ByteBuffer attributes, int attributeCount, byte isRequiredProperty, byte isInstanceProperty) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkNT1(name);
            Checks.checkBuffer((Buffer)attributes, attributeCount * ObjCPropertyAttribute.SIZEOF);
        }
        ObjCRuntime.nprotocol_addProperty(proto, MemoryUtil.memAddress(name), MemoryUtil.memAddress(attributes), attributeCount, isRequiredProperty, isInstanceProperty);
    }

    public static void protocol_addProperty(long proto, ByteBuffer name, ByteBuffer attributes, byte isRequiredProperty, byte isInstanceProperty) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
        }
        ObjCRuntime.nprotocol_addProperty(proto, MemoryUtil.memAddress(name), MemoryUtil.memAddress(attributes), attributes.remaining(), isRequiredProperty, isInstanceProperty);
    }

    public static void protocol_addProperty(long proto, CharSequence name, ByteBuffer attributes, byte isRequiredProperty, byte isInstanceProperty) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(proto);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        ObjCRuntime.nprotocol_addProperty(proto, __buffer.address(nameEncoded), MemoryUtil.memAddress(attributes), attributes.remaining(), isRequiredProperty, isInstanceProperty);
    }

    public static native long nobjc_copyImageNames(long var0);

    public static PointerBuffer objc_copyImageNames() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyImageNames(__buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nclass_getImageName(long var0);

    public static String class_getImageName(long cls) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cls);
        }
        long __result = ObjCRuntime.nclass_getImageName(cls);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nobjc_copyClassNamesForImage(long var0, long var2);

    public static PointerBuffer objc_copyClassNamesForImage(ByteBuffer image) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(image);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(image), __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static PointerBuffer objc_copyClassNamesForImage(CharSequence image) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        int imageEncoded = __buffer.stringParamUTF8(image, true);
        long __result = ObjCRuntime.nobjc_copyClassNamesForImage(__buffer.address(imageEncoded), __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static native long nsel_getName(long var0);

    public static String sel_getName(long sel) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(sel);
        }
        long __result = ObjCRuntime.nsel_getName(sel);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nsel_getUid(long var0);

    public static long sel_getUid(ByteBuffer str) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(str);
        }
        return ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(str));
    }

    public static long sel_getUid(CharSequence str) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int strEncoded = __buffer.stringParamUTF8(str, true);
        return ObjCRuntime.nsel_getUid(__buffer.address(strEncoded));
    }

    public static native long nsel_registerName(long var0);

    public static long sel_registerName(ByteBuffer str) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(str);
        }
        return ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(str));
    }

    public static long sel_registerName(CharSequence str) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int strEncoded = __buffer.stringParamUTF8(str, true);
        return ObjCRuntime.nsel_registerName(__buffer.address(strEncoded));
    }

    public static native byte nsel_isEqual(long var0, long var2);

    public static byte sel_isEqual(long lhs, long rhs) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(lhs);
            Checks.checkPointer(rhs);
        }
        return ObjCRuntime.nsel_isEqual(lhs, rhs);
    }

    public static native void nobjc_enumerationMutation(long var0);

    public static void objc_enumerationMutation(long obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        ObjCRuntime.nobjc_enumerationMutation(obj);
    }

    public static native void nobjc_setEnumerationMutationHandler(long var0);

    public static void objc_setEnumerationMutationHandler(EnumerationMutationHandler handler) {
        ObjCRuntime.nobjc_setEnumerationMutationHandler(handler.getPointer());
    }

    public static native long nimp_implementationWithBlock(long var0);

    public static long imp_implementationWithBlock(long block) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(block);
        }
        return ObjCRuntime.nimp_implementationWithBlock(block);
    }

    public static native long nimp_getBlock(long var0);

    public static long imp_getBlock(long anImp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(anImp);
        }
        return ObjCRuntime.nimp_getBlock(anImp);
    }

    public static native byte nimp_removeBlock(long var0);

    public static byte imp_removeBlock(long anImp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(anImp);
        }
        return ObjCRuntime.nimp_removeBlock(anImp);
    }

    public static native long nobjc_loadWeak(long var0);

    public static long objc_loadWeak(ByteBuffer location) {
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(location));
    }

    public static long objc_loadWeak(PointerBuffer location) {
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(location));
    }

    public static native long nobjc_storeWeak(long var0, long var2);

    public static long objc_storeWeak(ByteBuffer location, long obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(location), obj);
    }

    public static long objc_storeWeak(PointerBuffer location, long obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(obj);
        }
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(location), obj);
    }

    public static native void nobjc_setAssociatedObject(long var0, long var2, long var4, long var6);

    public static void objc_setAssociatedObject(long object, long key, long value, long policy) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(object);
            Checks.checkPointer(key);
            Checks.checkPointer(value);
        }
        ObjCRuntime.nobjc_setAssociatedObject(object, key, value, policy);
    }

    public static native long nobjc_getAssociatedObject(long var0, long var2);

    public static long objc_getAssociatedObject(long object, long key) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(object);
            Checks.checkPointer(key);
        }
        return ObjCRuntime.nobjc_getAssociatedObject(object, key);
    }

    public static native void nobjc_removeAssociatedObjects(long var0);

    public static void objc_removeAssociatedObjects(long object) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(object);
        }
        ObjCRuntime.nobjc_removeAssociatedObjects(object);
    }

    public static EnumerationMutationHandler EnumerationMutationHandler(final EnumerationMutationHandler.SAM sam) {
        return new EnumerationMutationHandler(){

            @Override
            public void invoke(long id) {
                sam.invoke(id);
            }
        };
    }

    static {
        LWJGLUtil.initialize();
    }
}

