/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XIModifierState
implements Pointer {
    public static final int SIZEOF;
    public static final int BASE;
    public static final int LATCHED;
    public static final int LOCKED;
    public static final int EFFECTIVE;
    private final ByteBuffer struct;

    public XIModifierState() {
        this(XIModifierState.malloc());
    }

    public XIModifierState(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setBase(int base) {
        XIModifierState.base(this.struct, base);
    }

    public void setLatched(int latched) {
        XIModifierState.latched(this.struct, latched);
    }

    public void setLocked(int locked) {
        XIModifierState.locked(this.struct, locked);
    }

    public void setEffective(int effective) {
        XIModifierState.effective(this.struct, effective);
    }

    public int getBase() {
        return XIModifierState.base(this.struct);
    }

    public int getLatched() {
        return XIModifierState.latched(this.struct);
    }

    public int getLocked() {
        return XIModifierState.locked(this.struct);
    }

    public int getEffective() {
        return XIModifierState.effective(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int base, int latched, int locked, int effective) {
        ByteBuffer ximodifierstate = XIModifierState.malloc();
        XIModifierState.base(ximodifierstate, base);
        XIModifierState.latched(ximodifierstate, latched);
        XIModifierState.locked(ximodifierstate, locked);
        XIModifierState.effective(ximodifierstate, effective);
        return ximodifierstate;
    }

    public static void base(ByteBuffer ximodifierstate, int base) {
        ximodifierstate.putInt(ximodifierstate.position() + BASE, base);
    }

    public static void latched(ByteBuffer ximodifierstate, int latched) {
        ximodifierstate.putInt(ximodifierstate.position() + LATCHED, latched);
    }

    public static void locked(ByteBuffer ximodifierstate, int locked) {
        ximodifierstate.putInt(ximodifierstate.position() + LOCKED, locked);
    }

    public static void effective(ByteBuffer ximodifierstate, int effective) {
        ximodifierstate.putInt(ximodifierstate.position() + EFFECTIVE, effective);
    }

    public static int base(ByteBuffer ximodifierstate) {
        return ximodifierstate.getInt(ximodifierstate.position() + BASE);
    }

    public static int latched(ByteBuffer ximodifierstate) {
        return ximodifierstate.getInt(ximodifierstate.position() + LATCHED);
    }

    public static int locked(ByteBuffer ximodifierstate) {
        return ximodifierstate.getInt(ximodifierstate.position() + LOCKED);
    }

    public static int effective(ByteBuffer ximodifierstate) {
        return ximodifierstate.getInt(ximodifierstate.position() + EFFECTIVE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = XIModifierState.offsets(MemoryUtil.memAddress(offsets));
        BASE = offsets.get(0);
        LATCHED = offsets.get(1);
        LOCKED = offsets.get(2);
        EFFECTIVE = offsets.get(3);
    }
}

