/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XIEventMask
implements Pointer {
    public static final int SIZEOF;
    public static final int DEVICEID;
    public static final int MASK;
    public static final int MASK_LEN;
    private final ByteBuffer struct;

    public XIEventMask() {
        this(XIEventMask.malloc());
    }

    public XIEventMask(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setDeviceid(int deviceid) {
        XIEventMask.deviceid(this.struct, deviceid);
    }

    public void setMask(long mask) {
        XIEventMask.mask(this.struct, mask);
    }

    public void setMask(ByteBuffer mask) {
        XIEventMask.mask(this.struct, mask);
    }

    public void setMaskLen(int mask_len) {
        XIEventMask.mask_len(this.struct, mask_len);
    }

    public int getDeviceid() {
        return XIEventMask.deviceid(this.struct);
    }

    public long getMask() {
        return XIEventMask.mask(this.struct);
    }

    public ByteBuffer getMask(int byteLen) {
        return XIEventMask.mask(this.struct, byteLen);
    }

    public int getMaskLen() {
        return XIEventMask.mask_len(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int deviceid, ByteBuffer mask, int mask_len) {
        ByteBuffer xieventmask = XIEventMask.malloc();
        XIEventMask.deviceid(xieventmask, deviceid);
        XIEventMask.mask(xieventmask, mask);
        XIEventMask.mask_len(xieventmask, mask_len);
        return xieventmask;
    }

    public static void deviceid(ByteBuffer xieventmask, int deviceid) {
        xieventmask.putInt(xieventmask.position() + DEVICEID, deviceid);
    }

    public static void mask(ByteBuffer xieventmask, long mask) {
        PointerBuffer.put(xieventmask, xieventmask.position() + MASK, mask);
    }

    public static void mask(ByteBuffer xieventmask, ByteBuffer mask) {
        XIEventMask.mask(xieventmask, MemoryUtil.memAddressSafe(mask));
    }

    public static void mask_len(ByteBuffer xieventmask, int mask_len) {
        xieventmask.putInt(xieventmask.position() + MASK_LEN, mask_len);
    }

    public static int deviceid(ByteBuffer xieventmask) {
        return xieventmask.getInt(xieventmask.position() + DEVICEID);
    }

    public static long mask(ByteBuffer xieventmask) {
        return PointerBuffer.get(xieventmask, xieventmask.position() + MASK);
    }

    public static ByteBuffer mask(ByteBuffer xieventmask, int byteLen) {
        return MemoryUtil.memByteBuffer(XIEventMask.mask(xieventmask), byteLen);
    }

    public static int mask_len(ByteBuffer xieventmask) {
        return xieventmask.getInt(xieventmask.position() + MASK_LEN);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = XIEventMask.offsets(MemoryUtil.memAddress(offsets));
        DEVICEID = offsets.get(0);
        MASK = offsets.get(1);
        MASK_LEN = offsets.get(2);
    }
}

