/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XClientMessageEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int MESSAGE_TYPE;
    public static final int FORMAT;
    public static final int DATA;
    public static final int DATA_B;
    public static final int DATA_S;
    public static final int DATA_L;
    private final ByteBuffer struct;

    public XClientMessageEvent() {
        this(XClientMessageEvent.malloc());
    }

    public XClientMessageEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XClientMessageEvent.type(this.struct, type);
    }

    public void setSerial(long serial) {
        XClientMessageEvent.serial(this.struct, serial);
    }

    public void setSendEvent(int send_event) {
        XClientMessageEvent.send_event(this.struct, send_event);
    }

    public void setDisplay(long display) {
        XClientMessageEvent.display(this.struct, display);
    }

    public void setWindow(long window) {
        XClientMessageEvent.window(this.struct, window);
    }

    public void setMessageType(long message_type) {
        XClientMessageEvent.message_type(this.struct, message_type);
    }

    public void setFormat(int format) {
        XClientMessageEvent.format(this.struct, format);
    }

    public void setDataB(ByteBuffer b) {
        XClientMessageEvent.dataBSet(this.struct, b);
    }

    public void setDataB(int index, byte b) {
        XClientMessageEvent.dataB(this.struct, index, b);
    }

    public void setDataS(ByteBuffer s) {
        XClientMessageEvent.dataSSet(this.struct, s);
    }

    public void setDataS(int index, short s) {
        XClientMessageEvent.dataS(this.struct, index, s);
    }

    public void setDataL(ByteBuffer l) {
        XClientMessageEvent.dataLSet(this.struct, l);
    }

    public void setDataL(int index, long l) {
        XClientMessageEvent.dataL(this.struct, index, l);
    }

    public int getType() {
        return XClientMessageEvent.type(this.struct);
    }

    public long getSerial() {
        return XClientMessageEvent.serial(this.struct);
    }

    public int getSendEvent() {
        return XClientMessageEvent.send_event(this.struct);
    }

    public long getDisplay() {
        return XClientMessageEvent.display(this.struct);
    }

    public long getWindow() {
        return XClientMessageEvent.window(this.struct);
    }

    public long getMessageType() {
        return XClientMessageEvent.message_type(this.struct);
    }

    public int getFormat() {
        return XClientMessageEvent.format(this.struct);
    }

    public void getDataB(ByteBuffer b) {
        XClientMessageEvent.dataBGet(this.struct, b);
    }

    public void getDataS(ByteBuffer s) {
        XClientMessageEvent.dataSGet(this.struct, s);
    }

    public void getDataL(ByteBuffer l) {
        XClientMessageEvent.dataLGet(this.struct, l);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window, long message_type, int format, ByteBuffer data_b, ByteBuffer data_s, ByteBuffer data_l) {
        ByteBuffer xclientmessageevent = XClientMessageEvent.malloc();
        XClientMessageEvent.type(xclientmessageevent, type);
        XClientMessageEvent.serial(xclientmessageevent, serial);
        XClientMessageEvent.send_event(xclientmessageevent, send_event);
        XClientMessageEvent.display(xclientmessageevent, display);
        XClientMessageEvent.window(xclientmessageevent, window);
        XClientMessageEvent.message_type(xclientmessageevent, message_type);
        XClientMessageEvent.format(xclientmessageevent, format);
        XClientMessageEvent.dataBSet(xclientmessageevent, data_b);
        XClientMessageEvent.dataSSet(xclientmessageevent, data_s);
        XClientMessageEvent.dataLSet(xclientmessageevent, data_l);
        return xclientmessageevent;
    }

    public static void type(ByteBuffer xclientmessageevent, int type) {
        xclientmessageevent.putInt(xclientmessageevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xclientmessageevent, long serial) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xclientmessageevent, int send_event) {
        xclientmessageevent.putInt(xclientmessageevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xclientmessageevent, long display) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + DISPLAY, display);
    }

    public static void window(ByteBuffer xclientmessageevent, long window) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + WINDOW, window);
    }

    public static void message_type(ByteBuffer xclientmessageevent, long message_type) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + MESSAGE_TYPE, message_type);
    }

    public static void format(ByteBuffer xclientmessageevent, int format) {
        xclientmessageevent.putInt(xclientmessageevent.position() + FORMAT, format);
    }

    public static void dataBSet(ByteBuffer xclientmessageevent, ByteBuffer b) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(b, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(b), MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_B, b.remaining());
    }

    public static void dataB(ByteBuffer xclientmessageevent, int index, byte b) {
        xclientmessageevent.put(DATA_B + index, b);
    }

    public static void dataSSet(ByteBuffer xclientmessageevent, ByteBuffer s) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(s, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(s), MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_S, s.remaining());
    }

    public static void dataS(ByteBuffer xclientmessageevent, int index, short s) {
        xclientmessageevent.putShort(DATA_S + index * 2, s);
    }

    public static void dataLSet(ByteBuffer xclientmessageevent, ByteBuffer l) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(l, 5 * POINTER_SIZE);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(l), MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_L, l.remaining());
    }

    public static void dataL(ByteBuffer xclientmessageevent, int index, long l) {
        PointerBuffer.put(xclientmessageevent, DATA_L + index * POINTER_SIZE, l);
    }

    public static int type(ByteBuffer xclientmessageevent) {
        return xclientmessageevent.getInt(xclientmessageevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xclientmessageevent) {
        return xclientmessageevent.getInt(xclientmessageevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + DISPLAY);
    }

    public static long window(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + WINDOW);
    }

    public static long message_type(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + MESSAGE_TYPE);
    }

    public static int format(ByteBuffer xclientmessageevent) {
        return xclientmessageevent.getInt(xclientmessageevent.position() + FORMAT);
    }

    public static void dataBGet(ByteBuffer xclientmessageevent, ByteBuffer b) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(b, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_B, MemoryUtil.memAddress(b), b.remaining());
    }

    public static byte dataB(ByteBuffer xclientmessageevent, int index) {
        return xclientmessageevent.get(DATA_B + index * 1);
    }

    public static void dataSGet(ByteBuffer xclientmessageevent, ByteBuffer s) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(s, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_S, MemoryUtil.memAddress(s), s.remaining());
    }

    public static short dataS(ByteBuffer xclientmessageevent, int index) {
        return xclientmessageevent.getShort(DATA_S + index * 2);
    }

    public static void dataLGet(ByteBuffer xclientmessageevent, ByteBuffer l) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(l, 40);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_L, MemoryUtil.memAddress(l), l.remaining());
    }

    public static long dataL(ByteBuffer xclientmessageevent, int index) {
        return xclientmessageevent.getLong(DATA_L + index * 8);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(11);
        SIZEOF = XClientMessageEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        WINDOW = offsets.get(4);
        MESSAGE_TYPE = offsets.get(5);
        FORMAT = offsets.get(6);
        DATA = offsets.get(7);
        DATA_B = offsets.get(8);
        DATA_S = offsets.get(9);
        DATA_L = offsets.get(10);
    }
}

