/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XAnyEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    private final ByteBuffer struct;

    public XAnyEvent() {
        this(XAnyEvent.malloc());
    }

    public XAnyEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XAnyEvent.type(this.struct, type);
    }

    public void setSerial(long serial) {
        XAnyEvent.serial(this.struct, serial);
    }

    public void setSendEvent(int send_event) {
        XAnyEvent.send_event(this.struct, send_event);
    }

    public void setDisplay(long display) {
        XAnyEvent.display(this.struct, display);
    }

    public void setWindow(long window) {
        XAnyEvent.window(this.struct, window);
    }

    public int getType() {
        return XAnyEvent.type(this.struct);
    }

    public long getSerial() {
        return XAnyEvent.serial(this.struct);
    }

    public int getSendEvent() {
        return XAnyEvent.send_event(this.struct);
    }

    public long getDisplay() {
        return XAnyEvent.display(this.struct);
    }

    public long getWindow() {
        return XAnyEvent.window(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window) {
        ByteBuffer xanyevent = XAnyEvent.malloc();
        XAnyEvent.type(xanyevent, type);
        XAnyEvent.serial(xanyevent, serial);
        XAnyEvent.send_event(xanyevent, send_event);
        XAnyEvent.display(xanyevent, display);
        XAnyEvent.window(xanyevent, window);
        return xanyevent;
    }

    public static void type(ByteBuffer xanyevent, int type) {
        xanyevent.putInt(xanyevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xanyevent, long serial) {
        PointerBuffer.put(xanyevent, xanyevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xanyevent, int send_event) {
        xanyevent.putInt(xanyevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xanyevent, long display) {
        PointerBuffer.put(xanyevent, xanyevent.position() + DISPLAY, display);
    }

    public static void window(ByteBuffer xanyevent, long window) {
        PointerBuffer.put(xanyevent, xanyevent.position() + WINDOW, window);
    }

    public static int type(ByteBuffer xanyevent) {
        return xanyevent.getInt(xanyevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xanyevent) {
        return PointerBuffer.get(xanyevent, xanyevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xanyevent) {
        return xanyevent.getInt(xanyevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xanyevent) {
        return PointerBuffer.get(xanyevent, xanyevent.position() + DISPLAY);
    }

    public static long window(ByteBuffer xanyevent) {
        return PointerBuffer.get(xanyevent, xanyevent.position() + WINDOW);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = XAnyEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        WINDOW = offsets.get(4);
    }
}

