/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.FFICIF;

public final class FFIClosure
implements Pointer {
    public static final int SIZEOF;
    public static final int CIF;
    public static final int FUN;
    public static final int USER_DATA;
    private final ByteBuffer struct;

    public FFIClosure(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setCif(long cif) {
        FFIClosure.cif(this.struct, cif);
    }

    public void setCif(ByteBuffer cif) {
        FFIClosure.cif(this.struct, cif);
    }

    public void setFun(long fun) {
        FFIClosure.fun(this.struct, fun);
    }

    public void setUserData(long user_data) {
        FFIClosure.user_data(this.struct, user_data);
    }

    public long getCif() {
        return FFIClosure.cif(this.struct);
    }

    public ByteBuffer getCifBuffer() {
        return FFIClosure.cifBuffer(this.struct);
    }

    public long getFun() {
        return FFIClosure.fun(this.struct);
    }

    public long getUserData() {
        return FFIClosure.user_data(this.struct);
    }

    private static native int offsets(long var0);

    public static void cif(ByteBuffer ffi_closure, long cif) {
        PointerBuffer.put(ffi_closure, ffi_closure.position() + CIF, cif);
    }

    public static void cif(ByteBuffer ffi_closure, ByteBuffer cif) {
        FFIClosure.cif(ffi_closure, MemoryUtil.memAddressSafe(cif));
    }

    public static void fun(ByteBuffer ffi_closure, long fun) {
        PointerBuffer.put(ffi_closure, ffi_closure.position() + FUN, fun);
    }

    public static void user_data(ByteBuffer ffi_closure, long user_data) {
        PointerBuffer.put(ffi_closure, ffi_closure.position() + USER_DATA, user_data);
    }

    public static long cif(ByteBuffer ffi_closure) {
        return PointerBuffer.get(ffi_closure, ffi_closure.position() + CIF);
    }

    public static ByteBuffer cifBuffer(ByteBuffer ffi_closure) {
        return MemoryUtil.memByteBuffer(FFIClosure.cif(ffi_closure), FFICIF.SIZEOF);
    }

    public static long fun(ByteBuffer ffi_closure) {
        return PointerBuffer.get(ffi_closure, ffi_closure.position() + FUN);
    }

    public static long user_data(ByteBuffer ffi_closure) {
        return PointerBuffer.get(ffi_closure, ffi_closure.position() + USER_DATA);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = FFIClosure.offsets(MemoryUtil.memAddress(offsets));
        CIF = offsets.get(0);
        FUN = offsets.get(1);
        USER_DATA = offsets.get(2);
    }
}

