/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryAccess;

public final class MemoryUtil {
    public static final long NULL = 0L;
    private static final MemoryAccess.MemoryAccessor ACCESSOR;
    public static final int PAGE_SIZE;

    private MemoryUtil() {
    }

    public static long memAddress0(Buffer buffer) {
        return ACCESSOR.getAddress(buffer);
    }

    public static long memAddress0Safe(Buffer buffer) {
        return buffer == null ? 0L : ACCESSOR.getAddress(buffer);
    }

    public static long memAddress0(PointerBuffer buffer) {
        return ACCESSOR.getAddress(buffer.getBuffer());
    }

    public static long memAddress0Safe(PointerBuffer buffer) {
        return buffer == null ? 0L : ACCESSOR.getAddress(buffer.getBuffer());
    }

    public static long memAddress(ByteBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ByteBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)position;
    }

    public static long memAddress(ShortBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ShortBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 1);
    }

    public static long memAddress(CharBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(CharBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 1);
    }

    public static long memAddress(IntBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(IntBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 2);
    }

    public static long memAddress(FloatBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(FloatBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 2);
    }

    public static long memAddress(LongBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(LongBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 3);
    }

    public static long memAddress(DoubleBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(DoubleBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 3);
    }

    public static long memAddress(PointerBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(PointerBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position * Pointer.POINTER_SIZE);
    }

    public static long memAddressSafe(ByteBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(ByteBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(ShortBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(ShortBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(CharBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(CharBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(IntBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(IntBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(FloatBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(FloatBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(LongBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(LongBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(DoubleBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(DoubleBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(PointerBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(PointerBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static ByteBuffer memByteBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newByteBuffer(address, capacity);
    }

    public static ByteBuffer memByteBufferNT1(long address) {
        return MemoryUtil.memByteBufferNT1(address, Integer.MAX_VALUE);
    }

    public static ByteBuffer memByteBufferNT1(long address, int maxLength) {
        if (address == 0L) {
            return null;
        }
        ByteBuffer string = ACCESSOR.newByteBuffer(address, maxLength);
        return MemoryUtil.memSetupBuffer(string, address, MemoryUtil.memStrLen1(string, 0));
    }

    public static ByteBuffer memByteBufferNT2(long address) {
        return MemoryUtil.memByteBufferNT2(address, Integer.MAX_VALUE);
    }

    public static ByteBuffer memByteBufferNT2(long address, int maxLength) {
        if (address == 0L) {
            return null;
        }
        ByteBuffer string = ACCESSOR.newByteBuffer(address, maxLength);
        return MemoryUtil.memSetupBuffer(string, address, MemoryUtil.memStrLen2(string, 0));
    }

    public static ShortBuffer memShortBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newShortBuffer(address, capacity);
    }

    public static CharBuffer memCharBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newCharBuffer(address, capacity);
    }

    public static IntBuffer memIntBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newIntBuffer(address, capacity);
    }

    public static LongBuffer memLongBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newLongBuffer(address, capacity);
    }

    public static FloatBuffer memFloatBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newFloatBuffer(address, capacity);
    }

    public static DoubleBuffer memDoubleBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.newDoubleBuffer(address, capacity);
    }

    public static PointerBuffer memPointerBuffer(long address, int capacity) {
        return new PointerBuffer(address, capacity);
    }

    public static ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static void memSet(long ptr, int value, int bytes) {
        if (LWJGLUtil.DEBUG && (ptr == 0L || bytes < 0)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memSet(ptr, value, bytes);
    }

    public static void memCopy(long src, long dst, int bytes) {
        if (LWJGLUtil.DEBUG && (src == 0L || dst == 0L || bytes < 0)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memCopy(src, dst, bytes);
    }

    public static byte memGetByte(long ptr) {
        return ACCESSOR.memGetByte(ptr);
    }

    public static short memGetShort(long ptr) {
        return ACCESSOR.memGetShort(ptr);
    }

    public static int memGetInt(long ptr) {
        return ACCESSOR.memGetInt(ptr);
    }

    public static long memGetLong(long ptr) {
        return ACCESSOR.memGetLong(ptr);
    }

    public static float memGetFloat(long ptr) {
        return ACCESSOR.memGetFloat(ptr);
    }

    public static double memGetDouble(long ptr) {
        return ACCESSOR.memGetDouble(ptr);
    }

    public static long memGetAddress(long ptr) {
        return ACCESSOR.memGetAddress(ptr);
    }

    public static void memPutByte(long ptr, byte value) {
        ACCESSOR.memPutByte(ptr, value);
    }

    public static void memPutShort(long ptr, short value) {
        ACCESSOR.memPutShort(ptr, value);
    }

    public static void memPutInt(long ptr, int value) {
        ACCESSOR.memPutInt(ptr, value);
    }

    public static void memPutLong(long ptr, long value) {
        ACCESSOR.memPutLong(ptr, value);
    }

    public static void memPutFloat(long ptr, float value) {
        ACCESSOR.memPutFloat(ptr, value);
    }

    public static void memPutDouble(long ptr, double value) {
        ACCESSOR.memPutDouble(ptr, value);
    }

    public static void memPutAddress(long ptr, long value) {
        ACCESSOR.memPutAddress(ptr, value);
    }

    public static native int memPointerSize();

    public static native <T> T memGlobalRefToObject(long var0);

    public static native long memNewGlobalRef(Object var0);

    public static native void memDeleteGlobalRef(long var0);

    public static native long memNewWeakGlobalRef(Object var0);

    public static native void memDeleteWeakGlobalRef(long var0);

    static native void nMemSet(long var0, int var2, long var3);

    static native void nMemCopy(long var0, long var2, long var4);

    static native byte nMemGetByte(long var0);

    static native short nMemGetShort(long var0);

    static native int nMemGetInt(long var0);

    static native long nMemGetLong(long var0);

    static native float nMemGetFloat(long var0);

    static native double nMemGetDouble(long var0);

    static native long nMemGetAddress(long var0);

    static native void nMemPutByte(long var0, byte var2);

    static native void nMemPutShort(long var0, short var2);

    static native void nMemPutInt(long var0, int var2);

    static native void nMemPutLong(long var0, long var2);

    static native void nMemPutFloat(long var0, float var2);

    static native void nMemPutDouble(long var0, double var2);

    static native void nMemPutAddress(long var0, long var2);

    static native long nGetAddress(Buffer var0);

    static native ByteBuffer nNewBuffer(long var0, int var2);

    public static ByteBuffer memEncodeASCII(CharSequence text) {
        return MemoryUtil.memEncodeASCII(text, true);
    }

    public static ByteBuffer memEncodeASCII(CharSequence text, boolean nullTerminated) {
        if (text == null) {
            return null;
        }
        ByteBuffer target = BufferUtils.createByteBuffer(text.length() + (nullTerminated ? 1 : 0));
        MemoryUtil.memEncodeASCII(text, nullTerminated, target);
        return target;
    }

    public static int memEncodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memEncodeASCII(text, nullTerminated, target, target.position());
    }

    public static int memEncodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int p = offset;
        int i = 0;
        while (i < text.length()) {
            target.put(p, (byte)text.charAt(i));
            ++i;
            ++p;
        }
        if (nullTerminated) {
            target.put(p++, (byte)0);
        }
        return p - offset;
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text) {
        return MemoryUtil.memEncodeUTF8(text, true);
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text, boolean nullTerminated) {
        if (text == null) {
            return null;
        }
        ByteBuffer target = BufferUtils.createByteBuffer(MemoryUtil.memEncodedLengthUTF8(text) + (nullTerminated ? 1 : 0));
        MemoryUtil.memEncodeUTF8(text, nullTerminated, target);
        return target;
    }

    public static int memEncodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memEncodeUTF8(text, nullTerminated, target, target.position());
    }

    public static int memEncodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int c;
        int i;
        int p = offset;
        for (i = 0; i < text.length() && 128 > (c = text.charAt(i)); ++i) {
            target.put(p++, (byte)c);
        }
        while (i < text.length()) {
            if ((c = text.charAt(i++)) < 128) {
                target.put(p++, (byte)c);
                continue;
            }
            int cp = c;
            if (c < 2048) {
                target.put(p++, (byte)(0xC0 | cp >> 6));
            } else {
                if (!Character.isHighSurrogate((char)c)) {
                    target.put(p++, (byte)(0xE0 | cp >> 12));
                } else {
                    cp = Character.toCodePoint((char)c, text.charAt(i++));
                    target.put(p++, (byte)(0xF0 | cp >> 18));
                    target.put(p++, (byte)(0x80 | cp >> 12 & 0x3F));
                }
                target.put(p++, (byte)(0x80 | cp >> 6 & 0x3F));
            }
            target.put(p++, (byte)(0x80 | cp & 0x3F));
        }
        if (nullTerminated) {
            target.put(p++, (byte)0);
        }
        return p - offset;
    }

    public static int memEncodedLengthUTF8(CharSequence value) {
        int i = 0;
        int len = value.length();
        int bytes = 0;
        while (i < len) {
            char c;
            if ((c = value.charAt(i++)) < '\u0080') {
                ++bytes;
                continue;
            }
            if (c < '\u0800') {
                bytes += 2;
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                bytes += 3;
                continue;
            }
            if (!(!LWJGLUtil.DEBUG || len > i && Character.isHighSurrogate(c) && Character.isLowSurrogate(value.charAt(i)))) {
                throw new RuntimeException("Malformed character sequence");
            }
            bytes += 4;
            ++i;
        }
        return bytes;
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text) {
        return MemoryUtil.memEncodeUTF16(text, true);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text, boolean nullTerminated) {
        if (text == null) {
            return null;
        }
        ByteBuffer target = BufferUtils.createByteBuffer(text.length() + (nullTerminated ? 1 : 0) << 1);
        MemoryUtil.memEncodeUTF16(text, nullTerminated, target);
        return target;
    }

    public static int memEncodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memEncodeUTF16(text, nullTerminated, target, target.position());
    }

    public static int memEncodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int p = offset;
        int i = 0;
        while (i < text.length()) {
            target.putChar(p, text.charAt(i));
            ++i;
            p += 2;
        }
        if (nullTerminated) {
            target.putChar(p, '\u0000');
            p += 2;
        }
        return p - offset;
    }

    public static int memStrLen1(ByteBuffer buffer) {
        return MemoryUtil.memStrLen1(buffer, buffer.position());
    }

    public static int memStrLen1(ByteBuffer buffer, int from) {
        int to;
        for (to = from; to < buffer.limit() && buffer.get(to) != 0; ++to) {
        }
        return to - from;
    }

    public static int memStrLen2(ByteBuffer buffer) {
        return MemoryUtil.memStrLen2(buffer, buffer.position());
    }

    public static int memStrLen2(ByteBuffer buffer, int from) {
        int to;
        for (to = from; to < buffer.limit() && (buffer.get(to) != 0 || to >= buffer.limit() - 1 || buffer.get(to + 1) != 0); to += 2) {
        }
        return to - from;
    }

    public static String memDecodeASCII(long address) {
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBufferNT1(address));
    }

    public static String memDecodeASCII(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecodeASCII(buffer, buffer.remaining());
    }

    public static String memDecodeASCII(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeASCII(buffer, length, buffer.position());
    }

    public static String memDecodeASCII(ByteBuffer buffer, int length, int offset) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)buffer.get(offset + i);
        }
        return new String(chars);
    }

    public static String memDecodeUTF8(long address) {
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(address));
    }

    public static String memDecodeUTF8(ByteBuffer buffer) {
        return MemoryUtil.memDecodeUTF8(buffer, buffer.remaining());
    }

    public static String memDecodeUTF8(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeUTF8(buffer, length, buffer.position());
    }

    public static String memDecodeUTF8(ByteBuffer buffer, int length, int offset) {
        byte c;
        int position;
        char[] string = new char[length];
        int i = 0;
        int limit = offset + length;
        for (position = offset; position < limit && (c = buffer.get(position)) >= 0; ++position) {
            string[i++] = (char)c;
        }
        while (position < limit) {
            byte b2;
            byte b1;
            byte b0;
            if (0 <= (b0 = buffer.get(position++))) {
                string[i++] = (char)b0;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                b1 = buffer.get(position++);
                if (LWJGLUtil.DEBUG && (b1 & 0xC0) != 128) {
                    throw new RuntimeException("Malformed character sequence");
                }
                string[i++] = (char)(b0 << 6 ^ b1 ^ 0xF80);
                continue;
            }
            if (b0 >> 4 == -2) {
                b1 = buffer.get(position++);
                b2 = buffer.get(position++);
                if (LWJGLUtil.DEBUG && MemoryUtil.isMalformed3(b0, b1, b2)) {
                    throw new RuntimeException("Malformed character sequence");
                }
                char c2 = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                if (LWJGLUtil.DEBUG && '\ud800' <= c2 && c2 <= '\udfff') {
                    throw new RuntimeException("Malformed character sequence");
                }
                string[i++] = c2;
                continue;
            }
            if (b0 >> 3 == -2) {
                b1 = buffer.get(position++);
                b2 = buffer.get(position++);
                byte b3 = buffer.get(position++);
                int cp = b0 << 18 ^ b1 << 12 ^ b2 << 6 ^ (b3 ^ 0x381F80);
                if (LWJGLUtil.DEBUG && (MemoryUtil.isMalformed4(b1, b2, b3) || !Character.isSupplementaryCodePoint(cp))) {
                    throw new RuntimeException("Malformed character sequence");
                }
                string[i++] = (char)((cp >>> 10) + 55296 - 64);
                string[i++] = (char)((cp & 0x3FF) + 56320);
                continue;
            }
            if (!LWJGLUtil.DEBUG) continue;
            throw new RuntimeException("Malformed character sequence");
        }
        return new String(string, 0, i);
    }

    private static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }

    public static String memDecodeUTF16(long address) {
        return MemoryUtil.memDecodeUTF16(MemoryUtil.memByteBufferNT2(address));
    }

    public static String memDecodeUTF16(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecodeUTF16(buffer, buffer.remaining());
    }

    public static String memDecodeUTF16(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeUTF16(buffer, length, buffer.position());
    }

    public static String memDecodeUTF16(ByteBuffer buffer, int length, int offset) {
        char[] chars = new char[length >> 1];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = buffer.getChar(offset + (i << 1));
        }
        return new String(chars);
    }

    static {
        LWJGLUtil.initialize();
        ACCESSOR = MemoryAccess.getInstance();
        PAGE_SIZE = ACCESSOR.getPageSize();
        LWJGLUtil.log("MemoryUtil MemoryAccessor: " + ACCESSOR.getClass().getSimpleName());
    }
}

