/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.MemoryAccess;
import sun.misc.Unsafe;

final class MemoryAccessSun {
    private MemoryAccessSun() {
    }

    private static final class MemoryAccessorUnsafe
    extends MemoryAccess.MemoryAccessorJava {
        private static final long BULK_OP_THRESHOLD = 0x100000L;
        private final Unsafe unsafe;
        private final long address;
        private final long capacity;
        private final long cleaner;
        private final long byteBufferParent;
        private final long shortBufferParent;
        private final long charBufferParent;
        private final long intBufferParent;
        private final long longBufferParent;
        private final long floatBufferParent;
        private final long doubleBufferParent;

        MemoryAccessorUnsafe() {
            try {
                this.unsafe = MemoryAccessorUnsafe.getUnsafeInstance();
                this.address = this.unsafe.objectFieldOffset(MemoryAccess.getDeclaredField(Buffer.class, "address"));
                this.capacity = this.unsafe.objectFieldOffset(MemoryAccess.getDeclaredField(Buffer.class, "capacity"));
                ByteBuffer buffer = this.globalBuffer;
                this.cleaner = this.unsafe.objectFieldOffset(MemoryAccess.getDeclaredField(buffer.getClass(), "cleaner"));
                this.byteBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.slice(), buffer));
                this.shortBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.asShortBuffer(), buffer));
                this.charBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.asCharBuffer(), buffer));
                this.intBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.asIntBuffer(), buffer));
                this.longBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.asLongBuffer(), buffer));
                this.floatBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.asFloatBuffer(), buffer));
                this.doubleBufferParent = this.unsafe.objectFieldOffset(MemoryAccess.getField(buffer.asDoubleBuffer(), buffer));
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        int getPageSize() {
            return this.unsafe.pageSize();
        }

        @Override
        public long getAddress(Buffer buffer) {
            return this.unsafe.getLong(buffer, this.address);
        }

        @Override
        ByteBuffer newByteBuffer(long address, int capacity) {
            ByteBuffer buffer = this.newByteBuffer();
            this.unsafe.putLong(buffer, this.address, address);
            this.unsafe.putInt(buffer, this.capacity, capacity);
            buffer.clear();
            return buffer;
        }

        private <T extends Buffer> T setup(T buffer, long address, int capacity, long parentField) {
            this.unsafe.putLong(buffer, this.address, address);
            this.unsafe.putInt(buffer, this.capacity, capacity);
            this.unsafe.putObject(buffer, parentField, null);
            buffer.clear();
            return buffer;
        }

        @Override
        public ByteBuffer setupBuffer(ByteBuffer buffer, long address, int capacity) {
            if (LWJGLUtil.DEBUG && this.unsafe.getObject(buffer, this.cleaner) != null) {
                throw new IllegalArgumentException("Instances created through ByteBuffer.allocateDirect cannot be modified.");
            }
            return this.setup(buffer, address, capacity, this.byteBufferParent);
        }

        @Override
        ShortBuffer setupBuffer(ShortBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.shortBufferParent);
        }

        @Override
        CharBuffer setupBuffer(CharBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.charBufferParent);
        }

        @Override
        IntBuffer setupBuffer(IntBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.intBufferParent);
        }

        @Override
        LongBuffer setupBuffer(LongBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.longBufferParent);
        }

        @Override
        FloatBuffer setupBuffer(FloatBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.floatBufferParent);
        }

        @Override
        DoubleBuffer setupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.doubleBufferParent);
        }

        @Override
        void memSet(long dst, int value, int bytes) {
            while (true) {
                long batchSize = 0x100000L < (long)bytes ? 0x100000L : (long)bytes;
                this.unsafe.setMemory(dst, batchSize, (byte)(value & 0xFF));
                bytes = (int)((long)bytes - 0x100000L);
                if (bytes < 0) break;
                dst += 0x100000L;
            }
        }

        @Override
        void memCopy(long src, long dst, int bytes) {
            while (true) {
                long batchSize = 0x100000L < (long)bytes ? 0x100000L : (long)bytes;
                this.unsafe.copyMemory(src, dst, batchSize);
                bytes = (int)((long)bytes - 0x100000L);
                if (bytes < 0) break;
                src += 0x100000L;
                dst += 0x100000L;
            }
        }

        @Override
        byte memGetByte(long ptr) {
            return this.unsafe.getByte(ptr);
        }

        @Override
        short memGetShort(long ptr) {
            return this.unsafe.getShort(ptr);
        }

        @Override
        int memGetInt(long ptr) {
            return this.unsafe.getInt(ptr);
        }

        @Override
        long memGetLong(long ptr) {
            return this.unsafe.getLong(ptr);
        }

        @Override
        float memGetFloat(long ptr) {
            return this.unsafe.getFloat(ptr);
        }

        @Override
        double memGetDouble(long ptr) {
            return this.unsafe.getDouble(ptr);
        }

        @Override
        long memGetAddress(long ptr) {
            return this.unsafe.getAddress(ptr);
        }

        @Override
        void memPutByte(long ptr, byte value) {
            this.unsafe.putByte(ptr, value);
        }

        @Override
        void memPutShort(long ptr, short value) {
            this.unsafe.putShort(ptr, value);
        }

        @Override
        void memPutInt(long ptr, int value) {
            this.unsafe.putInt(ptr, value);
        }

        @Override
        void memPutLong(long ptr, long value) {
            this.unsafe.putLong(ptr, value);
        }

        @Override
        void memPutFloat(long ptr, float value) {
            this.unsafe.putFloat(ptr, value);
        }

        @Override
        void memPutDouble(long ptr, double value) {
            this.unsafe.putDouble(ptr, value);
        }

        @Override
        void memPutAddress(long ptr, long value) {
            this.unsafe.putAddress(ptr, value);
        }

        private static Unsafe getUnsafeInstance() {
            Field[] fields;
            for (Field field : fields = Unsafe.class.getDeclaredFields()) {
                int modifiers;
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException e) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

