/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class WGLNVDXInterop {
    public static final int WGL_ACCESS_READ_ONLY_NV = 0;
    public static final int WGL_ACCESS_READ_WRITE_NV = 1;
    public static final int WGL_ACCESS_WRITE_DISCARD_NV = 2;
    public final long DXSetResourceShareHandleNV;
    public final long DXOpenDeviceNV;
    public final long DXCloseDeviceNV;
    public final long DXRegisterObjectNV;
    public final long DXUnregisterObjectNV;
    public final long DXObjectAccessNV;
    public final long DXLockObjectsNV;
    public final long DXUnlockObjectsNV;

    public WGLNVDXInterop(FunctionProvider provider) {
        this.DXSetResourceShareHandleNV = provider.getFunctionAddress("wglDXSetResourceShareHandleNV");
        this.DXOpenDeviceNV = provider.getFunctionAddress("wglDXOpenDeviceNV");
        this.DXCloseDeviceNV = provider.getFunctionAddress("wglDXCloseDeviceNV");
        this.DXRegisterObjectNV = provider.getFunctionAddress("wglDXRegisterObjectNV");
        this.DXUnregisterObjectNV = provider.getFunctionAddress("wglDXUnregisterObjectNV");
        this.DXObjectAccessNV = provider.getFunctionAddress("wglDXObjectAccessNV");
        this.DXLockObjectsNV = provider.getFunctionAddress("wglDXLockObjectsNV");
        this.DXUnlockObjectsNV = provider.getFunctionAddress("wglDXUnlockObjectsNV");
    }

    public static WGLNVDXInterop getInstance() {
        return GL.getCapabilities().__WGLNVDXInterop;
    }

    static WGLNVDXInterop create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_NV_DX_interop")) {
            return null;
        }
        WGLNVDXInterop funcs = new WGLNVDXInterop(provider);
        boolean supported = Checks.checkFunctions(funcs.DXSetResourceShareHandleNV, funcs.DXOpenDeviceNV, funcs.DXCloseDeviceNV, funcs.DXRegisterObjectNV, funcs.DXUnregisterObjectNV, funcs.DXObjectAccessNV, funcs.DXLockObjectsNV, funcs.DXUnlockObjectsNV);
        return GL.checkExtension("WGL_NV_DX_interop", funcs, supported);
    }

    public static native int nwglDXSetResourceShareHandleNV(long var0, long var2, long var4);

    public static int wglDXSetResourceShareHandleNV(long dxObject, long shareHandle) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXSetResourceShareHandleNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dxObject);
            Checks.checkPointer(shareHandle);
        }
        return WGLNVDXInterop.nwglDXSetResourceShareHandleNV(dxObject, shareHandle, __functionAddress);
    }

    public static native long nwglDXOpenDeviceNV(long var0, long var2);

    public static long wglDXOpenDeviceNV(long dxDevice) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXOpenDeviceNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dxDevice);
        }
        return WGLNVDXInterop.nwglDXOpenDeviceNV(dxDevice, __functionAddress);
    }

    public static native int nwglDXCloseDeviceNV(long var0, long var2);

    public static int wglDXCloseDeviceNV(long device) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXCloseDeviceNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return WGLNVDXInterop.nwglDXCloseDeviceNV(device, __functionAddress);
    }

    public static native long nwglDXRegisterObjectNV(long var0, long var2, int var4, int var5, int var6, long var7);

    public static long wglDXRegisterObjectNV(long device, long dxResource, int name, int type, int access) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXRegisterObjectNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
            Checks.checkPointer(dxResource);
        }
        return WGLNVDXInterop.nwglDXRegisterObjectNV(device, dxResource, name, type, access, __functionAddress);
    }

    public static native int nwglDXUnregisterObjectNV(long var0, long var2, long var4);

    public static int wglDXUnregisterObjectNV(long device, long object) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXUnregisterObjectNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
            Checks.checkPointer(object);
        }
        return WGLNVDXInterop.nwglDXUnregisterObjectNV(device, object, __functionAddress);
    }

    public static native int nwglDXObjectAccessNV(long var0, int var2, long var3);

    public static int wglDXObjectAccessNV(long object, int access) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXObjectAccessNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(object);
        }
        return WGLNVDXInterop.nwglDXObjectAccessNV(object, access, __functionAddress);
    }

    public static native int nwglDXLockObjectsNV(long var0, int var2, long var3, long var5);

    public static int nwglDXLockObjectsNV(long device, int count, long objects) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXLockObjectsNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, count, objects, __functionAddress);
    }

    public static int wglDXLockObjectsNV(long device, int count, ByteBuffer objects) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)objects, count << Pointer.POINTER_SHIFT);
        }
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, count, MemoryUtil.memAddress(objects));
    }

    public static int wglDXLockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress(objects));
    }

    public static native int nwglDXUnlockObjectsNV(long var0, int var2, long var3, long var5);

    public static int nwglDXUnlockObjectsNV(long device, int count, long objects) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXUnlockObjectsNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, count, objects, __functionAddress);
    }

    public static int wglDXUnlockObjectsNV(long device, int count, ByteBuffer objects) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)objects, count << Pointer.POINTER_SHIFT);
        }
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, count, MemoryUtil.memAddress(objects));
    }

    public static int wglDXUnlockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress(objects));
    }
}

