/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public final class WGLARBBufferRegion {
    public static final int WGL_FRONT_COLOR_BUFFER_BIT_ARB = 1;
    public static final int WGL_BACK_COLOR_BUFFER_BIT_ARB = 2;
    public static final int WGL_DEPTH_BUFFER_BIT_ARB = 4;
    public static final int WGL_STENCIL_BUFFER_BIT_ARB = 8;
    public final long CreateBufferRegionARB;
    public final long DeleteBufferRegionARB;
    public final long SaveBufferRegionARB;
    public final long RestoreBufferRegionARB;

    public WGLARBBufferRegion(FunctionProvider provider) {
        this.CreateBufferRegionARB = provider.getFunctionAddress("wglCreateBufferRegionARB");
        this.DeleteBufferRegionARB = provider.getFunctionAddress("wglDeleteBufferRegionARB");
        this.SaveBufferRegionARB = provider.getFunctionAddress("wglSaveBufferRegionARB");
        this.RestoreBufferRegionARB = provider.getFunctionAddress("wglRestoreBufferRegionARB");
    }

    public static WGLARBBufferRegion getInstance() {
        return GL.getCapabilities().__WGLARBBufferRegion;
    }

    static WGLARBBufferRegion create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_buffer_region")) {
            return null;
        }
        WGLARBBufferRegion funcs = new WGLARBBufferRegion(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateBufferRegionARB, funcs.DeleteBufferRegionARB, funcs.SaveBufferRegionARB, funcs.RestoreBufferRegionARB);
        return GL.checkExtension("WGL_ARB_buffer_region", funcs, supported);
    }

    public static native long nwglCreateBufferRegionARB(long var0, int var2, int var3, long var4);

    public static long wglCreateBufferRegionARB(long hdc, int layerPlane, int type) {
        long __functionAddress = WGLARBBufferRegion.getInstance().CreateBufferRegionARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLARBBufferRegion.nwglCreateBufferRegionARB(hdc, layerPlane, type, __functionAddress);
    }

    public static native void nwglDeleteBufferRegionARB(long var0, long var2);

    public static void wglDeleteBufferRegionARB(long region) {
        long __functionAddress = WGLARBBufferRegion.getInstance().DeleteBufferRegionARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(region);
        }
        WGLARBBufferRegion.nwglDeleteBufferRegionARB(region, __functionAddress);
    }

    public static native int nwglSaveBufferRegionARB(long var0, int var2, int var3, int var4, int var5, long var6);

    public static int wglSaveBufferRegionARB(long region, int x, int y, int width, int height) {
        long __functionAddress = WGLARBBufferRegion.getInstance().SaveBufferRegionARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(region);
        }
        return WGLARBBufferRegion.nwglSaveBufferRegionARB(region, x, y, width, height, __functionAddress);
    }

    public static native int nwglRestoreBufferRegionARB(long var0, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static int wglRestoreBufferRegionARB(long region, int x, int y, int width, int height, int xSrc, int ySrc) {
        long __functionAddress = WGLARBBufferRegion.getInstance().RestoreBufferRegionARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(region);
        }
        return WGLARBBufferRegion.nwglRestoreBufferRegionARB(region, x, y, width, height, xSrc, ySrc, __functionAddress);
    }
}

