/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class NVShaderBufferLoad {
    public static final int GL_BUFFER_GPU_ADDRESS_NV = 36637;
    public static final int GL_GPU_ADDRESS_NV = 36660;
    public static final int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 36661;
    public final long MakeBufferResidentNV;
    public final long MakeBufferNonResidentNV;
    public final long IsBufferResidentNV;
    public final long MakeNamedBufferResidentNV;
    public final long MakeNamedBufferNonResidentNV;
    public final long IsNamedBufferResidentNV;
    public final long GetBufferParameterui64vNV;
    public final long GetNamedBufferParameterui64vNV;
    public final long GetIntegerui64vNV;
    public final long Uniformui64NV;
    public final long Uniformui64vNV;
    public final long GetUniformui64vNV;
    public final long ProgramUniformui64NV;
    public final long ProgramUniformui64vNV;

    public NVShaderBufferLoad(FunctionProvider provider) {
        this.MakeBufferResidentNV = provider.getFunctionAddress("glMakeBufferResidentNV");
        this.MakeBufferNonResidentNV = provider.getFunctionAddress("glMakeBufferNonResidentNV");
        this.IsBufferResidentNV = provider.getFunctionAddress("glIsBufferResidentNV");
        this.MakeNamedBufferResidentNV = provider.getFunctionAddress("glMakeNamedBufferResidentNV");
        this.MakeNamedBufferNonResidentNV = provider.getFunctionAddress("glMakeNamedBufferNonResidentNV");
        this.IsNamedBufferResidentNV = provider.getFunctionAddress("glIsNamedBufferResidentNV");
        this.GetBufferParameterui64vNV = provider.getFunctionAddress("glGetBufferParameterui64vNV");
        this.GetNamedBufferParameterui64vNV = provider.getFunctionAddress("glGetNamedBufferParameterui64vNV");
        this.GetIntegerui64vNV = provider.getFunctionAddress("glGetIntegerui64vNV");
        this.Uniformui64NV = provider.getFunctionAddress("glUniformui64NV");
        this.Uniformui64vNV = provider.getFunctionAddress("glUniformui64vNV");
        this.GetUniformui64vNV = provider.getFunctionAddress("glGetUniformui64vNV");
        this.ProgramUniformui64NV = provider.getFunctionAddress("glProgramUniformui64NV");
        this.ProgramUniformui64vNV = provider.getFunctionAddress("glProgramUniformui64vNV");
    }

    public static NVShaderBufferLoad getInstance() {
        return GL.getCapabilities().__NVShaderBufferLoad;
    }

    static NVShaderBufferLoad create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_shader_buffer_load")) {
            return null;
        }
        NVShaderBufferLoad funcs = new NVShaderBufferLoad(provider);
        boolean supported = Checks.checkFunctions(funcs.MakeBufferResidentNV, funcs.MakeBufferNonResidentNV, funcs.IsBufferResidentNV, funcs.MakeNamedBufferResidentNV, funcs.MakeNamedBufferNonResidentNV, funcs.IsNamedBufferResidentNV, funcs.GetBufferParameterui64vNV, funcs.GetNamedBufferParameterui64vNV, funcs.GetIntegerui64vNV, funcs.Uniformui64NV, funcs.Uniformui64vNV, funcs.GetUniformui64vNV, funcs.ProgramUniformui64NV, funcs.ProgramUniformui64vNV);
        return GL.checkExtension("GL_NV_shader_buffer_load", funcs, supported);
    }

    public static native void nglMakeBufferResidentNV(int var0, int var1, long var2);

    public static void glMakeBufferResidentNV(int target, int access) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeBufferResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglMakeBufferResidentNV(target, access, __functionAddress);
    }

    public static native void nglMakeBufferNonResidentNV(int var0, long var1);

    public static void glMakeBufferNonResidentNV(int target) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeBufferNonResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglMakeBufferNonResidentNV(target, __functionAddress);
    }

    public static native boolean nglIsBufferResidentNV(int var0, long var1);

    public static boolean glIsBufferResidentNV(int target) {
        long __functionAddress = NVShaderBufferLoad.getInstance().IsBufferResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVShaderBufferLoad.nglIsBufferResidentNV(target, __functionAddress);
    }

    public static native void nglMakeNamedBufferResidentNV(int var0, int var1, long var2);

    public static void glMakeNamedBufferResidentNV(int buffer, int access) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeNamedBufferResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglMakeNamedBufferResidentNV(buffer, access, __functionAddress);
    }

    public static native void nglMakeNamedBufferNonResidentNV(int var0, long var1);

    public static void glMakeNamedBufferNonResidentNV(int buffer) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeNamedBufferNonResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglMakeNamedBufferNonResidentNV(buffer, __functionAddress);
    }

    public static native boolean nglIsNamedBufferResidentNV(int var0, long var1);

    public static boolean glIsNamedBufferResidentNV(int buffer) {
        long __functionAddress = NVShaderBufferLoad.getInstance().IsNamedBufferResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVShaderBufferLoad.nglIsNamedBufferResidentNV(buffer, __functionAddress);
    }

    public static native void nglGetBufferParameterui64vNV(int var0, int var1, long var2, long var4);

    public static void nglGetBufferParameterui64vNV(int target, int pname, long params) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetBufferParameterui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, params, __functionAddress);
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferParameterui64NV(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static native void nglGetNamedBufferParameterui64vNV(int var0, int var1, long var2, long var4);

    public static void nglGetNamedBufferParameterui64vNV(int buffer, int pname, long params) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetNamedBufferParameterui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferParameterui64NV(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static native void nglGetIntegerui64vNV(int var0, long var1, long var3);

    public static void nglGetIntegerui64vNV(int value, long result) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetIntegerui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, result, __functionAddress);
    }

    public static void glGetIntegerui64vNV(int value, ByteBuffer result) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)result, 8);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
    }

    public static void glGetIntegerui64vNV(int value, LongBuffer result) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)result, 1);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
    }

    public static long glGetIntegerui64NV(int value) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int result = __buffer.longParam();
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, __buffer.address(result));
        return __buffer.longValue(result);
    }

    public static native void nglUniformui64NV(int var0, long var1, long var3);

    public static void glUniformui64NV(int location, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().Uniformui64NV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglUniformui64NV(location, value, __functionAddress);
    }

    public static native void nglUniformui64vNV(int var0, int var1, long var2, long var4);

    public static void nglUniformui64vNV(int location, int count, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().Uniformui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglUniformui64vNV(location, count, value, __functionAddress);
    }

    public static void glUniformui64vNV(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        NVShaderBufferLoad.nglUniformui64vNV(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniformui64vNV(int location, LongBuffer value) {
        NVShaderBufferLoad.nglUniformui64vNV(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglGetUniformui64vNV(int var0, int var1, long var2, long var4);

    public static void nglGetUniformui64vNV(int program, int location, long params) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetUniformui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, params, __functionAddress);
    }

    public static void glGetUniformui64vNV(int program, int location, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformui64vNV(int program, int location, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
    }

    public static long glGetUniformui64NV(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static native void nglProgramUniformui64NV(int var0, int var1, long var2, long var4);

    public static void glProgramUniformui64NV(int program, int location, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().ProgramUniformui64NV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglProgramUniformui64NV(program, location, value, __functionAddress);
    }

    public static native void nglProgramUniformui64vNV(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniformui64vNV(int program, int location, int count, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().ProgramUniformui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniformui64vNV(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformui64vNV(int program, int location, LongBuffer value) {
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }
}

