/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class NVBindlessTexture {
    public final long GetTextureHandleNV;
    public final long GetTextureSamplerHandleNV;
    public final long MakeTextureHandleResidentNV;
    public final long MakeTextureHandleNonResidentNV;
    public final long GetImageHandleNV;
    public final long MakeImageHandleResidentNV;
    public final long MakeImageHandleNonResidentNV;
    public final long UniformHandleui64NV;
    public final long UniformHandleui64vNV;
    public final long ProgramUniformHandleui64NV;
    public final long ProgramUniformHandleui64vNV;
    public final long IsTextureHandleResidentNV;
    public final long IsImageHandleResidentNV;

    public NVBindlessTexture(FunctionProvider provider) {
        this.GetTextureHandleNV = provider.getFunctionAddress("glGetTextureHandleNV");
        this.GetTextureSamplerHandleNV = provider.getFunctionAddress("glGetTextureSamplerHandleNV");
        this.MakeTextureHandleResidentNV = provider.getFunctionAddress("glMakeTextureHandleResidentNV");
        this.MakeTextureHandleNonResidentNV = provider.getFunctionAddress("glMakeTextureHandleNonResidentNV");
        this.GetImageHandleNV = provider.getFunctionAddress("glGetImageHandleNV");
        this.MakeImageHandleResidentNV = provider.getFunctionAddress("glMakeImageHandleResidentNV");
        this.MakeImageHandleNonResidentNV = provider.getFunctionAddress("glMakeImageHandleNonResidentNV");
        this.UniformHandleui64NV = provider.getFunctionAddress("glUniformHandleui64NV");
        this.UniformHandleui64vNV = provider.getFunctionAddress("glUniformHandleui64vNV");
        this.ProgramUniformHandleui64NV = provider.getFunctionAddress("glProgramUniformHandleui64NV");
        this.ProgramUniformHandleui64vNV = provider.getFunctionAddress("glProgramUniformHandleui64vNV");
        this.IsTextureHandleResidentNV = provider.getFunctionAddress("glIsTextureHandleResidentNV");
        this.IsImageHandleResidentNV = provider.getFunctionAddress("glIsImageHandleResidentNV");
    }

    public static NVBindlessTexture getInstance() {
        return GL.getCapabilities().__NVBindlessTexture;
    }

    static NVBindlessTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_bindless_texture")) {
            return null;
        }
        NVBindlessTexture funcs = new NVBindlessTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.GetTextureHandleNV, funcs.GetTextureSamplerHandleNV, funcs.MakeTextureHandleResidentNV, funcs.MakeTextureHandleNonResidentNV, funcs.GetImageHandleNV, funcs.MakeImageHandleResidentNV, funcs.MakeImageHandleNonResidentNV, funcs.UniformHandleui64NV, funcs.UniformHandleui64vNV, funcs.ProgramUniformHandleui64NV, funcs.ProgramUniformHandleui64vNV, funcs.IsTextureHandleResidentNV, funcs.IsImageHandleResidentNV);
        return GL.checkExtension("GL_NV_bindless_texture", funcs, supported);
    }

    public static native long nglGetTextureHandleNV(int var0, long var1);

    public static long glGetTextureHandleNV(int texture) {
        long __functionAddress = NVBindlessTexture.getInstance().GetTextureHandleNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVBindlessTexture.nglGetTextureHandleNV(texture, __functionAddress);
    }

    public static native long nglGetTextureSamplerHandleNV(int var0, int var1, long var2);

    public static long glGetTextureSamplerHandleNV(int texture, int sampler) {
        long __functionAddress = NVBindlessTexture.getInstance().GetTextureSamplerHandleNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVBindlessTexture.nglGetTextureSamplerHandleNV(texture, sampler, __functionAddress);
    }

    public static native void nglMakeTextureHandleResidentNV(long var0, long var2);

    public static void glMakeTextureHandleResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeTextureHandleResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglMakeTextureHandleResidentNV(handle, __functionAddress);
    }

    public static native void nglMakeTextureHandleNonResidentNV(long var0, long var2);

    public static void glMakeTextureHandleNonResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeTextureHandleNonResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglMakeTextureHandleNonResidentNV(handle, __functionAddress);
    }

    public static native long nglGetImageHandleNV(int var0, int var1, boolean var2, int var3, int var4, long var5);

    public static long glGetImageHandleNV(int texture, int level, boolean layered, int layer, int format) {
        long __functionAddress = NVBindlessTexture.getInstance().GetImageHandleNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVBindlessTexture.nglGetImageHandleNV(texture, level, layered, layer, format, __functionAddress);
    }

    public static native void nglMakeImageHandleResidentNV(long var0, int var2, long var3);

    public static void glMakeImageHandleResidentNV(long handle, int access) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeImageHandleResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglMakeImageHandleResidentNV(handle, access, __functionAddress);
    }

    public static native void nglMakeImageHandleNonResidentNV(long var0, long var2);

    public static void glMakeImageHandleNonResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeImageHandleNonResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglMakeImageHandleNonResidentNV(handle, __functionAddress);
    }

    public static native void nglUniformHandleui64NV(int var0, long var1, long var3);

    public static void glUniformHandleui64NV(int location, long value) {
        long __functionAddress = NVBindlessTexture.getInstance().UniformHandleui64NV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglUniformHandleui64NV(location, value, __functionAddress);
    }

    public static native void nglUniformHandleui64vNV(int var0, int var1, long var2, long var4);

    public static void nglUniformHandleui64vNV(int location, int count, long values) {
        long __functionAddress = NVBindlessTexture.getInstance().UniformHandleui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglUniformHandleui64vNV(location, count, values, __functionAddress);
    }

    public static void glUniformHandleui64vNV(int location, int count, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        NVBindlessTexture.nglUniformHandleui64vNV(location, count, MemoryUtil.memAddress(values));
    }

    public static void glUniformHandleui64vNV(int location, LongBuffer values) {
        NVBindlessTexture.nglUniformHandleui64vNV(location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static native void nglProgramUniformHandleui64NV(int var0, int var1, long var2, long var4);

    public static void glProgramUniformHandleui64NV(int program, int location, long value) {
        long __functionAddress = NVBindlessTexture.getInstance().ProgramUniformHandleui64NV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglProgramUniformHandleui64NV(program, location, value, __functionAddress);
    }

    public static native void nglProgramUniformHandleui64vNV(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniformHandleui64vNV(int program, int location, int count, long values) {
        long __functionAddress = NVBindlessTexture.getInstance().ProgramUniformHandleui64vNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessTexture.nglProgramUniformHandleui64vNV(program, location, count, values, __functionAddress);
    }

    public static void glProgramUniformHandleui64vNV(int program, int location, int count, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        NVBindlessTexture.nglProgramUniformHandleui64vNV(program, location, count, MemoryUtil.memAddress(values));
    }

    public static void glProgramUniformHandleui64vNV(int program, int location, LongBuffer values) {
        NVBindlessTexture.nglProgramUniformHandleui64vNV(program, location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static native boolean nglIsTextureHandleResidentNV(long var0, long var2);

    public static boolean glIsTextureHandleResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().IsTextureHandleResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVBindlessTexture.nglIsTextureHandleResidentNV(handle, __functionAddress);
    }

    public static native boolean nglIsImageHandleResidentNV(long var0, long var2);

    public static boolean glIsImageHandleResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().IsImageHandleResidentNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return NVBindlessTexture.nglIsImageHandleResidentNV(handle, __functionAddress);
    }
}

