/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLXSGIVideoSync {
    public final long GetVideoSyncSGI;
    public final long WaitVideoSyncSGI;

    public GLXSGIVideoSync(FunctionProvider provider) {
        this.GetVideoSyncSGI = provider.getFunctionAddress("glXGetVideoSyncSGI");
        this.WaitVideoSyncSGI = provider.getFunctionAddress("glXWaitVideoSyncSGI");
    }

    public static GLXSGIVideoSync getInstance() {
        return GL.getCapabilities().__GLXSGIVideoSync;
    }

    static GLXSGIVideoSync create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGI_video_sync")) {
            return null;
        }
        GLXSGIVideoSync funcs = new GLXSGIVideoSync(provider);
        boolean supported = Checks.checkFunctions(funcs.GetVideoSyncSGI, funcs.WaitVideoSyncSGI);
        return GL.checkExtension("GLX_SGI_video_sync", funcs, supported);
    }

    public static native int nglXGetVideoSyncSGI(long var0, long var2);

    public static int nglXGetVideoSyncSGI(long count) {
        long __functionAddress = GLXSGIVideoSync.getInstance().GetVideoSyncSGI;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLXSGIVideoSync.nglXGetVideoSyncSGI(count, __functionAddress);
    }

    public static int glXGetVideoSyncSGI(ByteBuffer count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)count, 4);
        }
        return GLXSGIVideoSync.nglXGetVideoSyncSGI(MemoryUtil.memAddress(count));
    }

    public static int glXGetVideoSyncSGI(IntBuffer count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return GLXSGIVideoSync.nglXGetVideoSyncSGI(MemoryUtil.memAddress(count));
    }

    public static native int nglXWaitVideoSyncSGI(int var0, int var1, long var2, long var4);

    public static int nglXWaitVideoSyncSGI(int divisor, int remainder, long count) {
        long __functionAddress = GLXSGIVideoSync.getInstance().WaitVideoSyncSGI;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLXSGIVideoSync.nglXWaitVideoSyncSGI(divisor, remainder, count, __functionAddress);
    }

    public static int glXWaitVideoSyncSGI(int divisor, int remainder, ByteBuffer count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)count, 4);
        }
        return GLXSGIVideoSync.nglXWaitVideoSyncSGI(divisor, remainder, MemoryUtil.memAddress(count));
    }

    public static int glXWaitVideoSyncSGI(int divisor, int remainder, IntBuffer count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return GLXSGIVideoSync.nglXWaitVideoSyncSGI(divisor, remainder, MemoryUtil.memAddress(count));
    }
}

