/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.PrintStream;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLContextLinux;
import org.lwjgl.opengl.GLContextMacOSX;
import org.lwjgl.opengl.GLContextWindows;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.Closure;

public abstract class GLContext
implements Pointer {
    final ContextCapabilities capabilities;

    protected GLContext(ContextCapabilities capabilities) {
        this.capabilities = capabilities;
        GL.setCurrent(this);
    }

    public static GLContext createFromCurrent() {
        switch (LWJGLUtil.getPlatform()) {
            case WINDOWS: {
                return GLContextWindows.createFromCurrent();
            }
            case LINUX: {
                return GLContextLinux.createFromCurrent();
            }
            case MACOSX: {
                return GLContextMacOSX.createFromCurrent();
            }
        }
        throw new IllegalStateException();
    }

    public ContextCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void makeCurrent(long target) {
        this.makeCurrentImpl(target);
        GL.setCurrent(this);
    }

    public void makeCurrent(long targetDraw, long targetRead) {
        this.makeCurrentImpl(targetDraw, targetRead);
        GL.setCurrent(this);
    }

    protected abstract void makeCurrentImpl(long var1);

    protected abstract void makeCurrentImpl(long var1, long var3);

    public abstract boolean isCurrent();

    public void destroy() {
        this.destroyImpl();
    }

    protected abstract void destroyImpl();

    public void checkGLError() throws OpenGLException {
        int err = GL11.nglGetError(this.capabilities.__GL11.GetError);
        if (err != 0) {
            throw new OpenGLException(err);
        }
    }

    public static String translateGLErrorString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "No error";
            }
            case 1280: {
                return "Enum argument out of range";
            }
            case 1281: {
                return "Numeric argument out of range";
            }
            case 1282: {
                return "Operation illegal in current state";
            }
            case 1283: {
                return "Command would cause a stack overflow";
            }
            case 1284: {
                return "Command would cause a stack underflow";
            }
            case 1285: {
                return "Not enough memory left to execute command";
            }
            case 1286: {
                return "Framebuffer object is not complete";
            }
            case 32817: {
                return "The specified table is too large";
            }
        }
        return GLContext.getUnknownToken(errorCode);
    }

    private static String getUnknownToken(int token) {
        return String.format("Unknown (0x%X)", token);
    }

    public Closure setupDebugMessageCallback() {
        return this.setupDebugMessageCallback(System.err);
    }

    public Closure setupDebugMessageCallback(PrintStream stream) {
        if (this.capabilities.OpenGL43) {
            LWJGLUtil.log("[GL] Using OpenGL 4.3 for error logging.");
            GLDebugMessageCallback proc = GLContext.createDEBUGPROC(stream);
            GL43.glDebugMessageCallback(proc, 0L);
            if ((GL11.glGetInteger(33310) & 2) == 0) {
                LWJGLUtil.log("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable(37600);
            }
            return proc;
        }
        if (this.capabilities.GL_KHR_debug) {
            LWJGLUtil.log("[GL] Using KHR_debug for error logging.");
            GLDebugMessageCallback proc = GLContext.createDEBUGPROC(stream);
            KHRDebug.glDebugMessageCallback(proc, 0L);
            if ((GL11.glGetInteger(33310) & 2) == 0) {
                LWJGLUtil.log("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable(37600);
            }
            return proc;
        }
        if (this.capabilities.GL_ARB_debug_output) {
            LWJGLUtil.log("[GL] Using ARB_debug_output for error logging.");
            GLDebugMessageARBCallback proc = GLContext.createDEBUGPROCARB(stream);
            ARBDebugOutput.glDebugMessageCallbackARB(proc, 0L);
            return proc;
        }
        if (this.capabilities.GL_AMD_debug_output) {
            LWJGLUtil.log("[GL] Using AMD_debug_output for error logging.");
            GLDebugMessageAMDCallback proc = GLContext.createDEBUGPROCAMD(stream);
            AMDDebugOutput.glDebugMessageCallbackAMD(proc, 0L);
            return proc;
        }
        LWJGLUtil.log("[GL] No debug output implementation is available.");
        return null;
    }

    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("\t%s: %s\n", type, message);
    }

    private static GLDebugMessageCallback createDEBUGPROC(final PrintStream stream) {
        return new GLDebugMessageCallback(){

            @Override
            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                stream.println("[LWJGL] OpenGL debug message");
                GLContext.printDetail(stream, "ID", String.format("0x%X", id));
                GLContext.printDetail(stream, "Source", this.getSource(source));
                GLContext.printDetail(stream, "Type", this.getType(type));
                GLContext.printDetail(stream, "Severity", this.getSeverity(severity));
                GLContext.printDetail(stream, "Message", MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(message, length)));
            }

            private String getSource(int source) {
                switch (source) {
                    case 33350: {
                        return "API";
                    }
                    case 33351: {
                        return "WINDOW SYSTEM";
                    }
                    case 33352: {
                        return "SHADER COMPILER";
                    }
                    case 33353: {
                        return "THIRD PARTY";
                    }
                    case 33354: {
                        return "APPLICATION";
                    }
                    case 33355: {
                        return "OTHER";
                    }
                }
                return GLContext.getUnknownToken(source);
            }

            private String getType(int type) {
                switch (type) {
                    case 33356: {
                        return "ERROR";
                    }
                    case 33357: {
                        return "DEPRECATED BEHAVIOR";
                    }
                    case 33358: {
                        return "UNDEFINED BEHAVIOR";
                    }
                    case 33359: {
                        return "PORTABILITY";
                    }
                    case 33360: {
                        return "PERFORMANCE";
                    }
                    case 33361: {
                        return "OTHER";
                    }
                    case 33384: {
                        return "MARKER";
                    }
                }
                return GLContext.getUnknownToken(type);
            }

            private String getSeverity(int severity) {
                switch (severity) {
                    case 37190: {
                        return "HIGH";
                    }
                    case 37191: {
                        return "MEDIUM";
                    }
                    case 37192: {
                        return "LOW";
                    }
                    case 33387: {
                        return "NOTIFICATION";
                    }
                }
                return GLContext.getUnknownToken(severity);
            }
        };
    }

    private static GLDebugMessageARBCallback createDEBUGPROCARB(final PrintStream stream) {
        return new GLDebugMessageARBCallback(){

            @Override
            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                stream.println("[LWJGL] ARB_debug_output message");
                GLContext.printDetail(stream, "ID", String.format("0x%X", id));
                GLContext.printDetail(stream, "Source", this.getSource(source));
                GLContext.printDetail(stream, "Type", this.getType(type));
                GLContext.printDetail(stream, "Severity", this.getSeverity(severity));
                GLContext.printDetail(stream, "Message", MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(message, length)));
            }

            private String getSource(int source) {
                switch (source) {
                    case 33350: {
                        return "API";
                    }
                    case 33351: {
                        return "WINDOW SYSTEM";
                    }
                    case 33352: {
                        return "SHADER COMPILER";
                    }
                    case 33353: {
                        return "THIRD PARTY";
                    }
                    case 33354: {
                        return "APPLICATION";
                    }
                    case 33355: {
                        return "OTHER";
                    }
                }
                return GLContext.getUnknownToken(source);
            }

            private String getType(int type) {
                switch (type) {
                    case 33356: {
                        return "ERROR";
                    }
                    case 33357: {
                        return "DEPRECATED BEHAVIOR";
                    }
                    case 33358: {
                        return "UNDEFINED BEHAVIOR";
                    }
                    case 33359: {
                        return "PORTABILITY";
                    }
                    case 33360: {
                        return "PERFORMANCE";
                    }
                    case 33361: {
                        return "OTHER";
                    }
                }
                return GLContext.getUnknownToken(type);
            }

            private String getSeverity(int severity) {
                switch (severity) {
                    case 37190: {
                        return "HIGH";
                    }
                    case 37191: {
                        return "MEDIUM";
                    }
                    case 37192: {
                        return "LOW";
                    }
                }
                return GLContext.getUnknownToken(severity);
            }
        };
    }

    private static GLDebugMessageAMDCallback createDEBUGPROCAMD(final PrintStream stream) {
        return new GLDebugMessageAMDCallback(){

            @Override
            public void invoke(int id, int category, int severity, int length, long message, long userParam) {
                stream.println("[LWJGL] AMD_debug_output message");
                GLContext.printDetail(stream, "ID", String.format("0x%X", id));
                GLContext.printDetail(stream, "Category", this.getCategory(category));
                GLContext.printDetail(stream, "Severity", this.getSeverity(severity));
                GLContext.printDetail(stream, "Message", MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(message, length)));
            }

            private String getCategory(int category) {
                switch (category) {
                    case 37193: {
                        return "API ERROR";
                    }
                    case 37194: {
                        return "WINDOW SYSTEM";
                    }
                    case 37195: {
                        return "DEPRECATION";
                    }
                    case 37196: {
                        return "UNDEFINED BEHAVIOR";
                    }
                    case 37197: {
                        return "PERFORMANCE";
                    }
                    case 37198: {
                        return "SHADER COMPILER";
                    }
                    case 37199: {
                        return "APPLICATION";
                    }
                    case 37200: {
                        return "OTHER";
                    }
                }
                return GLContext.getUnknownToken(category);
            }

            private String getSeverity(int severity) {
                switch (severity) {
                    case 37190: {
                        return "HIGH";
                    }
                    case 37191: {
                        return "MEDIUM";
                    }
                    case 37192: {
                        return "LOW";
                    }
                }
                return GLContext.getUnknownToken(severity);
            }
        };
    }
}

