/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CGL {
    public static final int kCGLPFAAllRenderers = 1;
    public static final int kCGLPFATripleBuffer = 3;
    public static final int kCGLPFADoubleBuffer = 5;
    public static final int kCGLPFAStereo = 6;
    public static final int kCGLPFAColorSize = 8;
    public static final int kCGLPFAAlphaSize = 11;
    public static final int kCGLPFADepthSize = 12;
    public static final int kCGLPFAStencilSize = 13;
    public static final int kCGLPFAMinimumPolicy = 51;
    public static final int kCGLPFAMaximumPolicy = 52;
    public static final int kCGLPFASampleBuffers = 55;
    public static final int kCGLPFASamples = 56;
    public static final int kCGLPFAColorFloat = 58;
    public static final int kCGLPFAMultisample = 59;
    public static final int kCGLPFASupersample = 60;
    public static final int kCGLPFASampleAlpha = 61;
    public static final int kCGLPFARendererID = 70;
    public static final int kCGLPFASingleRenderer = 71;
    public static final int kCGLPFANoRecovery = 72;
    public static final int kCGLPFAAccelerated = 73;
    public static final int kCGLPFAClosestPolicy = 74;
    public static final int kCGLPFABackingStore = 76;
    public static final int kCGLPFABackingVolatile = 77;
    public static final int kCGLPFADisplayMask = 84;
    public static final int kCGLPFAAllowOfflineRenderers = 96;
    public static final int kCGLPFAAcceleratedCompute = 97;
    public static final int kCGLPFAOpenGLProfile = 99;
    public static final int kCGLPFASupportsAutomaticGraphicsSwitching = 101;
    public static final int kCGLPFAVirtualScreenCount = 128;
    public static final int kCGLPFAAuxBuffers = 7;
    public static final int kCGLPFAAccumSize = 14;
    public static final int kCGLPFAOffScreen = 53;
    public static final int kCGLPFAAuxDepthStencil = 57;
    public static final int kCGLPFAWindow = 80;
    public static final int kCGLPFACompliant = 83;
    public static final int kCGLPFAPBuffer = 90;
    public static final int kCGLPFARemotePBuffer = 91;
    public static final int kCGLPFARobust = 75;
    public static final int kCGLPFAMPSafe = 78;
    public static final int kCGLPFAMultiScreen = 81;
    public static final int kCGLPFAFullScreen = 54;
    public static final int kCGLRPOffScreen = 53;
    public static final int kCGLRPRendererID = 70;
    public static final int kCGLRPAccelerated = 73;
    public static final int kCGLRPBackingStore = 76;
    public static final int kCGLRPWindow = 80;
    public static final int kCGLRPCompliant = 83;
    public static final int kCGLRPDisplayMask = 84;
    public static final int kCGLRPBufferModes = 100;
    public static final int kCGLRPColorModes = 103;
    public static final int kCGLRPAccumModes = 104;
    public static final int kCGLRPDepthModes = 105;
    public static final int kCGLRPStencilModes = 106;
    public static final int kCGLRPMaxAuxBuffers = 107;
    public static final int kCGLRPMaxSampleBuffers = 108;
    public static final int kCGLRPMaxSamples = 109;
    public static final int kCGLRPSampleModes = 110;
    public static final int kCGLRPSampleAlpha = 111;
    public static final int kCGLRPVideoMemory = 120;
    public static final int kCGLRPTextureMemory = 121;
    public static final int kCGLRPGPUVertProcCapable = 122;
    public static final int kCGLRPGPUFragProcCapable = 123;
    public static final int kCGLRPRendererCount = 128;
    public static final int kCGLRPOnline = 129;
    public static final int kCGLRPAcceleratedCompute = 130;
    public static final int kCGLRPVideoMemoryMegabytes = 131;
    public static final int kCGLRPTextureMemoryMegabytes = 132;
    public static final int kCGLRPRobust = 75;
    public static final int kCGLRPMPSafe = 78;
    public static final int kCGLRPMultiScreen = 81;
    public static final int kCGLRPFullScreen = 54;
    public static final int kCGLCESwapRectangle = 201;
    public static final int kCGLCESwapLimit = 203;
    public static final int kCGLCERasterization = 221;
    public static final int kCGLCEStateValidation = 301;
    public static final int kCGLCESurfaceBackingSize = 305;
    public static final int kCGLCEDisplayListOptimization = 307;
    public static final int kCGLCEMPEngine = 313;
    public static final int kCGLCPSwapRectangle = 200;
    public static final int kCGLCPSwapInterval = 222;
    public static final int kCGLCPDispatchTableSize = 224;
    public static final int kCGLCPClientStorage = 226;
    public static final int kCGLCPSurfaceTexture = 228;
    public static final int kCGLCPSurfaceOrder = 235;
    public static final int kCGLCPSurfaceOpacity = 236;
    public static final int kCGLCPSurfaceBackingSize = 304;
    public static final int kCGLCPSurfaceSurfaceVolatile = 306;
    public static final int kCGLCPReclaimResources = 308;
    public static final int kCGLCPCurrentRendererID = 309;
    public static final int kCGLCPGPUVertexProcessing = 310;
    public static final int kCGLCPGPUFragmentProcessing = 311;
    public static final int kCGLCPHasDrawable = 314;
    public static final int kCGLCPMPSwapsInFlight = 315;
    public static final int kCGLGOFormatCacheSize = 501;
    public static final int kCGLGOClearFormatCache = 502;
    public static final int kCGLGORetainRenderers = 503;
    public static final int kCGLGOResetLibrary = 504;
    public static final int kCGLGOUseErrorHandler = 505;
    public static final int kCGLGOUseBuildCache = 506;
    public static final int kCGLOGLPVersion_Legacy = 4096;
    public static final int kCGLOGLPVersion_3_2_Core = 12800;
    public static final int kCGLNoError = 0;
    public static final int kCGLBadAttribute = 10000;
    public static final int kCGLBadProperty = 10001;
    public static final int kCGLBadPixelFormat = 10002;
    public static final int kCGLBadRendererInfo = 10003;
    public static final int kCGLBadContext = 10004;
    public static final int kCGLBadDrawable = 10005;
    public static final int kCGLBadDisplay = 10006;
    public static final int kCGLBadState = 10007;
    public static final int kCGLBadValue = 10008;
    public static final int kCGLBadMatch = 10009;
    public static final int kCGLBadEnumeration = 10010;
    public static final int kCGLBadOffScreen = 10011;
    public static final int kCGLBadFullScreen = 10012;
    public static final int kCGLBadWindow = 10013;
    public static final int kCGLBadAddress = 10014;
    public static final int kCGLBadCodeModule = 10015;
    public static final int kCGLBadAlloc = 10016;
    public static final int kCGLBadConnection = 10017;
    public static final int kCGLMonoscopicBit = 1;
    public static final int kCGLStereoscopicBit = 2;
    public static final int kCGLSingleBufferBit = 4;
    public static final int kCGLDoubleBufferBit = 8;
    public static final int kCGLTripleBufferBit = 16;
    public static final int kCGL0Bit = 1;
    public static final int kCGL1Bit = 2;
    public static final int kCGL2Bit = 4;
    public static final int kCGL3Bit = 8;
    public static final int kCGL4Bit = 16;
    public static final int kCGL5Bit = 32;
    public static final int kCGL6Bit = 64;
    public static final int kCGL8Bit = 128;
    public static final int kCGL10Bit = 256;
    public static final int kCGL12Bit = 512;
    public static final int kCGL16Bit = 1024;
    public static final int kCGL24Bit = 2048;
    public static final int kCGL32Bit = 4096;
    public static final int kCGL48Bit = 8192;
    public static final int kCGL64Bit = 16384;
    public static final int kCGL96Bit = 32768;
    public static final int kCGL128Bit = 65536;
    public static final int kCGLRGB444Bit = 64;
    public static final int kCGLARGB4444Bit = 128;
    public static final int kCGLRGB444A8Bit = 256;
    public static final int kCGLRGB555Bit = 512;
    public static final int kCGLARGB1555Bit = 1024;
    public static final int kCGLRGB555A8Bit = 2048;
    public static final int kCGLRGB565Bit = 4096;
    public static final int kCGLRGB565A8Bit = 8192;
    public static final int kCGLRGB888Bit = 16384;
    public static final int kCGLARGB8888Bit = 32768;
    public static final int kCGLRGB888A8Bit = 65536;
    public static final int kCGLRGB101010Bit = 131072;
    public static final int kCGLARGB2101010Bit = 262144;
    public static final int kCGLRGB101010_A8Bit = 524288;
    public static final int kCGLRGB121212Bit = 0x100000;
    public static final int kCGLARGB12121212Bit = 0x200000;
    public static final int kCGLRGB161616Bit = 0x400000;
    public static final int kCGLRGBA16161616Bit = 0x800000;
    public static final int kCGLRGBFloat64Bit = 0x1000000;
    public static final int kCGLRGBAFloat64Bit = 0x2000000;
    public static final int kCGLRGBFloat128Bit = 0x4000000;
    public static final int kCGLRGBAFloat128Bit = 0x8000000;
    public static final int kCGLRGBFloat256Bit = 0x10000000;
    public static final int kCGLRGBAFloat256Bit = 0x20000000;
    public static final int kCGLSupersampleBit = 1;
    public static final int kCGLMultisampleBit = 2;

    private CGL() {
    }

    public static native long CGLGetCurrentContext();

    public static native int nCGLSetCurrentContext(long var0);

    public static int CGLSetCurrentContext(long context) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(context);
        }
        return CGL.nCGLSetCurrentContext(context);
    }

    public static native long nCGLGetShareGroup(long var0);

    public static long CGLGetShareGroup(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLGetShareGroup(ctx);
    }

    public static native int nCGLChoosePixelFormat(long var0, long var2, long var4);

    public static int CGLChoosePixelFormat(ByteBuffer attribs, ByteBuffer pix, ByteBuffer npix) {
        if (LWJGLUtil.CHECKS) {
            if (pix != null) {
                Checks.checkBuffer((Buffer)pix, 1 << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)npix, 4);
        }
        return CGL.nCGLChoosePixelFormat(MemoryUtil.memAddress(attribs), MemoryUtil.memAddressSafe(pix), MemoryUtil.memAddress(npix));
    }

    public static int CGLChoosePixelFormat(IntBuffer attribs, PointerBuffer pix, IntBuffer npix) {
        if (LWJGLUtil.CHECKS) {
            if (pix != null) {
                Checks.checkBuffer(pix, 1);
            }
            Checks.checkBuffer((Buffer)npix, 1);
        }
        return CGL.nCGLChoosePixelFormat(MemoryUtil.memAddress(attribs), MemoryUtil.memAddressSafe(pix), MemoryUtil.memAddress(npix));
    }

    public static native int nCGLDestroyPixelFormat(long var0);

    public static int CGLDestroyPixelFormat(long pix) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
        }
        return CGL.nCGLDestroyPixelFormat(pix);
    }

    public static native int nCGLDescribePixelFormat(long var0, int var2, int var3, long var4);

    public static int CGLDescribePixelFormat(long pix, int pix_num, int attrib, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
            Checks.checkBuffer((Buffer)value, 4);
        }
        return CGL.nCGLDescribePixelFormat(pix, pix_num, attrib, MemoryUtil.memAddress(value));
    }

    public static int CGLDescribePixelFormat(long pix, int pix_num, int attrib, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
            Checks.checkBuffer((Buffer)value, 1);
        }
        return CGL.nCGLDescribePixelFormat(pix, pix_num, attrib, MemoryUtil.memAddress(value));
    }

    public static native void nCGLReleasePixelFormat(long var0);

    public static void CGLReleasePixelFormat(long pix) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
        }
        CGL.nCGLReleasePixelFormat(pix);
    }

    public static native long nCGLRetainPixelFormat(long var0);

    public static long CGLRetainPixelFormat(long pix) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
        }
        return CGL.nCGLRetainPixelFormat(pix);
    }

    public static native int nCGLGetPixelFormatRetainCount(long var0);

    public static int CGLGetPixelFormatRetainCount(long pix) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
        }
        return CGL.nCGLGetPixelFormatRetainCount(pix);
    }

    public static native int nCGLQueryRendererInfo(int var0, long var1, long var3);

    public static int CGLQueryRendererInfo(int display_mask, ByteBuffer rend, ByteBuffer nrend) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)rend, 1 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)nrend, 4);
        }
        return CGL.nCGLQueryRendererInfo(display_mask, MemoryUtil.memAddress(rend), MemoryUtil.memAddress(nrend));
    }

    public static int CGLQueryRendererInfo(int display_mask, PointerBuffer rend, IntBuffer nrend) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(rend, 1);
            Checks.checkBuffer((Buffer)nrend, 1);
        }
        return CGL.nCGLQueryRendererInfo(display_mask, MemoryUtil.memAddress(rend), MemoryUtil.memAddress(nrend));
    }

    public static native int nCGLDestroyRendererInfo(long var0);

    public static int CGLDestroyRendererInfo(long rend) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(rend);
        }
        return CGL.nCGLDestroyRendererInfo(rend);
    }

    public static native int nCGLDescribeRenderer(long var0, int var2, int var3, long var4);

    public static int CGLDescribeRenderer(long rend, int rend_num, int prop, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(rend);
            Checks.checkBuffer((Buffer)value, 4);
        }
        return CGL.nCGLDescribeRenderer(rend, rend_num, prop, MemoryUtil.memAddress(value));
    }

    public static int CGLDescribeRenderer(long rend, int rend_num, int prop, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(rend);
            Checks.checkBuffer((Buffer)value, 1);
        }
        return CGL.nCGLDescribeRenderer(rend, rend_num, prop, MemoryUtil.memAddress(value));
    }

    public static native int nCGLCreateContext(long var0, long var2, long var4);

    public static int CGLCreateContext(long pix, long share, ByteBuffer ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
            Checks.checkPointer(share);
            Checks.checkBuffer((Buffer)ctx, 1 << Pointer.POINTER_SHIFT);
        }
        return CGL.nCGLCreateContext(pix, share, MemoryUtil.memAddress(ctx));
    }

    public static int CGLCreateContext(long pix, long share, PointerBuffer ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(pix);
            Checks.checkPointer(share);
            Checks.checkBuffer(ctx, 1);
        }
        return CGL.nCGLCreateContext(pix, share, MemoryUtil.memAddress(ctx));
    }

    public static native int nCGLDestroyContext(long var0);

    public static int CGLDestroyContext(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLDestroyContext(ctx);
    }

    public static native int nCGLCopyContext(long var0, long var2, int var4);

    public static int CGLCopyContext(long src, long dst, int mask) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(src);
            Checks.checkPointer(dst);
        }
        return CGL.nCGLCopyContext(src, dst, mask);
    }

    public static native long nCGLRetainContext(long var0);

    public static long CGLRetainContext(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLRetainContext(ctx);
    }

    public static native void nCGLReleaseContext(long var0);

    public static void CGLReleaseContext(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        CGL.nCGLReleaseContext(ctx);
    }

    public static native int nCGLGetContextRetainCount(long var0);

    public static int CGLGetContextRetainCount(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLGetContextRetainCount(ctx);
    }

    public static native long nCGLGetPixelFormat(long var0);

    public static long CGLGetPixelFormat(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLGetPixelFormat(ctx);
    }

    public static native int nCGLClearDrawable(long var0);

    public static int CGLClearDrawable(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLClearDrawable(ctx);
    }

    public static native int nCGLFlushDrawable(long var0);

    public static int CGLFlushDrawable(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLFlushDrawable(ctx);
    }

    public static native int nCGLEnable(long var0, int var2);

    public static int CGLEnable(long ctx, int pname) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLEnable(ctx, pname);
    }

    public static native int nCGLDisable(long var0, int var2);

    public static int CGLDisable(long ctx, int pname) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLDisable(ctx, pname);
    }

    public static native int nCGLIsEnabled(long var0, int var2, long var3);

    public static int CGLIsEnabled(long ctx, int pname, ByteBuffer enable) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)enable, 4);
        }
        return CGL.nCGLIsEnabled(ctx, pname, MemoryUtil.memAddress(enable));
    }

    public static int CGLIsEnabled(long ctx, int pname, IntBuffer enable) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)enable, 1);
        }
        return CGL.nCGLIsEnabled(ctx, pname, MemoryUtil.memAddress(enable));
    }

    public static native int nCGLSetParameter(long var0, int var2, long var3);

    public static int CGLSetParameter(long ctx, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLSetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetParameter(long ctx, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLSetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetParameter(long ctx, int pname, int param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        return CGL.nCGLSetParameter(ctx, pname, __buffer.address(params));
    }

    public static native int nCGLGetParameter(long var0, int var2, long var3);

    public static int CGLGetParameter(long ctx, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLGetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLGetParameter(long ctx, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLGetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static native int nCGLSetVirtualScreen(long var0, int var2);

    public static int CGLSetVirtualScreen(long ctx, int screen) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLSetVirtualScreen(ctx, screen);
    }

    public static native int nCGLGetVirtualScreen(long var0, long var2);

    public static int CGLGetVirtualScreen(long ctx, ByteBuffer screen) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)screen, 4);
        }
        return CGL.nCGLGetVirtualScreen(ctx, MemoryUtil.memAddress(screen));
    }

    public static int CGLGetVirtualScreen(long ctx, IntBuffer screen) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkBuffer((Buffer)screen, 1);
        }
        return CGL.nCGLGetVirtualScreen(ctx, MemoryUtil.memAddress(screen));
    }

    public static native int nCGLUpdateContext(long var0);

    public static int CGLUpdateContext(long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return CGL.nCGLUpdateContext(ctx);
    }

    public static native int nCGLSetGlobalOption(int var0, long var1);

    public static int CGLSetGlobalOption(int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLSetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetGlobalOption(int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLSetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetGlobalOption(int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        return CGL.nCGLSetGlobalOption(pname, __buffer.address(params));
    }

    public static native int nCGLGetGlobalOption(int var0, long var1);

    public static int CGLGetGlobalOption(int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLGetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLGetGlobalOption(int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLGetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static native int nCGLLockContext(long var0);

    public static int CGLLockContext(long context) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(context);
        }
        return CGL.nCGLLockContext(context);
    }

    public static native int nCGLUnlockContext(long var0);

    public static int CGLUnlockContext(long context) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(context);
        }
        return CGL.nCGLUnlockContext(context);
    }

    public static native void nCGLGetVersion(long var0, long var2);

    public static void CGLGetVersion(ByteBuffer majorvers, ByteBuffer minorvers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)majorvers, 4);
            Checks.checkBuffer((Buffer)minorvers, 4);
        }
        CGL.nCGLGetVersion(MemoryUtil.memAddress(majorvers), MemoryUtil.memAddress(minorvers));
    }

    public static void CGLGetVersion(IntBuffer majorvers, IntBuffer minorvers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)majorvers, 1);
            Checks.checkBuffer((Buffer)minorvers, 1);
        }
        CGL.nCGLGetVersion(MemoryUtil.memAddress(majorvers), MemoryUtil.memAddress(minorvers));
    }

    public static native long nCGLErrorString(int var0);

    public static String CGLErrorString(int error) {
        long __result = CGL.nCGLErrorString(error);
        return MemoryUtil.memDecodeASCII(__result);
    }

    static {
        LWJGLUtil.initialize();
    }
}

