/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;
    public final long BindVertexArray;
    public final long DeleteVertexArrays;
    public final long GenVertexArrays;
    public final long IsVertexArray;

    public ARBVertexArrayObject(FunctionProvider provider) {
        this.BindVertexArray = provider.getFunctionAddress("glBindVertexArray");
        this.DeleteVertexArrays = provider.getFunctionAddress("glDeleteVertexArrays");
        this.GenVertexArrays = provider.getFunctionAddress("glGenVertexArrays");
        this.IsVertexArray = provider.getFunctionAddress("glIsVertexArray");
    }

    public static ARBVertexArrayObject getInstance() {
        return GL.getCapabilities().__ARBVertexArrayObject;
    }

    static ARBVertexArrayObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_vertex_array_object")) {
            return null;
        }
        ARBVertexArrayObject funcs = new ARBVertexArrayObject(provider);
        boolean supported = Checks.checkFunctions(funcs.BindVertexArray, funcs.DeleteVertexArrays, funcs.GenVertexArrays, funcs.IsVertexArray);
        return GL.checkExtension("GL_ARB_vertex_array_object", funcs, supported);
    }

    public static void glBindVertexArray(int array) {
        long __functionAddress = ARBVertexArrayObject.getInstance().BindVertexArray;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglBindVertexArray(array, __functionAddress);
    }

    public static void nglDeleteVertexArrays(int n, long arrays) {
        long __functionAddress = ARBVertexArrayObject.getInstance().DeleteVertexArrays;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglDeleteVertexArrays(n, arrays, __functionAddress);
    }

    public static void glDeleteVertexArrays(int n, ByteBuffer arrays) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        ARBVertexArrayObject.nglDeleteVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glDeleteVertexArrays(IntBuffer arrays) {
        ARBVertexArrayObject.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static void glDeleteVertexArrays(int array) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam(array);
        ARBVertexArrayObject.nglDeleteVertexArrays(1, __buffer.address(arrays));
    }

    public static void nglGenVertexArrays(int n, long arrays) {
        long __functionAddress = ARBVertexArrayObject.getInstance().GenVertexArrays;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglGenVertexArrays(n, arrays, __functionAddress);
    }

    public static void glGenVertexArrays(int n, ByteBuffer arrays) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        ARBVertexArrayObject.nglGenVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glGenVertexArrays(IntBuffer arrays) {
        ARBVertexArrayObject.nglGenVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static int glGenVertexArrays() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam();
        ARBVertexArrayObject.nglGenVertexArrays(1, __buffer.address(arrays));
        return __buffer.intValue(arrays);
    }

    public static boolean glIsVertexArray(int array) {
        long __functionAddress = ARBVertexArrayObject.getInstance().IsVertexArray;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL30.nglIsVertexArray(array, __functionAddress);
    }
}

