/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL40;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBTransformFeedback3 {
    public static final int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 36464;
    public static final int GL_MAX_VERTEX_STREAMS = 36465;
    public final long DrawTransformFeedbackStream;
    public final long BeginQueryIndexed;
    public final long EndQueryIndexed;
    public final long GetQueryIndexediv;

    public ARBTransformFeedback3(FunctionProvider provider) {
        this.DrawTransformFeedbackStream = provider.getFunctionAddress("glDrawTransformFeedbackStream");
        this.BeginQueryIndexed = provider.getFunctionAddress("glBeginQueryIndexed");
        this.EndQueryIndexed = provider.getFunctionAddress("glEndQueryIndexed");
        this.GetQueryIndexediv = provider.getFunctionAddress("glGetQueryIndexediv");
    }

    public static ARBTransformFeedback3 getInstance() {
        return GL.getCapabilities().__ARBTransformFeedback3;
    }

    static ARBTransformFeedback3 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_transform_feedback3")) {
            return null;
        }
        ARBTransformFeedback3 funcs = new ARBTransformFeedback3(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawTransformFeedbackStream, funcs.BeginQueryIndexed, funcs.EndQueryIndexed, funcs.GetQueryIndexediv);
        return GL.checkExtension("GL_ARB_transform_feedback3", funcs, supported);
    }

    public static void glDrawTransformFeedbackStream(int mode, int id, int stream) {
        long __functionAddress = ARBTransformFeedback3.getInstance().DrawTransformFeedbackStream;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL40.nglDrawTransformFeedbackStream(mode, id, stream, __functionAddress);
    }

    public static void glBeginQueryIndexed(int target, int index, int id) {
        long __functionAddress = ARBTransformFeedback3.getInstance().BeginQueryIndexed;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL40.nglBeginQueryIndexed(target, index, id, __functionAddress);
    }

    public static void glEndQueryIndexed(int target, int index) {
        long __functionAddress = ARBTransformFeedback3.getInstance().EndQueryIndexed;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL40.nglEndQueryIndexed(target, index, __functionAddress);
    }

    public static void nglGetQueryIndexediv(int target, int index, int pname, long params) {
        long __functionAddress = ARBTransformFeedback3.getInstance().GetQueryIndexediv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL40.nglGetQueryIndexediv(target, index, pname, params, __functionAddress);
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBTransformFeedback3.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBTransformFeedback3.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryIndexedi(int target, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBTransformFeedback3.nglGetQueryIndexediv(target, index, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

