/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBTimerQuery {
    public static final int GL_TIME_ELAPSED = 35007;
    public static final int GL_TIMESTAMP = 36392;
    public final long QueryCounter;
    public final long GetQueryObjecti64v;
    public final long GetQueryObjectui64v;

    public ARBTimerQuery(FunctionProvider provider) {
        this.QueryCounter = provider.getFunctionAddress("glQueryCounter");
        this.GetQueryObjecti64v = provider.getFunctionAddress("glGetQueryObjecti64v");
        this.GetQueryObjectui64v = provider.getFunctionAddress("glGetQueryObjectui64v");
    }

    public static ARBTimerQuery getInstance() {
        return GL.getCapabilities().__ARBTimerQuery;
    }

    static ARBTimerQuery create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_timer_query")) {
            return null;
        }
        ARBTimerQuery funcs = new ARBTimerQuery(provider);
        boolean supported = Checks.checkFunctions(funcs.QueryCounter, funcs.GetQueryObjecti64v, funcs.GetQueryObjectui64v);
        return GL.checkExtension("GL_ARB_timer_query", funcs, supported);
    }

    public static void glQueryCounter(int id, int target) {
        long __functionAddress = ARBTimerQuery.getInstance().QueryCounter;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglQueryCounter(id, target, __functionAddress);
    }

    public static void nglGetQueryObjecti64v(int id, int pname, long params) {
        long __functionAddress = ARBTimerQuery.getInstance().GetQueryObjecti64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGetQueryObjecti64v(id, pname, params, __functionAddress);
    }

    public static void glGetQueryObjecti64v(int id, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        ARBTimerQuery.nglGetQueryObjecti64v(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjecti64v(int id, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBTimerQuery.nglGetQueryObjecti64v(id, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetQueryObjecti64(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        ARBTimerQuery.nglGetQueryObjecti64v(id, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGetQueryObjectui64v(int id, int pname, long params) {
        long __functionAddress = ARBTimerQuery.getInstance().GetQueryObjectui64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGetQueryObjectui64v(id, pname, params, __functionAddress);
    }

    public static void glGetQueryObjectui64v(int id, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        ARBTimerQuery.nglGetQueryObjectui64v(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectui64v(int id, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBTimerQuery.nglGetQueryObjectui64v(id, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetQueryObjectui64(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        ARBTimerQuery.nglGetQueryObjectui64v(id, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }
}

