/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL44;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBMultiBind {
    public final long BindBuffersBase;
    public final long BindBuffersRange;
    public final long BindTextures;
    public final long BindSamplers;
    public final long BindImageTextures;
    public final long BindVertexBuffers;

    public ARBMultiBind(FunctionProvider provider) {
        this.BindBuffersBase = provider.getFunctionAddress("glBindBuffersBase");
        this.BindBuffersRange = provider.getFunctionAddress("glBindBuffersRange");
        this.BindTextures = provider.getFunctionAddress("glBindTextures");
        this.BindSamplers = provider.getFunctionAddress("glBindSamplers");
        this.BindImageTextures = provider.getFunctionAddress("glBindImageTextures");
        this.BindVertexBuffers = provider.getFunctionAddress("glBindVertexBuffers");
    }

    public static ARBMultiBind getInstance() {
        return GL.getCapabilities().__ARBMultiBind;
    }

    static ARBMultiBind create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_multi_bind")) {
            return null;
        }
        ARBMultiBind funcs = new ARBMultiBind(provider);
        boolean supported = Checks.checkFunctions(funcs.BindBuffersBase, funcs.BindBuffersRange, funcs.BindTextures, funcs.BindSamplers, funcs.BindImageTextures, funcs.BindVertexBuffers);
        return GL.checkExtension("GL_ARB_multi_bind", funcs, supported);
    }

    public static void nglBindBuffersBase(int target, int first, int count, long buffers) {
        long __functionAddress = ARBMultiBind.getInstance().BindBuffersBase;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglBindBuffersBase(target, first, count, buffers, __functionAddress);
    }

    public static void glBindBuffersBase(int target, int first, int count, ByteBuffer buffers) {
        if (LWJGLUtil.CHECKS && buffers != null) {
            Checks.checkBuffer((Buffer)buffers, count << 2);
        }
        ARBMultiBind.nglBindBuffersBase(target, first, count, MemoryUtil.memAddressSafe(buffers));
    }

    public static void glBindBuffersBase(int target, int first, IntBuffer buffers) {
        ARBMultiBind.nglBindBuffersBase(target, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers));
    }

    public static void nglBindBuffersRange(int target, int first, int count, long buffers, long offsets, long sizes) {
        long __functionAddress = ARBMultiBind.getInstance().BindBuffersRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglBindBuffersRange(target, first, count, buffers, offsets, sizes, __functionAddress);
    }

    public static void glBindBuffersRange(int target, int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer sizes) {
        if (LWJGLUtil.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (sizes != null) {
                Checks.checkBuffer((Buffer)sizes, count << Pointer.POINTER_SHIFT);
            }
        }
        ARBMultiBind.nglBindBuffersRange(target, first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void glBindBuffersRange(int target, int first, IntBuffer buffers, PointerBuffer offsets, PointerBuffer sizes) {
        if (LWJGLUtil.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (sizes != null) {
                Checks.checkBuffer(sizes, buffers.remaining());
            }
        }
        ARBMultiBind.nglBindBuffersRange(target, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void nglBindTextures(int first, int count, long textures) {
        long __functionAddress = ARBMultiBind.getInstance().BindTextures;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglBindTextures(first, count, textures, __functionAddress);
    }

    public static void glBindTextures(int first, int count, ByteBuffer textures) {
        if (LWJGLUtil.CHECKS && textures != null) {
            Checks.checkBuffer((Buffer)textures, count << 2);
        }
        ARBMultiBind.nglBindTextures(first, count, MemoryUtil.memAddressSafe(textures));
    }

    public static void glBindTextures(int first, IntBuffer textures) {
        ARBMultiBind.nglBindTextures(first, textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindSamplers(int first, int count, long samplers) {
        long __functionAddress = ARBMultiBind.getInstance().BindSamplers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglBindSamplers(first, count, samplers, __functionAddress);
    }

    public static void glBindSamplers(int first, int count, ByteBuffer samplers) {
        if (LWJGLUtil.CHECKS && samplers != null) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        ARBMultiBind.nglBindSamplers(first, count, MemoryUtil.memAddressSafe(samplers));
    }

    public static void glBindSamplers(int first, IntBuffer samplers) {
        ARBMultiBind.nglBindSamplers(first, samplers == null ? 0 : samplers.remaining(), MemoryUtil.memAddressSafe(samplers));
    }

    public static void nglBindImageTextures(int first, int count, long textures) {
        long __functionAddress = ARBMultiBind.getInstance().BindImageTextures;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglBindImageTextures(first, count, textures, __functionAddress);
    }

    public static void glBindImageTextures(int first, int count, ByteBuffer textures) {
        if (LWJGLUtil.CHECKS && textures != null) {
            Checks.checkBuffer((Buffer)textures, count << 2);
        }
        ARBMultiBind.nglBindImageTextures(first, count, MemoryUtil.memAddressSafe(textures));
    }

    public static void glBindImageTextures(int first, IntBuffer textures) {
        ARBMultiBind.nglBindImageTextures(first, textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindVertexBuffers(int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = ARBMultiBind.getInstance().BindVertexBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglBindVertexBuffers(first, count, buffers, offsets, strides, __functionAddress);
    }

    public static void glBindVertexBuffers(int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer strides) {
        if (LWJGLUtil.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, count << 2);
            }
        }
        ARBMultiBind.nglBindVertexBuffers(first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glBindVertexBuffers(int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (LWJGLUtil.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, buffers.remaining());
            }
        }
        ARBMultiBind.nglBindVertexBuffers(first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }
}

