/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBInvalidateSubdata {
    public final long InvalidateTexSubImage;
    public final long InvalidateTexImage;
    public final long InvalidateBufferSubData;
    public final long InvalidateBufferData;
    public final long InvalidateFramebuffer;
    public final long InvalidateSubFramebuffer;

    public ARBInvalidateSubdata(FunctionProvider provider) {
        this.InvalidateTexSubImage = provider.getFunctionAddress("glInvalidateTexSubImage");
        this.InvalidateTexImage = provider.getFunctionAddress("glInvalidateTexImage");
        this.InvalidateBufferSubData = provider.getFunctionAddress("glInvalidateBufferSubData");
        this.InvalidateBufferData = provider.getFunctionAddress("glInvalidateBufferData");
        this.InvalidateFramebuffer = provider.getFunctionAddress("glInvalidateFramebuffer");
        this.InvalidateSubFramebuffer = provider.getFunctionAddress("glInvalidateSubFramebuffer");
    }

    public static ARBInvalidateSubdata getInstance() {
        return GL.getCapabilities().__ARBInvalidateSubdata;
    }

    static ARBInvalidateSubdata create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_invalidate_subdata")) {
            return null;
        }
        ARBInvalidateSubdata funcs = new ARBInvalidateSubdata(provider);
        boolean supported = Checks.checkFunctions(funcs.InvalidateTexSubImage, funcs.InvalidateTexImage, funcs.InvalidateBufferSubData, funcs.InvalidateBufferData, funcs.InvalidateFramebuffer, funcs.InvalidateSubFramebuffer);
        return GL.checkExtension("GL_ARB_invalidate_subdata", funcs, supported);
    }

    public static void glInvalidateTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateTexSubImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglInvalidateTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, __functionAddress);
    }

    public static void glInvalidateTexImage(int texture, int level) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateTexImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglInvalidateTexImage(texture, level, __functionAddress);
    }

    public static void glInvalidateBufferSubData(int buffer, long offset, long length) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglInvalidateBufferSubData(buffer, offset, length, __functionAddress);
    }

    public static void glInvalidateBufferData(int buffer) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateBufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglInvalidateBufferData(buffer, __functionAddress);
    }

    public static void nglInvalidateFramebuffer(int target, int numAttachments, long attachments) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglInvalidateFramebuffer(target, numAttachments, attachments, __functionAddress);
    }

    public static void glInvalidateFramebuffer(int target, int numAttachments, ByteBuffer attachments) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        ARBInvalidateSubdata.nglInvalidateFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        ARBInvalidateSubdata.nglInvalidateFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        ARBInvalidateSubdata.nglInvalidateFramebuffer(target, 1, __buffer.address(attachments));
    }

    public static void nglInvalidateSubFramebuffer(int target, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateSubFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height, __functionAddress);
    }

    public static void glInvalidateSubFramebuffer(int target, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        ARBInvalidateSubdata.nglInvalidateSubFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, IntBuffer attachments, int x, int y, int width, int height) {
        ARBInvalidateSubdata.nglInvalidateSubFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        ARBInvalidateSubdata.nglInvalidateSubFramebuffer(target, 1, __buffer.address(attachments), x, y, width, height);
    }
}

